/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNFFacadeControllerBean;
import com.kingdee.eas.ma.view.BgRollMethodEnum;
import com.kingdee.eas.ma.view.BgViewDimensionCollection;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFFacadeControllerBean
extends AbstractBgNFFacadeControllerBean {
    private static final long serialVersionUID = 2057413839052616209L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNFFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getBgViewDimensionInfo(Context ctx, String bgSchemeId, String orgId, boolean hasData, boolean isRoll) throws BOSException, EASBizException {
        BgViewDimensionCollection bgViewDimensionCol = new BgViewDimensionCollection();
        if (bgSchemeId == null) {
            return bgViewDimensionCol;
        }
        BgViewDimensionInfo bgViewDimensionInfo = null;
        BgTemplateInfo bgTemplateInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        if (hasData) {
            sql.append("SELECT FData , ");
        } else {
            sql.append("SELECT ");
        }
        sql.append("FTemplateID, FRollMethod, FRollType, FRollStep, FRollLength, FOverFlow, FFixedLength FROM T_BG_BgViewDimension d WHERE d.FTemplateID in (SELECT FBgTemplateId FROM T_BG_BgSchemeNode where FBgSchemeId = ?) ");
        if (isRoll) {
            sql.append(" AND FRollMethod IN(2,1)");
        }
        if (BgSHelper.isBgPermissionUsed((Context)ctx)) {
            HashSet<String> org = new HashSet<String>();
            org.add(orgId);
            String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Set schPer = BgPermissionFactory.getLocalInstance((Context)ctx).getBgTemplatePermissionWithBgScheme(user, org, bgSchemeId.toString());
            if (schPer != null && !schPer.isEmpty()) {
                sql.append(" AND (d.FTemplateID in " + BgHelper.tranSet2String((Set)schPer) + ")");
            } else {
                sql.append(" AND  d.FTemplateID = '0000000000000000000'");
            }
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgViewDimensionInfo = new BgViewDimensionInfo();
                if (hasData) {
                    bgViewDimensionInfo.setData(rst.getBytes("FData"));
                }
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FTemplateID")));
                bgViewDimensionInfo.setTemplate(bgTemplateInfo);
                bgViewDimensionInfo.setRollMethod(BgRollMethodEnum.getEnum((int)rst.getInt("FRollMethod")));
                bgViewDimensionInfo.setRollType(BgPeriodEnum.getEnum((int)rst.getInt("FRollType")));
                bgViewDimensionInfo.setRollStep(rst.getInt("FRollStep"));
                bgViewDimensionInfo.setRollLength(rst.getInt("FRollLength"));
                bgViewDimensionInfo.setOverFlow(rst.getInt("FOverFlow"));
                bgViewDimensionInfo.setFixedLength(rst.getInt("FFixedLength"));
                bgViewDimensionCol.add(bgViewDimensionInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgViewDimensionCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getBgTemplateInfo(Context ctx, BOSUuid bgSchemeId, String orgId) throws BOSException, EASBizException {
        BgTemplateCollection bgTemplateCol = new BgTemplateCollection();
        if (bgSchemeId == null) {
            return bgTemplateCol;
        }
        BgTemplateInfo bgTemplateInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName, FNumber, FRootID, FFormType from T_BG_BgTemplate t where t.FID in (select FBgTemplateId from T_BG_BgSchemeNode where FBgSchemeId = ?) and t.FTemplateStatus = 0 and (FBgTypeID is null or FBgTypeID <> 'BV/FQwEUEADgABtLwKgSXv9s2OA=') ");
        if (BgSHelper.isBgPermissionUsed((Context)ctx)) {
            HashSet<String> org = new HashSet<String>();
            org.add(orgId);
            String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Set schPer = BgPermissionFactory.getLocalInstance((Context)ctx).getBgTemplatePermissionWithBgScheme(user, org, bgSchemeId.toString());
            if (schPer != null && !schPer.isEmpty()) {
                sql.append(" and (t.fid in " + BgHelper.tranSet2String((Set)schPer) + ")");
            } else {
                sql.append(" and  t.fid = '0000000000000000000'");
            }
        }
        sql.append(" order by FNumber ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString("FRootID")));
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }

    @Override
    protected IObjectValue _getBgTemplateInfo(Context ctx, BOSUuid bgTemplateId, boolean hasLoadData) throws BOSException, EASBizException {
        if (bgTemplateId == null) {
            return null;
        }
        Connection conn = null;
        BgTemplateInfo _bgTemplateInfo = null;
        try {
            conn = this.getConnection(ctx);
            _bgTemplateInfo = BgInfoHelper.getBgTemplateInfo(conn, bgTemplateId, hasLoadData);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return _bgTemplateInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkNumberRepeat(Context ctx, String number, BOSUuid orgUnitId, BOSUuid bgFormId) throws BOSException, EASBizException {
        boolean result = true;
        if (StringUtils.isEmpty((String)number)) return result;
        if (orgUnitId == null) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FNumber = ? and FOrgUnitId = ? and FID <> ?");
            pstmt.setString(1, number);
            pstmt.setString(2, orgUnitId.toString());
            pstmt.setString(3, bgFormId.toString());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkBgFormInfoRepeat(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId) throws BOSException, EASBizException {
        boolean result = true;
        if (orgUnitId == null) return result;
        if (bgSchemeId == null) return result;
        if (bgTemplateId == null) return result;
        if (bgPeriodId == null) return result;
        if (currencyId == null) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FOrgUnitId = ? and FBgSchemeId = ? and FBgTemplateId = ? and FBgPeriodId = ? and FCurrencyId = ?");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            pstmt.setString(3, bgTemplateId.toString());
            pstmt.setString(4, bgPeriodId.toString());
            pstmt.setString(5, currencyId.toString());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected IObjectCollection _getSelfDefineBgTemplateInfo(Context ctx, String bgSchemeID) throws BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getBgTemplateInfo(Context ctx, BOSUuid bgSchemeId, String orgId, boolean isSelf) throws BOSException, EASBizException {
        BgTemplateCollection bgTemplateCol = new BgTemplateCollection();
        if (bgSchemeId == null) {
            return bgTemplateCol;
        }
        BgTemplateInfo bgTemplateInfo = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName, FNumber, FRootID, FFormType from T_BG_BgTemplate t where t.FID in (select FBgTemplateId from T_BG_BgSchemeNode where FBgSchemeId = ?) and t.FTemplateStatus = 0 and FBgTypeID = 'BV/FQwEUEADgABtLwKgSXv9s2OA=' ");
        if (BgSHelper.isBgPermissionUsed((Context)ctx)) {
            HashSet<String> org = new HashSet<String>();
            org.add(orgId);
            String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Set schPer = BgPermissionFactory.getLocalInstance((Context)ctx).getBgTemplatePermissionWithBgScheme(user, org, bgSchemeId.toString());
            if (schPer != null && !schPer.isEmpty()) {
                sql.append(" and (t.fid in (" + BgNSQLHelper.getParamSizeString(schPer) + ")");
                sql.append(" or t.fcreatorid = ?)");
                _tmpList.addAll(schPer);
                _tmpList.add(user);
            } else {
                sql.append(" and  t.fcreatorid = ?");
                _tmpList.add(user);
            }
        }
        sql.append(" order by FNumber ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList, 2);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString("FRootID")));
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }

    private String getQueryStr(String[] strs) {
        if (strs == null || strs.length == 0) {
            return null;
        }
        StringBuffer querStr = new StringBuffer("(");
        int length = strs.length;
        for (int i = 0; i < length; ++i) {
            querStr.append("'" + strs[i] + "',");
        }
        querStr.delete(querStr.length() - 1, querStr.length());
        querStr.append(")");
        return querStr.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _checkBatchAddNewBgFormRepeat(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String orgUnitId = (String)paramMap.get("orgUnitId");
        String bgSchemeId = (String)paramMap.get("bgSchemeId");
        String currencyId = (String)paramMap.get("currencyId");
        String[] bgPeriodIds = (String[])paramMap.get("bgPeriodIds");
        String[] bgTemplateIds = (String[])paramMap.get("bgTemplateIds");
        if (orgUnitId == null) return null;
        if (bgSchemeId == null) return null;
        if (currencyId == null) return null;
        if (bgPeriodIds == null) return null;
        if (bgTemplateIds == null) return null;
        if (bgPeriodIds.length == 0) return null;
        if (bgTemplateIds.length == 0) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBgTemplateId,FBgPeriodId from T_BG_BgForm where FOrgUnitId = ? and FBgSchemeId = ? and FBgTemplateId in " + this.getQueryStr(bgTemplateIds) + " and FBgPeriodId in  " + this.getQueryStr(bgPeriodIds) + "and FCurrencyId = ?");
            pstmt.setString(1, orgUnitId);
            pstmt.setString(2, bgSchemeId);
            pstmt.setString(3, currencyId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                checkMap.put(rst.getString(1) + "#" + rst.getString(2), null);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return checkMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBgParam(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (ctx == null) {
            return paramMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _key = null;
        String _value = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FKey, FValue from T_BG_BgParam");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _key = rst.getString("FKey");
                _value = rst.getString("FValue");
                paramMap.put(_key, _value);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return paramMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _checkBatchAddNewBgFormRepeats(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String[] orgUnitIds = (String[])paramMap.get("orgUnitId");
        String bgSchemeId = (String)paramMap.get("bgSchemeId");
        String currencyId = (String)paramMap.get("currencyId");
        String[] bgPeriodIds = (String[])paramMap.get("bgPeriodIds");
        String[] bgTemplateIds = (String[])paramMap.get("bgTemplateIds");
        if (orgUnitIds == null) return null;
        if (orgUnitIds.length == 0) return null;
        if (bgSchemeId == null) return null;
        if (currencyId == null) return null;
        if (bgPeriodIds == null) return null;
        if (bgTemplateIds == null) return null;
        if (bgPeriodIds.length == 0) return null;
        if (bgTemplateIds.length == 0) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FOrgUnitID,FBgTemplateId,FBgPeriodId from T_BG_BgForm where FOrgUnitId in  " + this.getQueryStr(orgUnitIds) + "and FBgSchemeId = ? and FBgTemplateId in " + this.getQueryStr(bgTemplateIds) + " and FBgPeriodId in  " + this.getQueryStr(bgPeriodIds) + "and FCurrencyId = ?");
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, currencyId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                checkMap.put(rst.getString(1) + "#" + rst.getString(2) + "#" + rst.getString(3), null);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return checkMap;
    }

    @Override
    protected BOSUuid _firstCostCenterAndCU(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id != null) {
            ObjectStringPK iopk = new ObjectStringPK(id.toString());
            ICostCenterOrgUnit ic = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            CostCenterOrgUnitInfo iccoinfo = ic.getCostCenterOrgUnitInfo((IObjectPK)iopk);
            if (iccoinfo.isIsCU()) {
                return iccoinfo.getId();
            }
            if (iccoinfo.getParent() != null) {
                return this._firstCostCenterAndCU(ctx, iccoinfo.getParent().getId());
            }
        }
        return null;
    }

    @Override
    protected Map _batchAddWithMoreOrgs(Context ctx, BgFormInfo inBgFormInfo, OrgUnitInfo[] orgUnitInfos, BgTemplateCollection bgTemplateCol, BgPeriodInfo[] bgPeriods) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String bookPermisson = "";
        OrgUnitInfo _orgUnitInfo = null;
        FullOrgUnitInfo _fullOrgUnitInfo = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgPeriodInfo _bgPeriodInfo2 = null;
        BgFormInfo _bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer templateMsg = new StringBuffer();
        StringBuffer exMsg = new StringBuffer();
        StringBuffer perMsg = new StringBuffer();
        StringBuffer strs = new StringBuffer();
        int sucess = 0;
        int faild = 0;
        if (orgUnitInfos != null && orgUnitInfos.length > 0) {
            for (int h = 0; h < orgUnitInfos.length; ++h) {
                _orgUnitInfo = orgUnitInfos[h];
                _fullOrgUnitInfo = _orgUnitInfo.castToFullOrgUnitInfo();
                String schemaId = this.getIDWithSchemaNumberAndOrgID(ctx, inBgFormInfo.getBgScheme().getNumber(), _fullOrgUnitInfo.getId().toString());
                BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)schemaId));
                bgSchemeInfo.setNumber(inBgFormInfo.getBgScheme().getNumber());
                if (bgTemplateCol == null || bgTemplateCol.isEmpty()) continue;
                for (int i = 0; i < bgTemplateCol.size(); ++i) {
                    _bgTemplateInfo = bgTemplateCol.get(i);
                    for (BgPeriodInfo _bgPeriodInfo2 : bgPeriods) {
                        BgTemplateInfo bgTemplateInfo;
                        inBgFormInfo.setOrgUnit(_fullOrgUnitInfo);
                        _bgFormInfo = (BgFormInfo)this.createNewData(ctx, inBgFormInfo);
                        _bgFormInfo.setOrgUnit(_fullOrgUnitInfo);
                        _bgFormInfo.setBgScheme(bgSchemeInfo);
                        _bgFormInfo.setCU(_fullOrgUnitInfo.getCU());
                        if (this.hasTemplate(ctx, inBgFormInfo.getBgScheme(), (OrgUnitInfo)_fullOrgUnitInfo, _bgTemplateInfo)) {
                            String templateId = this.getTemplateIDWithTemplateNumberDAndOrgID(ctx, _bgTemplateInfo.getNumber(), _fullOrgUnitInfo.getId().toString(), _bgTemplateInfo.getRootId().toString());
                            bgTemplateInfo = new BgTemplateInfo();
                            bgTemplateInfo.setId(BOSUuid.read((String)templateId));
                            bgTemplateInfo.setName(_bgTemplateInfo.getName());
                            if (this.verifyBookPermission(ctx, bgTemplateInfo)) {
                                ++faild;
                                bookPermisson = bookPermisson + _fullOrgUnitInfo.getName() + ":" + _bgTemplateInfo.getNumber() + "\r\n";
                                continue;
                            }
                        } else {
                            ++faild;
                            templateMsg.append(this.getResourceString("bgBatchOrg") + _fullOrgUnitInfo.getName() + "," + this.getResourceString("bgBatchScheme") + inBgFormInfo.getBgScheme().getName() + "," + this.getResourceString("bgBatchCurrency") + inBgFormInfo.getCurrency().getName() + "," + this.getResourceString("bgBtchTemplate") + _bgTemplateInfo.getName() + "," + this.getResourceString("bgBatchPeriod") + _bgPeriodInfo2.getName() + "");
                            templateMsg.append("\r\n");
                            continue;
                        }
                        _bgFormInfo.setBgTemplate(bgTemplateInfo);
                        _bgFormInfo.setCurrency(inBgFormInfo.getCurrency());
                        _bgFormInfo.setBgType(inBgFormInfo.getBgType());
                        _bgFormInfo.setBgPeriod(_bgPeriodInfo2);
                        _bgFormInfo.setCreator(inBgFormInfo.getCreator());
                        _bgFormInfo.setName(this.getBgFormName(ctx, _bgFormInfo));
                        if (this.chekBgFormRepeat(ctx, _bgFormInfo)) {
                            ++faild;
                            errorMsg.append(this.getResourceString("bgBatchOrg") + _fullOrgUnitInfo.getName() + "," + this.getResourceString("bgBatchScheme") + inBgFormInfo.getBgScheme().getName() + "," + this.getResourceString("bgBatchCurrency") + inBgFormInfo.getCurrency().getName() + "," + this.getResourceString("bgBtchTemplate") + _bgTemplateInfo.getName() + "," + this.getResourceString("bgBatchPeriod") + _bgPeriodInfo2.getName());
                            errorMsg.append("\r\n");
                            continue;
                        }
                        _bgFormInfo.setMeasureUnit(_bgTemplateInfo.getDefaultMeasureUnit());
                        try {
                            iBgForm.submit(_bgFormInfo.getId(), (IObjectValue)_bgFormInfo, true);
                            ++sucess;
                        }
                        catch (Exception ex) {
                            ++faild;
                            if (ex instanceof BgFormException) {
                                BgFormException e = (BgFormException)((Object)ex);
                                exMsg.append(e.getMessage() + "\r\n");
                                continue;
                            }
                            exMsg.append("\r\n" + this.getResourceString("bgBatchOrg") + _fullOrgUnitInfo.getName() + "," + this.getResourceString("bgBatchScheme") + inBgFormInfo.getBgScheme().getName() + "," + this.getResourceString("bgBatchCurrency") + inBgFormInfo.getCurrency().getName() + "," + this.getResourceString("bgBtchTemplate") + _bgTemplateInfo.getName() + "," + this.getResourceString("bgBatchPeriod") + _bgPeriodInfo2.getName() + this.getResourceString("addBathNewException") + this.getResourceString("batchAddError") + "\r\n" + this.getResourceString("batchAddError1") + "\r\n" + this.getResourceString("batchAddError2") + "\r\n" + this.getResourceString("batchAddError4") + "\r\n" + this.getResourceString("batchAddError3"));
                        }
                    }
                }
            }
        }
        if (!bookPermisson.equals("")) {
            perMsg.append(this.getResourceString("addBathTemplateNoPermmision") + "\r\n" + bookPermisson.substring(0, bookPermisson.length() - 2));
        }
        if (errorMsg != null && !errorMsg.toString().equals("") || exMsg != null && !exMsg.toString().equals("") || perMsg != null && !perMsg.toString().equals("") || templateMsg != null && !templateMsg.toString().equals("")) {
            if (sucess > 0) {
                strs.append(this.getResourceString("addBathFaildNumbers1") + " " + sucess + " " + this.getResourceString("addBathSucessNumbers2") + "\r\n");
            }
            if (faild > 0) {
                strs.append(this.getResourceString("addBathFaildNumbers1") + " " + faild + " " + this.getResourceString("addBathFaildNumbers2") + "\r\n");
            }
            if (errorMsg != null && !errorMsg.toString().equals("")) {
                strs.append(this.getResourceString("addBatchBgFormReport") + "\r\n" + errorMsg.toString() + "\r\n");
            }
            if (templateMsg != null && !templateMsg.toString().equals("")) {
                strs.append(this.getResourceString("noTemplate") + "\r\n" + templateMsg.toString());
            }
            if (exMsg != null && !exMsg.toString().equals("")) {
                strs.append(exMsg.toString());
            }
            if (perMsg != null && !perMsg.toString().equals("")) {
                strs.append(perMsg.toString());
            }
            map.put("partSucess", strs.toString());
        } else {
            map.put("sucess", this.getResourceString("addBathFaildNumbers1") + " " + sucess + " " + this.getResourceString("addBathSucessNumbers2"));
        }
        if (sucess == 0) {
            map.put("faild", this.getResourceString("addBathBgFormFaild"));
        }
        return map;
    }

    private boolean verifyBookPermission(Context ctx, BgTemplateInfo templateInfo) throws EASBizException, BOSException {
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed((Context)ctx);
        Map sheetPer = null;
        BgTemplateInfo info = null;
        Book _book = null;
        Sheet _sheet = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission(ctx, templateInfo.getId().toString());
            String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            info = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateInfo("select data where id = '" + templateInfo.getId().toString() + "'");
            try {
                _book = info.getBook();
            }
            catch (Exception e) {
                BgFormException bge = new BgFormException(null);
                throw bge;
            }
            boolean isShowSheet = false;
            if (_book != null) {
                int sheetIndex = 0;
                int sheetSize = _book.getSheetCount();
                for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    if (isShowSheet) break;
                    isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                }
            }
            if (isSheetPer && !isShowSheet) {
                return true;
            }
        }
        return false;
    }

    private Map addBgSheetPermission(Context ctx, String temId) {
        if (temId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(temId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(ctx, hasPer);
            if (hasPer != null && hasPer.get(temId) != null) {
                sheetPer = (Map)hasPer.get(temId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    private boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            return true;
        }
        sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
        return sheetCreater != null && sheetCreater.equals(user);
        {
        }
    }

    protected IObjectValue createNewData(Context ctx, BgFormInfo inBgFormInfo) throws EASBizException {
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
        bgFormInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgFormInfo.setStartDate(new Date());
        bgFormInfo.setEndDate(bgFormInfo.getStartDate());
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        bgFormInfo.setName(inBgFormInfo.getName());
        bgFormInfo.setOrgUnit(inBgFormInfo.getOrgUnit());
        bgFormInfo.setCU(inBgFormInfo.getOrgUnit().getCU());
        bgFormInfo.setDescription(inBgFormInfo.getDescription());
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = this.getCompanyByOrgUnit(ctx, (OrgUnitInfo)bgFormInfo.getOrgUnit());
        }
        catch (Exception ex) {
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{"warng"});
        }
        if (companyInfo != null) {
            bgFormInfo.setCompany(companyInfo);
        } else {
            bgFormInfo.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        }
        bgFormInfo.setAdjust(bgFormInfo);
        bgFormInfo.setVersionNo(BgConstants.ONE);
        bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
        return bgFormInfo;
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    public void handUIExceptionAndAbort(Exception exc) {
        SysUtil.abort();
    }

    private String getResourceString(String str) {
        return ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)str, (Locale)ContextUtils.getLocaleFromEnv());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HashSet _getCommonSchema(Context ctx, OrgUnitInfo[] orgUnitInfos) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer orgids = new StringBuffer();
        try {
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (i == orgUnitInfos.length - 1) {
                    orgids.append("?");
                } else {
                    orgids.append("?,");
                }
                _tmpList.add(orgUnitInfos[i].getId().toString());
            }
            String sql = "select FID from T_BG_BgScheme where FNumber in (select FNumber from T_BG_BgScheme where FOrgUnitID in (" + orgids.toString() + ") group by FNumber having count(FNumber)=" + orgUnitInfos.length + ") and FOrgUnitID = ?";
            _tmpList.add(orgUnitInfos[0].getId().toString());
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                set.add(rst.getString(1));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return set;
    }

    protected String getBgFormName(Context ctx, BgFormInfo bgFormInfo) {
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            ParmCodingRule pcr = new ParmCodingRule();
            pcr.setCustomProperty("name");
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)bgFormInfo, bgFormInfo.getOrgUnit().getId().toString(), "sourceType", pcr);
            if (codingRuleInfo != null) {
                String codingRule = CodingRuleFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)bgFormInfo, codingRuleInfo, false, codingRuleInfo.isIsDHSelect());
                return codingRule;
            }
        }
        catch (Exception pcr) {
            // empty catch block
        }
        String bgFormName = null;
        bgFormName = new StringBuffer(bgFormInfo.getOrgUnit().getName()).append("-").append(bgFormInfo.getBgPeriod().getName()).append("-").append(bgFormInfo.getBgTemplate().getName()).toString().trim();
        return bgFormName.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasTemplate(Context ctx, BgSchemeInfo bgs, OrgUnitInfo org, BgTemplateInfo template) throws BOSException, BgFormException {
        boolean flag = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String sql = "select FID from T_BG_BgTemplate where FRootId=? and FOrgUnitID=? and fid in (select fbgtemplateid from T_BG_BgSchemeNode where fbgschemeid = (select top 1 fid from t_bg_bgscheme where frootid = ? and FOrgUnitID=?))";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, template.getRootId().toString());
            pstmt.setString(2, org.getId().toString());
            pstmt.setString(3, bgs.getRootId().toString());
            pstmt.setString(4, org.getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                flag = true;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return flag;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getIDWithSchemaNumberAndOrgID(Context ctx, String SchemaNumber, String OrgID) throws BOSException, BgFormException {
        String schemaID = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgScheme where FNumber=? and FOrgUnitID=?");
            pstmt.setString(1, SchemaNumber);
            pstmt.setString(2, OrgID);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                schemaID = rst.getString(1);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return schemaID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTemplateIDWithTemplateNumberDAndOrgID(Context ctx, String TemplateNumber, String OrgID, String TemplateRootId) throws BOSException, BgFormException {
        String templateId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String sql = "select FID from T_BG_BgTemplate where FNumber=? and FOrgUnitID=? and FRootId=?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, TemplateNumber);
            pstmt.setString(2, OrgID);
            pstmt.setString(3, TemplateRootId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                templateId = rst.getString(1);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return templateId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean chekBgFormRepeat(Context ctx, BgFormInfo bgFormInfo) throws BOSException, BgFormException {
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FOrgUnitId = ? and FBgSchemeId = ? and FBgTemplateId = ? and FBgPeriodId = ? and FCurrencyId = ?");
            pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
            pstmt.setString(3, bgFormInfo.getBgTemplate().getId().toString());
            pstmt.setString(4, bgFormInfo.getBgPeriod().getId().toString());
            pstmt.setString(5, bgFormInfo.getCurrency().getId().toString());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean GetTemplateId(Context ctx, BgFormInfo bgFormInfo) throws BOSException, BgFormException {
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID,FNUMBER from T_BG_BgTemplate where FOrgUnitID=? and FID=?");
            pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgFormInfo.getBgTemplate().getId().toString());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean GetSchemaId(Context ctx, BgFormInfo bgFormInfo) throws BOSException, BgFormException {
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID,FNUMBER from T_BG_BgScheme where FOrgUnitID=? and FID=?");
            pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasThisTemplate(Context ctx, BgFormInfo bgFormInfo) throws BOSException, BgFormException {
        boolean flag = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String sql = "select FID from T_BG_BgTemplate where FRootId=? and FOrgUnitID=? and fid in (select fbgtemplateid from T_BG_BgSchemeNode where fbgschemeid = (select top 1 fid from t_bg_bgscheme where frootid = ? and FOrgUnitID=?))";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgFormInfo.getBgTemplate().getRootId().toString());
            pstmt.setString(2, bgFormInfo.getOrgUnit().getId().toString());
            pstmt.setString(3, bgFormInfo.getBgScheme().getRootId().toString());
            pstmt.setString(4, bgFormInfo.getOrgUnit().getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                flag = true;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return flag;
    }

    @Override
    protected Map _checkRepeat4SpecialAddNew(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String orgUnitID = (String)paramMap.get("orgUnit");
        String bgSchemeID = (String)paramMap.get("bgScheme");
        String bgTemplateID = (String)paramMap.get("bgTemplate");
        String currencyID = (String)paramMap.get("currency");
        String bgPeriodID = (String)paramMap.get("bgPeriod");
        String bgItemGroupID = (String)paramMap.get("bgItemGroup");
        List itemIDS = (List)paramMap.get("bgItem");
        if (StringUtils.isEmpty((String)orgUnitID) || StringUtils.isEmpty((String)bgSchemeID) || StringUtils.isEmpty((String)bgTemplateID) || StringUtils.isEmpty((String)currencyID) || StringUtils.isEmpty((String)bgPeriodID) || StringUtils.isEmpty((String)bgItemGroupID) || itemIDS == null || itemIDS.isEmpty()) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        try {
            int index;
            int batch_size = 200;
            int size = 0;
            int count = 0;
            int pos = 0;
            StringBuffer sql = new StringBuffer("select FBgItemID from t_bg_bgform where FOrgUnitID = ? and FBgSchemeId = ? and FBgTemplateID = ? and FCurrencyID = ? and FBgPeriodID = ? and FBgItemGroupID = ? and FBgItemID in(");
            for (index = 1; index < batch_size; ++index) {
                sql.append("?,");
            }
            sql.append("?)");
            pos = 0;
            size = itemIDS.size();
            count = (size - 1) / batch_size + 1;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, orgUnitID);
                pstmt.setString(2, bgSchemeID);
                pstmt.setString(3, bgTemplateID);
                pstmt.setString(4, currencyID);
                pstmt.setString(5, bgPeriodID);
                pstmt.setString(6, bgItemGroupID);
                int x = 7;
                while (x < batch_size + 7) {
                    if (pos < size) {
                        pstmt.setString(x, (String)itemIDS.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    checkMap.put(rst.getString(1), null);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return checkMap;
    }

    @Override
    protected Map _getAllBgFormByID(Context ctx, String bgFormID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormID)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, BgFormInfo> valueMap = new HashMap<String, BgFormInfo>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FOrgUnitID,FBgSchemeID,FBgTemplateID,FCurrencyID,FBgPeriodID,FBgItemGroupID from T_BG_BgForm where fid = ? ", (Object[])new Object[]{bgFormID});
            String orgId = null;
            String bgSchemeId = null;
            String bgTemplateId = null;
            String currencyId = null;
            String bgPeriodId = null;
            String bgItemGroupId = null;
            if (rs.next()) {
                orgId = rs.getString("FOrgUnitID");
                bgSchemeId = rs.getString("FBgSchemeID");
                bgTemplateId = rs.getString("FBgTemplateID");
                currencyId = rs.getString("FCurrencyID");
                bgPeriodId = rs.getString("FBgPeriodID");
                bgItemGroupId = rs.getString("FBgItemGroupID");
            }
            SQLUtils.cleanup((ResultSet)rs);
            String querySql = "select form.fid as FBgFormID, form.FState as FState,item.fname_" + ctx.getLocale() + " as FItemName , item.FNumber as FItemNumber ,item.fid as FItemID from T_BG_BgForm form left join T_BG_BgItem item on form.FBgItemID = item.FID  where form.FOrgUnitID = ? and form.FBgSchemeId = ? and form.FBgTemplateID = ?  and form.FCurrencyID = ? and form.FBgPeriodID = ? and form.FBgItemGroupID = ?  and form.FState not in(5,15)  order by form.FVersionNO DESC ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(querySql);
            pstmt.setString(1, orgId);
            pstmt.setString(2, bgSchemeId);
            pstmt.setString(3, bgTemplateId);
            pstmt.setString(4, currencyId);
            pstmt.setString(5, bgPeriodId);
            pstmt.setString(6, bgItemGroupId);
            rst = pstmt.executeQuery();
            BgFormInfo formInfo = null;
            BgItemInfo bgItemInfo = null;
            String bgItemId = null;
            while (rst.next()) {
                bgItemId = rst.getString("FItemID");
                formInfo = new BgFormInfo();
                formInfo.setId(BOSUuid.read((String)rst.getString("FBgFormID")));
                formInfo.setState(BgFormStateEnum.getEnum((int)Integer.parseInt(rst.getString("FState"))));
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                bgItemInfo.setName(rst.getString("FItemName"), ctx.getLocale());
                bgItemInfo.setNumber(rst.getString("FItemNumber"));
                formInfo.setBgItem(bgItemInfo);
                if (valueMap.containsKey(bgItemId)) continue;
                valueMap.put(bgItemId, formInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return valueMap;
    }
}

