/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgAuditIdeaEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordFactory;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgDataAdjsutInfo;
import com.kingdee.eas.ma.budget.BgDataSynStateBizHelper;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgPastDataCollection;
import com.kingdee.eas.ma.budget.BgPastDataInfo;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPastRecordInfo;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.budget.IBgCtrlRecord;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.nbudget.BgCourseCommentFactory;
import com.kingdee.eas.ma.nbudget.BgCourseCommentInfo;
import com.kingdee.eas.ma.nbudget.BgCourseOperateEnum;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgFormWorkFlowInfo;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNFormFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgDataHelper;
import com.kingdee.eas.ma.nbudget.app.BgParamNHelper;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFacadeFactory;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.ma.view.util.IOHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFormFacadeControllerBean
extends AbstractBgNFormFacadeControllerBean {
    private static final long serialVersionUID = 5144756522180794088L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNFormFacadeControllerBean");
    private static final String PERMISSION_STR = "bg_form01_list";

    @Override
    protected void _getBudgetSheet(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        BgFormInfo bgFormInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        if (iBgForm != null) {
            if (!iBgForm.exists((IObjectPK)pk)) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, BgNFSHelper.getSelectors());
        this._getBudgetSheet(ctx, (IObjectValue)bgFormInfo);
    }

    private String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    @Override
    protected void _getBudgetSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin save bgData!");
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        BOSUuid bgFormId = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String formulaStr = null;
        String _sheetName = null;
        String formulaStrZx = null;
        String[] formulaPara = null;
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        boolean _isSpecialForm = false;
        String _SpecialNumber = null;
        Map tmpMap = null;
        HashMap ctrlMap = null;
        Map tmplateCtrlMap = null;
        Hashtable defCtrlMode = null;
        BgDataHelper _helper = new BgDataHelper();
        try {
            bgFormId = bgFormInfo.getId();
            if (bgFormInfo.getZipData() == null || bgFormInfo.getZipData().length == 0) {
                throw new BgFormException(BgFormException.CHECKBLANK, (Object[])new String[]{"data"});
            }
            IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
            IBgCtrSettingFacade ibgCtrSettingFacade = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx);
            _isSpecialForm = bgFormInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM);
            if (_isSpecialForm) {
                _SpecialNumber = bgFormInfo.getBgItem().getNumber();
            }
            List temFormula = null;
            if (bgFormInfo.getBgTemplate() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("data");
                BgTemplateInfo tempInfo = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgTemplate().getId()), sic);
                temFormula = BgNFSHelper.getFormulaListOfBook(tempInfo.getBook());
            }
            defCtrlMode = ibgCtrSettingFacade.getDefCtrlSetByTemplateID(bgFormInfo.getBgTemplate().getId().toString());
            if (!iBgForm.exists((IObjectPK)new ObjectUuidPK(bgFormId))) {
                ctrlMap = ibgCtrSettingFacade.getBgTemplateCtrlModeMap(bgFormInfo.getBgTemplate().getId());
                BgCtrlSetHelper.fillNoCtrlRecord(temFormula, (Map)ctrlMap);
                ctrlMap = BgCtrlSetHelper.fillPeriodAndCurrency((Map)((Map)ctrlMap.get("ctrlModeMap")), (String)bgFormInfo.getBgPeriod().getNumber(), (String)bgFormInfo.getCurrency().getNumber(), (int)bgFormInfo.getBgPeriod().getPeriodType().getValue());
            } else {
                ctrlMap = ibgCtrSettingFacade.getBgFormCtrlModeMap(bgFormInfo.getId());
            }
            tmplateCtrlMap = ibgCtrSettingFacade.getTemplateCtrlSetting(bgFormInfo.getBgTemplate().getId(), null);
            BgCtrlSetHelper.fillNoCtrlRecord((List)temFormula, (Map)tmplateCtrlMap);
            tmplateCtrlMap = (Map)tmplateCtrlMap.get("ctrlModeMap");
            _book = bgFormInfo.getBook();
            BgNFSHelper.disableCal(_book);
            BgNFSHelper.disableUndo(_book);
            int _sheetSize = _book.getSheetCount();
            for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                _sheet = _book.getSheet(_sheetIndex);
                _sheetName = _sheet.getSheetName();
                if (!StringUtils.isEmpty((String)_sheetName)) {
                    _sheetName = _sheetName.length() > 80 ? _sheetName.substring(1, 80) : "";
                }
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        String _ctrlKey;
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        formulaStrZx = null;
                        tmpMap = null;
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        formulaPara = BgNFSHelper.parseFormulaPara(formulaStr);
                        BgNFSHelper.checkFormulaPara(formulaStr, formulaPara);
                        if (_isSpecialForm) {
                            formulaStrZx = _helper.parseBgFormula(formulaPara, _SpecialNumber);
                            formulaPara = BgNFSHelper.parseFormulaPara(formulaStrZx);
                        }
                        try {
                            bValue = (BigDecimal)BgNFSHelper.getValue(_cell);
                        }
                        catch (Exception ex) {
                            bValue = BgNConstants.ZERO;
                        }
                        aValue = BgNFSHelper.getActualValue(_cell);
                        if (ctrlMap == null) {
                            ctrlMap = new HashMap();
                        }
                        if (formulaStrZx == null || !_isSpecialForm) {
                            if (ctrlMap.containsKey(formulaStr)) {
                                tmpMap = (Map)ctrlMap.get(formulaStr);
                            }
                        } else if (ctrlMap.containsKey(formulaStrZx)) {
                            tmpMap = (Map)ctrlMap.get(formulaStrZx);
                        }
                        if ((tmpMap == null || tmpMap.isEmpty()) && tmplateCtrlMap.containsKey(_ctrlKey = formulaPara[0] + "_" + formulaPara[2])) {
                            tmpMap = (Map)tmplateCtrlMap.get(_ctrlKey);
                            tmpMap.put("isFromSuper", Boolean.TRUE);
                            tmpMap.put("isCtrlAllowChange", Boolean.FALSE);
                        }
                        _helper.addBgDataInfo(bgFormInfo, _cell, formulaStr, bValue, aValue, BgNConstants.ZERO, tmpMap, defCtrlMode);
                    }
                }
            }
            Object[] _objs = _helper.compareBgDataInfo(ctx, bgFormId, bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getBgScheme().getId().toString());
            _helper.checkFormulaIsEctype(ctx, bgFormInfo, _objs);
            _helper.disposeBgDataValue(ctx, bgFormInfo, _objs);
            this.updateSheetName(ctx, bgFormId.toString(), _book);
            this.saveGatherInfo(ctx, bgFormInfo, _book);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{ex.getMessage()});
        }
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end save bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    @Override
    protected void _getBudgetSheet(Context ctx, IObjectValue model, Map adjustMap) throws BOSException, EASBizException {
        this._getBudgetSheet(ctx, model);
    }

    private Map getFormulaInfoFromBook(Book book) {
        HashMap result = new HashMap();
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<Integer> rowIndexCheckList = new ArrayList<Integer>();
        ArrayList<Integer> colIndexCheckList = new ArrayList<Integer>();
        String formulaStr = "";
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int _sheetSize = book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    formulaList.add(formulaStr);
                    rowIndexCheckList.add(new Integer(rowIndex));
                    colIndexCheckList.add(new Integer(colIndex));
                }
            }
        }
        result.put("formulaList", formulaList);
        result.put("rowIndexCheckList", rowIndexCheckList);
        result.put("colIndexCheckList", colIndexCheckList);
        return result;
    }

    private String getMsg(String msg, String ... info) {
        for (int i = 0; i < info.length; ++i) {
            msg = msg.replace("{" + i + "}", info[i]);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getAdjustSheetForView(Context ctx, IObjectValue[] modelArr, Map members, Map bgDataMap, String curOrgId, byte[] data) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        HashMap result = new HashMap();
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        try {
            Map bookResult = this.getFormulaInfoFromBook(IOHelper.unpackBook((byte[])data));
            List formulaList = (List)bookResult.get("formulaList");
            List rowIndexCheckList = (List)bookResult.get("rowIndexCheckList");
            List colIndexCheckList = (List)bookResult.get("colIndexCheckList");
            for (int i = 0; i < modelArr.length; ++i) {
                HashMap<String, Serializable> orgResult = new HashMap<String, Serializable>();
                boolean isSuccess = true;
                HashMap<Object, String> resultMsg = new HashMap<Object, String>();
                orgResult.put("isSuccess", Boolean.valueOf(isSuccess));
                orgResult.put("resultMsg", resultMsg);
                IObjectValue model = modelArr[i];
                if (model == null || !(model instanceof BgFormInfo)) {
                    Map map = null;
                    return map;
                }
                BgFormInfo bgFormInfo = (BgFormInfo)model;
                String orgId = bgFormInfo.getOrgUnit().getId().toString();
                HashMap adjustMap = null;
                if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo) && bgFormInfo.getAdjustMapData() != null && bgFormInfo.getAdjustMapData().length > 0) {
                    InputStream is = null;
                    ObjectInputStream ois = null;
                    try {
                        is = ZipUtil.unpack((byte[])bgFormInfo.getAdjustMapData());
                        ois = new ObjectInputStream(is);
                        adjustMap = (HashMap)ois.readObject();
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        try {
                            ois.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    String[] formulaInfo = BgFacadeHelper.checkFormulaIsEctypeInTmp(conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getAdjust().getId(), new ArrayList(adjustMap.keySet()));
                    if (formulaInfo != null) {
                        int index = formulaList.indexOf(formulaInfo[0]);
                        int rowAlias = -1;
                        int colAlias = -1;
                        if (rowIndexCheckList.size() > index && index > -1) {
                            rowAlias = Integer.valueOf(rowIndexCheckList.get(index).toString());
                        }
                        if (colIndexCheckList.size() > index && index > -1) {
                            colAlias = Integer.valueOf(colIndexCheckList.get(index).toString());
                        }
                        resultMsg.put(bgFormInfo.getId(), this.getMsg(ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"saveFailMsg", (Locale)ctx.getLocale()), bgFormInfo.getOrgUnit().getName(), bgFormInfo.getNumber(), colAlias > -1 && rowAlias > -1 ? TableToolkit.xy2range((int)colAlias, (int)rowAlias) : "", formulaInfo[0].replaceAll(",\"BgData\",true", ""), formulaInfo[1]));
                        isSuccess = false;
                        orgResult.put("isSuccess", Boolean.valueOf(isSuccess));
                        result.put(bgFormInfo.getOrgUnit().getId().toString(), orgResult);
                        continue;
                    }
                    if (orgId.equalsIgnoreCase(curOrgId)) {
                        BgNAdjHelper.createTmpDataOfFormulaForView(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getAdjust().getId(), adjustMap, members, bgFormInfo.getId(), null);
                    } else {
                        BgNAdjHelper.createTmpDataOfFormulaForView(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getAdjust().getId(), adjustMap, null, bgFormInfo.getId(), null);
                    }
                    iBgForm.save((CoreBaseInfo)bgFormInfo);
                    BgFormInfo tempInfo = new BgFormInfo();
                    tempInfo.setId(bgFormInfo.getAdjust().getId());
                    tempInfo.setName(bgFormInfo.getName());
                    this.saveGatherInfo(ctx, tempInfo, bgFormInfo.getBook());
                    resultMsg.put(bgFormInfo.getId().toString(), this.getMsg(ResourceBase.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"saveSuccessMsg", (Locale)ctx.getLocale()), bgFormInfo.getOrgUnit().getName(), bgFormInfo.getNumber()));
                }
                result.put(bgFormInfo.getOrgUnit().getId().toString(), orgResult);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _getAdjustSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        block21: {
            if (model == null || !(model instanceof BgFormInfo)) {
                return;
            }
            Connection conn = null;
            BgFormInfo bgFormInfo = (BgFormInfo)model;
            try {
                if (!BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo) || bgFormInfo.getAdjustMapData() == null || bgFormInfo.getAdjustMapData().length <= 0) break block21;
                InputStream is = null;
                ObjectInputStream ois = null;
                Map adjustMap = null;
                try {
                    is = ZipUtil.unpack((byte[])bgFormInfo.getAdjustMapData());
                    ois = new ObjectInputStream(is);
                    adjustMap = (HashMap)ois.readObject();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                    try {
                        ois.close();
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                adjustMap = BgNAdjHelper.getTmpDataOfFormula(bgFormInfo, adjustMap);
                conn = this.getConnection(ctx);
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    this.checkAdjustFormulaIsRepeat(adjustMap, bgFormInfo, conn);
                    BgNAdjHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getAdjust().getId(), adjustMap);
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgFormInfo.getAdjust().getId().toString() + "'"));
                }
                BgFormInfo tempInfo = new BgFormInfo();
                tempInfo.setId(bgFormInfo.getAdjust().getId());
                tempInfo.setName(bgFormInfo.getName());
                this.saveGatherInfo(ctx, tempInfo, bgFormInfo.getBook());
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
            }
            finally {
                SQLUtils.cleanup(conn);
            }
        }
    }

    private void checkAdjustFormulaIsRepeat(Map adjustMap, BgFormInfo bgFormInfo, Connection conn) throws BOSException, EASBizException {
        if (adjustMap == null || adjustMap.isEmpty() || bgFormInfo == null || conn == null) {
            return;
        }
        ArrayList<String> formulaCheckList = new ArrayList<String>();
        ArrayList<Integer> rowIndexCheckList = new ArrayList<Integer>();
        ArrayList<Integer> colIndexCheckList = new ArrayList<Integer>();
        String formulaStr = "";
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        try {
            _book = bgFormInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{e.getMessage()});
        }
        int _sheetSize = _book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell) || !adjustMap.containsKey(formulaStr = BgNFSHelper.getFormulaOfCell(_cell))) continue;
                    formulaCheckList.add(formulaStr);
                    rowIndexCheckList.add(new Integer(rowIndex));
                    colIndexCheckList.add(new Integer(colIndex));
                }
            }
        }
        String[] formulaInfo = BgFacadeHelper.checkFormulaIsEctype(conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getAdjust().getId(), formulaCheckList);
        if (formulaInfo != null) {
            int index = formulaCheckList.indexOf(formulaInfo[0]);
            int rowAlias = -1;
            int colAlias = -1;
            if (rowIndexCheckList.size() > index) {
                rowAlias = Integer.valueOf(rowIndexCheckList.get(index).toString());
            }
            if (colIndexCheckList.size() > index) {
                colAlias = Integer.valueOf(colIndexCheckList.get(index).toString());
            }
            throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{TableToolkit.xy2range((int)colAlias, (int)rowAlias), formulaInfo[0].replaceAll(",\"BgData\",true", ""), formulaInfo[1]});
        }
    }

    @Override
    protected void _getActualSheet(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        BgFormInfo bgFormInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        if (iBgForm != null) {
            if (!iBgForm.exists((IObjectPK)pk)) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, BgNFSHelper.getSelectors());
        this._getActualSheet(ctx, (IObjectValue)bgFormInfo);
    }

    @Override
    protected void _getActualSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _expression = null;
        BigDecimal _value = null;
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        _bgFormInfo = (BgFormInfo)model;
        _orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
        _bgSchemeId = _bgFormInfo.getBgScheme().getId().toString();
        try {
            _book = _bgFormInfo.getBook();
            BgNFSHelper.disableUndo(_book);
            BgNFSHelper.disableCal(_book);
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                        _expression = BgNFSHelper.loadExpression(_cell, 0);
                        if (!StringUtils.isEmpty((String)_expression)) {
                            BgNFSHelper.setExpression(_cell, _expression);
                            if (!hasBgFormula) {
                                _obj = BgNFSHelper.getCellData(_cell, "BG_BUDGET_VALUE");
                                BgNFSHelper.setValue(_cell, _obj);
                            }
                        } else if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNFSHelper.clearExpression(_cell);
                            if (!hasBgFormula) {
                                BgNFSHelper.setValue(_cell, null);
                            }
                        }
                        if (!hasBgFormula) continue;
                        _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        _value = BgNFSHelper.getActualValue(_cell);
                        formulaMap.put(_formulaStr, _value);
                        _value = BgNFSHelper.getBudgetValue(_cell);
                        BgNFSHelper.setValue(_cell, _value);
                    }
                }
            }
            _bgFormInfo.setBook(_book);
            this.updateActualValue(ctx, _orgUnitId, _bgSchemeId, formulaMap);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected void _getActualSheet(Context ctx, IObjectValue model, Map adjustMap) throws BOSException, EASBizException {
        if (model == null || adjustMap == null) {
            return;
        }
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object _obj = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _expression = null;
        BigDecimal _value = null;
        _bgFormInfo = (BgFormInfo)model;
        _orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
        _bgSchemeId = _bgFormInfo.getBgScheme().getId().toString();
        try {
            _book = _bgFormInfo.getBook();
            BgNFSHelper.disableUndo(_book);
            BgNFSHelper.disableCal(_book);
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                        _expression = BgNFSHelper.loadExpression(_cell, 0);
                        if (!StringUtils.isEmpty((String)_expression)) {
                            BgNFSHelper.setExpression(_cell, _expression);
                            if (!hasBgFormula) {
                                _obj = BgNFSHelper.getCellData(_cell, "BG_BUDGET_VALUE");
                                BgNFSHelper.setValue(_cell, _obj);
                            }
                        } else if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNFSHelper.clearExpression(_cell);
                            if (!hasBgFormula) {
                                BgNFSHelper.setValue(_cell, null);
                            }
                        }
                        if (!hasBgFormula) continue;
                        _value = BgNFSHelper.getBudgetValue(_cell);
                        BgNFSHelper.setValue(_cell, _value);
                    }
                }
            }
            _bgFormInfo.setBook(_book);
            if (adjustMap.isEmpty()) {
                return;
            }
            ArrayList keyList = new ArrayList(adjustMap.keySet());
            int num = keyList.size();
            for (int i = 0; i < num; ++i) {
                Object keyObj = keyList.get(i);
                if (keyObj == null) continue;
                String key = keyObj.toString();
                BgDataAdjsutInfo info = (BgDataAdjsutInfo)adjustMap.get(key);
                BigDecimal adjustVal = info.getValue();
                if (adjustVal == null) {
                    adjustVal = BgNConstants.ZERO;
                }
                adjustMap.put(key, adjustVal);
            }
            this.updateActualValue(ctx, _orgUnitId, _bgSchemeId, adjustMap);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected boolean _getBatchActualSheet(Context ctx, String bgFormId) throws BOSException, EASBizException {
        int index;
        int size;
        if (bgFormId == null) {
            return false;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("sheetParam.*"));
        selector.add(new SelectorItemInfo("bgPeriod.*"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        selector.add(new SelectorItemInfo("bgScheme.*"));
        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, selector);
        Book book = null;
        Sheet sheet = null;
        Cell cell = null;
        Object _obj = null;
        String _formulaStr = null;
        String _valueStr = null;
        BigDecimal _value = null;
        try {
            book = bgFormInfo.getBook();
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        int size2 = book.getSheetCount();
        for (int index2 = 0; index2 < size2; ++index2) {
            sheet = book.getSheet(index2);
            int rowCount = sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    String _expression;
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        BgNFSHelper.setValue(cell, BgNFSHelper.getActualValue(cell));
                    }
                    if (!StringUtils.isEmpty((String)(_expression = BgNFSHelper.loadExpression(cell, 1)))) {
                        BgNFSHelper.setExpression(cell, _expression);
                    } else {
                        BgNFSHelper.clearExpression(cell);
                    }
                    String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, (IObjectValue)bgFormInfo);
                    BgNFSHelper.checkExpressions(cell, (IObjectValue)bgFormInfo, 1, companyNumber);
                    BgNFSHelper.checkExpressions(cell, (IObjectValue)bgFormInfo, 0, companyNumber);
                }
            }
        }
        try {
            bgFormInfo.setBook(book);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        ArrayList datas = ReportFactory.getLocalInstance((Context)ctx).backCalcEx((IObjectValue)bgFormInfo, bgFormInfo.getZipData(), null);
        HashMap<String, BigDecimal> adjustMap = new HashMap<String, BigDecimal>();
        if (datas != null) {
            size = datas.size();
            for (index = 0; index < size; ++index) {
                ArrayList list = (ArrayList)datas.get(index);
                sheet = book.getSheet(index);
                int rowCount = sheet.getMaxRowIndex();
                for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    ArrayList row = (ArrayList)list.get(rowIndex);
                    int colCount = sheet.getMaxColIndex();
                    for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasExpression(cell) || row == null) continue;
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            if (row.get(colIndex) != null) {
                                _obj = row.get(colIndex);
                                try {
                                    _value = new BigDecimal(_obj.toString());
                                }
                                catch (Exception e) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setActualValue(cell, _value);
                            } else {
                                BgNFSHelper.setActualValue(cell, BgNConstants.ZERO);
                            }
                            adjustMap.put(_formulaStr, _value);
                            continue;
                        }
                        if (row.get(colIndex) == null) continue;
                        _obj = row.get(colIndex);
                        try {
                            _value = new BigDecimal(_obj.toString());
                            _valueStr = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)_value);
                            BgNFSHelper.setCellData(cell, "BG_ACTUAL_VALUE", _valueStr);
                            continue;
                        }
                        catch (Exception e) {
                            BgNFSHelper.setCellData(cell, "BG_ACTUAL_VALUE", _obj.toString());
                        }
                    }
                }
            }
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        size = book.getSheetCount();
        for (index = 0; index < size; ++index) {
            sheet = book.getSheet(index);
            int rowCount = sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    String _expression = BgNFSHelper.loadExpression(cell, 0);
                    if (!StringUtils.isEmpty((String)_expression)) {
                        BgNFSHelper.setExpression(cell, _expression);
                    } else {
                        BgNFSHelper.clearExpression(cell);
                    }
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    BgNFSHelper.setValue(cell, BgNFSHelper.getBudgetValue(cell));
                }
            }
        }
        try {
            bgFormInfo.setBook(book);
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        this.updateActualValue(ctx, bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getBgScheme().getId().toString(), adjustMap);
        this._writeBgCtrlRecord(ctx, bgFormInfo.getId().toString());
        iBgForm.update((IObjectPK)pk, (CoreBaseInfo)bgFormInfo);
        return true;
    }

    protected void updateActualValue(Context ctx, String orgUnitId, String bgSchemeId, Map formulaMap) throws BOSException, EASBizException {
        if (ctx == null || formulaMap == null || formulaMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String _formulaStr2 = null;
        BigDecimal _value = null;
        int batchIndex = 0;
        int batchSize = 200;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Update T_BG_BgData set FBgActual=?, FBizActual=? where FOrgUnitId=? AND FBgSchemeId=? AND FFormula=?");
            for (String _formulaStr2 : formulaMap.keySet()) {
                if (_formulaStr2 == null) continue;
                _value = (BigDecimal)formulaMap.get(_formulaStr2);
                pstmt.setBigDecimal(1, _value);
                pstmt.setBigDecimal(2, BgNConstants.ZERO);
                pstmt.setString(3, orgUnitId);
                pstmt.setString(4, bgSchemeId);
                pstmt.setString(5, _formulaStr2);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkCanAudit(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgFormException(BgFormException.CHECKBLANK, (Object[])new String[]{"id"});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgFormIdStr = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgForm where FID = ? and FState in (?,?,?,?) ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormIdStr);
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 4);
            pstmt.setInt(4, 41);
            pstmt.setInt(5, 102);
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgNFormException(BgNFormException.CANTAUDITBYSTATE);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _checkCanAntiAuditForRoll(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        Set formulaSet;
        BgFormInfo bgFormInfo;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        String bgFormIdStr;
        block40: {
            if (bgFormId == null) {
                throw new BgFormException(BgFormException.CHECKBLANK, (Object[])new String[]{"id"});
            }
            bgFormIdStr = bgFormId.toString();
            conn = null;
            pstmt = null;
            rst = null;
            IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(new FilterInfo());
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIdStr, CompareType.EQUALS));
            entityViewInfo.setSelector(this.getAntiAuditForRollSic());
            BgFormCollection col = iBgForm.getBgFormCollection(entityViewInfo);
            if (col.size() == 0) {
                throw new BgFormException(BgFormException.NOBGFORMINFO, (Object[])new String[]{bgFormIdStr});
            }
            bgFormInfo = col.get(0);
            if (bgFormInfo.getState().getValue() != 2) {
                throw new BgNFormException(BgNFormException.CANTANTIAUDITBYSTATE);
            }
            IBudgetView view = BudgetViewLoaderImpl.getIntance();
            BgDimensionManagerImpl dimensionManager = new BgDimensionManagerImpl();
            try {
                view.load((IBgDimensionManager)dimensionManager, bgFormInfo.getEntries().get(0).getDimensionData());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.NODATA, (Throwable)e);
            }
            formulaSet = BgViewServerHelper.getFormulasForView((Context)ctx, (IBgDimensionManager)dimensionManager, (BgFormInfo)bgFormInfo);
            if (bgFormInfo.getEntries().get(0).getRollMethod().getValue() == 2) {
                int periodType = BgNPeriodHelper.parserBgPeriodType(bgFormInfo.getBgRollPeriod().getNumber());
                String bgPeriodNum = bgFormInfo.getBgPeriod().getNumber();
                String firstRollNum = null;
                if (4 == periodType) {
                    firstRollNum = bgPeriodNum + ".01M";
                } else if (3 == periodType) {
                    firstRollNum = bgPeriodNum + ".01Q";
                } else if (9 == periodType) {
                    firstRollNum = bgPeriodNum + ".01M.01TD";
                }
                int overFlow = bgFormInfo.getEntries().get(0).getOverFlow();
                Date lastDate = BgPeriodHelper.getEndDay((String)BgNPeriodHelper.getOffsetBgPeriodNumber(BgNPeriodHelper.getPeriodNum(bgFormInfo.getBgScheme().getDateTo(), BgPeriodEnum.getEnum((int)periodType)), overFlow));
                HashSet<String> curPeriodNumSet = new HashSet<String>();
                String curPeriodNum = bgPeriodNum.equals(bgFormInfo.getBgRollPeriod().getNumber()) ? firstRollNum : bgFormInfo.getBgRollPeriod().getNumber();
                for (int i = 0; i < bgFormInfo.getEntries().get(0).getRollLength(); ++i) {
                    curPeriodNumSet.add(curPeriodNum);
                    curPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber(curPeriodNum, 1);
                    if (lastDate.before(BgPeriodHelper.getBeginDay((String)curPeriodNum)) || !curPeriodNum.substring(0, 4 + "Y".length()).equalsIgnoreCase(bgPeriodNum)) break;
                }
                Iterator iterator = formulaSet.iterator();
                String formula = null;
                HashSet<String> newFormulaSet = new HashSet<String>();
                while (iterator.hasNext()) {
                    formula = (String)iterator.next();
                    if (!curPeriodNumSet.contains(this.getPeriodNum(formula))) continue;
                    newFormulaSet.add(formula);
                }
                formulaSet.clear();
                formulaSet.addAll(newFormulaSet);
            }
            if (!formulaSet.isEmpty()) break block40;
            SQLUtils.cleanup(rst, pstmt, conn);
            return;
        }
        try {
            int batchCount;
            int i;
            Object[] params;
            StringBuffer sql = new StringBuffer();
            sql.append("select pastdata.FID  from t_bg_bgdata data,  t_bg_bgpastdata pastdata, t_bg_bgpastrecord pastrecord  where data.fid = pastdata.FBgDataID and pastdata.FPastRecordID = pastrecord.fid and pastrecord.FBgFormID != ?  and data.FOrgUnitId = ?  and data.FBgSchemeId = ? and data.fformula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement(sql.toString());
                params = formulaSet.toArray();
                if (params.length > 0) {
                    int batchCount2 = (params.length - 1) / 200 + 1;
                    for (i = 0; i < batchCount2; ++i) {
                        pstmt.setString(1, bgFormInfo.getId().toString());
                        pstmt.setString(2, bgFormInfo.getOrgUnit().getId().toString());
                        pstmt.setString(3, bgFormInfo.getBgScheme().getId().toString());
                        BgNSQLHelper.setParam4Batch(pstmt, 4, i, 200, params);
                        rst = pstmt.executeQuery();
                        if (!rst.next()) continue;
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYADJUST);
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
            sql = new StringBuffer();
            sql.append("select FID from t_bg_bgtmpdata where FBgFormID != ? and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                params = formulaSet.toArray();
                batchCount = (params.length - 1) / 200 + 1;
                for (i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, bgFormInfo.getId().toString());
                    pstmt.setString(2, bgFormInfo.getOrgUnit().getId().toString());
                    pstmt.setString(3, bgFormInfo.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch(pstmt, 4, i, 200, params);
                    rst = pstmt.executeQuery();
                    if (!rst.next()) continue;
                    throw new BgNFormException(BgNFormException.CANTANTIAUDITBYADJUST);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql = new StringBuffer();
            sql.append("select FID from T_BG_BgActualData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                params = formulaSet.toArray();
                batchCount = (params.length - 1) / 200 + 1;
                for (i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
                    pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch(pstmt, 3, i, 200, params);
                    rst = pstmt.executeQuery();
                    if (!rst.next()) continue;
                    throw new BgNFormException(BgNFormException.CANTANTIAUDITBYACTUALDATA);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            sql = new StringBuffer();
            sql.append("select count(FID) from T_BG_BgCtrlRecord where FBillid <> ? and FBgTraceType <> ?  and FBgDataId in ").append("(select distinct FID from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
            BgNSQLHelper.addPlaceHolder(sql, 200).append("))");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                params = formulaSet.toArray();
                batchCount = (params.length - 1) / 200 + 1;
                for (i = 0; i < batchCount; ++i) {
                    int count;
                    pstmt.setString(1, bgFormIdStr);
                    pstmt.setInt(2, 1);
                    pstmt.setString(3, bgFormInfo.getOrgUnit().getId().toString());
                    pstmt.setString(4, bgFormInfo.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch(pstmt, 5, i, 200, params);
                    rst = pstmt.executeQuery();
                    if (!rst.next() || (count = rst.getInt(1)) <= 0) continue;
                    throw new BgNFormException(BgNFormException.CANTANTIAUDITBYCTRLDATA);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private String getPeriodNum(String fomulaStr) {
        String[] parameter = BgNFSHelper.parseFormulaPara(fomulaStr);
        return parameter[1];
    }

    private SelectorItemCollection getAntiAuditForRollSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("versionNo");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgRollPeriod.number");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("adjust.id");
        sic.add("data");
        sic.add("auditor.id");
        sic.add("auditTime");
        sic.add("bgRollPeriod.id");
        sic.add("entries.dimensionData");
        sic.add("entries.rollMethod");
        sic.add("entries.rollStep");
        sic.add("entries.overFlow");
        sic.add("entries.rollLength");
        sic.add("entries.fixedLength");
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkCanAntiAudit(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block63: {
            if (bgFormId == null) {
                throw new BgFormException(BgFormException.CHECKBLANK, (Object[])new String[]{"id"});
            }
            conn = null;
            pstmt = null;
            rst = null;
            String bgFormIdStr = bgFormId.toString();
            boolean isStartBasisApproved = BgNSHelper.isStartBasisApproved(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select FID from T_BG_BgForm where FID = ? and FState IN (").append(2);
            if (isStartBasisApproved) {
                sql.append(",3");
            }
            sql.append(")");
            try {
                conn = this.getConnection(ctx);
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (!rst.next()) {
                        if (!isStartBasisApproved) throw new BgNFormException(BgNFormException.CANTANTIAUDITBYSTATE);
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYBASIS);
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw ex;
                        catch (EASBizException ex2) {
                            throw ex2;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (isStartBasisApproved) {
                    BgFormInfo bgFormInfo = BgInfoHelper.getBgFormInfo(conn, bgFormId, false);
                    if (bgFormInfo != null && bgFormInfo.getCertificateUserId() != null && bgFormInfo.getState().getValue() == 14) {
                        throw new BgFormException(BgFormException.CHECKBASISANTIAUDIT);
                    }
                    if (bgFormInfo != null && bgFormInfo.isIsConfirm()) {
                        throw new BgFormException(BgFormException.CHECKBASISANTIAUDIT);
                    }
                }
                sql = new StringBuffer();
                sql.append("select FID from T_BG_BgForm where (FAdjustId = ?) and (FState in (4,15)) and (FDataSource in (5,2))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYADJUST);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                sql = new StringBuffer();
                sql.append("select FID from T_BG_BgAdjustBillEntry where FBgFormId = ?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYADJUST);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                sql = new StringBuffer();
                sql.append("select FBgFormId from T_BG_BgActualRecord where FBgFormId = ?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYACTUAL);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                sql = new StringBuffer();
                sql.append("select count(FID) from T_BG_BgCtrlRecord where FBgDataId in ").append("(select distinct FID from T_BG_BgData where FBgFormId = ?) and FBillid <> ?");
                try {
                    int count;
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    pstmt.setString(2, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next() && (count = rst.getInt(1)) > 0) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYCTRL);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                sql = new StringBuffer();
                sql.append("select count(FID) from T_BG_BgCtrlRecord where FBgDataId in ").append("(select distinct FBGDATAID from T_BG_BgDataEntry where FBgFormId = ?) and FBillid <> ?");
                try {
                    int count;
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    pstmt.setString(2, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next() && (count = rst.getInt(1)) > 0) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYCTRL);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                if (BgNSHelper.isBeforeAntiAuditCheckGatherInfo(ctx)) break block63;
                sql = new StringBuffer();
                sql.append("select FID from T_BG_BgGatherInfo where FSubBgFormId = ?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYGATHER);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (EASBizException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (BOSException ex3) {
                        throw ex3;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateSheetName(Context ctx, String bgFormId, Book book) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgFormId == null) return;
        if (book == null) {
            return;
        }
        String _Sign = "A1B2C3D4";
        String _sheetId = null;
        String _sheetName = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        Sheet _sheet = null;
        try {
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement("delete from T_BG_BgSheet where FBgFormId = ?");
                pstmt.setString(1, bgFormId);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("Insert Into T_BG_BgSheet (FID, FBgFormId, FSheetIndex, FSheetID, FSheetName) values (?, ?, ?, ?, ?)");
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = book.getSheet(i);
                _sheetId = _sheet.getID();
                _sheetName = _sheet.getSheetName();
                pstmt.setString(1, BOSUuid.create((String)_Sign).toString());
                pstmt.setString(2, bgFormId);
                pstmt.setInt(3, i);
                pstmt.setString(4, _sheetId);
                pstmt.setString(5, _sheetName);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void saveGatherInfo(Context ctx, BgFormInfo bgFormInfo, Book book) throws BOSException, EASBizException {
        if (ctx == null || bgFormInfo == null || book == null) {
            return;
        }
        boolean isQueryUpdate = false;
        String _bgTmpBgFormId = null;
        String _bgFormId = bgFormInfo.getId().toString();
        String _orgUnitId2 = null;
        String _bgSchemeId = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer gather = new StringBuffer();
        sql.append("Insert Into T_BG_BgGatherInfo(FID, FBgFormId, FBgFormName, FSubOrgUnitId, FSubBgSchemeId, FSubBgFormId) Select newbosid('12345678'), '" + _bgFormId + "', '" + bgFormInfo.getName() + "', f.FOrgUnitId, f.FBgSchemeId, f.FID From T_BG_BgForm f left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID ");
        Object obj = book.getUserObjectValue("GATHER_BGFORM");
        if (obj != null && obj instanceof Map && !((Map)obj).isEmpty()) {
            Map _bgFormIdsMap = (Map)obj;
            sql.append("where f.FID in (");
            for (String _orgUnitId2 : _bgFormIdsMap.keySet()) {
                _bgTmpBgFormId = (String)_bgFormIdsMap.get(_orgUnitId2);
                gather.append("?,");
                _tmpList.add(_bgTmpBgFormId);
            }
            gather.delete(gather.length() - 1, gather.length());
            sql.append(gather);
            sql.append(")");
            isQueryUpdate = true;
        } else {
            obj = book.getUserObjectValue("GATHER_SCHEME");
            if (obj != null && obj instanceof Map && !((Map)obj).isEmpty()) {
                Map _bgSchemeMap = (Map)obj;
                try {
                    HashSet<String> formulaSet = new HashSet<String>();
                    HashSet<String> bgFormIdSet = new HashSet<String>();
                    String sql1 = "select FFormula from T_BG_BgData where FBgFormId = '" + _bgFormId + "'";
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql1);
                    rs = pstmt.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            formulaSet.add(rs.getString("FFormula"));
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    int batchSize = 200;
                    int size = formulaSet.size();
                    int count = (size - 1) / batchSize + 1;
                    int pos = 0;
                    StringBuffer dataSql = new StringBuffer();
                    dataSql.append("select distinct t.FBgFormId from T_BG_BgData t left join T_BG_BgForm f on t.FBgFormId = F.FID where (");
                    for (String _orgUnitId2 : _bgSchemeMap.keySet()) {
                        _bgSchemeId = (String)_bgSchemeMap.get(_orgUnitId2);
                        dataSql.append("(t.FOrgUnitId = '" + _orgUnitId2 + "' and t.FBgSchemeId = '" + _bgSchemeId + "') or ");
                    }
                    dataSql.delete(dataSql.length() - 4, dataSql.length());
                    dataSql.append(")");
                    dataSql.append(" AND f.FState ").append(this.getGatherState(ctx));
                    if (!formulaSet.isEmpty()) {
                        dataSql.append(" AND t.FFormula in (");
                        for (int i = 0; i < batchSize; ++i) {
                            dataSql.append("?").append(",");
                        }
                        dataSql.delete(dataSql.length() - 1, dataSql.length());
                        dataSql.append(")");
                        pstmt = conn.prepareStatement(dataSql.toString());
                        Object[] formulaArray = formulaSet.toArray();
                        for (int i = 0; i < count; ++i) {
                            int x = 1;
                            while (x <= batchSize) {
                                if (pos < size) {
                                    pstmt.setString(x, formulaArray[pos].toString());
                                } else {
                                    pstmt.setString(x, "#");
                                }
                                ++x;
                                ++pos;
                            }
                            rs = pstmt.executeQuery();
                            if (rs != null) {
                                while (rs.next()) {
                                    bgFormIdSet.add(rs.getString("FBgFormId"));
                                }
                            }
                            SQLUtils.cleanup((ResultSet)rs);
                        }
                    }
                    sql.append("where f.FID in (");
                    if (!bgFormIdSet.isEmpty()) {
                        Iterator it = bgFormIdSet.iterator();
                        while (it.hasNext()) {
                            sql.append("'").append(it.next()).append("'").append(",");
                        }
                        sql.delete(sql.length() - 1, sql.length());
                    } else {
                        sql.append("'#'");
                    }
                    sql.append(")");
                    isQueryUpdate = true;
                }
                catch (SQLException e1) {
                    try {
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e1.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            }
        }
        if (isQueryUpdate) {
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("delete from T_BG_BgGatherInfo where FBgFormId = ?");
                pstmt.setString(1, _bgFormId);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement(sql.toString());
                BgNSQLHelper.setParams(pstmt, _tmpList);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    protected String getGatherState(Context ctx) {
        String state = null;
        String gatherState = BgNSHelper.isStateOfGather(ctx);
        state = "0".equals(gatherState) ? new StringBuffer(" IN (").append(2).append(")").toString() : ("1".equals(gatherState) ? new StringBuffer(" IN (").append(14).append(",").append(2).append(")").toString() : ("2".equals(gatherState) ? new StringBuffer(" IN (").append(3).append(")").toString() : ("3".equals(gatherState) ? new StringBuffer(" IN (").append(40).append(")").toString() : ("4".equals(gatherState) ? new StringBuffer(" IN (").append(41).append(")").toString() : ("5".equals(gatherState) ? new StringBuffer(" NOT IN (").append(15).append(",").append(5).append(",").append(4).append(")").toString() : new StringBuffer(" IN (").append(2).append(")").toString())))));
        return state;
    }

    @Override
    protected void _writeBgCtrlRecord(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String sql0 = "delete from t_bg_bgctrlrecord where fbillid = ? and fbgtracetype = 1";
        String sql1 = " select a.fname, a.fnumber, a.flastupdatetime, a.forgunitid  from t_bg_bgform a where a.fid = ? ";
        String sql2 = " select a.fid, a.fbizactual, b.fkey ,c.fnumber from t_bg_bgdata a ,t_bg_bgitemcombination b ,t_bg_bgperiod c  where a.fbgitemcombinid = b.fid and a.fbgperiodid = c.fid and a.fbizactual!=0 and a.fbgformid = ? ";
        DbUtil.execute((Context)ctx, (String)sql0, (Object[])new String[]{bgFormId});
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgFormId});
        IRowSet rs2 = null;
        String billName = "";
        String billNumber = "";
        String orgUnitId = null;
        java.sql.Date date = null;
        try {
            if (rs1.next()) {
                billName = rs1.getString(1);
                billNumber = rs1.getString(2);
                date = rs1.getDate(3);
                orgUnitId = rs1.getString("forgunitid");
            }
            IBgCtrlRecord iRecord = BgCtrlRecordFactory.getLocalInstance((Context)ctx);
            rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new String[]{bgFormId});
            BgCtrlRecordCollection coll = new BgCtrlRecordCollection();
            HashMap bgItemNameMap = new HashMap();
            while (rs2.next()) {
                String bgDataId = rs2.getString(1);
                BigDecimal bizActual = rs2.getBigDecimal(2);
                String itemKey = rs2.getString(3);
                String bgPeriodNumber = rs2.getString(4);
                bgItemNameMap.put(itemKey, null);
                BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                bgCtrlRecordInfo.setBgDataId(bgDataId);
                if (bizActual != null && bizActual.floatValue() == 0.0f) continue;
                bgCtrlRecordInfo.setActualAmount(bizActual);
                bgCtrlRecordInfo.setBillId(bgFormId);
                bgCtrlRecordInfo.setBillName(billName);
                bgCtrlRecordInfo.setBillNumber(billNumber);
                bgCtrlRecordInfo.setBillType(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"6_BgNFormFacadeControllerBean", (Locale)ctx.getLocale()));
                bgCtrlRecordInfo.setBizDate((Date)date);
                bgCtrlRecordInfo.setBgPeriodId(bgPeriodNumber);
                bgCtrlRecordInfo.setItemName(itemKey);
                bgCtrlRecordInfo.setOrgUnitId(orgUnitId);
                bgCtrlRecordInfo.setBillSourceOrgunitID(orgUnitId);
                bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.BgForm);
                if (BgNPeriodHelper.parserBgPeriodType(bgPeriodNumber) == 7) {
                    bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay((String)bgPeriodNumber));
                }
                coll.add(bgCtrlRecordInfo);
            }
            for (int i = 0; i < coll.size(); ++i) {
                String name = bgItemNameMap.get(coll.get(i).getItemName()) == null ? "" : (String)bgItemNameMap.get(coll.get(i).getItemName());
                coll.get(i).setItemName(name);
            }
            iRecord.addNewColl(coll);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs1);
                SQLUtils.cleanup(rs2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs1);
        SQLUtils.cleanup((ResultSet)rs2);
    }

    @Override
    protected List _checkBatchAudit(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        int index;
        ArrayList<String> reList = new ArrayList<String>();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        int batchSize = 200;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgForm where (FState = ").append(1).append(" or FState = ").append(4).append(" or FState = ").append(41).append(" or FState = ").append(102);
        if (BgNSHelper.isStartBasisApproved(ctx)) {
            sql.append(" or FState = ").append(3);
            if (BgNSHelper.isStepByStepReport(ctx)) {
                sql.append(" or FState = ").append(40);
            }
        }
        sql.append(") and FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    reList.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    @Override
    protected Map _batchAudit(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        return this._batchAudit(ctx, bgFormIds, null);
    }

    @Override
    protected Map _batchAudit(Context ctx, List bgFormIds, BOSUuid auditUser) throws BOSException, EASBizException {
        return this._batchAudit(ctx, bgFormIds, auditUser, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _batchAudit(Context ctx, List bgFormIds, BOSUuid auditUser, boolean isConfirm) throws BOSException, EASBizException {
        SelectorItemCollection sic;
        boolean isStepByStepReport;
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return new HashMap();
        }
        boolean bl = isStepByStepReport = BgNSHelper.isStartBasisApproved(ctx) && BgNSHelper.isStepByStepReport(ctx);
        if (isStepByStepReport) {
            List tmpList = this.findGatherFormIds(ctx, bgFormIds, 40);
            Object obj = null;
            int size = tmpList.size();
            for (int i = 0; i < size; ++i) {
                obj = tmpList.get(i);
                if (bgFormIds.contains(obj)) continue;
                bgFormIds.add(obj);
            }
        }
        int _state = 0;
        String _bgFormId = null;
        HashMap<String, Serializable> _batchAuditMap = new HashMap<String, Serializable>();
        HashMap<String, Integer> _formStateMap = new HashMap<String, Integer>();
        if (auditUser == null) {
            auditUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        int index = 0;
        int batchSize = 200;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FState from T_BG_BgForm where FID IN (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)((String)bgFormIds.get(pos))).toString());
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgFormId = rst.getString(1);
                    _state = rst.getInt(2);
                    _formStateMap.put(_bgFormId, new Integer(_state));
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
        Iterator iter = bgFormIds.iterator();
        while (iter.hasNext()) {
            _bgFormId = iter.next().toString();
            try {
                if (_formStateMap.containsKey(_bgFormId)) {
                    _state = (Integer)_formStateMap.get(_bgFormId);
                    if (_state == 1 || _state == 102 || _state == 41 || isStepByStepReport && _state == 40) {
                        this._audit(ctx, BOSUuid.read((String)_bgFormId), auditUser);
                        ibgFormFacade.submitAuditIdea(BOSUuid.read((String)_bgFormId), auditUser, BgAuditIdeaEnum.AUDITPASS, "");
                        this._writeBgCtrlRecord(ctx, _bgFormId);
                    } else if (_state == 4) {
                        boolean bSuccess = ibgFormFacade.auditFormAdjust(BOSUuid.read((String)_bgFormId));
                        IBgForm ibgform = BgFormFactory.getLocalInstance((Context)ctx);
                        if (ibgform == null) {
                            throw new BgFormException(BgFormException.NOINSTANCE);
                        }
                        if (bSuccess) {
                            ObjectUuidPK pk = new ObjectUuidPK(_bgFormId);
                            sic = new SelectorItemCollection();
                            sic.add("id");
                            sic.add("adjust.id");
                            if (ibgform.exists((IObjectPK)pk)) {
                                BgFormInfo bgAdjustInfo = ibgform.getBgFormInfo((IObjectPK)pk, sic);
                                ibgFormFacade.submitAuditIdea(bgAdjustInfo.getAdjust().getId(), auditUser, BgAuditIdeaEnum.ADJUSTPASS, "");
                            }
                        }
                    }
                    if (isConfirm) {
                        IBgForm ibgform = BgFormFactory.getLocalInstance((Context)ctx);
                        BgFormInfo formInfo = ibgform.getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormId));
                        formInfo.setIsConfirm(true);
                        SelectorItemCollection sic2 = new SelectorItemCollection();
                        sic2.add("isConfirm");
                        ibgform.updatePartial((CoreBaseInfo)formInfo, sic2);
                    }
                    _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                    continue;
                }
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
            catch (Exception ex) {
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
        }
        _formStateMap.clear();
        if (!_batchAuditMap.isEmpty()) {
            HashMap<String, String> idNumbers = new HashMap<String, String>();
            HashMap<String, String> idNnames = new HashMap<String, String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", _batchAuditMap.keySet(), CompareType.INCLUDE));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            view.setSelector(sic);
            BgFormCollection collection = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                idNumbers.put(collection.get(i).getId().toString(), collection.get(i).getNumber());
                idNnames.put(collection.get(i).getId().toString(), collection.get(i).getName());
            }
            _batchAuditMap.put("idNumbers", idNumbers);
            _batchAuditMap.put("idNnames", idNnames);
        }
        return _batchAuditMap;
    }

    @Override
    protected Map _batchBasisAudit(Context ctx, List bgFormIds, BOSUuid userId) throws BOSException, EASBizException {
        boolean isStepByStepReport;
        SelectorItemCollection sic;
        FilterInfo filter;
        EntityViewInfo view;
        BgFormCollection collection;
        IBgForm ibgForm;
        HashMap<String, Serializable> _batchAuditMap;
        ArrayList<String> basisIdList;
        ArrayList<String> batchIdList;
        String _bgFormId;
        block20: {
            if (bgFormIds == null || bgFormIds.isEmpty()) {
                return new HashMap();
            }
            _bgFormId = null;
            BOSUuid _analyseId = BOSUuid.read((String)"BV/FQwEUEADgABtLwKgSXv9s2OA=");
            HashSet bgFormIdSet = new HashSet();
            batchIdList = new ArrayList<String>();
            basisIdList = new ArrayList<String>();
            _batchAuditMap = new HashMap<String, Serializable>();
            ArrayList<String> tempList = new ArrayList<String>();
            ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
            BgFormInfo bgFormInfo = null;
            collection = null;
            if (userId == null) {
                userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
            }
            bgFormIdSet.addAll(bgFormIds);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bgFormIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            sic.add("bgType.id");
            sic.add("bgTemplate.id");
            sic.add("bgTemplate.rootId");
            sic.add("bgScheme.id");
            sic.add("bgScheme.rootId");
            view.setSelector(sic);
            isStepByStepReport = BgNSHelper.isStartBasisApproved(ctx) && BgNSHelper.isStepByStepReport(ctx);
            collection = ibgForm.getBgFormCollection(view);
            if (collection == null) break block20;
            int in = collection.size();
            for (int i = 0; i < in; ++i) {
                bgFormInfo = collection.get(i);
                _bgFormId = bgFormInfo.getId().toString();
                if (bgFormInfo.getState().equals((Object)BgFormStateEnum.Edited) || bgFormInfo.getState().equals((Object)BgFormStateEnum.EditeCompleted)) {
                    _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                    if (bgFormInfo.getBgType() != null && _analyseId.equals((Object)bgFormInfo.getBgType().getId())) {
                        batchIdList.add(_bgFormId);
                        continue;
                    }
                    if (bgFormInfo.getBgTemplate().getId().equals((Object)bgFormInfo.getBgTemplate().getRootId()) || bgFormInfo.getBgScheme().getId().equals((Object)bgFormInfo.getBgScheme().getRootId())) {
                        if (isStepByStepReport) {
                            tempList.clear();
                            tempList.add(_bgFormId);
                            List gatherCourseFormIds = this.findGatherFormIds(ctx, tempList, 40);
                            for (int x = 0; x < gatherCourseFormIds.size(); ++x) {
                                if (batchIdList.contains(gatherCourseFormIds.get(x))) continue;
                                batchIdList.add((String)gatherCourseFormIds.get(x));
                            }
                            continue;
                        }
                        batchIdList.add(_bgFormId);
                        continue;
                    }
                    basisIdList.add(_bgFormId);
                    continue;
                }
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
            collection.clear();
        }
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
        java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgForm set FState=?, FAuditorID=?, FAuditedTime=? where FID=?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Iterator iter = basisIdList.iterator();
            while (iter.hasNext()) {
                _bgFormId = iter.next().toString();
                pstmt.setInt(1, 3);
                pstmt.setString(2, userId.toString());
                pstmt.setDate(3, date);
                pstmt.setString(4, _bgFormId);
                pstmt.addBatch();
                ibgFormFacade.submitAuditIdea(BOSUuid.read((String)_bgFormId), userId, BgAuditIdeaEnum.AUDITPASS, "");
            }
            int[] sum = pstmt.executeBatch();
            if (sum != null && sum.length > 0) {
                BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, basisIdList, (boolean)true);
            }
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("update t_bas_paramitem set FIsModify = 1 where fid = 'nFM0PoeHSFWrpLUK0QkHjO0ql5o='");
            pstmt.executeUpdate();
            Map map = null;
            if (!batchIdList.isEmpty()) {
                map = isStepByStepReport ? this._batchAuditGatherCourse(ctx, batchIdList, userId, null) : this._batchAudit(ctx, batchIdList, userId);
            }
            if (map != null) {
                _batchAuditMap.putAll(map);
            }
            if (!_batchAuditMap.isEmpty()) {
                HashMap<String, String> idNumbers = new HashMap<String, String>();
                HashMap<String, String> idNnames = new HashMap<String, String>();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", _batchAuditMap.keySet(), CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("name");
                view.setSelector(sic);
                collection = ibgForm.getBgFormCollection(view);
                for (int i = 0; i < collection.size(); ++i) {
                    idNumbers.put(collection.get(i).getId().toString(), collection.get(i).getNumber());
                    idNnames.put(collection.get(i).getId().toString(), collection.get(i).getName());
                }
                _batchAuditMap.put("idNumbers", idNumbers);
                _batchAuditMap.put("idNnames", idNnames);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return _batchAuditMap;
    }

    @Override
    protected void _audit(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        this._audit(ctx, bgFormId, null);
    }

    @Override
    protected void _audit(Context ctx, BOSUuid bgFormId, BOSUuid auditUser) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        String _userId = null;
        _userId = auditUser == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditUser.toString();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer upsql = new StringBuffer();
        sql.append("update T_BG_BgForm set FData=?, FState=?, FAuditorID=?, FAuditedTime=?, FStateBeforeAudit = ? where FID=?");
        upsql.append("update T_BG_BgData set FBizActual = FBgActual where FBgFormId = ?");
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        try {
            conn = this.getConnection(ctx);
            _bgFormInfo = BgFSHelper.getBgFormInfo((Connection)conn, (BOSUuid)bgFormId, (boolean)true);
            if (_bgFormInfo != null) {
                int _state = _bgFormInfo.getState().getValue();
                if (_state != 1 && _state != 102 && _state != 41) {
                    if (BgNSHelper.isStartBasisApproved(ctx) && BgNSHelper.isStepByStepReport(ctx)) {
                        if (_state != 40 && _state != 14) {
                            throw new BgNFormException(BgNFormException.CANTAUDITBYSTATE);
                        }
                    } else {
                        throw new BgNFormException(BgNFormException.CANTAUDITBYSTATE);
                    }
                }
                if (!BgTemFormTypeEnum.VIEWFORM.equals((Object)_bgFormInfo.getBgTemplate().getFormType())) {
                    _book = _bgFormInfo.getBook();
                    BgNFSHelper.disableUndo(_book);
                    BgNFSHelper.disableCal(_book);
                    BgNFSHelper.updateAliasAudit(_book);
                    _bgFormInfo.setBook(_book);
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setBytes(1, _bgFormInfo.getZipData());
                pstmt.setInt(2, 2);
                pstmt.setString(3, _userId);
                pstmt.setTimestamp(4, timestamp);
                pstmt.setInt(5, _state);
                pstmt.setString(6, bgFormId.toString());
                int sum = -1;
                sum = pstmt.executeUpdate();
                if (sum > 0) {
                    BgDataSynStateBizHelper.updateDataStateByFormID((Context)ctx, (String)bgFormId.toString(), (boolean)true);
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement(upsql.toString());
                pstmt.setString(1, bgFormId.toString());
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement("update t_bas_paramitem set FIsModify = 1 where fid = 'nFM0PoeHSFWrpLUK0QkHjO0ql5o='");
                pstmt.executeUpdate();
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    protected List batchAntiAudit4StepByStepReport(Context ctx, List bgFormIds) throws EASBizException, BOSException {
        int i;
        Object object = ctx.get((Object)"UN_CONFIRM");
        boolean isBatchUnConfirm = false;
        if (object instanceof Boolean) {
            isBatchUnConfirm = (Boolean)object;
        }
        List reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        BgFormInfo bgFormInfo = null;
        BgFormCollection collection = null;
        ArrayList<String> gatherCourseFormIds = new ArrayList<String>();
        ArrayList<String> subOrgFormIds = new ArrayList<String>();
        HashSet idSet = new HashSet();
        idSet.addAll(bgFormIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        sic.add("bgType.id");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgScheme.id");
        sic.add("bgScheme.rootId");
        view.setSelector(sic);
        collection = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
        for (int i2 = 0; i2 < collection.size(); ++i2) {
            bgFormInfo = collection.get(i2);
            if (bgFormInfo.getBgTemplate().getId().equals((Object)bgFormInfo.getBgTemplate().getRootId()) || bgFormInfo.getBgScheme().getId().equals((Object)bgFormInfo.getBgScheme().getRootId())) {
                if (gatherCourseFormIds.contains(bgFormInfo.getId().toString())) continue;
                gatherCourseFormIds.add(bgFormInfo.getId().toString());
                continue;
            }
            if (subOrgFormIds.contains(bgFormInfo.getId().toString())) continue;
            subOrgFormIds.add(bgFormInfo.getId().toString());
        }
        List result1 = null;
        List result2 = null;
        List gatherFormIds = this.findGatherFormIds(ctx, gatherCourseFormIds, 2);
        Object obj = null;
        Object obj2 = null;
        int in = gatherFormIds.size();
        for (i = 0; i < in; ++i) {
            obj = gatherFormIds.get(i);
            if (obj == null) continue;
            for (int j = subOrgFormIds.size() - 1; j >= 0; --j) {
                obj2 = subOrgFormIds.get(j);
                if (obj2 == null || !obj.toString().equals(obj2.toString())) continue;
                subOrgFormIds.remove(j);
            }
        }
        if (!isBatchUnConfirm && !gatherCourseFormIds.isEmpty()) {
            result1 = this.batchAntiAuditGatherCourse(ctx, gatherCourseFormIds);
        }
        if (!subOrgFormIds.isEmpty()) {
            result2 = this.batchAntiAuditSubOrgForm(ctx, subOrgFormIds);
        }
        if (result1 != null && !result1.isEmpty() && result2 != null && !result2.isEmpty()) {
            for (i = 0; i < result1.size(); ++i) {
                ((List)result1.get(i)).addAll((List)result2.get(i));
            }
            reList = result1;
        } else {
            reList = result1 != null && !result1.isEmpty() ? result1 : result2;
        }
        return reList;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected List _batchAntiAuditForRoll(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 35[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void queryLatestHistoryForm(Context ctx, List<String> bgFormIdsStr, Map bgHistoryFormMap) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(new FilterInfo());
        entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("adjust.id", new HashSet<String>(bgFormIdsStr), CompareType.INCLUDE));
        entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)15, CompareType.EQUALS));
        entityViewInfo.setSelector(this.getAntiAuditForRollSic());
        IBgForm iBgForm = BgFormFactory.getLocalInstance((Context)ctx);
        BgFormCollection historyCol = iBgForm.getBgFormCollection(entityViewInfo);
        for (int i = 0; i < historyCol.size(); ++i) {
            BgFormInfo bgFormInfo = historyCol.get(i);
            String bgFormIdStr = bgFormInfo.getAdjust().getId().toString();
            if (bgHistoryFormMap.get(bgFormIdStr) == null) {
                bgHistoryFormMap.put(bgFormIdStr, bgFormInfo);
                continue;
            }
            if (bgFormInfo.getVersionNo().compareTo(((BgFormInfo)bgHistoryFormMap.get(bgFormIdStr)).getVersionNo()) <= 0) continue;
            bgHistoryFormMap.put(bgFormIdStr, bgFormInfo);
        }
    }

    private void dealExchangBgFormInfo(Context ctx, List<String> bgFormIdsStr, Map<String, BgFormInfo> bgFormMap, Map<String, BgFormInfo> bgHistoryFormMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        HashSet<String> unAuditIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        Object rs = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo bgHistoryFormInfo = null;
        String bgFormIdStr = null;
        sql.append("Update T_BG_BgForm set FData=?, FState=?, FAuditorID=?, FAuditedTime=?, FVersionNo=? , FBGROLLPERIODID = ? where FID=?");
        StringBuffer entrySql = new StringBuffer();
        entrySql.append("Update T_BG_BgFormEntry set FDimensionData = ? , FDimensionStyle = ? where FBgFormID = ?");
        Connection entryConn = null;
        PreparedStatement entryPstmt = null;
        try {
            conn = this.getConnection(ctx);
            entryConn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            entryPstmt = entryConn.prepareStatement(entrySql.toString());
            for (int i = 0; i < bgFormIdsStr.size(); ++i) {
                bgFormIdStr = bgFormIdsStr.get(i);
                bgFormInfo = bgFormMap.get(bgFormIdStr);
                unAuditIds.add(bgFormInfo.getAdjust().getId().toString());
                bgHistoryFormInfo = bgHistoryFormMap.get(bgFormInfo.getAdjust().getId().toString());
                pstmt.setBytes(1, bgFormInfo.getZipData());
                pstmt.setInt(2, 6);
                pstmt.setString(3, null);
                pstmt.setTimestamp(4, null);
                pstmt.setBigDecimal(5, bgFormInfo.getVersionNo());
                pstmt.setString(6, bgFormInfo.getBgRollPeriod().getId().toString());
                pstmt.setString(7, bgHistoryFormInfo.getId().toString());
                pstmt.addBatch();
                entryPstmt.setBytes(1, bgFormInfo.getEntries().get(0).getDimensionData());
                entryPstmt.setBytes(2, bgFormInfo.getEntries().get(0).getDimensionStyle());
                entryPstmt.setString(3, bgHistoryFormInfo.getId().toString());
                entryPstmt.addBatch();
                pstmt.setBytes(1, bgHistoryFormInfo.getZipData());
                pstmt.setInt(2, bgFormInfo.getState().getValue());
                pstmt.setString(3, bgHistoryFormInfo.getAuditor().getId().toString());
                pstmt.setTimestamp(4, bgHistoryFormInfo.getAuditTime());
                pstmt.setBigDecimal(5, bgHistoryFormInfo.getVersionNo());
                pstmt.setString(6, bgHistoryFormInfo.getBgRollPeriod().getId().toString());
                pstmt.setString(7, bgFormInfo.getId().toString());
                pstmt.addBatch();
                entryPstmt.setBytes(1, bgHistoryFormInfo.getEntries().get(0).getDimensionData());
                entryPstmt.setBytes(2, bgHistoryFormInfo.getEntries().get(0).getDimensionStyle());
                entryPstmt.setString(3, bgFormInfo.getId().toString());
                entryPstmt.addBatch();
            }
            pstmt.executeBatch();
            entryPstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt, (Connection)entryConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt, (Connection)entryConn);
        BgBillIntegrateSchemeFacadeFactory.getLocalInstance((Context)ctx).synBillState(unAuditIds, "OPERATOT_UNAPPROVED");
    }

    private void dealAdjustData(Context ctx, List<String> bgFormIdsStr, Map<String, BgFormInfo> bgFormMap, Set pastRecordIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgFormInfo bgFormInfo = null;
        String bgFormIdStr = null;
        BgPastDataInfo bgPastDataInfo = null;
        BgPastDataCollection bgPastDataCol = new BgPastDataCollection();
        HashMap addTmpMap = new HashMap();
        BgAdjustFormDiversityData diversityData = null;
        sql.append("select pastrecord.FBgFormID,pastdata.FPastValue, pastdata.FFormula, pastdata.FBalance, pastdata.FAdjValue, pastdata.FPastRecordID, pastdata.FBgDataID, pastdata.FAdjustorId, pastdata.FAdjustTime, pastdata.FAdjReason from t_bg_bgpastdata pastdata, t_bg_bgpastrecord pastrecord  where  pastdata.FPastRecordID = pastrecord.fid  and ((pastrecord.FBgFormID = ? and pastrecord.FVersionNo = ?)");
        try {
            int i;
            conn = this.getConnection(ctx);
            for (i = 1; i < bgFormIdsStr.size(); ++i) {
                sql.append(" or (pastrecord.FBgFormID = ? and pastrecord.FVersionNo = ?)");
            }
            sql.append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < bgFormIdsStr.size(); ++i) {
                bgFormIdStr = bgFormIdsStr.get(i);
                bgFormInfo = bgFormMap.get(bgFormIdStr);
                pstmt.setString(2 * i + 1, bgFormInfo.getId().toString());
                pstmt.setBigDecimal(2 * i + 2, bgFormInfo.getVersionNo());
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgPastDataInfo = new BgPastDataInfo();
                bgPastDataInfo.setBalance(rst.getBigDecimal("FBalance"));
                bgPastDataInfo.setBgData(rst.getString("FBgDataID"));
                bgPastDataCol.add(bgPastDataInfo);
                pastRecordIds.add(rst.getString("FPastRecordID"));
                bgFormIdStr = rst.getString("FBgFormID");
                if (addTmpMap.get(bgFormIdStr) == null) {
                    addTmpMap.put(bgFormIdStr, new HashMap());
                }
                diversityData = new BgAdjustFormDiversityData();
                diversityData.setAdjustor(rst.getString("FAdjustorId"));
                diversityData.setAdjustReson(rst.getString("FAdjReason"));
                diversityData.setAdjustTime((Date)rst.getTimestamp("FAdjustTime"));
                diversityData.setFormula(rst.getString("FFormula"));
                diversityData.setNewValue(rst.getBigDecimal("FBalance").add(rst.getBigDecimal("FPastValue")));
                diversityData.setOldValue(rst.getBigDecimal("FBalance"));
                ((Map)addTmpMap.get(bgFormIdStr)).put(rst.getString("FFormula"), diversityData);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            String updateBgData = "Update T_BG_BgData set FBgValue = ?  where FID = ?";
            pstmt = conn.prepareStatement(updateBgData);
            for (int i2 = 0; i2 < bgPastDataCol.size(); ++i2) {
                bgPastDataInfo = bgPastDataCol.get(i2);
                pstmt.setBigDecimal(1, bgPastDataInfo.getBalance().setScale(8, 4));
                pstmt.setString(2, bgPastDataInfo.getBgData());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            for (Object o : addTmpMap.keySet()) {
                bgFormInfo = bgFormMap.get(o);
                BgNAdjHelper.insertTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), (Map)addTmpMap.get(o));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _batchAntiAudit(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        boolean isStepByStepReport = BgNSHelper.isStartBasisApproved(ctx) && BgNSHelper.isStepByStepReport(ctx);
        Object object = ctx.get((Object)"UN_CONFIRM");
        boolean isBatchUnConfirm = false;
        if (object instanceof Boolean) {
            isBatchUnConfirm = (Boolean)object;
        }
        if (isStepByStepReport && !isBatchUnConfirm) {
            return this.batchAntiAudit4StepByStepReport(ctx, bgFormIds);
        }
        ArrayList reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        if (isStepByStepReport) {
            List tmpList = this.findGatherFormIds(ctx, bgFormIds, 2);
            Object obj = null;
            int size = tmpList.size();
            for (int i = 0; i < size; ++i) {
                obj = tmpList.get(i);
                if (bgFormIds.contains(obj)) continue;
                bgFormIds.add(obj);
            }
        }
        HashSet _bgFormIdSet = new HashSet();
        ArrayList _bgFormIds = new ArrayList();
        _bgFormIds.addAll(bgFormIds);
        _bgFormIdSet.addAll(bgFormIds);
        int batchSize = 25;
        int batchIndex = 0;
        int size = _bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IMutexServiceControl imc = null;
        boolean isBasis = BgNSHelper.isStartBasisApproved(ctx);
        int _state = 0;
        int _dataSource = 0;
        int _stateBeforeAudit = 1;
        String _bgFormId = null;
        String _bgFormName = null;
        String[] _bgFormInfo = null;
        StringBuffer para = null;
        StringBuffer sql = null;
        HashMap<String, String> stateBeforeAuditMap = new HashMap<String, String>();
        para = new StringBuffer();
        for (int i = 1; i < batchSize; ++i) {
            para.append("?,");
        }
        para.append("?");
        try {
            int x;
            int index;
            String _bgFormNumber;
            conn = this.getConnection(ctx);
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList<String[]> _checkUse = new ArrayList<String[]>();
            ArrayList<String[]> _checkState = new ArrayList<String[]>();
            reList.add(_checkUse);
            reList.add(_checkState);
            sql = new StringBuffer();
            sql.append("SELECT FID, FName, FNumber, FState, FStateBeforeAudit FROM T_BG_BgForm WHERE FID IN (" + para + ")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (int index2 = 0; index2 < count; ++index2) {
                    int x2 = 1;
                    while (x2 <= batchSize) {
                        if (pos < size) {
                            _bgFormId = _bgFormIds.get(pos).toString();
                            pstmt.setString(x2, BOSUuid.read((String)_bgFormId).toString());
                        } else {
                            pstmt.setString(x2, "#");
                        }
                        ++x2;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _bgFormId = rst.getString("FID");
                        _bgFormName = rst.getString("FName");
                        _bgFormNumber = rst.getString("FNumber");
                        _stateBeforeAudit = rst.getInt("FStateBeforeAudit");
                        stateBeforeAuditMap.put(_bgFormId, "" + _stateBeforeAudit);
                        if (imc.requestObjIDForUpdate(_bgFormId)) {
                            imc.releaseObjIDForUpdate(_bgFormId);
                            _state = rst.getInt("FState");
                            if (_state == 2 || _state == 3) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkState.add(_bgFormInfo);
                            continue;
                        }
                        _bgFormIdSet.remove(_bgFormId);
                        _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                        _checkUse.add(_bgFormInfo);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                _bgFormIds.clear();
                _bgFormIds.addAll(_bgFormIdSet);
            }
            ArrayList<String[]> _checkBasis = new ArrayList<String[]>();
            if (!_bgFormIds.isEmpty() && isBasis && !isBatchUnConfirm) {
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE (FCertificateUserId is not null or FIsConfirm = 1) and FState = 2 and FID IN (" + para + ")");
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index3 = 0; index3 < count; ++index3) {
                        int x3 = 1;
                        while (x3 <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x3, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x3, "#");
                            }
                            ++x3;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkBasis.add(_bgFormInfo);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkAdjust = new ArrayList<String[]>();
            reList.add(_checkAdjust);
            HashMap bgFormNumberMap = new HashMap();
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber, FState, FDataSource, FAdjustId FROM T_BG_BgForm WHERE FAdjustId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index4 = 0; index4 < count; ++index4) {
                        int x4 = 1;
                        while (x4 <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x4, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x4, "#");
                            }
                            ++x4;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FAdjustId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _state = rst.getInt("FState");
                            _dataSource = rst.getInt("FDataSource");
                            if (_state != 4 && _state != 15 || _dataSource != 2 && _dataSource != 5 || bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkAdjust.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkBill = new ArrayList<String[]>();
            reList.add(_checkBill);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT DISTINCT FBgFormId FROM T_BG_BgAdjustBillEntry WHERE FBgFormId IN (" + para + "))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index5 = 0; index5 < count; ++index5) {
                        int x5 = 1;
                        while (x5 <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x5, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x5, "#");
                            }
                            ++x5;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkBill.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkRecord = new ArrayList<String[]>();
            reList.add(_checkRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT t.FID, t.FBgFormId, f.FName, f.FNumber FROM T_BG_BgActualRecord t LEFT JOIN T_BG_BgForm f on t.FBgFormId = f.FID WHERE FBgFormId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index6 = 0; index6 < count; ++index6) {
                        int x6 = 1;
                        while (x6 <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x6, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x6, "#");
                            }
                            ++x6;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FBgFormId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkCtrlRecord = new ArrayList<String[]>();
            reList.add(_checkCtrlRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT d.FBgFormId FROM T_BG_BgData d INNER JOIN T_BG_BgCtrlRecord r on r.FBgDataId = d.FID WHERE d.FBgFormId IN (");
                sql.append(para);
                sql.append(") AND r.fbgtracetype <> 1 group by d.FBgFormId)");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkCtrlRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT d.FBgFormId FROM T_BG_BgDataEntry d INNER JOIN T_BG_BgCtrlRecord r on r.FBgDataId = d.FBgDataID WHERE d.FBgFormId IN (");
                sql.append(para);
                sql.append(") AND r.fbgtracetype <> 1 group by d.FBgFormId)");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkCtrlRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _useGather = new ArrayList<String[]>();
            reList.add(_useGather);
            if (!_bgFormIds.isEmpty() && !BgNSHelper.isBeforeAntiAuditCheckGatherInfo(ctx)) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm ").append("WHERE FID IN (").append("SELECT DISTINCT FSubBgFormId from T_BG_BgGatherInfo ").append("WHERE FSubBgFormId IN (").append(para).append("))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index7 = 0; index7 < count; ++index7) {
                        int x7 = 1;
                        while (x7 <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x7, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x7, "#");
                            }
                            ++x7;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _useGather.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<Object> _succeed = new ArrayList<Object>();
            reList.add(_succeed);
            HashMap bgFormIdsMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            boolean isAntiAuditToFormerState = BgNSHelper.isAntiAuditToFormerState(ctx);
            String stateBeforeAudit = null;
            if (!_bgFormIds.isEmpty()) {
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FCertificateUserId = '', FCertificateTime = null,FIsConfirm = 0, FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState<>?");
                String sql2 = "update T_BG_BgData set FBizActual = 0 where FBgFormId = ?";
                PreparedStatement pstmt2 = null;
                String sql3 = "delete from T_BG_BgCtrlRecord where FBillId = ? and FBgTraceType = 1";
                PreparedStatement pstmt3 = null;
                batchIndex = 0;
                String userId = user.getId().toString();
                Timestamp date = new Timestamp(System.currentTimeMillis());
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt2 = conn.prepareStatement(sql2);
                    pstmt3 = conn.prepareStatement(sql3);
                    int[] sum = null;
                    Iterator iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        _succeed.add(_bgFormId);
                        if (isAntiAuditToFormerState) {
                            _state = 1;
                            stateBeforeAudit = (String)stateBeforeAuditMap.get(_bgFormId);
                            if (!StringUtils.isEmpty((String)stateBeforeAudit)) {
                                _state = Integer.parseInt(stateBeforeAudit);
                            }
                            if (_state == 41) {
                                pstmt.setInt(1, 41);
                            } else {
                                pstmt.setInt(1, _state);
                            }
                            if (isBatchUnConfirm) {
                                pstmt.setInt(1, 41);
                            } else {
                                pstmt.setInt(1, _state);
                            }
                        } else {
                            pstmt.setInt(1, 1);
                        }
                        pstmt.setString(2, "");
                        pstmt.setDate(3, null);
                        pstmt.setString(4, BOSUuid.read((String)userId).toString());
                        pstmt.setTimestamp(5, date);
                        pstmt.setString(6, BOSUuid.read((String)_bgFormId).toString());
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        pstmt2.setString(1, BOSUuid.read((String)_bgFormId).toString());
                        pstmt2.addBatch();
                        pstmt3.setString(1, BOSUuid.read((String)_bgFormId).toString());
                        pstmt3.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        sum = pstmt2.executeBatch();
                        pstmt3.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                        sum = pstmt2.executeBatch();
                        pstmt3.executeBatch();
                        batchIndex = 0;
                    }
                    if (sum != null && sum.length > 0) {
                        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, _bgFormIds, (boolean)false);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)ex.getMessage());
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup((Statement)pstmt);
                        SQLUtils.cleanup(pstmt2);
                        SQLUtils.cleanup(pstmt3);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt2);
                SQLUtils.cleanup((Statement)pstmt3);
                if (!_succeed.isEmpty()) {
                    HashSet<Object> idSet = new HashSet<Object>();
                    int in = _succeed.size();
                    for (int i = 0; i < in; ++i) {
                        idSet.add((String)_succeed.get(i));
                    }
                    idSet.add(_succeed);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("number");
                    sic.add("name");
                    view.setSelector(sic);
                    BgFormCollection bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
                    _succeed.clear();
                    for (int i = 0; i < bgFormColl.size(); ++i) {
                        _bgFormInfo = new String[]{bgFormColl.get(i).getId().toString(), bgFormColl.get(i).getName(), bgFormColl.get(i).getNumber()};
                        _succeed.add(_bgFormInfo);
                    }
                }
                batchIndex = 0;
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FCertificateUserId = '', FCertificateTime = null, FIsConfirm = 0, FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState=?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    Iterator iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        pstmt.setInt(1, 4);
                        pstmt.setString(2, BOSUuid.read((String)userId).toString());
                        pstmt.setTimestamp(3, date);
                        pstmt.setString(4, BOSUuid.read((String)userId).toString());
                        pstmt.setTimestamp(5, date);
                        pstmt.setString(6, BOSUuid.read((String)_bgFormId).toString());
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            if (!bgFormIdsMap.isEmpty()) {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
                BOSUuid auditUser = user.getId();
                Iterator formIt = bgFormIdsMap.keySet().iterator();
                while (formIt.hasNext()) {
                    iBgFormFacade.submitAuditIdea(BOSUuid.read((String)((String)formIt.next())), auditUser, BgAuditIdeaEnum.UNAUDIT, "");
                }
            }
            if (isBasis && !isBatchUnConfirm) {
                reList.add(_checkBasis);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkBudgetData(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block28: {
            if (bgFormId == null) {
                return;
            }
            IBgForm ibgForm = null;
            BgFormInfo _bgFormInfo = null;
            BgDataAdjsutInfo _adjData = null;
            Book _book = null;
            Sheet _sheet = null;
            Cell _cell = null;
            byte[] _data = null;
            int batchSize = 200;
            int batchIndex = 0;
            String _formulaStr2 = null;
            BigDecimal _value = null;
            HashMap<String, BgDataAdjsutInfo> adjustMap = new HashMap<String, BgDataAdjsutInfo>();
            HashMap<String, BigDecimal> updateMap = new HashMap<String, BigDecimal>();
            HashMap removeMap = new HashMap();
            HashSet<String> formulaSet = new HashSet<String>();
            HashSet<String> _formulaSet = new HashSet<String>();
            conn = null;
            pstmt = null;
            rst = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select FFormula from T_BG_BgData where FBgFormId = ?");
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    formulaSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
                _bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
                _data = _bgFormInfo.getData();
                if (_data == null || _data.length <= 0) break block28;
                _book = _bgFormInfo.getBook();
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                int sheetSize = _book.getSheetCount();
                for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    int _rowCount = _sheet.getMaxRowIndex();
                    int _colCount = _sheet.getMaxColIndex();
                    for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                        for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                            _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                            if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                            _formulaStr2 = BgNFSHelper.getFormulaOfCell(_cell);
                            _value = BgNFSHelper.getBudgetValue(_cell);
                            _formulaSet.add(_formulaStr2);
                            if (formulaSet.contains(_formulaStr2)) {
                                updateMap.put(_formulaStr2, _value);
                                continue;
                            }
                            _adjData = new BgDataAdjsutInfo();
                            _adjData.setType(0);
                            adjustMap.put(_formulaStr2, _adjData);
                        }
                    }
                }
                for (String _formulaStr2 : formulaSet) {
                    if (_formulaSet.contains(_formulaStr2)) continue;
                    removeMap.put(_formulaStr2, null);
                }
                if (!adjustMap.isEmpty()) {
                    this._getBudgetSheet(ctx, (IObjectValue)_bgFormInfo, adjustMap);
                }
                if (!updateMap.isEmpty()) {
                    batchIndex = 0;
                    try {
                        pstmt = conn.prepareStatement("update T_BG_BgData set FBgValue = ? where FBgFormId = ? and FFormula = ?");
                        for (String _formulaStr2 : updateMap.keySet()) {
                            _value = (BigDecimal)updateMap.get(_formulaStr2);
                            pstmt.setBigDecimal(1, _value);
                            pstmt.setString(2, bgFormId.toString());
                            pstmt.setString(3, _formulaStr2);
                            pstmt.addBatch();
                            if (++batchIndex < batchSize) continue;
                            pstmt.executeBatch();
                            batchIndex = 0;
                        }
                        if (batchIndex != 0) {
                            pstmt.executeBatch();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)ex);
                        throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    finally {
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                }
                if (removeMap.isEmpty()) break block28;
                batchIndex = 0;
                try {
                    pstmt = conn.prepareStatement("delete from T_BG_BgData where FBgFormId = ? and FFormula = ?");
                    for (String _formulaStr2 : removeMap.keySet()) {
                        pstmt.setString(1, bgFormId.toString());
                        pstmt.setString(2, _formulaStr2);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkData(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        IBgForm ibgForm = null;
        BgFormInfo _bgFormInfo = null;
        BgDataAdjsutInfo _adjData = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        byte[] _data = null;
        String _formulaStr2222 = null;
        HashMap<String, BgDataAdjsutInfo> adjustMap = new HashMap<String, BgDataAdjsutInfo>();
        HashSet<String> formulaSet = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FFormula from T_BG_BgData where FBgFormId = ?");
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formulaSet.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
            _bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
            _data = _bgFormInfo.getData();
            if (_data != null && _data.length > 0) {
                _book = _bgFormInfo.getBook();
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                int sheetSize = _book.getSheetCount();
                for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    int _rowCount = _sheet.getMaxRowIndex();
                    int _colCount = _sheet.getMaxColIndex();
                    for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                        for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                            _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                            if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                            _formulaStr2222 = BgNFSHelper.getFormulaOfCell(_cell);
                            if (formulaSet.contains(_formulaStr2222)) {
                                _adjData = new BgDataAdjsutInfo();
                                _adjData.setType(1);
                                adjustMap.put(_formulaStr2222, _adjData);
                                continue;
                            }
                            _adjData = new BgDataAdjsutInfo();
                            _adjData.setType(0);
                            adjustMap.put(_formulaStr2222, _adjData);
                        }
                    }
                }
                for (String _formulaStr2222 : formulaSet) {
                    if (adjustMap.containsKey(_formulaStr2222)) continue;
                    _adjData = new BgDataAdjsutInfo();
                    _adjData.setType(2);
                    adjustMap.put(_formulaStr2222, _adjData);
                }
                this._getBudgetSheet(ctx, (IObjectValue)_bgFormInfo, adjustMap);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected List _checkCourse(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected List _course(Context ctx, List bgFormIds, String orgUnitId, String userId) throws BOSException, EASBizException {
        return this.cource(ctx, bgFormIds, orgUnitId, userId, false);
    }

    @Override
    protected List _courceByScheme(Context ctx, List bgFormIds, String orgUnitId, String userId) throws BOSException, EASBizException {
        return this.cource(ctx, bgFormIds, orgUnitId, userId, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List cource(Context ctx, List bgFormIds, String orgUnitId, String userId, boolean isReportByScheme) throws BOSException, EASBizException {
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        boolean isStartBasisApproved = BgNSHelper.isStartBasisApproved(ctx);
        String _bgFormId = null;
        String _orgUnitId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _stateMsg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        Map _orgUnitMap = null;
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        BgFormInfo bgFormInfo = new BgFormInfo();
        BgFormStateEnum stateEnum = BgFormStateEnum.Edited;
        _orgUnitMap = this.getCourseOrgMap(ctx, orgUnitId, bgFormIds);
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        if (isStartBasisApproved) {
            stateEnum = BgFormStateEnum.BasisApproved;
        }
        if (!(_bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, stateEnum, true)).isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsSet.add(_bgFormStr[0]);
                _stateMsg.append(_bgFormStr[2]).append(",");
            }
            if (_stateMsg.length() > 0) {
                _stateMsg.delete(_stateMsg.length() - 1, _stateMsg.length());
            }
        }
        String _reportBySchemeMsg = null;
        if (!isReportByScheme) {
            _reportBySchemeMsg = this.checkReportByScheme(ctx, bgFormIds, _bgFormIdsSet);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement psInst = null;
        PreparedStatement pstCau = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer cause = new StringBuffer();
        sql.append("insert into T_BG_BgCourseData(FID, FBValue, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgValue, FBgFormId, FFormula, '" + _userId + "' , ").append("NOW(), '" + _userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        cause.append("insert into T_BG_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgFormId, FFormula, '" + _userId + "' , ").append("NOW(), '" + _userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        IObjectPK pk = null;
        try {
            if (!_pBgFormInfos.isEmpty()) {
                int in = _pBgFormInfos.size();
                for (int i = 0; i < in; ++i) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i);
                    if (_bgFormIdsSet.contains(_bgFormStr[0])) continue;
                    logs.append(_bgFormStr[2]).append(",");
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                    pk = LogUtil.beginLog((Context)ctx, (String)"bgForm_course", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgForm_course");
                }
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FState = ?, FCourseOrgId = ?, FCourseUserId = ?, FCourseTime = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            psInst = conn.prepareStatement(sql.toString());
            pstCau = conn.prepareStatement(cause.toString());
            int[] sum = null;
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i).toString();
                if (!_orgUnitMap.containsKey(_bgFormId) || _bgFormIdsSet.contains(_bgFormId)) continue;
                _orgUnitId = (String)_orgUnitMap.get(_bgFormId);
                _tmpList.add(_bgFormId);
                pstmt.setInt(1, 40);
                pstmt.setString(2, BOSUuid.read((String)_orgUnitId).toString());
                pstmt.setString(3, _userId);
                pstmt.setTimestamp(4, _timestamp);
                pstmt.setString(5, _userId);
                pstmt.setTimestamp(6, _timestamp);
                pstmt.setString(7, BOSUuid.read((String)_bgFormId).toString());
                if (isStartBasisApproved) {
                    pstmt.setInt(8, 3);
                } else {
                    pstmt.setInt(8, 1);
                }
                pstmt.addBatch();
                psInst.setString(1, BOSUuid.read((String)_bgFormId).toString());
                psInst.setString(2, BOSUuid.read((String)_bgFormId).toString());
                psInst.executeUpdate();
                pstCau.setString(1, _bgFormId);
                pstCau.setString(2, _bgFormId);
                pstCau.executeUpdate();
                if (++batchIndex < batchSize) continue;
                sum = pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                sum = pstmt.executeBatch();
            }
            if (!_tmpList.isEmpty()) {
                this.updateOperateInfo(ctx, _tmpList, _userId, 1);
            }
            if (sum != null && sum.length > 0) {
                BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, _tmpList, (boolean)true);
            }
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstCau);
                SQLUtils.cleanup(psInst);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstCau);
        SQLUtils.cleanup((Statement)psInst);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_stateMsg.toString());
        _reList.add(_reportBySchemeMsg);
        return _reList;
    }

    private String checkReportByScheme(Context ctx, List bgFormIds, Set removeSet) throws SQLDataException {
        StringBuffer result = new StringBuffer();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return result.toString();
        }
        StringBuffer sql = new StringBuffer("Select bgForm.FID, bgForm.FNumber From T_Bg_BgForm bgForm, T_Bg_BgScheme bgScheme Where bgForm.FBgSchemeId = bgScheme.FID AND bgScheme.FIsReportByScheme = 1 And bgForm.FID IN(");
        sql.append(BgNSQLHelper.getParamSizeString(bgFormIds)).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < bgFormIds.size(); ++i) {
                pstmt.setString(1 + i, (String)bgFormIds.get(i));
            }
            res = pstmt.executeQuery();
            while (res.next()) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(res.getString("FNumber"));
                removeSet.add(res.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return result.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List queryBgFormIds(Context ctx, List bgFormIds, List pBgFormIds, BgFormStateEnum state, boolean isCheckWorkFlow) throws EASBizException, BOSException {
        if (ctx == null) return new ArrayList();
        if (bgFormIds == null) return new ArrayList();
        if (pBgFormIds == null) return new ArrayList();
        if (state == null) {
            return new ArrayList();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 100;
        int size = 0;
        int count = 0;
        int pos = 0;
        ArrayList<String[]> _bgFormInfos = new ArrayList<String[]>();
        ArrayList<String> _bgFormIds = new ArrayList<String>();
        HashSet<String> _bgFormIdSet = new HashSet<String>();
        int _state = 0;
        String _id = null;
        String _name = null;
        String _number = null;
        String _bgFormId = null;
        String[] _bgFormStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName, FNumber, FState from T_BG_BgForm where FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (isCheckWorkFlow) {
            int i;
            _bgFormStr = new String[bgFormIds.size()];
            int in = bgFormIds.size();
            for (i = 0; i < in; ++i) {
                _bgFormStr[i] = (String)bgFormIds.get(i);
            }
            _bgFormStr = this.getWorkFlowInterface(ctx).checkBizObjInWfProcess(_bgFormStr);
            if (_bgFormStr != null) {
                in = _bgFormStr.length;
                for (i = 0; i < in; ++i) {
                    _bgFormIdSet.add(_bgFormStr[i]);
                    _bgFormIds.add(_bgFormStr[i]);
                }
            }
            if (!_bgFormIdSet.isEmpty()) {
                in = bgFormIds.size();
                for (i = 0; i < in; ++i) {
                    _bgFormId = (String)bgFormIds.get(i);
                    if (!_bgFormIdSet.contains(_bgFormId)) continue;
                    bgFormIds.set(i, "#");
                }
            }
        }
        try {
            int x;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                for (index = 0; index < count; ++index) {
                    for (x = 1; x <= batchSize; ++x, ++pos) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormIds.get(pos));
                            continue;
                        }
                        pstmt.setString(x, "#");
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _id = rst.getString(1);
                        _name = rst.getString(2);
                        _number = rst.getString(3);
                        _bgFormStr = new String[]{_id, _name, _number};
                        _bgFormInfos.add(_bgFormStr);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
            pos = 0;
            size = bgFormIds.size();
            count = (size - 1) / batchSize + 1;
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    _name = rst.getString(2);
                    _number = rst.getString(3);
                    _state = rst.getInt(4);
                    _bgFormStr = new String[]{_id, _name, _number};
                    if (_state == state.getValue()) {
                        pBgFormIds.add(_bgFormStr);
                        continue;
                    }
                    _bgFormInfos.add(_bgFormStr);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgFormIds.clear();
                _bgFormIdSet.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        _bgFormIds.clear();
        _bgFormIdSet.clear();
        return _bgFormInfos;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getCourseOrgMap(Context ctx, String orgUnitId, List bgFormIds) throws BOSException, EASBizException {
        HashMap<String, String> bgFormIdsMap = new HashMap<String, String>();
        if (ctx == null) return bgFormIdsMap;
        if (bgFormIds == null) {
            return bgFormIdsMap;
        }
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            int i = 0;
            int in = bgFormIds.size();
            while (i < in) {
                bgFormIdsMap.put((String)bgFormIds.get(i), orgUnitId);
                ++i;
            }
            return bgFormIdsMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 100;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String _bgFormId = null;
        String _orgUnitId = null;
        String _pOrgUnitId = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer query = new StringBuffer();
        sql.append("select FID, FOrgUnitId from T_BG_BgForm where FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        ArrayList _orgUnitIdList = new ArrayList();
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        HashMap<String, String> _orgUnitIdMap = new HashMap<String, String>();
        Object var21_23 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgFormId = rst.getString(1);
                    _orgUnitId = rst.getString(2);
                    bgFormIdsMap.put(_bgFormId, _orgUnitId);
                    _orgUnitIdSet.add(_orgUnitId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            _orgUnitIdList.addAll(_orgUnitIdSet);
            query.append("select FID, FParentID from T_ORG_CostCenter where FID IN (");
            for (index = 1; index < batchSize; ++index) {
                query.append("?,");
            }
            query.append("?)");
            pos = 0;
            size = _orgUnitIdList.size();
            count = (size - 1) / batchSize + 1;
            pstmt = conn.prepareStatement(query.toString());
            for (index = 0; index < count; ++index) {
                for (int y = 1; y <= batchSize; ++y, ++pos) {
                    if (pos < size) {
                        pstmt.setString(y, BOSUuid.read((String)((String)_orgUnitIdList.get(pos))).toString());
                        continue;
                    }
                    pstmt.setString(y, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    _pOrgUnitId = rst.getString(2);
                    _orgUnitIdMap.put(_orgUnitId, _pOrgUnitId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            for (Map.Entry entry : bgFormIdsMap.entrySet()) {
                _orgUnitId = (String)entry.getValue();
                _pOrgUnitId = (String)_orgUnitIdMap.get(_orgUnitId);
                if (_pOrgUnitId == null) continue;
                entry.setValue(_pOrgUnitId);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgFormIdsMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createCourseData(Context ctx, String userId, List bgFormIds, int state) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgFormIds == null) return;
        if (bgFormIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer cause = new StringBuffer();
        sql.append("insert into T_BG_BgCourseData(FID, FBValue, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgValue, FBgFormId, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        cause.append("insert into T_BG_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgFormId, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        String _bgFormId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstcau = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstcau = conn.prepareStatement(cause.toString());
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)bgFormIds.get(i);
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, _bgFormId);
                pstmt.executeUpdate();
                pstcau.setString(1, _bgFormId);
                pstcau.setString(2, _bgFormId);
                pstcau.executeUpdate();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstcau);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstcau);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IEnactmentService getWorkFlowInterface(Context ctx) throws BOSException {
        return EnactmentServiceFactory.createEnactService((Context)ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _approve(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        int i;
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String _bgFormId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashMap<String, String> _bgFormIdsMap = new HashMap<String, String>();
        IBgPastRecord _iPastRecord = BgPastRecordFactory.getLocalInstance((Context)ctx);
        BgFormInfo bgFormInfo = new BgFormInfo();
        BgPastRecordInfo _record = null;
        BgPastDataInfo _data = null;
        UserInfo _user = null;
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        ArrayList tmpBgFormIds = new ArrayList();
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Report, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsMap.put(_bgFormStr[0], _bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        if (!_bgFormIdsMap.isEmpty()) {
            for (i = 0; i < bgFormIds.size(); ++i) {
                if (_bgFormIdsMap.containsKey(bgFormIds.get(i))) continue;
                tmpBgFormIds.add(bgFormIds.get(i));
            }
            bgFormIds = tmpBgFormIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstdel = null;
        PreparedStatement pstQuy = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID, c.FBValue, d.FBgValue, d.FBgValue - c.FBValue, c.FFormula, c.FLastUpdateUserId, c.FLastUpdateTime ").append(" from T_BG_BgCourseData c ").append(" left join T_BG_BgData d on c.FID = d.FID ").append(" where c.FBgFormId = ? and c.FBValue <> d.FBgValue");
        IObjectPK pk = null;
        try {
            int i2;
            int in;
            if (!_pBgFormInfos.isEmpty()) {
                in = _pBgFormInfos.size();
                for (i2 = 0; i2 < in; ++i2) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i2);
                    logs.append(_bgFormStr[2]).append(" ");
                    logs.append(_bgFormStr[1]);
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgCourse_certificate", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgCourse_certificate");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FState = ?, FCertificateUserId = ?, FCertificateTime = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            pstdel = conn.prepareStatement("delete from T_BG_BgCourseData where FBgFormId = ?");
            pstQuy = conn.prepareStatement(sql.toString());
            in = bgFormIds.size();
            for (i2 = 0; i2 < in; ++i2) {
                _bgFormId = bgFormIds.get(i2).toString();
                pstQuy.setString(1, _bgFormId);
                rst = pstQuy.executeQuery();
                _tmpList.add(_bgFormId);
                _record = new BgPastRecordInfo();
                _record.setBgFormId(_bgFormId);
                _record.setPastSource(BgPastSourceEnum.COURSE);
                while (rst.next()) {
                    _data = new BgPastDataInfo();
                    _data.setBgData(rst.getString(1));
                    _data.setBalance(rst.getBigDecimal(2));
                    _data.setAdjValue(rst.getBigDecimal(3));
                    _data.setPastValue(rst.getBigDecimal(4));
                    _data.setFormula(rst.getString(5));
                    _user = new UserInfo();
                    _user.setId(BOSUuid.read((String)rst.getString(6)));
                    _data.setAdjustor(_user);
                    _data.setAdjusttime(rst.getTimestamp(7));
                    _record.getPastDatas().add(_data);
                }
                if (_record.getPastDatas().size() > 0) {
                    _iPastRecord.addnew((CoreBaseInfo)_record);
                }
                SQLUtils.cleanup((ResultSet)rst);
                pstmt.setInt(1, 41);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, _userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, _bgFormId);
                pstmt.setInt(7, 40);
                pstmt.addBatch();
                pstdel.setString(1, _bgFormId);
                pstdel.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                pstdel.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
                pstdel.executeBatch();
            }
            this.updateOperateInfo(ctx, _tmpList, _userId, 2);
            this.clearLockByAreaCertificate(ctx, bgFormIds);
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(pstQuy);
                SQLUtils.cleanup(pstdel);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)pstQuy);
        SQLUtils.cleanup((Statement)pstdel);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        this.MakeHistory(ctx, bgFormIds);
        return _reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearLockByAreaCertificate(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null) {
            return;
        }
        StringBuffer querySql = new StringBuffer("select fid,fdata from t_bg_bgform where fid in (");
        StringBuffer updateSql = new StringBuffer("update t_bg_bgform set fdata = ? where fid = ? ");
        int index = 0;
        int batchSize = 100;
        int size = 0;
        int count = 0;
        int pos = 0;
        for (int i = 1; i < batchSize; ++i) {
            querySql.append("?,");
        }
        querySql.append("? )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, BgFormInfo> tmpMap = new HashMap<String, BgFormInfo>();
        BgFormInfo info = null;
        String key2222 = null;
        try {
            size = bgFormIds.size();
            count = (size - 1) / batchSize + 1;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(querySql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)((String)bgFormIds.get(pos))).toString());
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    info = new BgFormInfo();
                    info.setZipData(BgInfoHelper.getBytes(rst, "fdata"));
                    this.clearCell(info);
                    tmpMap.put(rst.getString("fid"), info);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(updateSql.toString());
            for (String key2222 : tmpMap.keySet()) {
                info = (BgFormInfo)tmpMap.get(key2222);
                pstmt.setBytes(1, info.getZipData());
                pstmt.setString(2, BOSUuid.read((String)key2222).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception e) {
                    throw new BOSException(e.getCause());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                if (tmpMap == null) throw throwable;
                tmpMap.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (tmpMap == null) return;
        tmpMap.clear();
    }

    private void clearCell(BgFormInfo info) throws Exception {
        Book book = info.getBook();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        if (info == null || book == null) {
            return;
        }
        int sheetCount = book.getSheetCount();
        Sheet sheet = null;
        Cell cell = null;
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                int colCount = sheet.getMaxColIndex() + 1;
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasCertificate(cell)) continue;
                    BgNFSHelper.removeCellData(cell, "COURSE_CER");
                }
            }
        }
        info.setBook(book);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _antiApprove(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        Timestamp _Timestamp = new Timestamp(System.currentTimeMillis());
        String _bgFormId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        BgFormInfo bgFormInfo = new BgFormInfo();
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashMap<String, String> _bgFormIdsMap = new HashMap<String, String>();
        String _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Certificate, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsMap.put(_bgFormStr[0], _bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        ArrayList tmpBgFormIds = new ArrayList();
        if (!_bgFormIdsMap.isEmpty()) {
            for (int i = 0; i < bgFormIds.size(); ++i) {
                if (_bgFormIdsMap.containsKey(bgFormIds.get(i))) continue;
                tmpBgFormIds.add(bgFormIds.get(i));
            }
            bgFormIds = tmpBgFormIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        IObjectPK pk = null;
        try {
            int i;
            int in;
            if (!_pBgFormInfos.isEmpty()) {
                in = _pBgFormInfos.size();
                for (i = 0; i < in; ++i) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i);
                    logs.append(_bgFormStr[2]).append(",");
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgCourse_antiCertificate", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgCourse_antiCertificate");
            }
            bgFormIds.removeAll(_pBgFormInfos);
            this.createCourseData(ctx, userId, bgFormIds, 41);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FState = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            in = bgFormIds.size();
            for (i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i).toString();
                _tmpList.add(_bgFormId);
                pstmt.setInt(1, 40);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _Timestamp);
                pstmt.setString(4, _bgFormId);
                pstmt.setInt(5, 41);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            this.updateOperateInfo(ctx, _tmpList, _userId, 3);
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        return _reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _back(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        HashMap<String, Object> _reMap = new HashMap<String, Object>();
        _reMap.put("back_result", Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reMap;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String _bgFormId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        StringBuffer checkMsg = new StringBuffer();
        String bg036 = BgNSHelper.isStateOfGather(ctx);
        boolean isNeedCheck = "2".equals(bg036) || "3".equals(bg036) || "5".equals(bg036);
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        BgFormInfo bgFormInfo = new BgFormInfo();
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Report, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsSet.add(_bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        if (BgNSHelper.isStartBasisApproved(ctx) && BgNSHelper.isStepByStepReport(ctx)) {
            if (isNeedCheck) {
                List[] res = this.queryGatherBgFormIdsAndCheckCanBack(ctx, bgFormIds);
                bgFormIds.clear();
                if (res[0] != null) {
                    bgFormIds.addAll(res[0]);
                }
                if (res[1] != null && res[1].size() > 0) {
                    for (int i = 0; i < res[1].size() - 1; ++i) {
                        checkMsg.append(res[1].get(i)).append(",");
                    }
                    checkMsg.append(res[1].get(res[1].size() - 1));
                }
            } else {
                List gatherBgFormIds = this.queryGatherBgFormIds(ctx, bgFormIds);
                if (gatherBgFormIds != null && !gatherBgFormIds.isEmpty()) {
                    bgFormIds.addAll(gatherBgFormIds);
                }
            }
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        IObjectPK pk = null;
        try {
            if (!_pBgFormInfos.isEmpty()) {
                int in = _pBgFormInfos.size();
                for (int i = 0; i < in; ++i) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i);
                    logs.append(_bgFormStr[2]).append(",");
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgCourse_back", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgCourse_back");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FState = ?,FStateBeforeAudit = ?, FBackUserId = ?, FBackTime = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            int[] sum = null;
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i).toString();
                pstmt.setInt(1, 42);
                pstmt.setInt(2, 1);
                pstmt.setString(3, BOSUuid.read((String)_userId).toString());
                pstmt.setTimestamp(4, _timestamp);
                pstmt.setString(5, BOSUuid.read((String)_userId).toString());
                pstmt.setTimestamp(6, _timestamp);
                pstmt.setString(7, BOSUuid.read((String)_bgFormId).toString());
                pstmt.setInt(8, 40);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                sum = pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                sum = pstmt.executeBatch();
            }
            if (sum != null && sum.length > 0) {
                BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, (List)bgFormIds, (boolean)false);
            }
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        _reMap.put("back_result", Boolean.TRUE);
        _reMap.put("back_no_uproport", _msg.toString());
        _reMap.put("back_can_not", checkMsg.toString());
        return _reMap;
    }

    private List queryGatherBgFormIds(Context ctx, List bgFormIds) throws EASBizException, BOSException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return returnList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgFormId from t_bg_bgGatherInfo  ");
        sql.append("where FSubBgFormId in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        String gatherBgFormId = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)bgFormIds.get(pos).toString()).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                ArrayList<String> tempList = new ArrayList<String>();
                while (rst.next()) {
                    gatherBgFormId = rst.getString(1);
                    if (!returnList.contains(gatherBgFormId)) {
                        returnList.add(gatherBgFormId);
                    }
                    tempList.add(gatherBgFormId);
                }
                if (!tempList.isEmpty()) {
                    List tempList2 = this.queryGatherBgFormIds(ctx, tempList);
                    for (int i = 0; i < tempList2.size(); ++i) {
                        gatherBgFormId = (String)tempList2.get(i);
                        if (returnList.contains(gatherBgFormId)) continue;
                        returnList.add(gatherBgFormId);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return returnList;
    }

    @Override
    protected Map _confirm(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        Map _reMap = new HashMap();
        if (bgFormIds == null || bgFormIds.isEmpty() || StringUtils.isEmpty((String)userId)) {
            return _reMap;
        }
        String _bgFormId2 = null;
        HashSet<String> _billIdSet = new HashSet<String>();
        List<String> resList = new ArrayList();
        ArrayList<String> _tmpBgFormIds = new ArrayList<String>();
        _tmpBgFormIds.addAll(bgFormIds);
        String[] _bgFormIds = new String[_tmpBgFormIds.size()];
        int in = _tmpBgFormIds.size();
        for (int i = 0; i < in; ++i) {
            _bgFormIds[i] = (String)_tmpBgFormIds.get(i);
        }
        _bgFormIds = EnactmentServiceFactory.createEnactService((Context)ctx).checkBizObjInWfProcess(_bgFormIds);
        if (_bgFormIds != null) {
            _billIdSet.clear();
            for (String _bgFormId2 : _bgFormIds) {
                _billIdSet.add(_bgFormId2);
            }
            resList.addAll(_tmpBgFormIds);
            _tmpBgFormIds.clear();
            for (String _bgFormId2 : resList) {
                if (_billIdSet.contains(_bgFormId2)) continue;
                _tmpBgFormIds.add(_bgFormId2);
            }
            resList.clear();
        }
        resList = BgNFormFacadeFactory.getLocalInstance(ctx).checkBatchAudit(_tmpBgFormIds);
        _tmpBgFormIds.clear();
        _tmpBgFormIds.addAll(resList);
        int _bgFormIdSize = _tmpBgFormIds.size();
        BOSUuid[] bgFormAuditIds = new BOSUuid[_bgFormIdSize];
        for (int index = 0; index < _bgFormIdSize; ++index) {
            bgFormAuditIds[index] = BOSUuid.read((String)_tmpBgFormIds.get(index).toString());
        }
        if (BgParamNHelper.isCompulsionReportCheck(ctx)) {
            List nopass;
            boolean isExit = false;
            List check = BgFormFactory.getLocalInstance((Context)ctx).reportCheck(bgFormAuditIds);
            if (check.size() >= 3 && check.get(3) != null) {
                isExit = true;
            }
            if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
                isExit = true;
            }
            if (isExit) {
                return _reMap;
            }
        }
        _reMap = BgNFormFacadeFactory.getLocalInstance(ctx).batchAudit(bgFormIds, BOSUuid.read((String)userId));
        return _reMap;
    }

    @Override
    protected Map _getReferBgFormList(Context ctx, Map params) throws BOSException, EASBizException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        HashMap<String, Object[]> returnMap = new HashMap<String, Object[]>();
        String orgunit_fNumber = null;
        String bgscheme_FNumber = null;
        String bdcurrency_FNumber = null;
        String bgperiod_FNumber = null;
        String bgperiod1_FNumber = null;
        String bgperiod2_FNumber = null;
        String bgdata_FFormula = null;
        String _bgFormId = null;
        BOSUuid _tmpId = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String expression = null;
        Object paramKey2 = null;
        Object[] param = null;
        StringBuffer sql = new StringBuffer();
        ctx.getLocale();
        sql.append("select bgdata.FBgFormId, bgform.FName, orgunit.FName_" + ctx.getLocale() + ", orgunit.FLongNumber, bgperiod.FName_" + ctx.getLocale() + ", bgperiod.FLongNumber, bdcurrency.FName_" + ctx.getLocale() + " from T_Bg_BgData bgdata ");
        sql.append("join T_Bg_BgForm bgform on bgdata.FBgFormId = bgform.FID ");
        sql.append("join ( select FID, FName_" + ctx.getLocale() + ", FLongNumber from T_ORG_BaseUnit  where FNumber = ? ) orgunit on bgdata.FOrgUnitId = orgunit.FID ");
        sql.append("join ( select FID from T_BG_BgScheme where FNumber = ? ) bgscheme  on bgdata.FBgSchemeId = bgscheme.FID ");
        sql.append("join ( select FID, FName_" + ctx.getLocale() + " from T_BD_Currency where FNumber = ? ) bdcurrency  on bgdata.FCurrencyId = bdcurrency.FID ");
        sql.append("join T_BG_BgPeriod bgperiod on bgdata.FBgPeriodId = bgperiod.FID and bgperiod.FNumber = ?  ");
        sql.append("where bgdata.FFormula = ?  ");
        sql.append("order by orgunit.FLongNumber ASC, bgperiod.FLongNumber ASC  ");
        try {
            conn = this.getConnection(ctx);
            for (Object paramKey2 : params.keySet()) {
                param = (Object[])params.get(paramKey2);
                orgunit_fNumber = "" + param[0];
                bgscheme_FNumber = "" + param[1];
                bdcurrency_FNumber = "" + param[4];
                bgperiod1_FNumber = "" + param[5];
                if (!bgperiod1_FNumber.equals(bgperiod2_FNumber = "" + param[6])) {
                    java.sql.Date beginDate = null;
                    java.sql.Date endDate = null;
                    try {
                        ps = conn.prepareStatement("select FBeginDate from T_BG_BgPeriod where FNumber = '" + bgperiod1_FNumber + "'  union select FEndDate from T_BG_BgPeriod where FNumber = '" + bgperiod2_FNumber + "' ");
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            beginDate = rs.getDate(1);
                        }
                        if (rs.next()) {
                            endDate = rs.getDate(1);
                        }
                    }
                    catch (Exception e) {
                        try {
                            logger.error((Object)e);
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, ps);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                    BgPeriodCollection bgc = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)BgNPeriodHelper.parserBgPeriodType(bgperiod1_FNumber));
                    String str_period = null;
                    Iterator itPreiod = bgc.iterator();
                    while (itPreiod.hasNext()) {
                        bgperiod_FNumber = str_period = ((BgPeriodInfo)itPreiod.next()).getNumber();
                        bgdata_FFormula = "=BgItem(\"" + param[3] + "\",\"" + str_period + "\",\"" + param[2] + "\",\"BgData\",true,\"" + param[4] + "\")";
                        try {
                            ps = conn.prepareStatement(sql.toString());
                            ps.setString(1, orgunit_fNumber);
                            ps.setString(2, bgscheme_FNumber);
                            ps.setString(3, bdcurrency_FNumber);
                            ps.setString(4, bgperiod_FNumber);
                            ps.setString(5, bgdata_FFormula);
                            rs = ps.executeQuery();
                            while (rs.next()) {
                                Object[] paramItem = new Object[7];
                                _bgFormId = rs.getString(1);
                                paramItem[0] = _bgFormId;
                                _tmpId = BgGatherHelper.getGatherAdjustId((Connection)conn, (BOSUuid)BOSUuid.read((String)_bgFormId));
                                if (!_bgFormId.equals(_tmpId.toString())) {
                                    paramItem[0] = _tmpId.toString();
                                }
                                paramItem[1] = rs.getString(2);
                                paramItem[2] = rs.getString(3);
                                paramItem[3] = rs.getString(5);
                                paramItem[4] = rs.getString(7);
                                paramItem[5] = rs.getString(4);
                                paramItem[6] = rs.getString(6);
                                expression = "BGFORMULA(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + param[4] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\")";
                                returnMap.put(expression, paramItem);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                            throw new BOSException((Throwable)e);
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                        }
                    }
                    continue;
                }
                bgperiod_FNumber = bgperiod1_FNumber;
                bgdata_FFormula = "=BgItem(\"" + param[3] + "\",\"" + param[5] + "\",\"" + param[2] + "\",\"BgData\",true,\"" + param[4] + "\")";
                try {
                    ps = conn.prepareStatement(sql.toString());
                    ps.setString(1, orgunit_fNumber);
                    ps.setString(2, bgscheme_FNumber);
                    ps.setString(3, bdcurrency_FNumber);
                    ps.setString(4, bgperiod_FNumber);
                    ps.setString(5, bgdata_FFormula);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        Object[] paramItem = new Object[7];
                        _bgFormId = rs.getString(1);
                        paramItem[0] = _bgFormId;
                        _tmpId = BgGatherHelper.getGatherAdjustId((Connection)conn, (BOSUuid)BOSUuid.read((String)_bgFormId));
                        if (!_bgFormId.equals(_tmpId.toString())) {
                            paramItem[0] = _tmpId.toString();
                        }
                        paramItem[1] = rs.getString(2);
                        paramItem[2] = rs.getString(3);
                        paramItem[3] = rs.getString(5);
                        paramItem[4] = rs.getString(7);
                        paramItem[5] = rs.getString(4);
                        paramItem[6] = rs.getString(6);
                        expression = "BGFORMULA(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + param[4] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\")";
                        returnMap.put(expression, paramItem);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                }
            }
        }
        catch (BOSException be) {
            logger.error((Object)be);
            throw be;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return returnMap;
    }

    @Override
    protected List _queryBgFormWorkFlowInfo(Context ctx, Map queryParam) throws BOSException, EASBizException {
        int i;
        ArrayList<BgFormWorkFlowInfo> reList = new ArrayList<BgFormWorkFlowInfo>();
        if (queryParam == null) {
            return reList;
        }
        boolean _isBgPermissionUsed = BgSHelper.isBgPermissionUsed((Context)ctx);
        String CURR_USER_ID = (String)queryParam.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)queryParam.get("CURR_CTRLORGUNIT_ID");
        String SEL_ORGUNIT_ID = (String)queryParam.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)queryParam.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])queryParam.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])queryParam.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])queryParam.get("SEL_CURRENCY_IDS");
        String QUERY_INFO = (String)queryParam.get("QUERY_INFO");
        Boolean hasShowWorkFlow = (Boolean)queryParam.get("SHOW_INFO");
        if (hasShowWorkFlow == null) {
            hasShowWorkFlow = Boolean.FALSE;
        }
        String _key = null;
        ArrayList<String> idsList = new ArrayList<String>();
        Set<String> _queryOrgUnitIds = new HashSet<String>();
        HashSet<Integer> _state = new HashSet<Integer>();
        HashMap<String, BgFormWorkFlowInfo> _bgFormMap = new HashMap<String, BgFormWorkFlowInfo>();
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        BgFormCollection bgFormColl = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("adjust.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        HashSet<String> bgSchemeIdsSet = new HashSet<String>();
        if (SEL_BGSCHEME_IDS != null) {
            int in = SEL_BGSCHEME_IDS.length;
            for (int i2 = 0; i2 < in; ++i2) {
                if (SEL_BGSCHEME_IDS[i2] == null) continue;
                bgSchemeIdsSet.add(SEL_BGSCHEME_IDS[i2].toString());
            }
        }
        HashSet<String> bgPeriodIdsSet = new HashSet<String>();
        if (SEL_BGPERIOD_IDS != null) {
            int in = SEL_BGPERIOD_IDS.length;
            for (int i3 = 0; i3 < in; ++i3) {
                if (SEL_BGPERIOD_IDS[i3] == null) continue;
                bgPeriodIdsSet.add(SEL_BGPERIOD_IDS[i3].toString());
            }
        }
        HashSet<String> currnecyIdsSet = new HashSet<String>();
        if (SEL_CURRENCY_IDS != null) {
            int in = SEL_CURRENCY_IDS.length;
            for (int i4 = 0; i4 < in; ++i4) {
                if (SEL_CURRENCY_IDS[i4] == null) continue;
                currnecyIdsSet.add(SEL_CURRENCY_IDS[i4].toString());
            }
        }
        _state.add(new Integer(15));
        _state.add(new Integer(5));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootId", bgSchemeIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", currnecyIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", _state, CompareType.NOTINCLUDE));
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, SEL_ORGUNIT_ID)) {
                _queryOrgUnitIds.add(SEL_ORGUNIT_ID);
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, false);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        }
        if (_queryOrgUnitIds.isEmpty()) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", _queryOrgUnitIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6)");
        if (_isBgPermissionUsed) {
            BgPermissionHelper.addBgFormPermission(ctx, CURR_USER_ID, _queryOrgUnitIds, filter);
        }
        view.setFilter(filter);
        BgFormWorkFlowInfo workFlowInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 200;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID, f.FNumber, f.FName, f.FState, t.FActDefName_" + ctx.getLocale() + ", t.fPersonUserName_" + ctx.getLocale() + ", sc.fname_" + ctx.getLocale() + ", cc.FName_" + ctx.getLocale() + ", f.FAdjustID from T_WFR_Assign t  join T_BG_BgForm f on t.FBizObjId = f.FID  join T_BG_BgScheme sc on f.FBgSchemeId = sc.FID  join T_ORG_CostCenter cc on f.FOrgUnitId = cc.fid  WHERE t.FBIZFUNCTION = 'MultiApproveUIFunction'  AND t.FBIZPACKAGE = 'com.kingdee.eas.base.multiapprove.client' and ");
        if (!StringUtils.isEmpty((String)QUERY_INFO)) {
            sql.append(" t.FActDefName_" + ctx.getLocale() + " like '%" + QUERY_INFO + "%' and ");
        }
        sql.append(" t.FBizObjId IN (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
            bgFormColl = ibgForm.getBgFormCollection(view);
            if (bgFormColl != null) {
                int in = bgFormColl.size();
                for (i = 0; i < in; ++i) {
                    bgFormInfo = bgFormColl.get(i);
                    idsList.add(bgFormInfo.getId().toString());
                    if (hasShowWorkFlow.booleanValue() || !StringUtils.isEmpty((String)QUERY_INFO)) continue;
                    workFlowInfo = new BgFormWorkFlowInfo();
                    workFlowInfo.setId(bgFormInfo.getId().toString());
                    workFlowInfo.setNumber(bgFormInfo.getNumber());
                    workFlowInfo.setName(bgFormInfo.getName());
                    workFlowInfo.setState(bgFormInfo.getState().getValue());
                    workFlowInfo.setBgSchemeName(bgFormInfo.getBgScheme().getName());
                    workFlowInfo.setOrgUnitName(bgFormInfo.getOrgUnit().getName());
                    workFlowInfo.setAdjustId(bgFormInfo.getAdjust().getId().toString());
                    _bgFormMap.put(bgFormInfo.getId().toString(), workFlowInfo);
                    reList.add(workFlowInfo);
                }
                if (!idsList.isEmpty()) {
                    int size = idsList.size();
                    int count = (size - 1) / batchSize + 1;
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                pstmt.setString(x, (String)idsList.get(pos));
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _key = rst.getString(1);
                            if (_bgFormMap.containsKey(_key)) {
                                workFlowInfo = (BgFormWorkFlowInfo)_bgFormMap.get(_key);
                                workFlowInfo.addUserName(rst.getString(6));
                                if (workFlowInfo.getTask() != null) continue;
                                workFlowInfo.setTask(rst.getString(5));
                                continue;
                            }
                            workFlowInfo = new BgFormWorkFlowInfo();
                            workFlowInfo.setId(_key);
                            workFlowInfo.setNumber(rst.getString(2));
                            workFlowInfo.setName(rst.getString(3));
                            workFlowInfo.setState(rst.getInt(4));
                            workFlowInfo.setTask(rst.getString(5));
                            workFlowInfo.addUserName(rst.getString(6));
                            workFlowInfo.setBgSchemeName(rst.getString(7));
                            workFlowInfo.setOrgUnitName(rst.getString(8));
                            workFlowInfo.setAdjustId(rst.getString(9));
                            _bgFormMap.put(_key, workFlowInfo);
                            reList.add(workFlowInfo);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, conn);
        }
        return reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set queryImmOrgUnit(Context ctx, String currOrgUnitId, boolean isImmOrgUnit) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currOrgUnitId)) {
            return new HashSet();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        int _level = 0;
        String _number = null;
        String _longNumber = null;
        String _orgUnitId = null;
        String sql1 = "select FNumber, FLongNumber, FLevel from T_ORG_CostCenter where FID = ?";
        String sql2 = "select FID from T_ORG_CostCenter where FLongnumber like ? " + (isImmOrgUnit ? "and FLevel = ?" : "");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, BOSUuid.read((String)currOrgUnitId).toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitSet.add(currOrgUnitId);
                _number = rst.getString(1);
                _longNumber = rst.getString(2);
                _level = rst.getInt(3);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty(_number) && !StringUtils.isEmpty(_longNumber)) {
                pstmt = conn.prepareStatement(sql2);
                pstmt.setString(1, _longNumber + "!%");
                if (isImmOrgUnit) {
                    pstmt.setInt(2, _level + 1);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    orgUnitSet.add(_orgUnitId);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    protected IPermission getPermissionInterface(Context ctx) throws BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx);
    }

    protected boolean verifyPermission(Context ctx, String userId, String orgUnitId) throws BOSException, EASBizException {
        return this.getPermissionInterface(ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), PERMISSION_STR);
    }

    protected Set verifyPermission(Context ctx, String ctrlUnitId, String userId, Set orgUnitIdSet) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId) || orgUnitIdSet == null) {
            return new HashSet();
        }
        String _orgUnitId = null;
        FullOrgUnitInfo _orgUnitInfo = null;
        FullOrgUnitCollection _orgUnitCol = null;
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        _orgUnitCol = this.getPermissionInterface(ctx).getAuthorizedOrgOfIncludeSubCU((IObjectPK)new ObjectUuidPK(ctrlUnitId), (IObjectPK)new ObjectUuidPK(userId), OrgType.CostCenter, null, PERMISSION_STR);
        if (_orgUnitCol != null && !_orgUnitCol.isEmpty()) {
            int in = _orgUnitCol.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitInfo = _orgUnitCol.get(i);
                _orgUnitIdSet.add(_orgUnitInfo.getId().toString());
            }
            Iterator iter = orgUnitIdSet.iterator();
            while (iter.hasNext()) {
                _orgUnitId = (String)iter.next();
                if (_orgUnitIdSet.contains(_orgUnitId)) continue;
                iter.remove();
            }
            _orgUnitIdSet.clear();
        } else {
            orgUnitIdSet.clear();
        }
        return orgUnitIdSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateOperateInfo(Context ctx, String bgFormId, String userId, int operate) throws BOSException, EASBizException {
        if (ctx == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormId == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (userId == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgCourseCommentInfo info = new BgCourseCommentInfo();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BG_BgCourseComment (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FBgFormId, FComment) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
            pstmt.setString(2, userId);
            pstmt.setTimestamp(3, _timestamp);
            pstmt.setString(4, userId);
            pstmt.setTimestamp(5, _timestamp);
            pstmt.setString(6, null);
            pstmt.setInt(7, operate);
            pstmt.setString(8, bgFormId);
            pstmt.setString(9, info.getComment());
            pstmt.execute();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateOperateInfo(Context ctx, List bgFormIds, String userId, int operate) throws BOSException, EASBizException {
        if (ctx == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds.isEmpty()) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (userId == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgCourseCommentInfo info = new BgCourseCommentInfo();
        String _bgFormId = null;
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BG_BgCourseComment (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FBgFormId, FComment) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)bgFormIds.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, null);
                pstmt.setInt(7, operate);
                pstmt.setString(8, _bgFormId);
                pstmt.setString(9, info.getComment());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _getInitBudgetData(Context ctx, String bgFormId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> initMap = new HashMap<String, BigDecimal>();
        if (StringUtils.isEmpty((String)bgFormId)) {
            return initMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String querySql = "select FFormula, FBgValue from T_BG_BgData where FBgFormId = ?";
        String formulaStr = null;
        BigDecimal value = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(querySql);
            pstmt.setString(1, bgFormId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formulaStr = rst.getString("FFormula");
                value = rst.getBigDecimal("FBgValue");
                initMap.put(formulaStr, value);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return initMap;
    }

    @Override
    protected Map _writeBgActToCtrlRecord(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        StringBuffer message;
        HashMap<String, String> returnMap;
        block25: {
            returnMap = new HashMap<String, String>();
            if (bgFormIds == null || bgFormIds.isEmpty()) {
                return returnMap;
            }
            int _state = 0;
            String _bgFormId = null;
            String _number = null;
            String _name = null;
            java.sql.Date _date = null;
            String _orgUnitId = null;
            HashMap<String, Object[]> bgFormInfoMap = new HashMap<String, Object[]>();
            message = new StringBuffer();
            int index = 0;
            int batchSize = 100;
            int size = bgFormIds.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FState, FNumber, FName, FLastUpdateTime, ForgUnitId from T_BG_BgForm where FID IN (");
            for (index = 1; index < batchSize; ++index) {
                sql.append("?,");
            }
            sql.append("?)");
            StringBuffer sql1 = new StringBuffer();
            sql1.append("delete from t_bg_bgctrlrecord where fbillid = ? and fbgtracetype = 1");
            StringBuffer sql2 = new StringBuffer();
            sql2.append(" select a.fid, a.FBgActual, b.fkey ,c.fnumber, a.fbgformid ");
            sql2.append(" from t_bg_bgdata a ,t_bg_bgitemcombination b ,t_bg_bgperiod c ");
            sql2.append(" where a.fbgitemcombinid = b.fid and a.fbgperiodid = c.fid and a.FBgActual != 0 and a.fbgformid in (");
            for (index = 1; index < batchSize; ++index) {
                sql2.append("?,");
            }
            sql2.append("?)");
            StringBuffer sql3 = new StringBuffer();
            sql3.append("update t_bg_bgData set FBizActual = (select sum(FActualAmount) from t_bg_bgctrlrecord where fbgDataId = ? group by fbgDataID) where fid = ?");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            pstmt.setString(x, (String)bgFormIds.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _bgFormId = rst.getString("FID");
                        _state = rst.getInt("FState");
                        _number = rst.getString("FNumber");
                        _name = rst.getString("FName");
                        _date = rst.getDate("FLastUpdateTime");
                        if (_orgUnitId == null) {
                            _orgUnitId = rst.getString("FOrgUnitId");
                        }
                        bgFormInfoMap.put(_bgFormId, new Object[]{_name, _number, _date});
                        if (_state == 2) continue;
                        message.append(_number).append(",");
                        bgFormIds.remove(_bgFormId);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                pstmt = conn.prepareStatement(sql1.toString());
                index = 0;
                for (int i = 0; i < bgFormIds.size(); ++i) {
                    pstmt.setString(1, (String)bgFormIds.get(i));
                    pstmt.addBatch();
                    if (++index < batchSize) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                index = 0;
                size = bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                String bgDataId2 = null;
                BigDecimal bgActual = null;
                String itemKey = null;
                String bgPeriodNumber = null;
                String bgFormId = null;
                Object[] obj = null;
                HashMap bgDataActMap = new HashMap();
                BgCtrlRecordCollection coll = new BgCtrlRecordCollection();
                HashMap bgItemNameMap = new HashMap();
                pstmt = conn.prepareStatement(sql2.toString());
                for (index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            pstmt.setString(x, (String)bgFormIds.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgDataId2 = rst.getString(1);
                        bgActual = rst.getBigDecimal(2);
                        itemKey = rst.getString(3);
                        bgPeriodNumber = rst.getString(4);
                        bgFormId = rst.getString(5);
                        bgItemNameMap.put(itemKey, null);
                        BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                        bgCtrlRecordInfo.setBgDataId(bgDataId2);
                        if (bgActual != null && bgActual.floatValue() == 0.0f || (obj = (Object[])bgFormInfoMap.get(bgFormId)) == null || obj.length != 3) continue;
                        bgCtrlRecordInfo.setActualAmount(bgActual);
                        bgCtrlRecordInfo.setBillId(bgFormId);
                        bgCtrlRecordInfo.setBillName((String)obj[0]);
                        bgCtrlRecordInfo.setBillNumber((String)obj[1]);
                        bgCtrlRecordInfo.setBillType(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"6_BgNFormFacadeControllerBean", (Locale)ctx.getLocale()));
                        bgCtrlRecordInfo.setBizDate((Date)obj[2]);
                        bgCtrlRecordInfo.setBgPeriodId(bgPeriodNumber);
                        bgCtrlRecordInfo.setItemName(itemKey);
                        bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.BgForm);
                        if (BgNPeriodHelper.parserBgPeriodType(bgPeriodNumber) == 7) {
                            bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay((String)bgPeriodNumber));
                        }
                        coll.add(bgCtrlRecordInfo);
                        bgDataActMap.put(bgDataId2, null);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                for (int i = 0; i < coll.size(); ++i) {
                    String name = bgItemNameMap.get(coll.get(i).getItemName()) == null ? "" : (String)bgItemNameMap.get(coll.get(i).getItemName());
                    coll.get(i).setItemName(name);
                }
                IBgCtrlRecord iRecord = BgCtrlRecordFactory.getLocalInstance((Context)ctx);
                iRecord.addNewColl(coll);
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (bgDataActMap.isEmpty()) break block25;
                index = 0;
                pstmt = conn.prepareStatement(sql3.toString());
                for (String bgDataId2 : bgDataActMap.keySet()) {
                    pstmt.setString(1, BOSUuid.read((String)bgDataId2).toString());
                    pstmt.setString(2, BOSUuid.read((String)bgDataId2).toString());
                    pstmt.addBatch();
                    if (++index < batchSize) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index != 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (message.length() > 0 && message.indexOf(",") != -1) {
            message.delete(message.length() - 1, message.length());
            returnMap.put("message", ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"7_BgNFormFacadeControllerBean", (Locale)ctx.getLocale()) + message.toString() + ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"8_BgNFormFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return returnMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _batchAuditGatherCourse(Context ctx, List bgFormIds, BOSUuid auditUser, String auditIdea) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return new HashMap();
        }
        int _state = 0;
        String _bgFormId = null;
        HashMap<String, Boolean> _batchAuditMap = new HashMap<String, Boolean>();
        HashMap<String, Integer> _formStateMap = new HashMap<String, Integer>();
        if (auditUser == null) {
            auditUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        if (auditIdea == null) {
            auditIdea = "";
        }
        int index = 0;
        int batchSize = 200;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FState from T_BG_BgForm where FID IN (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)((String)bgFormIds.get(pos))).toString());
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgFormId = rst.getString(1);
                    _state = rst.getInt(2);
                    _formStateMap.put(_bgFormId, new Integer(_state));
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
        Iterator iter = bgFormIds.iterator();
        while (true) {
            if (!iter.hasNext()) {
                _formStateMap.clear();
                return _batchAuditMap;
            }
            _bgFormId = iter.next().toString();
            try {
                if (_formStateMap.containsKey(_bgFormId)) {
                    _state = (Integer)_formStateMap.get(_bgFormId);
                    if (_state == 1 || _state == 41 || _state == 40 || _state == 14) {
                        this._audit(ctx, BOSUuid.read((String)_bgFormId), auditUser);
                        ibgFormFacade.submitAuditIdea(BOSUuid.read((String)_bgFormId), auditUser, BgAuditIdeaEnum.AUDITPASS, auditIdea);
                        this._writeBgCtrlRecord(ctx, _bgFormId);
                    } else if (_state == 4) {
                        boolean bSuccess = ibgFormFacade.auditFormAdjust(BOSUuid.read((String)_bgFormId));
                        IBgForm ibgform = BgFormFactory.getLocalInstance((Context)ctx);
                        if (ibgform == null) {
                            throw new BgFormException(BgFormException.NOINSTANCE);
                        }
                        if (bSuccess) {
                            ObjectUuidPK pk = new ObjectUuidPK(_bgFormId);
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add("id");
                            sic.add("adjust.id");
                            if (ibgform.exists((IObjectPK)pk)) {
                                BgFormInfo bgAdjustInfo = ibgform.getBgFormInfo((IObjectPK)pk, sic);
                                ibgFormFacade.submitAuditIdea(bgAdjustInfo.getAdjust().getId(), auditUser, BgAuditIdeaEnum.ADJUSTPASS, "");
                            }
                        }
                    }
                    _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                    continue;
                }
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
            catch (Exception ex) {
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _batchUnComfirm(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        try {
            ctx.put((Object)"UN_CONFIRM", (Object)Boolean.TRUE);
            List resList = this._batchAntiAudit(ctx, bgFormIds);
            List successed = (List)resList.get(7);
            if (successed != null && successed.size() > 0) {
                BgCourseCommentInfo info = null;
                ArrayList<BgCourseCommentInfo> tmpList = new ArrayList<BgCourseCommentInfo>();
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                int in = successed.size();
                for (int i = 0; i < in; ++i) {
                    if (!(successed.get(i) instanceof String[])) continue;
                    String[] obj = (String[])successed.get(i);
                    info = new BgCourseCommentInfo();
                    info.setBgFormId(obj[0]);
                    info.setCreator(user);
                    info.setState(BgCourseOperateEnum.UnConfirm);
                    tmpList.add(info);
                }
                BgCourseCommentFactory.getLocalInstance(ctx).batchAddnew(tmpList);
            }
            List list = resList;
            return list;
        }
        finally {
            ctx.remove((Object)"UN_CONFIRM");
        }
    }

    @Override
    protected List _checkBatchAuditGatherCourse(Context ctx, List bgFormIds, String orgUnitId) throws BOSException, EASBizException {
        List reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select f.fid, f.fnumber, s.frootId,s.fid, t.frootId,t.fid from t_bg_bgForm f ");
        sql1.append("left join t_bg_bgTemplate t on t.fid = f.FBgTemplateID ");
        sql1.append("left join t_bg_bgScheme s on s.fid = f.FBgSchemeID ");
        sql1.append("where f.fid in (");
        for (int index = 1; index < batchSize; ++index) {
            sql1.append("?,");
        }
        sql1.append("?)");
        HashMap<String, String> idNumberMap = new HashMap<String, String>();
        ArrayList notPassBgFormIds = new ArrayList();
        notPassBgFormIds.addAll(bgFormIds);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (rst.getString(3).equals(rst.getString(4)) || rst.getString(5).equals(rst.getString(6))) {
                        notPassBgFormIds.remove(rst.getString(1));
                    }
                    idNumberMap.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (!notPassBgFormIds.isEmpty()) {
                throw new BgNFormException(BgNFormException.CANTPROCEEDNOTTOPORG);
            }
            reList = this.findGatherFormIds(ctx, bgFormIds, 40);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    @Override
    protected List _getGatherFormList(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        List rootIds = this.getRootIds(ctx, bgFormIds);
        List returnList = this.getNotReportIds(ctx, rootIds);
        List valueList = null;
        for (int i = returnList.size() - 1; i >= 0; --i) {
            String value1 = String.valueOf(returnList.get(i));
            for (int j = 0; j < bgFormIds.size(); ++j) {
                String value2 = String.valueOf(bgFormIds.get(j));
                if (!value1.equals(value2)) continue;
                returnList.remove(i);
            }
        }
        if (returnList.size() != 0) {
            valueList = this.getNotReportForm(ctx, returnList);
        }
        return valueList;
    }

    private List getNotReportForm(Context ctx, List bgFormIds) throws BOSException {
        ArrayList<BgFormInfo> valueList = new ArrayList<BgFormInfo>();
        String ids = this.getIds(bgFormIds);
        BgFormCollection bgColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection("select number,name,state,orgUnit.displayName,orgUnit.number where id in (" + ids + ") and (state != 40 and state !=15) order by number");
        for (int i = 0; i < bgColl.size(); ++i) {
            BgFormInfo bgInfo = bgColl.get(i);
            valueList.add(bgInfo);
        }
        return valueList;
    }

    private String getIds(List bgFormIds) {
        int i = 0;
        StringBuffer ids = new StringBuffer();
        for (int j = 0; j < bgFormIds.size(); ++j) {
            String id = (String)bgFormIds.get(j);
            ids.append("'" + id + "'");
            if (++i >= bgFormIds.size()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getNotReportIds(Context ctx, List bgFormIds) throws SQLDataException, BgException {
        List returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return returnList;
        }
        int batchSize = 50;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.fid from t_bg_bgForm f ");
        sql.append("join t_bg_bgGatherInfo g on f.fid = g.fsubBgFormId ");
        sql.append(" where g.fBgFormId in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            returnList = this.getNotReportIds(ctx, bgFormIds, conn, sql);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return returnList;
    }

    private List getNotReportIds(Context ctx, List bgFormIds, Connection conn, StringBuffer sql) throws SQLDataException, BgException {
        ArrayList returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty() || conn == null || sql == null) {
            return returnList;
        }
        for (int i = 0; i < bgFormIds.size(); ++i) {
            if (returnList.contains(bgFormIds.get(i))) continue;
            returnList.add(bgFormIds.get(i));
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String bgFormId = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)bgFormIds.get(pos).toString()).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                ArrayList<String> tempList = new ArrayList<String>();
                while (rst.next()) {
                    bgFormId = rst.getString(1);
                    if (!returnList.contains(bgFormId)) {
                        returnList.add(bgFormId);
                    }
                    tempList.add(bgFormId);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (tempList.isEmpty()) continue;
                List tempList2 = this.getNotReportIds(ctx, tempList, conn, sql);
                for (int i = 0; i < tempList2.size(); ++i) {
                    bgFormId = (String)tempList2.get(i);
                    if (returnList.contains(bgFormId)) continue;
                    returnList.add(bgFormId);
                }
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return returnList;
    }

    private List getRootIds(Context ctx, List bgFormIds) throws SQLDataException, BgNFormException, BgException {
        ArrayList reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select f.fid, f.fnumber, s.frootId,s.fid, t.frootId,t.fid from t_bg_bgForm f ");
        sql1.append("left join t_bg_bgTemplate t on t.fid = f.FBgTemplateID ");
        sql1.append("left join t_bg_bgScheme s on s.fid = f.FBgSchemeID ");
        sql1.append("where f.fid in (");
        for (int index = 1; index < batchSize; ++index) {
            sql1.append("?,");
        }
        sql1.append("?)");
        ArrayList<String> rootIds = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!rst.getString(3).equals(rst.getString(4)) && !rst.getString(5).equals(rst.getString(6))) continue;
                    rootIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return rootIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findGatherFormIds(Context ctx, List bgFormIds, int state) throws BOSException, EASBizException {
        List returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return returnList;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            returnList = this.findGatherFormIds(ctx, bgFormIds, state, conn);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return returnList;
    }

    private List findGatherFormIds(Context ctx, List bgFormIds, int state, Connection conn) throws BOSException, EASBizException {
        ArrayList returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty() || conn == null) {
            return returnList;
        }
        for (int i = 0; i < bgFormIds.size(); ++i) {
            if (returnList.contains(bgFormIds.get(i))) continue;
            returnList.add(bgFormIds.get(i));
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.fid from t_bg_bgForm f ");
        sql.append("join t_bg_bgGatherInfo g on f.fid = g.fsubBgFormId ");
        sql.append("where f.fState = " + state);
        sql.append(" and g.fBgFormId in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        String bgFormId = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, BOSUuid.read((String)bgFormIds.get(pos).toString()).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                ArrayList<String> tempList = new ArrayList<String>();
                while (rst.next()) {
                    bgFormId = rst.getString(1);
                    if (!returnList.contains(bgFormId)) {
                        returnList.add(bgFormId);
                    }
                    tempList.add(bgFormId);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (tempList.isEmpty()) continue;
                List tempList2 = this.findGatherFormIds(ctx, tempList, state, conn);
                for (int i = 0; i < tempList2.size(); ++i) {
                    bgFormId = (String)tempList2.get(i);
                    if (returnList.contains(bgFormId)) continue;
                    returnList.add(bgFormId);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List batchAntiAuditGatherCourse(Context ctx, List topBgFormIds) throws BOSException, EASBizException {
        ArrayList reList = new ArrayList();
        if (topBgFormIds == null || topBgFormIds.isEmpty()) {
            return reList;
        }
        List gatherFormIds = this.findGatherFormIds(ctx, topBgFormIds, 2);
        HashSet _bgFormIdSet = new HashSet();
        ArrayList _bgFormIds = new ArrayList();
        _bgFormIds.addAll(gatherFormIds);
        _bgFormIdSet.addAll(gatherFormIds);
        int batchSize = 25;
        int batchIndex = 0;
        int size = _bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IMutexServiceControl imc = null;
        boolean isBasis = BgNSHelper.isStartBasisApproved(ctx);
        int _state = 0;
        int _dataSource = 0;
        String _bgFormId = null;
        String _bgFormName = null;
        String[] _bgFormInfo = null;
        StringBuffer para = null;
        StringBuffer sql = null;
        para = new StringBuffer();
        for (int i = 1; i < batchSize; ++i) {
            para.append("?,");
        }
        para.append("?");
        try {
            String _bgFormNumber;
            conn = this.getConnection(ctx);
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList<String[]> _checkUse = new ArrayList<String[]>();
            ArrayList<String[]> _checkState = new ArrayList<String[]>();
            reList.add(_checkUse);
            reList.add(_checkState);
            sql = new StringBuffer();
            sql.append("SELECT FID, FName, FNumber, FState FROM T_BG_BgForm WHERE FID IN (" + para + ")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            _bgFormId = _bgFormIds.get(pos).toString();
                            pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _bgFormId = rst.getString("FID");
                        _bgFormName = rst.getString("FName");
                        _bgFormNumber = rst.getString("FNumber");
                        if (imc.requestObjIDForUpdate(_bgFormId)) {
                            imc.releaseObjIDForUpdate(_bgFormId);
                            _state = rst.getInt("FState");
                            if (_state == 2 || _state == 3) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkState.add(_bgFormInfo);
                            continue;
                        }
                        _bgFormIdSet.remove(_bgFormId);
                        _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                        _checkUse.add(_bgFormInfo);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                _bgFormIds.clear();
                _bgFormIds.addAll(_bgFormIdSet);
            }
            ArrayList _checkBasis = new ArrayList();
            ArrayList<String[]> _checkAdjust = new ArrayList<String[]>();
            reList.add(_checkAdjust);
            HashMap bgFormNumberMap = new HashMap();
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber, FState, FDataSource, FAdjustId FROM T_BG_BgForm WHERE FAdjustId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FAdjustId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _state = rst.getInt("FState");
                            _dataSource = rst.getInt("FDataSource");
                            if (_state != 4 && _state != 15 || _dataSource != 2 && _dataSource != 5 || bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkAdjust.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkBill = new ArrayList<String[]>();
            reList.add(_checkBill);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT DISTINCT FBgFormId FROM T_BG_BgAdjustBillEntry WHERE FBgFormId IN (" + para + "))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkBill.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkRecord = new ArrayList<String[]>();
            reList.add(_checkRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT t.FID, t.FBgFormId, f.FName, f.FNumber FROM T_BG_BgActualRecord t LEFT JOIN T_BG_BgForm f on t.FBgFormId = f.FID WHERE FBgFormId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FBgFormId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkCtrlRecord = new ArrayList<String[]>();
            reList.add(_checkCtrlRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT d.FBgFormId FROM T_BG_BgData d INNER JOIN T_BG_BgCtrlRecord r on r.FBgDataId = d.FID WHERE d.FBgFormId IN (");
                sql.append(para);
                sql.append(") AND r.fbgtracetype <> 1 group by d.FBgFormId)");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, BOSUuid.read((String)_bgFormId).toString());
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkCtrlRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList _useGather = new ArrayList();
            reList.add(_useGather);
            ArrayList<Object> _succeed = new ArrayList<Object>();
            reList.add(_succeed);
            HashMap bgFormIdsMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (!_bgFormIds.isEmpty()) {
                Iterator iter;
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState<>?");
                String sql2 = "update T_BG_BgData set FBizActual = 0 where FBgFormId = ?";
                PreparedStatement pstmt2 = null;
                String sql3 = "delete from T_BG_BgCtrlRecord where FBillId = ? and FBgTraceType = 1";
                PreparedStatement pstmt3 = null;
                batchIndex = 0;
                int[] sum = null;
                String userId = user.getId().toString();
                java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt2 = conn.prepareStatement(sql2);
                    pstmt3 = conn.prepareStatement(sql3);
                    iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        _succeed.add(_bgFormId);
                        if (topBgFormIds.contains(_bgFormId)) {
                            pstmt.setInt(1, 1);
                        } else {
                            pstmt.setInt(1, 40);
                        }
                        pstmt.setString(2, "");
                        pstmt.setDate(3, null);
                        pstmt.setString(4, BOSUuid.read((String)userId).toString());
                        pstmt.setDate(5, date);
                        pstmt.setString(6, BOSUuid.read((String)_bgFormId).toString());
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        pstmt2.setString(1, BOSUuid.read((String)_bgFormId).toString());
                        pstmt2.addBatch();
                        pstmt3.setString(1, BOSUuid.read((String)_bgFormId).toString());
                        pstmt3.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        sum = pstmt.executeBatch();
                        pstmt2.executeBatch();
                        pstmt3.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        sum = pstmt.executeBatch();
                        pstmt2.executeBatch();
                        pstmt3.executeBatch();
                        batchIndex = 0;
                    }
                    if (sum != null && sum.length > 0) {
                        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, _bgFormIds, (boolean)false);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)ex.getMessage());
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup((Statement)pstmt);
                        SQLUtils.cleanup(pstmt2);
                        SQLUtils.cleanup(pstmt3);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt2);
                SQLUtils.cleanup((Statement)pstmt3);
                if (!_succeed.isEmpty()) {
                    HashSet<Object> idSet = new HashSet<Object>();
                    int in = _succeed.size();
                    for (int i = 0; i < in; ++i) {
                        idSet.add((String)_succeed.get(i));
                    }
                    idSet.add(_succeed);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("number");
                    sic.add("name");
                    view.setSelector(sic);
                    BgFormCollection bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
                    _succeed.clear();
                    for (int i = 0; i < bgFormColl.size(); ++i) {
                        _bgFormInfo = new String[]{bgFormColl.get(i).getId().toString(), bgFormColl.get(i).getName(), bgFormColl.get(i).getNumber()};
                        _succeed.add(_bgFormInfo);
                    }
                }
                batchIndex = 0;
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState=?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        pstmt.setInt(1, 4);
                        pstmt.setString(2, BOSUuid.read((String)userId).toString());
                        pstmt.setDate(3, date);
                        pstmt.setString(4, BOSUuid.read((String)userId).toString());
                        pstmt.setDate(5, date);
                        pstmt.setString(6, BOSUuid.read((String)_bgFormId).toString());
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            if (!bgFormIdsMap.isEmpty()) {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
                BOSUuid auditUser = user.getId();
                Iterator formIt = bgFormIdsMap.keySet().iterator();
                while (formIt.hasNext()) {
                    iBgFormFacade.submitAuditIdea(BOSUuid.read((String)((String)formIt.next())), auditUser, BgAuditIdeaEnum.UNAUDIT, "");
                }
            }
            if (isBasis) {
                reList.add(_checkBasis);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List batchAntiAuditSubOrgForm(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        Object object = ctx.get((Object)"UN_CONFIRM");
        boolean isBatchUnConfirm = false;
        if (object instanceof Boolean) {
            isBatchUnConfirm = (Boolean)object;
        }
        ArrayList reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        HashSet _bgFormIdSet = new HashSet();
        ArrayList _bgFormIds = new ArrayList();
        _bgFormIds.addAll(bgFormIds);
        _bgFormIdSet.addAll(bgFormIds);
        int batchSize = 25;
        int batchIndex = 0;
        int size = _bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IMutexServiceControl imc = null;
        boolean isBasis = BgNSHelper.isStartBasisApproved(ctx);
        int _state = 0;
        int _dataSource = 0;
        String _bgFormId = null;
        String _bgFormName = null;
        String[] _bgFormInfo = null;
        StringBuffer para = null;
        StringBuffer sql = null;
        para = new StringBuffer();
        for (int i = 1; i < batchSize; ++i) {
            para.append("?,");
        }
        para.append("?");
        try {
            String _bgFormNumber;
            conn = this.getConnection(ctx);
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList<String[]> _checkUse = new ArrayList<String[]>();
            ArrayList<String[]> _checkState = new ArrayList<String[]>();
            reList.add(_checkUse);
            reList.add(_checkState);
            sql = new StringBuffer();
            sql.append("SELECT FID, FName, FNumber, FState FROM T_BG_BgForm WHERE FID IN (" + para + ")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            _bgFormId = _bgFormIds.get(pos).toString();
                            pstmt.setString(x, _bgFormId);
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _bgFormId = rst.getString("FID");
                        _bgFormName = rst.getString("FName");
                        _bgFormNumber = rst.getString("FNumber");
                        if (imc.requestObjIDForUpdate(_bgFormId)) {
                            imc.releaseObjIDForUpdate(_bgFormId);
                            _state = rst.getInt("FState");
                            if (_state == 2 || _state == 3) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkState.add(_bgFormInfo);
                            continue;
                        }
                        _bgFormIdSet.remove(_bgFormId);
                        _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                        _checkUse.add(_bgFormInfo);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                _bgFormIds.clear();
                _bgFormIds.addAll(_bgFormIdSet);
            }
            ArrayList<String[]> _checkBasis = new ArrayList<String[]>();
            if (!_bgFormIds.isEmpty() && isBasis && !isBatchUnConfirm) {
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE (FCertificateUserId is not null or FIsConfirm = 1 ) and FState = 2 and FID IN (" + para + ")");
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkBasis.add(_bgFormInfo);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkAdjust = new ArrayList<String[]>();
            reList.add(_checkAdjust);
            HashMap bgFormNumberMap = new HashMap();
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber, FState, FDataSource, FAdjustId FROM T_BG_BgForm WHERE FAdjustId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FAdjustId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _state = rst.getInt("FState");
                            _dataSource = rst.getInt("FDataSource");
                            if (_state != 4 && _state != 15 || _dataSource != 2 && _dataSource != 5 || bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkAdjust.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkBill = new ArrayList<String[]>();
            reList.add(_checkBill);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT DISTINCT FBgFormId FROM T_BG_BgAdjustBillEntry WHERE FBgFormId IN (" + para + "))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkBill.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkRecord = new ArrayList<String[]>();
            reList.add(_checkRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT t.FID, t.FBgFormId, f.FName, f.FNumber FROM T_BG_BgActualRecord t LEFT JOIN T_BG_BgForm f on t.FBgFormId = f.FID WHERE FBgFormId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FBgFormId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _checkCtrlRecord = new ArrayList<String[]>();
            reList.add(_checkCtrlRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm WHERE FID IN (SELECT d.FBgFormId FROM T_BG_BgData d INNER JOIN T_BG_BgCtrlRecord r on r.FBgDataId = d.FID WHERE d.FBgFormId IN (");
                sql.append(para);
                sql.append(") AND r.fbgtracetype <> 1 group by d.FBgFormId)");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkCtrlRecord.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<String[]> _useGather = new ArrayList<String[]>();
            reList.add(_useGather);
            if (!_bgFormIds.isEmpty() && !BgNSHelper.isBeforeAntiAuditCheckGatherInfo(ctx)) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber FROM T_BG_BgForm ").append("WHERE FID IN (").append("SELECT DISTINCT FSubBgFormId from T_BG_BgGatherInfo ").append("WHERE FSubBgFormId IN (").append(para).append("))");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = _bgFormIds.get(pos).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FID");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormNumberMap.containsKey(_bgFormNumber)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _useGather.add(_bgFormInfo);
                            bgFormNumberMap.put(_bgFormNumber, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList<Object> _succeed = new ArrayList<Object>();
            reList.add(_succeed);
            HashMap bgFormIdsMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (!_bgFormIds.isEmpty()) {
                Iterator iter;
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState<>?");
                batchIndex = 0;
                int[] sum = null;
                String userId = user.getId().toString();
                java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        _succeed.add(_bgFormId);
                        pstmt.setInt(1, 1);
                        pstmt.setString(2, userId);
                        pstmt.setDate(3, date);
                        pstmt.setString(4, userId);
                        pstmt.setDate(5, date);
                        pstmt.setString(6, _bgFormId);
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        sum = pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        sum = pstmt.executeBatch();
                    }
                    if (sum != null && sum.length > 0) {
                        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet((Context)ctx, _bgFormIds, (boolean)false);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (!_succeed.isEmpty()) {
                    HashSet<String> idSet = new HashSet<String>();
                    int in = _succeed.size();
                    for (int i = 0; i < in; ++i) {
                        idSet.add((String)_succeed.get(i));
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("number");
                    sic.add("name");
                    view.setSelector(sic);
                    BgFormCollection bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
                    _succeed.clear();
                    for (int i = 0; i < bgFormColl.size(); ++i) {
                        _bgFormInfo = new String[]{bgFormColl.get(i).getId().toString(), bgFormColl.get(i).getName(), bgFormColl.get(i).getNumber()};
                        _succeed.add(_bgFormInfo);
                    }
                }
                batchIndex = 0;
                sql = new StringBuffer();
                sql.append("update T_BG_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState=?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        pstmt.setInt(1, 4);
                        pstmt.setString(2, userId);
                        pstmt.setDate(3, date);
                        pstmt.setString(4, userId);
                        pstmt.setDate(5, date);
                        pstmt.setString(6, _bgFormId);
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            if (!bgFormIdsMap.isEmpty()) {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance((Context)ctx);
                BOSUuid auditUser = user.getId();
                Iterator formIt = bgFormIdsMap.keySet().iterator();
                while (formIt.hasNext()) {
                    iBgFormFacade.submitAuditIdea(BOSUuid.read((String)((String)formIt.next())), auditUser, BgAuditIdeaEnum.UNAUDIT, "");
                }
            }
            if (isBasis && !isBatchUnConfirm) {
                reList.add(_checkBasis);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void MakeHistory(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            IBgForm ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = null;
            BgFormInfo bgFormInfo = null;
            conn = this.getConnection(ctx);
            for (int i = 0; i < bgFormIds.size(); ++i) {
                String StrBgFormId = bgFormIds.get(i).toString();
                BOSUuid bgFormId = BOSUuid.read((String)StrBgFormId);
                pk = new ObjectUuidPK(bgFormId);
                bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk);
                this._cloneCollect(ctx, bgFormId, BgFormDataSourceEnum.APPROVE, BgFormStateEnum.History, bgFormInfo);
                SQLUtils.execute((Connection)conn, (String)("Update T_BG_BgForm set FVersionNo = FVersionNo + " + BgConstants.NextVer.toString() + " where FID = '" + bgFormId.toString() + "'"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"Error: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    protected IObjectPK _cloneCollect(Context ctx, BOSUuid id, BgFormDataSourceEnum dataSource, BgFormStateEnum state, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        IBgForm ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
        IObjectPK npk = null;
        BgFormInfo cloneInfo = null;
        cloneInfo = bgFormInfo.deepclone();
        if (dataSource != null) {
            cloneInfo.setDataSource(dataSource);
        }
        if (state != null) {
            cloneInfo.setState(state);
        }
        cloneInfo.setStartDate(bgFormInfo.getStartDate());
        cloneInfo.setEndDate(bgFormInfo.getEndDate());
        cloneInfo.setAdjust(bgFormInfo);
        cloneInfo.setAdjustMapData(null);
        cloneInfo.setVersionNo(bgFormInfo.getVersionNo());
        cloneInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        npk = ibgForm.addnew((CoreBaseInfo)cloneInfo);
        return npk;
    }

    private List[] queryGatherBgFormIdsAndCheckCanBack(Context ctx, List bgFormIds) throws EASBizException, BOSException {
        List[] returnList = new List[2];
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return returnList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select s.fid s_fid,s.fnumber s_fnumber,p.fid p_fid,p.fstate p_fstate ").append("from t_bg_bgform s ").append("left join t_bg_bgGatherInfo g on g.FSubBgFormId=s.fid ").append("left join t_bg_bgform p on p.fid=g.fbgformid ").append("where s.fid in(");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            returnList = this.doCheckGatherBgForm(pstmt, bgFormIds.toArray());
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List[] doCheckGatherBgForm(PreparedStatement pstmt, Object[] bgFormIds) throws SQLException {
        List[] subRes;
        List[] returnList = new List[2];
        if (pstmt == null || bgFormIds == null || bgFormIds.length == 0) {
            return returnList;
        }
        returnList[0] = new ArrayList();
        returnList[1] = new ArrayList();
        ResultSet res = null;
        HashSet<String> gatherFormIds = new HashSet<String>();
        try {
            String gatherBgFormId = null;
            String bgFormId = null;
            int gatherState = 0;
            String bgFormNumber = null;
            int size = bgFormIds.length;
            int count = (size - 1) / 200 + 1;
            for (int index = 0; index < count; ++index) {
                BgNSQLHelper.setParam4Batch(pstmt, index, 200, bgFormIds);
                res = pstmt.executeQuery();
                while (res.next()) {
                    bgFormId = res.getString("s_fid");
                    gatherBgFormId = res.getString("p_fid");
                    if (StringUtils.isEmpty((String)gatherBgFormId)) {
                        if (returnList[0].contains(bgFormId)) continue;
                        returnList[0].add(bgFormId);
                        continue;
                    }
                    gatherState = res.getInt("p_fstate");
                    if (gatherState == 3 || gatherState == 40 || gatherState == 25 || gatherState == 14) {
                        bgFormNumber = res.getString("s_fnumber");
                        if (returnList[1].contains(bgFormNumber)) continue;
                        returnList[1].add(bgFormNumber);
                        continue;
                    }
                    if (!returnList[0].contains(bgFormId)) {
                        returnList[0].add(bgFormId);
                    }
                    gatherFormIds.add(gatherBgFormId);
                }
            }
        }
        finally {
            SQLUtils.cleanup(res);
        }
        if (!gatherFormIds.isEmpty() && (subRes = this.doCheckGatherBgForm(pstmt, gatherFormIds.toArray())) != null) {
            if (subRes[0] != null && !subRes[0].isEmpty()) {
                for (int i = 0; i < subRes[0].size(); ++i) {
                    if (returnList[0].contains(subRes[0].get(i))) continue;
                    returnList[0].add(subRes[0].get(i));
                }
            }
            if (subRes[1] != null && !subRes[1].isEmpty()) {
                for (int i = 0; i < subRes[1].size(); ++i) {
                    if (returnList[1].contains(subRes[1].get(i))) continue;
                    returnList[1].add(subRes[1].get(i));
                }
            }
        }
        return returnList;
    }

    @Override
    protected Map _checkBackBgForm(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        List[] resList = this.queryGatherBgFormIdsAndCheckCanBack(ctx, bgFormIds);
        HashMap<String, List> resMap = new HashMap<String, List>();
        if (resList != null) {
            resMap.put("back_can", resList[0]);
        }
        return resMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _loadBudgetData(Context ctx, BOSUuid bgFormID) throws BOSException, EASBizException {
        BigDecimal value;
        int colIndex;
        int rowIndex;
        int colCount;
        int rowCount;
        String formula;
        Cell cell;
        Sheet sheet;
        Book book;
        BgFormInfo bgFormInfo;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        HashMap<String, BigDecimal> AValueMap;
        HashMap<String, BigDecimal> bValueMap;
        block13: {
            bValueMap = new HashMap<String, BigDecimal>();
            AValueMap = new HashMap<String, BigDecimal>();
            conn = null;
            ps = null;
            rs = null;
            bgFormInfo = null;
            book = null;
            sheet = null;
            cell = null;
            formula = null;
            rowCount = 0;
            colCount = 0;
            rowIndex = 0;
            colIndex = 0;
            value = null;
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement("select FFormula, FBgValue, FBizActual from T_BG_BgData where FBgFormId = ?");
            ps.setString(1, bgFormID.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                formula = rs.getString(1);
                bValueMap.put(formula, rs.getBigDecimal(2));
                AValueMap.put(formula, rs.getBigDecimal(3));
            }
            bgFormInfo = BgInfoHelper.getBgFormInfo(conn, bgFormID, true);
            if (bgFormInfo != null && bgFormInfo.getBook() != null) break block13;
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return;
        }
        try {
            book = bgFormInfo.getBook();
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            int sheetIndex = 0;
            int sheetCount = book.getSheetCount();
            while (true) {
                if (sheetIndex < sheetCount) {
                    sheet = book.getSheet(sheetIndex);
                    rowCount = sheet.getMaxRowIndex();
                    colCount = sheet.getMaxColIndex();
                } else {
                    bgFormInfo.setBook(book);
                    BgFormFactory.getLocalInstance((Context)ctx).updateValue((IObjectValue)bgFormInfo);
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                    return;
                }
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        boolean hasFormula = BgNFSHelper.checkHasFormulaOfCell(cell);
                        if (!hasFormula) continue;
                        formula = BgNFSHelper.getFormulaOfCell(cell);
                        if (bValueMap.containsKey(formula)) {
                            value = (BigDecimal)bValueMap.get(formula);
                            BgNFSHelper.setValue(cell, value);
                            BgNFSHelper.setBudgetValue(cell, value);
                        }
                        if (!AValueMap.containsKey(formula)) continue;
                        value = (BigDecimal)AValueMap.get(formula);
                        BgNFSHelper.setActualValue(cell, value);
                    }
                }
                ++sheetIndex;
            }
        }
        catch (BOSException be) {
            try {
                logger.error((Object)be);
                throw be;
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
    }

    @Override
    protected Map _getAttachMentByBgFormIDS(Context ctx, List IDList) throws BOSException, EASBizException {
        if (IDList == null || IDList.isEmpty()) {
            return null;
        }
        HashMap<String, Boolean> attchMap = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer("select distinct FBoID from T_BAS_BoAttchAsso where FBoID in (");
        int batch_size = 250;
        for (int i = 1; i < batch_size; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pos = 0;
            size = IDList.size();
            count = (size - 1) / batch_size + 1;
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batch_size) {
                    if (pos < size) {
                        pstmt.setString(x, (String)IDList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    attchMap.put(rst.getString("FBoID"), Boolean.TRUE);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return attchMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _courseWorkFlow(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        boolean isStartBasisApproved = BgNSHelper.isStartBasisApproved(ctx);
        String _bgFormId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        Object _orgUnitMap = null;
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        BgFormInfo bgFormInfo = new BgFormInfo();
        BgFormStateEnum stateEnum = BgFormStateEnum.Edited;
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        if (isStartBasisApproved) {
            stateEnum = BgFormStateEnum.BasisApproved;
        }
        if (!(_bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, stateEnum, false)).isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsSet.add(_bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement psInst = null;
        PreparedStatement pstCau = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer cause = new StringBuffer();
        sql.append("insert into T_BG_BgCourseData(FID, FBValue, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgValue, FBgFormId, FFormula, '" + _userId + "' , ").append("NOW(), '" + _userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        cause.append("insert into T_BG_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgFormId, FFormula, '" + _userId + "' , ").append("NOW(), '" + _userId + "', NOW() ").append("from T_BG_BgData bgdata where FBgFormId = ? and ").append("(select count(fid) from T_BG_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        IObjectPK pk = null;
        try {
            int i;
            int in;
            if (!_pBgFormInfos.isEmpty()) {
                in = _pBgFormInfos.size();
                for (i = 0; i < in; ++i) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i);
                    logs.append(_bgFormStr[2]).append(",");
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgForm_course", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgForm_course");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FState = ?, FCourseOrgId = ?, FCourseUserId = ?, FCourseTime = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            psInst = conn.prepareStatement(sql.toString());
            pstCau = conn.prepareStatement(cause.toString());
            in = bgFormIds.size();
            for (i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i).toString();
                if (_bgFormIdsSet.contains(_bgFormId)) continue;
                _tmpList.add(_bgFormId);
                pstmt.setInt(1, 40);
                pstmt.setString(2, "00000000-0000-0000-0000-000000000000CCE7AED4");
                pstmt.setString(3, _userId);
                pstmt.setTimestamp(4, _timestamp);
                pstmt.setString(5, _userId);
                pstmt.setTimestamp(6, _timestamp);
                pstmt.setString(7, _bgFormId);
                if (isStartBasisApproved) {
                    pstmt.setInt(8, 3);
                } else {
                    pstmt.setInt(8, 1);
                }
                pstmt.addBatch();
                psInst.setString(1, _bgFormId);
                psInst.setString(2, _bgFormId);
                psInst.executeUpdate();
                pstCau.setString(1, _bgFormId);
                pstCau.setString(2, _bgFormId);
                pstCau.executeUpdate();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            this.updateOperateInfo(ctx, _tmpList, _userId, 1);
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstCau);
                SQLUtils.cleanup(psInst);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstCau);
        SQLUtils.cleanup((Statement)psInst);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        return _reList;
    }

    @Override
    protected List _getAccountBizCostCenterNumber(Context ctx, String sql) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] array = null;
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (result.next()) {
                array = new String[]{result.getString(1), result.getString(2)};
                list.add(array);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected void _batchSaveGatherForView(Context ctx, CoreBaseCollection bgForms) throws BOSException, EASBizException {
        BgFormFactory.getLocalInstance((Context)ctx).save(bgForms);
        BgFormInfo bgform2 = null;
        Book book = null;
        for (BgFormInfo bgform2 : bgForms) {
            try {
                book = bgform2.getBook();
            }
            catch (Exception e) {
                throw new BgException(BgException.UNSERIALIZABLEERROR, (Object[])new String[]{e.getMessage()});
            }
            if (book == null) continue;
            this.saveGatherInfo(ctx, bgform2, book);
        }
    }

    @Override
    protected void _batchReportCalculate(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        int in = bgFormIds.size();
        for (int i = 0; i < in; ++i) {
            String bgFormId = (String)bgFormIds.get(i);
            this.reportCalculate(ctx, bgFormId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCalculate(Context ctx, String bgFormId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin calculator report!");
        IMutexServiceControl imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            if (imc.requestObjIDForUpdate(bgFormId)) {
                BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
                byte[] _bytes = ReportFactory.getLocalInstance((Context)ctx).backCacl((IObjectValue)bgFormInfo, bgFormInfo.getZipData());
                if (_bytes != null && _bytes.length > 0) {
                    bgFormInfo.setZipData(_bytes);
                    this.updateReportData(ctx, bgFormInfo);
                    this._updateReportInfo(ctx, (IObjectValue)bgFormInfo);
                }
            }
        }
        finally {
            imc.releaseObjIDForUpdate(bgFormId);
        }
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end calculator report!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReportData(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        block44: {
            if (ctx == null || bgFormInfo == null) {
                return;
            }
            Book book = null;
            Sheet sheet = null;
            Cell cell = null;
            Object obj = null;
            String formulaStr = null;
            BigDecimal value = null;
            BgNDataInfo dataInfo = null;
            Map formulaMap = null;
            HashMap adjustMap = null;
            HashMap<String, BigDecimal> updateMap = new HashMap<String, BigDecimal>();
            int state = bgFormInfo.getState().getValue();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            try {
                formulaMap = this.queryBgFormula(ctx, bgFormInfo.getId());
                if (state == 4) {
                    InputStream is = null;
                    ObjectInputStream ois = null;
                    byte[] _adjBytes = bgFormInfo.getAdjustMapData();
                    if (_adjBytes != null && _adjBytes.length > 0) {
                        try {
                            is = ZipUtil.unpack((byte[])_adjBytes);
                            ois = new ObjectInputStream(is);
                            adjustMap = (HashMap)ois.readObject();
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (ois != null) {
                                    ois.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (adjustMap == null) {
                        adjustMap = new HashMap();
                    }
                }
                book = bgFormInfo.getBook();
                BgNFSHelper.disableCal(book);
                BgNFSHelper.disableUndo(book);
                int in = book.getSheetCount();
                for (int i = 0; i < in; ++i) {
                    sheet = book.getSheet(i);
                    int rowCount = sheet.getMaxRowIndex();
                    int colCount = sheet.getMaxColIndex();
                    for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                            cell = sheet.getCell(rowIndex, colIndex, false);
                            if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                            formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            obj = BgNFSHelper.getValue(cell);
                            if (obj instanceof BigDecimal) {
                                value = (BigDecimal)obj;
                            } else {
                                try {
                                    value = new BigDecimal(obj.toString());
                                }
                                catch (Exception ex) {
                                    value = BgNConstants.ZERO;
                                }
                            }
                            if (formulaMap.containsKey(formulaStr)) {
                                dataInfo = (BgNDataInfo)formulaMap.get(formulaStr);
                                if (value.compareTo(dataInfo.getBudgetValue()) == 0) continue;
                                updateMap.put(formulaStr, value);
                                if (adjustMap == null) continue;
                                BgFormDiversityData divData = null;
                                if (adjustMap.containsKey(formulaStr)) {
                                    divData = (BgFormDiversityData)adjustMap.get(formulaStr);
                                    if (value.compareTo(divData.getOldValue()) == 0) {
                                        adjustMap.remove(formulaStr);
                                        BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
                                        continue;
                                    }
                                    divData.setNewValue(value);
                                    divData.setAdjustor(userId);
                                    divData.setAdjustTime((Date)time);
                                    continue;
                                }
                                divData = new BgFormDiversityData();
                                divData.setNewValue(value);
                                divData.setOldValue(dataInfo.getBudgetValue());
                                divData.setAdjustor(userId);
                                divData.setAdjustTime((Date)time);
                                adjustMap.put(formulaStr, divData);
                                BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
                                continue;
                            }
                            updateMap.put(formulaStr, value);
                        }
                    }
                }
                if (!updateMap.isEmpty()) {
                    this.updateBgData(ctx, bgFormInfo, updateMap);
                }
                if (state != 4) break block44;
                if (adjustMap == null || adjustMap.isEmpty()) {
                    bgFormInfo.setAdjustMapData(null);
                    break block44;
                }
                ByteArrayOutputStream baos = null;
                ObjectOutputStream oos = null;
                try {
                    baos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(adjustMap);
                    bgFormInfo.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
                }
                finally {
                    if (baos != null) {
                        baos.close();
                    }
                    if (oos != null) {
                        oos.close();
                    }
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{ex.getMessage()});
            }
        }
    }

    @Override
    public void _saveBgData(Context ctx, IObjectValue _bgFormInfo, Map adjustMap, Map initValueMap) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        if (!(_bgFormInfo instanceof BgFormInfo)) {
            return;
        }
        if (adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        if (initValueMap == null) {
            initValueMap = new HashMap();
        }
        BgFormInfo bgFormInfo = (BgFormInfo)_bgFormInfo;
        BgDataHelper _helper = new BgDataHelper();
        HashMap<String, BgFormDiversityData> addDataMap = new HashMap<String, BgFormDiversityData>();
        HashMap<String, BigDecimal> updateDataMap = new HashMap<String, BigDecimal>();
        Map _schemeDataMap = _helper.getImpl().querySchemeData(ctx, bgFormInfo.getOrgUnit().toString(), bgFormInfo.getBgScheme().getId().toString());
        if (adjustMap != null) {
            String formulaStr = "";
            Object divDataObj = null;
            BgFormDiversityData divData = null;
            Iterator iterator = adjustMap.keySet().iterator();
            while (iterator.hasNext()) {
                formulaStr = iterator.next().toString();
                divDataObj = adjustMap.get(formulaStr);
                if (!(divDataObj instanceof BgFormDiversityData)) continue;
                divData = divDataObj;
                if (initValueMap.containsKey(formulaStr)) {
                    updateDataMap.put(divData.getFormula(), divData.getNewValue());
                    continue;
                }
                if (_schemeDataMap.containsKey(formulaStr)) {
                    updateDataMap.put(divData.getFormula(), divData.getNewValue());
                    continue;
                }
                addDataMap.put(divData.getFormula(), divData);
            }
        }
        if (addDataMap.size() > 0) {
            this.addBgData(ctx, _helper, bgFormInfo, addDataMap);
        }
        if (updateDataMap.size() > 0) {
            this.updateBgData(ctx, bgFormInfo, updateDataMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBgData(Context ctx, BgDataHelper _helper, BgFormInfo bgFormInfo, Map addMap) throws BOSException, EASBizException {
        boolean isAdjust;
        boolean bl = isAdjust = bgFormInfo.getState().getValue() == 4;
        if (isAdjust) {
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                String[] formulaInfo = BgFacadeHelper.checkFormulaIsEctype(conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getAdjust().getId(), new ArrayList(addMap.keySet()));
                if (formulaInfo != null) {
                    throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, (Object[])new String[]{"", formulaInfo[0].replaceAll(",\"BgData\",true", ""), formulaInfo[1]});
                }
                BgNAdjHelper.insertTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getAdjust().getId(), addMap);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        IBgCtrSettingFacade ibgCtrSettingFacade = BgCtrSettingFacadeFactory.getLocalInstance((Context)ctx);
        Hashtable defCtrlMode = ibgCtrSettingFacade.getDefCtrlSetByTemplateID(bgFormInfo.getBgTemplate().getId().toString());
        Map ctrlMap = ibgCtrSettingFacade.getBgFormCtrlModeMap(bgFormInfo.getId());
        HashMap<String, BgNDataInfo> _addMap = new HashMap<String, BgNDataInfo>();
        for (Map.Entry entry : addMap.entrySet()) {
            BgNDataInfo _dataInfo = _helper.buildBgNDataInfo(bgFormInfo, (String)entry.getKey(), ((BgFormDiversityData)entry.getValue()).getNewValue(), BgNConstants.ZERO, BgNConstants.ZERO, (Map)ctrlMap.get((String)entry.getKey()), defCtrlMode);
            if (_dataInfo == null) continue;
            _addMap.put((String)entry.getKey(), _dataInfo);
        }
        try {
            _helper.checkFormulaIsEctype(ctx, bgFormInfo, new Object[]{_addMap});
        }
        catch (Exception e) {
            logger.error((Object)"checkFormulaIsEctype:", (Throwable)e);
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{e.getMessage()});
        }
        _helper.getImpl().addNewBgDataValue(ctx, bgFormInfo, _addMap);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBgData(Context ctx, BgFormInfo bgFormInfo, Map updateMap) throws BgFormException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        sql = bgFormInfo.getState().getValue() == 4 ? "update T_BG_BgTmpData set FBgValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?" : "update T_BG_BgData set FBgValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?";
        int batchSize = 100;
        int batchIndex = 0;
        String _orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String _bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (Map.Entry entry : updateMap.entrySet()) {
                pstmt.setBigDecimal(1, (BigDecimal)entry.getValue());
                pstmt.setString(2, _orgUnitId);
                pstmt.setString(3, _bgSchemeId);
                pstmt.setString(4, (String)entry.getKey());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLDataException e) {
            try {
                logger.error((Object)"bgForm calculator save:", (Throwable)e);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
                catch (SQLException e2) {
                    logger.error((Object)"bgForm calculator save:", (Throwable)e2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private Map queryBgFormula(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        HashMap<String, BgNDataInfo> _dataMap = new HashMap<String, BgNDataInfo>();
        if (ctx == null || bgFormId == null) {
            return _dataMap;
        }
        BgNDataInfo _dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FFormula, FBgValue, FBgActual from T_BG_BgData where FBgFormId = ?");
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _dataInfo = new BgNDataInfo();
                _dataInfo.setFormula(rst.getString("FFormula"));
                _dataInfo.setBudgetValue(rst.getBigDecimal("FBgValue"));
                _dataInfo.setActualValue(rst.getBigDecimal("FBgActual"));
                _dataMap.put(_dataInfo.getFormula(), _dataInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _updateReportInfo(Context ctx, IObjectValue _bgFormInfo) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (!(_bgFormInfo instanceof BgFormInfo)) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BgFormInfo bgFormInfo = (BgFormInfo)_bgFormInfo;
        String _bgFormId = bgFormInfo.getId().toString();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgForm set FData = ? where FID = ?");
            BgInfoHelper.setBytes(pstmt, 1, bgFormInfo.getZipData());
            pstmt.setString(2, _bgFormId);
            pstmt.executeUpdate();
            int state = bgFormInfo.getState().getValue();
            byte[] _bytes = bgFormInfo.getAdjustMapData();
            if (state == 4 && _bytes != null && _bytes.length > 0) {
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement("update T_BG_BgForm set FAdjustMapData = ? where FID = ?");
                BgInfoHelper.setBytes(pstmt, 1, bgFormInfo.getAdjustMapData());
                pstmt.setString(2, _bgFormId);
                pstmt.executeUpdate();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"bgForm calculator save:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String[] _getExecuteInfo(Context ctx, String[] parameter) throws BOSException, EASBizException {
        if (parameter == null) {
            return null;
        }
        String[] _tmpStr = new String[6];
        if (!StringUtils.isEmpty((String)parameter[1])) {
            IRowSet rst = null;
            try {
                String paramTmp1 = parameter[1];
                String[] param1 = paramTmp1.split(";");
                StringBuffer sql = new StringBuffer("select FID, FName_" + ctx.getLocale() + ", FNumber from T_ORG_CostCenter where FNumber in (");
                for (int i = 0; i < param1.length; ++i) {
                    sql.append("'" + param1[i] + "'");
                    if (i == param1.length - 1) break;
                    sql.append(",");
                }
                sql.append(")");
                rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rst.next()) {
                    _tmpStr[0] = rst.getString(1);
                    _tmpStr[1] = rst.getString(2);
                    _tmpStr[2] = rst.getString(3);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"error", (Throwable)ex);
                    logger.error((Object)parameter);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!StringUtils.isEmpty((String)parameter[2])) {
                try {
                    rst = DbUtil.executeQuery((Context)ctx, (String)"select FNumber, FRootID from T_BG_BgScheme where FOrgUnitId = ? and FNumber = ?", (Object[])new String[]{_tmpStr[0], parameter[2]});
                    if (rst.next()) {
                        _tmpStr[3] = rst.getString(1);
                        _tmpStr[4] = rst.getString(2);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"error", (Throwable)ex);
                    logger.error((Object)parameter);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        return _tmpStr;
    }
}

