/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgAutoEnurameHelper;
import com.kingdee.eas.ma.nbudget.BgExpressionsItemVariableHelper;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.AbstractBgNTemplateFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNTemplateFacadeControllerBean
extends AbstractBgNTemplateFacadeControllerBean {
    private static final long serialVersionUID = 5152903371544987385L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgNTemplateFacadeControllerBean");

    @Override
    protected Object _changeTemFormType(Context ctx, Map temIds, BgTemFormTypeEnum temFormType) throws BOSException, EASBizException {
        if (temIds == null || temIds.isEmpty() || temFormType == null) {
            return null;
        }
        String id = null;
        Connection conn = null;
        PreparedStatement temPst = null;
        PreparedStatement formPst = null;
        StringBuffer temSql = new StringBuffer();
        StringBuffer formSql = new StringBuffer();
        ResultSet rs = null;
        String msg = "";
        try {
            conn = this.getConnection(ctx);
            formSql.append("select fid from t_bg_bgform where fbgtemplateid in ( select fid from t_bg_bgtemplate where frootId = ? ) and fstate not in (2 , 5 , 1 , 15)");
            temSql.append("update t_bg_bgTemplate set FFormType = ? , fisChangeType = 1 where frootid = ? and fformType = ? ");
            temPst = conn.prepareStatement(temSql.toString());
            formPst = conn.prepareStatement(formSql.toString());
            Iterator ite = temIds.keySet().iterator();
            while (ite.hasNext()) {
                id = ite.next().toString();
                formPst.setString(1, id);
                rs = formPst.executeQuery();
                if (rs.next()) {
                    msg = msg + temIds.get(id).toString() + ",";
                    SQLUtils.cleanup((ResultSet)rs);
                    ite.remove();
                    continue;
                }
                SQLUtils.cleanup((ResultSet)rs);
                temPst.setInt(1, temFormType.getValue());
                temPst.setString(2, id);
                if (temFormType.getValue() == 0) {
                    temPst.setInt(3, 1);
                }
                if (temFormType.getValue() == 1) {
                    temPst.setInt(3, 0);
                }
                temPst.addBatch();
            }
            temPst.executeBatch();
            if (!temIds.isEmpty() && temFormType.getValue() == 0) {
                this.updateAllTemAndForm(ctx, temIds);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException("BgNTemplateFacadeControllerBean _changeTemFormType");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, formPst);
                SQLUtils.cleanup(temPst);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)formPst);
        SQLUtils.cleanup((Statement)temPst);
        SQLUtils.cleanup((Connection)conn);
        return msg;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateAllTemAndForm(Context ctx, Map temIds) throws BOSException, EASBizException {
        String temSql = "select fid, fdata ,fbgtypeid from t_bg_bgtemplate where frootid = ? and fformType = ?  ";
        String formSql = "Select bgform.fid, bgform.Fdata ,bgtemp.fbgtypeid from t_bg_bgform bgform,t_bg_bgtemplate bgtemp where bgform.fbgtemplateid=bgtemp.fid and  bgtemp.frootid = ? and bgtemp.fformType = ?  and bgform.fstate not in (2 , 5 , 15)";
        String temUp = "update t_bg_bgtemplate set fdata = ? where fid = ?";
        String formUP = "update t_bg_bgform set fdata = ? where fid = ?";
        Connection conn = null;
        PreparedStatement temPst = null;
        PreparedStatement formPst = null;
        PreparedStatement temUpPst = null;
        PreparedStatement formUpPst = null;
        ResultSet rs = null;
        String id = null;
        try {
            conn = this.getConnection(ctx);
            temPst = conn.prepareStatement(temSql.toString());
            formPst = conn.prepareStatement(formSql.toString());
            temUpPst = conn.prepareStatement(temUp.toString());
            formUpPst = conn.prepareStatement(formUP.toString());
            int i = 0;
            int n = 50;
            String upID = null;
            byte[] data = null;
            Book cBook = null;
            String bgtypeid = null;
            Iterator ite = temIds.keySet().iterator();
            while (ite.hasNext()) {
                id = ite.next().toString();
                formPst.setString(1, BOSUuid.read((String)id).toString());
                formPst.setInt(2, 0);
                rs = formPst.executeQuery();
                while (rs.next()) {
                    upID = rs.getString(1);
                    data = BgInfoHelper.getBytes(rs, 2);
                    cBook = IOHelper.unpackBook((byte[])data);
                    bgtypeid = rs.getString(3);
                    this.clearBook(cBook);
                    if ("BV/FQwEUEADgABtLwKgSXv9s2OA=".equalsIgnoreCase(bgtypeid)) {
                        BgExpressionsItemVariableHelper.batchRemoveUserObject(cBook);
                    } else {
                        BgAutoEnurameHelper.batchRemoveUserObject(cBook);
                    }
                    data = IOHelper.packBook((Book)cBook);
                    formUpPst.setString(2, BOSUuid.read((String)upID).toString());
                    formUpPst.setBytes(1, data);
                    formUpPst.addBatch();
                    if (++i != n) continue;
                    formUpPst.executeBatch();
                    formUpPst.clearBatch();
                    i = 0;
                }
                formUpPst.executeBatch();
                SQLUtils.cleanup((ResultSet)rs);
                temPst.setString(1, BOSUuid.read((String)id).toString());
                temPst.setInt(2, 0);
                rs = temPst.executeQuery();
                while (rs.next()) {
                    upID = rs.getString(1);
                    data = BgInfoHelper.getBytes(rs, 2);
                    cBook = IOHelper.unpackBook((byte[])data);
                    bgtypeid = rs.getString(3);
                    this.clearBook(cBook);
                    if ("BV/FQwEUEADgABtLwKgSXv9s2OA=".equalsIgnoreCase(bgtypeid)) {
                        BgExpressionsItemVariableHelper.batchRemoveUserObject(cBook);
                    } else {
                        BgAutoEnurameHelper.batchRemoveUserObject(cBook);
                    }
                    data = IOHelper.packBook((Book)cBook);
                    temUpPst.setString(2, BOSUuid.read((String)upID).toString());
                    temUpPst.setBytes(1, data);
                    temUpPst.addBatch();
                    if (++i != n) continue;
                    temUpPst.executeBatch();
                    temUpPst.clearBatch();
                    i = 0;
                }
                temUpPst.executeBatch();
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException("BgNTemplateFacadeControllerBean _changeTemFormType");
                catch (IOException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, formPst);
                SQLUtils.cleanup(temPst);
                SQLUtils.cleanup(temUpPst);
                SQLUtils.cleanup(formUpPst);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)formPst);
        SQLUtils.cleanup((Statement)temPst);
        SQLUtils.cleanup((Statement)temUpPst);
        SQLUtils.cleanup((Statement)formUpPst);
        SQLUtils.cleanup((Connection)conn);
    }

    private void clearBook(Book book) {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        Cell cell = null;
        if (book.getUserObject("EnumerAteArea") != null) {
            book.removeUserObject("EnumerAteArea");
            for (int i = 0; i < book.getSheetCount(); ++i) {
                sheet = book.getSheet(i);
                int maxM = sheet.getMaxRowIndex() + 1;
                for (int m = 0; m < maxM; ++m) {
                    int maxN = sheet.getMaxColIndex() + 1;
                    for (int n = 0; n < maxN; ++n) {
                        cell = sheet.getCell(m, n, false);
                        if (cell == null) continue;
                        cell.removeUserObject("BeginCell");
                        cell.removeUserObject("EndCell");
                        cell.removeUserObject("CollBeginCell");
                        cell.removeUserObject("CollEndCell");
                        cell.removeUserObject("ItemBeginCell");
                        cell.removeUserObject("ItemEndCell");
                    }
                }
            }
        }
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> rpcDataMap = new HashMap<String, Boolean>();
        BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String CUID = (String)paramMap.get("CUID");
        boolean result = codingRuleManager.isExist((IObjectValue)bgTemplateInfo, CUID);
        rpcDataMap.put("hasCodingRule", result);
        String oprtState = (String)paramMap.get("oprtState");
        IMeasureUnit iM = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (oprtState.equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol1 = iM.getMeasureUnitCollection(muView);
        rpcDataMap.put("muCol1", (Boolean)muCol1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        IBgElement iElement = BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCol = iElement.getBgElementCollection(view);
        rpcDataMap.put("bgElementCol", (Boolean)bgElementCol);
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muFilter2.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol2 = iM.getMeasureUnitCollection(muView2);
        rpcDataMap.put("muCol2", (Boolean)muCol2);
        return rpcDataMap;
    }

    @Override
    protected Map _removeBlankRows(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        StringBuffer sb;
        int removedColCount;
        int removedRowCount;
        HashMap<String, String> returnMap;
        block21: {
            returnMap = new HashMap<String, String>();
            if (id == null) {
                return returnMap;
            }
            BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id.toString(), (boolean)false);
            String boName = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType).getFullName();
            boolean isFromTemplate = false;
            if ("com.kingdee.eas.ma.budget.app.BgTemplate".equals(boName)) {
                isFromTemplate = true;
            }
            Book book = null;
            Sheet sheet = null;
            Row row = null;
            Column col = null;
            Cell cell = null;
            boolean canRemove = true;
            removedRowCount = 0;
            removedColCount = 0;
            sb = new StringBuffer();
            try {
                BgTemplateInfo info;
                IBgTemplate instance;
                if (isFromTemplate) {
                    instance = BgTemplateFactory.getLocalInstance((Context)ctx);
                    info = instance.getBgTemplateInfo("select number, name, data where id = '" + id.toString() + "'");
                    if (info != null) {
                        book = info.getBook();
                    }
                } else {
                    instance = BgFormFactory.getLocalInstance((Context)ctx);
                    info = instance.getBgFormInfo("select number, name, data where id = '" + id.toString() + "'");
                    if (info != null) {
                        book = info.getBook();
                    }
                }
                if (book == null) {
                    return returnMap;
                }
                boolean autoCalTag = book.isAutoCalculate();
                BgNFSHelper.disableUndo(book);
                BgNFSHelper.disableCal(book);
                int sheetCount = book.getSheetCount();
                block6: for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                    int i;
                    sheet = book.getSheet(sheetIndex);
                    int rowCount = sheet.getMaxRowIndex() + 1;
                    int colCount = sheet.getMaxColIndex() + 1;
                    for (i = rowCount - 1; i >= 0; --i) {
                        row = sheet.getRow(i, false);
                        canRemove = true;
                        if (row == null) continue;
                        for (int s = 0; s < colCount; ++s) {
                            cell = row.getCell(s, false);
                            if (!this.checkHasData(cell)) continue;
                            canRemove = false;
                            break;
                        }
                        if (!canRemove) break;
                        BgNFSHelper.removeRow(sheet, i);
                        ++removedRowCount;
                    }
                    rowCount = sheet.getMaxRowIndex() + 1;
                    colCount = sheet.getMaxColIndex() + 1;
                    for (i = colCount - 1; i >= 0; --i) {
                        col = sheet.getColumn(i, false);
                        canRemove = true;
                        if (col == null) continue;
                        for (int j = 0; j < rowCount; ++j) {
                            cell = sheet.getCell(j, i, false);
                            if (!this.checkHasData(cell)) continue;
                            canRemove = false;
                            break;
                        }
                        if (!canRemove) continue block6;
                        BgNFSHelper.removeColumn(sheet, i);
                        ++removedColCount;
                    }
                }
                book.setCalculate(autoCalTag);
                if (removedRowCount <= 0 && removedColCount <= 0) break block21;
                byte[] data = IOHelper.packBook((Book)book);
                Connection conn = null;
                PreparedStatement pstmt = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = isFromTemplate ? conn.prepareStatement("update t_bg_bgTemplate set fdata = ? where fid = ? ") : conn.prepareStatement("update t_bg_bgForm set fdata = ? where fid = ? ");
                    BgInfoHelper.setBytes(pstmt, 1, data);
                    pstmt.setString(2, id.toString());
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{e.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (removedRowCount > 0) {
            sb.append("Removed blank row count: " + removedRowCount + "\n");
        }
        if (removedColCount > 0) {
            sb.append("Removed blank column count: " + removedColCount + "\n");
        }
        if (sb.length() == 0) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"11_BgNTemplateFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        returnMap.put("message", sb.toString());
        return returnMap;
    }

    private boolean checkHasData(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean check = !BgNFSHelper.checkIsEmptyValue(cell) || BgNFSHelper.checkHasItemFormula(cell) || cell.hasFormula() || BgNFSHelper.checkHasEnumerateOfCell(cell) || BgNFSHelper.checkHasComment(cell) || cell.getUserObjectValue("ScriptBeginCell") != null;
        return check;
    }

    @Override
    protected int _forceChangeBgType(Context ctx, String orgId, Set templateIds) throws BOSException, EASBizException {
        logger.debug((Object)"forceChangeBgType:");
        long startTime = System.currentTimeMillis();
        int flag = 0;
        if (StringUtils.isEmpty((String)orgId) || templateIds == null || templateIds.size() == 0) {
            return flag;
        }
        Connection conn = null;
        PreparedStatement pmt = null;
        try {
            conn = this.getConnection(ctx);
            Map allTemplateIds = this.getAllTemplateIds(conn, orgId, templateIds);
            if (allTemplateIds == null) {
                int n = flag;
                return n;
            }
            for (Map.Entry entry2 : BgNSQLHelper.bgTypeRefTables.entrySet()) {
                String tableName = (String)entry2.getKey();
                String[] cols = ((String)entry2.getValue()).split("!");
                String colName = cols[0];
                String condName = cols[1];
                StringBuffer sql = new StringBuffer("update ").append(tableName).append(" set ").append(colName).append(" = ? where ").append(condName).append(" in (");
                BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
                pmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry2 : allTemplateIds.entrySet()) {
                    String typeid = (String)entry2.getKey();
                    Object[] tempIds = ((List)entry2.getValue()).toArray();
                    int count = (tempIds.length - 1) / 200 + 1;
                    for (int i = 0; i < count; ++i) {
                        pmt.setObject(1, typeid);
                        BgNSQLHelper.setParam4Batch(pmt, 2, i, 200, tempIds);
                        flag += pmt.executeUpdate();
                    }
                }
                SQLUtils.cleanup((Statement)pmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_forceChangeBgType", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pmt, (Connection)conn);
        }
        long time = System.currentTimeMillis() - startTime;
        logger.debug((Object)(time + "ms"));
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllTemplateIds(Connection conn, String orgId, Set templateIds) throws SQLException {
        HashMap<String, ArrayList<String>> hashMap;
        String oLongnumber;
        ResultSet res;
        PreparedStatement pmt;
        block9: {
            pmt = null;
            res = null;
            String sql = "select flongnumber from t_org_baseunit where fid=?";
            pmt = conn.prepareStatement(sql);
            pmt.setString(1, orgId);
            res = pmt.executeQuery();
            oLongnumber = null;
            if (res.next()) {
                oLongnumber = res.getString("flongnumber");
            }
            if (oLongnumber != null) break block9;
            Map map = null;
            SQLUtils.cleanup((ResultSet)res, (Statement)pmt);
            return map;
        }
        try {
            SQLUtils.cleanup((ResultSet)res, (Statement)pmt);
            Object[] ids = templateIds.toArray();
            HashMap<String, String> roots = new HashMap<String, String>();
            int totalLength = ids.length;
            int count = (totalLength - 1) / 200 + 1;
            StringBuffer sql1 = new StringBuffer("select frootid,FBgTypeID from t_bg_bgtemplate where fid in(");
            BgNSQLHelper.addPlaceHolder(sql1, 200).append(")");
            pmt = conn.prepareStatement(sql1.toString());
            for (int i = 0; i < count; ++i) {
                BgNSQLHelper.setParam4Batch(pmt, i, 200, ids);
                res = pmt.executeQuery();
                while (res.next()) {
                    roots.put(res.getString("frootid"), res.getString("FBgTypeID"));
                }
                SQLUtils.cleanup((ResultSet)res);
            }
            SQLUtils.cleanup((Statement)pmt);
            HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
            ids = roots.keySet().toArray();
            totalLength = ids.length;
            count = (totalLength - 1) / 200 + 1;
            sql1 = new StringBuffer("select FID,frootid from t_bg_bgtemplate where forgunitid in (select fid from t_org_baseunit where flongnumber like ? or fid=?)  and frootid in (");
            BgNSQLHelper.addPlaceHolder(sql1, 200).append(")");
            pmt = conn.prepareStatement(sql1.toString());
            pmt.setString(1, oLongnumber + "!" + "%");
            pmt.setString(2, BOSUuid.read((String)orgId).toString());
            for (int i = 0; i < count; ++i) {
                BgNSQLHelper.setParam4Batch(pmt, 3, i, 200, ids);
                res = pmt.executeQuery();
                while (res.next()) {
                    String rootid = res.getString("frootid");
                    String typeId = (String)roots.get(rootid);
                    String fid = res.getString("FID");
                    ArrayList<String> list = (ArrayList<String>)result.get(typeId);
                    if (list == null) {
                        list = new ArrayList<String>();
                        result.put(typeId, list);
                    }
                    list.add(fid);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(res, pmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pmt);
        return hashMap;
    }
}

