/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgSelfDefineObjInfo;
import com.kingdee.eas.ma.nbudget.app.AbstractBgSelfDefineFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSelfDefineFacadeControllerBean
extends AbstractBgSelfDefineFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgSelfDefineFacadeControllerBean");
    private static final long serialVersionUID = -2805555193433405951L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected List _getAdjustValue(Context ctx, String[] array) throws BOSException {
        ArrayList<BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj> list = new ArrayList<BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj>();
        String idSql = this.geHelpSql(ctx, array);
        if ("".equals(idSql)) {
            return list;
        }
        idSql = "('" + idSql + "')";
        StringBuffer sql = new StringBuffer();
        sql.append("select b.fpastvalue pastValue ,b.fadjusttime adjustTime,a.fpastSource pastSource from t_bg_bgpastrecord a, t_bg_bgpastdata b ");
        sql.append(" where a.fid = b.fpastrecordid");
        sql.append(" and b.fpastrecordid in (select fid from t_bg_bgpastrecord where fpastSource <> " + BgPastSourceEnum.DECOMPOSER.getValue() + ")");
        sql.append(" and b.fbgdataid in " + idSql);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal pastVal = rs.getBigDecimal("pastValue");
                int pastSource = rs.getInt("pastSource");
                Date modifyDate = rs.getDate("adjustTime");
                BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj info = new BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj((java.util.Date)modifyDate, pastSource, pastVal);
                list.add(info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException ex2) {
            logger.error((Object)"budget error:", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String geHelpSql(Context ctx, String[] array) {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            String string;
            String bgItem = array[0];
            String orgNum = array[1];
            String schemeNum = array[2];
            String sqlOrgUnit = " and forgunitid in (select fid from t_org_baseunit where fnumber = ?)";
            String sql = "select fid from t_bg_bgdata  where fbgschemeid in  (select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fnumber = ? " + sqlOrgUnit + "))" + sqlOrgUnit + " and fformula = ? ";
            con = null;
            ps = null;
            rs = null;
            try {
                String id;
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                ps.setString(1, schemeNum);
                ps.setString(2, orgNum);
                ps.setString(3, orgNum);
                ps.setString(4, bgItem);
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                string = id = rs.getString("fid");
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
            catch (SQLException ex2) {
                logger.error((Object)"budget error:", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return "";
    }

    @Override
    protected List _getBgDataID(Context ctx, String[] array) throws BOSException {
        String bgDataID = this.geHelpSql(ctx, array);
        ArrayList<String> list = new ArrayList<String>();
        if ("".equals(bgDataID)) {
            return list;
        }
        list.add(bgDataID);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BgTraceFilterParam _constructTraceFilterParam(Context ctx, String[] array) throws BOSException {
        BgPeriodCollection periodCol;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        String periodNum;
        String orgNum;
        BgTraceFilterParam filterParam;
        block6: {
            filterParam = new BgTraceFilterParam();
            orgNum = array[1];
            String schemeNum = array[2];
            periodNum = array[3];
            String sql = "select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fnumber = ? ) and forgunitid = (select fid from t_org_baseunit where fnumber = ?) ";
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                ps.setString(1, schemeNum);
                ps.setString(2, orgNum);
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                String bgSchemeID = rs.getString("fid");
                filterParam.setBgSchemeId(bgSchemeID);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"budget error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id ,name where number = '" + orgNum + "'");
        if (col.size() > 0) {
            FullOrgUnitInfo orgInfo = col.get(0);
            OrgUnitInfo costInfo = new OrgUnitInfo();
            costInfo.setId(orgInfo.getId());
            costInfo.setName(orgInfo.getName());
            filterParam.setOrgUnitInfoAry(new OrgUnitInfo[]{costInfo});
        }
        if ((periodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection("select id ,number where number = '" + periodNum + "'")).size() > 0) {
            BgPeriodInfo periodInfo = periodCol.get(0);
            filterParam.setBeginPeriod(periodInfo);
            filterParam.setEndPeriod(periodInfo);
        }
        return filterParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected Map _getValueByFormula(Context ctx, String orgUnitID, String bgSchemeNum, String bgItem) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        HashMap<String, BgSelfDefineObjInfo> map;
        block10: {
            map = new HashMap<String, BgSelfDefineObjInfo>();
            StringBuffer sql = new StringBuffer();
            sql.append(" select fbgvalue ,FBizActual ,fbgformid,sumPastVal from t_bg_bgdata ");
            sql.append(this.getSumPastValSql());
            sql.append(" where a.forgunitid = ? ");
            sql.append(" and a.fbgschemeid = (select fid from t_bg_bgscheme where fnumber = ? and forgunitid = ? )");
            sql.append(" and a.fformula  = ? ");
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, orgUnitID);
                ps.setString(2, bgSchemeNum);
                ps.setString(3, orgUnitID);
                ps.setString(4, bgItem);
                rs = ps.executeQuery();
                if (rs.next()) {
                    BigDecimal actual;
                    BigDecimal budget;
                    BigDecimal adjust = rs.getBigDecimal("sumPastVal");
                    if (adjust == null) {
                        adjust = new BigDecimal("0.00");
                    }
                    if ((budget = rs.getBigDecimal("fbgvalue")) == null) {
                        budget = new BigDecimal("0.00");
                    }
                    if ((actual = rs.getBigDecimal("fbizactual")) == null) {
                        actual = new BigDecimal("0.00");
                    }
                    String bgFormID = rs.getString("fbgformid");
                    BgSelfDefineObjInfo info = new BgSelfDefineObjInfo(budget, actual, adjust, bgFormID);
                    map.put(orgUnitID, info);
                    break block10;
                }
                BigDecimal zero = new BigDecimal("0.00");
                map.put(orgUnitID, new BgSelfDefineObjInfo(zero, zero, zero, ""));
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
            catch (SQLException ex2) {
                logger.error((Object)"budget error:", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return map;
    }

    private String getSumPastValSql() {
        String sql = "a left join (select fbgdataid , sum(FPASTVALUE) sumPastVal from T_BG_bgpastdata where FPastRecordID in (select fid from t_bg_bgpastrecord where fpastSource <> " + BgPastSourceEnum.DECOMPOSER.getValue() + ") group by fbgdataid) b on a.fid = b.fbgdataid";
        return sql;
    }

    @Override
    protected String _getBgItemNameByNum(Context ctx, String bgItemNum, String orgUnitId) throws BOSException {
        try {
            orgUnitId = BgSHelper.getIsolateOrg((Context)ctx, (String)orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (bgItemNum == null) {
            return "";
        }
        String name = "";
        String[] nums = bgItemNum.split(",");
        HashSet<String> numSet = new HashSet<String>();
        for (int n = 0; n < nums.length; ++n) {
            numSet.add(nums[n]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("name"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgItemCollection cols = BgItemFactory.getLocalInstance((Context)ctx).getBgItemCollection(viewInfo);
        for (int i = 0; i < cols.size(); ++i) {
            name = name + ", " + cols.get(i).getName();
        }
        name = name.substring(2);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected String _getAnalysisFormID(Context ctx, String bgTemplateID, String orgUnitID, String bgPeriodID) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            String string;
            String sql = "select fid from t_bg_bgform where forgunitid = ? and fbgperiodid = ?  and fbgtemplateid = (select fid from t_bg_bgtemplate where frootid = (select frootid from t_bg_bgtemplate where fid = ? ) and forgunitid = ?)";
            con = null;
            ps = null;
            rs = null;
            try {
                String bgFormID;
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, orgUnitID);
                ps.setString(2, bgPeriodID);
                ps.setString(3, bgTemplateID);
                ps.setString(4, orgUnitID);
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                string = bgFormID = rs.getString("fid");
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
            catch (SQLException ex2) {
                logger.error((Object)"budget error:", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return "";
    }

    @Override
    protected Map _getExecuteInfo(Context ctx, String[] parameter) throws BOSException, EASBizException {
        if (parameter == null) {
            return null;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        HashSet<String> orgIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            int i;
            StringBuffer sql;
            Object[] params = null;
            int batchCount = 0;
            conn = this.getConnection(ctx);
            if (!StringUtils.isEmpty((String)parameter[1])) {
                sql = new StringBuffer();
                sql.append("select FID, FName_").append(ctx.getLocale()).append(", FNumber from T_ORG_CostCenter where FNumber in (");
                BgNSQLHelper.addPlaceHolder(sql).append(")");
                pstmt = conn.prepareStatement(sql.toString());
                params = parameter[1].split(";");
                batchCount = BgNSQLHelper.getBatchCount(params.length);
                for (i = 0; i < batchCount; ++i) {
                    BgNSQLHelper.setParam4BatchDefCount(pstmt, 1, i, params);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        OrgUnitInfo org = new OrgUnitInfo();
                        org.setId(BOSUuid.read((String)res.getString(1)));
                        org.setName(res.getString(2));
                        org.setNumber(res.getString(3));
                        orgIds.add(org.getId().toString());
                        orgUnits.add(org);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
            SQLUtils.cleanup(res, pstmt);
            if (!orgUnits.isEmpty()) {
                OrgUnitInfo[] orgs = new OrgUnitInfo[orgUnits.size()];
                orgs = orgUnits.toArray(orgs);
                resMap.put("ORGUNIT_INFO", orgs);
            }
            if (!StringUtils.isEmpty((String)parameter[2]) && !orgIds.isEmpty()) {
                sql = new StringBuffer();
                sql.append("select top 1 FNumber, FRootID from T_BG_BgScheme where FNumber = ? and FOrgUnitId in(");
                BgNSQLHelper.addPlaceHolder(sql).append(")");
                pstmt = conn.prepareStatement(sql.toString());
                params = orgIds.toArray();
                batchCount = BgNSQLHelper.getBatchCount(params);
                for (i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, parameter[2]);
                    BgNSQLHelper.setParam4BatchDefCount(pstmt, 2, i, params);
                    res = pstmt.executeQuery();
                    if (!res.next()) continue;
                    BgSchemeInfo bgScheme = new BgSchemeInfo();
                    bgScheme.setNumber(res.getString(1));
                    bgScheme.setRootId(BOSUuid.read((String)res.getString(2)));
                    resMap.put("BGSCHEME_INFO", bgScheme);
                    break;
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                logger.error((Object)parameter);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, pstmt, (Connection)conn);
        return resMap;
    }
}

