/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormulaPoint;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkDataCollection;
import com.kingdee.eas.ma.nbudget.BgWorkDataFactory;
import com.kingdee.eas.ma.nbudget.BgWorkDataInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperHistoryVersionFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperHistoryVersionInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.IBgWorkData;
import com.kingdee.eas.ma.nbudget.IBgWorkPaper;
import com.kingdee.eas.ma.nbudget.IBgWorkPaperHistoryVersion;
import com.kingdee.eas.ma.nbudget.app.AbstractBgWorkPaperControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkPaperControllerBean
extends AbstractBgWorkPaperControllerBean {
    private static final long serialVersionUID = 5469303913999959592L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgWorkPaperControllerBean");

    @Override
    protected String _checkHasExist(Context ctx, String orgId, String bgSchemeId, String bgWorkTemplateId, String bgPeriodId, String currencyId, int dataType, String number) throws BOSException, EASBizException {
        ResultSet res;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            String string;
            String sql = "SELECT FID FROM T_BG_BGWORKPAPER WHERE FORGUNITID = ? AND FBGSCHEMEID = ? AND FBgWorkTemplateID = ? AND FBGPERIODID = ? AND FCURRENCYID = ? AND FDATATYPE = ?";
            conn = null;
            pstmt = null;
            res = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, orgId);
                pstmt.setString(2, bgSchemeId);
                pstmt.setString(3, bgWorkTemplateId);
                pstmt.setString(4, bgPeriodId);
                pstmt.setString(5, currencyId);
                pstmt.setInt(6, dataType);
                res = pstmt.executeQuery();
                if (!res.next()) break block4;
                string = "hasExist";
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return null;
    }

    @Override
    protected String _checkNumber(Context ctx, String orgId, String number) throws BOSException, EASBizException {
        ResultSet res;
        PreparedStatement pstmt;
        Connection conn;
        block7: {
            String string;
            if (orgId == null) {
                return null;
            }
            if (StringUtils.isEmpty((String)number)) {
                return "noNumber";
            }
            if (!BgNWorkPaperHelper.checkNumber(number)) {
                return "numberError";
            }
            String sql = "SELECT FID FROM T_BG_BGWORKPAPER WHERE FORGUNITID = ? AND FNUMBER = ?";
            conn = null;
            pstmt = null;
            res = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, orgId);
                pstmt.setString(2, number);
                res = pstmt.executeQuery();
                if (!res.next()) break block7;
                string = "numberRepeat";
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        return null;
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        try {
            BgNWorkPaperHelper.requestObjectLock(ctx, pk.toString());
            BgNWorkPaperHelper.releaseObjectLock(ctx, pk.toString());
        }
        catch (EASBizException e1) {
            logger.error((Object)"");
            throw new CanNotDeleteException(e1.getMessage());
        }
        catch (BOSException e1) {
            logger.error((Object)"");
            throw new CanNotDeleteException(e1.getMessage());
        }
        String cannotDelete = ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.BgNWorkPaperResource", (String)"cannotDelete", (Locale)ctx.getLocale());
        String sql = "select fid from t_bg_bgworkpaper where fstate = 2 and fid = ?";
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            res = pstmt.executeQuery();
            if (res.next()) {
                throw new CanNotDeleteException(cannotDelete);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new CanNotDeleteException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        this.traceBook(ctx, model, false);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgWorkPaperInfo info = (BgWorkPaperInfo)model;
        if (info.getOrgUnit() != null) {
            BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), "sourceType");
        }
        this.checkRepeat(ctx, model);
        super._addnew(ctx, pk, model);
        this.traceBook(ctx, model, true);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgWorkPaperInfo info = (BgWorkPaperInfo)model;
        if (info.getOrgUnit() != null) {
            BgCodeNumberNHelper.applyNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), "sourceType");
        }
        this.checkRepeat(ctx, model);
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgWorkPaper_add");
        IObjectPK result = super._addnew(ctx, model);
        this.traceBook(ctx, model, true);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgWorkPaperInfo info = this.getBgWorkPaperInfo(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgWorkPaper.id", (Object)pk.toString()));
        BgWorkDataFactory.getLocalInstance(ctx).delete(filter);
        Connection conn = null;
        try {
            BOSUuid id = BOSUuid.read((String)pk.toString());
            BgFacadeHelper.clearRefBgItem(conn, id);
            BgFacadeHelper.clearRefBgPeriod(conn, id);
            BgFacadeHelper.clearRefCurrency(conn, id);
            BgFacadeHelper.clearRefBgElement(conn, id);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        super._delete(ctx, pk);
        BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)info, info.getOrgUnit().getId().toString(), info.getNumber());
    }

    private void checkRepeat(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgWorkPaperInfo info;
        String msg;
        if (model instanceof BgWorkPaperInfo && !StringUtils.isEmpty((String)(msg = this._checkHasExist(ctx, (info = (BgWorkPaperInfo)model).getOrgUnit().getId().toString(), info.getBgScheme().getId().toString(), info.getBgWorkTemplate().getId().toString(), info.getBgPeriod().getId().toString(), info.getCurrency().getId().toString(), info.getDataType().getValue(), info.getNumber())))) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.BgNWorkPaperResource", (String)msg, (Locale)ctx.getLocale())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceBook(Context ctx, IObjectValue model, boolean isAddNew) throws BOSException, EASBizException {
        if (!(model instanceof BgWorkPaperInfo)) {
            return;
        }
        BgWorkPaperInfo info = (BgWorkPaperInfo)model;
        BgWorkDataInfo data2 = null;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        String orgUnitId = info.getOrgUnit() == null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : info.getOrgUnit().getId().toString();
        HashMap<String, BgWorkDataInfo> workData = new HashMap<String, BgWorkDataInfo>();
        if (!isAddNew && info.getId() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgWorkPaper.id", (Object)info.getId().toString()));
            evi.setFilter(filter);
            evi.setSelector(this.getWorkDataSelector());
            BgWorkDataCollection col = BgWorkDataFactory.getLocalInstance(ctx).getBgWorkDataCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    data2 = col.get(i);
                    workData.put(data2.getFormula(), data2);
                }
            }
        }
        String periodNumber = info.getBgPeriod().getNumber();
        String currencyNumber = info.getCurrency().getNumber();
        String itemNumber = null;
        String elementNumber = null;
        String srcType = null;
        String formula = null;
        String[] params = null;
        Sheet sheet = null;
        Cell cell = null;
        Map colData = null;
        BgNFormulaPoint point = null;
        BigDecimal value = null;
        HashSet<String> itemNumbers = new HashSet<String>();
        HashSet<String> elementNumbers = new HashSet<String>();
        ArrayList<String> periodNumbers = new ArrayList<String>();
        periodNumbers.add(periodNumber);
        ArrayList<String> currencyNumbers = new ArrayList<String>();
        currencyNumbers.add(currencyNumber);
        HashMap<String, BgNFormulaPoint> formulaPoint = new HashMap<String, BgNFormulaPoint>();
        HashMap<String, BgWorkDataInfo> addNew = new HashMap<String, BgWorkDataInfo>();
        HashMap<String, BgWorkDataInfo> update = new HashMap<String, BgWorkDataInfo>();
        try {
            Book book = info.getBook();
            for (int s = 0; s < book.getSheetCount(); ++s) {
                sheet = book.getSheet(s);
                for (int row = 0; row <= sheet.getMaxRowIndex(); ++row) {
                    itemNumber = BgNWorkPaperHelper.getItemNumber(sheet.getRow(row, false));
                    if (StringUtils.isEmpty((String)itemNumber)) continue;
                    itemNumbers.add(itemNumber);
                    for (int col = 0; col <= sheet.getMaxColIndex(); ++col) {
                        cell = sheet.getCell(row, col, false);
                        if (cell == null) continue;
                        formula = BgNFSHelper.getFormulaOfCell(cell);
                        if (!StringUtils.isEmpty((String)formula) && (point = (BgNFormulaPoint)formulaPoint.get(formula)) == null) {
                            point = new BgNFormulaPoint();
                            point.setFormula(formula);
                            point.setSheetId(sheet.getID());
                            point.setSheetName(sheet.getSheetName());
                            point.setColIndex(col);
                            point.setRowIndex(row);
                            formulaPoint.put(formula, point);
                        }
                        if ((colData = BgNWorkPaperHelper.getDataColMap(sheet.getColumn(col, false))) == null || colData.get("WORK_PAPER_SINGLE_ORG_ID") instanceof String || StringUtils.isEmpty((String)(elementNumber = BgNWorkPaperHelper.getElementNumber(colData)))) continue;
                        elementNumbers.add(elementNumber);
                        srcType = BgNWorkPaperHelper.getSrcType(colData);
                        if (StringUtils.isEmpty((String)srcType) || String.valueOf(1).equals(srcType)) continue;
                        params = new String[6];
                        params[4] = "true";
                        params[5] = currencyNumber;
                        params[3] = "BgData";
                        params[2] = elementNumber;
                        params[0] = itemNumber;
                        params[1] = periodNumber;
                        formula = BgNFSHelper.getFormulaFromParam(params);
                        if (StringUtils.isEmpty((String)formula)) continue;
                        if (addNew.get(formula) instanceof BgWorkDataInfo) {
                            data2 = (BgWorkDataInfo)addNew.get(formula);
                        } else if (update.get(formula) instanceof BgWorkDataInfo) {
                            data2 = (BgWorkDataInfo)update.get(formula);
                        } else if (workData.get(formula) instanceof BgWorkDataInfo) {
                            data2 = (BgWorkDataInfo)workData.get(formula);
                            update.put(formula, data2);
                            workData.remove(formula);
                        } else {
                            data2 = new BgWorkDataInfo();
                            addNew.put(formula, data2);
                            data2.setId(BOSUuid.create((BOSObjectType)data2.getBOSType()));
                            data2.setFormula(formula);
                            data2.setBgWorkPaper(info);
                            data2.setCurrency(info.getCurrency());
                            data2.setBgPeriod(info.getBgPeriod());
                            data2.setBgScheme(info.getBgScheme());
                            data2.setDataType(info.getDataType());
                            data2.setOrgTree(info.getOrgTree());
                            data2.setOrgGroup(info.getOrgUnit());
                            data2.setBgItemNumber(itemNumber);
                            data2.setBgElement(new BgElementInfo());
                            data2.getBgElement().setNumber(elementNumber);
                        }
                        value = cell.getValue().getValue() instanceof BigDecimal ? (BigDecimal)cell.getValue().getValue() : null;
                        if (String.valueOf(2).equals(srcType)) {
                            data2.setSumAmount(value);
                            continue;
                        }
                        if (String.valueOf(4).equals(srcType)) {
                            data2.setConsolidAmount(value);
                            continue;
                        }
                        if (!String.valueOf(3).equals(srcType)) continue;
                        data2.setElimAmount(value);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.checkFormula(ctx, info.getBgScheme().getId().toString(), info.getOrgUnit().getId().toString(), info.getDataType().getValue(), info.getId().toString(), formulaPoint);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ArrayList<String> numbers = new ArrayList<String>();
            if (!itemNumbers.isEmpty()) {
                numbers.addAll(itemNumbers);
            }
            Map itemMap = BgFacadeHelper.getBgItemMap(conn, null, numbers);
            itemMap = BgFacadeHelper.createBgItemMap(ctx, itemMap, numbers, orgUnitId);
            if (!isAddNew) {
                BgFacadeHelper.clearRefBgItem(conn, info.getId());
            }
            BgFacadeHelper.dealRefBgItem(ctx, info.getId(), itemNumbers, itemMap);
            if (!addNew.isEmpty()) {
                for (BgWorkDataInfo data2 : addNew.values()) {
                    data2.setBgItemId((String)itemMap.get(data2.getBgItemNumber()));
                }
            }
            numbers.clear();
            if (!elementNumbers.isEmpty()) {
                numbers.addAll(elementNumbers);
            }
            Map eleMap = BgFacadeHelper.getBgElementMap(conn, null, numbers);
            BgFacadeHelper.clearRefBgElement(conn, info.getId());
            BgFacadeHelper.dealRefBgElement(ctx, info.getId(), elementNumbers, eleMap);
            Map perMap = BgFacadeHelper.getBgPeriodMap(conn, null, periodNumbers);
            BgFacadeHelper.clearRefBgPeriod(conn, info.getId());
            BgFacadeHelper.dealRefBgPeriod(ctx, info.getId(), new HashSet(periodNumbers), perMap);
            Map curMap = BgFacadeHelper.getCurrencyMap(conn, null, currencyNumbers);
            BgFacadeHelper.clearRefCurrency(conn, info.getId());
            BgFacadeHelper.dealRefCurrency(ctx, info.getId(), new HashSet(currencyNumbers), curMap);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.fillBgItemName(ctx, addNew, info.getOrgTree().getId().toString());
        this.fillBgElementId(ctx, addNew);
        IBgWorkData work = BgWorkDataFactory.getLocalInstance(ctx);
        if (!workData.isEmpty()) {
            IObjectPK[] delPk = new IObjectPK[workData.size()];
            int index = 0;
            for (BgWorkDataInfo data2 : workData.values()) {
                delPk[index] = new ObjectUuidPK(data2.getId());
                ++index;
            }
            work.delete(delPk);
        }
        BgWorkDataCollection updateCol = new BgWorkDataCollection();
        if (!update.isEmpty()) {
            for (BgWorkDataInfo data2 : update.values()) {
                updateCol.add(data2);
            }
            work.updateSimple(updateCol);
        }
        CoreBaseCollection addCol = new CoreBaseCollection();
        if (!addNew.isEmpty()) {
            for (BgWorkDataInfo data2 : addNew.values()) {
                addCol.add((CoreBaseInfo)data2);
            }
            work.addnew(addCol);
        }
    }

    private void fillBgItemName(Context ctx, Map addNew, String treeId) throws BOSException, EASBizException {
        if (addNew == null || addNew.isEmpty()) {
            return;
        }
        ArrayList<String> treeIds = new ArrayList<String>();
        treeIds.add(treeId);
        Map treeMap = BgElimFacadeFactory.getLocalInstance(ctx).getOrgMapping(treeIds);
        treeId = null;
        if (treeMap != null && !treeMap.isEmpty()) {
            treeId = ((FullOrgUnitInfo)treeMap.values().toArray()[0]).getId().toString();
        }
        try {
            if (!BgSHelper.isBgItemIsolate((Context)ctx)) {
                treeId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (treeId == null) {
            return;
        }
        BgWorkDataInfo data2 = null;
        String[] nums = null;
        HashSet<String> numbers = new HashSet<String>();
        for (BgWorkDataInfo data2 : addNew.values()) {
            if (StringUtils.isEmpty((String)data2.getBgItemNumber()) || (nums = data2.getBgItemNumber().replaceAll(",", "_").split("_")) == null) continue;
            for (int i = 0; i < nums.length; ++i) {
                numbers.add(nums[i]);
            }
        }
        HashMap<String, String> names = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer("SELECT FNumber, FName_").append(ctx.getLocale()).append(" FItemName").append(" From T_Bg_BgItem WHERE FOrgUnitId = ? AND FNumber in (");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        Object[] params = numbers.toArray();
        int batCount = (params.length - 1) / 200 + 1;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batCount; ++i) {
                pstmt.setString(1, treeId);
                BgNSQLHelper.setParam4Batch(pstmt, 2, i, 200, params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    names.put(res.getString("FNumber"), res.getString("FItemName"));
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        StringBuffer name = null;
        for (BgWorkDataInfo data2 : addNew.values()) {
            if (StringUtils.isEmpty((String)data2.getBgItemNumber())) continue;
            name = new StringBuffer();
            nums = data2.getBgItemNumber().replaceAll(",", "_").split("_");
            if (nums != null && nums.length > 0) {
                for (int i = 0; i < nums.length - 1; ++i) {
                    if (!names.containsKey(nums[i])) continue;
                    name.append(names.get(nums[i])).append("_");
                }
                if (names.containsKey(nums[nums.length - 1])) {
                    name.append(names.get(nums[nums.length - 1]));
                }
            }
            data2.setBgItemName(name.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBgElementId(Context ctx, Map addNew) throws BOSException, EASBizException {
        if (addNew == null || addNew.isEmpty()) {
            return;
        }
        BgWorkDataInfo data2 = null;
        HashSet<String> numbers = new HashSet<String>();
        for (BgWorkDataInfo data2 : addNew.values()) {
            numbers.add(data2.getBgElement().getNumber());
        }
        HashMap<String, String> element = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer("SELECT FID,FNumber from t_bg_bgelement where fnumber in(");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        Object[] params = numbers.toArray();
        int batCount = (params.length - 1) / 200 + 1;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batCount; ++i) {
                BgNSQLHelper.setParam4Batch(pstmt, i, 200, params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    element.put(res.getString("FNumber"), res.getString("FID"));
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        for (BgWorkDataInfo data2 : addNew.values()) {
            data2.getBgElement().setId(BOSUuid.read((String)((String)element.get(data2.getBgElement().getNumber()))));
        }
    }

    private void checkFormula(Context ctx, String bgSchemeId, String groupId, int dataType, String selfId, Map formulaPoint) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)groupId) || formulaPoint == null || formulaPoint.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((String)selfId)) {
            selfId = "#";
        }
        Object[] params = formulaPoint.keySet().toArray();
        int batCount = (params.length - 1) / 200 + 1;
        StringBuffer sql = new StringBuffer("SELECT TOP 1 FFormula, FBgWorkPaperId From T_Bg_BgWorkData WHERE FOrgGroupId = ? AND FBgSchemeId = ? \n");
        sql.append(" AND FDataType = ? AND FBgWorkPaperId <> ? AND FFormula IN (");
        BgNSQLHelper.addPlaceHolder(sql, 200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batCount; ++i) {
                pstmt.setString(1, groupId);
                pstmt.setString(2, bgSchemeId);
                pstmt.setInt(3, dataType);
                pstmt.setString(4, selfId);
                BgNSQLHelper.setParam4Batch(pstmt, 5, i, 200, params);
                res = pstmt.executeQuery();
                if (res.next()) {
                    String formula = res.getString("FFormula");
                    String paperId = res.getString("FBgWorkPaperId");
                    BgWorkPaperInfo paper = this.getBgWorkPaperInfo(ctx, "select name where id = '" + paperId + "'");
                    if (paper != null && formulaPoint.get(formula) instanceof BgNFormulaPoint) {
                        BgNFormulaPoint point = (BgNFormulaPoint)formulaPoint.get(formula);
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.BgNWorkPaperResource", (String)"formulaRepeat", (Locale)ctx.getLocale());
                        msg = MessageFormat.format(msg, point.getSheetName(), TableToolkit.xy2range((int)point.getColIndex(), (int)point.getRowIndex()), formula, paper.getName());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
    }

    private SelectorItemCollection getWorkDataSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("formula");
        sic.add("sumAmount");
        sic.add("elimAmount");
        sic.add("consolidAmount");
        return sic;
    }

    @Override
    protected void _createHistoryVersion(Context ctx, String versionNoIdea, IObjectValue model) throws BOSException {
        if (model == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)versionNoIdea) && versionNoIdea.length() > 650) {
            versionNoIdea = versionNoIdea.substring(0, 650);
        }
        IBgWorkPaper ibgWorkPaper = BgWorkPaperFactory.getLocalInstance(ctx);
        IBgWorkPaperHistoryVersion iBgWorkPaperHistoryVersion = BgWorkPaperHistoryVersionFactory.getLocalInstance(ctx);
        BgWorkPaperInfo latestWorkPaperInfo = (BgWorkPaperInfo)model;
        BgWorkPaperInfo bgWorkPaperInfo = null;
        try {
            bgWorkPaperInfo = ibgWorkPaper.getBgWorkPaperInfo((IObjectPK)new ObjectUuidPK(latestWorkPaperInfo.getId()));
            BgWorkPaperHistoryVersionInfo bgworkPaperHistoryVersionInfo = new BgWorkPaperHistoryVersionInfo();
            bgworkPaperHistoryVersionInfo.setData(bgWorkPaperInfo.getData());
            bgworkPaperHistoryVersionInfo.setVersionNo(bgWorkPaperInfo.getVersionNo());
            bgworkPaperHistoryVersionInfo.setVersionIdea(versionNoIdea);
            bgworkPaperHistoryVersionInfo.setBgWorkPaper(bgWorkPaperInfo);
            bgworkPaperHistoryVersionInfo.setName(bgWorkPaperInfo.getName());
            iBgWorkPaperHistoryVersion.addnew(bgworkPaperHistoryVersionInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

