/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetBillStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestException;
import com.kingdee.eas.ma.nbudget.IBgRequestAdjustBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBillEntry;
import com.kingdee.eas.ma.nbudget.app.AbstractBudgetRequestBillControllerBean;
import com.kingdee.eas.scm.sm.pur.IPur4budgetFacade;
import com.kingdee.eas.scm.sm.pur.Pur4budgetFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.PurObjectEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurObjectType;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BudgetRequestBillControllerBean
extends AbstractBudgetRequestBillControllerBean {
    private static final long serialVersionUID = -4927876480830983321L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BudgetRequestBillControllerBean");
    private final String resourse = "com.kingdee.eas.ma.nbudget.BudgetRequestBillResource";

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        BudgetRequestBillInfo info = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            info = (BudgetRequestBillInfo)this._getValue(ctx, pk, sic);
            if (0 != info.getState().getValue()) {
                throw new CanNotDeleteException((Object)((Object)info.getState()) + ResourceBase.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"reqBillStateErrorDel", (Locale)ctx.getLocale()));
            }
        }
        catch (Exception e) {
            throw new CanNotDeleteException(e.getMessage());
        }
    }

    protected void _sendMessage(Context ctx, BudgetRequestBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo == null) {
            return;
        }
        String resourceFile = "com.kingdee.eas.ma.nbudget.BudgetRequestBillResource";
        Object title = null;
        String body = null;
        SenderAgent agent = null;
        Message message = null;
        Locale locale = null;
        locale = ctx.getLocale();
        body = ResourceBase.getString((String)resourceFile, (String)"billClose", (Locale)locale);
        body = MessageFormat.format(body, billInfo.getNumber());
        agent = SenderAgent.getSenderAgent();
        message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setLocaleStringHeader("title", body, locale);
        message.setLocaleStringHeader("sender", ctx.getUserName(), locale);
        message.setLocaleStringHeader("body", body, locale);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", billInfo.getCreator().getId().toString());
        agent.sendMessage(message);
    }

    @Override
    protected boolean _close(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isClose = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK billPk = new ObjectUuidPK(billId);
        ObjectUuidPK entryPk = null;
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)billPk);
        if (budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
            boolean isNeedBack = false;
            BudgetRequestBillControllerBean.applyMutexService(ctx, billId.toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            IBudgetRequestBillEntry iBudgetRequestBillEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
            BudgetRequestBillEntryCollection billEntryCollection = budgetRequestBillInfo.getBgEnties();
            BudgetRequestBillEntryInfo entryInfo = null;
            for (int i = 0; i < billEntryCollection.size(); ++i) {
                entryInfo = billEntryCollection.get(i);
                entryPk = new ObjectUuidPK(entryInfo.getId());
                BigDecimal appValue = entryInfo.getApplyValue();
                BigDecimal useValue = BudgetRequestBillControllerBean.getAllBOTPValue(ctx, billPk.toString(), entryInfo.getId().toString());
                if (appValue == null) {
                    appValue = BgNConstants.ZERO;
                }
                if (useValue == null) {
                    useValue = BgNConstants.ZERO;
                }
                if (appValue.compareTo(useValue) <= 0) continue;
                isNeedBack = true;
                BigDecimal unUseValue = appValue.subtract(useValue).negate();
                entryInfo.setCheckValue(unUseValue);
                iBudgetRequestBillEntry.update((IObjectPK)entryPk, entryInfo);
            }
            if (isNeedBack) {
                BudgetCtrlCaller.requestBudget((Context)ctx, (BOSUuid)billId);
            }
        } else {
            throw new BudgetRequestException(BudgetRequestException.ISRIGHTSATEBILL);
        }
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgClosed);
        ibudgetRequestBill.update((IObjectPK)billPk, (CoreBaseInfo)budgetRequestBillInfo);
        BudgetRequestBillControllerBean.releaseMutexService(ctx, billId.toString());
        isClose = true;
        return isClose;
    }

    @Override
    protected boolean _submitWorkFlow(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSumit = true;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = ibudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)pk);
        IBudgetRequestBillEntry iBudgetRequestBillEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
        BudgetRequestBillEntryCollection billEntryCollection = budgetRequestBillInfo.getBgEnties();
        BudgetRequestBillEntryInfo entryInfo = null;
        ObjectUuidPK entryPk = null;
        for (int i = 0; i < billEntryCollection.size(); ++i) {
            entryInfo = billEntryCollection.get(i);
            entryPk = new ObjectUuidPK(entryInfo.getId());
            BigDecimal appValue = entryInfo.getApplyValue();
            if (appValue == null) {
                appValue = BgNConstants.ZERO;
            }
            entryInfo.setCheckValue(appValue);
            iBudgetRequestBillEntry.update((IObjectPK)entryPk, entryInfo);
        }
        return isSumit;
    }

    @Override
    protected boolean _submitLocal(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isSumitLocal = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        BudgetRequestBillInfo billInfo = ibudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)(pk = new ObjectUuidPK(billId)));
        if (!billInfo.getState().equals((Object)BudgetBillStateEnum.bgprocess) && !billInfo.getState().equals((Object)BudgetBillStateEnum.bgsubmit)) {
            throw new BudgetRequestException(BudgetRequestException.ISRIGHTSATEBILL);
        }
        billInfo.setState(BudgetBillStateEnum.bgsubmit);
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)billInfo);
        isSumitLocal = true;
        return isSumitLocal;
    }

    @Override
    protected boolean _unSubmitWorkFlow(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected boolean _audit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isAudit = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        BudgetRequestBillInfo budgetRequestBillInfo = ibudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)(pk = new ObjectUuidPK(billId)));
        if (budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgprocess)) {
            Date now = BgHelper.getDayBegin((Date)new Date());
            Date bgEndDate = BgHelper.getDayBegin((Date)budgetRequestBillInfo.getBgEndDate());
            if (bgEndDate.before(now)) {
                throw new BudgetRequestException(BudgetRequestException.BGENDDATEERROR);
            }
            IBudgetRequestBillEntry iBudgetRequestBillEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
            BudgetRequestBillEntryCollection billEntryCollection = budgetRequestBillInfo.getBgEnties();
            BudgetRequestBillEntryInfo entryInfo = null;
            ObjectUuidPK entryPk = null;
            for (int i = 0; i < billEntryCollection.size(); ++i) {
                entryInfo = billEntryCollection.get(i);
                entryPk = new ObjectUuidPK(entryInfo.getId());
                BigDecimal appValue = entryInfo.getApplyValue();
                if (appValue == null) {
                    appValue = BgNConstants.ZERO;
                }
                entryInfo.setCheckValue(appValue);
                iBudgetRequestBillEntry.update((IObjectPK)entryPk, entryInfo);
            }
            BudgetCtrlCaller.requestBudget((Context)ctx, (BOSUuid)billId);
            isAudit = true;
            BudgetRequestBillControllerBean.applyMutexService(ctx, billId.toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            budgetRequestBillInfo.setState(BudgetBillStateEnum.bgAudited);
            budgetRequestBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            budgetRequestBillInfo.setAuditDate(new Date());
            ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
            BudgetRequestBillControllerBean.releaseMutexService(ctx, billId.toString());
        }
        return isAudit;
    }

    @Override
    protected boolean _unAudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isUnAudit = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)(pk = new ObjectUuidPK(billId)));
        if (budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
            BOTRelationCollection botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(billId.toString());
            if (botRelationCol != null && botRelationCol.size() > 0) {
                throw new BudgetRequestException(BudgetRequestException.HASBOTPBILL);
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection item = filter.getFilterItems();
            item.add(new FilterItemInfo("bgRequestBill.id", (Object)billId.toString(), CompareType.EQUALS));
            IBgRequestAdjustBill ibgAdjust = BgRequestAdjustBillFactory.getLocalInstance(ctx);
            if (ibgAdjust.exists(filter)) {
                throw new BudgetRequestException(BudgetRequestException.HASADJUSTBILL);
            }
        } else {
            throw new BudgetRequestException(BudgetRequestException.ISRIGHTSATEBILL);
        }
        BudgetRequestBillControllerBean.applyMutexService(ctx, billId.toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        BudgetCtrlCaller.returnBudget((Context)ctx, (BOSUuid)billId);
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgprocess);
        budgetRequestBillInfo.setAuditor(null);
        budgetRequestBillInfo.setAuditDate(null);
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
        isUnAudit = true;
        BudgetRequestBillControllerBean.releaseMutexService(ctx, billId.toString());
        return isUnAudit;
    }

    @Override
    protected boolean _wfAudit(Context ctx, BOSUuid billId, BOSUuid userId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isWfAudit = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)(pk = new ObjectUuidPK(billId)));
        if (budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgprocess) || budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgsubmit)) {
            IBudgetRequestBillEntry iBudgetRequestBillEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
            BudgetRequestBillEntryCollection billEntryCollection = budgetRequestBillInfo.getBgEnties();
            BudgetRequestBillEntryInfo entryInfo = null;
            ObjectUuidPK entryPk = null;
            for (int i = 0; i < billEntryCollection.size(); ++i) {
                entryInfo = billEntryCollection.get(i);
                entryPk = new ObjectUuidPK(entryInfo.getId());
                BigDecimal appValue = entryInfo.getApplyValue();
                if (appValue == null) {
                    appValue = BgNConstants.ZERO;
                }
                entryInfo.setCheckValue(appValue);
                iBudgetRequestBillEntry.update((IObjectPK)entryPk, entryInfo);
            }
        } else {
            throw new BudgetRequestException(BudgetRequestException.ISRIGHTSATEBILL);
        }
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgAudited);
        budgetRequestBillInfo.setAuditDate(new Date());
        budgetRequestBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
        isWfAudit = true;
        return isWfAudit;
    }

    @Override
    protected boolean _wfUnAudit(Context ctx, BOSUuid billId, BOSUuid userId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isWfUnAudit = false;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)(pk = new ObjectUuidPK(billId)));
        if (budgetRequestBillInfo.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
            BOTRelationCollection botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(billId.toString());
            if (botRelationCol != null && botRelationCol.size() > 0) {
                return false;
            }
            budgetRequestBillInfo.setState(BudgetBillStateEnum.bgprocess);
            ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
            isWfUnAudit = true;
        }
        return isWfUnAudit;
    }

    @Override
    protected void _updateAuditingState(Context ctx, BOSUuid billId, BOSUuid userId) throws BOSException, EASBizException {
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgsubmit);
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
    }

    @Override
    protected void _updateEditState(Context ctx, BOSUuid billId, BOSUuid userId) throws BOSException, EASBizException {
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgprocess);
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
    }

    @Override
    protected void _updateAuditedState(Context ctx, BOSUuid billId, BOSUuid userId) throws BOSException, EASBizException {
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
        budgetRequestBillInfo.setState(BudgetBillStateEnum.bgAudited);
        budgetRequestBillInfo.setAuditDate(new Date());
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
    }

    @Override
    protected boolean _reMakeCoseDate(Context ctx, BOSUuid billId, Date closeEndDate) throws BOSException, EASBizException {
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
        BudgetRequestBillControllerBean.applyMutexService(ctx, billId.toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        budgetRequestBillInfo.setBgEndDate(closeEndDate);
        ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
        BudgetRequestBillControllerBean.releaseMutexService(ctx, billId.toString());
        return true;
    }

    @Override
    protected String _isApplyValueToUseValue(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String isApplyValueToUseValue = null;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
        BudgetRequestBillEntryCollection billEntryCollection = budgetRequestBillInfo.getBgEnties();
        BudgetRequestBillEntryInfo entryInfo = null;
        for (int i = 0; i < billEntryCollection.size(); ++i) {
            entryInfo = billEntryCollection.get(i);
            BigDecimal appValue = entryInfo.getApplyValue();
            BigDecimal useValue = BudgetRequestBillControllerBean.getAllBOTPValue(ctx, billId.toString(), entryInfo.getId().toString());
            if (appValue == null) {
                appValue = BgNConstants.ZERO;
            }
            if (useValue == null) {
                useValue = BgNConstants.ZERO;
            }
            if (appValue.compareTo(useValue) == 0) continue;
            return entryInfo.getBgItemName();
        }
        return isApplyValueToUseValue;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BudgetRequestBillInfo info = (BudgetRequestBillInfo)model;
        String LogName = "";
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (info.getNumber() == null || info.getNumber().trim().length() == 0) {
            BgHelper.setSNumber((Context)ctx, (String)info.getCU().getId().toString(), (CoreBaseInfo)info);
        }
        if (info.getNumber() == null || info.getNumber().length() == 0) {
            throw new BudgetRequestException(BudgetRequestException.NUMBERISNULL);
        }
        this.checkBudgetBillNumber(ctx, info);
        LogName = info.getNumber();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)LogName, (String)"bgRequestBill_Add");
        IObjectPK tempObject = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return tempObject;
    }

    protected void checkBudgetBillNumber(Context ctx, BudgetRequestBillInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.setMaskString("#0 AND #1");
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("number", (Object)model.getNumber(), CompareType.EQUALS));
        item.add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
        IBudgetRequestBill iBudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        if (iBudgetRequestBill.exists(filter)) {
            throw new BudgetRequestException(BudgetRequestException.NUMBERREPEAT, new String[]{model.getNumber()});
        }
    }

    public static void applyMutexService(Context ctx, String id, String userID) throws BOSException, BudgetRequestException {
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isRequest = iMC.requestObjIDForUpdate(id, userID);
        if (!isRequest) {
            throw new BudgetRequestException(BudgetRequestException.LOCKINFO);
        }
    }

    public static void releaseMutexService(Context ctx, String id) throws BOSException {
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMC.releaseObjIDForUpdate(id);
    }

    @Override
    protected void _updateAdjustingState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        if (ibudgetRequestBill.exists((IObjectPK)(pk = new ObjectUuidPK(billId)))) {
            BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
            budgetRequestBillInfo.setState(BudgetBillStateEnum.adjusting);
            ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
        }
    }

    @Override
    protected void _updateAuditedState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IBudgetRequestBill ibudgetRequestBill = BudgetRequestBillFactory.getLocalInstance(ctx);
        if (ibudgetRequestBill.exists((IObjectPK)(pk = new ObjectUuidPK(billId)))) {
            BudgetRequestBillInfo budgetRequestBillInfo = (BudgetRequestBillInfo)ibudgetRequestBill.getValue((IObjectPK)pk);
            budgetRequestBillInfo.setState(BudgetBillStateEnum.bgAudited);
            ibudgetRequestBill.update((IObjectPK)pk, (CoreBaseInfo)budgetRequestBillInfo);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botObj = (BOTRelationInfo)bOTRelationInfo;
        BudgetRequestBillEntryInfo bgEntryInfo = null;
        IBudgetRequestBillEntry ibgEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
        String destObjectID = botObj.getDestObjectID();
        ObjectUuidPK destObjPK = new ObjectUuidPK(destObjectID);
        BOSObjectType type = BudgetRequestBillControllerBean.getBOSType(destObjectID);
        if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                logger.info((Object)"\u9884\u7b97\u7533\u8bf7\u5355\u5f00\u59cb\u751f\u6210\u4ed8\u6b3e\u5355");
                PaymentBillInfo billInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destObjPK);
                PaymentBillEntryCollection entryColl = billInfo.getEntries();
                if (entryColl != null && entryColl.size() > 0) {
                    for (int i = 0; i < entryColl.size(); ++i) {
                        BigDecimal totalUseValue;
                        PaymentBillEntryInfo entryInfo = entryColl.get(i);
                        if (entryInfo.getSourceBillEntryId() == null) continue;
                        String srcBillEntryId = entryInfo.getSourceBillEntryId();
                        String srcBillId = entryInfo.getSourceBillId();
                        BigDecimal payment = entryInfo.getAmount();
                        bgEntryInfo = ibgEntry.getBudgetRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(srcBillEntryId));
                        BigDecimal applyValue = bgEntryInfo.getApplyValue();
                        if (applyValue.compareTo(totalUseValue = BudgetRequestBillControllerBean.getAllBOTPValue(ctx, srcBillId, srcBillEntryId, destObjectID).add(payment)) != -1) continue;
                        throw new BudgetRequestException(BudgetRequestException.BOTPFAIL, new Object[]{bgEntryInfo.getBgItemName()});
                    }
                }
                logger.info((Object)"\u9884\u7b97\u7533\u8bf7\u5355\u5df2\u751f\u6210\u4ed8\u6b3e\u5355");
            }
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
            PurObjectType objectType = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx).getPurObjectType(type, (IObjectPK)destObjPK, true);
            PurObjectEntryType entryType = null;
            List entryList = null;
            if (objectType != null && (entryList = objectType.getEntries()) != null) {
                int n = entryList.size();
                for (int i = 0; i < n; ++i) {
                    BigDecimal totalUseValue;
                    entryType = (PurObjectEntryType)entryList.get(i);
                    if (entryType.getSourceBillEntryId() == null) continue;
                    String srcBillEntryId = entryType.getSourceBillEntryId();
                    String srcBillId = entryType.getSourceBillId();
                    BigDecimal payment = entryType.getAmount();
                    bgEntryInfo = ibgEntry.getBudgetRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(srcBillEntryId));
                    BigDecimal applyValue = bgEntryInfo.getApplyValue();
                    if (applyValue.compareTo(totalUseValue = BudgetRequestBillControllerBean.getAllBOTPValue(ctx, srcBillId, srcBillEntryId, destObjectID).add(payment)) != -1) continue;
                    throw new BudgetRequestException(BudgetRequestException.BOTPFAIL, new Object[]{bgEntryInfo.getBgItemName()});
                }
                logger.info((Object)("create " + objectType.getBotpBillName()));
            }
        }
    }

    private static BigDecimal getAllBOTPValue(Context ctx, String srcObjId, String srcObjEntryId, String destObjectId) throws BOSException, EASBizException {
        BigDecimal useValue = new BigDecimal(0);
        if (srcObjId == null) {
            return useValue;
        }
        BOTRelationCollection botRelationCol = null;
        BOTRelationInfo relationInfo = null;
        BOSObjectType destObjType = null;
        botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(srcObjId);
        if (botRelationCol != null && botRelationCol.size() > 0) {
            for (int i = 0; i < botRelationCol.size(); ++i) {
                relationInfo = botRelationCol.get(i);
                String destObjID = relationInfo.getDestObjectID();
                if (destObjID.equals(destObjectId)) continue;
                destObjType = BudgetRequestBillControllerBean.getBOSType(destObjID);
                ObjectUuidPK destObjPK = new ObjectUuidPK(destObjID);
                if (new PaymentBillInfo().getBOSType().equals((Object)destObjType)) {
                    PaymentBillInfo billInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destObjPK);
                    if (!billInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) && !billInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                    PaymentBillEntryCollection entryColl = billInfo.getEntries();
                    PaymentBillEntryInfo entryInfo = null;
                    if (entryColl == null || entryColl.size() <= 0) continue;
                    for (int j = 0; j < entryColl.size(); ++j) {
                        entryInfo = entryColl.get(j);
                        if (entryInfo.getSourceBillEntryId() == null || !entryInfo.getSourceBillEntryId().equals(srcObjEntryId)) continue;
                        useValue = useValue.add(entryInfo.getAmount());
                    }
                    continue;
                }
                IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
                PurObjectType returnValue = purfacade.getPurObjectType(destObjType, (IObjectPK)destObjPK, false);
                if (returnValue == null) continue;
                List entryList = returnValue.getEntries();
                PurObjectEntryType entryType = null;
                if (entryList == null) continue;
                int n = entryList.size();
                for (int j = 0; j < n; ++j) {
                    entryType = (PurObjectEntryType)entryList.get(i);
                    if (entryType.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryType.getSourceBillEntryId())) continue;
                    useValue = useValue.add(entryType.getAmount());
                }
            }
        }
        return useValue;
    }

    private static BigDecimal getAllBOTPValue(Context ctx, String srcObjId, String srcObjEntryId) throws BOSException, EASBizException {
        BigDecimal useValue = new BigDecimal(0);
        if (srcObjId == null) {
            return useValue;
        }
        BOTRelationCollection botRelationCol = null;
        BOTRelationInfo relationInfo = null;
        BOSObjectType destObjType = null;
        botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(srcObjId);
        if (botRelationCol != null && botRelationCol.size() > 0) {
            for (int i = 0; i < botRelationCol.size(); ++i) {
                relationInfo = botRelationCol.get(i);
                String destObjID = relationInfo.getDestObjectID();
                destObjType = BudgetRequestBillControllerBean.getBOSType(destObjID);
                ObjectUuidPK destObjPK = new ObjectUuidPK(destObjID);
                if (new PaymentBillInfo().getBOSType().equals((Object)destObjType)) {
                    PaymentBillInfo billInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destObjPK);
                    if (!billInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) && !billInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                    PaymentBillEntryCollection entryColl = billInfo.getEntries();
                    PaymentBillEntryInfo entryInfo = null;
                    if (entryColl == null || entryColl.size() <= 0) continue;
                    for (int j = 0; j < entryColl.size(); ++j) {
                        entryInfo = entryColl.get(j);
                        if (!entryInfo.getSourceBillEntryId().equals(srcObjEntryId)) continue;
                        useValue = useValue.add(entryInfo.getAmount());
                    }
                    continue;
                }
                IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
                PurObjectType returnValue = purfacade.getPurObjectType(destObjType, (IObjectPK)destObjPK, false);
                if (returnValue == null) continue;
                List entryList = returnValue.getEntries();
                PurObjectEntryType entryType = null;
                if (entryList == null) continue;
                int n = entryList.size();
                for (int j = 0; j < n; ++j) {
                    entryType = (PurObjectEntryType)entryList.get(j);
                    if (entryType.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryType.getSourceBillEntryId())) continue;
                    useValue = useValue.add(entryType.getAmount());
                }
            }
        }
        return useValue;
    }

    @Override
    protected void _reWriteBillAtAntiAudit(Context ctx, IObjectPK[] destObjPks) throws BOSException, EASBizException {
        if (destObjPks == null || destObjPks.length == 0) {
            return;
        }
        BOSObjectType type = null;
        ObjectUuidPK srcObjEntryId = null;
        BigDecimal destObjEntryAmount = new BigDecimal(0);
        IBudgetRequestBillEntry iBgEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
        BudgetRequestBillEntryInfo bgEntryInfo = null;
        int count = destObjPks.length;
        for (int i = 0; i < count; ++i) {
            type = BudgetRequestBillControllerBean.getBOSType(destObjPks[i].toString());
            if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
                PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo(destObjPks[i]);
                int size = info.getEntries().size();
                for (int j = 0; j < size; ++j) {
                    if (info.getEntries().get(j).getSourceBillEntryId() == null || !iBgEntry.exists((IObjectPK)(srcObjEntryId = new ObjectUuidPK(info.getEntries().get(j).getSourceBillEntryId())))) continue;
                    destObjEntryAmount = info.getEntries().get(j).getAmount().negate();
                    bgEntryInfo = iBgEntry.getBudgetRequestBillEntryInfo((IObjectPK)srcObjEntryId);
                    bgEntryInfo.setUseValue(bgEntryInfo.getUseValue().add(destObjEntryAmount));
                    iBgEntry.update((IObjectPK)srcObjEntryId, bgEntryInfo);
                }
                continue;
            }
            IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
            PurObjectType returnValue = purfacade.getPurObjectType(type, destObjPks[i], true);
            if (returnValue == null) continue;
            List entryList = returnValue.getEntries();
            PurObjectEntryType entryType = null;
            if (entryList == null) continue;
            int size = entryList.size();
            for (int j = 0; j < size; ++j) {
                entryType = (PurObjectEntryType)entryList.get(j);
                if (entryType.getSourceBillEntryId() == null || !iBgEntry.exists((IObjectPK)(srcObjEntryId = new ObjectUuidPK(entryType.getSourceBillEntryId())))) continue;
                destObjEntryAmount = entryType.getAmount().negate();
                bgEntryInfo = iBgEntry.getBudgetRequestBillEntryInfo((IObjectPK)srcObjEntryId);
                bgEntryInfo.setUseValue(bgEntryInfo.getUseValue().add(destObjEntryAmount));
                iBgEntry.update((IObjectPK)srcObjEntryId, bgEntryInfo);
            }
        }
    }

    @Override
    protected void _reWriteBillAtAudit(Context ctx, IObjectPK[] destObjPks) throws BOSException, EASBizException {
        if (destObjPks == null || destObjPks.length == 0) {
            return;
        }
        BOSObjectType type = null;
        ObjectUuidPK srcObjEntryId = null;
        BigDecimal destObjEntryAmount = new BigDecimal(0);
        IBudgetRequestBillEntry iBgEntry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
        BudgetRequestBillEntryInfo bgEntryInfo = null;
        int count = destObjPks.length;
        for (int i = 0; i < count; ++i) {
            type = BudgetRequestBillControllerBean.getBOSType(destObjPks[i].toString());
            if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
                PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo(destObjPks[i]);
                int size = info.getEntries().size();
                for (int j = 0; j < size; ++j) {
                    if (info.getEntries().get(j).getSourceBillEntryId() == null || !iBgEntry.exists((IObjectPK)(srcObjEntryId = new ObjectUuidPK(info.getEntries().get(j).getSourceBillEntryId())))) continue;
                    destObjEntryAmount = info.getEntries().get(j).getAmount();
                    bgEntryInfo = iBgEntry.getBudgetRequestBillEntryInfo((IObjectPK)srcObjEntryId);
                    bgEntryInfo.setUseValue(bgEntryInfo.getUseValue().add(destObjEntryAmount));
                    iBgEntry.update((IObjectPK)srcObjEntryId, bgEntryInfo);
                }
                continue;
            }
            IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
            PurObjectType returnValue = purfacade.getPurObjectType(type, destObjPks[i], true);
            if (returnValue == null) continue;
            List entryList = returnValue.getEntries();
            PurObjectEntryType entryType = null;
            if (entryList == null) continue;
            int size = entryList.size();
            for (int j = 0; j < size; ++j) {
                entryType = (PurObjectEntryType)entryList.get(j);
                if (entryType.getSourceBillEntryId() == null || !iBgEntry.exists((IObjectPK)(srcObjEntryId = new ObjectUuidPK(entryType.getSourceBillEntryId())))) continue;
                destObjEntryAmount = entryType.getAmount().negate();
                bgEntryInfo = iBgEntry.getBudgetRequestBillEntryInfo((IObjectPK)srcObjEntryId);
                bgEntryInfo.setUseValue(bgEntryInfo.getUseValue().add(destObjEntryAmount));
                iBgEntry.update((IObjectPK)srcObjEntryId, bgEntryInfo);
            }
        }
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BudgetRequestBillInfo budgetRequestInfo = (BudgetRequestBillInfo)super._getValue(ctx, pk);
        return budgetRequestInfo.getNumber();
    }

    @Override
    protected void _checkNumber(Context ctx, BudgetRequestBillInfo info) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        conn = this.getConnection(ctx);
        ResultSet rs = null;
        String sql = "select fid from T_BG_BudgetRequestBill where FNumber = ? and FOrgUnitID = ? and FID <> ? ;";
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, info.getNumber());
            pstmt.setString(2, info.getOrgUnit().getId().toString());
            pstmt.setString(3, info.getId().toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }
}

