/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BudgetBillStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillCollection;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBillEntry;
import com.kingdee.eas.ma.nbudget.app.AbstractBudgetRequestBillFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.IPur4budgetFacade;
import com.kingdee.eas.scm.sm.pur.Pur4budgetFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.PurObjectEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurObjectType;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BudgetRequestBillFacadeControllerBean
extends AbstractBudgetRequestBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BudgetRequestBillFacadeControllerBean");

    @Override
    protected void _closeBillBySys(Context ctx) throws BOSException, EASBizException {
        IBudgetRequestBill billFactory = BudgetRequestBillFactory.getLocalInstance(ctx);
        IBudgetRequestBillEntry entryFacotry = BudgetRequestBillEntryFactory.getLocalInstance(ctx);
        BudgetRequestBillCollection billColl = null;
        BudgetRequestBillEntryCollection entryColl = null;
        BudgetRequestBillInfo billInfo = null;
        BudgetRequestBillEntryInfo entryInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("state", (Object)new Integer(5));
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("bgEndDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        billColl = billFactory.getBudgetRequestBillCollection(view);
        for (int i = 0; i < billColl.size(); ++i) {
            boolean isNeedBack = false;
            billInfo = billColl.get(i);
            ObjectUuidPK billPk = new ObjectUuidPK(billInfo.getId());
            ObjectUuidPK entryPk = null;
            entryColl = billInfo.getBgEnties();
            for (int j = 0; j < entryColl.size(); ++j) {
                entryInfo = entryColl.get(j);
                entryPk = new ObjectUuidPK(entryInfo.getId());
                BigDecimal appValue = entryInfo.getApplyValue();
                BigDecimal useValue = BudgetRequestBillFacadeControllerBean.getAllBOTPValue(ctx, billPk.toString(), entryInfo.getId().toString());
                if (appValue == null) {
                    appValue = BgNConstants.ZERO;
                }
                if (useValue == null) {
                    useValue = BgNConstants.ZERO;
                }
                if (appValue.compareTo(useValue) == 0) continue;
                isNeedBack = true;
                BigDecimal unUseValue = appValue.subtract(useValue).negate();
                entryInfo.setCheckValue(unUseValue);
                entryFacotry.update((IObjectPK)entryPk, entryInfo);
            }
            if (isNeedBack) {
                BudgetCtrlCaller.requestBudget((Context)ctx, (BOSUuid)billInfo.getId());
            }
            billInfo.setState(BudgetBillStateEnum.bgClosed);
            billFactory.update((IObjectPK)billPk, (CoreBaseInfo)billInfo);
            this._sendMessage(ctx, billInfo);
        }
    }

    private static BigDecimal getAllBOTPValue(Context ctx, String srcObjId, String srcObjEntryId) throws BOSException, EASBizException {
        BigDecimal useValue = new BigDecimal(0);
        if (srcObjId == null) {
            return useValue;
        }
        BOTRelationCollection botRelationCol = null;
        BOTRelationInfo relationInfo = null;
        BOSObjectType destObjType = null;
        botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(srcObjId);
        if (botRelationCol != null && botRelationCol.size() > 0) {
            for (int i = 0; i < botRelationCol.size(); ++i) {
                relationInfo = botRelationCol.get(i);
                String destObjID = relationInfo.getDestObjectID();
                destObjType = BudgetRequestBillFacadeControllerBean.getBOSType(destObjID);
                ObjectUuidPK destObjPK = new ObjectUuidPK(destObjID);
                if (new PaymentBillInfo().getBOSType().equals((Object)destObjType)) {
                    PaymentBillInfo billInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destObjPK);
                    if (!billInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) && !billInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                    PaymentBillEntryCollection entryColl = billInfo.getEntries();
                    PaymentBillEntryInfo entryInfo = null;
                    if (entryColl == null || entryColl.size() <= 0) continue;
                    for (int j = 0; j < entryColl.size(); ++j) {
                        entryInfo = entryColl.get(j);
                        if (!entryInfo.getSourceBillEntryId().equals(srcObjEntryId)) continue;
                        useValue = useValue.add(entryInfo.getAmount());
                    }
                    continue;
                }
                IPur4budgetFacade purfacade = Pur4budgetFacadeFactory.getLocalInstance((Context)ctx);
                PurObjectType returnValue = purfacade.getPurObjectType(destObjType, (IObjectPK)destObjPK, false);
                if (returnValue == null) continue;
                List entryList = returnValue.getEntries();
                PurObjectEntryType entryType = null;
                if (entryList == null) continue;
                int n = entryList.size();
                for (int j = 0; j < n; ++j) {
                    entryType = (PurObjectEntryType)entryList.get(j);
                    if (entryType.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryType.getSourceBillEntryId())) continue;
                    useValue = useValue.add(entryType.getAmount());
                }
            }
        }
        return useValue;
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    protected void _sendMessage(Context ctx, BudgetRequestBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo == null) {
            return;
        }
        String resourceFile = "com.kingdee.eas.ma.nbudget.BudgetRequestBillResource";
        Object title = null;
        String body = null;
        SenderAgent agent = null;
        Message message = null;
        Locale locale = null;
        locale = ctx.getLocale();
        body = ResourceBase.getString((String)resourceFile, (String)"billClose", (Locale)locale);
        body = MessageFormat.format(body, billInfo.getNumber());
        agent = SenderAgent.getSenderAgent();
        message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setLocaleStringHeader("title", body, locale);
        message.setLocaleStringHeader("sender", ctx.getUserName(), locale);
        message.setLocaleStringHeader("body", body, locale);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", billInfo.getCreator().getId().toString());
        agent.sendMessage(message);
    }
}

