/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgActualCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgActualCalculator.class);
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();
    private int parameterCount = 7;

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void setParameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    public BgActualCalculator() {
    }

    public BgActualCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgActual start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            Parameter parameter = null;
            Object[] objs = null;
            if (params != null && !params.isEmpty()) {
                parameter = params.getParameter(0);
                objs = parameter.getArgs();
                if (objs.length == 8) {
                    this.setParameterCount(8);
                } else {
                    this.setParameterCount(7);
                }
            }
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgActual finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        String[] _formulas = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgFormulaSet = null;
        BgFormulaInfo _bgFormula = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _beginPeriodNumber = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            _endPeriodNumber = (String)((Variant)_parmeter.getArgs()[6]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgFormulaInfo(this, _parmeter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (this.getParameterCount() == 8) {
                _key = _key + "!" + _bgFormula.getActualSource();
            }
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                this.getExpressMap().put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x]);
            }
        }
    }

    protected void calculate() throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("SELECT FBizActual, FFormula FROM T_Bg_BgData ").append("WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula IN (");
        for (int index = 1; index < this.getBatchSize(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String actualSource = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        Connection newConn = null;
        PreparedStatement pstmt = null;
        Statement newPstme = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                if (this.getParameterCount() == 8) {
                    actualSource = _key[2];
                }
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    if (this.getParameterCount() == 8 && !"all".equals(actualSource)) {
                        Map resultBgDataIds = this.getBgDataIdByFormula(_bgFormulaList, _orgUnitId, _bgSchemeId);
                        if (resultBgDataIds == null || resultBgDataIds.isEmpty()) continue;
                        int type = this.getSourceType(actualSource);
                        StringBuffer exeSql = new StringBuffer();
                        exeSql.append("Select sum(FActualAmount) result ,FBgDataId from t_bg_BgCtrlRecord where FBgDataId in(");
                        Object[] params = new Object[resultBgDataIds.size() + 1];
                        int x = 0;
                        Iterator it = resultBgDataIds.keySet().iterator();
                        while (it.hasNext()) {
                            params[x] = it.next();
                            ++x;
                            exeSql.append("?,");
                        }
                        exeSql.deleteCharAt(exeSql.length() - 1);
                        exeSql.append(") ");
                        exeSql.append("And FBgTraceType= ? ");
                        exeSql.append(" group by FBgDataId ");
                        params[resultBgDataIds.size()] = new Integer(type);
                        IRowSet result = DbUtil.executeQuery((Context)this.getCtx(), (String)exeSql.toString(), (Object[])params);
                        while (result.next()) {
                            _value = result.getBigDecimal("result");
                            if (_value == null) {
                                _value = BgConstants.BIGZERO;
                            }
                            _formulaStr = resultBgDataIds.get(result.getString("FBgDataId")).toString();
                            _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).append("!").append(actualSource).toString();
                            this.getBgDataMap().put(_tmpKey, _value);
                        }
                    } else {
                        pstmt.setString(1, _orgUnitId);
                        pstmt.setString(2, _bgSchemeId);
                        int x = 3;
                        while (x < this.getBatchSize() + 3) {
                            if (pos < size) {
                                pstmt.setString(x, (String)_bgFormulaList.get(pos));
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _value = rst.getBigDecimal(1);
                            _formulaStr = rst.getString(2);
                            _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).toString();
                            this.getBgDataMap().put(_tmpKey, _value);
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                SQLUtils.cleanup(rst, newPstme, newConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup(rst, newPstme, newConn);
    }

    public Map getBgDataIdByFormula(List bgFormulaList, String orgId, String bgSchemeId) throws SQLException {
        if (bgFormulaList == null || bgFormulaList.isEmpty() || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rst = null;
        int n = bgFormulaList.size();
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FId ,FFormula  from t_bg_bgdata WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in ( ");
        for (int index = 1; index < n; ++index) {
            sql.append("?,");
        }
        sql.append("?");
        sql.append(")");
        conn = EJBFactory.getConnection((Context)this.getCtx());
        pstmt = conn.prepareStatement(sql.toString());
        pstmt.setString(1, orgId);
        pstmt.setString(2, bgSchemeId);
        int y = 0;
        int x = 3;
        while (x < n + 3) {
            pstmt.setString(x, (String)bgFormulaList.get(y));
            ++x;
            ++y;
        }
        rst = pstmt.executeQuery();
        while (rst.next()) {
            String bgdateId = rst.getString(1);
            String formula = rst.getString(2);
            map.put(bgdateId, formula);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return map;
    }

    private int getSourceType(String sourceStr) {
        if (StringUtils.isEmpty((String)sourceStr)) {
            return 0;
        }
        int source = 0;
        source = "actualInit".equals(sourceStr) ? 1 : ("actualRecord".equals(sourceStr) ? 2 : ("billCtrlRecord".equals(sourceStr) ? 3 : 0));
        return source;
    }

    protected void fillValue() {
        String _key = null;
        String _orgKey = null;
        String _formulaStr2 = null;
        String actualSource = null;
        String[] _formulas = null;
        BigDecimal _value = null;
        BgFormulaInfo _bgFormula = null;
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgFormulaInfo)this.getFormulaList().get(i);
            _value = BgNConstants.ZERO;
            if (_bgFormula.isCalculator()) {
                _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
                _formulas = _bgFormula.getFormulas();
                if (this.getParameterCount() == 8) {
                    actualSource = _bgFormula.getActualSource();
                }
                if (_formulas != null) {
                    for (String _formulaStr2 : _formulas) {
                        _key = new StringBuffer(_orgKey).append("!").append(_formulaStr2).toString();
                        if (this.getParameterCount() == 8 && actualSource != null && !"all".equals(actualSource)) {
                            _key = _key + "!" + actualSource;
                        }
                        if (!this.getBgDataMap().containsKey(_key)) continue;
                        _value = _value.add((BigDecimal)this.getBgDataMap().get(_key));
                    }
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }
}

