/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgPeriodExtEnum;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgActualCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgActualExtInfo;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgActualExt
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgActualCalculator.class);
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgActualExt() {
    }

    public BgActualExt(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgActual start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgActual finished!");
    }

    @Override
    protected void parserBgPeriodWithCaculater(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportVariables rv = this.getProvider().getReportVariables();
        String tempDate = null;
        String pNumber = null;
        HashMap<String, String> beginDateCache = new HashMap<String, String>();
        HashMap<String, String> endDateCache = new HashMap<String, String>();
        Parameter _parameter = null;
        Object _obj = null;
        Object[] _objs = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        IReportPropertyAdapter adapter = null;
        int _periodType = 0;
        int _currYear = 0;
        int _currPeriod = 0;
        String _orgUnitNumber = null;
        String _schemeNumber = null;
        adapter = this.getProvider().getReportAdapter();
        _obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String _currOrgUnitNumber = (String)adapter.getReportProperty("Company.Number");
        String _currCurrencyNumber = (String)adapter.getReportProperty("Currency.Number");
        String _currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        String _bgSchemeNumber = (String)adapter.getReportProperty("BG_SCHEME_NUMBER");
        String _bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        String _bgBeginDate = (String)adapter.getReportProperty("bg_begin_date");
        String _bgEndDate = (String)adapter.getReportProperty("bg_end_date");
        if (_obj == null) {
            _periodType = (Integer)adapter.getReportProperty("PeriodType");
            _currYear = (Integer)adapter.getReportProperty("Report.Year");
            _currPeriod = (Integer)adapter.getReportProperty("Report.Period");
        }
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            _objs = _parameter.getArgs();
            _orgUnitNumber = (String)((Variant)_objs[0]).getValue();
            _schemeNumber = (String)((Variant)_objs[1]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _objs[0] = !StringUtils.isEmpty((String)_bgOrgNumber) ? new Variant((Object)_bgOrgNumber) : new Variant((Object)_currOrgUnitNumber);
            }
            if (StringUtils.isEmpty((String)_schemeNumber)) {
                _objs[1] = new Variant((Object)_bgSchemeNumber);
            }
            _objs[4] = this.parserCurrencyParameter((Variant)_objs[4], _currCurrencyNumber);
            if (_obj != null && _obj instanceof Integer && (Integer)_obj != 8) {
                if (_objs[5] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[5].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
                if (_objs[6] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[6].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
            }
            Object obj_Date = this.getCtx().get((Object)"DateContextHandler_date");
            Object obj_TimeType = this.getCtx().get((Object)"DateContextHandler_date");
            if (StringUtils.isEmpty((String)((String)((Variant)_objs[5]).getValue()))) {
                if (rv != null && rv.contains("StartBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()))) {
                    pNumber = this.parserBgPeriodParameter(new Variant((Object)rv.getStringValue("StartBgPeriod", _parameter.getSheetName())), _currPeriodNumber).getValue().toString();
                    if (beginDateCache.get(pNumber) instanceof String) {
                        _objs[5] = new Variant(beginDateCache.get(pNumber));
                    } else {
                        tempDate = this.getPeriodDate(pNumber, "FBeginDate", null);
                        if (StringUtils.isEmpty((String)pNumber)) {
                            _objs[5] = new Variant((Object)_bgBeginDate);
                        } else {
                            _objs[5] = new Variant((Object)tempDate);
                            beginDateCache.put(pNumber, tempDate);
                        }
                    }
                } else {
                    _objs[5] = new Variant((Object)_bgBeginDate);
                }
            }
            if (StringUtils.isEmpty((String)((String)((Variant)_objs[6]).getValue()))) {
                if (rv != null && rv.contains("EndBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("EndBgPeriod", _parameter.getSheetName()))) {
                    pNumber = this.parserBgPeriodParameter(new Variant((Object)rv.getStringValue("EndBgPeriod", _parameter.getSheetName())), _currPeriodNumber).getValue().toString();
                    if (endDateCache.get(pNumber) instanceof String) {
                        _objs[6] = new Variant(endDateCache.get(pNumber));
                    } else {
                        tempDate = this.getPeriodDate(pNumber, "FEndDate", null);
                        if (StringUtils.isEmpty((String)tempDate)) {
                            _objs[6] = new Variant((Object)_bgEndDate);
                        } else {
                            _objs[6] = new Variant((Object)tempDate);
                            endDateCache.put(pNumber, tempDate);
                        }
                    }
                } else {
                    _objs[6] = new Variant((Object)_bgEndDate);
                }
            }
            if (_obj != null) {
                _objs[5] = this.parserBgPeriodParameter((Variant)_objs[5], _currPeriodNumber);
                _objs[6] = this.parserBgPeriodParameter((Variant)_objs[6], _currPeriodNumber);
                continue;
            }
            if (obj_Date != null && obj_TimeType != null && obj_Date instanceof java.util.Date && obj_TimeType.getClass().getName().equals("com.kingdee.eas.ma.nbudget.KPITimeTypeEnum")) {
                _objs[5] = this.parserPeriodParamForKPI((Variant)_objs[5], (java.util.Date)obj_Date, (StringEnum)obj_TimeType);
                _objs[6] = this.parserPeriodParamForKPI((Variant)_objs[6], (java.util.Date)obj_Date, (StringEnum)obj_TimeType);
                continue;
            }
            _objs[5] = this.parserPeriodParameter((Variant)_objs[5], _periodType, _currYear, _currPeriod);
            _objs[6] = this.parserPeriodParameter((Variant)_objs[6], _periodType, _currYear, _currPeriod);
        }
        beginDateCache.clear();
        endDateCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        int _periodType;
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        Object _beginPeriodNumber = null;
        Object _endPeriodNumber = null;
        String _beginPeriodDate = null;
        String _endPeriodDate = null;
        String _periodType1 = null;
        String[] _formulas = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgFormulaSet = null;
        BgActualExtInfo _bgFormula = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _beginPeriodDate = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            _endPeriodDate = (String)((Variant)_parmeter.getArgs()[6]).getValue();
            _periodType = this.getperiod((String)((Variant)_parmeter.getArgs()[7]).getValue());
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodDate) || StringUtils.isEmpty((String)_endPeriodDate)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodDate) != BgNPeriodHelper.parserBgPeriodType(_endPeriodDate)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgActualExtInfo(this, _parmeter, this.getCtx());
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            this.getFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgActualExtInfo)this.getFormulaList().get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _periodType1 = _bgFormula.getPeriodType();
            _periodType = this.getperiod(_periodType1);
            _beginPeriodDate = _bgFormula.getBeginPeriodDate();
            _endPeriodDate = _bgFormula.getEndPeriodDate();
            _bgFormula.set_periodType(_periodType);
            _bgFormula.setBeginPeriodDate(_beginPeriodDate);
            _bgFormula.setEndPeriodDate(_endPeriodDate);
            _key = _bgFormula.getOrgAndBgSchemeIdKeyAll() + "!" + _bgFormula.toString();
            if (this.getExpressMap().containsKey(_key)) {
                _bgFormulaSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                this.getExpressMap().put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x]);
            }
        }
    }

    protected void calculate() throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("SELECT sum(b.factualamount) FROM t_bg_bgctrlrecord B left join T_Bg_BgData C on B.fbgdataid = C.fid").append("  WHERE  b.fdaydate >=  ? ").append(" AND b.fdaydate <=  ?  ").append(" AND( (b.fbgperiodid in (select Fnumber from t_bg_bgperiod where fperiodtype = ? ) and B.FbgTraceType in (3,4,5,6,7)) or B.FbgTraceType in (1,2) )").append(" and b.fbgdataid in (   SELECT a.fid FROM T_Bg_BgData a where a.FOrgUnitId = ? ").append(" AND a.FBgSchemeId = ? AND a.FFormula like ? ) ");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        Object _formulaStr = null;
        java.util.Date _beginDate = null;
        java.util.Date _endDate = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                int _periodType = Integer.parseInt(_key[4]);
                _beginDate = this.getBeginDate(_key[2]);
                _endDate = this.getEndDate(_key[3]);
                Date _beginDate1 = new Date(_beginDate.getTime());
                Date _endDate1 = new Date(_endDate.getTime());
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setInt(3, _periodType);
                    pstmt.setDate(1, _beginDate1);
                    pstmt.setDate(2, _endDate1);
                    pstmt.setString(4, _orgUnitId);
                    pstmt.setString(5, _bgSchemeId);
                    pstmt.setString(6, (String)_bgFormulaList.get(pos));
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        if (_value == null) {
                            _value = BigDecimal.valueOf(0L);
                        }
                        _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_beginDate).append("!").append(_endDate).append("!").append((String)_bgFormulaList.get(pos)).toString();
                        this.getBgDataMap().put(_tmpKey, _value);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void fillValue() {
        String _key = null;
        String _orgKey = null;
        String _formulaStr = "";
        String[] _formulas = null;
        BigDecimal _value = null;
        java.util.Date _beginDate = null;
        java.util.Date _endDate = null;
        BgActualExtInfo _bgFormula = null;
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgActualExtInfo)this.getFormulaList().get(i);
            _value = BgNConstants.ZERO;
            if (_bgFormula.isCalculator()) {
                _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
                _formulas = _bgFormula.getFormulas();
                _beginDate = this.getBeginDate(_bgFormula.getBeginPeriodDate());
                _endDate = this.getEndDate(_bgFormula.getEndPeriodDate());
                if (_formulas != null) {
                    _formulaStr = _formulas[0];
                    _key = new StringBuffer(_orgKey).append("!").append(_beginDate).append("!").append(_endDate).append("!").append(_formulaStr).toString();
                    if (this.getBgDataMap().containsKey(_key)) {
                        _value = _value.add((BigDecimal)this.getBgDataMap().get(_key));
                    }
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    protected java.util.Date getBeginDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int len = Math.min(time.length(), 10);
        String date = time.substring(0, len) + " 00:00:00";
        try {
            java.util.Date begindate = sdf.parse(date);
            return begindate;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    protected java.util.Date getEndDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int len = Math.min(time.length(), 10);
        String date = time.substring(0, len) + " 23:59:59";
        try {
            java.util.Date enddate = sdf.parse(date);
            return enddate;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    protected int getperiod(String time) {
        BgPeriodExtEnum period = BgPeriodExtEnum.getEnum((String)time);
        return period.getValue();
    }

    @Override
    protected void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPeriodDate(String periodNumber, String fieldName, String dateFormatter) {
        if (StringUtils.isEmpty((String)periodNumber) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        if (StringUtils.isEmpty((String)dateFormatter)) {
            dateFormatter = "yyyy-MM-dd";
        }
        String sql = "Select " + fieldName + " from t_bg_bgperiod where fnumber = ?";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatter);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql, (Object[])new Object[]{periodNumber});
            if (rs != null && rs.next()) {
                String string = sdf.format(rs.getDate(1));
                return string;
            }
            String string = null;
            return string;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        return null;
    }
}

