/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.IBgCalculator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.StringEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgCalculator
implements IBgCalculator {
    private static final Logger logger = Logger.getLogger(BgCalculator.class);
    private ICalculateContextProvider provider;
    private Context ctx = null;
    private Map orgUnitMap = new HashMap();
    private Map bgSchemeMap = new HashMap();
    private List bgPeriodList = new ArrayList();
    private Map bgDataMap = new HashMap(250);
    private Map bgAdjDataMap = new HashMap(250);
    private Map cacheMap = new HashMap();
    private Map bgPeriodCacheMap = new HashMap();
    private Map bgFormulaMapFromBook = null;
    private static final int batchSize = 250;
    private static final String MATCH_STR = "\\-?\\d+";
    public static final String DateContextHandler_DATE = "DateContextHandler_date";
    public static final String DateContextHandler_TIMPTYPE = "DateContextHandler_date";
    public static final String DoubleOrgError = "#BAD FUNCTION: Source cell is not numeric!";

    public BgCalculator() {
    }

    public BgCalculator(ICalculateContextProvider provider, Context ctx) {
        this.setProvider(provider);
        this.setCtx(ctx);
        this.setBgFormulaMapFromBook();
    }

    @Override
    public void execute(SortedParameterArray params) {
    }

    public void execute(ICalculateContextProvider provider, Context ctx, SortedParameterArray params) {
        this.setProvider(provider);
        this.setCtx(ctx);
        this.execute(params);
    }

    protected void clear() {
        this.getOrgUnitMap().clear();
        this.getBgSchemeMap().clear();
        this.getBgPeriodList().clear();
        this.getCacheMap().clear();
        this.getBgPeriodCacheMap().clear();
        this.getBgDataMap().clear();
        this.getBgAdjDataMap().clear();
        this.getBgFormulaMapFromBook().clear();
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    protected ICalculateContextProvider getProvider() {
        return this.provider;
    }

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map getBgSchemeMap() {
        return this.bgSchemeMap;
    }

    public List getBgPeriodList() {
        return this.bgPeriodList;
    }

    public Map getBgDataMap() {
        return this.bgDataMap;
    }

    public Map getBgAdjDataMap() {
        return this.bgAdjDataMap;
    }

    public Map getCacheMap() {
        return this.cacheMap;
    }

    public Map getBgPeriodCacheMap() {
        return this.bgPeriodCacheMap;
    }

    protected int getBatchSize() {
        return 250;
    }

    private void setBgFormulaMapFromBook() {
        IReportPropertyAdapter adapter = null;
        adapter = this.getProvider().getReportAdapter();
        this.bgFormulaMapFromBook = (Map)adapter.getReportProperty("Report_FormulaMap");
        if (this.bgFormulaMapFromBook == null) {
            this.bgFormulaMapFromBook = new HashMap();
        }
    }

    public Map getBgFormulaMapFromBook() {
        return this.bgFormulaMapFromBook;
    }

    public void updateBgDataMap() {
        String _key2 = null;
        for (String _key2 : this.getBgFormulaMapFromBook().keySet()) {
            this.getBgDataMap().put(_key2, this.getBgFormulaMapFromBook().get(_key2));
        }
    }

    public void updateBgAdjDataMap() {
        String _key2 = null;
        for (String _key2 : this.getBgFormulaMapFromBook().keySet()) {
            this.getBgAdjDataMap().put(_key2, this.getBgFormulaMapFromBook().get(_key2));
        }
    }

    protected void getOrgUnitInfo(Set orgUnitNumberSet) throws Exception {
        if (orgUnitNumberSet == null || orgUnitNumberSet.isEmpty()) {
            return;
        }
        ArrayList _orgUnitNumberList = new ArrayList();
        _orgUnitNumberList.addAll(orgUnitNumberSet);
        int size = _orgUnitNumberList.size();
        int count = (size - 1) / this.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fnumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FNumber FROM T_ORG_CostCenter WHERE FNumber IN (");
        for (int i = 1; i < this.getBatchSize(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= this.getBatchSize()) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_orgUnitNumberList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fnumber = rst.getString("FNumber");
                    this.getOrgUnitMap().put(_fnumber, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _orgUnitNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _orgUnitNumberList.clear();
    }

    protected void getBgSchemeInfo(Set bgSchemeNumberSet) throws Exception {
        if (bgSchemeNumberSet == null || bgSchemeNumberSet.isEmpty()) {
            return;
        }
        ArrayList _bgSchemeNumberList = new ArrayList();
        _bgSchemeNumberList.addAll(bgSchemeNumberSet);
        int tmp = 0;
        int size = _bgSchemeNumberList.size();
        int count = (size - 1) / this.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fOrgNumber = null;
        String _fBgSchemeNumber = null;
        String _key = null;
        String[] _tmpStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT S.FID, S.FNumber, S.FOrgUnitId, B.FNumber FOrgUnitNumber FROM T_BG_BgScheme S LEFT JOIN T_ORG_CostCenter B ON S.FOrgUnitId = B.FID WHERE ");
        for (int i = 1; i < this.getBatchSize(); ++i) {
            sql.append("(B.FNumber = ? and S.FNumber = ?) or ");
        }
        sql.append("(B.FNumber = ? and S.FNumber = ?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= this.getBatchSize()) {
                    tmp = x * 2;
                    if (pos < size) {
                        _key = (String)_bgSchemeNumberList.get(pos);
                        _tmpStr = _key.split("!");
                        pstmt.setString(tmp - 1, _tmpStr[0]);
                        pstmt.setString(tmp, _tmpStr[1]);
                    } else {
                        pstmt.setString(tmp - 1, "#");
                        pstmt.setString(tmp, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fOrgNumber = rst.getString("FOrgUnitNumber");
                    _fBgSchemeNumber = rst.getString("FNumber");
                    _key = _fOrgNumber + "!" + _fBgSchemeNumber;
                    this.getBgSchemeMap().put(_key, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgSchemeNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _bgSchemeNumberList.clear();
    }

    protected void getBgPeriodInfo() throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] _periodInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement("SELECT FNumber, FPeriodType FROM T_BG_BgPeriod ORDER BY FNumber ASC");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _periodInfo = new Object[]{rst.getString(1), new Integer(rst.getInt(2))};
                this.getBgPeriodList().add(_periodInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    public List parserBgPeriod(String beginBgPeriodNumber, String endBgPeriodNumber) {
        int _endType;
        ArrayList<String> _bgPeriodList = null;
        if (StringUtils.isEmpty((String)beginBgPeriodNumber) || StringUtils.isEmpty((String)endBgPeriodNumber) || this.getBgPeriodList().isEmpty()) {
            return _bgPeriodList;
        }
        if (beginBgPeriodNumber.equals(endBgPeriodNumber)) {
            _bgPeriodList = new ArrayList<String>();
            _bgPeriodList.add(beginBgPeriodNumber);
            return _bgPeriodList;
        }
        int _beginType = this.parserBgPeriodType(beginBgPeriodNumber);
        if (_beginType != (_endType = this.parserBgPeriodType(endBgPeriodNumber))) {
            return _bgPeriodList;
        }
        boolean _include = false;
        Object[] _periodInfo = null;
        String _periodNumber = null;
        int _periodType = 0;
        _bgPeriodList = new ArrayList();
        int size = this.getBgPeriodList().size();
        for (int index = 0; index < size; ++index) {
            _periodInfo = (Object[])this.getBgPeriodList().get(index);
            _periodNumber = (String)_periodInfo[0];
            _periodType = (Integer)_periodInfo[1];
            if (_periodType != _beginType) continue;
            if (!_include && (_periodNumber.equals(beginBgPeriodNumber) || _periodNumber.compareTo(beginBgPeriodNumber) > 0 && _periodNumber.compareTo(endBgPeriodNumber) <= 0)) {
                _include = true;
            }
            if (_include) {
                _bgPeriodList.add(_periodNumber);
            }
            if (_include && (_periodNumber.equals(endBgPeriodNumber) || _periodNumber.compareTo(beginBgPeriodNumber) < 0)) break;
        }
        return _bgPeriodList;
    }

    protected int parserBgPeriodType(String bgPeriodNumber) {
        int bgPeriodType = 0;
        String[] parameter = null;
        String _code = null;
        String _bgPeriodNumber = null;
        _bgPeriodNumber = bgPeriodNumber;
        parameter = _bgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    bgPeriodType = 1;
                    break;
                }
                case 2: {
                    _code = parameter[1].substring(2);
                    if ("HY".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) break;
                        bgPeriodType = 2;
                        break;
                    }
                    if ("Q".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) break;
                        bgPeriodType = 3;
                        break;
                    }
                    if ("M".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) break;
                        bgPeriodType = 4;
                        break;
                    }
                    if (!"W".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}W", _bgPeriodNumber)) break;
                    bgPeriodType = 5;
                    break;
                }
                case 3: {
                    _code = parameter[2].substring(2);
                    if ("D".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", _bgPeriodNumber)) break;
                        bgPeriodType = 7;
                        break;
                    }
                    if ("TD".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", _bgPeriodNumber)) break;
                        bgPeriodType = 9;
                        break;
                    }
                    if (!"MW".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) break;
                    bgPeriodType = 6;
                    break;
                }
            }
        }
        return bgPeriodType;
    }

    protected void parserBgPeriodWithCaculater(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportVariables rv = this.getProvider().getReportVariables();
        Variant variant = null;
        Parameter _parameter = null;
        Object _obj = null;
        Object[] _objs = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        IReportPropertyAdapter adapter = null;
        int _periodType = 0;
        int _currYear = 0;
        int _currPeriod = 0;
        String _orgUnitNumber = null;
        String _schemeNumber = null;
        adapter = this.getProvider().getReportAdapter();
        _obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String _currOrgUnitNumber = (String)adapter.getReportProperty("Company.Number");
        String _currCurrencyNumber = (String)adapter.getReportProperty("Currency.Number");
        String _currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        String _bgSchemeNumber = (String)adapter.getReportProperty("BG_SCHEME_NUMBER");
        String _bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        if (_obj == null) {
            _periodType = (Integer)adapter.getReportProperty("PeriodType");
            _currYear = (Integer)adapter.getReportProperty("Report.Year");
            _currPeriod = (Integer)adapter.getReportProperty("Report.Period");
        }
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            _objs = _parameter.getArgs();
            _orgUnitNumber = (String)((Variant)_objs[0]).getValue();
            _schemeNumber = (String)((Variant)_objs[1]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _objs[0] = !StringUtils.isEmpty((String)_bgOrgNumber) ? new Variant((Object)_bgOrgNumber) : new Variant((Object)_currOrgUnitNumber);
            }
            if (StringUtils.isEmpty((String)_schemeNumber)) {
                _objs[1] = new Variant((Object)_bgSchemeNumber);
            }
            _objs[4] = this.parserCurrencyParameter((Variant)_objs[4], _currCurrencyNumber);
            if (_obj != null && _obj instanceof Integer && (Integer)_obj != 8) {
                if (_objs[5] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[5].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
                if (_objs[6] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[6].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
            }
            if (_objs[5] instanceof Variant && ((variant = (Variant)_objs[5]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("StartBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()))) {
                _objs[5] = new Variant((Object)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()));
            }
            if (_objs[6] instanceof Variant && ((variant = (Variant)_objs[6]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("EndBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("EndBgPeriod", _parameter.getSheetName()))) {
                _objs[6] = new Variant((Object)rv.getStringValue("EndBgPeriod", _parameter.getSheetName()));
            }
            Object obj_Date = this.getCtx().get((Object)"DateContextHandler_date");
            Object obj_TimeType = this.getCtx().get((Object)"DateContextHandler_date");
            if (_obj != null) {
                _objs[5] = this.parserBgPeriodParameter((Variant)_objs[5], _currPeriodNumber);
                _objs[6] = this.parserBgPeriodParameter((Variant)_objs[6], _currPeriodNumber);
                continue;
            }
            if (obj_Date != null && obj_TimeType != null && obj_Date instanceof Date && obj_TimeType.getClass().getName().equals("com.kingdee.eas.ma.nbudget.KPITimeTypeEnum")) {
                _objs[5] = this.parserPeriodParamForKPI((Variant)_objs[5], (Date)obj_Date, (StringEnum)obj_TimeType);
                _objs[6] = this.parserPeriodParamForKPI((Variant)_objs[6], (Date)obj_Date, (StringEnum)obj_TimeType);
                continue;
            }
            _objs[5] = this.parserPeriodParameter((Variant)_objs[5], _periodType, _currYear, _currPeriod);
            _objs[6] = this.parserPeriodParameter((Variant)_objs[6], _periodType, _currYear, _currPeriod);
        }
    }

    protected Variant parserCurrencyParameter(Variant currencyNumber, String currCurrencyNumber) {
        if (currencyNumber == null || currencyNumber.getValue() == null) {
            return new Variant((Object)currCurrencyNumber);
        }
        String _currencyNumber = currencyNumber.getValue().toString();
        if (StringUtils.isEmpty((String)_currencyNumber)) {
            return new Variant((Object)currCurrencyNumber);
        }
        return currencyNumber;
    }

    protected Variant parserBgPeriodParameter(Variant bgPeriodNumber, String currBgPeriodNumber) {
        if (bgPeriodNumber == null || bgPeriodNumber.getValue() == null) {
            return new Variant((Object)currBgPeriodNumber);
        }
        String _bgPeriodNumber = bgPeriodNumber.getValue().toString();
        if (StringUtils.isEmpty((String)_bgPeriodNumber) || "0".equals(_bgPeriodNumber)) {
            return new Variant((Object)currBgPeriodNumber);
        }
        if (Pattern.matches(MATCH_STR, _bgPeriodNumber)) {
            int _offset = 0;
            try {
                _offset = Integer.parseInt(_bgPeriodNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer _offsetKey = new Integer(_offset);
            if (this.getBgPeriodCacheMap().containsKey(_offsetKey)) {
                _bgPeriodNumber = (String)this.getBgPeriodCacheMap().get(_offsetKey);
            } else {
                _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(currBgPeriodNumber, _offset);
                this.getBgPeriodCacheMap().put(_offsetKey, _bgPeriodNumber);
            }
        }
        return new Variant((Object)_bgPeriodNumber);
    }

    protected Variant parserPeriodParamForKPI(Variant bgPeriodNumber, Date bizDate, StringEnum type) {
        int _offset = 0;
        String _bgPeriodNumber = null;
        String tmpNumber = BgNPeriodHelper.getBgPeriodNumberForKPI(bizDate, type);
        if (bgPeriodNumber != null && bgPeriodNumber.getValue() != null) {
            String _offStr = bgPeriodNumber.getValue().toString();
            if (Pattern.matches(MATCH_STR, _offStr)) {
                try {
                    _offset = Integer.parseInt(_offStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String _offsetKey = tmpNumber + String.valueOf(_offset);
                if (this.getBgPeriodCacheMap().containsKey(_offsetKey)) {
                    _bgPeriodNumber = (String)this.getBgPeriodCacheMap().get(_offsetKey);
                } else {
                    _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(tmpNumber, _offset);
                    this.getBgPeriodCacheMap().put(_offsetKey, _bgPeriodNumber);
                }
            } else if (!StringUtils.isEmpty((String)_offStr)) {
                _bgPeriodNumber = _offStr;
            }
        }
        if (_bgPeriodNumber == null) {
            _bgPeriodNumber = tmpNumber;
        }
        return new Variant((Object)_bgPeriodNumber);
    }

    protected Variant parserPeriodParameter(Variant bgPeriodNumber, int periodType, int currYear, int currPeriod) {
        int _offset = 0;
        String _bgPeriodNumber = null;
        if (bgPeriodNumber != null && bgPeriodNumber.getValue() != null) {
            String _offStr = bgPeriodNumber.getValue().toString();
            if (Pattern.matches(MATCH_STR, _offStr)) {
                try {
                    _offset = Integer.parseInt(_offStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String _offsetKey = String.valueOf(periodType) + "_" + String.valueOf(currYear) + "_" + String.valueOf(currPeriod) + "_" + String.valueOf(_offset);
                if (this.getBgPeriodCacheMap().containsKey(_offsetKey)) {
                    _bgPeriodNumber = (String)this.getBgPeriodCacheMap().get(_offsetKey);
                } else {
                    _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(periodType, currYear, currPeriod, _offset);
                    this.getBgPeriodCacheMap().put(_offsetKey, _bgPeriodNumber);
                }
            } else if (!StringUtils.isEmpty((String)_offStr)) {
                _bgPeriodNumber = _offStr;
            }
        }
        if (_bgPeriodNumber == null) {
            _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(periodType, currYear, currPeriod, 0);
        }
        return new Variant(_bgPeriodNumber);
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }
}

