/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.KPITimeTypeEnum;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgCdInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCdCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgCdCalculator.class);
    private List cdList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgCdCalculator() {
    }

    public BgCdCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    @Override
    public void execute(SortedParameterArray params) {
        try {
            this.initParams(params);
            this.calculate();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.fillValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        this.parserBgPeriodWithCaculater(params);
        BgCdInfo _bgCdInfo = null;
        String _orgTree = null;
        String _orgUnion = null;
        String _orgUnionId = null;
        String _bgSchemeNumber = null;
        String _bgSchemeId = null;
        String _bgElementNumber = null;
        String _strItemCombinNum = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        String _dataType = null;
        Parameter _parmeter = null;
        HashSet<String> _orgUnionNumberSet = new HashSet<String>();
        HashSet<String> _bgSchemeNumberSet = new HashSet<String>();
        Set<String> _bgCdSet = null;
        String[] _cds = null;
        String _key = null;
        SyntaxErrorException _exception = new SyntaxErrorException(128L);
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            _orgTree = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _orgUnion = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgElementNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _strItemCombinNum = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            _beginPeriodNumber = (String)((Variant)_parmeter.getArgs()[6]).getValue();
            _endPeriodNumber = (String)((Variant)_parmeter.getArgs()[7]).getValue();
            _dataType = (String)((Variant)_parmeter.getArgs()[8]).getValue();
            if (StringUtils.isEmpty((String)_orgTree) || StringUtils.isEmpty((String)_orgUnion) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_strItemCombinNum) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber) || StringUtils.isEmpty((String)_currencyNumber)) {
                _parmeter.setValue((Object)_exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parmeter.setValue((Object)_exception);
                continue;
            }
            _bgCdInfo = new BgCdInfo(this, _parmeter);
            if (!_orgUnionNumberSet.contains(_bgCdInfo.getOrgUnion())) {
                _orgUnionNumberSet.add(_bgCdInfo.getOrgUnion());
            }
            if (!_bgSchemeNumberSet.contains(_key = _bgCdInfo.getTreeAndBgSchemeNumberKey())) {
                _bgSchemeNumberSet.add(_key);
            }
            this.getCdList().add(_bgCdInfo);
        }
        try {
            this.getOrgUnitInfo(_orgUnionNumberSet);
            this.getBgSchemeInfo(_bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            _orgUnionNumberSet.clear();
            _bgSchemeNumberSet.clear();
        }
        int jn = this.getCdList().size();
        for (int j = 0; j < jn; ++j) {
            _bgCdInfo = (BgCdInfo)this.getCdList().get(j);
            _bgCdInfo.parser();
            _orgUnionId = (String)this.getOrgUnitMap().get(_bgCdInfo.getOrgUnion());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgCdInfo.getTreeAndBgSchemeNumberKey());
            _bgCdInfo.setOrgUnionId(_orgUnionId);
            _bgCdInfo.setBgSchemeId(_bgSchemeId);
            _key = _bgCdInfo.getOrgAndBgSchemeAndDataTypeIdKey();
            if (this.getExpressMap().containsKey(_key)) {
                _bgCdSet = (Set)this.getExpressMap().get(_key);
            } else {
                _bgCdSet = new HashSet();
                this.getExpressMap().put(_key, _bgCdSet);
            }
            _cds = _bgCdInfo.getCds();
            if (_cds == null) continue;
            int xn = _cds.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgCdSet.contains(_cds[x])) continue;
                _bgCdSet.add(_cds[x]);
            }
        }
    }

    protected void calculate() throws Exception {
        int index;
        StringBuffer sqlCslData = new StringBuffer(1024);
        StringBuffer sqlWorkData = new StringBuffer(1024);
        sqlCslData.append("SELECT FFORMULA,FCONSOLIDAMOUNT FROM T_BG_BGCSLDATA WHERE FORGGROUPID=? AND FBGSCHEMEID= ? AND FDATATYPE = ? AND FFORMULA IN(");
        for (index = 1; index < this.getBatchSize(); ++index) {
            sqlCslData.append("?,");
        }
        sqlCslData.append("?)");
        sqlWorkData.append("SELECT FFORMULA,FCONSOLIDAMOUNT FROM T_BG_BGWORKDATA WHERE FORGGROUPID=? AND FBGSCHEMEID= ? AND FDATATYPE = ? AND FFORMULA IN(");
        for (index = 1; index < this.getBatchSize(); ++index) {
            sqlWorkData.append("?,");
        }
        sqlWorkData.append("?)");
        Map.Entry _entry2 = null;
        String _tmpKey = null;
        String[] _key = null;
        String _orgUnion = null;
        String _bgschemeId = null;
        String _cdStr = null;
        int _datatype = 0;
        BigDecimal _value = null;
        Set _bgCdSet = null;
        ArrayList _bgCdList = new ArrayList();
        int size = 0;
        int count = 0;
        int pos = 0;
        HashMap _temMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sqlCslData.toString());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgCdSet = (Set)_entry2.getValue();
                _bgCdList.clear();
                _bgCdList.addAll(_bgCdSet);
                HashSet _temHashSet = new HashSet();
                _temHashSet.addAll(_bgCdSet);
                _temMap.put(_tmpKey, _temHashSet);
                _key = _tmpKey.split("!");
                _orgUnion = _key[0];
                _bgschemeId = _key[1];
                _datatype = this.getDataType(_key[2]);
                pos = 0;
                size = _bgCdList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index2 = 0; index2 < count; ++index2) {
                    pstmt.setString(1, _orgUnion);
                    pstmt.setString(2, _bgschemeId);
                    pstmt.setInt(3, _datatype);
                    int x = 4;
                    while (x < this.getBatchSize() + 4) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgCdList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _cdStr = rst.getString(1);
                        _value = rst.getBigDecimal(2);
                        this.getBgDataMap().put(_tmpKey + "!" + _cdStr, _value);
                        ((HashSet)_temMap.get(_tmpKey)).remove(_cdStr);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            pstmt = conn.prepareStatement(sqlWorkData.toString());
            for (Map.Entry _entry2 : _temMap.entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgCdSet = (Set)_entry2.getValue();
                _bgCdList.clear();
                _bgCdList.addAll(_bgCdSet);
                _key = _tmpKey.split("!");
                _orgUnion = _key[0];
                _bgschemeId = _key[1];
                _datatype = this.getDataType(_key[2]);
                pos = 0;
                size = _bgCdList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index3 = 0; index3 < count; ++index3) {
                    pstmt.setString(1, _orgUnion);
                    pstmt.setString(2, _bgschemeId);
                    pstmt.setInt(3, _datatype);
                    int x = 4;
                    while (x < this.getBatchSize() + 4) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgCdList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _cdStr = rst.getString(1);
                        _value = rst.getBigDecimal(2);
                        this.getBgDataMap().put(_tmpKey + "!" + _cdStr, _value);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void fillValue() {
        BgCdInfo _bgCd = null;
        BigDecimal _value = null;
        String[] _cds = null;
        int in = this.getCdList().size();
        for (int i = 0; i < in; ++i) {
            _bgCd = (BgCdInfo)this.getCdList().get(i);
            _value = BgNConstants.ZERO;
            _cds = _bgCd.getCds();
            if (_cds != null) {
                int jn = _cds.length;
                for (int j = 0; j < jn; ++j) {
                    BigDecimal obj = (BigDecimal)this.getBgDataMap().get(_bgCd.getOrgAndBgSchemeAndDataTypeIdKey() + "!" + _cds[j]);
                    _value = _value.add(obj == null ? BgConstants.BIGZERO : obj);
                }
            }
            _bgCd.getParam().setValue((Object)_value);
        }
    }

    public List getCdList() {
        return this.cdList;
    }

    public void setCdList(List cdList) {
        this.cdList = cdList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    public void setExpressMap(Map expressMap) {
        this.expressMap = expressMap;
    }

    @Override
    protected void getOrgUnitInfo(Set orgUnitNumberSet) throws Exception {
        if (orgUnitNumberSet == null || orgUnitNumberSet.isEmpty()) {
            return;
        }
        ArrayList _orgUnitNumberList = new ArrayList();
        _orgUnitNumberList.addAll(orgUnitNumberSet);
        int size = _orgUnitNumberList.size();
        int count = (size - 1) / this.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fnumber = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FNumber FROM T_ORG_BaseUnit WHERE FNumber IN (");
        for (int i = 1; i < this.getBatchSize(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= this.getBatchSize()) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_orgUnitNumberList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fnumber = rst.getString("FNumber");
                    this.getOrgUnitMap().put(_fnumber, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _orgUnitNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _orgUnitNumberList.clear();
    }

    @Override
    protected void getBgSchemeInfo(Set bgSchemeNumberSet) throws Exception {
        if (bgSchemeNumberSet == null || bgSchemeNumberSet.isEmpty()) {
            return;
        }
        ArrayList _bgSchemeNumberList = new ArrayList();
        _bgSchemeNumberList.addAll(bgSchemeNumberSet);
        int tmp = 0;
        int size = _bgSchemeNumberList.size();
        int count = (size - 1) / this.getBatchSize() + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fTreeNumber = null;
        String _fBgSchemeNumber = null;
        String _key = null;
        String[] _tmpStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T.FNUMBER FTREENUMBER,S.FNUMBER FSCHEMENUMBER, S.FID  FROM T_BG_BGElimOrgMapping M JOIN T_ORG_TREE T ON T.FID = M.FTreeId  JOIN T_BG_BgScheme S ON S.FOrgUnitId = M.FOrgUnitId WHERE ");
        for (int i = 1; i < this.getBatchSize(); ++i) {
            sql.append("(T.FNUMBER = ? AND S.FNUMBER = ?) OR ");
        }
        sql.append("(T.FNUMBER = ? AND S.FNUMBER = ?)");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= this.getBatchSize()) {
                    tmp = x * 2;
                    if (pos < size) {
                        _key = (String)_bgSchemeNumberList.get(pos);
                        _tmpStr = _key.split("!");
                        pstmt.setString(tmp - 1, _tmpStr[0]);
                        pstmt.setString(tmp, _tmpStr[1]);
                    } else {
                        pstmt.setString(tmp - 1, "#");
                        pstmt.setString(tmp, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString("FID");
                    _fTreeNumber = rst.getString("FTREENUMBER");
                    _fBgSchemeNumber = rst.getString("FSCHEMENUMBER");
                    _key = _fTreeNumber + "!" + _fBgSchemeNumber;
                    this.getBgSchemeMap().put(_key, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgSchemeNumberList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _bgSchemeNumberList.clear();
    }

    private int getDataType(String sourceStr) {
        if (StringUtils.isEmpty((String)sourceStr)) {
            return 0;
        }
        int source = 0;
        if (BgDataTypeEnum.BgData.getName().equals(sourceStr)) {
            source = 1;
        } else if (BgDataTypeEnum.BgActual.getName().equals(sourceStr)) {
            source = 2;
        }
        return source;
    }

    @Override
    protected void parserBgPeriodWithCaculater(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportVariables rv = this.getProvider().getReportVariables();
        Variant variant = null;
        Parameter _parameter = null;
        Object _obj = null;
        Object[] _objs = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        IReportPropertyAdapter adapter = null;
        int _periodType = 0;
        int _currYear = 0;
        int _currPeriod = 0;
        adapter = this.getProvider().getReportAdapter();
        _obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String _currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        if (_obj == null) {
            _periodType = (Integer)adapter.getReportProperty("PeriodType");
            _currYear = (Integer)adapter.getReportProperty("Report.Year");
            _currPeriod = (Integer)adapter.getReportProperty("Report.Period");
        }
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            _objs = _parameter.getArgs();
            if (_obj != null && _obj instanceof Integer && (Integer)_obj != 8) {
                if (_objs[6] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[6].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
                if (_objs[7] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[7].toString())) {
                    _parameter.setValue((Object)exception);
                    continue;
                }
            }
            if (_objs[6] instanceof Variant && ((variant = (Variant)_objs[6]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("StartBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()))) {
                _objs[6] = new Variant((Object)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()));
            }
            if (_objs[7] instanceof Variant && ((variant = (Variant)_objs[7]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("EndBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("EndBgPeriod", _parameter.getSheetName()))) {
                _objs[7] = new Variant((Object)rv.getStringValue("EndBgPeriod", _parameter.getSheetName()));
            }
            Object obj_Date = this.getCtx().get((Object)"DateContextHandler_date");
            Object obj_TimeType = this.getCtx().get((Object)"timetype");
            if (_obj != null) {
                _objs[6] = this.parserBgPeriodParameter((Variant)_objs[6], _currPeriodNumber);
                _objs[7] = this.parserBgPeriodParameter((Variant)_objs[7], _currPeriodNumber);
                continue;
            }
            if (obj_Date != null && obj_TimeType != null && obj_Date instanceof Date && obj_TimeType instanceof KPITimeTypeEnum) {
                _objs[6] = this.parserPeriodParamForKPI((Variant)_objs[6], (Date)obj_Date, (KPITimeTypeEnum)((Object)obj_TimeType));
                _objs[7] = this.parserPeriodParamForKPI((Variant)_objs[7], (Date)obj_Date, (KPITimeTypeEnum)((Object)obj_TimeType));
                continue;
            }
            _objs[6] = this.parserPeriodParameter((Variant)_objs[6], _periodType, _currYear, _currPeriod);
            _objs[7] = this.parserPeriodParameter((Variant)_objs[7], _periodType, _currYear, _currPeriod);
        }
    }
}

