/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.ma.nbudget.BgDifferenceTypeEnum;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgFormulaInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgDifferenceCalculator
extends BgCalculator {
    private static final Logger logger = Logger.getLogger(BgDifferenceCalculator.class);
    private List wfFormulaList = new ArrayList();
    private Map wfExpressMap = new HashMap();
    private List decFormulaList = new ArrayList();
    private Map decExpressMap = new HashMap();

    public BgDifferenceCalculator() {
    }

    public BgDifferenceCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getWfFormulaList() {
        return this.wfFormulaList;
    }

    public Map getWfExpressMap() {
        return this.wfExpressMap;
    }

    public List getDecFormulaList() {
        return this.decFormulaList;
    }

    public Map getDecExpressMap() {
        return this.decExpressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgDifference start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculateWorkFlow();
            this.calculateDecom();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgDifference finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgElementNumber = null;
        String _bgItemNumber = null;
        String _currencyNumber = null;
        String _beginPeriodNumber = null;
        String _endPeriodNumber = null;
        HashSet<String> orgUnitNumberSet = new HashSet<String>();
        HashSet<String> bgSchemeNumberSet = new HashSet<String>();
        BgFormulaInfo _bgFormula = null;
        Parameter _parameter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            String diffType;
            _parameter = params.getParameter(i);
            if (_parameter.getValue() != null && _parameter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parameter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parameter.getArgs()[1]).getValue();
            _bgElementNumber = (String)((Variant)_parameter.getArgs()[2]).getValue();
            _bgItemNumber = (String)((Variant)_parameter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parameter.getArgs()[4]).getValue();
            _beginPeriodNumber = (String)((Variant)_parameter.getArgs()[5]).getValue();
            _endPeriodNumber = (String)((Variant)_parameter.getArgs()[6]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgElementNumber) || StringUtils.isEmpty((String)_bgItemNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_beginPeriodNumber) || StringUtils.isEmpty((String)_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (BgNPeriodHelper.parserBgPeriodType(_beginPeriodNumber) != BgNPeriodHelper.parserBgPeriodType(_endPeriodNumber)) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parameter.setValue((Object)orgException);
                continue;
            }
            _bgFormula = new BgFormulaInfo(this, _parameter);
            if (!orgUnitNumberSet.contains(_bgFormula.getOrgUnitNumber())) {
                orgUnitNumberSet.add(_bgFormula.getOrgUnitNumber());
            }
            if (!bgSchemeNumberSet.contains(_key = _bgFormula.getOrgAndBgSchemeNumberKey())) {
                bgSchemeNumberSet.add(_key);
            }
            if ("WorkFlow".equalsIgnoreCase(diffType = ((Variant)_parameter.getArgs()[7]).getValue().toString()) || "1".equalsIgnoreCase(diffType)) {
                this.getWfFormulaList().add(_bgFormula);
                continue;
            }
            this.getDecFormulaList().add(_bgFormula);
        }
        try {
            this.getOrgUnitInfo(orgUnitNumberSet);
            this.getBgSchemeInfo(bgSchemeNumberSet);
            this.getBgPeriodInfo();
        }
        finally {
            orgUnitNumberSet.clear();
            bgSchemeNumberSet.clear();
        }
        this.parseFormulaAndExpress(this.getWfFormulaList(), this.getWfExpressMap());
        this.parseFormulaAndExpress(this.getDecFormulaList(), this.getDecExpressMap());
    }

    private void parseFormulaAndExpress(List formulaList, Map expressMap) {
        if (formulaList == null || formulaList.isEmpty() || expressMap == null) {
            return;
        }
        BgFormulaInfo _bgFormula = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _key = null;
        Set<String> _bgFormulaSet = null;
        String[] _formulas = null;
        int jn = formulaList.size();
        for (int j = 0; j < jn; ++j) {
            _bgFormula = (BgFormulaInfo)formulaList.get(j);
            _bgFormula.parser();
            _orgUnitId = (String)this.getOrgUnitMap().get(_bgFormula.getOrgUnitNumber());
            _bgSchemeId = (String)this.getBgSchemeMap().get(_bgFormula.getOrgAndBgSchemeNumberKey());
            _bgFormula.setOrgUnitId(_orgUnitId);
            _bgFormula.setBgSchemeId(_bgSchemeId);
            _key = _bgFormula.getOrgAndBgSchemeIdKey();
            if (expressMap.containsKey(_key)) {
                _bgFormulaSet = (Set)expressMap.get(_key);
            } else {
                _bgFormulaSet = new HashSet();
                expressMap.put(_key, _bgFormulaSet);
            }
            _formulas = _bgFormula.getFormulas();
            if (_formulas == null) continue;
            int xn = _formulas.length;
            for (int x = 0; x < xn; ++x) {
                if (_bgFormulaSet.contains(_formulas[x])) continue;
                _bgFormulaSet.add(_formulas[x]);
            }
        }
    }

    protected void calculateWorkFlow() throws Exception {
        if (this.getWfExpressMap().isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select pData.FFormula,pData.FAdjValue from T_BG_BgPastdata pData ").append("left join T_BG_BgPastrecord pRecord on pData.FPastRecordid = pRecord.fid ").append("left join T_BG_BgForm bgForm on pRecord.FBgFormID = bgForm.FID ").append("where pRecord.FPastSource =").append(6).append(" ").append("and bgForm.FOrgUnitId = ? AND bgForm.FBgSchemeId = ? ").append("and pData.FFormula IN (");
        for (int index = 1; index < this.getBatchSize(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getWfExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < this.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(2);
                        _formulaStr = rst.getString(1);
                        _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).append("!").append(0).toString();
                        if (this.getBgDataMap().containsKey(_tmpKey)) {
                            _value = _value.add((BigDecimal)this.getBgDataMap().get(_tmpKey));
                        }
                        this.getBgDataMap().put(_tmpKey, _value);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            this.updateBgAdjDataMap();
            this.updateBgDataMap();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"calculator WorkFlow error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculateDecom() throws Exception {
        if (this.getDecExpressMap().isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select pData.FFormula,pData.FPastValue from T_BG_BgPastdata pData ").append("left join T_BG_BgPastrecord pRecord on pData.FPastRecordid = pRecord.fid ").append("left join T_BG_BgForm bgForm on pRecord.FBgFormID = bgForm.FID ").append("where pRecord.FPastSource <>").append(6).append(" ").append("and bgForm.FOrgUnitId = ? AND bgForm.FBgSchemeId = ? ").append("and pData.FFormula IN (");
        for (int index = 1; index < this.getBatchSize(); ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        String _tmpKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _formulaStr = null;
        String[] _key = null;
        BigDecimal _value = null;
        Map.Entry _entry2 = null;
        Set _bgFormulaSet = null;
        ArrayList _bgFormulaList = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (Map.Entry _entry2 : this.getDecExpressMap().entrySet()) {
                _tmpKey = (String)_entry2.getKey();
                _bgFormulaSet = (Set)_entry2.getValue();
                _bgFormulaList.clear();
                _bgFormulaList.addAll(_bgFormulaSet);
                _key = _tmpKey.split("!");
                _orgUnitId = _key[0];
                _bgSchemeId = _key[1];
                pos = 0;
                size = _bgFormulaList.size();
                count = (size - 1) / this.getBatchSize() + 1;
                for (int index = 0; index < count; ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < this.getBatchSize() + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormulaList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(2);
                        _formulaStr = rst.getString(1);
                        _tmpKey = new StringBuffer(_orgUnitId).append("!").append(_bgSchemeId).append("!").append(_formulaStr).append("!").append(1).toString();
                        if (this.getBgDataMap().containsKey(_tmpKey)) {
                            _value = _value.add((BigDecimal)this.getBgDataMap().get(_tmpKey));
                        }
                        this.getBgDataMap().put(_tmpKey, _value);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            this.updateBgAdjDataMap();
            this.updateBgDataMap();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"calculator WorkFlow error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void fillValue() {
        this.fillValue(this.getWfFormulaList(), BgDifferenceTypeEnum.WorkFlow);
        this.fillValue(this.getDecFormulaList(), BgDifferenceTypeEnum.DecomDiff);
    }

    private void fillValue(List formulaList, BgDifferenceTypeEnum difType) {
        if (formulaList == null || formulaList.isEmpty()) {
            return;
        }
        BgFormulaInfo _bgFormula = null;
        String _key = null;
        String _orgKey = null;
        String _formulaStr2 = null;
        String[] _formulas = null;
        BigDecimal _value = null;
        int in = formulaList.size();
        for (int i = 0; i < in; ++i) {
            _bgFormula = (BgFormulaInfo)formulaList.get(i);
            _value = BgNConstants.ZERO;
            if (_bgFormula.isCalculator()) {
                _orgKey = _bgFormula.getOrgAndBgSchemeIdKey();
                _formulas = _bgFormula.getFormulas();
                if (_formulas != null) {
                    for (String _formulaStr2 : _formulas) {
                        _key = _orgKey + "!" + _formulaStr2 + "!" + difType.getValue();
                        if (!this.getBgDataMap().containsKey(_key)) continue;
                        _value = _value.add((BigDecimal)this.getBgDataMap().get(_key));
                    }
                }
            }
            if (_bgFormula.getParam().getValue() != null && _bgFormula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _bgFormula.getParam().setValue((Object)_value);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.getWfFormulaList().clear();
        this.getWfExpressMap().clear();
        this.getDecFormulaList().clear();
        this.getDecExpressMap().clear();
    }
}

