/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class BgFormulaInfo {
    private BgCalculator bgCalculator = null;
    private Parameter param = null;
    private boolean isCalculator = true;
    private String orgUnitId = null;
    private String orgUnitNumber = null;
    private String bgSchemeId = null;
    private String bgSchemeNumber = null;
    private String bgItemNumber = null;
    private String bgItemGroupNumber = null;
    private String bgElementNumber = null;
    private String currencyNumber = null;
    private String beginPeriodNumber = null;
    private String endPeriodNumber = null;
    private String actualSource = null;
    private String dataType = null;
    private String[] formulas = null;
    private List perdictPeriodList = new ArrayList();

    private BgFormulaInfo() {
    }

    public BgFormulaInfo(BgCalculator bgCalculator, Parameter param) {
        this.bgCalculator = bgCalculator;
        this.param = param;
        Object[] params = param.getArgs();
        this.orgUnitNumber = ((Variant)params[0]).getValue().toString();
        this.bgSchemeNumber = ((Variant)params[1]).getValue().toString();
        this.bgElementNumber = ((Variant)params[2]).getValue().toString();
        this.bgItemNumber = ((Variant)params[3]).getValue().toString();
        this.currencyNumber = ((Variant)params[4]).getValue().toString();
        if (((Variant)params[5]).getValue() != null) {
            this.beginPeriodNumber = ((Variant)params[5]).getValue().toString();
        }
        if (((Variant)params[5]).getValue() != null) {
            this.endPeriodNumber = ((Variant)params[6]).getValue().toString();
        }
        if (this.beginPeriodNumber == null || this.endPeriodNumber == null) {
            this.setCalculator(false);
        }
        if (params.length == 8) {
            this.actualSource = ((Variant)params[7]).getValue().toString();
        }
    }

    public BgFormulaInfo(BgCalculator bgCalculator, Parameter param, String orgUnitNumber, String bgSchemeNumber, String bgElementNumber, String bgItemGroupNumber, String bgItemNumber, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) {
        this.bgCalculator = bgCalculator;
        this.param = param;
        this.orgUnitNumber = orgUnitNumber;
        this.bgSchemeNumber = bgSchemeNumber;
        this.bgElementNumber = bgElementNumber;
        this.bgItemNumber = bgItemNumber;
        this.bgItemGroupNumber = bgItemGroupNumber;
        this.currencyNumber = currencyNumber;
        this.beginPeriodNumber = beginPeriodNumber;
        this.endPeriodNumber = endPeriodNumber;
        if (this.beginPeriodNumber == null || this.endPeriodNumber == null) {
            this.setCalculator(false);
        }
    }

    public BgFormulaInfo(BgCalculator bgCalculator, Parameter param, String orgUnitNumber, String bgSchemeNumber, String bgElementNumber, String bgItemGroupNumber, String bgItemNumber, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String dataType) {
        this.bgCalculator = bgCalculator;
        this.param = param;
        this.orgUnitNumber = orgUnitNumber;
        this.bgSchemeNumber = bgSchemeNumber;
        this.bgElementNumber = bgElementNumber;
        this.bgItemNumber = bgItemNumber;
        this.bgItemGroupNumber = bgItemGroupNumber;
        this.currencyNumber = currencyNumber;
        this.beginPeriodNumber = beginPeriodNumber;
        this.endPeriodNumber = endPeriodNumber;
        this.dataType = dataType;
        if (this.beginPeriodNumber == null || this.endPeriodNumber == null) {
            this.setCalculator(false);
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public BgCalculator getBgCalculator() {
        return this.bgCalculator;
    }

    public void setCalculator(boolean isCalculator) {
        this.isCalculator = isCalculator;
    }

    public boolean isCalculator() {
        return this.isCalculator;
    }

    public void parser() {
        if (this.isCalculator()) {
            String _key = new StringBuffer(this.beginPeriodNumber).append("!").append(this.endPeriodNumber).toString();
            List _bgPeriodList = null;
            if (this.getBgCalculator().getCacheMap().containsKey(_key)) {
                _bgPeriodList = (List)this.getBgCalculator().getCacheMap().get(_key);
            } else {
                _bgPeriodList = this.getBgCalculator().parserBgPeriod(this.beginPeriodNumber, this.endPeriodNumber);
                this.getBgCalculator().getCacheMap().put(_key, _bgPeriodList);
            }
            if (_bgPeriodList != null) {
                int size = _bgPeriodList.size();
                this.formulas = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.formulas[i] = new StringBuffer("=BgItem(\"" + this.bgItemNumber + "\",\"" + _bgPeriodList.get(i) + "\",\"" + this.bgElementNumber + "\",\"BgData\",true,\"" + this.currencyNumber + "\")").toString();
                }
            }
        }
    }

    public void parserForPerdict(Context ctx) throws Exception {
        this.getPerdictPeriodList().clear();
        this.getBgPeriodInfo(ctx);
        List _bgPeriodList = this.parserBgPeriod(this.beginPeriodNumber, this.endPeriodNumber);
        if (_bgPeriodList != null) {
            int size = _bgPeriodList.size();
            this.formulas = new String[size];
            for (int i = 0; i < size; ++i) {
                this.formulas[i] = new StringBuffer("=BgItem(\"" + this.bgItemNumber + "\",\"" + _bgPeriodList.get(i) + "\",\"" + this.bgElementNumber + "\",\"BgData\",true,\"" + this.currencyNumber + "\")").toString();
            }
        }
    }

    public List parserBgPeriod(String beginBgPeriodNumber, String endBgPeriodNumber) {
        int _endType;
        ArrayList<String> _bgPeriodList = null;
        if (StringUtils.isEmpty((String)beginBgPeriodNumber) || StringUtils.isEmpty((String)endBgPeriodNumber) || this.getPerdictPeriodList().isEmpty()) {
            return _bgPeriodList;
        }
        if (beginBgPeriodNumber.equals(endBgPeriodNumber)) {
            _bgPeriodList = new ArrayList<String>();
            _bgPeriodList.add(beginBgPeriodNumber);
            return _bgPeriodList;
        }
        int _beginType = this.parserBgPeriodType(beginBgPeriodNumber);
        if (_beginType != (_endType = this.parserBgPeriodType(endBgPeriodNumber))) {
            return _bgPeriodList;
        }
        boolean _include = false;
        Object[] _periodInfo = null;
        String _periodNumber = null;
        int _periodType = 0;
        _bgPeriodList = new ArrayList();
        int size = this.getPerdictPeriodList().size();
        for (int index = 0; index < size; ++index) {
            _periodInfo = (Object[])this.getPerdictPeriodList().get(index);
            _periodNumber = (String)_periodInfo[0];
            _periodType = (Integer)_periodInfo[1];
            if (_periodType != _beginType) continue;
            if (!_include && (_periodNumber.equals(beginBgPeriodNumber) || _periodNumber.compareTo(beginBgPeriodNumber) > 0 && _periodNumber.compareTo(endBgPeriodNumber) <= 0)) {
                _include = true;
            }
            if (_include) {
                _bgPeriodList.add(_periodNumber);
            }
            if (_include && (_periodNumber.equals(endBgPeriodNumber) || _periodNumber.compareTo(beginBgPeriodNumber) < 0)) break;
        }
        return _bgPeriodList;
    }

    private int parserBgPeriodType(String bgPeriodNumber) {
        int bgPeriodType = 0;
        String[] parameter = null;
        String _code = null;
        String _bgPeriodNumber = null;
        _bgPeriodNumber = bgPeriodNumber;
        parameter = _bgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    bgPeriodType = 1;
                    break;
                }
                case 2: {
                    _code = parameter[1].substring(2);
                    if ("HY".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) break;
                        bgPeriodType = 2;
                        break;
                    }
                    if ("Q".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) break;
                        bgPeriodType = 3;
                        break;
                    }
                    if ("M".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) break;
                        bgPeriodType = 4;
                        break;
                    }
                    if (!"W".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}W", _bgPeriodNumber)) break;
                    bgPeriodType = 5;
                    break;
                }
                case 3: {
                    _code = parameter[2].substring(2);
                    if ("D".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", _bgPeriodNumber)) break;
                        bgPeriodType = 7;
                        break;
                    }
                    if ("TD".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", _bgPeriodNumber)) break;
                        bgPeriodType = 9;
                        break;
                    }
                    if (!"MW".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) break;
                    bgPeriodType = 6;
                    break;
                }
            }
        }
        return bgPeriodType;
    }

    private void getBgPeriodInfo(Context ctx) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] _periodInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("SELECT FNumber, FPeriodType FROM T_BG_BgPeriod ORDER BY FNumber ASC");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _periodInfo = new Object[]{rst.getString(1), new Integer(rst.getInt(2))};
                this.getPerdictPeriodList().add(_periodInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private List getPerdictPeriodList() {
        return this.perdictPeriodList;
    }

    public String toString() {
        StringBuffer key = new StringBuffer();
        key.append(this.orgUnitNumber).append("!").append(this.bgSchemeNumber).append("!").append(this.bgItemNumber).append("!").append(this.bgElementNumber).append("!").append(this.beginPeriodNumber).append("!").append(this.endPeriodNumber).append("!").append(this.currencyNumber);
        return key.toString();
    }

    public Parameter getParam() {
        return this.param;
    }

    public String getOrgUnitNumber() {
        return this.orgUnitNumber;
    }

    public String getBgSchemeNumber() {
        return this.bgSchemeNumber;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public String getOrgUnitId() {
        if (this.orgUnitId == null) {
            this.orgUnitId = "#";
        }
        return this.orgUnitId;
    }

    public void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    public String getBgSchemeId() {
        if (this.bgSchemeId == null) {
            this.bgSchemeId = "#";
        }
        return this.bgSchemeId;
    }

    public String getOrgAndBgSchemeIdKey() {
        return new StringBuffer(this.getOrgUnitId()).append("!").append(this.getBgSchemeId()).toString();
    }

    public String getOrgAndBgSchemeNumberKey() {
        return new StringBuffer(this.orgUnitNumber).append("!").append(this.bgSchemeNumber).toString();
    }

    public String[] getFormulas() {
        return this.formulas;
    }

    public String getActualSource() {
        if (this.actualSource == null || this.actualSource.equals("")) {
            this.actualSource = "all";
        }
        return this.actualSource;
    }

    public void setActualSource(String actualSource) {
        this.actualSource = actualSource;
    }

    public String getBgItemGroupNumber() {
        return this.bgItemGroupNumber;
    }

    public void setBgItemGroupNumber(String bgItemGroupNumber) {
        this.bgItemGroupNumber = bgItemGroupNumber;
    }

    public String getBgItemNumber() {
        return this.bgItemNumber;
    }
}

