/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.nbudget.app.formula.BgGetOrgAttrInfo;
import com.kingdee.eas.ma.nbudget.app.formula.IBgCalculator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgGetOrgAttrCalculator
implements IBgCalculator {
    private static final Logger logger = Logger.getLogger(BgGetOrgAttrCalculator.class);
    private ICalculateContextProvider provider;
    private Context ctx = null;
    private List formulaList = new ArrayList();
    private Set orgUnitNumer = new HashSet();
    private Map orgUnitMap = new HashMap();
    private List companyList = new ArrayList();
    private List saleList = new ArrayList();
    private List purchaseList = new ArrayList();
    private List storageList = new ArrayList();
    private List costCenterList = new ArrayList();
    private List profitCenterList = new ArrayList();
    private List hrList = new ArrayList();
    private List transportList = new ArrayList();
    private List qualityList = new ArrayList();

    public BgGetOrgAttrCalculator() {
    }

    public BgGetOrgAttrCalculator(ICalculateContextProvider provider, Context ctx) {
        this.setProvider(provider);
        this.setCtx(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate BgGetOrgAttrCalculator start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parseParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate BgGetOrgAttrCalculator finished!");
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    public ICalculateContextProvider getProvider() {
        return this.provider;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Set getOrgUnitNumer() {
        return this.orgUnitNumer;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public List getCompanyList() {
        return this.companyList;
    }

    public List getSaleList() {
        return this.saleList;
    }

    public List getPurchaseList() {
        return this.purchaseList;
    }

    public List getStorageList() {
        return this.storageList;
    }

    public List getCostCenterList() {
        return this.costCenterList;
    }

    public List getProfitCenterList() {
        return this.profitCenterList;
    }

    public List getHrList() {
        return this.hrList;
    }

    public List getTransportList() {
        return this.transportList;
    }

    public List getQualityList() {
        return this.qualityList;
    }

    protected void parseParams(SortedParameterArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter _parameter = null;
        Object[] _objs = null;
        IReportPropertyAdapter adapter = null;
        String _orgUnitNumber = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        adapter = this.getProvider().getReportAdapter();
        String _currOrgUnitNumber = (String)adapter.getReportProperty("Company.Number");
        int count = params.size();
        for (int index = 0; index < count; ++index) {
            _parameter = params.getParameter(index);
            _objs = _parameter.getArgs();
            _orgUnitNumber = (String)((Variant)_objs[0]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _objs[0] = new Variant((Object)_currOrgUnitNumber);
            }
            if (this.parseOrgUnitNumber((Variant)_objs[0]) && this.parseOrgUnitType((Variant)_objs[1]) && this.parseOrgUnitVirtual((Variant)_objs[2])) continue;
            _parameter.setValue((Object)exception);
        }
    }

    protected boolean parseOrgUnitNumber(Variant orgUnitNumber) {
        if (orgUnitNumber == null || orgUnitNumber.getValue() == null) {
            return false;
        }
        String _orgUnitNumber = (String)orgUnitNumber.getValue();
        return !StringUtils.isEmpty((String)_orgUnitNumber);
    }

    protected boolean parseOrgUnitType(Variant orgUnitType) {
        if (orgUnitType == null || orgUnitType.getValue() == null) {
            return false;
        }
        String _orgUnitType = (String)orgUnitType.getValue();
        return !StringUtils.isEmpty((String)_orgUnitType);
    }

    protected boolean parseOrgUnitVirtual(Variant virtual) {
        return virtual != null && virtual.getValue() != null;
    }

    protected void initParams(SortedParameterArray params) {
        Parameter _parameter = null;
        BgGetOrgAttrInfo orgAttrInfo = null;
        int count = params.size();
        for (int index = 0; index < count; ++index) {
            _parameter = params.getParameter(index);
            if (_parameter.getValue() != null && _parameter.getValue() instanceof SyntaxErrorException) continue;
            orgAttrInfo = new BgGetOrgAttrInfo(this, _parameter);
            this.getFormulaList().add(orgAttrInfo);
            this.getOrgUnitNumer().add(orgAttrInfo.getOrgUnitNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() {
        int i;
        int in;
        if (this.getOrgUnitNumer().isEmpty()) {
            return;
        }
        BgGetOrgAttrInfo orgAttrInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitCollection orgUnitColl = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getOrgUnitNumer(), CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            orgUnitColl = this.getOrgUnitInterface().getFullOrgUnitCollection(view);
            if (orgUnitColl != null) {
                in = orgUnitColl.size();
                for (i = 0; i < in; ++i) {
                    orgUnitInfo = orgUnitColl.get(i);
                    this.getOrgUnitMap().put(orgUnitInfo.getNumber(), orgUnitInfo);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        in = this.getFormulaList().size();
        for (i = 0; i < in; ++i) {
            orgAttrInfo = (BgGetOrgAttrInfo)this.getFormulaList().get(i);
            orgAttrInfo.calculator();
        }
        this.calculator(1);
        this.calculator(2);
        this.calculator(3);
        this.calculator(4);
        this.calculator(5);
        this.calculator(6);
        this.calculator(16);
        this.calculator(24);
        this.calculator(32);
    }

    protected void fillValue() {
        BgGetOrgAttrInfo orgAttrInfo = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            orgAttrInfo = (BgGetOrgAttrInfo)this.getFormulaList().get(i);
            if (!orgAttrInfo.isHasError()) {
                orgAttrInfo.getParameter().setValue((Object)orgAttrInfo.isValue());
                continue;
            }
            orgAttrInfo.getParameter().setValue((Object)exception);
        }
    }

    protected void clear() {
        this.getFormulaList().clear();
        this.getOrgUnitNumer().clear();
        this.getOrgUnitMap().clear();
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("isBizUnit");
        return sic;
    }

    protected IFullOrgUnit getOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected ICompanyOrgUnit getCompanyInterface() throws Exception {
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected ISaleOrgUnit getSaleInterface() throws Exception {
        return SaleOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected IPurchaseOrgUnit getPurchaseInterface() throws Exception {
        return PurchaseOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected IStorageOrgUnit getStorageInterface() throws Exception {
        return StorageOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected ICostCenterOrgUnit getCostCenterInterface() throws Exception {
        return CostCenterOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected IProfitCenterOrgUnit getProfitCenterInterface() throws Exception {
        return ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected ICtrlUnit getCtrlUnitInterface() throws Exception {
        return CtrlUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected IHROrgUnit getHRInterface() throws Exception {
        return HROrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected ITransportOrgUnit getTransportInterface() throws Exception {
        return TransportOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    protected IQualityOrgUnit getQualityInterface() throws Exception {
        return QualityOrgUnitFactory.getLocalInstance((Context)this.getCtx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculator(int orgTypeEnum) {
        List tmpList = this.getQueryOrgUnitList(orgTypeEnum);
        if (tmpList != null && !tmpList.isEmpty()) {
            String _tmpStr = null;
            BgGetOrgAttrInfo orgAttrInfo = null;
            ICoreBase _interface = null;
            IObjectValue model = null;
            CoreBaseCollection collection = null;
            HashSet<String> orgUnitIdSet = new HashSet<String>();
            HashMap<String, IObjectValue> orgUnitIdMap = new HashMap<String, IObjectValue>();
            int in = tmpList.size();
            for (int i = 0; i < in; ++i) {
                orgAttrInfo = (BgGetOrgAttrInfo)tmpList.get(i);
                orgUnitIdSet.add(orgAttrInfo.getOrgUnitInfo().getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orgUnitIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(this.getSelectors());
            try {
                _interface = this.getInterface(orgTypeEnum);
                collection = _interface.getCollection(view);
                if (collection != null) {
                    int in2 = collection.size();
                    for (int i = 0; i < in2; ++i) {
                        model = collection.getObject(i);
                        orgUnitIdMap.put(model.getString("id"), model);
                    }
                    int jn = tmpList.size();
                    for (int j = 0; j < jn; ++j) {
                        orgAttrInfo = (BgGetOrgAttrInfo)tmpList.get(j);
                        _tmpStr = orgAttrInfo.getOrgUnitInfo().getId().toString();
                        if (!orgUnitIdMap.containsKey(_tmpStr)) continue;
                        model = (IObjectValue)orgUnitIdMap.get(_tmpStr);
                        orgAttrInfo.setVirtual(model.getBoolean("isBizUnit"));
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                if (collection != null) {
                    collection.clear();
                }
            }
        }
    }

    protected List getQueryOrgUnitList(int orgTypeEnum) {
        List tmpList = null;
        switch (orgTypeEnum) {
            case 1: {
                tmpList = this.getCompanyList();
                break;
            }
            case 2: {
                tmpList = this.getSaleList();
                break;
            }
            case 3: {
                tmpList = this.getPurchaseList();
                break;
            }
            case 4: {
                tmpList = this.getStorageList();
                break;
            }
            case 5: {
                tmpList = this.getCostCenterList();
                break;
            }
            case 6: {
                tmpList = this.getProfitCenterList();
                break;
            }
            case 16: {
                tmpList = this.getHrList();
                break;
            }
            case 24: {
                tmpList = this.getTransportList();
                break;
            }
            case 32: {
                tmpList = this.getQualityList();
            }
        }
        return tmpList;
    }

    protected ICoreBase getInterface(int orgTypeEnum) throws Exception {
        ICompanyOrgUnit _interface = null;
        switch (orgTypeEnum) {
            case 1: {
                _interface = this.getCompanyInterface();
                break;
            }
            case 2: {
                _interface = this.getSaleInterface();
                break;
            }
            case 3: {
                _interface = this.getPurchaseInterface();
                break;
            }
            case 4: {
                _interface = this.getStorageInterface();
                break;
            }
            case 5: {
                _interface = this.getCostCenterInterface();
                break;
            }
            case 6: {
                _interface = this.getProfitCenterInterface();
                break;
            }
            case 16: {
                _interface = this.getHRInterface();
                break;
            }
            case 24: {
                _interface = this.getTransportInterface();
                break;
            }
            case 32: {
                _interface = this.getQualityInterface();
            }
        }
        return _interface;
    }
}

