/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgNAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgNAvlCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgNAvlFormulaInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BgNAvlCurrYearCalculator
extends BgNAvlCalculator {
    private static Logger logger = Logger.getLogger(BgNAvlCurrYearCalculator.class);
    private Map budgetValueMap = new HashMap();
    private Map actualValueMap = new HashMap();

    public BgNAvlCurrYearCalculator(BgNAvlBalCalculator calculator) {
        super(calculator);
    }

    @Override
    public Map getBudgetValueMap() {
        return this.budgetValueMap;
    }

    public Map getActualValueMap() {
        return this.actualValueMap;
    }

    @Override
    public void calculator() throws Exception {
        this.calculatorByBudgetValue();
        this.calculatorByActualValue();
        this.calculatorBalanceValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getBudgetValueMap().clear();
        this.getActualValueMap().clear();
    }

    protected void calculatorByBudgetValue() throws Exception {
        this.getBudgetValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        String _yearPeriodTypeKey = null;
        Map periodMap = null;
        int _bgPeriodType = 0;
        int _year = 0;
        String _bgItemNumber = null;
        String _bgElementNumber = null;
        String _currencyNumber = null;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(d.FBgValue), i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("and p.FID in (select FID from T_BG_BgPeriod where (FYear >= ? and FYear <= ?)) ").append("group by i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getCalculator().getBgSchemeMap().get(this.getBgSchemeId());
        Date _beginDate = bgSchemeInfo.getDateFrom();
        Date _endDate = bgSchemeInfo.getDateTo();
        int beginYear = this.getCalendar().getCurrentlyYear(_beginDate);
        int endYear = this.getCalendar().getCurrentlyYear(_endDate);
        periodMap = this.getPeriodMap(beginYear, endYear);
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            pstmt.setInt(3, beginYear);
            pstmt.setInt(4, endYear);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _bgItemNumber = rst.getString(2);
                _bgPeriodType = rst.getInt(3);
                _year = rst.getInt(4);
                _bgElementNumber = rst.getString(5);
                _currencyNumber = rst.getString(6);
                _yearPeriodTypeKey = new StringBuffer("" + _year).append("!").append("" + _bgPeriodType).toString();
                _value = this.getNewValue(_value, periodMap, _yearPeriodTypeKey, this.getOrgUnitId(), this.getBgSchemeId(), _bgItemNumber, _bgElementNumber, _currencyNumber);
                _key = new StringBuffer(_bgItemNumber).append("!").append(_bgPeriodType).append("!").append(_year).append("!").append(_bgElementNumber).append("!").append(_currencyNumber).toString();
                this.getBudgetValueMap().put(_key, _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private Map getPeriodMap(int beginYear, int endYear) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        List<String> periodNumberList = null;
        String _key = null;
        int _year = 0;
        int _periodType = 0;
        String _periodNumber = null;
        HashMap<String, List<String>> periodMap = new HashMap<String, List<String>>();
        String sql = "select FYear,FPeriodType,FNumber from T_BG_BgPeriod where (FYear >= ? and FYear <= ?)";
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, beginYear);
            pstmt.setInt(2, endYear);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _year = rst.getInt(1);
                _periodType = rst.getInt(2);
                _periodNumber = rst.getString(3);
                _key = new StringBuffer("" + _year).append("!").append("" + _periodType).toString();
                if (periodMap.containsKey(_key)) {
                    periodNumberList = (List)periodMap.get(_key);
                    if (periodNumberList == null) {
                        periodNumberList = new ArrayList();
                    }
                    periodNumberList.add(_periodNumber);
                    continue;
                }
                periodNumberList = new ArrayList();
                periodNumberList.add(_periodNumber);
                periodMap.put(_key, periodNumberList);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return periodMap;
    }

    protected void calculatorByActualValue() throws Exception {
        this.getActualValueMap().clear();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal _value = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer _keyStr = null;
        sql.append("select sum(d.FBizActual), i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ").append("from T_BG_BgData d ").append("left join T_BG_BgItemcombination i on d.FBgItemcombinId = i.FID ").append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ").append("left join T_BG_BgElement e on d.FBgElementId = e.FID ").append("left join T_BD_Currency c on d.FCurrencyId = c.FID ").append("left join T_BG_BgForm f on d.FBgFormId = f.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("group by i.FKey, p.FPeriodType, p.FYear, e.FNumber, c.FNumber ");
        try {
            conn = EJBFactory.getConnection((Context)this.getCalculator().getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, this.getOrgUnitId());
            pstmt.setString(2, this.getBgSchemeId());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _value = rst.getBigDecimal(1);
                _keyStr = new StringBuffer();
                _keyStr.append(rst.getString(2)).append("!").append(rst.getInt(3)).append("!").append(rst.getInt(4)).append("!").append(rst.getString(5)).append("!").append(rst.getString(6));
                this.getActualValueMap().put(_keyStr.toString(), _value);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void calculatorBalanceValue() throws Exception {
        Map.Entry _entry2 = null;
        BgNAvlFormulaInfo formula = null;
        HashMap formulaMap = new HashMap();
        int bgPeriodType = 0;
        int year = 0;
        String formulaStr = null;
        String _key = null;
        String[] parameter = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        for (Map.Entry _entry2 : this.getFormulaMap().entrySet()) {
            _bValue = BgNConstants.ZERO;
            formulaStr = (String)_entry2.getKey();
            formula = (BgNAvlFormulaInfo)_entry2.getValue();
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
            if (parameter == null) continue;
            bgPeriodType = BgNPeriodHelper.parserBgPeriodType(parameter[1]);
            year = BgNPeriodHelper.parserBgPeriodYear(parameter[1]);
            _key = new StringBuffer().append(parameter[0].replaceAll(",", "_")).append("!").append(bgPeriodType).append("!").append(year).append("!").append(parameter[2]).append("!").append(parameter[5]).toString();
            _bValue = this.getBudgetValueMap().containsKey(_key) ? (BigDecimal)this.getBudgetValueMap().get(_key) : BgNConstants.ZERO;
            formula.setBudgetValue(_bValue);
            _aValue = this.getActualValueMap().containsKey(_key) ? (BigDecimal)this.getActualValueMap().get(_key) : BgNConstants.ZERO;
            formula.setActualValue(_aValue);
            formula.calculator();
        }
    }
}

