/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefFormulaInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgRefFormCalculator
extends BgRefCalculator {
    private static final Logger logger = Logger.getLogger(BgRefFormCalculator.class);
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgRefFormCalculator() {
    }

    public BgRefFormCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgRefForm start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgRefForm finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _bgFormId = null;
        String _orgUnitNumber = null;
        String _bgFormNumber = null;
        String _sheetName = null;
        String _cellName = null;
        HashSet<String> numberKeySet = new HashSet<String>();
        Map<String, Set<String>> _sheetNameMap = null;
        Set<String> _cellPosSet = null;
        BgRefFormulaInfo _formula = null;
        Parameter _parmeter = null;
        IReportPropertyAdapter adapter = null;
        adapter = this.getProvider().getReportAdapter();
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        String _bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgFormNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _sheetName = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _cellName = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _parmeter.getArgs()[0] = new Variant((Object)_bgOrgNumber);
            }
            if (StringUtils.isEmpty((String)(_orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue())) || StringUtils.isEmpty((String)_bgFormNumber) || StringUtils.isEmpty((String)_sheetName) || StringUtils.isEmpty((String)_cellName)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _formula = new BgRefFormulaInfo(_parmeter, true);
            _key = _formula.getBgFormOfFormulaKey();
            if (!numberKeySet.contains(_key)) {
                numberKeySet.add(_key);
            }
            this.getFormulaList().add(_formula);
        }
        try {
            this.getBgFormInfo(numberKeySet);
        }
        finally {
            numberKeySet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _formula = (BgRefFormulaInfo)this.getFormulaList().get(j);
            _bgFormId = (String)this.getBgFormMap().get(_formula.getBgFormOfFormulaKey());
            _formula.setBgFormId(_bgFormId);
            if (StringUtils.isEmpty((String)_formula.getBgFormId())) continue;
            if (this.getExpressMap().containsKey(_formula.getBgFormId())) {
                _sheetNameMap = (Map)this.getExpressMap().get(_formula.getBgFormId());
            } else {
                _sheetNameMap = new HashMap();
                this.getExpressMap().put(_formula.getBgFormId(), _sheetNameMap);
            }
            _sheetName = _formula.getSheetName();
            if (_sheetNameMap.containsKey(_sheetName)) {
                _cellPosSet = (Set)_sheetNameMap.get(_sheetName);
            } else {
                _cellPosSet = new HashSet();
                _sheetNameMap.put(_sheetName, _cellPosSet);
            }
            if (_cellPosSet.contains(_formula.getCellPos())) continue;
            _cellPosSet.add(_formula.getCellPos());
        }
    }

    protected void getBgFormInfo(Set numberKeySet) throws Exception {
        int i;
        if (numberKeySet == null || numberKeySet.isEmpty()) {
            return;
        }
        ArrayList _numberKeyList = new ArrayList();
        _numberKeyList.addAll(numberKeySet);
        int batchSize = 10;
        int size = _numberKeyList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _fNumber = null;
        String _oNumber = null;
        String _key = null;
        BigDecimal _FVersionNO = null;
        String[] _parameter = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer paraStr = new StringBuffer();
        for (i = 1; i < batchSize; ++i) {
            paraStr.append("?,");
        }
        paraStr.append("?");
        sql.append("SELECT f.FID, u.FNumber, f.FNumber,FVersionNO FROM T_BG_BgForm f ").append("LEFT JOIN T_ORG_CostCenter u on f.FOrgUnitId = u.FID ").append("WHERE (u.FNumber IN (").append(paraStr).append(") ").append("AND f.FNumber IN (").append(paraStr).append(")) ").append("AND (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("(u.FNumber = ? AND f.FNumber = ?) OR ");
        }
        sql.append("(u.FNumber = ? AND f.FNumber = ?))");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        _key = (String)_numberKeyList.get(pos);
                        _parameter = _key.split("!");
                        pstmt.setString(x, _parameter[0]);
                        pstmt.setString(batchSize + x, _parameter[1]);
                        pstmt.setString(batchSize * 2 + (x - 1) * 2 + 1, _parameter[0]);
                        pstmt.setString(batchSize * 2 + (x - 1) * 2 + 2, _parameter[1]);
                    } else {
                        pstmt.setString(x, "#");
                        pstmt.setString(batchSize + x, "#");
                        pstmt.setString(batchSize * 2 + (x - 1) * 2 + 1, "#");
                        pstmt.setString(batchSize * 2 + (x - 1) * 2 + 2, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _oNumber = rst.getString(2);
                    _fNumber = rst.getString(3);
                    _FVersionNO = rst.getBigDecimal("FVersionNO");
                    tempMap.put(_fid, _FVersionNO);
                    _key = new StringBuffer(_oNumber).append("!").append(_fNumber).toString();
                    if (this.getBgFormMap().get(_key) != null) {
                        String tempFId = (String)this.getBgFormMap().get(_key);
                        BigDecimal tmpVNO = (BigDecimal)tempMap.get(tempFId);
                        if (tmpVNO == null || _FVersionNO == null || !(_FVersionNO.doubleValue() > tmpVNO.doubleValue())) continue;
                        this.getBgFormMap().put(_key, _fid);
                        continue;
                    }
                    this.getBgFormMap().put(_key, _fid);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _numberKeyList.clear();
                tempMap.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _numberKeyList.clear();
        tempMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() throws Exception {
        if (this.getExpressMap().isEmpty()) {
            return;
        }
        byte[] _data = null;
        int _sheetIndex = 0;
        int _sheetSize = 0;
        String _bgFormId = null;
        String _sheetName = null;
        String _posStr2 = null;
        Map _sheetNameMap = null;
        Map _bgSheetNameMap = null;
        Map<String, Object> _bgCellPosMap = null;
        Set _cellPosSet = null;
        Map.Entry _entry2 = null;
        Rect _rect = null;
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _bgFormId = (String)_entry2.getKey();
                _sheetNameMap = (Map)_entry2.getValue();
                _bgFormInfo = BgInfoHelper.getBgFormInfo(conn, _bgFormId, true);
                if (_bgFormInfo == null || (_data = _bgFormInfo.getZipData()) == null || _data.length <= 0) continue;
                try {
                    _book = _bgFormInfo.getBook();
                    if (_book == null) continue;
                    BgNFSHelper.disableCal(_book);
                    BgNFSHelper.disableUndo(_book);
                    _sheetSize = _book.getSheetCount();
                    for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                        _sheet = _book.getSheet(_sheetIndex);
                        _sheetName = _sheet.getSheetName().toLowerCase();
                        if (!_sheetNameMap.containsKey(_sheetName)) continue;
                        _cellPosSet = (Set)_sheetNameMap.get(_sheetName);
                        for (String _posStr2 : _cellPosSet) {
                            if (StringUtils.isEmpty((String)_posStr2) || (_rect = TableToolkit.range2xy((String)_posStr2)) == null || (_cell = _sheet.getCell(_rect.getYBase(), _rect.getXBase(), false)) == null) continue;
                            if (this.getBgCellDataMap().containsKey(_bgFormId)) {
                                _bgSheetNameMap = (Map)this.getBgCellDataMap().get(_bgFormId);
                            } else {
                                _bgSheetNameMap = new HashMap();
                                this.getBgCellDataMap().put(_bgFormId, _bgSheetNameMap);
                            }
                            if (_bgSheetNameMap.containsKey(_sheetName)) {
                                _bgCellPosMap = (Map)_bgSheetNameMap.get(_sheetName);
                            } else {
                                _bgCellPosMap = new HashMap();
                                _bgSheetNameMap.put(_sheetName, _bgCellPosMap);
                            }
                            _bgCellPosMap.put(_posStr2, _cell.getValue() != Variant.nullVariant ? _cell.getValue().getValue() : null);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"error:", (Throwable)ex);
                }
                finally {
                    _book = null;
                    _data = null;
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void fillValue() {
        BgRefFormulaInfo _formula = null;
        Object _obj = null;
        Object _value = null;
        Map _bgSheetNameMap = null;
        Map _bgCellPosMap = null;
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _formula = (BgRefFormulaInfo)this.getFormulaList().get(i);
            _value = this.getBgCellDataMap().containsKey(_formula.getBgFormId()) ? ((_bgSheetNameMap = (Map)this.getBgCellDataMap().get(_formula.getBgFormId())).containsKey(_formula.getSheetName()) ? ((_bgCellPosMap = (Map)_bgSheetNameMap.get(_formula.getSheetName())).containsKey(_formula.getCellPos()) ? ((_obj = _bgCellPosMap.get(_formula.getCellPos())) != null ? _obj : "") : "") : "") : "";
            if (_formula.getParam().getValue() != null && _formula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _formula.getParam().setValue(_value);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }
}

