/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgFormulaException;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgRefFormulaInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgRefTemplateCalculator
extends BgRefCalculator {
    private static final Logger logger = Logger.getLogger(BgRefTemplateCalculator.class);
    private List formulaList = new ArrayList();
    private Map expressMap = new HashMap();

    public BgRefTemplateCalculator() {
    }

    public BgRefTemplateCalculator(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public Map getExpressMap() {
        return this.expressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        logger.info((Object)"invoke batch calculate bgRefTemplate start!");
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            this.parserBgPeriodWithCaculater(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke parser parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.initParams(params);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke initialize parameter succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.calculate();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke calculate succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
            _beginTime = _endTime;
            this.fillValue();
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke fill resultset succeed!");
            logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
        logger.info((Object)"invoke batch calculate bgRefTemplate finished!");
    }

    protected void parserBgPeriodWithCaculater(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportVariables rv = this.getProvider().getReportVariables();
        Variant variant = null;
        IReportPropertyAdapter adapter = null;
        Parameter _parameter = null;
        Object[] _objs = null;
        Object _obj = null;
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        adapter = this.getProvider().getReportAdapter();
        _obj = adapter.getReportProperty("BG_PERIOD_TYPE");
        String _currCurrencyNumber = (String)adapter.getReportProperty("Currency.Number");
        String _currPeriodNumber = (String)adapter.getReportProperty("BG_PERIOD_NUMBER");
        String _bgSchemeNumber = (String)adapter.getReportProperty("BG_SCHEME_NUMBER");
        String _bgOrgNumber = (String)adapter.getReportProperty("BG_ORG_NUMBER");
        String _orgUnitNumber = null;
        String _schemeNumber = null;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            _objs = _parameter.getArgs();
            _orgUnitNumber = (String)((Variant)_objs[0]).getValue();
            _schemeNumber = (String)((Variant)_objs[1]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber)) {
                _objs[0] = new Variant((Object)_bgOrgNumber);
            }
            if (StringUtils.isEmpty((String)_schemeNumber)) {
                _objs[1] = new Variant((Object)_bgSchemeNumber);
            }
            if (_obj != null && _obj instanceof Integer && (Integer)_obj != 8 && _objs[3] != null && BgPeriodNVariableHelper.checkCanConvert((String)_objs[3].toString())) {
                _parameter.setValue((Object)exception);
                continue;
            }
            if (_objs[3] instanceof Variant && ((variant = (Variant)_objs[3]).getValue() == null || StringUtils.isEmpty((String)variant.getValue().toString())) && rv != null && rv.contains("StartBgPeriod", _parameter.getSheetName()) && !StringUtils.isEmpty((String)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()))) {
                _objs[3] = new Variant((Object)rv.getStringValue("StartBgPeriod", _parameter.getSheetName()));
            }
            _objs[3] = this.parserBgPeriodParameter((Variant)_objs[3], _currPeriodNumber);
            _objs[4] = this.parserCurrencyParameter((Variant)_objs[4], _currCurrencyNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        String _key = null;
        String _bgFormId = null;
        String _orgUnitNumber = null;
        String _bgSchemeNumber = null;
        String _bgTemplateNumber = null;
        String _bgPeriodNumber = null;
        String _currencyNumber = null;
        String _sheetName = null;
        String _cellName = null;
        HashSet<String> numberKeySet = new HashSet<String>();
        Map<String, Set<String>> _sheetNameMap = null;
        Set<String> _cellPosSet = null;
        BgRefFormulaInfo _formula = null;
        Parameter _parmeter = null;
        BgFormulaException _exception = new BgFormulaException(BgFormulaException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parmeter = params.getParameter(i);
            if (_parmeter.getValue() != null && _parmeter.getValue() instanceof SyntaxErrorException) continue;
            _orgUnitNumber = (String)((Variant)_parmeter.getArgs()[0]).getValue();
            _bgSchemeNumber = (String)((Variant)_parmeter.getArgs()[1]).getValue();
            _bgTemplateNumber = (String)((Variant)_parmeter.getArgs()[2]).getValue();
            _bgPeriodNumber = (String)((Variant)_parmeter.getArgs()[3]).getValue();
            _currencyNumber = (String)((Variant)_parmeter.getArgs()[4]).getValue();
            _sheetName = (String)((Variant)_parmeter.getArgs()[5]).getValue();
            _cellName = (String)((Variant)_parmeter.getArgs()[6]).getValue();
            if (StringUtils.isEmpty((String)_orgUnitNumber) || StringUtils.isEmpty((String)_bgSchemeNumber) || StringUtils.isEmpty((String)_bgTemplateNumber) || StringUtils.isEmpty((String)_bgPeriodNumber) || StringUtils.isEmpty((String)_currencyNumber) || StringUtils.isEmpty((String)_sheetName) || StringUtils.isEmpty((String)_cellName)) {
                _parmeter.setValue((Object)exception);
                continue;
            }
            if (_orgUnitNumber.indexOf(";") >= 0) {
                _parmeter.setValue((Object)orgException);
                continue;
            }
            _formula = new BgRefFormulaInfo(_parmeter, false);
            _key = _formula.getBgTemplateOfFormulaKey();
            if (!numberKeySet.contains(_key)) {
                numberKeySet.add(_key);
            }
            this.getFormulaList().add(_formula);
        }
        try {
            this.getBgFormInfo(numberKeySet);
        }
        finally {
            numberKeySet.clear();
        }
        int jn = this.getFormulaList().size();
        for (int j = 0; j < jn; ++j) {
            _formula = (BgRefFormulaInfo)this.getFormulaList().get(j);
            _bgFormId = (String)this.getBgFormMap().get(_formula.getBgTemplateOfFormulaKey());
            _formula.setBgFormId(_bgFormId);
            if (StringUtils.isEmpty((String)_formula.getBgFormId())) continue;
            if (this.getExpressMap().containsKey(_formula.getBgFormId())) {
                _sheetNameMap = (Map)this.getExpressMap().get(_formula.getBgFormId());
            } else {
                _sheetNameMap = new HashMap();
                this.getExpressMap().put(_formula.getBgFormId(), _sheetNameMap);
            }
            _sheetName = _formula.getSheetName();
            if (_sheetNameMap.containsKey(_sheetName)) {
                _cellPosSet = (Set)_sheetNameMap.get(_sheetName);
            } else {
                _cellPosSet = new HashSet();
                _sheetNameMap.put(_sheetName, _cellPosSet);
            }
            if (_cellPosSet.contains(_formula.getCellPos())) continue;
            _cellPosSet.add(_formula.getCellPos());
        }
    }

    protected void getBgFormInfo(Set numberKeySet) throws Exception {
        int i;
        if (numberKeySet == null || numberKeySet.isEmpty()) {
            return;
        }
        ArrayList _numberKeyList = new ArrayList();
        _numberKeyList.addAll(numberKeySet);
        int batchSize = 10;
        int size = _numberKeyList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>();
        BigDecimal _versionNO = null;
        BigDecimal _oldVersion = null;
        String _fid = null;
        String _uNumber = null;
        String _sNumber = null;
        String _tNumber = null;
        String _pNumber = null;
        String _cNumber = null;
        String _key = null;
        String _tmpId = null;
        String[] _parameter = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer paraStr = new StringBuffer();
        for (i = 1; i < batchSize; ++i) {
            paraStr.append("?,");
        }
        paraStr.append("?");
        sql.append("SELECT f.FID, u.FNumber, s.FNumber, t.FNumber, p.FNumber, c.FNumber,f.FVersionNO ").append("FROM T_BG_BgForm f ").append("LEFT JOIN T_ORG_CostCenter u on f.FOrgUnitId = u.FID ").append("LEFT JOIN T_BG_BgScheme s on f.fbgschemeId = s.FID ").append("LEFT JOIN T_BG_BgTemplate t on f.FBgtemplateId = t.FID ").append("LEFT JOIN T_BG_BgPeriod p on f.FBgPeriodId = p.FID ").append("LEFT JOIN T_BD_Currency c on f.FCurrencyId = c.FID ").append("WHERE (u.FNumber IN (").append(paraStr).append(") ").append("AND s.FNumber IN (").append(paraStr).append(") ").append("AND t.FNumber IN (").append(paraStr).append(") ").append("AND p.FNumber IN (").append(paraStr).append(") ").append("AND c.FNumber IN (").append(paraStr).append(") AND t.FFormType != 3 ) ").append("AND (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("(u.FNumber=? AND s.FNumber=? AND t.FNumber=? AND p.FNumber=? AND c.FNumber=?) OR ");
        }
        sql.append("(u.FNumber=? AND s.FNumber=? AND t.FNumber=? AND p.FNumber=? AND c.FNumber=?))");
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        _key = (String)_numberKeyList.get(pos);
                        _parameter = _key.split("!");
                        pstmt.setString(x, _parameter[0]);
                        pstmt.setString(batchSize + x, _parameter[1]);
                        pstmt.setString(batchSize * 2 + x, _parameter[2]);
                        pstmt.setString(batchSize * 3 + x, _parameter[3]);
                        pstmt.setString(batchSize * 4 + x, _parameter[4]);
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 1, _parameter[0]);
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 2, _parameter[1]);
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 3, _parameter[2]);
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 4, _parameter[3]);
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 5, _parameter[4]);
                    } else {
                        pstmt.setString(x, "#");
                        pstmt.setString(batchSize + x, "#");
                        pstmt.setString(batchSize * 2 + x, "#");
                        pstmt.setString(batchSize * 3 + x, "#");
                        pstmt.setString(batchSize * 4 + x, "#");
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 1, "#");
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 2, "#");
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 3, "#");
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 4, "#");
                        pstmt.setString(batchSize * 5 + (x - 1) * 5 + 5, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _uNumber = rst.getString(2);
                    _sNumber = rst.getString(3);
                    _tNumber = rst.getString(4);
                    _pNumber = rst.getString(5);
                    _cNumber = rst.getString(6);
                    _versionNO = rst.getBigDecimal("FVersionNO");
                    tempMap.put(_fid, _versionNO);
                    _key = new StringBuffer(_uNumber).append("!").append(_sNumber).append("!").append(_tNumber).append("!").append(_pNumber).append("!").append(_cNumber).toString();
                    if (this.getBgFormMap().get(_key) != null) {
                        _tmpId = (String)this.getBgFormMap().get(_key);
                        _oldVersion = (BigDecimal)tempMap.get(_tmpId);
                        if (_versionNO == null || _oldVersion == null || !(_versionNO.doubleValue() > _oldVersion.doubleValue())) continue;
                        this.getBgFormMap().put(_key, _fid);
                        continue;
                    }
                    this.getBgFormMap().put(_key, _fid);
                }
                if (this.getBgFormMap().isEmpty()) {
                    logger.info((Object)"no find form object!");
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _numberKeyList.clear();
                tempMap.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _numberKeyList.clear();
        tempMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() throws Exception {
        if (this.getExpressMap().isEmpty()) {
            logger.info((Object)"calculate expression is null!");
            return;
        }
        byte[] _data = null;
        int _sheetIndex = 0;
        int _sheetSize = 0;
        String _bgFormId = null;
        String _sheetName = null;
        String _posStr2 = null;
        Map _sheetNameMap = null;
        Map _bgSheetNameMap = null;
        Map<String, Object> _bgCellPosMap = null;
        Set _cellPosSet = null;
        Map.Entry _entry2 = null;
        Rect _rect = null;
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            for (Map.Entry _entry2 : this.getExpressMap().entrySet()) {
                _bgFormId = (String)_entry2.getKey();
                _sheetNameMap = (Map)_entry2.getValue();
                _bgFormInfo = BgInfoHelper.getBgFormInfo(conn, _bgFormId, true);
                if (_bgFormInfo == null) {
                    return;
                }
                _data = _bgFormInfo.getZipData();
                if (_data == null || _data.length <= 0) continue;
                try {
                    _book = _bgFormInfo.getBook();
                    BgNFSHelper.disableCal(_book);
                    BgNFSHelper.disableUndo(_book);
                    _sheetSize = _book.getSheetCount();
                    for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                        _sheet = _book.getSheet(_sheetIndex);
                        _sheetName = _sheet.getSheetName().toLowerCase();
                        if (!_sheetNameMap.containsKey(_sheetName)) continue;
                        _cellPosSet = (Set)_sheetNameMap.get(_sheetName);
                        for (String _posStr2 : _cellPosSet) {
                            if (StringUtils.isEmpty((String)_posStr2) || (_rect = TableToolkit.range2xy((String)_posStr2)) == null || (_cell = _sheet.getCell(_rect.getYBase(), _rect.getXBase(), false)) == null) continue;
                            if (this.getBgCellDataMap().containsKey(_bgFormId)) {
                                _bgSheetNameMap = (Map)this.getBgCellDataMap().get(_bgFormId);
                            } else {
                                _bgSheetNameMap = new HashMap();
                                this.getBgCellDataMap().put(_bgFormId, _bgSheetNameMap);
                            }
                            if (_bgSheetNameMap.containsKey(_sheetName)) {
                                _bgCellPosMap = (Map)_bgSheetNameMap.get(_sheetName);
                            } else {
                                _bgCellPosMap = new HashMap();
                                _bgSheetNameMap.put(_sheetName, _bgCellPosMap);
                            }
                            _bgCellPosMap.put(_posStr2, _cell.getValue() != Variant.nullVariant ? _cell.getValue().getValue() : null);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"error:", (Throwable)ex);
                }
                finally {
                    _book = null;
                    _data = null;
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void fillValue() {
        BgRefFormulaInfo _formula = null;
        Object _obj = null;
        Object _value = null;
        Map _bgSheetNameMap = null;
        Map _bgCellPosMap = null;
        int in = this.getFormulaList().size();
        for (int i = 0; i < in; ++i) {
            _formula = (BgRefFormulaInfo)this.getFormulaList().get(i);
            _value = this.getBgCellDataMap().containsKey(_formula.getBgFormId()) ? ((_bgSheetNameMap = (Map)this.getBgCellDataMap().get(_formula.getBgFormId())).containsKey(_formula.getSheetName()) ? ((_bgCellPosMap = (Map)_bgSheetNameMap.get(_formula.getSheetName())).containsKey(_formula.getCellPos()) ? ((_obj = _bgCellPosMap.get(_formula.getCellPos())) != null ? _obj : "") : "") : "") : "";
            if (_formula.getParam().getValue() != null && _formula.getParam().getValue() instanceof SyntaxErrorException) continue;
            _formula.getParam().setValue(_value);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getFormulaList().clear();
        this.getExpressMap().clear();
    }
}

