/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class BgReportCalculatorProvider
implements INeedSheetInfo,
ICalculator {
    public static final String PERMISSION_ACCOUNTVIEW = "bd_account_accountView_view";
    private Context ServerCtx = null;
    ChecFmlParamPermissionUtil pmc = null;
    Map permissionOrgs = null;
    public static final int DT_CURRENT = 1;
    public static final int DT_START = 2;
    public static final int DT_END = 3;
    private String sheetName;
    private ICalculateContextProvider context;

    public BgReportCalculatorProvider() {
    }

    public BgReportCalculatorProvider(Context ctx) {
        this.ServerCtx = ctx;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.ServerCtx = context.getServerContext();
        this.pmc = ChecFmlParamPermissionUtil.getInstance((ICalculateContextProvider)context);
    }

    public void clearContext() {
        this.context = null;
        this.ServerCtx = null;
    }

    public String keyWord(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.context.getReportVariables() != null) {
            return this.context.getReportVariables().getStringValue(name, this.getCalculateSheetName());
        }
        return null;
    }

    private int getReport_Year() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
    }

    private int getSheet_StartYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_StartPeriod() {
        return this.context.getReportVariables().getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
    }

    private String getCalculateSheetName() {
        return this.getSheetName();
    }

    private String getCorrect_Currency_Number() {
        String currency = this.context.getReportVariables().getStringValue("Currency", this.getCalculateSheetName());
        if (StringUtils.isEmpty((String)currency)) {
            currency = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        }
        return currency;
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    public BigDecimal BgAct(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        String field = "fbgvalue";
        BigDecimal result = this.calculateBg(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field);
        return result;
    }

    private BigDecimal calculateBg(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber, String field) throws BOSException, EASBizException {
        IBgFormulaFacade iBgF = null;
        if (iBgF == null) {
            iBgF = this.ServerCtx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        String[] parameterAfterPreDeal = this.preDealBgParameter(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber);
        orgNumber = parameterAfterPreDeal[0];
        bgSchemeNumber = parameterAfterPreDeal[1];
        bgElementNumber = parameterAfterPreDeal[2];
        strItemCombinNum = parameterAfterPreDeal[3];
        currencyNumber = parameterAfterPreDeal[4];
        beginPeriodNumber = parameterAfterPreDeal[5];
        endPeriodNumber = parameterAfterPreDeal[6];
        BigDecimal result = iBgF.getBgValue(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, field, 4);
        return result;
    }

    private String[] preDealBgParameter(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        IReportPropertyAdapter adapter = this.context.getReportAdapter();
        String[] paratemer = new String[7];
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        boolean isparseBegin = true;
        boolean isparseEnd = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
        }
        catch (NumberFormatException e) {
            isparseBegin = false;
        }
        try {
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isparseEnd = false;
        }
        isPass = isparseBegin || isparseEnd;
        int currentYear = 0;
        int currentPeriod = 0;
        if (adapter.getReportProperty("BG_PERIOD_TYPE") != null && isPass) {
            int bgPeriodType = (Integer)adapter.getReportProperty("BG_PERIOD_TYPE");
            currentYear = (Integer)adapter.getReportProperty("Report.Year");
            if (bgPeriodType == 1) {
                currentPeriod = 0;
                if (isparseBegin) {
                    if (begin > 1900) {
                        beginPeriodNumber = begin + "Y";
                    } else {
                        int beginYear = currentYear + begin;
                        beginPeriodNumber = beginYear + "Y";
                    }
                }
                if (isparseEnd) {
                    if (end > 1900) {
                        endPeriodNumber = end + "Y";
                    } else {
                        int endYear = currentYear + end;
                        endPeriodNumber = endYear + "Y";
                    }
                }
            } else if (bgPeriodType == 4) {
                currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
                int beginYear = currentYear = ((Integer)adapter.getReportProperty("Report.Year")).intValue();
                int beginPeriod = 0;
                if (isparseBegin) {
                    beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 12 ? begin : 12);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 12;
                            int j = beginPeriod % 12;
                            beginYear = beginYear + i - 1;
                            beginPeriod = 12 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                }
                int endYear = currentYear;
                if (isparseEnd) {
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? currentPeriod + end : (end <= 12 ? end : 12);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 12;
                            int j = endPeriod % 12;
                            endYear = endYear + i - 1;
                            endPeriod = 12 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
                }
            } else if (bgPeriodType == 3) {
                currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
                int beginYear = currentYear = ((Integer)adapter.getReportProperty("Report.Year")).intValue();
                int beginPeriod = 0;
                if (isparseBegin) {
                    beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 4 ? begin : 4);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 4;
                            int j = beginPeriod % 4;
                            beginYear = beginYear + i - 1;
                            beginPeriod = 4 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                }
                if (isparseEnd) {
                    int endYear = currentYear;
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? currentPeriod + end : (end <= 4 ? end : 4);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 4;
                            int j = endPeriod % 4;
                            endYear = endYear + i - 1;
                            endPeriod = 4 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
                }
            } else if (bgPeriodType == 2) {
                currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
                int beginYear = currentYear = ((Integer)adapter.getReportProperty("Report.Year")).intValue();
                if (isparseBegin) {
                    int beginPeriod = 0;
                    beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 2 ? begin : 2);
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int i = beginPeriod / 2;
                            int j = beginPeriod % 2;
                            beginYear = beginYear + i - 1;
                            beginPeriod = 2 + j;
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                }
                if (isparseEnd) {
                    int endYear = currentYear;
                    int endPeriod = 0;
                    endPeriod = end <= 0 ? currentPeriod + end : (end <= 2 ? end : 2);
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int i = endPeriod / 2;
                            int j = endPeriod % 2;
                            endYear = endYear + i - 1;
                            endPeriod = 2 + j;
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
                }
            } else if (bgPeriodType == 5) {
                int _maxWeeks;
                currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
                currentYear = (Integer)adapter.getReportProperty("Report.Year");
                CalendarHelper calendar = new CalendarHelper();
                int beginYear = currentYear;
                int endYear = currentYear;
                int maxWeek = calendar.getWeeksOfYear(currentYear, true);
                if (isparseBegin) {
                    int beginPeriod = 0;
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            for (beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= maxWeek ? begin : maxWeek); beginPeriod <= 0; beginPeriod += _maxWeeks) {
                                _maxWeeks = calendar.getWeeksOfYear(--beginYear, true);
                            }
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "W";
                }
                if (isparseEnd) {
                    int endPeriod = 0;
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            for (endPeriod = end <= 0 ? currentPeriod + end : (end <= maxWeek ? end : maxWeek); endPeriod <= 0; endPeriod += _maxWeeks) {
                                _maxWeeks = calendar.getWeeksOfYear(--endYear, true);
                            }
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "W";
                }
            } else if (bgPeriodType == 7) {
                currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
                CalendarHelper calendar = new CalendarHelper();
                currentYear = (Integer)adapter.getReportProperty("Report.Year");
                int maxDays = calendar.isLeapYear(currentYear) ? 366 : 365;
                int beginYear = currentYear;
                int endYear = currentYear;
                int beginPeriod = 0;
                if (isparseBegin) {
                    if (begin <= 0) {
                        if (beginPeriod <= 0) {
                            int _maxDays;
                            for (beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= maxDays ? begin : maxDays); beginPeriod <= 0; beginPeriod += _maxDays) {
                                _maxDays = calendar.getDaysOfYear(--beginYear);
                            }
                        }
                    } else {
                        beginYear = currentYear;
                        beginPeriod = begin;
                    }
                }
                int endPeriod = 0;
                if (isparseEnd) {
                    if (end <= 0) {
                        if (endPeriod <= 0) {
                            int _maxDays;
                            for (endPeriod = end <= 0 ? currentPeriod + end : (end <= maxDays ? end : maxDays); endPeriod <= 0; endPeriod += _maxDays) {
                                _maxDays = calendar.getDaysOfYear(--endYear);
                            }
                        }
                    } else {
                        endYear = currentYear;
                        endPeriod = end;
                    }
                }
                Calendar _calendar = Calendar.getInstance();
                _calendar.set(1, beginYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.set(11, 0);
                _calendar.set(12, 0);
                _calendar.set(13, 0);
                _calendar.set(14, 0);
                _calendar.add(6, beginPeriod - 1);
                if (isparseBegin) {
                    beginPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                }
                _calendar.set(1, endYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.set(11, 0);
                _calendar.set(12, 0);
                _calendar.set(13, 0);
                _calendar.set(14, 0);
                _calendar.add(6, endPeriod - 1);
                if (isparseEnd) {
                    endPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                }
            }
        } else if (isPass) {
            int endYear;
            currentYear = (Integer)adapter.getReportProperty("Report.Year");
            currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
            RptPeriodTypeEnum type = RptPeriodTypeEnum.getEnum((int)((Integer)adapter.getReportProperty("PeriodType")));
            int reportStartYear = adapter.getReportProperty("Report_StartYear") == null ? 0 : (Integer)adapter.getReportProperty("Report_StartYear");
            int reportStartPeriod = adapter.getReportProperty("Report_StartPeriod") == null ? 0 : (Integer)adapter.getReportProperty("Report_StartPeriod");
            int reportEndYear = adapter.getReportProperty("Report_EndYear") == null ? 0 : (Integer)adapter.getReportProperty("Report_EndYear");
            int reportEndPeriod = adapter.getReportProperty("Report_EndPeriod") == null ? 0 : (Integer)adapter.getReportProperty("Report_EndPeriod");
            int beginYear = reportStartYear == 0 ? currentYear : reportStartYear;
            int n = endYear = reportEndYear == 0 ? currentYear : reportEndYear;
            if (type.getValue() == 6) {
                currentPeriod = 0;
                if (isparseBegin) {
                    beginPeriodNumber = begin > 0 ? begin + "Y" : (beginYear += begin) + "Y";
                }
                if (isparseEnd) {
                    endPeriodNumber = end > 0 ? end + "Y" : (endYear += end) + "Y";
                }
            } else if (type.getValue() == 3) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 12 ? begin : 12);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 12;
                        int j = beginPeriod % 12;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 12 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 12 ? end : 12);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 12;
                        int j = endPeriod % 12;
                        endYear = endYear + i - 1;
                        endPeriod = 12 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                if (isparseBegin) {
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                }
                if (isparseEnd) {
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
                }
            } else if (type.getValue() == 4) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear = endYear + i - 1;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                if (isparseBegin) {
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                }
                if (isparseEnd) {
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
                }
            } else if (type.getValue() == 5) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear = endYear + i - 1;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                if (isparseBegin) {
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                }
                if (isparseEnd) {
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
                }
            } else if (type.getValue() == 2) {
                CalendarHelper calendar = new CalendarHelper();
                int maxWeek = calendar.getWeeksOfYear(currentYear, true);
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxWeeks;
                        for (beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= maxWeek ? begin : maxWeek); beginPeriod <= 0; beginPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--beginYear, true);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxWeeks;
                        for (endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= maxWeek ? end : maxWeek); endPeriod <= 0; endPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--endYear, true);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                if (isparseBegin) {
                    beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "W";
                }
                if (isparseEnd) {
                    endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "W";
                }
            } else if (type.getValue() == 1) {
                CalendarHelper calendar = new CalendarHelper();
                int maxDays = calendar.isLeapYear(currentYear) ? 366 : 365;
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxDays;
                        for (beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= maxDays ? begin : maxDays); beginPeriod <= 0; beginPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--beginYear);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxDays;
                        for (endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= maxDays ? end : maxDays); endPeriod <= 0; endPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--endYear);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                Calendar _calendar = Calendar.getInstance();
                _calendar.set(1, beginYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.set(11, 0);
                _calendar.set(12, 0);
                _calendar.set(13, 0);
                _calendar.set(14, 0);
                _calendar.add(6, beginPeriod - 1);
                if (isparseBegin) {
                    beginPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                }
                _calendar.set(1, endYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.set(11, 0);
                _calendar.set(12, 0);
                _calendar.set(13, 0);
                _calendar.set(14, 0);
                _calendar.add(6, endPeriod - 1);
                if (isparseEnd) {
                    endPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                }
            }
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            currencyNumber = this.getCorrect_Currency_Number();
        }
        paratemer[0] = orgNumber;
        paratemer[1] = bgSchemeNumber;
        paratemer[2] = bgElementNumber;
        paratemer[3] = strItemCombinNum;
        paratemer[4] = currencyNumber;
        paratemer[5] = beginPeriodNumber;
        paratemer[6] = endPeriodNumber;
        return paratemer;
    }

    public BigDecimal BgItem(String strItemCombinNum, String periodNumber, String bgElementNumber, String type, boolean isSum, String currencyNumber) {
        return new BigDecimal("0.00");
    }

    public BigDecimal BgItem(String strItemCombinNum, String periodNumber, String bgElementNumber, String currencyNumber) {
        return new BigDecimal("0.00");
    }

    public BigDecimal BgActual(String orgNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        IBgFormulaFacade iBgF = null;
        if (iBgF == null) {
            iBgF = this.ServerCtx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        int currentPeriod = 0;
        if (isPass) {
            currentYear = this.getReport_Year();
            currentPeriod = this.getReport_Period();
            int beginYear = this.getSheet_StartYear() == 0 ? currentYear : this.getSheet_StartYear();
            int beginPeriod = 0;
            beginPeriod = begin < 0 ? (this.getSheet_StartPeriod() == 0 ? currentPeriod + begin : this.getSheet_StartPeriod() + begin) : (begin <= 12 ? begin : 12);
            if (beginPeriod < 0 || beginPeriod > 12) {
                int i = beginPeriod / 12;
                int j = beginPeriod % 12;
                beginYear += i;
                beginPeriod = 12 + j;
            }
            int endYear = this.getSheet_EndYear() == 0 ? currentYear : this.getSheet_EndYear();
            int endPeriod = 0;
            endPeriod = end < 0 ? (this.getSheet_EndPeriod() == 0 ? currentPeriod + end : this.getSheet_EndPeriod() + end) : (end <= 12 ? end : 12);
            if (endPeriod < 0 || endPeriod > 12) {
                int i = endPeriod / 12;
                int j = endPeriod % 12;
                endYear += i;
                endPeriod = j;
            }
            beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
            endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            currencyNumber = this.getCorrect_Currency_Number();
        }
        BigDecimal result = iBgF.getBgValue(orgNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber, "fbizactual");
        return result;
    }

    public String BgGetOrgNum(String selectType) throws BOSException, EASBizException {
        IReportPropertyAdapter adapter = this.context.getReportAdapter();
        String bgFormID = null;
        if (adapter.getReportProperty("BG_FORM_ID") != null) {
            bgFormID = adapter.getReportProperty("BG_FORM_ID").toString();
        }
        IBgForm iBgForm = null;
        ICostCenterOrgUnit iCostCenterOrgUnit = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (this.ServerCtx == null) {
            iBgForm = BgFormFactory.getRemoteInstance();
            iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iBgForm = BgFormFactory.getLocalInstance((Context)this.ServerCtx);
            iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        }
        BgFormCollection cols = null;
        if (bgFormID != null) {
            cols = iBgForm.getBgFormCollection("select orgUnit.id where id = '" + bgFormID + "'");
        }
        BgFormInfo bgFormInfo = null;
        if (cols != null) {
            bgFormInfo = cols.get(0);
        }
        String number = "";
        if (bgFormInfo == null) {
            if (this.ServerCtx == null) {
                if (selectType.equalsIgnoreCase("CostCenter")) {
                    Object numberObj = adapter.getReportProperty("BgCostCenterNum");
                    if (numberObj != null && !"".equals(numberObj.toString())) {
                        return numberObj.toString();
                    }
                    number = SysContext.getSysContext().getCurrentCostUnit().getNumber();
                } else if (selectType.equalsIgnoreCase("CompanyUnit")) {
                    Object numberObj = adapter.getReportProperty("Company.Number");
                    if (number != null && !"".equals(numberObj.toString())) {
                        return numberObj.toString();
                    }
                    number = SysContext.getSysContext().getCurrentFIUnit().getNumber();
                }
                return number;
            }
            if (selectType.equalsIgnoreCase("CostCenter")) {
                Object numberObj = adapter.getReportProperty("BgCostCenterNum");
                if (numberObj != null && !"".equals(numberObj.toString())) {
                    return numberObj.toString();
                }
                number = ContextUtil.getCurrentCostUnit((Context)this.ServerCtx).getNumber();
            } else if (selectType.equalsIgnoreCase("CompanyUnit")) {
                Object numberObj = adapter.getReportProperty("Company.Number");
                if (number != null && !"".equals(numberObj.toString())) {
                    return numberObj.toString();
                }
                number = ContextUtil.getCurrentFIUnit((Context)this.ServerCtx).getNumber();
            }
            return number;
        }
        String curFormOrgUnitID = bgFormInfo.getOrgUnit().getId().toString();
        if (selectType.equalsIgnoreCase("CostCenter")) {
            number = this.getCostCenterNumber(iCostCenterOrgUnit, curFormOrgUnitID);
        } else if (selectType.equalsIgnoreCase("CompanyUnit")) {
            number = this.getCompanyUnitNumber(iCostCenterOrgUnit, iCompanyOrgUnit, curFormOrgUnitID);
        }
        return number;
    }

    private String getCostCenterNumber(ICostCenterOrgUnit iCostCenterOrgUnit, String curOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(curOrgUnitID);
        if (iCostCenterOrgUnit.exists((IObjectPK)pk)) {
            CostCenterOrgUnitInfo ccou = iCostCenterOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)pk);
            return ccou.getNumber();
        }
        return "";
    }

    private String getCompanyUnitNumber(ICostCenterOrgUnit iCostCenterOrgUnit, ICompanyOrgUnit iCompanyOrgUnit, String curOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(curOrgUnitID);
        if (iCompanyOrgUnit.exists((IObjectPK)pk)) {
            CompanyOrgUnitInfo coui = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
            return coui.getNumber();
        }
        CostCenterOrgUnitInfo info = null;
        try {
            info = iCostCenterOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            return "";
        }
        CostCenterOrgUnitInfo parentInfo = info.getParent();
        if (parentInfo == null) {
            return "";
        }
        String parentID = parentInfo.getId().toString();
        return this.getCompanyUnitNumber(iCostCenterOrgUnit, iCompanyOrgUnit, parentID);
    }

    public Object BgActualFD(String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        int currentPeriod = 0;
        if (isPass) {
            currentYear = this.getReport_Year();
            currentPeriod = this.getReport_Period();
            int beginYear = this.getSheet_StartYear() == 0 ? currentYear : this.getSheet_StartYear();
            int beginPeriod = 0;
            beginPeriod = begin < 0 ? (this.getSheet_StartPeriod() == 0 ? currentPeriod + begin : this.getSheet_StartPeriod() + begin) : (begin <= 12 ? begin : 12);
            if (beginPeriod < 0 || beginPeriod > 12) {
                int i = beginPeriod / 12;
                int j = beginPeriod % 12;
                beginYear += i;
                beginPeriod = 12 + j;
            }
            int endYear = this.getSheet_EndPeriod() == 0 ? currentYear : this.getSheet_EndPeriod();
            int endPeriod = 0;
            endPeriod = end < 0 ? (this.getSheet_EndPeriod() == 0 ? currentPeriod + end : this.getSheet_EndPeriod() + end) : (end <= 12 ? end : 12);
            if (endPeriod < 0 || endPeriod > 12) {
                int i = endPeriod / 12;
                int j = endPeriod % 12;
                endYear += i;
                endPeriod = j;
            }
            beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
            endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
        }
        if (currencyNumber == null || currencyNumber.length() <= 0) {
            currencyNumber = this.getCorrect_Currency_Number();
        }
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.ma.budget.BgHelper");
            Method method = clazz.getMethod("BgActualFD", Context.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class);
            result = method.invoke(clazz.newInstance(), this.ServerCtx, orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            return "BAD FUNCTION: " + e.getMessage();
        }
        return result;
    }

    public String bgRptDate(String dateFormat) throws EASBizException, BOSException {
        return this.getBgRptDate(dateFormat);
    }

    private String getBgRptDate(String dateFormat) throws BOSException, EASBizException {
        IBgPeriod ibp = null;
        ibp = this.ServerCtx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)this.ServerCtx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("beginDate");
        sic.add("endDate");
        sic.add("periodType");
        sic.add("year");
        sic.add("week");
        String periodId = (String)this.context.getReportAdapter().getReportProperty("BG_PERIOD_ID");
        BgPeriodInfo period = (BgPeriodInfo)ibp.getValue((IObjectPK)new ObjectUuidPK(periodId), sic);
        Date beginDate = period.getBeginDate();
        Date date = period.getEndDate();
        if (dateFormat.equalsIgnoreCase("yyyy")) {
            return new SimpleDateFormat("yyyy").format(date);
        }
        if (dateFormat.equalsIgnoreCase("mm")) {
            return new SimpleDateFormat("MM").format(date);
        }
        if (dateFormat.equalsIgnoreCase("dd")) {
            return new SimpleDateFormat("dd").format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-mm")) {
            return new SimpleDateFormat("yyyy-MM").format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-mm-dd")) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-mm-ww")) {
            int firstDayOfWeek;
            Calendar calendar = Calendar.getInstance();
            if (this.isLastDayOfMonth(date) && this.get(date, beginDate) < 7L) {
                calendar.setTime(beginDate);
                firstDayOfWeek = calendar.get(7);
                calendar.setFirstDayOfWeek(firstDayOfWeek);
                calendar.setTime(date);
            } else {
                calendar.setTime(date);
                firstDayOfWeek = calendar.get(7) + 1;
                calendar.setFirstDayOfWeek(firstDayOfWeek);
            }
            String formateKey = "yyyy-MM-WW";
            SimpleDateFormat sDateFormat = new SimpleDateFormat(formateKey);
            sDateFormat.setCalendar(calendar);
            return sDateFormat.format(date);
        }
        if (dateFormat.equalsIgnoreCase("yyyy-ww")) {
            int firstDayOfWeek;
            if (period.getPeriodType().getValue() == 5) {
                return period.getYear() + "-" + period.getWeek();
            }
            Calendar calendar = Calendar.getInstance();
            if (this.isLastDayOfMonth(date) && this.get(date, beginDate) < 7L) {
                calendar.setTime(beginDate);
                firstDayOfWeek = calendar.get(7);
                calendar.setFirstDayOfWeek(firstDayOfWeek);
                calendar.setTime(date);
            } else {
                calendar.setTime(BgReportCalculatorProvider.getFirstDayDateOfYear(date));
                firstDayOfWeek = calendar.get(7);
                calendar.setFirstDayOfWeek(firstDayOfWeek);
                calendar.setTime(date);
            }
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-ww");
            sDateFormat.setCalendar(calendar);
            Calendar maxSundayOfYear = this.getMaxSundayOfYear(calendar.get(1));
            if (calendar.after(maxSundayOfYear)) {
                return new SimpleDateFormat("yyyy").format(maxSundayOfYear.getTime()) + "-" + (maxSundayOfYear.get(3) + 1);
            }
            return sDateFormat.format(date);
        }
        return "";
    }

    private Calendar getMaxSundayOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        int dayOfWeek = c.get(7);
        ((Calendar)c).add(6, dayOfWeek * -1);
        return c;
    }

    public String getCurrentOrg(String returnType) throws EASBizException, BOSException {
        IFullOrgUnit ibf = this.ServerCtx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        String returnVal = "";
        if (this.context.getReportAdapter().getReportProperty("BG_ORG_ID") != null) {
            String orgid = (String)this.context.getReportAdapter().getReportProperty("BG_ORG_ID");
            String oql = "select name ,number where id = '" + orgid + "'";
            FullOrgUnitCollection col = ibf.getFullOrgUnitCollection(oql);
            FullOrgUnitInfo info = col.get(0);
            if (returnType.equals("Name")) {
                returnVal = info.getName();
            } else if (returnType.equals("Number")) {
                returnVal = info.getNumber();
            }
        }
        return returnVal;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    private boolean isLastDayOfMonth(Date a) {
        Calendar b = Calendar.getInstance();
        b.setTime(a);
        int lastDay = b.getActualMaximum(5);
        int now = b.get(5);
        return lastDay == now;
    }

    private long get(Date date1, Date date2) {
        long day = (date1.getTime() - date2.getTime()) / 86400000L > 0L ? (date1.getTime() - date2.getTime()) / 86400000L : (date2.getTime() - date1.getTime()) / 86400000L;
        return day;
    }

    public static Date getFirstDayDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMinimum(6);
        cal.set(6, last);
        return cal.getTime();
    }
}

