/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseAccountBalanceInfo;
import com.kingdee.eas.fi.gl.BaseAssistBalanceCollection;
import com.kingdee.eas.fi.gl.BaseAssistBalanceInfo;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VchAmortUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.ma.pca.AmortizeDcEnum;
import com.kingdee.eas.ma.pca.AmortizeLogInfo;
import com.kingdee.eas.ma.pca.AmortizeOrgTypeEnum;
import com.kingdee.eas.ma.pca.AmortizePattern;
import com.kingdee.eas.ma.pca.AmortizeRuleAccountDCEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleAmountType;
import com.kingdee.eas.ma.pca.AmortizeRuleAssActTypeEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.AmortizeSchemeGenVoucherHandler;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAmortizeRuleSrcEntryGenVoucher {
    protected AmortizeSchemeGenVoucherHandler handler;
    protected PeriodInfo period;
    protected PeriodInfo currentPeriod;
    protected Context ctx;
    protected AmortizeRuleInfo rule;
    protected AmortizeRuleSrcEntryInfo srcEntry;
    protected int periodNumber;
    protected Map<String, AmortizeLogInfo> logMap;
    protected Map<String, BigDecimal> workLoadMap;
    protected BigDecimal workLoadTotal;
    protected CompanyOrgUnitInfo company;
    protected UserInfo curUser;
    protected Date endDate;
    protected CurrencyInfo baseCurrency;
    protected CurrencyInfo rptCurrency;
    protected BigDecimal schemeToLocRate;
    protected BigDecimal schemeToRptRate = GlUtils.one;
    protected BigDecimal locToRptRate = GlUtils.one;
    protected BaseVoucherInfo voucher;
    protected AbstractObjectCollection entries;
    protected BaseVoucherEntryInfo voucherEntry;
    protected AbstractObjectCollection records;
    protected BaseVoucherEntryInfo cussentEntry;
    protected AbstractObjectCollection cussentRecords;
    protected int assDc;
    protected BalanceDirectionEnum accountDc;
    protected BigDecimal logAmtOri;
    protected BigDecimal amount;
    protected EntryDC amtDc;

    public AbstractAmortizeRuleSrcEntryGenVoucher(Context ctx, AmortizeRuleInfo rule, int periodNumber, Map<String, AmortizeLogInfo> logMap, Map<String, BigDecimal> workLoadMap, BigDecimal workLoadTotal, AmortizeSchemeGenVoucherHandler handler) throws EASBizException, BOSException {
        this.handler = handler;
        this.ctx = ctx;
        this.rule = rule;
        this.periodNumber = periodNumber;
        this.logMap = logMap;
        this.workLoadMap = workLoadMap;
        this.workLoadTotal = workLoadTotal;
        this.curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
    }

    protected abstract CompanyOrgUnitInfo getCompany() throws EASBizException, BOSException;

    protected abstract PeriodInfo getCurrentPeriod() throws EASBizException, BOSException;

    protected abstract void initBaseVoucher() throws EASBizException, BOSException;

    protected abstract BaseVoucherAssistRecordInfo createNewAssistRecordInfo();

    protected abstract BaseAssistBalanceCollection getAssistBalanceData() throws EASBizException, BOSException;

    protected abstract BaseAccountBalanceInfo getAccountBalanceData() throws EASBizException, BOSException;

    protected BigDecimal genSrcVoucher(AmortizeRuleSrcEntryInfo srcEntry) throws EASBizException, BOSException {
        this.init(srcEntry);
        this.initBaseVoucher();
        this.getSourceAmount();
        this.createOutVoucherEntry();
        if (srcEntry.getAccount().getCAA() != null) {
            this.createOutVoucherAssistRecords();
        }
        if (srcEntry.getCussentAccount() != null) {
            this.createCussentVoucherEntry();
            if (srcEntry.getCussentAccount().getCAA() != null) {
                this.createCussentVoucherAssistRecords();
            }
        }
        this.createAmortizeLog();
        return this.getRuleAmount();
    }

    protected void init(AmortizeRuleSrcEntryInfo srcEntry) throws EASBizException, BOSException {
        this.srcEntry = srcEntry;
        this.company = this.getCompany();
        this.period = this.handler.getPeriod(this.ctx, this.company, this.periodNumber);
        this.currentPeriod = this.getCurrentPeriod();
        this.endDate = this.period.getEndDate();
        this.baseCurrency = this.company.getBaseCurrency();
        this.rptCurrency = this.company.getReportCurrency();
        this.schemeToLocRate = this.handler.getCurrencyToLocExchangeRate(this.ctx, srcEntry.getCurrency(), this.period, this.company, this.endDate);
        if (this.rptCurrency != null) {
            this.schemeToRptRate = this.handler.getCurrencyToRptExchangeRate(this.ctx, srcEntry.getCurrency(), this.period, this.company, this.endDate);
            this.locToRptRate = this.handler.getCurrencyToRptExchangeRate(this.ctx, this.baseCurrency, this.period, this.company, this.endDate);
        }
        this.accountDc = srcEntry.getAccount().getDC();
        this.logAmtOri = new BigDecimal("0");
        this.assDc = 1;
        this.amount = new BigDecimal("0");
        this.amtDc = EntryDC.DEBIT;
    }

    protected void fillBaseVoucher() {
        this.voucher.setSourceBillId(this.srcEntry.getId().toString());
        this.voucher.setCompany(this.company);
        this.voucher.setId(null);
        this.voucher.setNumber(null);
        this.voucher.setCreator(this.curUser);
        this.voucher.setHandler(this.curUser);
        Date now = new Date();
        Timestamp t = new Timestamp(now.getTime());
        this.voucher.setCreateTime(t);
        this.voucher.setLastUpdateUser(this.curUser);
        this.voucher.setLastUpdateTime(t);
        this.voucher.setCashier(null);
        this.voucher.setAuditor(null);
        this.voucher.setPoster(null);
        this.voucher.setCanceller(null);
        this.voucher.setIsCheck(false);
        this.voucher.setIsCussent(false);
        this.voucher.setBizDate(this.endDate);
        this.voucher.setBookedDate(this.endDate);
        this.voucher.setPeriod(this.period);
        this.voucher.setSourceType(SourceType.AUTO_AMORTIZE);
        this.voucher.setBizStatus(VoucherStatusEnum.TEMP);
        this.voucher.setVoucherAbstract(this.rule.getDescription());
        this.voucher.setVoucherType(this.srcEntry.getVoucherType());
        this.voucher.setIsReverseVoucher(false);
        this.voucher.setCashflowFetched(false);
        this.voucher.setEntryCount(2);
    }

    private void getSourceAmount() throws EASBizException, BOSException {
        BaseVoucherAssistRecordInfo assist = null;
        if (AmortizeRuleAssActTypeEnum.Customize.equals((Object)this.srcEntry.getAsstMode()) && this.srcEntry.getAssRec() != null && this.srcEntry.getAssRec().size() > 0) {
            if (AmortizeRuleAmountType.Amount.equals((Object)this.srcEntry.getAssAmountType())) {
                AmortizeRuleSrcAssRecCollection srcAssCol = this.srcEntry.getAssRec();
                int j = srcAssCol.size();
                for (int i = 0; i < j; ++i) {
                    AmortizeRuleSrcAssRecInfo srcAssRec = srcAssCol.get(i);
                    assist = this.createNewAssistRecordInfo();
                    assist.setId(null);
                    assist.setSeq(i + 1);
                    assist.setDescription(this.rule.getDescription());
                    assist.setBizDate(this.endDate);
                    assist.setOprStatus(1);
                    this.handler.checkAssitInfo(this.ctx, srcAssRec.getAssGrp().getId().toString(), this.company.getId().toString(), this.curUser.getId().toString(), false, false);
                    assist.setAssGrp(srcAssRec.getAssGrp());
                    assist.setBill(this.voucher);
                    assist.setEntry(this.voucherEntry);
                    assist.setQuantity(srcAssRec.getQuantity());
                    assist.setPrice(srcAssRec.getPrice());
                    assist.setMeasureUnit(srcAssRec.getMeasureUnit());
                    this.amount = this.amount.add(srcAssRec.getAmount());
                    this.logAmtOri = this.logAmtOri.add(srcAssRec.getAmount());
                    assist.setOriginalAmount(srcAssRec.getAmount());
                    BigDecimal assLocalAmt = this.handler.exchangeCurrency(this.schemeToLocRate, this.baseCurrency, srcAssRec.getAmount());
                    assist.setLocalAmount(assLocalAmt);
                    BigDecimal assRptAmt = GlUtils.zero;
                    if (this.rptCurrency != null) {
                        assRptAmt = 3 == this.company.getReportConvertMode().getValue() ? this.handler.exchangeCurrency(this.locToRptRate, this.rptCurrency, assLocalAmt) : this.handler.exchangeCurrency(this.schemeToRptRate, this.rptCurrency, srcAssRec.getAmount());
                    }
                    assist.setReportingAmount(assRptAmt);
                    this.records.addObject((IObjectValue)assist);
                }
            } else {
                AmortizeRuleSrcAssRecCollection srcAssCol = this.srcEntry.getAssRec();
                HashMap<String, AmortizeRuleSrcAssRecInfo> assMap = new HashMap<String, AmortizeRuleSrcAssRecInfo>();
                int j = srcAssCol.size();
                for (int i = 0; i < j; ++i) {
                    AmortizeRuleSrcAssRecInfo srcAssRec = srcAssCol.get(i);
                    assMap.put(srcAssRec.getAssGrp().getId().toString(), srcAssRec);
                }
                Set grpSet = assMap.keySet();
                BaseAssistBalanceCollection balColl = this.getAssistBalanceData();
                int seq = 1;
                BigDecimal logAmtOriTmp = null;
                int j2 = balColl.size();
                for (int i = 0; i < j2; ++i) {
                    BaseAssistBalanceInfo info = balColl.get(i);
                    if (!grpSet.contains(info.getAssistGrp().getId().toString())) continue;
                    AmortizeRuleSrcAssRecInfo recInfo = (AmortizeRuleSrcAssRecInfo)assMap.get(info.getAssistGrp().getId().toString());
                    assist = this.createNewAssistRecordInfo();
                    assist.setId(null);
                    assist.setSeq(seq++);
                    assist.setDescription(this.rule.getDescription());
                    assist.setBizDate(this.endDate);
                    assist.setOprStatus(1);
                    this.handler.checkAssitInfo(this.ctx, info.getAssistGrp().getId().toString(), this.company.getId().toString(), this.curUser.getId().toString(), false, false);
                    assist.setAssGrp(info.getAssistGrp());
                    assist.setBill(this.voucher);
                    assist.setEntry(this.voucherEntry);
                    assist.setQuantity(recInfo.getQuantity());
                    assist.setPrice(recInfo.getPrice());
                    assist.setMeasureUnit(recInfo.getMeasureUnit());
                    BigDecimal assOriAmt = null;
                    switch (this.srcEntry.getAmountSourceType().getValue()) {
                        case 1: {
                            assOriAmt = info.getEndBalanceFor().add(info.getYearCreditFor()).subtract(info.getYearDebitFor());
                            if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                                logAmtOriTmp = assOriAmt;
                                break;
                            }
                            logAmtOriTmp = assOriAmt.negate();
                            break;
                        }
                        case 2: {
                            assOriAmt = info.getBeginBalanceFor();
                            if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                                logAmtOriTmp = assOriAmt;
                                break;
                            }
                            logAmtOriTmp = assOriAmt.negate();
                            break;
                        }
                        case 3: {
                            logAmtOriTmp = assOriAmt = info.getDebitFor();
                            break;
                        }
                        case 4: {
                            assOriAmt = info.getCreditFor();
                            this.amtDc = EntryDC.CREDIT;
                            logAmtOriTmp = assOriAmt;
                            break;
                        }
                        case 5: {
                            assOriAmt = info.getDebitFor().subtract(info.getCreditFor());
                            if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                                logAmtOriTmp = assOriAmt;
                                break;
                            }
                            logAmtOriTmp = assOriAmt.negate();
                            break;
                        }
                        case 6: {
                            logAmtOriTmp = assOriAmt = info.getYearDebitFor();
                            break;
                        }
                        case 7: {
                            assOriAmt = info.getYearCreditFor();
                            this.amtDc = EntryDC.CREDIT;
                            logAmtOriTmp = assOriAmt;
                            break;
                        }
                        case 8: {
                            assOriAmt = info.getEndBalanceFor();
                            if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                                logAmtOriTmp = assOriAmt;
                                break;
                            }
                            logAmtOriTmp = assOriAmt.negate();
                            break;
                        }
                        default: {
                            assOriAmt = new BigDecimal("0");
                            logAmtOriTmp = new BigDecimal("0");
                        }
                    }
                    assOriAmt = assOriAmt.multiply(recInfo.getRatio()).divide(new BigDecimal("100"), this.srcEntry.getCurrency().getPrecision(), 4);
                    logAmtOriTmp = logAmtOriTmp.multiply(recInfo.getRatio()).divide(new BigDecimal("100"), this.srcEntry.getCurrency().getPrecision(), 4);
                    this.amount = this.amount.add(assOriAmt);
                    this.logAmtOri = this.logAmtOri.add(logAmtOriTmp);
                    assist.setOriginalAmount(assOriAmt);
                    BigDecimal assLocalAmt = this.handler.exchangeCurrency(this.schemeToLocRate, this.baseCurrency, assOriAmt);
                    assist.setLocalAmount(assLocalAmt);
                    BigDecimal assRptAmt = GlUtils.zero;
                    if (this.rptCurrency != null) {
                        assRptAmt = 3 == this.company.getReportConvertMode().getValue() ? this.handler.exchangeCurrency(this.locToRptRate, this.rptCurrency, assLocalAmt) : this.handler.exchangeCurrency(this.schemeToRptRate, this.rptCurrency, assOriAmt);
                    }
                    assist.setReportingAmount(assRptAmt);
                    this.records.addObject((IObjectValue)assist);
                }
            }
        } else if (AmortizeRuleAmountType.Amount.equals((Object)this.srcEntry.getAccountAmountType())) {
            this.logAmtOri = this.amount = this.srcEntry.getAmount();
        } else {
            BaseAccountBalanceInfo info = this.getAccountBalanceData();
            if (info != null) {
                switch (this.srcEntry.getAmountSourceType().getValue()) {
                    case 1: {
                        this.amount = info.getEndBalanceFor().add(info.getYearCreditFor()).subtract(info.getYearDebitFor());
                        if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                            this.logAmtOri = this.amount;
                            break;
                        }
                        this.logAmtOri = this.amount.negate();
                        break;
                    }
                    case 2: {
                        this.amount = info.getBeginBalanceFor();
                        if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                            this.logAmtOri = this.amount;
                            break;
                        }
                        this.logAmtOri = this.amount.negate();
                        break;
                    }
                    case 3: {
                        this.logAmtOri = this.amount = info.getDebitFor();
                        break;
                    }
                    case 4: {
                        this.amount = info.getCreditFor();
                        this.amtDc = EntryDC.CREDIT;
                        this.logAmtOri = this.amount;
                        break;
                    }
                    case 5: {
                        this.amount = info.getDebitFor().subtract(info.getCreditFor());
                        if (BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc)) {
                            this.logAmtOri = this.amount;
                            break;
                        }
                        this.logAmtOri = this.amount.negate();
                        break;
                    }
                    case 6: {
                        this.logAmtOri = this.amount = info.getYearDebitFor();
                        break;
                    }
                    case 7: {
                        this.amount = info.getYearCreditFor();
                        this.amtDc = EntryDC.CREDIT;
                        this.logAmtOri = this.amount;
                        break;
                    }
                    case 8: {
                        this.amount = info.getEndBalanceFor();
                        this.logAmtOri = BalanceDirectionEnum.DEBIT.equals((Object)this.accountDc) ? this.amount : this.amount.negate();
                    }
                }
            } else {
                this.logAmtOri = this.amount = new BigDecimal("0");
            }
            this.amount = this.amount.multiply(this.srcEntry.getRatio()).divide(new BigDecimal("100"), this.srcEntry.getCurrency().getPrecision(), 4);
            this.logAmtOri = this.logAmtOri.multiply(this.srcEntry.getRatio()).divide(new BigDecimal("100"), this.srcEntry.getCurrency().getPrecision(), 4);
        }
        this.amount = this.amount.setScale(this.srcEntry.getCurrency().getPrecision());
        if (AmortizeRuleAccountDCEnum.Auto.equals((Object)this.srcEntry.getDc())) {
            this.amount = this.amount.negate();
            this.assDc *= -1;
        }
    }

    private void createOutVoucherEntry() {
        BigDecimal entryLocAmt = this.handler.exchangeCurrency(this.schemeToLocRate, this.baseCurrency, this.amount);
        BigDecimal entryRptAmt = GlUtils.zero;
        BigDecimal schemeRptExchangerate = GlUtils.one;
        if (this.rptCurrency != null) {
            if (3 == this.company.getReportConvertMode().getValue()) {
                entryRptAmt = this.handler.exchangeCurrency(this.locToRptRate, this.rptCurrency, entryLocAmt);
                schemeRptExchangerate = this.locToRptRate;
            } else {
                entryRptAmt = this.handler.exchangeCurrency(this.schemeToRptRate, this.rptCurrency, this.amount);
                schemeRptExchangerate = this.schemeToRptRate;
            }
        }
        this.entries.addObject((IObjectValue)this.voucherEntry);
        this.voucherEntry.setAccount(this.srcEntry.getAccount());
        this.voucherEntry.setCurrency(this.srcEntry.getCurrency());
        this.voucherEntry.setSeq(1);
        this.voucherEntry.setDescription(this.rule.getDescription());
        this.voucherEntry.setOprStatus(1);
        this.voucherEntry.setIsCheck(false);
        this.voucherEntry.setIsHand(true);
        this.voucherEntry.setBill(this.voucher);
        if (AmortizeRuleAccountDCEnum.Auto.equals((Object)this.srcEntry.getDc())) {
            if (this.amount.signum() >= 0) {
                this.voucherEntry.setEntryDC(this.amtDc);
            } else {
                this.amount = this.amount.negate();
                this.assDc *= -1;
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
                if (EntryDC.CREDIT.equals((Object)this.amtDc)) {
                    this.voucherEntry.setEntryDC(EntryDC.DEBIT);
                } else {
                    this.voucherEntry.setEntryDC(EntryDC.CREDIT);
                }
            }
        } else if (AmortizeRuleAccountDCEnum.Credit.equals((Object)this.srcEntry.getDc())) {
            this.voucherEntry.setEntryDC(EntryDC.CREDIT);
            if (EntryDC.DEBIT.equals((Object)this.amtDc)) {
                this.amount = this.amount.negate();
                this.assDc *= -1;
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
            }
        } else {
            this.voucherEntry.setEntryDC(EntryDC.DEBIT);
            if (EntryDC.CREDIT.equals((Object)this.amtDc)) {
                this.amount = this.amount.negate();
                this.assDc *= -1;
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
            }
        }
        this.voucherEntry.setOriginalAmount(this.amount);
        this.voucherEntry.setLocalAmount(entryLocAmt);
        this.voucherEntry.setReportingAmount(entryRptAmt);
        this.voucherEntry.setLocalExchangeRate(this.schemeToLocRate);
        this.voucherEntry.setReportingExchangeRate(schemeRptExchangerate);
        this.voucher.setLocalDebitAmount(this.voucherEntry.getLocalAmount());
        this.voucher.setLocalCreditAmount(this.voucherEntry.getLocalAmount());
        this.voucher.setReportingDebitAmount(this.voucherEntry.getReportingAmount());
        this.voucher.setReportingCreditAmount(this.voucherEntry.getReportingAmount());
    }

    private void createOutVoucherAssistRecords() throws BOSException, EASBizException {
        block17: {
            block16: {
                BaseVoucherAssistRecordInfo assist = null;
                if (!AmortizeRuleAssActTypeEnum.Auto.equals((Object)this.srcEntry.getAsstMode())) break block16;
                BaseAssistBalanceCollection balColl = this.getAssistBalanceData();
                BigDecimal assOriAmtOcp = new BigDecimal("0");
                int j = balColl.size();
                for (int i = 0; i < j; ++i) {
                    BaseAssistBalanceInfo info = balColl.get(i);
                    assist = this.createNewAssistRecordInfo();
                    assist.setId(null);
                    assist.setSeq(i + 1);
                    assist.setDescription(this.rule.getDescription());
                    assist.setBizDate(this.endDate);
                    assist.setOprStatus(1);
                    this.handler.checkAssitInfo(this.ctx, info.getAssistGrp().getId().toString(), this.company.getId().toString(), this.curUser.getId().toString(), false, false);
                    assist.setAssGrp(info.getAssistGrp());
                    assist.setBill(this.voucher);
                    assist.setEntry(this.voucherEntry);
                    BigDecimal assOriAmt = null;
                    switch (this.srcEntry.getAmountSourceType().getValue()) {
                        case 1: {
                            assOriAmt = info.getEndBalanceFor().add(info.getYearCreditFor()).subtract(info.getYearDebitFor());
                            break;
                        }
                        case 2: {
                            assOriAmt = info.getBeginBalanceFor();
                            break;
                        }
                        case 3: {
                            assOriAmt = info.getDebitFor();
                            break;
                        }
                        case 4: {
                            assOriAmt = info.getCreditFor();
                            break;
                        }
                        case 5: {
                            assOriAmt = info.getDebitFor().subtract(info.getCreditFor());
                            break;
                        }
                        case 6: {
                            assOriAmt = info.getYearDebitFor();
                            break;
                        }
                        case 7: {
                            assOriAmt = info.getYearCreditFor();
                            break;
                        }
                        case 8: {
                            assOriAmt = info.getEndBalanceFor();
                            break;
                        }
                        default: {
                            assOriAmt = new BigDecimal("0");
                        }
                    }
                    assOriAmt = assOriAmt.multiply(this.srcEntry.getRatio()).divide(new BigDecimal("100"), this.srcEntry.getCurrency().getPrecision(), 4);
                    if (this.assDc == -1) {
                        assOriAmt = assOriAmt.negate();
                    }
                    if (i == j - 1) {
                        assOriAmt = this.amount.subtract(assOriAmtOcp);
                    } else {
                        assOriAmtOcp = assOriAmtOcp.add(assOriAmt);
                    }
                    assist.setOriginalAmount(assOriAmt);
                    BigDecimal assLocalAmt = this.handler.exchangeCurrency(this.schemeToLocRate, this.baseCurrency, assOriAmt);
                    assist.setLocalAmount(assLocalAmt);
                    BigDecimal assRptAmt = GlUtils.zero;
                    if (this.rptCurrency != null) {
                        assRptAmt = 3 == this.company.getReportConvertMode().getValue() ? this.handler.exchangeCurrency(this.locToRptRate, this.rptCurrency, assLocalAmt) : this.handler.exchangeCurrency(this.schemeToRptRate, this.rptCurrency, assOriAmt);
                    }
                    assist.setReportingAmount(assRptAmt);
                    this.records.addObject((IObjectValue)assist);
                }
                break block17;
            }
            if (this.assDc != -1) break block17;
            int j = this.records.size();
            for (int i = 0; i < j; ++i) {
                BaseVoucherAssistRecordInfo rec = (BaseVoucherAssistRecordInfo)this.records.getObject(i);
                rec.setOriginalAmount(rec.getOriginalAmount().negate());
                rec.setLocalAmount(rec.getLocalAmount().negate());
                rec.setReportingAmount(rec.getReportingAmount().negate());
            }
        }
    }

    private void createCussentVoucherEntry() throws EASBizException, BOSException {
        this.entries.addObject((IObjectValue)this.cussentEntry);
        this.cussentEntry.setSeq(2);
        this.cussentEntry.setDescription(this.rule.getDescription());
        this.cussentEntry.setOprStatus(1);
        this.cussentEntry.setIsCheck(false);
        this.cussentEntry.setIsHand(true);
        this.cussentEntry.setAccount(this.srcEntry.getCussentAccount());
        this.cussentEntry.setBill(this.voucher);
        this.cussentEntry.setEntryDC(EntryDC.DEBIT);
        if (EntryDC.DEBIT.equals((Object)this.voucherEntry.getEntryDC())) {
            this.cussentEntry.setEntryDC(EntryDC.CREDIT);
        }
        BigDecimal cussentToRptRate = GlUtils.one;
        BigDecimal cussentToLocRate = this.handler.getCurrencyToLocExchangeRate(this.ctx, this.srcEntry.getCussentCurrency(), this.period, this.company, this.endDate);
        if (this.rptCurrency != null) {
            cussentToRptRate = this.handler.getCurrencyToRptExchangeRate(this.ctx, this.srcEntry.getCussentCurrency(), this.period, this.company, this.endDate);
        }
        this.cussentEntry.setCurrency(this.srcEntry.getCussentCurrency());
        this.cussentEntry.setOriginalAmount(this.voucherEntry.getOriginalAmount());
        this.cussentEntry.setLocalAmount(this.voucherEntry.getLocalAmount());
        this.cussentEntry.setReportingAmount(this.voucherEntry.getReportingAmount());
        this.cussentEntry.setLocalExchangeRate(this.voucherEntry.getLocalExchangeRate());
        this.cussentEntry.setReportingExchangeRate(this.voucherEntry.getReportingExchangeRate());
        if (!this.srcEntry.getCurrency().getId().toString().equals(this.srcEntry.getCussentCurrency().getId().toString())) {
            this.cussentEntry.setOriginalAmount(this.voucherEntry.getLocalAmount().divide(cussentToLocRate, this.srcEntry.getCussentCurrency().getPrecision(), 4));
            this.cussentEntry.setLocalExchangeRate(cussentToLocRate);
            BigDecimal cussentRptExchangerate = GlUtils.one;
            if (this.rptCurrency != null) {
                cussentRptExchangerate = 3 == this.company.getReportConvertMode().getValue() ? this.locToRptRate : cussentToRptRate;
            }
            this.cussentEntry.setReportingExchangeRate(cussentRptExchangerate);
        }
    }

    private void createCussentVoucherAssistRecords() throws EASBizException, BOSException {
        AsstActGroupDetailInfo aagpInfo;
        int i;
        BaseVoucherAssistRecordInfo cAssist = null;
        cAssist = this.createNewAssistRecordInfo();
        cAssist.setId(null);
        cAssist.setSeq(1);
        cAssist.setDescription(this.rule.getDescription());
        cAssist.setBizDate(this.endDate);
        cAssist.setOprStatus(1);
        if (this.srcEntry.getCussentAssGrp() != null) {
            this.handler.checkAssitInfo(this.ctx, this.srcEntry.getCussentAssGrp().getId().toString(), this.company.getId().toString(), this.curUser.getId().toString(), false, false);
            cAssist.setAssGrp(this.srcEntry.getCussentAssGrp());
        }
        cAssist.setBill(this.voucher);
        cAssist.setEntry(this.cussentEntry);
        cAssist.setOriginalAmount(this.cussentEntry.getOriginalAmount());
        cAssist.setLocalAmount(this.cussentEntry.getLocalAmount());
        cAssist.setReportingAmount(this.cussentEntry.getReportingAmount());
        AsstAccountInfo aac = this.srcEntry.getCussentAccount().getCAA();
        AsstActGroupDetailCollection aagColl = aac.getAsstActGpDt();
        AsstActTypeCollection actTypes = new AsstActTypeCollection();
        int j = aagColl.size();
        for (i = 0; i < j; ++i) {
            aagpInfo = aagColl.get(i);
            actTypes.add(aagpInfo.getAsstActType());
        }
        j = aagColl.size();
        for (i = 0; i < j; ++i) {
            aagpInfo = aagColl.get(i);
            String assHgAttr = aagpInfo.getAsstActType().getAsstHGAttribute();
            if ((!"companyOrg".equals(assHgAttr) || !AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)this.rule.getAmortizeOrgType())) && (!"profitOrg".equals(assHgAttr) || AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)this.rule.getAmortizeOrgType()))) continue;
            if (AmortizePattern.Workload.equals((Object)this.rule.getAmortizePattern()) && this.workLoadMap != null) {
                Set<String> idSet = this.workLoadMap.keySet();
                String[] ids = idSet.toArray(new String[idSet.size()]);
                BigDecimal oriAmountLeft = this.cussentEntry.getOriginalAmount();
                BigDecimal LocAmountLeft = this.cussentEntry.getLocalAmount();
                BigDecimal rptAmountLeft = this.cussentEntry.getReportingAmount();
                int n = ids.length;
                for (int m = 0; m < n; ++m) {
                    CompanyOrgUnitInfo comHg;
                    String orgID = ids[m];
                    BigDecimal workLoad = this.workLoadMap.get(orgID);
                    BaseVoucherAssistRecordInfo nAss = (BaseVoucherAssistRecordInfo)cAssist.clone();
                    nAss.setSeq(m + 1);
                    if (m + 1 == n) {
                        nAss.setOriginalAmount(oriAmountLeft);
                        nAss.setLocalAmount(LocAmountLeft);
                        nAss.setReportingAmount(rptAmountLeft);
                    } else {
                        nAss.setOriginalAmount(this.cussentEntry.getOriginalAmount().multiply(workLoad).divide(this.workLoadTotal, this.cussentEntry.getOriginalAmount().scale(), 4));
                        nAss.setLocalAmount(this.cussentEntry.getLocalAmount().multiply(workLoad).divide(this.workLoadTotal, this.cussentEntry.getLocalAmount().scale(), 4));
                        nAss.setReportingAmount(this.cussentEntry.getReportingAmount().multiply(workLoad).divide(this.workLoadTotal, this.cussentEntry.getReportingAmount().scale(), 4));
                        oriAmountLeft = oriAmountLeft.subtract(nAss.getOriginalAmount());
                        LocAmountLeft = LocAmountLeft.subtract(nAss.getLocalAmount());
                        rptAmountLeft = rptAmountLeft.subtract(nAss.getReportingAmount());
                    }
                    AssistantHGInfo assHgInfo = this.srcEntry.getCussentAssGrp();
                    if (assHgInfo == null) {
                        assHgInfo = new AssistantHGInfo();
                    }
                    if ("companyOrg".equals(assHgAttr)) {
                        comHg = new CompanyOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setCompanyOrg(comHg);
                    } else {
                        comHg = new ProfitCenterOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setProfitOrg((ProfitCenterOrgUnitInfo)comHg);
                    }
                    assHgInfo.setId(null);
                    assHgInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHG(assHgInfo, aac.getId().toString(), actTypes);
                    nAss.setAssGrp(assHgInfo);
                    this.cussentRecords.addObject((IObjectValue)nAss);
                }
            } else {
                AmortizeRuleDestEntryCollection destEntries = this.rule.getDestEntries();
                HashMap<String, BigDecimal> orgRadioMap = new HashMap<String, BigDecimal>();
                int n = destEntries.size();
                for (int m = 0; m < n; ++m) {
                    AmortizeRuleDestEntryInfo destEntry = destEntries.get(m);
                    String orgID = "companyOrg".equals(assHgAttr) ? destEntry.getCompany().getId().toString() : destEntry.getProfitCenter().getId().toString();
                    orgRadioMap.put(orgID, destEntry.getOrgRatio());
                }
                Set keySet = orgRadioMap.keySet();
                String[] ids = keySet.toArray(new String[keySet.size()]);
                BigDecimal oriAmountLeft = this.cussentEntry.getOriginalAmount();
                BigDecimal LocAmountLeft = this.cussentEntry.getLocalAmount();
                BigDecimal rptAmountLeft = this.cussentEntry.getReportingAmount();
                int n2 = ids.length;
                for (int m = 0; m < n2; ++m) {
                    CompanyOrgUnitInfo comHg;
                    String orgID = ids[m];
                    BaseVoucherAssistRecordInfo nAss = (BaseVoucherAssistRecordInfo)cAssist.clone();
                    nAss.setSeq(m + 1);
                    if (m + 1 == n2) {
                        nAss.setOriginalAmount(oriAmountLeft);
                        nAss.setLocalAmount(LocAmountLeft);
                        nAss.setReportingAmount(rptAmountLeft);
                    } else {
                        BigDecimal orgRadio = (BigDecimal)orgRadioMap.get(orgID);
                        nAss.setOriginalAmount(this.cussentEntry.getOriginalAmount().multiply(orgRadio).divide(VchAmortUtils.ONE_HUNDRED, this.cussentEntry.getOriginalAmount().scale(), 4));
                        nAss.setLocalAmount(this.cussentEntry.getLocalAmount().multiply(orgRadio).divide(VchAmortUtils.ONE_HUNDRED, this.cussentEntry.getLocalAmount().scale(), 4));
                        nAss.setReportingAmount(this.cussentEntry.getReportingAmount().multiply(orgRadio).divide(VchAmortUtils.ONE_HUNDRED, this.cussentEntry.getReportingAmount().scale(), 4));
                        oriAmountLeft = oriAmountLeft.subtract(nAss.getOriginalAmount());
                        LocAmountLeft = LocAmountLeft.subtract(nAss.getLocalAmount());
                        rptAmountLeft = rptAmountLeft.subtract(nAss.getReportingAmount());
                    }
                    AssistantHGInfo assHgInfo = this.srcEntry.getCussentAssGrp();
                    if (assHgInfo == null) {
                        assHgInfo = new AssistantHGInfo();
                    }
                    if ("companyOrg".equals(assHgAttr)) {
                        comHg = new CompanyOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setCompanyOrg(comHg);
                    } else {
                        comHg = new ProfitCenterOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setProfitOrg((ProfitCenterOrgUnitInfo)comHg);
                    }
                    assHgInfo.setId(null);
                    assHgInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHG(assHgInfo, aac.getId().toString(), actTypes);
                    nAss.setAssGrp(assHgInfo);
                    this.cussentRecords.addObject((IObjectValue)nAss);
                }
            }
            cAssist = null;
            break;
        }
        if (cAssist != null) {
            this.cussentRecords.addObject((IObjectValue)cAssist);
        }
        this.cussentEntry.setAssistRecords(this.cussentRecords);
    }

    private void createAmortizeLog() {
        AmortizeLogInfo logInfo = new AmortizeLogInfo();
        if (this.voucher instanceof PcVoucherInfo) {
            logInfo.setPcVoucher((PcVoucherInfo)this.voucher);
        } else if (this.rule.getAmortizeOrgType().equals((Object)AmortizeOrgTypeEnum.CompanyToProfitCenter)) {
            logInfo.setVoucher(null);
        } else {
            logInfo.setVoucher((VoucherInfo)this.voucher);
        }
        this.fillAmortizeLog(logInfo);
        logInfo.setAmortizeDC(AmortizeDcEnum.Out);
        logInfo.setAmortizeRule(this.rule);
        BigDecimal logAmt = this.voucherEntry.getLocalAmount();
        if (this.logAmtOri.signum() * logAmt.signum() < 0) {
            logAmt = logAmt.negate();
        }
        logInfo.setAmount(logAmt);
        logInfo.setPeriod(this.period);
        logInfo.setCurrency(this.baseCurrency);
        String logMapKey = this.getAmortizeLogMapKey();
        if (this.logMap.get(logMapKey) != null) {
            AmortizeLogInfo extLogInfo = this.logMap.get(logMapKey);
            extLogInfo.setAmount(extLogInfo.getAmount().add(logAmt));
            PcVoucherInfo extVoucherInfo = extLogInfo.getPcVoucher();
            extVoucherInfo.setLocalCreditAmount(extVoucherInfo.getLocalCreditAmount().add(this.voucher.getLocalCreditAmount()));
            extVoucherInfo.setLocalDebitAmount(extVoucherInfo.getLocalDebitAmount().add(this.voucher.getLocalDebitAmount()));
            extVoucherInfo.setReportingCreditAmount(extVoucherInfo.getReportingCreditAmount().add(this.voucher.getReportingCreditAmount()));
            extVoucherInfo.setReportingDebitAmount(extVoucherInfo.getReportingDebitAmount().add(this.voucher.getReportingDebitAmount()));
            int j = this.entries.size();
            for (int i = 0; i < j; ++i) {
                BaseVoucherEntryInfo entryInfo = (BaseVoucherEntryInfo)this.entries.getObject(i);
                entryInfo.setSeq(extVoucherInfo.getEntryCount() + 1);
                extVoucherInfo.getEntries().addObject((IObjectValue)entryInfo);
                extVoucherInfo.setEntryCount(extVoucherInfo.getEntryCount() + 1);
            }
        } else {
            this.logMap.put(logMapKey, logInfo);
        }
    }

    protected abstract void fillAmortizeLog(AmortizeLogInfo var1);

    protected abstract String getAmortizeLogMapKey();

    protected BigDecimal getRuleAmount() throws BOSException, EASBizException {
        BigDecimal localAmount;
        BigDecimal bigDecimal = localAmount = EntryDC.CREDIT.equals((Object)this.voucherEntry.getEntryDC()) ? this.voucherEntry.getLocalAmount().negate() : this.voucherEntry.getLocalAmount();
        if (this.rule.getCompany().getBaseCurrency().getId().toString().equals(this.baseCurrency.getId().toString())) {
            return localAmount;
        }
        BigDecimal ruleToLocRate = this.handler.getCurrencyToLocExchangeRate(this.ctx, this.rule.getCompany().getBaseCurrency(), this.period, this.company, this.endDate);
        return localAmount.divide(ruleToLocRate, this.rule.getCompany().getBaseCurrency().getPrecision(), 4);
    }
}

