/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.PcCashflowUtils;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCashflowInitService {
    protected Context ctx;
    protected CompanyOrgUnitInfo company;
    protected ProfitCenterOrgUnitInfo profitCenter;
    protected static final BigDecimal ZERO = new BigDecimal("0");
    protected static final String RESCLASSNAME = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    protected static final String RECFLOW = "com.kingdee.eas.fi.gl.CashflowInitResource";
    protected int lineIndex = 1;
    protected final Integer INTESUB1 = new Integer(11000000);
    protected final Integer INTESUB2 = new Integer(12000000);
    protected final Integer INTEPURGE1 = new Integer(11000000);
    protected final Integer INTEPURGE2 = new Integer(12000000);
    protected final Integer PRIMARYWORK = new Integer(30000000);
    protected final Integer SECONDARYWORK = new Integer(30000001);
    protected final Integer PRIMARYCASH = new Integer(40000000);
    protected final Integer SECONDARYCASH = new Integer(40000001);

    public AbstractCashflowInitService(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter) {
        this.ctx = ctx;
        this.company = company;
        this.profitCenter = profitCenter;
    }

    protected Map getCashBalance(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        PeriodInfo[] periods = PcaInitHelp.getPeriods(ctx, this.company, this.profitCenter);
        AccountRefContrastInfo accountInfo = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(this.company.getCU().getId().toString(), this.company.getAccountTable().getId().toString(), periods[2].getPeriodYear(), periods[2].getPeriodNumber());
        String curAcctTableID = null;
        curAcctTableID = accountInfo != null && accountInfo.getDisabledAcctTable() != null ? accountInfo.getDisabledAcctTable().getId().toString() : this.company.getAccountTable().getId().toString();
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
        }
        sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        Map cashBegin = this.getAmountFromBalance(ctx, currencyCollection, true, true, sbCurrencyIds.toString(), curAcctTableID);
        Map cashEnd = this.getAmountFromBalance(ctx, currencyCollection, true, false, sbCurrencyIds.toString(), curAcctTableID);
        Map equBegin = this.getAmountFromBalance(ctx, currencyCollection, false, true, sbCurrencyIds.toString(), curAcctTableID);
        Map equEnd = this.getAmountFromBalance(ctx, currencyCollection, false, false, sbCurrencyIds.toString(), curAcctTableID);
        HashMap<BOSUuid, QueryData[]> result = new HashMap<BOSUuid, QueryData[]>();
        QueryData[] data = null;
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            data = new QueryData[]{(QueryData)cashBegin.get(currency.getId()), (QueryData)cashEnd.get(currency.getId()), (QueryData)equBegin.get(currency.getId()), (QueryData)equEnd.get(currency.getId())};
            result.put(currency.getId(), data);
        }
        return result;
    }

    private Map getAmountFromBalance(Context ctx, CurrencyCollection currencyCollection, boolean isCash, boolean isBegin, String currencyIds, String accountTableId) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer("Select balance.FCurrencyID,");
        if (isBegin) {
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditFor-FYearDebitFor+FBeginBalanceFor) else (FYearDebitFor-FYearCreditFor+(-1)*FBeginBalanceFor) end) FAmount, ");
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditLocal-FYearDebitLocal+FBeginBalanceLocal) else (FYearDebitLocal-FYearCreditLocal+(-1)*FBeginBalanceLocal) end) FAmountLocal, ");
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditRpt-FYearDebitRpt+FBeginBalanceRpt) else (FYearDebitRpt-FYearCreditRpt+(-1)*FBeginBalanceRpt) end) FAmountRpt ");
        } else {
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceFor else (-1)*FBeginBalanceFor end) FAmount, ");
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceLocal else (-1)*FBeginBalanceLocal end) FAmountLocal, ");
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceRpt else (-1)*FBeginBalanceRpt end) FAmountRpt ");
        }
        sbSql.append(" from T_pca_InitpcAccountBalance balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1");
        sbSql.append(" and balance.FprofitCenterId = ?");
        sbSql.append(" and balance.FCurrencyID in (").append(currencyIds).append(")");
        sbSql.append(" and account.FaccountTableId = ?");
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        sbSql.append(" group by  balance.FCurrencyID");
        HashMap<BOSUuid, QueryData> result = new HashMap<BOSUuid, QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{this.profitCenter.getId().toString(), accountTableId});
            while (rs.next()) {
                QueryData data = new QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FAmount") == null ? ZERO : rs.getBigDecimal("FAmount"));
                data.setLocalAmount(rs.getBigDecimal("FAmountLocal") == null ? ZERO : rs.getBigDecimal("FAmountLocal"));
                data.setReportingAmount(rs.getBigDecimal("FAmountRpt") == null ? ZERO : rs.getBigDecimal("FAmountRpt"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    protected void checkQueryResult(CurrencyCollection currencyCollection, Map result) {
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (result.containsKey(currency.getId())) continue;
            QueryData data = new QueryData();
            data.setCurrency(currency);
            data.setOriginalAmount(ZERO);
            data.setLocalAmount(ZERO);
            data.setReportingAmount(ZERO);
            result.put(data.getCurrency().getId(), data);
        }
    }

    protected String getGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
    }

    protected String getGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
    }

    protected Map getRetainedProfits(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
        }
        String diffAccountSet = PcCashflowUtils.getDiff(ctx, this.company);
        sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        StringBuffer sbSql = new StringBuffer("Select balance.FCurrencyID,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLFor else (-1)*FYearPnLFor end) FAmount ,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLLocal else (-1)*FYearPnLLocal end) FAmountLocal ,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLRpt else (-1)*FYearPnLRpt end) FAmountRpt ");
        sbSql.append(" from T_pca_InitpcAccountBalance balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1 and account.FPLType>0");
        sbSql.append(" and balance.FprofitCenterId = ?");
        sbSql.append(" and balance.FCurrencyID in (").append(sbCurrencyIds).append(")");
        if (diffAccountSet != null && diffAccountSet.length() > 0) {
            sbSql.append(" and account.FID not in (" + diffAccountSet + ")");
        }
        sbSql.append(" group by  balance.FCurrencyID");
        Object[] params = new Object[]{this.profitCenter.getId().toString()};
        HashMap<BOSUuid, QueryData> result = new HashMap<BOSUuid, QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                QueryData data = new QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FAmount") == null ? ZERO : rs.getBigDecimal("FAmount"));
                data.setLocalAmount(rs.getBigDecimal("FAmountLocal") == null ? ZERO : rs.getBigDecimal("FAmountLocal"));
                data.setReportingAmount(rs.getBigDecimal("FAmountRpt") == null ? ZERO : rs.getBigDecimal("FAmountRpt"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    protected static class QueryData {
        private CurrencyInfo currency = null;
        private BigDecimal originalAmount = ZERO;
        private BigDecimal LocalAmount = ZERO;
        private BigDecimal reportingAmount = ZERO;

        protected QueryData() {
        }

        public CurrencyInfo getCurrency() {
            return this.currency;
        }

        public void setCurrency(CurrencyInfo currency) {
            this.currency = currency;
        }

        public BigDecimal getOriginalAmount() {
            return this.originalAmount;
        }

        public void setOriginalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
        }

        public BigDecimal getLocalAmount() {
            return this.LocalAmount;
        }

        public void setLocalAmount(BigDecimal localAmount) {
            this.LocalAmount = localAmount;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setReportingAmount(BigDecimal reportingAmount) {
            this.reportingAmount = reportingAmount;
        }
    }
}

