/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPcaBalanceFixService {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.AbstractPcaBalanceFixService");
    static final String GENERAL_LOCAL_CURRENCY = "11111111-1111-1111-1111-111111111111DEB58FDC";
    static final String GENERAL_REPORT_CURRENCY = "22222222-2222-2222-2222-222222222222DEB58FDC";
    protected static final int ACCOUNT_BALANCE = 1;
    protected static final int ASSIST_BALANCE = 2;
    protected static final int MEASURE_BALANCE = 3;
    protected Context ctx;
    protected String accountTableID;
    protected String profitCenterID;
    protected String companyID;
    protected PeriodInfo periodfrom;
    protected PeriodInfo periodto;
    protected boolean useReport;
    protected boolean isQtyAsst;
    protected String acctIDs = null;

    public AbstractPcaBalanceFixService(Context ctx, Map param) throws BOSException, EASBizException {
        this.init(ctx, param);
    }

    private void init(Context ctx, Map param) throws BOSException, EASBizException {
        this.ctx = ctx;
        String[] accounts = (String[])param.get("selectedAV");
        if (accounts != null && accounts.length > 0) {
            StringBuffer accountIDs = new StringBuffer();
            int j = accounts.length;
            for (int i = 0; i < j; ++i) {
                accountIDs.append(",'").append(accounts[i]).append("'");
            }
            accountIDs.deleteCharAt(0);
            StringBuffer sql = new StringBuffer();
            sql.append("select b.fid from t_bd_accountview a \r\n");
            sql.append("inner join t_bd_accountview b \r\n");
            sql.append("on charindex(a.flongnumber||'!',b.flongnumber||'!')=1 and a.fcompanyid=b.fcompanyid and a.faccounttableid=b.faccounttableid \r\n");
            sql.append("where a.fid in (").append(accountIDs).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    accountIDs.append(",'").append(rs.getString(1)).append("'");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.acctIDs = accountIDs.toString();
        }
        this.accountTableID = (String)param.get("accountTableID");
        this.profitCenterID = (String)param.get("profitCenterID");
        this.companyID = (String)param.get("companyID");
        int periodfromInt = Integer.parseInt((String)param.get("periodFrom"));
        int periodtoInt = Integer.parseInt((String)param.get("periodTo"));
        this.periodfrom = PeriodUtils.getPeriodInfo((Context)ctx, (int)(periodfromInt / 100), (int)(periodfromInt % 100), (IObjectPK)new ObjectUuidPK(this.companyID));
        this.periodto = PeriodUtils.getPeriodInfo((Context)ctx, (int)(periodtoInt / 100), (int)(periodtoInt % 100), (IObjectPK)new ObjectUuidPK(this.companyID));
        HashMap hmAllParam = GlUtils.getDefaultGLParam((Context)ctx, (String)this.companyID);
        this.useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
        this.isQtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
    }

    public abstract String execute() throws EASBizException, BOSException;

    protected void updateCurPeriodBalance2(int balType) throws SQLException, BOSException, EASBizException {
        String tempTableMeasure;
        String tempTableAssist;
        block18: {
            String periodId = this.periodfrom.getId().toString();
            String filter = " and vch.Fprofitcenterid='" + this.profitCenterID + "' and vch.fperiodid='" + periodId + "' and vch.FbizStatus<>0 and vch.FbizStatus<>2  ";
            if (balType == 5) {
                filter = filter + " and vch.FbizStatus=5 ";
            }
            if (this.acctIDs != null && !"".equals(this.acctIDs)) {
                filter = filter + " and ve.FAccountID in (" + this.acctIDs + ")  \r\n";
            }
            String companyfilter = " and acct.FAccounttableId='" + this.accountTableID + "'   ";
            String tempTableAccount = null;
            tempTableAssist = null;
            tempTableMeasure = null;
            try {
                try {
                    tempTableAccount = this.createBalanceTempTable(this.ctx, 1);
                    tempTableAssist = this.createBalanceTempTable(this.ctx, 2);
                    if (this.isQtyAsst) {
                        tempTableMeasure = this.createBalanceTempTable(this.ctx, 3);
                    }
                }
                catch (Exception e) {
                    throw new BOSException("Create TempTable fail! ", (Throwable)e);
                }
                try {
                    DbUtil.execute((Context)this.ctx, (String)("insert into " + tempTableAccount + this.getAccountSql2(filter, companyfilter)));
                    this.insertGenaCurrencyAmount(this.ctx, tempTableAccount, balType, 1);
                    DbUtil.execute((Context)this.ctx, (String)("insert into " + tempTableAssist + this.getAssistSql(filter, companyfilter)));
                    this.insertGenaCurrencyAmount(this.ctx, tempTableAssist, balType, 2);
                    if (this.isQtyAsst) {
                        DbUtil.execute((Context)this.ctx, (String)("insert into " + tempTableMeasure + this.getAssistMeasureSql(filter, companyfilter)));
                        this.insertGenaCurrencyAmount(this.ctx, tempTableMeasure, balType, 3);
                    }
                }
                catch (Exception e) {
                    throw new BOSException("insert TempTable fail! ", (Throwable)e);
                }
                this.insertEmptyBalanceRecord(this.ctx, tempTableAccount, balType, this.useReport, 1);
                this.updateBalanceRecord(this.ctx, tempTableAccount, balType, 1);
                this.insertEmptyBalanceRecord(this.ctx, tempTableAssist, balType, this.useReport, 2);
                this.updateBalanceRecord(this.ctx, tempTableAssist, balType, 2);
                if (this.isQtyAsst) {
                    this.insertEmptyBalanceRecord(this.ctx, tempTableMeasure, balType, this.useReport, 3);
                    this.updateBalanceRecord(this.ctx, tempTableMeasure, balType, 3);
                }
                if (tempTableAccount == null) break block18;
            }
            catch (BOSException e) {
                try {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"316_PeriodTransFacadeControllerBean", (Locale)this.ctx.getLocale()), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (tempTableAccount != null) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableAccount);
                    }
                    if (tempTableAssist != null) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableAssist);
                    }
                    if (tempTableMeasure != null) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableMeasure);
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableAccount);
        }
        if (tempTableAssist != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableAssist);
        }
        if (tempTableMeasure != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableMeasure);
        }
    }

    private String createBalanceTempTable(Context ctx, int balanceType) throws Exception {
        String tableAlias = balanceType == 1 ? "T_Pca_ACCBALTMPTABLE" : (balanceType == 2 ? "T_Pca_ASSTBALTMPTABLE" : "T_Pca_MUBALTMPTABLE");
        StringBuffer sql = new StringBuffer();
        sql.append(" ORGUNITID         VARCHAR(44),");
        sql.append(" PROFITCENTERID         VARCHAR(44),");
        sql.append(" PERIOD          \t\tINT,");
        sql.append(" ACCOUNTID         VARCHAR(44),");
        sql.append(" CURRENCYID        VARCHAR(44),");
        if (balanceType == 2) {
            sql.append(" ASSISTGRPID       VARCHAR(44),");
        } else if (balanceType == 3) {
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            sql.append(" MEASUREUNITID     VARCHAR(44),");
        }
        sql.append(" DEBITFOR          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITFOR         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITLOCAL        NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITRPT          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITRPT         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITQTY          NUMERIC(28,10) DEFAULT 0,");
        sql.append(" CREDITQTY         NUMERIC(28,10) DEFAULT 0,");
        sql.append(" MONTHPNLFOR       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLLOCAL     NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLRPT       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLQTY       NUMERIC(28,10) DEFAULT 0");
        sql.append(" ,FLOGCOUNT INT");
        String tmpTableName = GLTempTableUtil.createDBSysTempTable((Context)ctx, (String)sql.toString());
        try {
            String indexStr = "accountid, profitcenterid,PERIOD,orgunitid";
            if (balanceType == 2) {
                indexStr = indexStr + ", assistgrpid";
            } else if (balanceType == 3) {
                indexStr = indexStr + ", assistgrpid, measureunitid";
            }
            indexStr = indexStr + ",CURRENCYID";
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, indexStr, false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update voucher balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    private String getAccountSql2(String filter, String companyFilter) {
        String sql = " select vch.FCompanyID CompanyID,vch.FProfitCenterID ProfitCenterID, p.fnumber Period, \t\t\t\t\t\t\t\t\t\t   \r\n\tpacct.FID AccountID, ve.FCurrencyID CurrencyID,\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \r\n sum(ve.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                       \r\n\t sum(ve.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                                \r\n\t sum(ve.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                        \r\n\t sum(ve.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                                 \r\n\t sum(ve.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                      \r\n\t sum(ve.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                               \r\n\t sum(ve.FStandardQuantity * ve.FEntryDC)  FDebitQtyV,                                                    \r\n\t sum(ve.FStandardQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                             \r\n\t sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.foriginalamount else 0 end) FMonthPnLForV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.flocalamount else 0 end) FMonthPnLLocalV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.freportingamount else 0 end) FMonthPnLRptV,  sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FStandardQuantity else 0 end) FMonthPnLQtyV  ,count(ve.fid) FVeCount      \r\n    from T_Pca_PcVoucher vch                                                                           \t\t\r\n inner join T_BD_PERIOD p on p.fid =  vch.FPeriodID                                                                          \t\t\r\n inner join T_PCA_PcVoucherEntry ve on vch.FID = ve.FBillID                                         \t\t\r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID                                \t\t\t\r\n inner join t_BD_AccountView pacct on pacct.Fcompanyid = acct.Fcompanyid and pacct.faccounttableid = acct.faccounttableid and charindex(pacct.FLongNumber, acct.FLongNumber) = 1 \r\n" + companyFilter + " inner join T_BD_AccountType acctType on pacct.FAccountTypeID = acctType.FID \r\n where 1 = 1 " + filter + " group by vch.FCompanyID, vch.FProfitCenterID, p.fnumber, pacct.fid, ve.FCurrencyID \r\n";
        return sql;
    }

    private String getAssistSql(String filter, String companyFilter) {
        String sql = " select vch.FCompanyID CompanyID,vch.FProfitCenterID ProfitCenterID, p.fnumber Period, \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tve.FAccountID AccountID, ve.FCurrencyID CurrencyID, vast.FAssGrpID AssistGrpID,\t\t\t\t\t\t\t\r\n sum(vast.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                     \r\n\t sum(vast.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                              \r\n\t sum(vast.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                      \r\n\t sum(vast.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                               \r\n\t sum(vast.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                    \r\n\t sum(vast.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                             \r\n\t sum(vast.FStandardQuantity * ve.FEntryDC)  FDebitQtyV,                                                  \r\n\t sum(vast.FStandardQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                           \r\n\t sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.foriginalamount else 0 end) FMonthPnLForV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.flocalamount else 0 end) FMonthPnLLocalV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.freportingamount else 0 end) FMonthPnLRptV,  sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.FStandardQuantity else 0 end) FMonthPnLQtyV  ,count(vast.fid) FVeCount                                                                               \r\n from T_Pca_PcVoucher vch                                                                                   \r\n inner join T_BD_PERIOD p on p.fid =  vch.FPeriodID                                                                          \t\t\r\n inner join T_PCA_PcVoucherEntry ve  on vch.FID = ve.FBillID                                                \r\n inner join T_PCA_PcVoucherAssistRecord vast\t  on ve.FID = vast.FEntryID\t                                \r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID                                            \r\n" + companyFilter + " inner join T_BD_AccountType acctType on acct.FAccountTypeID = acctType.FID                  \t\t\t\r\n where vast.FAssGrpID is not null                                             \t\t                    \r\n" + filter + " group by vch.FCompanyID,vch.FProfitCenterID,p.fnumber, ve.FAccountID, ve.FCurrencyID, vast.FAssGrpID\t\t\t\t\t\r\n";
        return sql;
    }

    private String getAssistMeasureSql(String filter, String companyFilter) {
        String sql = " select vch.FCompanyID CompanyID,vch.FProfitCenterID ProfitCenterID, p.fnumber Period, \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tve.FAccountID AccountID, ve.FCurrencyID CurrencyID, vast.FAssGrpID AssistGrpID,  case when vast.FMeasureUnitId is null then '00000000-0000-0000-0000-0000000000005B825C57' else vast.FMeasureUnitId end MeasureUnitid ,  \r\n sum(vast.FOriginalAmount * ve.FEntryDC) FDebitForV,                                                     \r\n\t sum(vast.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV,                                              \r\n\t sum(vast.FLocalAmount * ve.FEntryDC) FDebitLocalV,                                                      \r\n\t sum(vast.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV,                                               \r\n\t sum(vast.FReportingAmount * ve.FEntryDC) FDebitRptV,                                                    \r\n\t sum(vast.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV,                                             \r\n\t sum(vast.FQuantity * ve.FEntryDC)  FDebitQtyV,                                                  \r\n\t sum(vast.FQuantity * (1 - ve.FEntryDC))  FCreditQtyV,                                           \r\n\t sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.foriginalamount else 0 end) FMonthPnLForV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.flocalamount else 0 end) FMonthPnLLocalV, sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.freportingamount else 0 end) FMonthPnLRptV,  sum(case when acctType.FProperty = 4 and vch.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*vast.FQuantity else 0 end) FMonthPnLQtyV  ,count(vast.fid) FVeCount                                                                               \r\n from T_PCA_PcVoucher vch                                                                                   \r\n inner join T_BD_PERIOD p on p.fid =  vch.FPeriodID                                                    \t\t\r\n inner join T_PCA_PcVoucherEntry ve on vch.FID = ve.FBillID                   \t                        \t\r\n inner join T_PCA_PcVoucherAssistRecord vast on ve.FID = vast.FEntryID\t                                    \r\n inner join t_BD_AccountView acct on ve.FAccountID = acct.FID and acct.fisqty=1                          \r\n" + companyFilter + " inner join t_bd_asstaccount ac on ac.fid = acct.fcaa and ac.fisqty = 1 \t\t\t\t\t\t\t\t\t\r\n inner join T_BD_AccountType acctType on acct.FAccountTypeID = acctType.FID \t\t\t\t\t\t\t\t\r\n where vast.FAssGrpID is not null                                                                        \r\n" + filter + " group by vch.FCompanyID,vch.FProfitCenterID, p.fnumber, ve.FAccountID, ve.FCurrencyID,vast.FMeasureUnitid, vast.FAssGrpID\t\r\n";
        return sql;
    }

    private void insertEmptyBalanceRecord(Context ctx, String tempTableName, int balType, boolean useRpt, int balanceType) throws BOSException {
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, useRpt, balanceType, balType, null);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, useRpt, balanceType, balType, GENERAL_LOCAL_CURRENCY);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, useRpt, balanceType, balType, GENERAL_REPORT_CURRENCY);
    }

    private void doInsertEmptyBalanceRecord(Context ctx, String tempTableName, boolean useRpt, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTableName(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = !GENERAL_LOCAL_CURRENCY.equals(currencyId) && !GENERAL_REPORT_CURRENCY.equals(currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(balanceTableName);
        sql.append("(fprofitcenterid,forgunitid, ");
        if (isForCurrency) {
            sql.append("fcurrencyid, ");
        }
        sql.append("faccountid, fperiod");
        if (balanceType == 2) {
            sql.append(", fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", fassistgrpid ");
            sql.append(", fmeasureunitid ");
        }
        sql.append(") ");
        sql.append(" select distinct ").append("t.profitcenterid,t.orgunitid, ");
        if (isForCurrency) {
            sql.append("t.currencyid, ");
        }
        sql.append("t.accountid, t.period");
        if (balanceType == 2) {
            sql.append(", t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", t.assistgrpid ");
            sql.append(", t.measureunitid ");
        }
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where 1=1 ");
        if (isForCurrency) {
            sql.append(" and t.currencyid <> '").append(GENERAL_LOCAL_CURRENCY).append("' \n");
            sql.append(" and t.currencyid <> '").append(GENERAL_REPORT_CURRENCY).append("' \n");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("' \n");
        }
        sql.append(" and not exists ( ");
        sql.append(" select 1 from ").append(balanceTableName).append(" b ");
        sql.append(" where b.fprofitcenterid = t.profitcenterid and b.forgunitid = t.orgunitid ");
        sql.append(" and b.fperiod = t.period ");
        if (isForCurrency) {
            sql.append(" and b.fcurrencyid = t.currencyid ");
        }
        sql.append(" and b.faccountid = t.accountid ");
        if (balanceType == 2) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
            sql.append(" and b.fmeasureunitid = t.measureunitid ");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateBalanceRecord(Context ctx, String tempTableName, int balType, int balanceType) throws BOSException {
        this.doUpdateBalanceRecord(ctx, tempTableName, balanceType, balType, null);
        this.doUpdateBalanceRecord(ctx, tempTableName, balanceType, balType, GENERAL_LOCAL_CURRENCY);
        this.doUpdateBalanceRecord(ctx, tempTableName, balanceType, balType, GENERAL_REPORT_CURRENCY);
    }

    private void doUpdateBalanceRecord(Context ctx, String tempTableName, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTableName(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if (GENERAL_LOCAL_CURRENCY.equals(currencyId)) {
            isLocaCurrency = true;
        } else if (GENERAL_REPORT_CURRENCY.equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update /*+ NOT_GEN_EXISTS*/ ").append(balanceTableName).append(" set (");
        if (isForCurrency) {
            sql.append(" FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor,");
            sql.append(" FMonthPnLFor, FYearPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal,");
            sql.append(" FMonthPnLLocal, FYearPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt,");
            sql.append(" FMonthPnLRpt, FYearPnLRpt, ");
        }
        sql.append(" FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty,");
        sql.append(" FMonthPnLQty, FYearPnLQty ");
        sql.append(" ,FDetailCount ");
        sql.append(") = (");
        sql.append(" select ");
        if (isForCurrency) {
            sql.append(" FDebitFor + t.DebitFor, FYearDebitFor + t.DebitFor,FCreditFor + t.CreditFor, FYearCreditFor + t.CreditFor,FEndBalanceFor + t.DebitFor - t.CreditFor,");
            sql.append(" FMonthPnLFor + t.MonthPnLFor, FYearPnLFor + t.MonthPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal + t.DebitLocal,  FYearDebitLocal + t.DebitLocal, FCreditLocal + t.CreditLocal, FYearCreditLocal + t.CreditLocal, FEndBalanceLocal + t.DebitLocal - t.CreditLocal, ");
            sql.append(" FMonthPnLLocal + t.MonthPnLLocal, FYearPnLLocal + t.MonthPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt + t.DebitRpt, FYearDebitRpt + t.DebitRpt, FCreditRpt + t.CreditRpt, FYearCreditRpt + t.CreditRpt, FEndBalanceRpt + t.DebitRpt - t.CreditRpt, ");
            sql.append(" FMonthPnLRpt + t.MonthPnLRpt, FYearPnLRpt + t.MonthPnLRpt,");
        }
        sql.append(" FDebitQty + t.DebitQty, FYearDebitQty + t.DebitQty, FCreditQty + t.CreditQty, FYearCreditQty + t.CreditQty, FEndQty + t.DebitQty - t.CreditQty, ");
        sql.append(" isNull(FMonthPnLQty,0) + t.MonthPnLQty, isNull(FYearPnLQty,0) + t.MonthPnLQty ");
        sql.append(" ,case when isnull(FDetailCount,0)+ t.FLogCount < 0 then 0 else isnull(FDetailCount,0)+ t.FLogCount end ");
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.profitcenterid = fprofitcenterid and t.orgunitid = forgunitid ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" ) ");
        sql.append(" where exists ");
        sql.append(" (select 1 from ").append(tempTableName).append(" t ");
        sql.append(" where t.profitcenterid = fprofitcenterid and t.orgunitid = forgunitid ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertGenaCurrencyAmount(Context ctx, String tmpTableName, int balType, int balanceType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.orgunitid,t.profitcenterid, t.period, t.accountid, '").append(GENERAL_LOCAL_CURRENCY).append("' currencyid, ");
        if (balanceType == 2) {
            sql.append("t.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append("t.assistgrpid, t.measureunitid, ");
        }
        sql.append(" sum(t.DebitLocal) DebitFor, sum(t.CreditLocal) CreditFor, ");
        sql.append(" sum(t.DebitLocal) DebitLocal, sum(t.CreditLocal) CreditLocal, ");
        sql.append(" sum(t.DebitLocal) DebitRpt, sum(t.CreditLocal) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLLocal) MonthPnLFor, sum(t.MonthPnLLocal) MonthPnLLocal, sum(t.MonthPnLLocal) MonthPnLRpt, ");
        sql.append(" sum(t.MonthPnLQty) MonthPnLQty, ");
        sql.append(" sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by t.orgunitid,t.profitcenterid, t.period, t.accountid");
        if (balanceType == 2) {
            sql.append(",t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(",t.assistgrpid, t.measureunitid ");
        }
        sql.append(" union all ");
        sql.append(" select t.orgunitid,t.profitcenterid, t.period, t.accountid, '").append(GENERAL_REPORT_CURRENCY).append("' currencyid, ");
        if (balanceType == 2) {
            sql.append("t.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append("t.assistgrpid, t.measureunitid, ");
        }
        sql.append(" sum(t.DebitRpt) DebitFor, sum(t.CreditRpt) CreditFor,");
        sql.append(" sum(t.DebitRpt) DebitLocal, sum(t.CreditRpt) CreditLocal, ");
        sql.append(" sum(t.DebitRpt) DebitRpt, sum(t.CreditRpt) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLRpt) MonthPnLFor, sum(t.MonthPnLRpt) MonthPnLLocal, sum(t.MonthPnLRpt) MonthPnLRpt, ");
        sql.append(" sum(t.MonthPnLQty) MonthPnLQty, ");
        sql.append(" sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by t.orgunitid,t.profitcenterid, t.period, t.accountid");
        if (balanceType == 2) {
            sql.append(",t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(",t.assistgrpid, t.measureunitid ");
        }
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
    }

    protected void clearNextPeriod(PreparedStatement stmt, Connection con, int periodNumber, int baltype) throws SQLException {
        this.doClearNextPeriod(stmt, con, periodNumber, 1, baltype, null);
        this.doClearNextPeriod(stmt, con, periodNumber, 1, baltype, GENERAL_LOCAL_CURRENCY);
        this.doClearNextPeriod(stmt, con, periodNumber, 1, baltype, GENERAL_REPORT_CURRENCY);
        this.doClearNextPeriod(stmt, con, periodNumber, 2, baltype, null);
        this.doClearNextPeriod(stmt, con, periodNumber, 2, baltype, GENERAL_LOCAL_CURRENCY);
        this.doClearNextPeriod(stmt, con, periodNumber, 2, baltype, GENERAL_REPORT_CURRENCY);
        this.doClearNextPeriod(stmt, con, periodNumber, 3, baltype, null);
        this.doClearNextPeriod(stmt, con, periodNumber, 3, baltype, GENERAL_LOCAL_CURRENCY);
        this.doClearNextPeriod(stmt, con, periodNumber, 3, baltype, GENERAL_REPORT_CURRENCY);
    }

    private void doClearNextPeriod(PreparedStatement stmt, Connection con, int nextPeriodNumber, int balanceType, int baltype, String currencyId) throws SQLException {
        String tablename = this.getBalanceTableName(balanceType, baltype, currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append("Delete from ").append(tablename).append(" \r\n");
        sql.append("    Where  FPeriod = ?                                        \r\n");
        sql.append("    and FProfitCenterID = ?                                          \r\n");
        sql.append("and FAccountid in (select fid from t_bd_accountview where FCompanyid=? and FAccounttableId=? )                                        \r\n");
        if (this.acctIDs != null && !"".equals(this.acctIDs)) {
            sql.append(" and FAccountid in (").append(this.acctIDs).append(")       \r\n");
        }
        stmt = con.prepareStatement(sql.toString());
        int index = 1;
        stmt.setInt(index++, nextPeriodNumber);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.profitCenterID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.companyID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.accountTableID);
        stmt.executeUpdate();
        stmt.close();
    }

    protected void clearCurPeriodBalance(Connection conn, int periodNumber, int baltype) throws BOSException {
        Statement stmt = null;
        try {
            this.doClearPeriodBalance(conn, periodNumber, 1, baltype, null);
            this.doClearPeriodBalance(conn, periodNumber, 1, baltype, GENERAL_LOCAL_CURRENCY);
            this.doClearPeriodBalance(conn, periodNumber, 1, baltype, GENERAL_REPORT_CURRENCY);
            this.doClearPeriodBalance(conn, periodNumber, 2, baltype, null);
            this.doClearPeriodBalance(conn, periodNumber, 2, baltype, GENERAL_LOCAL_CURRENCY);
            this.doClearPeriodBalance(conn, periodNumber, 2, baltype, GENERAL_REPORT_CURRENCY);
            this.doClearPeriodBalance(conn, periodNumber, 3, baltype, null);
            this.doClearPeriodBalance(conn, periodNumber, 3, baltype, GENERAL_LOCAL_CURRENCY);
            this.doClearPeriodBalance(conn, periodNumber, 3, baltype, GENERAL_REPORT_CURRENCY);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(null, stmt, null);
        }
    }

    private void doClearPeriodBalance(Connection conn, int periodNumber, int balanceTyep, int baltype, String currencyid) throws SQLException {
        PreparedStatement stmt = null;
        stmt = this.getStmtClearBalUpdate(conn, this.acctIDs, balanceTyep, baltype, currencyid);
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.profitCenterID);
        stmt.setInt(index++, periodNumber);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.companyID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.accountTableID);
        stmt.executeUpdate();
        stmt.close();
    }

    private PreparedStatement getStmtClearBalUpdate(Connection conn, String acctIDs, int balanceType, int baltype, String currencyId) throws SQLException {
        String tablename = this.getBalanceTableName(balanceType, baltype, currencyId);
        StringBuffer sql = new StringBuffer(" update ");
        sql.append(tablename).append(" set ");
        if (GENERAL_LOCAL_CURRENCY.equals(currencyId) || currencyId == null) {
            sql.append("FDebitLocal = 0,\r\n");
            sql.append("FYearDebitLocal = FYearDebitLocal-FDebitLocal,\r\n");
            sql.append("FCreditLocal =0,\r\n");
            sql.append("FYearCreditLocal = FYearCreditLocal-FCreditLocal,\r\n");
            sql.append("FEndBalanceLocal = FBeginBalanceLocal, \r\n");
            sql.append("FMonthPnLLocal = 0, \r\n");
            sql.append("FYearPnLLocal = FYearPnLLocal -FMonthPnLLocal, \r\n");
        }
        if (GENERAL_REPORT_CURRENCY.equals(currencyId) || currencyId == null) {
            sql.append("FDebitRpt = 0,\r\n");
            sql.append("FYearDebitRpt = FYearDebitRpt -FDebitRpt,\r\n");
            sql.append("FCreditRpt = 0,\r\n");
            sql.append("FYearCreditRpt = FYearCreditRpt-FCreditRpt,\r\n");
            sql.append("FEndBalanceRpt = FBeginBalanceRpt, \r\n");
            sql.append("FMonthPnLRpt = 0, \r\n");
            sql.append("FYearPnLRpt = FYearPnLRpt -FMonthPnLRpt, \r\n");
        }
        if (currencyId == null) {
            sql.append("FDebitFor = 0,\r\n");
            sql.append("FYearDebitFor = FYearDebitFor -FDebitFor,\r\n");
            sql.append("FCreditFor = 0,\r\n");
            sql.append("FYearCreditFor = FYearCreditFor - FCreditFor,\r\n");
            sql.append("FEndBalanceFor = FBeginBalanceFor, \r\n");
            sql.append("FMonthPnLFor = 0, \r\n");
            sql.append("FYearPnLFor = FYearPnLFor -FMonthPnLFor, \r\n");
        }
        sql.append("FDebitQty = 0, \r\n");
        sql.append("FYearDebitQty = FYearDebitQty -FDebitQty, \r\n");
        sql.append("FCreditQty =0, \r\n");
        sql.append("FYearCreditQty = FYearCreditQty - FCreditQty, \r\n");
        sql.append("FEndQty = FBeginQty, \r\n");
        sql.append("FMonthPnLQty = 0,\t\t\t\t\t\t\t\r\n");
        sql.append("FYearPnLQty = isNull(FYearPnLQty,0) - isNull(FMonthPnLQty,0) ,\t\r\n");
        sql.append("FDetailCount = 0  ");
        sql.append("where FProfitCenterID = ? \r\n");
        sql.append("and FPeriod = ? \r\n");
        sql.append("and FAccountid in (select fid from t_bd_accountview where fcompanyid=? and FAccounttableId=? ) \r\n");
        if (acctIDs != null && !"".equals(acctIDs)) {
            sql.append(" and FAccountid in (").append(acctIDs).append(") ");
        }
        return conn.prepareStatement(sql.toString());
    }

    protected String getBalanceTableName(int balanceType, int baltype, String currencyId) {
        String balanceTableName = null;
        if (balanceType == 1) {
            balanceTableName = PCABalanceUtils.getAccountBalanceTable(baltype, currencyId);
        } else if (balanceType == 2) {
            balanceTableName = PCABalanceUtils.getAssistBalanceTable(baltype, currencyId);
        } else if (balanceType == 3) {
            balanceTableName = PCABalanceUtils.getAssistMeasureBalanceTable(baltype, currencyId);
        }
        return balanceTableName;
    }

    protected String getBalanceTable(int tableType, int balType, String currencyId) {
        return PCABalanceUtils.getBalanceTable(tableType, balType, currencyId);
    }
}

