/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.ma.pca.AmortizeLogCollection;
import com.kingdee.eas.ma.pca.AmortizeLogFactory;
import com.kingdee.eas.ma.pca.AmortizeLogInfo;
import com.kingdee.eas.ma.pca.AmortizeSchemeException;
import com.kingdee.eas.ma.pca.AmortizeSchemeFactory;
import com.kingdee.eas.ma.pca.AmortizeSchemeInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeLogControllerBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class AmortizeLogControllerBean
extends AbstractAmortizeLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.AmortizeLogControllerBean");

    @Override
    protected void _deleteAmortizeVoucher(Context ctx, String amortizeSchemeID, Set periodNumberSet) throws BOSException, EASBizException {
        String fromAmortizeLogDelete = "fromAmortizeLogDelete";
        ctx.put((Object)fromAmortizeLogDelete, (Object)fromAmortizeLogDelete);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("amortizeScheme.id", (Object)amortizeSchemeID));
        filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)periodNumberSet, CompareType.INCLUDE));
        AmortizeLogCollection logColl = AmortizeLogFactory.getRemoteInstance().getAmortizeLogCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        HashSet<String> hasPermSet = new HashSet<String>();
        Iterator it = logColl.iterator();
        while (it.hasNext()) {
            VoucherInfo voucherInfo;
            SelectorItemCollection selector;
            AmortizeLogInfo logInfo = (AmortizeLogInfo)it.next();
            String cpid = logInfo.getCompany().getId().toString();
            if (!hasPermSet.contains(cpid)) {
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(cpid), "pca_amortizeLog_delVch");
                hasPermSet.add(cpid);
            }
            if (logInfo.getVoucher() == null && logInfo.getPcVoucher() == null) continue;
            SelectorItemCollection schemeSelector = new SelectorItemCollection();
            schemeSelector.add("number");
            schemeSelector.add("company.name");
            AmortizeSchemeInfo schemeInfo = AmortizeSchemeFactory.getLocalInstance(ctx).getAmortizeSchemeInfo((IObjectPK)new ObjectUuidPK(amortizeSchemeID), schemeSelector);
            String voucherOrgName = "";
            String voucherDisplayNumber = "";
            if (logInfo.getVoucher() != null) {
                selector = new SelectorItemCollection();
                selector.add("number");
                selector.add("company.name");
                selector.add("voucherType.name");
                voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(logInfo.getVoucher().getId()), selector);
                voucherOrgName = voucherInfo.getCompany().getName();
                voucherDisplayNumber = "[" + voucherInfo.getVoucherType().getName() + "]" + voucherInfo.getNumber();
            } else if (logInfo.getPcVoucher() != null) {
                selector = new SelectorItemCollection();
                selector.add("number");
                selector.add("profitCenter.name");
                selector.add("voucherType.name");
                voucherInfo = (PcVoucherInfo)PcVoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(logInfo.getPcVoucher().getId()), selector);
                voucherOrgName = voucherInfo.getProfitCenter().getName();
                voucherDisplayNumber = "[" + voucherInfo.getVoucherType().getName() + "]" + voucherInfo.getNumber();
            }
            try {
                if (logInfo.getVoucher() != null) {
                    VoucherFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(logInfo.getVoucher().getId()));
                    continue;
                }
                if (logInfo.getPcVoucher() == null) continue;
                PcVoucherFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(logInfo.getPcVoucher().getId()));
            }
            catch (Exception e) {
                throw new AmortizeSchemeException(AmortizeSchemeException.DELETEVOUCHERERROR, new Object[]{schemeInfo.getCompany().getName(), schemeInfo.getNumber(), voucherOrgName, voucherDisplayNumber, e.getMessage()});
            }
        }
        ctx.put((Object)fromAmortizeLogDelete, null);
    }
}

