/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.AmortizeOrgTypeEnum;
import com.kingdee.eas.ma.pca.AmortizePattern;
import com.kingdee.eas.ma.pca.AmortizeRuleAmountType;
import com.kingdee.eas.ma.pca.AmortizeRuleAssActTypeEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleFactory;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryInfo;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeRuleControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AmortizeRuleControllerBean
extends AbstractAmortizeRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.AmortizeRuleControllerBean");
    private static final String RES_AMORTIZERULERESOURCE = "com.kingdee.eas.ma.pca.PcaAmortizeRuleResource";

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)pk.toString())) {
            return;
        }
        this.checkFuncPermission(ctx, pk, "pca_amortizeRule_enable");
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PCA_AmortizeRule set FEnable = 1 where FID in ('");
        sql.append(pk);
        sql.append("')");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)pk.toString())) {
            return;
        }
        this.checkFuncPermission(ctx, pk, "pca_amortizeRule_disable");
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PCA_AmortizeRule set FEnable = 0 where FID in ('");
        sql.append(pk);
        sql.append("') ");
        sql.append(" and NOT EXISTS (SELECT sch.FID FROM T_PCA_AmortizeScheme sch ");
        sql.append(" inner join T_PCA_AmortizeSchemeEntry entry on entry.FBILLID = sch.FID ");
        sql.append(" where sch.FENABLED = 1 and entry.FAMORTIZERULEID = T_PCA_AmortizeRule.FID) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AmortizeRuleInfo amortizeRuleInfo = (AmortizeRuleInfo)model;
        UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CompanyOrgUnitInfo companyInfo = amortizeRuleInfo.getCompany();
        ObjectUuidPK userPk = new ObjectUuidPK(aUserInfo.getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(companyInfo.getId());
        if (amortizeRuleInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(amortizeRuleInfo.getId()))) {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "pca_amortizeRule_edit");
        } else {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "pca_amortizeRule_addnew");
        }
        this.checkBeforeSave(ctx, amortizeRuleInfo);
        this.checkDestEntriesRatio(ctx, amortizeRuleInfo);
        return super._save(ctx, (IObjectValue)amortizeRuleInfo);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkFuncPermission(ctx, pk, "pca_amortizeRule_delete");
        super._delete(ctx, pk);
    }

    private void checkFuncPermission(Context ctx, IObjectPK pk, String permissionName) throws EASBizException, BOSException {
        UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        AmortizeRuleInfo amortizeRuleInfo = AmortizeRuleFactory.getLocalInstance(ctx).getAmortizeRuleInfo(pk, selector);
        CompanyOrgUnitInfo companyInfo = amortizeRuleInfo.getCompany();
        ObjectUuidPK userPk = new ObjectUuidPK(aUserInfo.getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(companyInfo.getId());
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionName);
    }

    private void checkBeforeSave(Context ctx, AmortizeRuleInfo amortizeRuleInfo) throws EASBizException, BOSException {
        String msg;
        CompanyOrgUnitInfo companyInfo = amortizeRuleInfo.getCompany();
        if (companyInfo == null || companyInfo.getId() == null) {
            String msg2 = this.getNotNullErrorMsg(ctx, "company");
            throw new EASBizException(new NumericExceptionSubItem("1", msg2));
        }
        String number = amortizeRuleInfo.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            String msg3 = this.getNotNullErrorMsg(ctx, "number");
            throw new EASBizException(new NumericExceptionSubItem("1", msg3));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)amortizeRuleInfo.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)amortizeRuleInfo.getNumber()));
        if (amortizeRuleInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)amortizeRuleInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"existRule", (Locale)ctx.getOriginLocale())));
        }
        String name = amortizeRuleInfo.getName();
        if (StringUtils.isEmpty((String)name)) {
            String msg4 = this.getNotNullErrorMsg(ctx, "name");
            throw new EASBizException(new NumericExceptionSubItem("1", msg4));
        }
        AmortizeRuleSrcEntryCollection srcEntries = amortizeRuleInfo.getSrcEntries();
        if (srcEntries.size() == 0) {
            String msg5 = this.getErrorMsg(ctx, "srcEntries", "moreThanOneEntry");
            throw new EASBizException(new NumericExceptionSubItem("1", msg5));
        }
        AmortizeOrgTypeEnum orgType = amortizeRuleInfo.getAmortizeOrgType();
        Iterator it = srcEntries.iterator();
        int i = 1;
        while (it.hasNext()) {
            AccountViewInfo account;
            String msg6;
            AccountViewInfo accountViewInfo;
            String msg7;
            AmortizeRuleSrcEntryInfo entryInfo = (AmortizeRuleSrcEntryInfo)it.next();
            if (AmortizeOrgTypeEnum.ProfitCenterToProfitCenter == orgType) {
                ProfitCenterOrgUnitInfo profitCenterInfo = entryInfo.getProfitCenter();
                if (profitCenterInfo == null || profitCenterInfo.getId() == null) {
                    msg7 = this.getEntryErrorMsg(ctx, i, "srcEntries", "profitCenter");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg7));
                }
            } else {
                CompanyOrgUnitInfo company = entryInfo.getCompany();
                if (company == null || company.getId() == null) {
                    msg7 = this.getEntryErrorMsg(ctx, i, "srcEntries", "companyOrgUnit");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg7));
                }
            }
            if ((accountViewInfo = entryInfo.getAccount()) == null || accountViewInfo.getId() == null) {
                msg7 = this.getEntryErrorMsg(ctx, i, "srcEntries", "account");
                throw new EASBizException(new NumericExceptionSubItem("1", msg7));
            }
            CurrencyInfo currencyInfo = entryInfo.getCurrency();
            if (currencyInfo == null || currencyInfo.getId() == null) {
                String msg8 = this.getEntryErrorMsg(ctx, i, "srcEntries", "currency");
                throw new EASBizException(new NumericExceptionSubItem("1", msg8));
            }
            AmortizeRuleAmountType amountType = entryInfo.getAccountAmountType();
            if (AmortizeRuleAmountType.Ratio == amountType) {
                if (entryInfo.getRatio() == null || entryInfo.getRatio().compareTo(new BigDecimal("0.00")) <= 0) {
                    msg6 = this.getEntryErrorMsg(ctx, i, "srcEntries", "ratio");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg6));
                }
            } else if (AmortizeRuleAmountType.Amount == amountType && (entryInfo.getAmount() == null || entryInfo.getAmount().compareTo(new BigDecimal("0.00")) == 0)) {
                msg6 = this.getEntryErrorMsg(ctx, i, "srcEntries", "amount");
                throw new EASBizException(new NumericExceptionSubItem("1", msg6));
            }
            if ((account = entryInfo.getCussentAccount()) == null || account.getId() == null) {
                String msg9 = this.getEntryErrorMsg(ctx, i, "srcEntries", "cussentAccount");
                throw new EASBizException(new NumericExceptionSubItem("1", msg9));
            }
            CurrencyInfo currency = entryInfo.getCussentCurrency();
            if (currency == null || currency.getId() == null) {
                String msg10 = this.getEntryErrorMsg(ctx, i, "srcEntries", "cussentCurrency");
                throw new EASBizException(new NumericExceptionSubItem("1", msg10));
            }
            VoucherTypeInfo voucherType = entryInfo.getVoucherType();
            if (voucherType == null || voucherType.getId() == null) {
                String msg11 = this.getEntryErrorMsg(ctx, i, "srcEntries", "voucherType");
                throw new EASBizException(new NumericExceptionSubItem("1", msg11));
            }
            AmortizeRuleAmountType assAmountType = entryInfo.getAssAmountType();
            if (entryInfo.getAsstMode() == AmortizeRuleAssActTypeEnum.Customize && accountViewInfo.getCAA() != null) {
                AmortizeRuleSrcAssRecCollection assRecColl = entryInfo.getAssRec();
                if (assRecColl.size() == 0) {
                    msg = this.getAssRecErrorMsg(ctx, i, "srcEntries");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg));
                }
                Iterator itor = assRecColl.iterator();
                int j = 1;
                while (itor.hasNext()) {
                    AmortizeRuleSrcAssRecInfo assRecInfo = (AmortizeRuleSrcAssRecInfo)itor.next();
                    if (assRecInfo.getAssGrp() == null) {
                        String msg12 = this.getAssRecByRowErrorMsg(ctx, i, j, "srcEntries");
                        throw new EASBizException(new NumericExceptionSubItem("1", msg12));
                    }
                    if (AmortizeRuleAmountType.Ratio == assAmountType) {
                        if (assRecInfo.getRatio() == null || assRecInfo.getRatio().compareTo(new BigDecimal("0.00")) <= 0) {
                            String msg13 = this.getAssRecByRowErrorMsg(ctx, i, j, "srcEntries", "ratio");
                            throw new EASBizException(new NumericExceptionSubItem("1", msg13));
                        }
                    } else if (AmortizeRuleAmountType.Amount == assAmountType && (assRecInfo.getAmount() == null || assRecInfo.getAmount().compareTo(new BigDecimal("0.00")) == 0)) {
                        String msg14 = this.getAssRecByRowErrorMsg(ctx, i, j, "srcEntries", "amount");
                        throw new EASBizException(new NumericExceptionSubItem("1", msg14));
                    }
                    ++j;
                }
            }
            ++i;
        }
        AmortizeRuleDestEntryCollection destEntries = amortizeRuleInfo.getDestEntries();
        if (destEntries.size() == 0) {
            String msg15 = this.getErrorMsg(ctx, "destEntries", "moreThanOneEntry");
            throw new EASBizException(new NumericExceptionSubItem("1", msg15));
        }
        AmortizePattern pattern = amortizeRuleInfo.getAmortizePattern();
        Iterator destItor = destEntries.iterator();
        int ii = 0;
        HashMap<String, Integer> maxRowNumMap = new HashMap<String, Integer>();
        while (destItor.hasNext()) {
            String msg16;
            String msg17;
            Integer maxRow;
            int jj = 1;
            AmortizeRuleDestEntryInfo entryInfo = (AmortizeRuleDestEntryInfo)destItor.next();
            String orgNumer = null;
            if (AmortizeOrgTypeEnum.CompanyToCompany == orgType) {
                CompanyOrgUnitInfo company = entryInfo.getCompany();
                if (company == null || company.getId() == null) {
                    msg = this.getEntryErrorMsg(ctx, ii + 1, "destEntries", "companyOrgUnit");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg));
                }
                if (!maxRowNumMap.containsKey(company.getId().toString())) {
                    ++ii;
                    maxRowNumMap.put(company.getId().toString(), 1);
                    jj = 1;
                } else {
                    maxRow = maxRowNumMap.get(company.getId().toString()) == null ? Integer.valueOf(0) : (Integer)maxRowNumMap.get(company.getId().toString());
                    maxRowNumMap.put(company.getId().toString(), maxRow + 1);
                    jj = maxRow + 1;
                }
                orgNumer = company.getNumber();
            } else {
                ProfitCenterOrgUnitInfo profitCenterInfo = entryInfo.getProfitCenter();
                if (profitCenterInfo == null || profitCenterInfo.getId() == null) {
                    msg = this.getEntryErrorMsg(ctx, ii + 1, "destEntries", "profitCenter");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg));
                }
                if (!maxRowNumMap.containsKey(profitCenterInfo.getId().toString())) {
                    ++ii;
                    maxRowNumMap.put(profitCenterInfo.getId().toString(), 1);
                    jj = 1;
                } else {
                    maxRow = maxRowNumMap.get(profitCenterInfo.getId().toString()) == null ? Integer.valueOf(0) : (Integer)maxRowNumMap.get(profitCenterInfo.getId().toString());
                    maxRowNumMap.put(profitCenterInfo.getId().toString(), maxRow + 1);
                    jj = maxRow + 1;
                }
                orgNumer = profitCenterInfo.getNumber();
            }
            AccountViewInfo account = entryInfo.getCussentAccount();
            if (account == null || account.getId() == null) {
                msg = this.getEntryErrorMsg(ctx, ii, "destEntries", "cussentAccount");
                throw new EASBizException(new NumericExceptionSubItem("1", msg));
            }
            CurrencyInfo currency = entryInfo.getCussentCurrency();
            if (currency == null || currency.getId() == null) {
                String msg18 = this.getEntryErrorMsg(ctx, ii, "destEntries", "cussentCurrency");
                throw new EASBizException(new NumericExceptionSubItem("1", msg18));
            }
            VoucherTypeInfo voucherType = entryInfo.getVoucherType();
            if (voucherType == null || voucherType.getId() == null) {
                msg17 = this.getEntryErrorMsg(ctx, ii, "destEntries", "voucherType");
                throw new EASBizException(new NumericExceptionSubItem("1", msg17));
            }
            if (AmortizePattern.Ratio == pattern && (entryInfo.getOrgRatio() == null || entryInfo.getOrgRatio().compareTo(new BigDecimal("0.00")) <= 0)) {
                msg17 = this.getEntryErrorMsg(ctx, ii, "destEntries", "ratio");
                throw new EASBizException(new NumericExceptionSubItem("1", msg17));
            }
            AccountViewInfo accountView = entryInfo.getAccount();
            if (accountView == null || accountView.getId() == null) {
                String msg19 = this.getDestEntryErrorMsg(ctx, jj, orgType, orgNumer, "account");
                throw new EASBizException(new NumericExceptionSubItem("1", msg19));
            }
            CurrencyInfo currencyInfo = entryInfo.getCurrency();
            if (currencyInfo == null || currencyInfo.getId() == null) {
                msg16 = this.getDestEntryErrorMsg(ctx, jj, orgType, orgNumer, "currency");
                throw new EASBizException(new NumericExceptionSubItem("1", msg16));
            }
            if (entryInfo.getAccountRatio() == null || entryInfo.getAccountRatio().compareTo(new BigDecimal("0.00")) <= 0) {
                msg16 = this.getDestEntryErrorMsg(ctx, jj, orgType, orgNumer, "ratio");
                throw new EASBizException(new NumericExceptionSubItem("1", msg16));
            }
            if (entryInfo.getAssActMode() != AmortizeRuleAssActTypeEnum.Customize || accountView.getCAA() == null) continue;
            AmortizeRuleDestAssRecCollection assRecColl = entryInfo.getAssRec();
            if (assRecColl.size() == 0) {
                String msg20 = this.getDestEntryErrorMsg(ctx, jj, orgType, orgNumer, "CAA");
                throw new EASBizException(new NumericExceptionSubItem("1", msg20));
            }
            Iterator itor = assRecColl.iterator();
            int j = 1;
            while (itor.hasNext()) {
                AmortizeRuleDestAssRecInfo assRecInfo = (AmortizeRuleDestAssRecInfo)itor.next();
                if (assRecInfo.getAssGrp() == null) {
                    String msg21 = this.getDestEntrybyRowErrorMsg(ctx, jj, j, orgType, orgNumer, "");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg21));
                }
                if (assRecInfo.getRatio() == null || assRecInfo.getRatio().compareTo(new BigDecimal("0.00")) <= 0) {
                    String msg22 = this.getDestEntrybyRowErrorMsg(ctx, jj, j, orgType, orgNumer, "ratio");
                    throw new EASBizException(new NumericExceptionSubItem("1", msg22));
                }
                ++j;
            }
        }
    }

    private String getDestEntrybyRowErrorMsg(Context ctx, int jj, int j, AmortizeOrgTypeEnum orgType, String orgNumer, String name) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"destEntries", (Locale)ctx.getOriginLocale()));
        if (AmortizeOrgTypeEnum.CompanyToCompany == orgType) {
            msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"companyOrgUnit", (Locale)ctx.getOriginLocale()));
        } else {
            msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"profitCenter", (Locale)ctx.getOriginLocale()));
        }
        msg.append(orgNumer);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"mapping", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(jj);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(j);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"CAA", (Locale)ctx.getOriginLocale()));
        if (!StringUtils.isEmpty((String)name)) {
            msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        }
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getDestEntryErrorMsg(Context ctx, int jj, AmortizeOrgTypeEnum orgType, String orgNumer, String name) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"destEntries", (Locale)ctx.getOriginLocale()));
        if (AmortizeOrgTypeEnum.CompanyToCompany == orgType) {
            msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"companyOrgUnit", (Locale)ctx.getOriginLocale()));
        } else {
            msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"profitCenter", (Locale)ctx.getOriginLocale()));
        }
        msg.append(orgNumer);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"mapping", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(jj);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getAssRecByRowErrorMsg(Context ctx, int i, int j, String entry, String name) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)entry, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(i);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"mapping", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(j);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"CAA", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getAssRecByRowErrorMsg(Context ctx, int i, int j, String entry) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)entry, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(i);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"mapping", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(j);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"CAA", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getAssRecErrorMsg(Context ctx, int i, String entry) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)entry, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(i);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"mapping", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"CAA", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getEntryErrorMsg(Context ctx, int i, String entry, String name) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)entry, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"no", (Locale)ctx.getOriginLocale()));
        msg.append(i);
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"row", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"entry", (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getNotNullErrorMsg(Context ctx, String name) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"isNotNull", (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private String getErrorMsg(Context ctx, String name, String operate) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)name, (Locale)ctx.getOriginLocale()));
        msg.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)operate, (Locale)ctx.getOriginLocale()));
        return msg.toString();
    }

    private void checkSrcEntriesRatioAndAmount(Context ctx, AmortizeRuleInfo amortizeRuleInfo) throws EASBizException, BOSException {
        AmortizeOrgTypeEnum orgType = amortizeRuleInfo.getAmortizeOrgType();
        AmortizeRuleSrcEntryCollection entryColl = amortizeRuleInfo.getSrcEntries();
        Iterator itor = entryColl.iterator();
        while (itor.hasNext()) {
            String orgName;
            AmortizeRuleSrcEntryInfo entryInfo = (AmortizeRuleSrcEntryInfo)itor.next();
            BigDecimal result = new BigDecimal("0.00");
            AmortizeRuleAmountType assAmountType = entryInfo.getAssAmountType();
            AmortizeRuleSrcAssRecCollection assRecColl = entryInfo.getAssRec();
            if (assRecColl.size() == 0) continue;
            Iterator it = assRecColl.iterator();
            while (it.hasNext()) {
                AmortizeRuleSrcAssRecInfo assRecInfo = (AmortizeRuleSrcAssRecInfo)it.next();
                if (assAmountType != null && assAmountType == AmortizeRuleAmountType.Amount) {
                    result = result.add(assRecInfo.getAmount());
                    continue;
                }
                result = result.add(assRecInfo.getRatio());
            }
            if (assAmountType != null && assAmountType == AmortizeRuleAmountType.Amount) {
                if (result.compareTo(entryInfo.getAmount()) == 0) continue;
                orgName = null;
                if (orgType == AmortizeOrgTypeEnum.CompanyToCompany || orgType == AmortizeOrgTypeEnum.CompanyToProfitCenter) {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select name where id = '" + entryInfo.getCompany().getId() + "'");
                    orgName = company.getName();
                } else {
                    ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getProfitCenter().getId()));
                    orgName = profitCenter.getName();
                }
                AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(entryInfo.getAccount().getId()));
                StringBuffer sb = new StringBuffer();
                sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"srcEntries", (Locale)ctx.getOriginLocale()));
                sb.append(orgName).append(account.getName());
                sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getLocale()));
                sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"accountHGAmountSumError", (Locale)ctx.getLocale()));
                throw new EASBizException(new NumericExceptionSubItem("1", sb.toString()));
            }
            if (result.compareTo(new BigDecimal("100.00")) == 0) continue;
            orgName = null;
            if (orgType == AmortizeOrgTypeEnum.CompanyToCompany || orgType == AmortizeOrgTypeEnum.CompanyToProfitCenter) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select name where id = '" + entryInfo.getCompany().getId() + "'");
                orgName = company.getName();
            } else {
                ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getProfitCenter().getId()));
                orgName = profitCenter.getName();
            }
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(entryInfo.getAccount().getId()));
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"srcEntries", (Locale)ctx.getOriginLocale()));
            sb.append(orgName).append(account.getName());
            sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getLocale()));
            sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"accountHGRatioSumError", (Locale)ctx.getLocale()));
            throw new EASBizException(new NumericExceptionSubItem("1", sb.toString()));
        }
    }

    private void checkDestEntriesRatio(Context ctx, AmortizeRuleInfo amortizeRuleInfo) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> orgMap = new HashMap<String, BigDecimal>();
        HashMap<String, Map<String, BigDecimal>> accountMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Map<String, Map<String, Map<String, BigDecimal>>>> asstMap = new HashMap<String, Map<String, Map<String, Map<String, BigDecimal>>>>();
        AmortizePattern amortizePattern = amortizeRuleInfo.getAmortizePattern();
        AmortizeOrgTypeEnum orgType = amortizeRuleInfo.getAmortizeOrgType();
        AmortizeRuleDestEntryCollection entryColl = amortizeRuleInfo.getDestEntries();
        Iterator it = entryColl.iterator();
        while (it.hasNext()) {
            AmortizeRuleDestAssRecCollection assRecColl;
            AmortizeRuleDestEntryInfo entry = (AmortizeRuleDestEntryInfo)it.next();
            String orgMapKey = null;
            orgMapKey = orgType == AmortizeOrgTypeEnum.CompanyToCompany ? entry.getCompany().getId().toString() : entry.getProfitCenter().getId().toString();
            if (!orgMap.containsKey(orgMapKey)) {
                orgMap.put(orgMapKey, entry.getOrgRatio());
            }
            Map<String, BigDecimal> accountItemMap = new HashMap<String, BigDecimal>();
            String accountId = entry.getAccount().getId().toString() + entry.getSeq();
            if (!accountMap.containsKey(orgMapKey)) {
                accountItemMap.put(accountId, entry.getAccountRatio());
                accountMap.put(orgMapKey, accountItemMap);
            } else {
                accountItemMap = (Map)accountMap.get(orgMapKey);
                if (!accountItemMap.containsKey(accountId)) {
                    accountItemMap.put(accountId, entry.getAccountRatio());
                    accountMap.put(orgMapKey, accountItemMap);
                }
            }
            if ((assRecColl = entry.getAssRec()) == null) continue;
            Iterator itor = assRecColl.iterator();
            while (itor.hasNext()) {
                AmortizeRuleDestAssRecInfo assRecInfo = (AmortizeRuleDestAssRecInfo)itor.next();
                if (assRecInfo == null || assRecInfo.getAssGrp() == null) continue;
                String assGrpId = assRecInfo.getAssGrp().getId().toString() + assRecInfo.getSeq();
                Map<String, Map<String, Map<String, BigDecimal>>> accMap = new HashMap();
                Map<String, BigDecimal> assItemMap = new HashMap<String, BigDecimal>();
                if (!asstMap.containsKey(orgMapKey)) {
                    assItemMap.put(assGrpId, assRecInfo.getRatio());
                    accMap.put(accountId, assItemMap);
                    asstMap.put(orgMapKey, accMap);
                    continue;
                }
                accMap = (Map)asstMap.get(orgMapKey);
                if (!accMap.containsKey(accountId)) {
                    assItemMap.put(assGrpId, assRecInfo.getRatio());
                    accMap.put(accountId, assItemMap);
                } else {
                    assItemMap = (Map)accMap.get(accountId);
                    if (!assItemMap.containsKey(assGrpId)) {
                        assItemMap.put(assGrpId, assRecInfo.getRatio());
                        accMap.put(accountId, assItemMap);
                    }
                }
                asstMap.put(orgMapKey, accMap);
            }
        }
        if (amortizePattern == AmortizePattern.Ratio) {
            Iterator orgItor = orgMap.keySet().iterator();
            BigDecimal orgRaionSum = new BigDecimal("0.00");
            while (orgItor.hasNext()) {
                String key = (String)orgItor.next();
                BigDecimal ratio = (BigDecimal)orgMap.get(key);
                orgRaionSum = orgRaionSum.add(ratio);
            }
            if (orgRaionSum.compareTo(new BigDecimal("100.00")) != 0) {
                String msg = ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"destEntriesOrgRatioSumError", (Locale)ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("1", msg));
            }
        }
        for (String orgkey : accountMap.keySet()) {
            Map accItemMap = (Map)accountMap.get(orgkey);
            Iterator accItemItor = accItemMap.keySet().iterator();
            BigDecimal accRaionSum = new BigDecimal("0.00");
            while (accItemItor.hasNext()) {
                String accKey = (String)accItemItor.next();
                BigDecimal ratio = (BigDecimal)accItemMap.get(accKey);
                accRaionSum = accRaionSum.add(ratio);
            }
            if (accRaionSum.compareTo(new BigDecimal("100.00")) == 0) continue;
            String orgName = null;
            if (orgType == AmortizeOrgTypeEnum.CompanyToCompany) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select name where id = '" + orgkey + "'");
                orgName = company.getName();
            } else {
                ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgkey));
                orgName = profitCenter.getName();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"destEntry", (Locale)ctx.getLocale()));
            sb.append(orgName);
            sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"accountRatioSumError", (Locale)ctx.getLocale()));
            throw new EASBizException(new NumericExceptionSubItem("1", sb.toString()));
        }
        for (String orgkey : asstMap.keySet()) {
            Map acctMap = (Map)asstMap.get(orgkey);
            for (String accKey : acctMap.keySet()) {
                Map hgMap = (Map)acctMap.get(accKey);
                Iterator hgItor = hgMap.keySet().iterator();
                BigDecimal hgRaionSum = new BigDecimal("0.00");
                while (hgItor.hasNext()) {
                    String hgKey = (String)hgItor.next();
                    BigDecimal ratio = (BigDecimal)hgMap.get(hgKey);
                    hgRaionSum = hgRaionSum.add(ratio);
                }
                if (hgRaionSum.compareTo(new BigDecimal("100.00")) == 0) continue;
                String orgName = null;
                if (orgType == AmortizeOrgTypeEnum.CompanyToCompany) {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select name where id = '" + orgkey + "'");
                    orgName = company.getName();
                } else {
                    ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgkey));
                    orgName = profitCenter.getName();
                }
                String accId = accKey.length() < 28 ? accKey.substring(0, 16) : accKey.substring(0, 28);
                AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accId));
                StringBuffer sb = new StringBuffer();
                sb.append(orgName).append(account.getName());
                sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"account", (Locale)ctx.getLocale()));
                sb.append(ResourceBase.getString((String)RES_AMORTIZERULERESOURCE, (String)"accountHGRatioSumError", (Locale)ctx.getLocale()));
                throw new EASBizException(new NumericExceptionSubItem("1", sb.toString()));
            }
        }
    }
}

