/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VchAmortUtils;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.AmortizeDcEnum;
import com.kingdee.eas.ma.pca.AmortizeLogInfo;
import com.kingdee.eas.ma.pca.AmortizeOrgTypeEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleAccountDCEnum;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestAssRecInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeRuleDestEntryGenVoucher;
import com.kingdee.eas.ma.pca.app.AmortizeSchemeGenVoucherHandler;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class AmortizeRuleDestEntryGenPcVoucherHandler
extends AbstractAmortizeRuleDestEntryGenVoucher {
    public AmortizeRuleDestEntryGenPcVoucherHandler(AmortizeSchemeGenVoucherHandler handler) {
        super(handler);
    }

    @Override
    protected void genDestVoucher(Context ctx, AmortizeRuleInfo rule, AmortizeRuleDestEntryInfo destEntry, int periodNumber, BigDecimal ruleAmount, BigDecimal logAmt, Map<String, AmortizeLogInfo> logMap, Map<String, BigDecimal> outAmountMap, BigDecimal totalOut) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo profitCenter = destEntry.getProfitCenter();
        CompanyOrgUnitInfo company = PcaUtils.getDelegateCompany(ctx, profitCenter.getId().toString());
        PeriodInfo period = this.handler.getPeriod(ctx, company, periodNumber);
        PcVoucherInfo voucher = new PcVoucherInfo();
        voucher.setSourceBillId(destEntry.getId().toString());
        voucher.setCompany(company);
        voucher.setProfitCenter(profitCenter);
        voucher.setId(null);
        voucher.setNumber(null);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        voucher.setCreator(curUser);
        voucher.setHandler(curUser);
        Date now = new Date();
        Timestamp t = new Timestamp(now.getTime());
        voucher.setCreateTime(t);
        voucher.setLastUpdateUser(curUser);
        voucher.setLastUpdateTime(t);
        voucher.setCashier(null);
        voucher.setAuditor(null);
        voucher.setPoster(null);
        voucher.setCanceller(null);
        voucher.setIsCheck(false);
        voucher.setIsCussent(false);
        Timestamp endDate = period.getEndDate();
        voucher.setBizDate((Date)endDate);
        voucher.setBookedDate((Date)endDate);
        voucher.setPeriod(period);
        voucher.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        voucher.setSourceType(SourceType.AUTO_AMORTIZE);
        voucher.setBizStatus(VoucherStatusEnum.TEMP);
        voucher.setVoucherAbstract(rule.getDescription());
        voucher.setVoucherType(destEntry.getVoucherType());
        voucher.setIsReverseVoucher(false);
        voucher.setCashflowFetched(false);
        PcVoucherEntryCollection entries = new PcVoucherEntryCollection();
        voucher.setEntries((AbstractObjectCollection)entries);
        CurrencyInfo ruleCurrency = rule.getCompany().getBaseCurrency();
        EntryDC amtDc = EntryDC.CREDIT;
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        CurrencyInfo rptCurrency = company.getReportCurrency();
        boolean isEnableRpt = rptCurrency != null;
        BigDecimal schemeToLocRate = this.handler.getCurrencyToLocExchangeRate(ctx, destEntry.getCurrency(), period, company, endDate);
        BigDecimal cussentToLocRate = this.handler.getCurrencyToLocExchangeRate(ctx, destEntry.getCussentCurrency(), period, company, endDate);
        BigDecimal schemeToRptRate = GlUtils.one;
        BigDecimal locToRptRate = GlUtils.one;
        BigDecimal cussentToRptRate = GlUtils.one;
        if (isEnableRpt) {
            schemeToRptRate = this.handler.getCurrencyToRptExchangeRate(ctx, destEntry.getCurrency(), period, company, endDate);
            locToRptRate = this.handler.getCurrencyToRptExchangeRate(ctx, baseCurrency, period, company, endDate);
            cussentToRptRate = this.handler.getCurrencyToRptExchangeRate(ctx, destEntry.getCussentCurrency(), period, company, endDate);
        }
        BigDecimal amount = null;
        BigDecimal entryLocAmt = null;
        if (ruleCurrency.getId().toString().equals(baseCurrency.getId().toString())) {
            entryLocAmt = ruleAmount;
            amount = destEntry.getCurrency().getId().toString().equals(baseCurrency.getId().toString()) ? entryLocAmt : entryLocAmt.divide(schemeToLocRate, destEntry.getCurrency().getPrecision(), 4);
        } else {
            if (ruleCurrency.getId().toString().equals(destEntry.getCurrency().getId().toString())) {
                amount = ruleAmount;
            } else {
                BigDecimal destEntryToRuleRate = this.handler.getCurrencyToLocExchangeRate(ctx, destEntry.getCurrency(), period, rule.getCompany(), endDate);
                amount = ruleAmount.divide(destEntryToRuleRate, destEntry.getCurrency().getPrecision(), 4);
            }
            entryLocAmt = this.handler.exchangeCurrency(schemeToLocRate, baseCurrency, amount);
        }
        BigDecimal entryRptAmt = GlUtils.zero;
        BigDecimal schemeRptExchangerate = GlUtils.one;
        BigDecimal cussentRptExchangerate = GlUtils.one;
        if (isEnableRpt) {
            if (3 == company.getReportConvertMode().getValue()) {
                entryRptAmt = this.handler.exchangeCurrency(locToRptRate, rptCurrency, entryLocAmt);
                schemeRptExchangerate = locToRptRate;
                cussentRptExchangerate = locToRptRate;
            } else {
                entryRptAmt = this.handler.exchangeCurrency(schemeToRptRate, rptCurrency, amount);
                schemeRptExchangerate = schemeToRptRate;
                cussentRptExchangerate = cussentToRptRate;
            }
        }
        PcVoucherEntryInfo voucherEntry = new PcVoucherEntryInfo();
        entries.add(voucherEntry);
        voucherEntry.setAccount(destEntry.getAccount());
        voucherEntry.setOriginalAmount(amount);
        voucherEntry.setCurrency(destEntry.getCurrency());
        voucherEntry.setSeq(1);
        voucherEntry.setDescription(rule.getDescription());
        voucherEntry.setOprStatus(1);
        voucherEntry.setIsCheck(false);
        voucherEntry.setIsHand(true);
        voucherEntry.setBill(voucher);
        if (AmortizeRuleAccountDCEnum.Auto.equals((Object)destEntry.getDc())) {
            if (amount.signum() >= 0) {
                voucherEntry.setEntryDC(amtDc);
            } else {
                amount = amount.negate();
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
                if (EntryDC.CREDIT.equals((Object)amtDc)) {
                    voucherEntry.setEntryDC(EntryDC.DEBIT);
                } else {
                    voucherEntry.setEntryDC(EntryDC.CREDIT);
                }
            }
        } else if (AmortizeRuleAccountDCEnum.Credit.equals((Object)destEntry.getDc())) {
            voucherEntry.setEntryDC(EntryDC.CREDIT);
            if (EntryDC.DEBIT.equals((Object)amtDc)) {
                amount = amount.negate();
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
            }
        } else {
            voucherEntry.setEntryDC(EntryDC.DEBIT);
            if (EntryDC.CREDIT.equals((Object)amtDc)) {
                amount = amount.negate();
                entryLocAmt = entryLocAmt.negate();
                entryRptAmt = entryRptAmt.negate();
            }
        }
        voucherEntry.setOriginalAmount(amount);
        voucherEntry.setLocalAmount(entryLocAmt);
        voucherEntry.setReportingAmount(entryRptAmt);
        voucherEntry.setLocalExchangeRate(schemeToLocRate);
        voucherEntry.setReportingExchangeRate(schemeRptExchangerate);
        AmortizeRuleDestAssRecCollection coll = destEntry.getAssRec();
        PcVoucherAssistRecordCollection records = new PcVoucherAssistRecordCollection();
        voucherEntry.setAssistRecords((AbstractObjectCollection)records);
        PcVoucherAssistRecordInfo assist = null;
        AmortizeRuleDestAssRecInfo destAssRec = null;
        BigDecimal leftAssistOrigAmt = amount;
        BigDecimal leftAssistLocAmt = entryLocAmt;
        BigDecimal leftAssistRptAmt = entryRptAmt;
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            destAssRec = coll.get(i);
            assist = new PcVoucherAssistRecordInfo();
            assist.setId(null);
            assist.setSeq(destAssRec.getSeq());
            assist.setDescription(rule.getDescription());
            assist.setBizDate((Date)endDate);
            assist.setOprStatus(1);
            if (destAssRec.getAssGrp() != null) {
                this.handler.checkAssitInfo(ctx, destAssRec.getAssGrp().getId().toString(), company.getId().toString(), curUser.getId().toString(), false, false);
                assist.setAssGrp(destAssRec.getAssGrp());
            }
            assist.setBill(voucher);
            assist.setEntry(voucherEntry);
            assist.setQuantity(destAssRec.getQuantity());
            assist.setPrice(destAssRec.getPrice());
            assist.setMeasureUnit(destAssRec.getMeasureUnit());
            BigDecimal assistAmortOrigAmt = GlUtils.zero;
            BigDecimal assistAmortLocAmt = GlUtils.zero;
            BigDecimal assistAmortRptAmt = GlUtils.zero;
            if (i == j - 1) {
                assistAmortOrigAmt = leftAssistOrigAmt;
                assistAmortLocAmt = leftAssistLocAmt;
                assistAmortRptAmt = leftAssistRptAmt;
            } else {
                assistAmortOrigAmt = amount.multiply(destAssRec.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, destEntry.getCurrency().getPrecision(), 4);
                assistAmortLocAmt = entryLocAmt.multiply(destAssRec.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, destEntry.getCurrency().getPrecision(), 4);
                assistAmortRptAmt = entryRptAmt.multiply(destAssRec.getRatio()).divide(VchAmortUtils.ONE_HUNDRED, destEntry.getCurrency().getPrecision(), 4);
                leftAssistOrigAmt = leftAssistOrigAmt.subtract(assistAmortOrigAmt);
                leftAssistLocAmt = leftAssistLocAmt.subtract(assistAmortLocAmt);
                leftAssistRptAmt = leftAssistRptAmt.subtract(assistAmortRptAmt);
            }
            assist.setOriginalAmount(assistAmortOrigAmt);
            assist.setLocalAmount(assistAmortLocAmt);
            assist.setReportingAmount(assistAmortRptAmt);
            records.add(assist);
        }
        PcVoucherEntryInfo cussentEntry = new PcVoucherEntryInfo();
        entries.add(cussentEntry);
        cussentEntry.setSeq(2);
        cussentEntry.setDescription(rule.getDescription());
        cussentEntry.setOprStatus(1);
        cussentEntry.setIsCheck(false);
        cussentEntry.setIsHand(true);
        AccountViewInfo cussentAccount = destEntry.getCussentAccount();
        cussentEntry.setAccount(cussentAccount);
        cussentEntry.setBill(voucher);
        cussentEntry.setEntryDC(EntryDC.DEBIT);
        if (EntryDC.DEBIT.equals((Object)voucherEntry.getEntryDC())) {
            cussentEntry.setEntryDC(EntryDC.CREDIT);
        }
        cussentEntry.setCurrency(destEntry.getCussentCurrency());
        cussentEntry.setOriginalAmount(voucherEntry.getOriginalAmount());
        cussentEntry.setLocalAmount(voucherEntry.getLocalAmount());
        cussentEntry.setReportingAmount(voucherEntry.getReportingAmount());
        cussentEntry.setLocalExchangeRate(voucherEntry.getLocalExchangeRate());
        cussentEntry.setReportingExchangeRate(voucherEntry.getReportingExchangeRate());
        if (!destEntry.getCurrency().getId().toString().equals(destEntry.getCussentCurrency().getId().toString())) {
            cussentEntry.setOriginalAmount(voucherEntry.getLocalAmount().divide(cussentToLocRate, destEntry.getCussentCurrency().getPrecision(), 4));
            cussentEntry.setLocalExchangeRate(cussentToLocRate);
            cussentEntry.setReportingExchangeRate(cussentRptExchangerate);
        }
        if (cussentAccount.getCAA() != null) {
            AsstActGroupDetailInfo aagpInfo;
            int i;
            PcVoucherAssistRecordCollection cussentRecords = new PcVoucherAssistRecordCollection();
            PcVoucherAssistRecordInfo cAssist = null;
            cAssist = new PcVoucherAssistRecordInfo();
            cAssist.setId(null);
            cAssist.setSeq(1);
            cAssist.setDescription(rule.getDescription());
            cAssist.setBizDate((Date)endDate);
            cAssist.setOprStatus(1);
            if (destEntry.getCussentAssGrp() != null) {
                this.handler.checkAssitInfo(ctx, destEntry.getCussentAssGrp().getId().toString(), company.getId().toString(), curUser.getId().toString(), false, false);
                cAssist.setAssGrp(destEntry.getCussentAssGrp());
            }
            cAssist.setBill(voucher);
            cAssist.setEntry(cussentEntry);
            cAssist.setOriginalAmount(cussentEntry.getOriginalAmount());
            cAssist.setLocalAmount(cussentEntry.getLocalAmount());
            cAssist.setReportingAmount(cussentEntry.getReportingAmount());
            AsstAccountInfo aac = cussentAccount.getCAA();
            AsstActGroupDetailCollection aagColl = aac.getAsstActGpDt();
            AsstActTypeCollection actTypes = new AsstActTypeCollection();
            int j2 = aagColl.size();
            for (i = 0; i < j2; ++i) {
                aagpInfo = aagColl.get(i);
                actTypes.add(aagpInfo.getAsstActType());
            }
            j2 = aagColl.size();
            for (i = 0; i < j2; ++i) {
                aagpInfo = aagColl.get(i);
                String assHgAttr = aagpInfo.getAsstActType().getAsstHGAttribute();
                if ((!"profitOrg".equals(assHgAttr) || !AmortizeOrgTypeEnum.ProfitCenterToProfitCenter.equals((Object)rule.getAmortizeOrgType())) && (!"companyOrg".equals(assHgAttr) || AmortizeOrgTypeEnum.ProfitCenterToProfitCenter.equals((Object)rule.getAmortizeOrgType()))) continue;
                Set<String> idSet = outAmountMap.keySet();
                String[] ids = idSet.toArray(new String[idSet.size()]);
                BigDecimal oriAmountLeft = cussentEntry.getOriginalAmount();
                BigDecimal LocAmountLeft = cussentEntry.getLocalAmount();
                BigDecimal rptAmountLeft = cussentEntry.getReportingAmount();
                int n = ids.length;
                for (int m = 0; m < n; ++m) {
                    CompanyOrgUnitInfo comHg;
                    String orgID = ids[m];
                    BigDecimal outAmount = outAmountMap.get(orgID);
                    PcVoucherAssistRecordInfo nAss = (PcVoucherAssistRecordInfo)cAssist.clone();
                    nAss.setSeq(m + 1);
                    if (m + 1 == n) {
                        nAss.setOriginalAmount(oriAmountLeft);
                        nAss.setLocalAmount(LocAmountLeft);
                        nAss.setReportingAmount(rptAmountLeft);
                    } else {
                        nAss.setOriginalAmount(cussentEntry.getOriginalAmount().multiply(outAmount).divide(totalOut, cussentEntry.getOriginalAmount().scale(), 4));
                        nAss.setLocalAmount(cussentEntry.getLocalAmount().multiply(outAmount).divide(totalOut, cussentEntry.getLocalAmount().scale(), 4));
                        nAss.setReportingAmount(cussentEntry.getReportingAmount().multiply(outAmount).divide(totalOut, cussentEntry.getReportingAmount().scale(), 4));
                        oriAmountLeft = oriAmountLeft.subtract(nAss.getOriginalAmount());
                        LocAmountLeft = LocAmountLeft.subtract(nAss.getLocalAmount());
                        rptAmountLeft = rptAmountLeft.subtract(nAss.getReportingAmount());
                    }
                    AssistantHGInfo assHgInfo = destEntry.getCussentAssGrp();
                    if (assHgInfo == null) {
                        assHgInfo = new AssistantHGInfo();
                    }
                    if ("companyOrg".equals(assHgAttr)) {
                        comHg = new CompanyOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setCompanyOrg(comHg);
                    } else {
                        comHg = new ProfitCenterOrgUnitInfo();
                        comHg.setId(BOSUuid.read((String)orgID));
                        assHgInfo.setProfitOrg((ProfitCenterOrgUnitInfo)comHg);
                    }
                    assHgInfo.setId(null);
                    assHgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(assHgInfo, aac.getId().toString(), actTypes);
                    nAss.setAssGrp(assHgInfo);
                    cussentRecords.add(nAss);
                }
                cAssist = null;
                break;
            }
            if (cAssist != null) {
                cussentRecords.add(cAssist);
            }
            cussentEntry.setAssistRecords((AbstractObjectCollection)cussentRecords);
        }
        voucher.setLocalDebitAmount(voucherEntry.getLocalAmount());
        voucher.setLocalCreditAmount(voucherEntry.getLocalAmount());
        voucher.setReportingDebitAmount(voucherEntry.getReportingAmount());
        voucher.setReportingCreditAmount(voucherEntry.getReportingAmount());
        voucher.setEntryCount(entries.size());
        AmortizeLogInfo logInfo = new AmortizeLogInfo();
        logInfo.setPcVoucher(voucher);
        logInfo.setAmortizeProfitCenter(profitCenter);
        logInfo.setAmortizeDC(AmortizeDcEnum.In);
        logInfo.setAmortizeRule(rule);
        logInfo.setAmount(logAmt);
        logInfo.setPeriod(period);
        logInfo.setCurrency(baseCurrency);
        if (logMap.get(profitCenter.getId().toString()) != null) {
            AmortizeLogInfo extLogInfo = logMap.get(profitCenter.getId().toString());
            extLogInfo.setAmount(extLogInfo.getAmount().add(logAmt));
            PcVoucherInfo extVoucherInfo = extLogInfo.getPcVoucher();
            extVoucherInfo.setLocalCreditAmount(extVoucherInfo.getLocalCreditAmount().add(voucher.getLocalCreditAmount()));
            extVoucherInfo.setLocalDebitAmount(extVoucherInfo.getLocalDebitAmount().add(voucher.getLocalDebitAmount()));
            extVoucherInfo.setReportingCreditAmount(extVoucherInfo.getReportingCreditAmount().add(voucher.getReportingCreditAmount()));
            extVoucherInfo.setReportingDebitAmount(extVoucherInfo.getReportingDebitAmount().add(voucher.getReportingDebitAmount()));
            int j3 = entries.size();
            for (int i = 0; i < j3; ++i) {
                PcVoucherEntryInfo entryInfo = entries.get(i);
                entryInfo.setSeq(extVoucherInfo.getEntryCount() + 1);
                extVoucherInfo.getEntries().add(entryInfo);
                extVoucherInfo.setEntryCount(extVoucherInfo.getEntryCount() + 1);
            }
        } else {
            logMap.put(profitCenter.getId().toString(), logInfo);
        }
    }
}

