/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseAccountBalanceInfo;
import com.kingdee.eas.fi.gl.BaseAssistBalanceCollection;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.AmortizeLogInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryInfo;
import com.kingdee.eas.ma.pca.PcAccountBalance1FFactory;
import com.kingdee.eas.ma.pca.PcAccountBalance1LFactory;
import com.kingdee.eas.ma.pca.PcAccountBalance1RFactory;
import com.kingdee.eas.ma.pca.PcAccountBalance5FFactory;
import com.kingdee.eas.ma.pca.PcAccountBalance5LFactory;
import com.kingdee.eas.ma.pca.PcAccountBalance5RFactory;
import com.kingdee.eas.ma.pca.PcAssistBalanceInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeRuleSrcEntryGenVoucher;
import com.kingdee.eas.ma.pca.app.AmortizeSchemeGenVoucherHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

public class AmortizeRuleSrcEntryGenPcVoucherHandler
extends AbstractAmortizeRuleSrcEntryGenVoucher {
    private ProfitCenterOrgUnitInfo profitCenter;

    public AmortizeRuleSrcEntryGenPcVoucherHandler(Context ctx, AmortizeRuleInfo rule, int periodNumber, Map<String, AmortizeLogInfo> logMap, Map<String, BigDecimal> workLoadMap, BigDecimal workLoadTotal, AmortizeSchemeGenVoucherHandler handler) throws EASBizException, BOSException {
        super(ctx, rule, periodNumber, logMap, workLoadMap, workLoadTotal, handler);
    }

    @Override
    protected void init(AmortizeRuleSrcEntryInfo srcEntry) throws EASBizException, BOSException {
        this.profitCenter = srcEntry.getProfitCenter();
        super.init(srcEntry);
    }

    @Override
    protected CompanyOrgUnitInfo getCompany() throws EASBizException, BOSException {
        return PcaUtils.getDelegateCompany(this.ctx, this.profitCenter.getId().toString());
    }

    @Override
    protected PeriodInfo getCurrentPeriod() throws EASBizException, BOSException {
        return PcaUtils.getCurrentPeriod(this.ctx, this.profitCenter.getId().toString());
    }

    @Override
    protected void initBaseVoucher() throws EASBizException, BOSException {
        PcVoucherInfo pcVoucher = new PcVoucherInfo();
        pcVoucher.setProfitCenter(this.profitCenter);
        this.voucher = pcVoucher;
        this.voucher.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        this.fillBaseVoucher();
        this.entries = new PcVoucherEntryCollection();
        this.voucher.setEntries(this.entries);
        this.voucherEntry = new PcVoucherEntryInfo();
        this.records = new PcVoucherAssistRecordCollection();
        this.voucherEntry.setAssistRecords(this.records);
        this.cussentEntry = new PcVoucherEntryInfo();
        this.cussentRecords = new PcVoucherAssistRecordCollection();
    }

    @Override
    protected BaseVoucherAssistRecordInfo createNewAssistRecordInfo() {
        return new PcVoucherAssistRecordInfo();
    }

    @Override
    protected BaseAssistBalanceCollection getAssistBalanceData() throws EASBizException, BOSException {
        BaseAssistBalanceCollection baseColl = new BaseAssistBalanceCollection();
        int pRealNumber = this.handler.getRealPeriodNumber(this.ctx, this.periodNumber, this.rule, this.company, this.currentPeriod);
        StringBuffer assSql = new StringBuffer();
        assSql.append("select b.fassistgrpid,b.FENDBALANCEFOR,b.FBEGINBALANCEFOR,b.FYEARCREDITFOR,b.FYEARDEBITFOR,b.FDEBITFOR,b.FCREDITFOR ");
        if (this.srcEntry.isIncludeUnPost()) {
            assSql.append("from T_PCA_PCASSISTBALANCE_1F b ");
        } else {
            assSql.append("from T_PCA_PCASSISTBALANCE_5F b ");
        }
        assSql.append("where b.fperiod=? and b.fprofitcenterid=? and faccountid=? and b.fcurrencyid=?");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)assSql.toString(), (Object[])new Object[]{pRealNumber, this.profitCenter.getId().toString(), this.srcEntry.getAccount().getId().toString(), this.srcEntry.getCurrency().getId().toString()});
        try {
            while (rs != null && rs.next()) {
                PcAssistBalanceInfo info = new PcAssistBalanceInfo();
                AssistantHGInfo grpInfo = new AssistantHGInfo();
                grpInfo.setId(BOSUuid.read((String)rs.getString("fassistgrpid")));
                info.setAssistGrp(grpInfo);
                info.setBeginBalanceFor(rs.getBigDecimal("FBEGINBALANCEFOR"));
                info.setEndBalanceFor(rs.getBigDecimal("FENDBALANCEFOR"));
                info.setYearCreditFor(rs.getBigDecimal("FYEARCREDITFOR"));
                info.setYearDebitFor(rs.getBigDecimal("FYEARDEBITFOR"));
                info.setDebitFor(rs.getBigDecimal("FDEBITFOR"));
                info.setCreditFor(rs.getBigDecimal("FCREDITFOR"));
                baseColl.addObject((IObjectValue)info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return baseColl;
    }

    @Override
    protected BaseAccountBalanceInfo getAccountBalanceData() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.handler.getRealPeriodNumber(this.ctx, this.periodNumber, this.rule, this.company, this.currentPeriod)));
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)this.profitCenter.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)this.srcEntry.getAccount().getId().toString()));
        int balType = this.srcEntry.isIncludeUnPost() ? 1 : 5;
        AbstractObjectCollection balColl = null;
        if (balType == 1) {
            balColl = this.srcEntry.getCurrency().isGeneralLocalCurrency() ? PcAccountBalance1LFactory.getLocalInstance(this.ctx).getPcAccountBalance1LCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)) : (this.srcEntry.getCurrency().isGeneralReportCurrency() ? PcAccountBalance1RFactory.getLocalInstance(this.ctx).getPcAccountBalance1RCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)) : PcAccountBalance1FFactory.getLocalInstance(this.ctx).getPcAccountBalance1FCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)));
        } else if (balType == 5) {
            balColl = this.srcEntry.getCurrency().isGeneralLocalCurrency() ? PcAccountBalance5LFactory.getLocalInstance(this.ctx).getPcAccountBalance5LCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)) : (this.srcEntry.getCurrency().isGeneralReportCurrency() ? PcAccountBalance5RFactory.getLocalInstance(this.ctx).getPcAccountBalance5RCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)) : PcAccountBalance5FFactory.getLocalInstance(this.ctx).getPcAccountBalance5FCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null)));
        }
        if (balColl != null && balColl.size() > 0) {
            BaseAccountBalanceInfo info = new BaseAccountBalanceInfo();
            info.putAll(balColl.getObject(0));
            return info;
        }
        return null;
    }

    @Override
    protected void fillAmortizeLog(AmortizeLogInfo logInfo) {
        logInfo.setAmortizeProfitCenter(this.profitCenter);
    }

    @Override
    protected String getAmortizeLogMapKey() {
        return this.profitCenter.getId().toString();
    }
}

