/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VchAmortUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.AmortizeDcEnum;
import com.kingdee.eas.ma.pca.AmortizeLogFactory;
import com.kingdee.eas.ma.pca.AmortizeLogInfo;
import com.kingdee.eas.ma.pca.AmortizeOrgTypeEnum;
import com.kingdee.eas.ma.pca.AmortizePattern;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleDestEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeRuleSrcEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeSchemeEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeSchemeEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeSchemeException;
import com.kingdee.eas.ma.pca.AmortizeSchemeInfo;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryCollection;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryFactory;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeStandInfo;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeRuleDestEntryGenVoucher;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeRuleSrcEntryGenVoucher;
import com.kingdee.eas.ma.pca.app.AmortizeRuleDestEntryGenGLVoucherHandler;
import com.kingdee.eas.ma.pca.app.AmortizeRuleDestEntryGenPcVoucherHandler;
import com.kingdee.eas.ma.pca.app.AmortizeRuleSrcEntryGenGLVoucherHandler;
import com.kingdee.eas.ma.pca.app.AmortizeRuleSrcEntryGenPcVoucherHandler;
import com.kingdee.eas.ma.pca.app.AmortizeSchemeGenVoucherHandler;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AmortizeSchemeGenVoucher {
    private Context ctx;
    private AmortizeSchemeInfo schemeInfo;
    private int periodNumber;
    protected AmortizeSchemeGenVoucherHandler handler;
    private List<Map> previewList;
    private boolean schemeZero = true;

    public AmortizeSchemeGenVoucher(Context ctx, AmortizeSchemeInfo schemeInfo, int periodNumber) {
        this.ctx = ctx;
        this.schemeInfo = schemeInfo;
        this.periodNumber = periodNumber;
        this.handler = new AmortizeSchemeGenVoucherHandler();
    }

    public AmortizeSchemeGenVoucher(Context ctx, AmortizeSchemeInfo schemeInfo, int periodNumber, List<Map> previewList) {
        this(ctx, schemeInfo, periodNumber);
        this.previewList = previewList;
    }

    public void genVoucher() throws EASBizException, BOSException {
        AmortizeSchemeEntryCollection entries = this.schemeInfo.getEntries();
        HashMap<String, AmortizeLogInfo> logMap = new HashMap<String, AmortizeLogInfo>();
        int j = entries.size();
        for (int i = 0; i < j; ++i) {
            BigDecimal logAmount;
            BigDecimal accountAmount;
            AmortizeRuleDestEntryInfo destEntry;
            int m;
            int n;
            AmortizeSchemeEntryInfo entry = entries.get(i);
            AmortizeRuleInfo rule = entry.getAmortizeRule();
            HashMap<String, BigDecimal> outAmountMap = new HashMap<String, BigDecimal>();
            BigDecimal logTotal = new BigDecimal("0");
            AmortizeRuleSrcEntryCollection srcEntries = rule.getSrcEntries();
            AmortizeRuleDestEntryCollection destEntries = rule.getDestEntries();
            HashMap<String, BigDecimal> workLoadMapAll = null;
            BigDecimal workLoadTotal = new BigDecimal("0");
            HashMap<String, BigDecimal> workLoadMap = new HashMap<String, BigDecimal>();
            if (AmortizePattern.Workload.equals((Object)rule.getAmortizePattern())) {
                AmortizeRuleDestEntryInfo destEntry2;
                int m2;
                int n2;
                workLoadMapAll = new HashMap<String, BigDecimal>();
                CompanyOrgUnitInfo company = rule.getCompany();
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)(this.periodNumber / 100), (int)(this.periodNumber % 100), (CompanyOrgUnitInfo)company);
                AmortizeStandInfo asInfo = rule.getAmortizeStand();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("amortizeStand.id", (Object)asInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("bill.period.id", (Object)period.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("bill.company.id", (Object)company.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("bill.dataType", (Object)(AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)rule.getAmortizeOrgType()) ? "2" : "1")));
                AmortizeStandDataEntryCollection asDataEntryColl = AmortizeStandDataEntryFactory.getLocalInstance(this.ctx).getAmortizeStandDataEntryCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
                if (asDataEntryColl == null || asDataEntryColl.size() == 0) {
                    throw new AmortizeSchemeException(AmortizeSchemeException.AMORTIZERULEHASNOSTANDARDDATA, new Object[]{rule.getNumber(), asInfo.getName()});
                }
                int b = asDataEntryColl.size();
                for (int a = 0; a < b; ++a) {
                    AmortizeStandDataEntryInfo dataEntryInfo = asDataEntryColl.get(a);
                    String orgID = AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)rule.getAmortizeOrgType()) ? dataEntryInfo.getCompany().getId().toString() : dataEntryInfo.getProfitCenter().getId().toString();
                    workLoadMapAll.put(orgID, dataEntryInfo.getWorkload());
                }
                if (AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)rule.getAmortizeOrgType())) {
                    n2 = destEntries.size();
                    for (m2 = 0; m2 < n2; ++m2) {
                        destEntry2 = destEntries.get(m2);
                        String companyId = destEntry2.getCompany().getId().toString();
                        if (workLoadMapAll.get(companyId) == null) {
                            throw new AmortizeSchemeException(AmortizeSchemeException.AMORTIZERULESCOMPANYHASNOSTANDARDDATA, new Object[]{rule.getNumber(), destEntry2.getCompany().getName(), asInfo.getName()});
                        }
                        if (!workLoadMap.containsKey(destEntry2.getCompany().getId().toString())) {
                            workLoadTotal = workLoadTotal.add((BigDecimal)workLoadMapAll.get(companyId));
                        }
                        workLoadMap.put(destEntry2.getCompany().getId().toString(), (BigDecimal)workLoadMapAll.get(companyId));
                    }
                } else {
                    n2 = destEntries.size();
                    for (m2 = 0; m2 < n2; ++m2) {
                        destEntry2 = destEntries.get(m2);
                        String pcId = destEntry2.getProfitCenter().getId().toString();
                        if (workLoadMapAll.get(pcId) == null) {
                            throw new AmortizeSchemeException(AmortizeSchemeException.AMORTIZERULESCOMPANYHASNOSTANDARDDATA, new Object[]{rule.getNumber(), destEntry2.getProfitCenter().getName(), asInfo.getName()});
                        }
                        if (!workLoadMap.containsKey(destEntry2.getProfitCenter().getId().toString())) {
                            workLoadTotal = workLoadTotal.add((BigDecimal)workLoadMapAll.get(pcId));
                        }
                        workLoadMap.put(destEntry2.getProfitCenter().getId().toString(), (BigDecimal)workLoadMapAll.get(pcId));
                    }
                }
            }
            BigDecimal totalOut = new BigDecimal("0");
            AbstractAmortizeRuleSrcEntryGenVoucher genSrcVoucher = AmortizeOrgTypeEnum.ProfitCenterToProfitCenter.equals((Object)rule.getAmortizeOrgType()) ? new AmortizeRuleSrcEntryGenPcVoucherHandler(this.ctx, rule, this.periodNumber, logMap, workLoadMap, workLoadTotal, this.handler) : new AmortizeRuleSrcEntryGenGLVoucherHandler(this.ctx, rule, this.periodNumber, logMap, workLoadMap, workLoadTotal, this.handler);
            int n3 = srcEntries.size();
            for (int m3 = 0; m3 < n3; ++m3) {
                AmortizeRuleSrcEntryInfo srcEntry = srcEntries.get(m3);
                if (AmortizeOrgTypeEnum.CompanyToProfitCenter.equals((Object)rule.getAmortizeOrgType())) {
                    srcEntry.put("isCompanyToProfitCenter", true);
                }
                BigDecimal outAmt = genSrcVoucher.genSrcVoucher(srcEntry);
                String orgID = AmortizeOrgTypeEnum.ProfitCenterToProfitCenter.equals((Object)rule.getAmortizeOrgType()) ? srcEntry.getProfitCenter().getId().toString() : srcEntry.getCompany().getId().toString();
                if (outAmountMap.containsKey(orgID)) {
                    outAmountMap.put(orgID, outAmt.add((BigDecimal)outAmountMap.get(orgID)));
                } else {
                    outAmountMap.put(orgID, outAmt);
                }
                totalOut = totalOut.add(outAmt);
            }
            Collection logs = logMap.values();
            for (AmortizeLogInfo logInfo : logs) {
                logTotal = logTotal.add(logInfo.getAmount());
            }
            if (this.previewList != null) {
                this.createPreviewData(entry, logMap, this.previewList, AmortizeDcEnum.Out);
            } else {
                this.saveVocuherAndLog(rule, logMap);
            }
            if (totalOut.signum() == 0) continue;
            AbstractAmortizeRuleDestEntryGenVoucher genDestVoucher = AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)rule.getAmortizeOrgType()) ? new AmortizeRuleDestEntryGenGLVoucherHandler(this.handler) : new AmortizeRuleDestEntryGenPcVoucherHandler(this.handler);
            BigDecimal ocpAmount = new BigDecimal("0");
            BigDecimal logOcpAmount = new BigDecimal("0");
            if (AmortizePattern.Workload.equals((Object)rule.getAmortizePattern())) {
                BigDecimal orgLogAmount;
                BigDecimal orgAmount;
                if (AmortizeOrgTypeEnum.CompanyToCompany.equals((Object)rule.getAmortizeOrgType())) {
                    n = destEntries.size();
                    for (m = 0; m < n; ++m) {
                        destEntry = destEntries.get(m);
                        if (m == n - 1) {
                            accountAmount = totalOut.subtract(ocpAmount);
                            logAmount = logTotal.subtract(logOcpAmount);
                        } else {
                            String companyId = destEntry.getCompany().getId().toString();
                            orgAmount = totalOut.multiply((BigDecimal)workLoadMapAll.get(companyId)).divide(workLoadTotal, totalOut.scale(), 4);
                            accountAmount = orgAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, totalOut.scale(), 4);
                            orgLogAmount = logTotal.multiply((BigDecimal)workLoadMapAll.get(companyId)).divide(workLoadTotal, logTotal.scale(), 4);
                            logAmount = orgLogAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, logTotal.scale(), 4);
                        }
                        genDestVoucher.genDestVoucher(this.ctx, rule, destEntry, this.periodNumber, accountAmount, logAmount, logMap, outAmountMap, totalOut);
                        ocpAmount = ocpAmount.add(accountAmount);
                        logOcpAmount = logOcpAmount.add(logAmount);
                    }
                } else {
                    n = destEntries.size();
                    for (m = 0; m < n; ++m) {
                        destEntry = destEntries.get(m);
                        if (m == n - 1) {
                            accountAmount = totalOut.subtract(ocpAmount);
                            logAmount = logTotal.subtract(logOcpAmount);
                        } else {
                            String pcId = destEntry.getProfitCenter().getId().toString();
                            orgAmount = totalOut.multiply((BigDecimal)workLoadMapAll.get(pcId)).divide(workLoadTotal, totalOut.scale(), 4);
                            accountAmount = orgAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, totalOut.scale(), 4);
                            orgLogAmount = logTotal.multiply((BigDecimal)workLoadMapAll.get(pcId)).divide(workLoadTotal, logTotal.scale(), 4);
                            logAmount = orgLogAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, logTotal.scale(), 4);
                        }
                        genDestVoucher.genDestVoucher(this.ctx, rule, destEntry, this.periodNumber, accountAmount, logAmount, logMap, outAmountMap, totalOut);
                        ocpAmount = ocpAmount.add(accountAmount);
                        logOcpAmount = logOcpAmount.add(logAmount);
                    }
                }
            } else {
                n = destEntries.size();
                for (m = 0; m < n; ++m) {
                    destEntry = destEntries.get(m);
                    if (m == n - 1) {
                        accountAmount = totalOut.subtract(ocpAmount);
                        logAmount = logTotal.subtract(logOcpAmount);
                    } else {
                        BigDecimal orgAmount = totalOut.multiply(destEntry.getOrgRatio()).divide(VchAmortUtils.ONE_HUNDRED, totalOut.scale(), 4);
                        accountAmount = orgAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, totalOut.scale(), 4);
                        BigDecimal orgLogAmount = logTotal.multiply(destEntry.getOrgRatio()).divide(VchAmortUtils.ONE_HUNDRED, logTotal.scale(), 4);
                        logAmount = orgLogAmount.multiply(destEntry.getAccountRatio()).divide(VchAmortUtils.ONE_HUNDRED, logTotal.scale(), 4);
                    }
                    genDestVoucher.genDestVoucher(this.ctx, rule, destEntry, this.periodNumber, accountAmount, logAmount, logMap, outAmountMap, totalOut);
                    ocpAmount = ocpAmount.add(accountAmount);
                    logOcpAmount = logOcpAmount.add(logAmount);
                }
            }
            if (this.previewList != null) {
                this.createPreviewData(entry, logMap, this.previewList, AmortizeDcEnum.In);
                continue;
            }
            this.saveVocuherAndLog(rule, logMap);
        }
        if (this.schemeZero) {
            throw new AmortizeSchemeException(AmortizeSchemeException.SCHEMEZERO);
        }
    }

    private void createPreviewData(AmortizeSchemeEntryInfo entry, Map<String, AmortizeLogInfo> logMap, List<Map> previewList, AmortizeDcEnum dc) {
        HashMap<String, String> basePreviewData = new HashMap<String, String>();
        String year = ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaClosePeriodResource", (String)"YEAR", (Locale)this.ctx.getOriginLocale());
        String period = ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaClosePeriodResource", (String)"PERIOD", (Locale)this.ctx.getOriginLocale());
        AmortizeRuleInfo ruleInfo = entry.getAmortizeRule();
        basePreviewData.put("company_name", this.schemeInfo.getCompany().getName());
        basePreviewData.put("id", this.schemeInfo.getId().toString());
        basePreviewData.put("scheme_id", this.schemeInfo.getId().toString());
        basePreviewData.put("scheme_number", this.schemeInfo.getNumber());
        basePreviewData.put("scheme_name", this.schemeInfo.getName());
        basePreviewData.put("period", this.periodNumber / 100 + year + this.periodNumber % 100 + period);
        basePreviewData.put("amortizeRule_id", ruleInfo.getId().toString());
        basePreviewData.put("amortizeRule_number", ruleInfo.getNumber());
        basePreviewData.put("amortizeRule_name", ruleInfo.getName());
        basePreviewData.put("dc", dc.getAlias());
        EntryDC edc = EntryDC.CREDIT;
        if (AmortizeDcEnum.In.equals((Object)dc)) {
            edc = EntryDC.DEBIT;
        }
        boolean ruleZero = true;
        Collection<AmortizeLogInfo> logs = logMap.values();
        for (AmortizeLogInfo logInfo : logs) {
            logInfo.setAmortizeScheme(this.schemeInfo);
            logInfo.setCompany(this.schemeInfo.getCompany());
            PcVoucherInfo vchInfo = null;
            if (this.isZeroVoucher(logInfo)) continue;
            this.schemeZero = false;
            ruleZero = false;
            if (logInfo.getPcVoucher() != null) {
                vchInfo = logInfo.getPcVoucher();
                basePreviewData.put("amortize_org", logInfo.getPcVoucher().getProfitCenter().getName());
            } else if (logInfo.getVoucher() != null) {
                vchInfo = logInfo.getVoucher();
                basePreviewData.put("amortize_org", logInfo.getVoucher().getCompany().getName());
            } else {
                basePreviewData.put("amortize_org", logInfo.getAmortizeCompany().getName());
            }
            HashMap<String, Object> previewData = new HashMap<String, Object>(basePreviewData);
            previewData.put("data.id", BOSUuid.create((String)"abcd"));
            previewData.put("amount", GlUtils.formatNumber((BigDecimal)logInfo.getAmount()));
            previewList.add(previewData);
        }
        if (ruleZero) {
            HashMap<String, Object> previewData = new HashMap<String, Object>(basePreviewData);
            previewData.put("data.id", BOSUuid.create((String)"abcd"));
            previewData.put("dc", null);
            previewData.put("amount", ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"NO_BALANCE", (Locale)this.ctx.getOriginLocale()));
            previewList.add(previewData);
        }
        logMap.clear();
    }

    private void saveVocuherAndLog(AmortizeRuleInfo rule, Map<String, AmortizeLogInfo> logMap) throws BOSException, EASBizException {
        AmortizeLogInfo logInfo;
        Collection<AmortizeLogInfo> logs = logMap.values();
        Iterator<AmortizeLogInfo> logIt = logs.iterator();
        boolean ruleZero = true;
        while (logIt.hasNext()) {
            logInfo = logIt.next();
            logInfo.setAmortizeScheme(this.schemeInfo);
            logInfo.setCompany(this.schemeInfo.getCompany());
            if (this.isZeroVoucher(logInfo)) continue;
            this.schemeZero = false;
            ruleZero = false;
            if (logInfo.getPcVoucher() != null) {
                logInfo.getPcVoucher().setSourceBillId(this.schemeInfo.getId().toString());
                try {
                    PcVoucherFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)logInfo.getPcVoucher());
                }
                catch (EASBizException e) {
                    throw new AmortizeSchemeException(AmortizeSchemeException.VOUCHERPREFIX, new Object[]{logInfo.getPcVoucher().getProfitCenter().getName(), e.getMessage()});
                }
            }
            if (logInfo.getVoucher() != null) {
                logInfo.getVoucher().setSourceBillId(this.schemeInfo.getId().toString());
                try {
                    VoucherFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)logInfo.getVoucher());
                }
                catch (EASBizException e) {
                    throw new AmortizeSchemeException(AmortizeSchemeException.VOUCHERPREFIX, new Object[]{logInfo.getVoucher().getCompany().getName(), e.getMessage()});
                }
            }
            AmortizeLogFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)logInfo);
        }
        if (ruleZero && (logIt = logs.iterator()).hasNext()) {
            logInfo = logIt.next();
            logInfo.setAmortizeScheme(this.schemeInfo);
            logInfo.setCompany(this.schemeInfo.getCompany());
            logInfo.setAmortizeCompany(null);
            logInfo.setAmortizeProfitCenter(null);
            logInfo.setAmortizeDC(null);
            logInfo.setCurrency(null);
            logInfo.setAmount(null);
            AmortizeLogFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)logInfo);
        }
        logMap.clear();
    }

    private boolean isZeroVoucher(AmortizeLogInfo logInfo) {
        if (logInfo.getPcVoucher() != null) {
            PcVoucherInfo pcVoucher = logInfo.getPcVoucher();
            if (pcVoucher.getLocalCreditAmount() != null && pcVoucher.getLocalCreditAmount().signum() != 0 || pcVoucher.getLocalDebitAmount() != null && pcVoucher.getLocalDebitAmount().signum() != 0) {
                return false;
            }
            PcVoucherEntryCollection peColl = pcVoucher.getEntries();
            int j = peColl.size();
            for (int i = 0; i < j; ++i) {
                PcVoucherEntryInfo entryInfo = peColl.get(i);
                PcVoucherAssistRecordCollection assistRecords = entryInfo.getAssistRecords();
                if (assistRecords == null || assistRecords.size() == 0) {
                    if (entryInfo.getOriginalAmount().signum() == 0) continue;
                    return false;
                }
                int n = assistRecords.size();
                for (int m = 0; m < n; ++m) {
                    PcVoucherAssistRecordInfo recInfo = assistRecords.get(m);
                    if (recInfo.getOriginalAmount().signum() == 0) continue;
                    return false;
                }
            }
        } else if (logInfo.getVoucher() != null) {
            VoucherInfo voucher = logInfo.getVoucher();
            if (voucher.getLocalCreditAmount() != null && voucher.getLocalCreditAmount().signum() != 0 || voucher.getLocalDebitAmount() != null && voucher.getLocalDebitAmount().signum() != 0) {
                return false;
            }
            VoucherEntryCollection peColl = voucher.getEntries();
            int j = peColl.size();
            for (int i = 0; i < j; ++i) {
                VoucherEntryInfo entryInfo = peColl.get(i);
                VoucherAssistRecordCollection assistRecords = entryInfo.getAssistRecords();
                if (assistRecords == null || assistRecords.size() == 0) {
                    if (entryInfo.getOriginalAmount().signum() == 0) continue;
                    return false;
                }
                int n = assistRecords.size();
                for (int m = 0; m < n; ++m) {
                    VoucherAssistRecordInfo recInfo = assistRecords.get(m);
                    if (recInfo.getOriginalAmount().signum() == 0) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

