/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.common.GLOrgUtil;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.ma.pca.AmortizePeriodType;
import com.kingdee.eas.ma.pca.AmortizeRuleInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AmortizeSchemeGenVoucherHandler {
    protected Map<String, VoucherInfo.ExchangeRateWithValue> exchangeRateCache = new HashMap<String, VoucherInfo.ExchangeRateWithValue>();
    protected Map<String, PeriodInfo> periodCache = new HashMap<String, PeriodInfo>();

    protected BigDecimal exchangeCurrency(BigDecimal exchangeRate, CurrencyInfo destCurrency, BigDecimal origAmt) {
        return GlUtils.getScaleBigDecimal((BigDecimal)origAmt.multiply(exchangeRate), (int)destCurrency.getPrecision());
    }

    protected PeriodInfo getPeriod(Context ctx, CompanyOrgUnitInfo company, int periodNumber) throws EASBizException, BOSException {
        String key = company.getId().toString();
        if (this.periodCache.get(key) != null) {
            return this.periodCache.get(key);
        }
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)(periodNumber / 100), (int)(periodNumber % 100), (CompanyOrgUnitInfo)company);
        this.periodCache.put(key, period);
        return period;
    }

    protected void checkAssitInfo(Context ctx, String asstGrpid, String companyId, String userId, boolean isOrgPermission, boolean isChooseAsstCom) throws BOSException, EASBizException {
        String fnameloc = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select fid," + fnameloc + ",fmappingfieldname,frealtiondataobject,FasstHGAttribute from t_bd_asstacttype  where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail \twhere \tfasstaccountid =(select fasstaccountid from t_bd_assistanthg where fid=?) )";
        String freeze = null;
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstGrpid});
            while (rowset != null && rowset.next()) {
                String sql3;
                IRowSet rowset3;
                String fid2;
                String sql2;
                IRowSet rowset2;
                String fname = rowset.getString(fnameloc);
                String fmappingfieldname = rowset.getString("fmappingfieldname");
                String frealtiondataobject = rowset.getString("frealtiondataobject");
                String asstHGAttribute = rowset.getString("FasstHGAttribute");
                int isAsstValueDC = 1;
                if (asstHGAttribute.equals("customer")) {
                    freeze = "FUsedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("provider")) {
                    freeze = "FUsedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("material")) {
                    freeze = "FStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("person")) {
                    freeze = "FDeletedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("ntType")) {
                    freeze = "FIsUsed";
                } else if (asstHGAttribute.equals("innerAccount")) {
                    freeze = "FIsUsed";
                } else if (asstHGAttribute.equals("")) {
                    freeze = null;
                } else if (asstHGAttribute.startsWith("generalAssActType")) {
                    freeze = "FIsEnabled";
                } else if (asstHGAttribute.startsWith("bankAccount")) {
                    freeze = "FIsClosed";
                } else if (asstHGAttribute.equals("region")) {
                    freeze = "FDeletedStatus";
                    isAsstValueDC = 2;
                } else if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg") || asstHGAttribute.equals("adminOrg")) {
                    freeze = "FIsSealUp";
                    isAsstValueDC = 0;
                } else {
                    freeze = null;
                }
                if (freeze == null || (rowset2 = DbUtil.executeQuery((Context)ctx, (String)(sql2 = "select " + fmappingfieldname + " from t_bd_assistanthg where fid =?"), (Object[])new Object[]{asstGrpid})) == null || !rowset2.next() || (fid2 = rowset2.getString(fmappingfieldname)) == null || (rowset3 = DbUtil.executeQuery((Context)ctx, (String)(sql3 = "select " + fnameloc + "," + freeze + ", fnumber from " + frealtiondataobject + " where fid=?"), (Object[])new Object[]{fid2})) == null || !rowset3.next()) continue;
                int state = rowset3.getInt(freeze);
                if (isAsstValueDC == 0) {
                    state = 1 - state;
                } else if (isAsstValueDC == 2) {
                    state = 2 - state;
                }
                if (!asstHGAttribute.startsWith("bankAccount") && state == 0 || asstHGAttribute.startsWith("bankAccount") && state == 1) {
                    if (asstHGAttribute.startsWith("bankAccount")) {
                        throw new VoucherException(VoucherException.VOUCHERBANDDISABLE, (Object[])new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                    }
                    if (asstHGAttribute.equals("region")) {
                        throw new VoucherException(new NumericExceptionSubItem("999", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"533_GLGeneralFacadeControllerBean", (Locale)ctx.getLocale())), (Object[])new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                    }
                    throw new VoucherException(VoucherException.VOUCHERASSTFREESED, (Object[])new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                }
                AssistCuSuStatusValidator cusuValidator = null;
                int result = 0;
                if (asstHGAttribute.equals("customer")) {
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(ctx);
                    }
                    result = cusuValidator.customerValidator(fid2, companyId);
                } else if (asstHGAttribute.equals("provider")) {
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(ctx);
                    }
                    result = cusuValidator.supplierValidator(fid2, companyId);
                }
                if (result == 1) {
                    throw new VoucherException(VoucherException.VOUCHERASSTFREESED, (Object[])new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
                }
                if (!asstHGAttribute.equals("saleOrg") && !asstHGAttribute.equals("profitOrg") && !asstHGAttribute.equals("purchaseOrg") && !asstHGAttribute.equals("storeageOrg") && !asstHGAttribute.equals("adminOrg") && !asstHGAttribute.equals("costOrg") || GLOrgUtil.isOrgValid((Context)ctx, (String)asstHGAttribute, (String)fid2, (String)companyId, (String)userId, (boolean)isChooseAsstCom, (boolean)isOrgPermission)) continue;
                throw new VoucherException(VoucherException.VOUCHERASSTFREESED, (Object[])new String[]{fname + "(" + rowset3.getString(fnameloc) + ")"});
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    protected BigDecimal getCurrencyToLocExchangeRate(Context ctx, CurrencyInfo srcCurrency, PeriodInfo period, CompanyOrgUnitInfo company, Date endDate) throws BOSException, EASBizException {
        String schemeToLocKey = srcCurrency.getId().toString() + company.getBaseCurrency().getId().toString();
        VoucherInfo.ExchangeRateWithValue schemeToLocRateValue = this.exchangeRateCache.get(schemeToLocKey);
        if (schemeToLocRateValue == null) {
            schemeToLocRateValue = GlUtils.getLocalCurrencyExchangeRate((Context)ctx, (String)srcCurrency.getId().toString(), (CompanyOrgUnitInfo)company, (PeriodInfo)period, (Date)endDate);
            this.exchangeRateCache.put(schemeToLocKey, schemeToLocRateValue);
        }
        return schemeToLocRateValue.getValue().setScale(schemeToLocRateValue.getPresion());
    }

    protected BigDecimal getCurrencyToRptExchangeRate(Context ctx, CurrencyInfo srcCurrency, PeriodInfo period, CompanyOrgUnitInfo company, Date endDate) throws BOSException, EASBizException {
        String schemeToRptKey = srcCurrency.getId().toString() + company.getReportCurrency().getId().toString();
        VoucherInfo.ExchangeRateWithValue schemeToRptRateValue = this.exchangeRateCache.get(schemeToRptKey);
        if (schemeToRptRateValue == null) {
            schemeToRptRateValue = GlUtils.getRptCurrencyExchangeRate((Context)ctx, (String)srcCurrency.getId().toString(), (CompanyOrgUnitInfo)company, (PeriodInfo)period, (Date)endDate);
            this.exchangeRateCache.put(schemeToRptKey, schemeToRptRateValue);
        }
        return schemeToRptRateValue.getValue().setScale(schemeToRptRateValue.getPresion());
    }

    protected int getRealPeriodNumber(Context ctx, int periodNumber, AmortizeRuleInfo rule, CompanyOrgUnitInfo company, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        PeriodInfo dataPeriod = null;
        if (AmortizePeriodType.ExecutePeriod.equals((Object)rule.getPeriodType())) {
            dataPeriod = new PeriodInfo();
            dataPeriod.setPeriodNumber(periodNumber % 100);
            dataPeriod.setNumber(periodNumber);
            dataPeriod.setPeriodYear(periodNumber / 100);
        } else {
            dataPeriod = currentPeriod;
        }
        int shift = rule.getPeriodShift();
        int dataNumber = dataPeriod.getPeriodNumber();
        int dataPeriodNumber = dataPeriod.getNumber();
        if (shift > 0) {
            if (dataNumber + shift <= 12) {
                dataPeriodNumber = dataPeriod.getPeriodYear() * 100 + (dataNumber + shift);
            } else {
                PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)dataPeriod.getPeriodYear(), (int)12, (CompanyOrgUnitInfo)company);
                for (int i = 0; i < dataNumber + shift - 12; ++i) {
                    pInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)pInfo);
                }
                dataPeriodNumber = pInfo.getNumber();
            }
        } else if (shift < 0) {
            if (dataNumber + shift > 0) {
                dataPeriodNumber = dataPeriod.getPeriodYear() * 100 + (dataNumber + shift);
            } else {
                PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)dataPeriod.getPeriodYear(), (int)1, (CompanyOrgUnitInfo)company);
                for (int i = dataNumber + shift; i <= 0; ++i) {
                    pInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)pInfo);
                }
                dataPeriodNumber = pInfo.getNumber();
            }
        }
        return dataPeriodNumber;
    }
}

