/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryFactory;
import com.kingdee.eas.ma.pca.AmortizeStandDataEntryInfo;
import com.kingdee.eas.ma.pca.AmortizeStandDataInfo;
import com.kingdee.eas.ma.pca.IAmortizeStandDataEntry;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeStandDataControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AmortizeStandDataControllerBean
extends AbstractAmortizeStandDataControllerBean {
    private static final long serialVersionUID = -7508943748146610468L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.AmortizeStandDataControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AmortizeStandDataInfo info = (AmortizeStandDataInfo)model;
        return this._submitInternal(ctx, info);
    }

    protected IObjectPK _submitInternal(Context ctx, AmortizeStandDataInfo dataInfo) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, (IObjectValue)dataInfo);
        dataInfo.put("id", pk.getKeyValue("id"));
        Iterator iteratorEntry = dataInfo.getEntries().iterator();
        IAmortizeStandDataEntry dataEntry = AmortizeStandDataEntryFactory.getLocalInstance(ctx);
        this.deleteAllEntries(ctx, pk.toString());
        while (iteratorEntry.hasNext()) {
            AmortizeStandDataEntryInfo entryInfo = (AmortizeStandDataEntryInfo)iteratorEntry.next();
            entryInfo.setBill(dataInfo);
            dataEntry.submit((CoreBaseInfo)entryInfo);
        }
        return pk;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    protected void deleteAllEntries(Context ctx, String amortizeStandID) throws BOSException, EASBizException {
        String sbSql = "delete from T_PCA_AmortizeStandDataEntry where FBillID = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            ps.setString(1, amortizeStandID);
            sbSql = null;
            ps.executeUpdate();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteAllEntries(ctx, pk.toString());
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._getValue(ctx, pk, this.getDefaultSelector());
    }

    public SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longNumber"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.CU.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.reportCurrency.id"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("company.accountPeriodType.id"));
        sic.add(new SelectorItemInfo("company.accountPeriodType.number"));
        sic.add(new SelectorItemInfo("company.accountPeriodType.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("period.periodType.id"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.id"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.number"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.name"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.description"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.amortizeStand.measureUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.company.id"));
        sic.add(new SelectorItemInfo("entries.company.number"));
        sic.add(new SelectorItemInfo("entries.company.longNumber"));
        sic.add(new SelectorItemInfo("entries.company.name"));
        sic.add(new SelectorItemInfo("entries.company.CU.id"));
        sic.add(new SelectorItemInfo("entries.company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entries.company.reportCurrency.id"));
        sic.add(new SelectorItemInfo("entries.company.accountTable.id"));
        sic.add(new SelectorItemInfo("entries.company.accountPeriodType.id"));
        sic.add(new SelectorItemInfo("entries.company.accountPeriodType.number"));
        sic.add(new SelectorItemInfo("entries.company.accountPeriodType.name"));
        sic.add(new SelectorItemInfo("entries.profitCenter.id"));
        sic.add(new SelectorItemInfo("entries.profitCenter.number"));
        sic.add(new SelectorItemInfo("entries.profitCenter.name"));
        sic.add(new SelectorItemInfo("entries.profitCenter.CU.id"));
        return sic;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this.getAmortizeStandDataInternal(ctx, pk, selector);
    }

    private AmortizeStandDataInfo getAmortizeStandDataInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)selector);
        AmortizeStandDataInfo info = null;
        info = (AmortizeStandDataInfo)super._getValue(ctx, pk, sic);
        return info;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AmortizeStandDataInfo info = (AmortizeStandDataInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }
}

