/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.pca.AmortizeStandFactory;
import com.kingdee.eas.ma.pca.IAmortizeStand;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.app.AbstractAmortizeStandTypeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AmortizeStandTypeControllerBean
extends AbstractAmortizeStandTypeControllerBean {
    private static final long serialVersionUID = 5180064492572208328L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.AmortizeStandTypeControllerBean");

    @Override
    protected boolean _exists(Context ctx, String oql) throws BOSException, EASBizException {
        boolean exist = false;
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 1 FROM T_PCA_AmortizeStandType where FName_").append(ctx.getLocale()).append("=? ");
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql.toString());
            psStmt.setString(1, sql.toString());
            rs = psStmt.executeQuery();
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return exist;
    }

    protected void canDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = pk.toString();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("amortizeStandType.id", (Object)id));
        filter.setMaskString("#0");
        IAmortizeStand ctrl = AmortizeStandFactory.getLocalInstance(ctx);
        boolean canDelete = ctrl.exists(filter);
        if (canDelete) {
            throw new PcaException(PcaException.CANAMORTIZESTANDTYPE);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.canDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        this.checkNameDup(ctx, (DataBaseInfo)model);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        this.checkNameDup(ctx, (DataBaseInfo)model);
        return super._save(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("name", (Object)treeModel.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0");
        if (treeModel.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new PcaException(PcaException.NAMEEXIST);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0");
        if (treeModel.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new PcaException(PcaException.NUMBEREXIST);
        }
    }
}

