/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowInitException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.pca.app.AbstractCashflowInitService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CashflowInitCheckAsstIsEqualService
extends AbstractCashflowInitService {
    public CashflowInitCheckAsstIsEqualService(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter) {
        super(ctx, company, profitCenter);
    }

    public void check() throws EASBizException, BOSException {
        List items = this.getInitItemWithGsst(this.ctx);
        for (Object[] obj : items) {
            BigDecimal[] asstAmount = this.getAsstValue(this.ctx, obj[0].toString());
            int precision = Integer.parseInt(obj[5].toString());
            String currencyName = obj[4].toString();
            String itemName = obj[6] + "";
            BigDecimal bdOriginalAmount = ((BigDecimal)obj[1]).setScale(precision, 1);
            BigDecimal bdLocalAmount = ((BigDecimal)obj[2]).setScale(precision, 1);
            BigDecimal bdRptAmount = ((BigDecimal)obj[3]).setScale(precision, 1);
            BigDecimal asstOriginalAmount = asstAmount[0].setScale(precision, 1);
            BigDecimal asstLocalAmount = asstAmount[1].setScale(precision, 1);
            BigDecimal asstReportAmount = asstAmount[2].setScale(precision, 1);
            if (bdOriginalAmount.compareTo(asstOriginalAmount) != 0) {
                Object[] params = new Object[]{currencyName, GlUtils.formatNumber((BigDecimal)bdOriginalAmount, (int)precision), GlUtils.formatNumber((BigDecimal)asstOriginalAmount, (int)precision), itemName};
                throw new CashFlowInitException(CashFlowInitException.ASST_ORIGINAL_NOT_EQUAL, params);
            }
            if (bdLocalAmount.compareTo(asstLocalAmount) != 0) {
                Object[] params = new Object[]{currencyName, GlUtils.formatNumber((BigDecimal)bdLocalAmount, (int)precision), GlUtils.formatNumber((BigDecimal)asstLocalAmount, (int)precision), itemName};
                throw new CashFlowInitException(CashFlowInitException.ASST_LOCALL_NOT_EQUAL, params);
            }
            if (bdRptAmount.compareTo(asstReportAmount) == 0) continue;
            Object[] params = new Object[]{currencyName, GlUtils.formatNumber((BigDecimal)bdRptAmount, (int)precision), GlUtils.formatNumber((BigDecimal)asstReportAmount, (int)precision), itemName};
            throw new CashFlowInitException(CashFlowInitException.ASST_REPORT_NOT_EQUAL, params);
        }
    }

    private List getInitItemWithGsst(Context ctx) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer(" select FName_");
        sbSql.append(ctx.getLocale());
        sbSql.append(" cfItemName,FInitid ,FCashflowItemID ,foriginalamount,FLocalAmount,freportingamount, curname,Fprecision FROM T_BD_CashFlowItem cfi");
        sbSql.append(" INNER JOIN ( SELECT cinit.fid FInitid,FCashflowItemID  , curname ,Fprecision, FOriginalAmount,   FLocalAmount,  FReportingAmount");
        sbSql.append(" FROM T_Pca_pcCashflowInit   cinit ");
        sbSql.append(" inner join ( select fid,fname_");
        sbSql.append(ctx.getLocale());
        sbSql.append("  curname,Fprecision from t_bd_currency ) cur on cinit.fcurrencyid = cur.fid");
        sbSql.append("  WHERE   FProfitCenterID = ?) cfit");
        sbSql.append(" ON cfi.fid = cfit.FCashflowItemID where cfi.FIsEnable=1 and FAsstAccountID is not null");
        Object[] params = null;
        params = new Object[]{this.profitCenter.getId().toString()};
        ArrayList<Object[]> items = new ArrayList<Object[]>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                Object[] obj = new Object[]{rs.getString("FInitid"), rs.getBigDecimal("foriginalamount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount"), rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount"), rs.getBigDecimal("freportingamount") == null ? ZERO : rs.getBigDecimal("freportingamount"), rs.getString("curname"), rs.getString("Fprecision"), rs.getString("cfItemName")};
                items.add(obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return items;
    }

    private BigDecimal[] getAsstValue(Context ctx, String cFlowInitID) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer(" SELECT  sum(FOriginalAmount) FOriginalAmount, sum(FLocalAmount) FLocalAmount, sum(FReportingAmount) FReportingAmount ");
        sbSql.append(" FROM T_Pca_PcCashflowGrpAsst");
        sbSql.append(" WHERE FCflowInitID = ?");
        Object[] params = null;
        params = new Object[]{cFlowInitID};
        BigDecimal[] obj = new BigDecimal[]{ZERO, ZERO, ZERO};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            if (rs.next()) {
                obj[0] = rs.getBigDecimal("FOriginalAmount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount");
                obj[1] = rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount");
                obj[2] = rs.getBigDecimal("FReportingAmount") == null ? ZERO : rs.getBigDecimal("FReportingAmount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return obj;
    }
}

