/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.app.AbstractCashflowInitService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CashflowInitListDataService
extends AbstractCashflowInitService {
    CurrencyInfo currencyInfo;

    public CashflowInitListDataService(Context ctx, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter) {
        super(ctx, company, profitCenter);
        this.currencyInfo = currencyInfo;
    }

    public List getData() throws EASBizException, BOSException {
        CurrencyCollection currencyCollection = new CurrencyCollection();
        currencyCollection.add(this.currencyInfo);
        Map balance = this.getCashBalance(this.ctx, currencyCollection);
        List ltItem = this.selectDataFromDB(this.ctx, (IObjectValue)this.currencyInfo, 0);
        if (!ltItem.isEmpty()) {
            ltItem = this.formatAddSpace(this.ctx, ltItem, (IObjectValue)this.currencyInfo, (AbstractCashflowInitService.QueryData[])balance.get(this.currencyInfo.getId()));
        }
        ltItem.addAll(this.formatSeconary(this.ctx, this.selectDataFromDB(this.ctx, (IObjectValue)this.currencyInfo, 1), (IObjectValue)this.currencyInfo));
        ltItem.addAll(this.selectDataFromDB(this.ctx, (IObjectValue)this.currencyInfo, 2));
        if (!ltItem.isEmpty()) {
            this.addCashSum(this.ctx, ltItem, (IObjectValue)this.currencyInfo, (AbstractCashflowInitService.QueryData[])balance.get(this.currencyInfo.getId()));
            ltItem = this.formatSeq(this.ctx, ltItem);
        }
        return ltItem;
    }

    private List selectDataFromDB(Context ctx, IObjectValue curInfo, int itemType) throws BOSException, EASBizException {
        ArrayList<Object[]> ltItem = new ArrayList<Object[]>();
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        String generalLocal = null;
        String generalReport = null;
        StringBuffer sbSql = new StringBuffer();
        generalLocal = this.getGeneralLocalCurrency();
        generalReport = this.getGeneralReportCurrency();
        StringBuffer sbFName = new StringBuffer(" cfi.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        sbSql.append(" SELECT cfi.FId FidItem,  cfi.FLongNumber \t\t\tFLongNumber, \r\n");
        sbSql.append(sbFName);
        sbSql.append(" \t\t\t\t\t\tFName,  cfi.FType \t\t\t\tFType,  cfi.FIsFreeze \t\t\tFIsFreeze,  cfi.FIsDealActivity \t\tFIsDealActivity,  cfi.FDirection \t\t\tFDirection,  cfi.FIsProfit \t\t\tFIsProfit,  cfi.FIsEnable \t\t\tFIsEnable, cfi.FIsExChange \t\t\tFIsExChange,  cfi.FAsstAccountID\t\tFAsstAccountID,  cfi.FIsLeaf \t\t\t\tFIsLeaf,  cfi.FLevel \t\t\t\tFLevel, \r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" cfit.Fid\t\t\tFidInit, \r\n");
        }
        sbSql.append(" cfit.FSeq \t\t\tFSeq, \r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" cfit.FCurrencyID FCurrencyID, \r\n");
        }
        sbSql.append(" cfit.FOriginalAmount FOriginalAmount,  cfit.FLocalAmount \t\tFLocalAmount,  cfit.FReportingAmount \tFReportingAmount, cfit.FCompanyID \t\t\tFCompanyID , cfit.FprofitcenterID \t\t\tFprofitcenterID \r\n");
        sbSql.append(" FROM T_BD_CashFlowItem cfi \t\t\t\r\n");
        sbSql.append(" LEFT OUTER JOIN (\t\t\t\t\t\r\n");
        sbSql.append(" SELECT FCashflowItemID, \t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" Fid,\t\t\t\t\t\t\t\t\r\n");
        }
        sbSql.append(" FSeq,\t\t\t\t\t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" FCurrencyID,\t FOriginalAmount, FLocalAmount, FReportingAmount,\t\t\t\t\t\t\r\n");
        } else {
            sbSql.append(" SUM(FOriginalAmount) FOriginalAmount,  SUM(FLocalAmount) FLocalAmount, SUM(FReportingAmount) FReportingAmount, \r\n");
        }
        sbSql.append(" FCompanyID,FprofitcenterID  \t\t\t\r\n");
        sbSql.append(" FROM T_pca_pcCashflowInit \t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" WHERE FCurrencyID = ? AND FprofitcenterID = ? ) cfit \r\n");
        } else {
            sbSql.append(" WHERE FprofitcenterID = ?  GROUP BY FCashflowItemID,  FSeq, FCompanyID,FprofitcenterID\t) cfit \t\t\t\t\t\r\n");
        }
        sbSql.append(" ON cfi.fid = cfit.FCashflowItemID \t\r\n");
        sbSql.append(" WHERE cfi.FType = ");
        sbSql.append(itemType);
        sbSql.append(" ORDER BY cfi.FType, cfi.FLongNumber  \r\n");
        Object[] obj = null;
        int iComma = 0;
        int n = sbSql.toString().length();
        for (int i = 0; i < n; ++i) {
            if (sbSql.toString().charAt(i) != ',') continue;
            ++iComma;
        }
        Object[] params = null;
        params = !curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport) ? new Object[]{curinfo.getId().toString(), this.profitCenter.getId().toString()} : new Object[]{this.profitCenter.getId().toString()};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                obj = new Object[iComma + 1];
                obj[0] = rs.getString("FidItem");
                obj[1] = rs.getString("FLongNumber");
                obj[2] = rs.getString("FName");
                obj[3] = rs.getString("FType");
                obj[4] = rs.getString("FIsFreeze");
                obj[5] = rs.getString("FIsDealActivity");
                obj[6] = new Integer(rs.getInt("FDirection"));
                obj[7] = new Integer(rs.getInt("FIsProfit"));
                obj[8] = new Integer(rs.getInt("FIsEnable"));
                obj[9] = new Integer(rs.getInt("FIsExChange"));
                obj[10] = rs.getString("FAsstAccountID");
                obj[11] = new Integer(rs.getInt("FisLeaf"));
                obj[12] = new Integer(rs.getInt("FLevel"));
                if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
                    obj[13] = rs.getString("FidInit");
                }
                obj[14] = new Integer(rs.getInt("FSeq"));
                if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
                    obj[15] = rs.getString("FCurrencyID");
                }
                obj[16] = rs.getBigDecimal("FOriginalAmount");
                obj[17] = rs.getBigDecimal("FLocalAmount");
                obj[18] = rs.getBigDecimal("FReportingAmount");
                obj[19] = rs.getString("FprofitcenterID");
                ltItem.add(obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ltItem;
    }

    private List formatAddSpace(Context ctx, List ltItem, IObjectValue curInfo, AbstractCashflowInitService.QueryData[] balance) throws EASBizException, BOSException {
        if (ltItem == null || ltItem.size() == 0 || ltItem.get(0) == null) {
            return new ArrayList();
        }
        ArrayList<Object[]> ltItemReturn = new ArrayList<Object[]>();
        CashFlowItemCollection col = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection("select level order by level desc");
        int maxLevel = col.get(0).getLevel();
        BigDecimal bdSubtotalOriginal = ZERO;
        BigDecimal bdSubtotalLocal = ZERO;
        BigDecimal bdSubtotalReporting = ZERO;
        BigDecimal bdInSumOriginal = ZERO;
        BigDecimal bdInSumLocal = ZERO;
        BigDecimal bdInSumReporting = ZERO;
        BigDecimal bdOutSumOriginal = ZERO;
        BigDecimal bdOutSumLocal = ZERO;
        BigDecimal bdOutSumReporting = ZERO;
        BigDecimal bdCashSumOriginal = ZERO;
        BigDecimal bdCashSumLocal = ZERO;
        BigDecimal bdCashSumReporting = ZERO;
        BigDecimal cashSumOriginal = ZERO;
        BigDecimal cashSumLocal = ZERO;
        BigDecimal cashSumReport = ZERO;
        int iLevel = 1;
        Object[] objItem = null;
        Object[] objData = null;
        String cflowItemName = null;
        int thisDirection = 0;
        int thisIsLeaf = 0;
        int thisLevel = 0;
        String purge = null;
        Object objCashflowItemID = null;
        int n = ltItem.size();
        for (int i = 0; i < n; ++i) {
            objItem = (Object[])ltItem.get(i);
            objData = (Object[])objItem.clone();
            cflowItemName = objItem[2] != null ? objItem[2].toString() : "";
            thisDirection = (Integer)objItem[6];
            thisIsLeaf = (Integer)objItem[11];
            thisLevel = (Integer)objItem[12];
            BigDecimal bdOriginal = objItem[16] == null ? ZERO : (BigDecimal)objItem[16];
            BigDecimal bdLocal = objItem[17] == null ? ZERO : (BigDecimal)objItem[17];
            BigDecimal bdReporting = objItem[18] == null ? ZERO : (BigDecimal)objItem[18];
            ltItemReturn.add(objData);
            if (thisLevel == 1) {
                objData[2] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.CashflowInitResource", (String)String.valueOf(iLevel++), (Locale)ctx.getLocale()) + this.getBlankString(thisLevel) + cflowItemName;
                purge = cflowItemName;
            } else {
                objData[2] = this.getBlankString(thisLevel) + cflowItemName;
            }
            if (thisIsLeaf == 0 && thisLevel == 1) {
                objCashflowItemID = objData[0];
            }
            if (thisDirection != 0) {
                if (thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) {
                    bdSubtotalOriginal = bdSubtotalOriginal.add(bdOriginal);
                    bdSubtotalLocal = bdSubtotalLocal.add(bdLocal);
                    bdSubtotalReporting = bdSubtotalReporting.add(bdReporting);
                }
                if (i + 1 == ltItem.size() || (Integer)((Object[])ltItem.get(i + 1))[6] != thisDirection) {
                    Object[] objSubtotal = (Object[])objItem.clone();
                    objSubtotal[2] = thisDirection == 1 ? this.getBlankString(thisLevel) + this.getResource(ctx, "strInTotal") : this.getBlankString(thisLevel) + this.getResource(ctx, "strOutTotal");
                    objSubtotal[0] = objCashflowItemID;
                    objSubtotal[11] = this.INTESUB1;
                    objSubtotal[12] = this.INTESUB2;
                    objSubtotal[16] = bdSubtotalOriginal;
                    objSubtotal[17] = bdSubtotalLocal;
                    objSubtotal[18] = bdSubtotalReporting;
                    if (maxLevel != 1) {
                        ltItemReturn.add(objSubtotal);
                    }
                    bdSubtotalOriginal = ZERO;
                    bdSubtotalLocal = ZERO;
                    bdSubtotalReporting = ZERO;
                }
            }
            if (thisLevel == 2 || thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) {
                if (thisDirection == 1) {
                    bdInSumOriginal = bdInSumOriginal.add(bdOriginal);
                    bdInSumLocal = bdInSumLocal.add(bdLocal);
                    bdInSumReporting = bdInSumReporting.add(bdReporting);
                } else if (thisDirection == 2) {
                    bdOutSumOriginal = bdOutSumOriginal.add(bdOriginal);
                    bdOutSumLocal = bdOutSumLocal.add(bdLocal);
                    bdOutSumReporting = bdOutSumReporting.add(bdReporting);
                }
            }
            if (i + 1 != ltItem.size() && (Integer)((Object[])ltItem.get(i + 1))[12] != 1) continue;
            Object[] objPurge = (Object[])objItem.clone();
            objPurge[0] = objCashflowItemID;
            objPurge[2] = this.getBlankString(thisLevel) + this.getSumString(ctx, purge);
            objPurge[11] = this.INTEPURGE1;
            objPurge[12] = this.INTEPURGE2;
            bdCashSumOriginal = bdCashSumOriginal.add(bdInSumOriginal.subtract(bdOutSumOriginal));
            objPurge[16] = bdCashSumOriginal;
            bdCashSumLocal = bdCashSumLocal.add(bdInSumLocal.subtract(bdOutSumLocal));
            objPurge[17] = bdCashSumLocal;
            bdCashSumReporting = bdCashSumReporting.add(bdInSumReporting.subtract(bdOutSumReporting));
            objPurge[18] = bdCashSumReporting;
            if (objPurge[5].toString().equals("1")) {
                objPurge[20] = this.PRIMARYWORK;
            }
            cashSumOriginal = cashSumOriginal.add(bdCashSumOriginal);
            cashSumLocal = cashSumLocal.add(bdCashSumLocal);
            cashSumReport = cashSumReport.add(bdCashSumReporting);
            bdInSumOriginal = ZERO;
            bdInSumLocal = ZERO;
            bdInSumReporting = ZERO;
            bdOutSumOriginal = ZERO;
            bdOutSumLocal = ZERO;
            bdOutSumReporting = ZERO;
            bdCashSumOriginal = ZERO;
            bdCashSumLocal = ZERO;
            bdCashSumReporting = ZERO;
            ltItemReturn.add(objPurge);
        }
        Object[] objCashSum = (Object[])((Object[])ltItem.get(0)).clone();
        objCashSum[2] = this.getResource(ctx, String.valueOf(iLevel++)) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strCashSum", (Locale)ctx.getLocale());
        objCashSum[1] = new Integer(this.lineIndex++);
        objCashSum[16] = cashSumOriginal;
        objCashSum[17] = cashSumLocal;
        objCashSum[18] = cashSumReport;
        objCashSum[4] = Boolean.TRUE;
        objCashSum[11] = this.INTEPURGE1;
        objCashSum[12] = this.INTEPURGE2;
        objCashSum[20] = this.PRIMARYCASH;
        ltItemReturn.add(objCashSum);
        if (objItem != null) {
            objCashSum = (Object[])objItem.clone();
        }
        objCashSum[0] = "";
        objCashSum[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strAddCashAndXjdjwBegin", (Locale)ctx.getLocale());
        objCashSum[1] = new Integer(this.lineIndex++);
        objCashSum[16] = balance[0].getOriginalAmount().add(balance[2].getOriginalAmount());
        objCashSum[17] = balance[0].getLocalAmount().add(balance[2].getLocalAmount());
        objCashSum[18] = balance[0].getReportingAmount().add(balance[2].getReportingAmount());
        objCashSum[4] = Boolean.FALSE;
        objCashSum[11] = this.INTEPURGE1;
        objCashSum[12] = this.INTEPURGE2;
        ltItemReturn.add(objCashSum);
        if (objItem != null) {
            objCashSum = (Object[])objItem.clone();
        }
        objCashSum[0] = "";
        objCashSum[2] = this.getResource(ctx, String.valueOf(iLevel++)) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strCashAndXjdjwEndBanlance", (Locale)ctx.getLocale());
        objCashSum[1] = new Integer(this.lineIndex++);
        objCashSum[16] = balance[1].getOriginalAmount().add(balance[3].getOriginalAmount());
        objCashSum[17] = balance[1].getLocalAmount().add(balance[3].getLocalAmount());
        objCashSum[18] = balance[1].getReportingAmount().add(balance[3].getReportingAmount());
        objCashSum[4] = Boolean.TRUE;
        objCashSum[11] = this.INTEPURGE1;
        objCashSum[12] = this.INTEPURGE2;
        ltItemReturn.add(objCashSum);
        return ltItemReturn;
    }

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.CashflowInitResource", (String)name, (Locale)ctx.getLocale());
    }

    private String getBlankString(int level) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            sbBlank.append("        ");
        }
        return sbBlank.toString();
    }

    private String getSumString(Context ctx, String sumName) {
        StringBuffer sbReturn = new StringBuffer(this.getResource(ctx, "strSum"));
        int pos = sbReturn.indexOf("@");
        if (sumName == null) {
            sumName = "";
        }
        sbReturn.replace(pos, pos + 1, sumName);
        return sbReturn.toString();
    }

    private List formatSeconary(Context ctx, List ltItem, IObjectValue curInfo) throws EASBizException, BOSException {
        if (ltItem == null || ltItem.isEmpty()) {
            return new ArrayList();
        }
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        CurrencyCollection currencyCollection = new CurrencyCollection();
        currencyCollection.add(curinfo);
        Map profit = this.getRetainedProfits(ctx, currencyCollection);
        AbstractCashflowInitService.QueryData profitData = (AbstractCashflowInitService.QueryData)profit.get(curinfo.getId());
        BigDecimal bdTotal = ZERO;
        BigDecimal bdTotalLocal = ZERO;
        BigDecimal bdTotalRpt = ZERO;
        Object[] arrayObj = null;
        int sizeVec = ltItem.size();
        for (int i = 0; i < sizeVec; ++i) {
            arrayObj = (Object[])ltItem.get(i);
            int thisLevel = Integer.parseInt(arrayObj[12].toString());
            if (thisLevel <= 2) {
                arrayObj[2] = this.getBlankString(thisLevel + 1) + arrayObj[2];
                continue;
            }
            arrayObj[2] = this.getBlankString(thisLevel + 1) + arrayObj[2];
            arrayObj[1] = new Integer(this.lineIndex++);
            if (Integer.parseInt(arrayObj[7].toString()) == 1) {
                arrayObj[16] = profitData.getOriginalAmount();
                arrayObj[17] = profitData.getLocalAmount();
                arrayObj[18] = profitData.getReportingAmount();
                arrayObj[11] = this.INTEPURGE1;
                arrayObj[12] = this.INTEPURGE2;
                continue;
            }
            if (arrayObj[16] != null) {
                bdTotal = bdTotal.add((BigDecimal)arrayObj[16]);
            }
            if (arrayObj[17] != null) {
                bdTotalLocal = bdTotalLocal.add((BigDecimal)arrayObj[17]);
            }
            if (arrayObj[18] == null) continue;
            bdTotalRpt = bdTotalRpt.add((BigDecimal)arrayObj[18]);
        }
        if (arrayObj != null) {
            Object[] array5 = (Object[])arrayObj.clone();
            array5[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strWork", (Locale)ctx.getLocale());
            array5[1] = new Integer(this.lineIndex++);
            array5[16] = profitData.getOriginalAmount().add(bdTotal);
            array5[17] = profitData.getLocalAmount().add(bdTotalLocal);
            array5[18] = profitData.getReportingAmount().add(bdTotalRpt);
            array5[4] = Boolean.TRUE;
            array5[11] = this.INTEPURGE1;
            array5[12] = this.INTEPURGE2;
            array5[20] = this.SECONDARYWORK;
            ltItem.add(array5);
        }
        return ltItem;
    }

    private List addCashSum(Context ctx, List ltItem, IObjectValue curInfo, AbstractCashflowInitService.QueryData[] balance) throws BOSException, EASBizException {
        Object[] tempObject = (Object[])ltItem.get(0);
        Object[] array1 = (Object[])tempObject.clone();
        array1[2] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strAdd", (Locale)ctx.getLocale());
        array1[11] = this.INTEPURGE1;
        array1[12] = this.INTEPURGE2;
        array1[16] = null;
        array1[17] = null;
        array1[18] = null;
        ltItem.add(array1);
        Object[] array2 = (Object[])tempObject.clone();
        array2[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strCashEnd", (Locale)ctx.getLocale());
        array2[1] = new Integer(this.lineIndex++);
        array2[16] = balance[1].getOriginalAmount();
        array2[17] = balance[1].getLocalAmount();
        array2[18] = balance[1].getReportingAmount();
        array2[11] = this.INTEPURGE1;
        array2[12] = this.INTEPURGE2;
        ltItem.add(array2);
        Object[] array3 = (Object[])tempObject.clone();
        array3[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strJCahsBegin", (Locale)ctx.getLocale());
        array3[1] = new Integer(this.lineIndex++);
        array3[16] = balance[0].getOriginalAmount();
        array3[17] = balance[0].getLocalAmount();
        array3[18] = balance[0].getReportingAmount();
        array3[11] = this.INTEPURGE1;
        array3[12] = this.INTEPURGE2;
        ltItem.add(array3);
        Object[] array4 = (Object[])tempObject.clone();
        array4[0] = "";
        array4[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strAddSjdjwEnd", (Locale)ctx.getLocale());
        array4[1] = new Integer(this.lineIndex++);
        array4[16] = balance[3].getOriginalAmount();
        array4[17] = balance[3].getLocalAmount();
        array4[18] = balance[3].getReportingAmount();
        array4[11] = this.INTEPURGE1;
        array4[12] = this.INTEPURGE2;
        ltItem.add(array4);
        Object[] array5 = (Object[])tempObject.clone();
        array5[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strJSjdjwEnd", (Locale)ctx.getLocale());
        array5[1] = new Integer(this.lineIndex++);
        array5[16] = balance[2].getOriginalAmount();
        array5[17] = balance[2].getLocalAmount();
        array5[18] = balance[2].getReportingAmount();
        array5[11] = this.INTEPURGE1;
        array5[12] = this.INTEPURGE2;
        ltItem.add(array5);
        Object[] array6 = (Object[])tempObject.clone();
        array6[2] = this.getBlankString(2) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.app.CashFlowDispayResource", (String)"strCashAndXjdjw", (Locale)ctx.getLocale());
        array6[1] = new Integer(this.lineIndex++);
        array6[16] = balance[1].getOriginalAmount().subtract(balance[0].getOriginalAmount()).add(balance[3].getOriginalAmount()).subtract(balance[2].getOriginalAmount());
        array6[17] = balance[1].getLocalAmount().subtract(balance[0].getLocalAmount()).add(balance[3].getLocalAmount()).subtract(balance[2].getLocalAmount());
        array6[18] = balance[1].getReportingAmount().subtract(balance[0].getReportingAmount()).add(balance[3].getReportingAmount()).subtract(balance[2].getReportingAmount());
        array6[11] = this.INTEPURGE1;
        array6[12] = this.INTEPURGE2;
        array6[20] = this.SECONDARYCASH;
        ltItem.add(array6);
        return ltItem;
    }

    private List formatSeq(Context ctx, List ltItem) throws EASBizException, BOSException {
        ArrayList<Object[]> ltItemReturn = new ArrayList<Object[]>();
        Object[] objItem = null;
        Object[] objData = null;
        int iSeq = 1;
        int n = ltItem.size();
        for (int i = 0; i < n; ++i) {
            objItem = (Object[])ltItem.get(i);
            objData = (Object[])objItem.clone();
            int thisLevel = (Integer)objItem[12];
            objData[14] = thisLevel == 1 ? null : new Integer(iSeq++);
            ltItemReturn.add(objData);
        }
        return ltItemReturn;
    }
}

