/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowInitException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.ma.pca.app.AbstractCashflowInitService;
import com.kingdee.eas.ma.pca.app.CashflowInitCheckAsstIsEqualService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CashfowInitCheckService
extends AbstractCashflowInitService {
    public CashfowInitCheckService(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter) {
        super(ctx, company, profitCenter);
    }

    public void check() throws CashFlowInitException, EASBizException, BOSException {
        CurrencyCollection curCol = this.getCurrency(this.ctx, this.company);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        Map hmParamValue = InitHelp.getInitParam((Context)this.ctx, (CompanyOrgUnitInfo)this.company);
        boolean isForeignCurrency = (Boolean)hmParamValue.get("GL_008");
        this.checkSupItem(this.ctx, curCol, isForeignCurrency);
        this.checkMasterItem(this.ctx, curCol, isForeignCurrency);
        CashflowInitCheckAsstIsEqualService service = new CashflowInitCheckAsstIsEqualService(this.ctx, this.company, this.profitCenter);
        service.check();
    }

    private void checkMasterItem(Context ctx, CurrencyCollection curCol, boolean isForeignCurrency) throws BOSException, EASBizException, CashFlowInitException {
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean isGeneralLocal = false;
        boolean isGeneralReport = false;
        Map primaryCash = this.selectWorkDataFromDB(ctx, curCol, 0, 0);
        Map balance = this.getCashBalance(ctx, curCol);
        AbstractCashflowInitService.QueryData primaryCashData = null;
        CurrencyInfo currency = null;
        AbstractCashflowInitService.QueryData[] balanceData = null;
        BigDecimal cashAmt = ZERO;
        for (Object key : primaryCash.keySet()) {
            primaryCashData = (AbstractCashflowInitService.QueryData)primaryCash.get(key);
            currency = primaryCashData.getCurrency();
            balanceData = (AbstractCashflowInitService.QueryData[])balance.get(key);
            isGeneralLocal = generalLocal.equals(currency.getId().toString());
            isGeneralReport = generalReport.equals(currency.getId().toString());
            BigDecimal[] secondaryCash = new BigDecimal[]{balanceData[1].getOriginalAmount().subtract(balanceData[0].getOriginalAmount()).add(balanceData[3].getOriginalAmount()).subtract(balanceData[2].getOriginalAmount()), balanceData[1].getLocalAmount().subtract(balanceData[0].getLocalAmount()).add(balanceData[3].getLocalAmount()).subtract(balanceData[2].getLocalAmount()), balanceData[1].getReportingAmount().subtract(balanceData[0].getReportingAmount()).add(balanceData[3].getReportingAmount()).subtract(balanceData[2].getReportingAmount())};
            cashAmt = primaryCashData.getOriginalAmount().subtract(secondaryCash[0]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralLocal && !isGeneralReport && cashAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryCashData.getOriginalAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryCash[0], (int)currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.CASH_ORIGINAL_NOT_EQUAL, params);
            }
            cashAmt = primaryCashData.getLocalAmount().subtract(secondaryCash[1]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if ((isGeneralLocal || isForeignCurrency) && cashAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryCashData.getLocalAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryCash[1], (int)currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.CASH_LOCAL_NOT_EQUAL, params);
            }
            cashAmt = primaryCashData.getReportingAmount().subtract(secondaryCash[2]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralReport && !isForeignCurrency || cashAmt.compareTo(ZERO) == 0) continue;
            Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryCashData.getReportingAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryCash[2], (int)currency.getPrecision())};
            throw new CashFlowInitException(CashFlowInitException.CASH_REPORT_NOT_EQUAL, params);
        }
    }

    private void checkSupItem(Context ctx, CurrencyCollection curCol, boolean isForeignCurrency) throws BOSException, EASBizException, CashFlowInitException {
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean isGeneralLocal = false;
        boolean isGeneralReport = false;
        Map primaryWork = this.selectWorkDataFromDB(ctx, curCol, 0, 1);
        Map secondaryWork = this.getSecondaryWorkData(ctx, curCol);
        CurrencyInfo currency = null;
        AbstractCashflowInitService.QueryData primaryData = null;
        AbstractCashflowInitService.QueryData secondaryData = null;
        BigDecimal workAmt = ZERO;
        for (Object key : primaryWork.keySet()) {
            primaryData = (AbstractCashflowInitService.QueryData)primaryWork.get(key);
            currency = primaryData.getCurrency();
            secondaryData = (AbstractCashflowInitService.QueryData)secondaryWork.get(key);
            if (!primaryData.getCurrency().getId().toString().equals(secondaryData.getCurrency().getId().toString())) continue;
            isGeneralLocal = generalLocal.equals(currency.getId().toString());
            isGeneralReport = generalReport.equals(currency.getId().toString());
            workAmt = workAmt.setScale(currency.getPrecision());
            workAmt = primaryData.getOriginalAmount().subtract(secondaryData.getOriginalAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralLocal && !isGeneralReport && workAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryData.getOriginalAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryData.getOriginalAmount(), (int)currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.WORK_ORIGINAL_NOT_EQUAL, params);
            }
            workAmt = primaryData.getLocalAmount().subtract(secondaryData.getLocalAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if ((isGeneralLocal || isForeignCurrency) && workAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryData.getLocalAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryData.getLocalAmount(), (int)currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.WORK_LOCAL_NOT_EQUAL, params);
            }
            workAmt = primaryData.getReportingAmount().subtract(secondaryData.getReportingAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralReport && !isForeignCurrency || workAmt.compareTo(ZERO) == 0) continue;
            Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber((BigDecimal)primaryData.getReportingAmount(), (int)currency.getPrecision()), GlUtils.formatNumber((BigDecimal)secondaryData.getReportingAmount(), (int)currency.getPrecision())};
            throw new CashFlowInitException(CashFlowInitException.WORK_REPORT_NOT_EQUAL, params);
        }
    }

    private CurrencyCollection getCurrency(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        EntityViewInfo accountView = new EntityViewInfo();
        FilterInfo accountFilter = new FilterInfo();
        accountFilter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        accountFilter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        accountFilter.setMaskString("#0 or #1");
        accountView.setFilter(accountFilter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(accountFilter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = null;
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(false);
        } else {
            EntityViewInfo currencyView = new EntityViewInfo();
            FilterInfo currencyFilter = new FilterInfo();
            currencyView.setFilter(currencyFilter);
            currencyFilter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getBaseCurrency().getId().toString()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
            currencyFilter.setMaskString("#0 or #1");
            curCol = curCtrl.getCurrencyCollection(currencyView);
        }
        return curCol;
    }

    private Map getSecondaryWorkData(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        Map secondaryWork = this.selectWorkDataFromDB(ctx, currencyCollection, 1, 0);
        Map profits = this.getRetainedProfits(ctx, currencyCollection);
        for (Object key : secondaryWork.keySet()) {
            AbstractCashflowInitService.QueryData secondaryData = (AbstractCashflowInitService.QueryData)secondaryWork.get(key);
            AbstractCashflowInitService.QueryData profitData = (AbstractCashflowInitService.QueryData)profits.get(key);
            secondaryData.setOriginalAmount(secondaryData.getOriginalAmount() == null ? (profitData.getOriginalAmount() == null ? GlUtils.zero : profitData.getOriginalAmount()) : secondaryData.getOriginalAmount().add(profitData.getOriginalAmount() == null ? GlUtils.zero : profitData.getOriginalAmount()));
            secondaryData.setLocalAmount(secondaryData.getLocalAmount() == null ? (profitData.getLocalAmount() == null ? GlUtils.zero : profitData.getLocalAmount()) : secondaryData.getLocalAmount().add(profitData.getLocalAmount() == null ? GlUtils.zero : profitData.getLocalAmount()));
            secondaryData.setReportingAmount(secondaryData.getReportingAmount() == null ? (profitData.getReportingAmount() == null ? GlUtils.zero : profitData.getReportingAmount()) : secondaryData.getReportingAmount().add(profitData.getReportingAmount() == null ? GlUtils.zero : profitData.getReportingAmount()));
        }
        return secondaryWork;
    }

    private Map selectWorkDataFromDB(Context ctx, CurrencyCollection currencyCollection, int itemType, int isDealActivity) throws BOSException, EASBizException {
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean hasGeneralLocal = false;
        boolean hasGeneralReport = false;
        boolean hasOtherCurrency = false;
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (generalLocal.equals(currency.getId().toString())) {
                hasGeneralLocal = true;
                continue;
            }
            if (generalReport.equals(currency.getId().toString())) {
                hasGeneralReport = true;
                continue;
            }
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
            hasOtherCurrency = true;
        }
        if (hasOtherCurrency) {
            sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        }
        StringBuffer sbSql = new StringBuffer();
        if (hasOtherCurrency) {
            sbSql.append(this.getOtherCurrencySql(itemType, isDealActivity, sbCurrencyIds.toString()));
        }
        if (hasGeneralLocal) {
            if (sbSql.length() > 0) {
                sbSql.append(" union all ");
            }
            sbSql.append(this.getGeneralCurrencySql(itemType, isDealActivity, generalLocal));
        }
        if (hasGeneralReport) {
            if (sbSql.length() > 0) {
                sbSql.append(" union all ");
            }
            sbSql.append(this.getGeneralCurrencySql(itemType, isDealActivity, generalReport));
        }
        int paramCount = 0;
        if (hasOtherCurrency) {
            ++paramCount;
        }
        if (hasGeneralLocal) {
            ++paramCount;
        }
        if (hasGeneralReport) {
            ++paramCount;
        }
        Object[] params = new Object[paramCount];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.profitCenter.getId().toString();
        }
        HashMap<BOSUuid, AbstractCashflowInitService.QueryData> result = new HashMap<BOSUuid, AbstractCashflowInitService.QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                if (rs.getString("fcurrencyid") == null) continue;
                AbstractCashflowInitService.QueryData data = new AbstractCashflowInitService.QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FOriginalAmount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount"));
                data.setLocalAmount(rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount"));
                data.setReportingAmount(rs.getBigDecimal("FReportingAmount") == null ? ZERO : rs.getBigDecimal("FReportingAmount"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    private String getOtherCurrencySql(int itemType, int isDealActivity, String currencyIds) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("    SELECT  ");
        if (itemType == 0) {
            sbSql.append("    cfit.fcurrencyid,sum(case cfi.fdirection when 1 then FOriginalAmount else (-1)*FOriginalAmount end) FOriginalAmount, ");
            sbSql.append("    sum(case cfi.fdirection when 1 then FLocalAmount else (-1)*FLocalAmount end) FLocalAmount,");
            sbSql.append("    sum(case cfi.fdirection when 1 then FReportingAmount else (-1)*FReportingAmount end) FReportingAmount");
        } else {
            sbSql.append("    cfit.fcurrencyid,sum(FOriginalAmount) FOriginalAmount,sum(FLocalAmount) FLocalAmount,sum(FReportingAmount) FReportingAmount");
        }
        sbSql.append("    FROM T_BD_CashFlowItem cfi LEFT OUTER JOIN ( ");
        sbSql.append("    SELECT FCurrencyID,FCompanyID,FCashflowItemID,FOriginalAmount, FLocalAmount, FReportingAmount");
        sbSql.append("    FROM T_Pca_PcCashflowInit");
        sbSql.append("    WHERE");
        sbSql.append("    FCurrencyID IN (").append(currencyIds).append(")");
        sbSql.append("    AND FProfitCenterID = ? ) cfit ");
        sbSql.append("    ON cfi.fid = cfit.FCashflowItemID");
        sbSql.append("    WHERE cfi.fisprofit=0 AND  cfi.FType = ");
        sbSql.append(itemType);
        if (isDealActivity == 1) {
            sbSql.append("   and cfi.FIsDealActivity=1");
        }
        sbSql.append(" group by fcurrencyid");
        return sbSql.toString();
    }

    private String getGeneralCurrencySql(int itemType, int isDealActivity, String generalCurrency) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("    SELECT  ");
        sbSql.append("'").append(generalCurrency).append("' fcurrencyid,");
        if (itemType == 0) {
            sbSql.append("    sum(case cfi.fdirection when 1 then FOriginalAmount else (-1)*FOriginalAmount end) FOriginalAmount, ");
            sbSql.append("    sum(case cfi.fdirection when 1 then FLocalAmount else (-1)*FLocalAmount end) FLocalAmount,");
            sbSql.append("    sum(case cfi.fdirection when 1 then FReportingAmount else (-1)*FReportingAmount end) FReportingAmount");
        } else {
            sbSql.append("    sum(FOriginalAmount) FOriginalAmount,sum(FLocalAmount) FLocalAmount,sum(FReportingAmount) FReportingAmount");
        }
        sbSql.append("    FROM T_BD_CashFlowItem cfi LEFT OUTER JOIN ( ");
        sbSql.append("    SELECT FCurrencyID,FCashflowItemID,FOriginalAmount, FLocalAmount, FReportingAmount");
        sbSql.append("    FROM T_Pca_PcCashflowInit");
        sbSql.append("    WHERE");
        sbSql.append("    FProfitCenterID = ? ) cfit ");
        sbSql.append("    ON cfi.fid = cfit.FCashflowItemID");
        sbSql.append("    WHERE cfi.fisprofit=0 AND  cfi.FType = ");
        sbSql.append(itemType);
        if (isDealActivity == 1) {
            sbSql.append("   and cfi.FIsDealActivity=1");
        }
        return sbSql.toString();
    }
}

