/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.ma.pca.CashEntryInfo;
import com.kingdee.eas.ma.pca.PcCashflowSplitRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowSplitRecordInfo;
import com.kingdee.eas.ma.pca.PcCashflowUtils;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.ITAccountSplitStrategy;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultTAccountSplitStrategy
implements ITAccountSplitStrategy {
    private static final ITAccountSplitStrategy instance = new DefaultTAccountSplitStrategy();
    private boolean isAutoDispose = false;

    private DefaultTAccountSplitStrategy() {
    }

    public static ITAccountSplitStrategy getInstance() {
        return instance;
    }

    @Override
    public PcCashflowSplitRecordCollection split(Context ctx, PcVoucherInfo voucherInfo, Map params) throws EASBizException, BOSException {
        Map voucherMap = PcCashflowUtils.getVoucherByNear(ctx, voucherInfo);
        List entries = (List)voucherMap.get("col");
        PcCashflowSplitRecordCollection result = new PcCashflowSplitRecordCollection();
        boolean isAllCashAccount = this.isAllCashAccount(entries);
        ctx.put((Object)"isAllCashAccount", (Object)isAllCashAccount);
        CompanyOrgUnitInfo curCompany = null;
        Object obj = params.get("CurrentCompany");
        if (obj == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("number"));
            curCompany = PcaUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        } else {
            curCompany = (CompanyOrgUnitInfo)obj;
        }
        this.isAutoDispose = PcaUtils.getDefaultPcaParam(ctx, voucherInfo.getProfitCenter().getId().toString(), "PCA_0151");
        boolean isOneDebit = (Boolean)voucherMap.get("isOneDebit");
        boolean isOneCredit = (Boolean)voucherMap.get("isOneCredit");
        if (isOneDebit) {
            this.splitWithOneToMany(ctx, true, entries, result);
        } else if (isOneCredit) {
            this.splitWithOneToMany(ctx, false, entries, result);
        } else {
            this.splitWithNear(ctx, voucherInfo, entries, result, true);
            this.splitWithNear(ctx, voucherInfo, entries, result, false);
            Iterator iterator = entries.iterator();
            CashEntryInfo entry = null;
            boolean isOver = true;
            while (iterator.hasNext()) {
                entry = (CashEntryInfo)iterator.next();
                if (entry.getLocalAmount().signum() == 0) continue;
                isOver = false;
                break;
            }
            if (!isOver) {
                this.splitWithAmount(ctx, voucherInfo, entries, result);
            }
        }
        this.mergeCashflowSplitRecordCollection(result);
        ctx.remove((Object)"isAllCashAccount");
        return result;
    }

    private void splitWithOneToMany(Context ctx, boolean isDebitOneToMany, List entries, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        CashEntryInfo cashEntry = null;
        ArrayList<CashEntryInfo> tempEntryCol = new ArrayList<CashEntryInfo>();
        if (isDebitOneToMany) {
            CashEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)entries.get(i);
                if (entry.getEntryDC().getValue() == 0) {
                    tempEntryCol.add(entry);
                    continue;
                }
                cashEntry = entry;
            }
        } else {
            CashEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)entries.get(i);
                if (entry.getEntryDC().getValue() == 1) {
                    tempEntryCol.add(entry);
                    continue;
                }
                cashEntry = entry;
            }
        }
        this.dealOneToMany(ctx, cashEntry, tempEntryCol, resultCollector);
    }

    private void splitWithNear(Context ctx, PcVoucherInfo voucherInfo, List entries, PcCashflowSplitRecordCollection resultCollector, boolean DToC) throws EASBizException, BOSException {
        List enCol1 = entries;
        int enCount2 = entries.size();
        boolean isAllSpit = true;
        while (isAllSpit) {
            CashEntryInfo entry;
            int j;
            ArrayList<CashEntryInfo> tempEntryCol;
            BigDecimal sum;
            boolean isCR;
            CashEntryInfo entry1;
            boolean isSpit;
            int i;
            isAllSpit = false;
            int enCount = enCol1.size();
            for (i = 0; i >= 0 && i < enCount; ++i) {
                isSpit = false;
                entry1 = (CashEntryInfo)enCol1.get(i);
                boolean bl = isCR = entry1.getEntryDC().getValue() == 0;
                if (!DToC) {
                    isCR = !isCR;
                }
                sum = PcaUtils.zero;
                tempEntryCol = new ArrayList<CashEntryInfo>();
                if (entry1.getLocalAmount().signum() == 0) continue;
                int n = j = isCR ? i - 1 : i + 1;
                while (j >= 0 && j < enCount2) {
                    entry = (CashEntryInfo)entries.get(j);
                    j = isCR ? --j : ++j;
                    if (entry.getLocalAmount().signum() == 0) continue;
                    if (entry1.getEntryDC().getValue() == entry.getEntryDC().getValue()) {
                        if (entry1.getLocalAmount().compareTo(sum) != 0) break;
                        if (PcCashflowUtils.isCashAccount(entry1.getAccount()) && !this.hasCashAccount(tempEntryCol)) {
                            this.dealOneToMany(ctx, entry1, tempEntryCol, resultCollector);
                        } else {
                            tempEntryCol.add(entry1);
                            if (!this.splitWithAmount(ctx, voucherInfo, tempEntryCol, resultCollector)) continue;
                        }
                        isSpit = true;
                        isAllSpit = true;
                        if (isCR) break;
                        i = j - 2;
                        break;
                    }
                    tempEntryCol.add(entry);
                    sum = sum.add(entry.getLocalAmount());
                }
                if (!isSpit || i != enCount - 1) continue;
                i = 1;
            }
            enCount = enCol1.size();
            for (i = 0; i >= 0 && i < enCount; ++i) {
                isSpit = false;
                entry1 = (CashEntryInfo)enCol1.get(i);
                boolean bl = isCR = entry1.getEntryDC().getValue() == 0;
                if (!DToC) {
                    isCR = !isCR;
                }
                sum = PcaUtils.zero;
                tempEntryCol = new ArrayList();
                if (entry1.getLocalAmount().signum() == 0) continue;
                int n = j = isCR ? i - 1 : i + 1;
                while (j >= 0 && j < enCount2) {
                    entry = (CashEntryInfo)entries.get(j);
                    j = isCR ? --j : ++j;
                    if (entry.getLocalAmount().signum() == 0) continue;
                    if (entry1.getEntryDC().getValue() == entry.getEntryDC().getValue()) break;
                    tempEntryCol.add(entry);
                    sum = sum.add(entry.getLocalAmount());
                    if (entry1.getLocalAmount().compareTo(sum) == 0) {
                        if (PcCashflowUtils.isCashAccount(entry1.getAccount()) && !this.hasCashAccount(tempEntryCol)) {
                            this.dealOneToMany(ctx, entry1, tempEntryCol, resultCollector);
                        } else {
                            tempEntryCol.add(entry1);
                            if (!this.splitWithAmount(ctx, voucherInfo, tempEntryCol, resultCollector)) continue;
                        }
                        isSpit = true;
                        isAllSpit = true;
                        if (isCR) break;
                        i = j;
                        break;
                    }
                    if (!(entry1.getLocalAmount().signum() > 0 ? entry1.getLocalAmount().compareTo(sum) < 0 : entry1.getLocalAmount().compareTo(sum) > 0)) continue;
                }
                if (!isSpit || i != enCount - 1) continue;
                i = 1;
            }
        }
    }

    private boolean splitWithAmount(Context ctx, PcVoucherInfo voucherInfo, List enCol, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        CashEntryInfo entry;
        CashEntryInfo cashEntry = null;
        int enCount2 = enCol.size();
        this.sortByAmount(enCol);
        Iterator iterator = enCol.iterator();
        ArrayList<CashEntryInfo> cashEntries = new ArrayList<CashEntryInfo>();
        while (iterator.hasNext()) {
            entry = (CashEntryInfo)iterator.next();
            if (!PcCashflowUtils.isCashAccount(entry.getAccount()) || entry.getLocalAmount().signum() == 0) continue;
            cashEntries.add(entry);
        }
        if (cashEntries.size() == 0) {
            int size = enCol.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)enCol.get(i);
                entry.setLocalAmount(PcaUtils.zero);
            }
            return true;
        }
        int enCount = cashEntries.size();
        block2: for (int i = 0; i < enCount; ++i) {
            int localSignum;
            int j;
            int tempSeq;
            int j2;
            cashEntry = (CashEntryInfo)cashEntries.get(i);
            boolean isContinue = false;
            BigDecimal cashLocal = cashEntry.getLocalAmount();
            int cashLocalSignum = cashLocal.signum();
            if (cashLocal.signum() == 0) continue;
            boolean isCR = cashEntry.getEntryDC().getValue() == 0;
            int seqSub = Integer.MAX_VALUE;
            CashEntryInfo tempEntry = null;
            for (j2 = 0; j2 < enCount2; ++j2) {
                entry = (CashEntryInfo)enCol.get(j2);
                if (entry.getLocalAmount().signum() == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || !cashEntry.getLocalAmount().equals(entry.getLocalAmount())) continue;
                tempSeq = cashEntry.getSeq() - entry.getSeq();
                if (Math.abs(tempSeq) < Math.abs(seqSub) || Math.abs(tempSeq) == Math.abs(seqSub) && (isCR ? tempSeq > 0 : tempSeq < 0)) {
                    seqSub = tempSeq;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealNormalVoucher(ctx, cashEntry, tempEntry, resultCollector);
                continue;
            }
            seqSub = Integer.MAX_VALUE;
            for (j2 = 0; j2 < enCount2; ++j2) {
                entry = (CashEntryInfo)enCol.get(j2);
                if (entry.getLocalAmount().signum() == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || !cashEntry.getLocalAmount().equals(entry.getLocalAmount().negate())) continue;
                tempSeq = cashEntry.getSeq() - entry.getSeq();
                if (Math.abs(tempSeq) < Math.abs(seqSub) || Math.abs(tempSeq) == Math.abs(seqSub) && (isCR ? tempSeq > 0 : tempSeq < 0)) {
                    seqSub = tempSeq;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealSingleVoucherByAdmount(ctx, cashEntry, tempEntry, resultCollector);
                continue;
            }
            BigDecimal local = PcaUtils.zero;
            BigDecimal subAmount = PcaUtils.zero;
            seqSub = Integer.MAX_VALUE;
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (entry.getLocalAmount().signum() == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || cashLocalSignum != localSignum) continue;
                int tempSeq2 = cashEntry.getSeq() - entry.getSeq();
                if (subAmount.signum() != 0 && subAmount.compareTo(local.subtract(cashLocal)) != 0) break;
                subAmount = local.subtract(cashLocal);
                if (Math.abs(tempSeq2) < Math.abs(seqSub) || Math.abs(tempSeq2) == Math.abs(seqSub) && (isCR ? tempSeq2 > 0 : tempSeq2 < 0)) {
                    seqSub = tempSeq2;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealNormalVoucher(ctx, cashEntry, tempEntry, resultCollector);
                if (cashEntry.getLocalAmount().signum() == 0) continue;
                --i;
                continue;
            }
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (localSignum == 0 || cashLocalSignum == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashLocalSignum == localSignum) continue;
                this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, resultCollector);
                if (cashEntry.getLocalAmount().signum() != 0) {
                    --i;
                }
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            if (!this.isAutoDispose && !((Boolean)ctx.get((Object)"isAllCashAccount")).booleanValue()) {
                if (this.isAllCashAccount(enCol)) {
                    return false;
                }
                for (j = 0; j < enCount2; ++j) {
                    entry = (CashEntryInfo)enCol.get(j);
                    local = entry.getLocalAmount();
                    if (cashLocalSignum == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue()) continue;
                    entry.setLocalAmount(cashEntry.getLocalAmount());
                    entry.setOriginalAmount(cashEntry.getOriginalAmount());
                    entry.setReportingAmount(cashEntry.getReportingAmount());
                    if (entry.getAssistCol() != null && entry.getAssistCol().size() > 0) {
                        for (CashEntryInfo assistRecord : entry.getAssistCol()) {
                            if (assistRecord.getVoucherAssistEntry() == null || assistRecord.getVoucherAssistEntry().getSeq() != 1) continue;
                            assistRecord.setLocalAmount(cashEntry.getLocalAmount());
                            assistRecord.setOriginalAmount(cashEntry.getOriginalAmount());
                            assistRecord.setReportingAmount(cashEntry.getReportingAmount());
                            break;
                        }
                    }
                    this.dealNormalVoucher(ctx, cashEntry, entry, resultCollector);
                    isContinue = true;
                    break;
                }
                if (isContinue) continue;
                for (j = 0; j < enCount2; ++j) {
                    entry = (CashEntryInfo)enCol.get(j);
                    local = entry.getLocalAmount();
                    if (cashLocalSignum == 0 || PcCashflowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashEntry.getSeq() == entry.getSeq()) continue;
                    entry.setLocalAmount(cashEntry.getLocalAmount().multiply(PcaUtils.negone));
                    entry.setOriginalAmount(cashEntry.getOriginalAmount().multiply(PcaUtils.negone));
                    entry.setReportingAmount(cashEntry.getReportingAmount().multiply(PcaUtils.negone));
                    if (entry.getAssistCol() != null && entry.getAssistCol().size() > 0) {
                        for (CashEntryInfo assistRecord : entry.getAssistCol()) {
                            if (assistRecord.getVoucherAssistEntry() == null || assistRecord.getVoucherAssistEntry().getSeq() != 1) continue;
                            assistRecord.setLocalAmount(cashEntry.getLocalAmount().multiply(PcaUtils.negone));
                            assistRecord.setOriginalAmount(cashEntry.getOriginalAmount().multiply(PcaUtils.negone));
                            assistRecord.setReportingAmount(cashEntry.getReportingAmount().multiply(PcaUtils.negone));
                            break;
                        }
                    }
                    this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, resultCollector);
                    continue block2;
                }
                continue;
            }
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                if (entry.getLocalAmount().signum() == 0) continue;
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || cashLocalSignum != localSignum) continue;
                this.dealNormalVoucher(ctx, cashEntry, entry, resultCollector);
                if (cashEntry.getLocalAmount().signum() != 0) {
                    --i;
                }
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (localSignum == 0 || cashLocalSignum == 0 || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashEntry.getSeq() == entry.getSeq() || cashLocalSignum == localSignum) continue;
                this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, resultCollector);
                if (cashEntry.getLocalAmount().signum() == 0) continue block2;
                --i;
                continue block2;
            }
        }
        return true;
    }

    private void dealOneToMany(Context ctx, CashEntryInfo cashEntry, List entries, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        if (cashEntry.getLocalAmount().abs().signum() == 0 && cashEntry.getReportingAmount().abs().signum() == 0) {
            return;
        }
        String cashEntryCurrencyId = cashEntry.getCurrency().getId().toString();
        String entryCurrencyId = null;
        BigDecimal origAmt = null;
        BigDecimal[] amt = null;
        CashEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (CashEntryInfo)entries.get(i);
            entryCurrencyId = entry.getCurrency().getId().toString();
            boolean isCurrencySame = entryCurrencyId.equals(cashEntryCurrencyId);
            if (isCurrencySame) {
                origAmt = entry.getOriginalAmount();
            } else {
                origAmt = cashEntry.getLocalAmount().abs().signum() != 0 ? cashEntry.getOriginalAmount().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4)) : cashEntry.getOriginalAmount().multiply(entry.getReportingAmount().abs().divide(cashEntry.getReportingAmount().abs(), 28, 4));
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount(), entry.getReportingAmount()};
            this.collectByAmount(ctx, cashEntry, entry, amt, false, resultCollector);
            entry.setLocalAmount(PcaUtils.zero);
        }
        cashEntry.setLocalAmount(PcaUtils.zero);
    }

    private void dealSingleVoucherByAdmount(Context ctx, CashEntryInfo cashEntry, CashEntryInfo entry, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        BigDecimal entryLocal = entry.getLocalAmount();
        BigDecimal cashEntryLocal = cashEntry.getLocalAmount();
        BigDecimal cashEntrySignum = cashEntryLocal.signum() == 1 ? PcaUtils.one : PcaUtils.negone;
        BigDecimal[] amt = null;
        boolean isCurrencySame = cashEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString());
        boolean isCashSplit = entryLocal.abs().compareTo(cashEntryLocal.abs()) >= 0 && (this.isAutoDispose || (Boolean)ctx.get((Object)"isAllCashAccount") != false);
        BigDecimal origAmt = null;
        if (isCashSplit) {
            amt = new BigDecimal[]{cashEntry.getOriginalAmount(), cashEntry.getLocalAmount(), cashEntry.getReportingAmount()};
        } else {
            if (!isCurrencySame) {
                origAmt = cashEntry.getOriginalAmount().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4));
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntrySignum);
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount().abs().multiply(cashEntrySignum), entry.getReportingAmount().abs().multiply(cashEntrySignum)};
        }
        this.collectByAmount(ctx, cashEntry, entry, amt, true, resultCollector);
        if (isCashSplit) {
            if (!isCurrencySame) {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntry.getLocalAmount().abs().divide(entry.getLocalAmount().abs(), 28, 4)).multiply(cashEntrySignum);
                origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = cashEntry.getOriginalAmount();
            }
            entry.setOriginalAmount(entry.getOriginalAmount().add(origAmt));
            entry.setLocalAmount(entry.getLocalAmount().add(cashEntry.getLocalAmount()));
            entry.setReportingAmount(entry.getReportingAmount().add(cashEntry.getReportingAmount()));
            cashEntry.setLocalAmount(PcaUtils.zero);
        } else {
            cashEntry.setOriginalAmount(cashEntry.getOriginalAmount().subtract(origAmt));
            cashEntry.setLocalAmount(cashEntry.getLocalAmount().add(entry.getLocalAmount()));
            cashEntry.setReportingAmount(cashEntry.getReportingAmount().add(entry.getReportingAmount()));
            entry.setLocalAmount(PcaUtils.zero);
        }
    }

    private void dealNormalVoucher(Context ctx, CashEntryInfo cashEntry, CashEntryInfo entry, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        BigDecimal entryLocalAmt = entry.getLocalAmount();
        BigDecimal cashEntryLocalAmt = cashEntry.getLocalAmount();
        BigDecimal entrySignum = entryLocalAmt.signum() == 1 ? PcaUtils.one : PcaUtils.negone;
        BigDecimal cashEntrySignum = cashEntryLocalAmt.signum() == 1 ? PcaUtils.one : PcaUtils.negone;
        BigDecimal origAmt = null;
        boolean isCashSplit = entryLocalAmt.compareTo(cashEntryLocalAmt) > 0 && (entryLocalAmt.signum() > 0 || cashEntryLocalAmt.signum() > 0) || entryLocalAmt.compareTo(cashEntryLocalAmt) < 0 && entryLocalAmt.signum() < 0 && cashEntryLocalAmt.signum() < 0;
        boolean isCurrencySame = cashEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString());
        BigDecimal[] amt = null;
        if (isCashSplit) {
            amt = new BigDecimal[]{cashEntry.getOriginalAmount(), cashEntry.getLocalAmount(), cashEntry.getReportingAmount()};
        } else {
            if (!isCurrencySame) {
                origAmt = cashEntry.getOriginalAmount().abs().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4)).multiply(entrySignum);
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = entry.getOriginalAmount();
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount(), entry.getReportingAmount()};
        }
        this.collectByAmount(ctx, cashEntry, entry, amt, false, resultCollector);
        if (isCashSplit) {
            if (!isCurrencySame) {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntry.getLocalAmount().abs().divide(entry.getLocalAmount().abs(), 28, 4)).multiply(cashEntrySignum);
                origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = cashEntry.getOriginalAmount();
            }
            entry.setOriginalAmount(entry.getOriginalAmount().subtract(origAmt));
            entry.setLocalAmount(entry.getLocalAmount().subtract(cashEntry.getLocalAmount()));
            entry.setReportingAmount(entry.getReportingAmount().subtract(cashEntry.getReportingAmount()));
            cashEntry.setLocalAmount(PcaUtils.zero);
        } else {
            cashEntry.setOriginalAmount(cashEntry.getOriginalAmount().subtract(origAmt));
            cashEntry.setLocalAmount(cashEntry.getLocalAmount().subtract(entry.getLocalAmount()));
            cashEntry.setReportingAmount(cashEntry.getReportingAmount().subtract(entry.getReportingAmount()));
            entry.setLocalAmount(PcaUtils.zero);
        }
    }

    private void sortByAmount(List enCol) {
        Collections.sort(enCol, new Comparator(){

            public int compare(Object o1, Object o2) {
                CashEntryInfo entry = (CashEntryInfo)o1;
                CashEntryInfo entry1 = (CashEntryInfo)o2;
                return entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
            }
        });
    }

    private boolean hasCashAccount(List tempEntryCol) throws BOSException {
        int enCount = tempEntryCol.size();
        for (int j = 0; j < enCount; ++j) {
            CashEntryInfo entryInfo = (CashEntryInfo)tempEntryCol.get(j);
            if (!PcCashflowUtils.isCashAccount(entryInfo.getAccount())) continue;
            return true;
        }
        return false;
    }

    private void collectByAmount(Context ctx, CashEntryInfo selfEntry, CashEntryInfo oppEntry, BigDecimal[] amt, boolean isSingleVoucher, PcCashflowSplitRecordCollection resultCollector) throws EASBizException, BOSException {
        if (amt[1].signum() == 0) {
            return;
        }
        if (PcCashflowUtils.isCashAccount(oppEntry.getAccount()) && (this.isAutoDispose || ((Boolean)ctx.get((Object)"isAllCashAccount")).booleanValue())) {
            PcCashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, amt, resultCollector, null, ItemFlag.DISPOSE);
            resultCollector.add(splitRecord);
            BigDecimal[] disposeAmt = new BigDecimal[3];
            boolean isCurrencySame = selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString());
            if (isCurrencySame) {
                if (selfEntry.getVoucherEntry().getEntryDC() == oppEntry.getVoucherEntry().getEntryDC()) {
                    disposeAmt[0] = amt[0].negate();
                    disposeAmt[1] = amt[1].negate();
                    disposeAmt[2] = amt[2].negate();
                } else {
                    disposeAmt[0] = amt[0];
                    disposeAmt[1] = amt[1];
                    disposeAmt[2] = amt[2];
                }
            } else {
                BigDecimal origAmt = oppEntry.getOriginalAmount().multiply(amt[1].divide(oppEntry.getLocalAmount(), 28, 4));
                origAmt = origAmt.setScale(oppEntry.getCurrency().getPrecision(), 4);
                if (selfEntry.getVoucherEntry().getEntryDC() == oppEntry.getVoucherEntry().getEntryDC()) {
                    disposeAmt[0] = origAmt.negate();
                    disposeAmt[1] = amt[1].negate();
                    disposeAmt[2] = amt[2].negate();
                } else {
                    disposeAmt[0] = origAmt;
                    disposeAmt[1] = amt[1];
                    disposeAmt[2] = amt[2];
                }
            }
            PcCashflowSplitRecordInfo disposeRecord = this.createSplitRecord(ctx, oppEntry, selfEntry, disposeAmt, resultCollector, null, ItemFlag.DISPOSE);
            resultCollector.add(disposeRecord);
        } else {
            List assistCol = (List)oppEntry.getAssistCol();
            if (assistCol == null) {
                PcCashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, amt, resultCollector, null, ItemFlag.PRIMARY);
                resultCollector.add(splitRecord);
            } else {
                boolean isCurrencySame = selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString());
                if (selfEntry.getLocalAmount().compareTo(oppEntry.getLocalAmount()) == 0 && !selfEntry.getEntryDC().equals((Object)oppEntry.getEntryDC())) {
                    CashEntryInfo entry2 = null;
                    for (CashEntryInfo entry2 : assistCol) {
                        if (entry2.getLocalAmount().signum() == 0) continue;
                        BigDecimal[] assistArray = new BigDecimal[3];
                        if (isCurrencySame) {
                            assistArray[0] = entry2.getOriginalAmount();
                        } else {
                            assistArray[0] = amt[0].multiply(entry2.getLocalAmount().divide(amt[1], 28, 4));
                            assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                        }
                        assistArray[1] = entry2.getLocalAmount();
                        assistArray[2] = entry2.getReportingAmount();
                        PcCashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry2.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                        resultCollector.add(splitRecord);
                    }
                } else if (selfEntry.getLocalAmount().add(oppEntry.getLocalAmount()).signum() == 0 && selfEntry.getEntryDC().equals((Object)oppEntry.getEntryDC())) {
                    CashEntryInfo entry3 = null;
                    for (CashEntryInfo entry3 : assistCol) {
                        if (entry3.getLocalAmount().signum() == 0) continue;
                        BigDecimal[] assistArray = new BigDecimal[3];
                        if (isCurrencySame) {
                            assistArray[0] = entry3.getOriginalAmount().negate();
                        } else {
                            assistArray[0] = amt[0].negate().multiply(entry3.getLocalAmount().divide(amt[1], 28, 4));
                            assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                        }
                        assistArray[1] = entry3.getLocalAmount().negate();
                        assistArray[2] = entry3.getReportingAmount().negate();
                        PcCashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry3.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                        resultCollector.add(splitRecord);
                    }
                } else {
                    this.sortByAmount(assistCol);
                    BigDecimal[] assistArray = new BigDecimal[3];
                    BigDecimal[] copyAmt = new BigDecimal[]{amt[0], amt[1], amt[2]};
                    CashEntryInfo entry = null;
                    for (int i = 0; i < assistCol.size(); ++i) {
                        BigDecimal origAmt;
                        PcCashflowSplitRecordInfo splitRecord;
                        entry = (CashEntryInfo)assistCol.get(i);
                        if (entry.getLocalAmount().signum() == 0) continue;
                        BigDecimal sub = null;
                        BigDecimal subRpt = null;
                        if (!isSingleVoucher) {
                            sub = copyAmt[1].subtract(entry.getLocalAmount());
                            subRpt = copyAmt[2].subtract(entry.getReportingAmount());
                            if (copyAmt[1].signum() > 0 && sub.signum() >= 0 || copyAmt[1].signum() <= 0 && sub.signum() < 0) {
                                if (isCurrencySame) {
                                    assistArray[0] = entry.getOriginalAmount();
                                } else {
                                    assistArray[0] = amt[0].multiply(entry.getLocalAmount().divide(amt[1], 28, 4));
                                    assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                                }
                                assistArray[1] = entry.getLocalAmount();
                                assistArray[2] = entry.getReportingAmount();
                                copyAmt[1] = sub;
                                copyAmt[0] = copyAmt[0].subtract(assistArray[0]);
                                copyAmt[2] = copyAmt[2].subtract(assistArray[2]);
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                entry.setLocalAmount(PcaUtils.zero);
                                entry.setOriginalAmount(PcaUtils.zero);
                                entry.setReportingAmount(PcaUtils.zero);
                            } else {
                                assistArray[0] = copyAmt[0];
                                assistArray[1] = copyAmt[1];
                                assistArray[2] = copyAmt[2];
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                origAmt = null;
                                if (isCurrencySame) {
                                    origAmt = entry.getOriginalAmount().subtract(copyAmt[0]);
                                } else {
                                    origAmt = entry.getOriginalAmount().multiply(amt[1].divide(entry.getLocalAmount(), 28, 4));
                                    origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
                                    origAmt = entry.getOriginalAmount().subtract(origAmt);
                                }
                                entry.setOriginalAmount(origAmt);
                                entry.setLocalAmount(sub.negate());
                                entry.setReportingAmount(subRpt.negate());
                            }
                        } else {
                            sub = copyAmt[1].add(entry.getLocalAmount());
                            subRpt = copyAmt[2].add(entry.getReportingAmount());
                            if (copyAmt[1].signum() > 0 && sub.signum() < 0 || copyAmt[1].signum() < 0 && sub.signum() > 0) {
                                assistArray[0] = copyAmt[0];
                                assistArray[1] = copyAmt[1];
                                assistArray[2] = copyAmt[2];
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                origAmt = null;
                                if (isCurrencySame) {
                                    origAmt = entry.getOriginalAmount().add(copyAmt[0]);
                                } else {
                                    origAmt = entry.getOriginalAmount().multiply(amt[1].divide(entry.getLocalAmount(), 28, 4));
                                    origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
                                    origAmt = entry.getOriginalAmount().add(origAmt);
                                }
                                entry.setOriginalAmount(origAmt);
                                entry.setLocalAmount(sub);
                                entry.setReportingAmount(subRpt);
                            } else {
                                if (isCurrencySame) {
                                    assistArray[0] = entry.getOriginalAmount().negate();
                                } else {
                                    assistArray[0] = amt[0].negate().multiply(entry.getLocalAmount().divide(amt[1], 28, 4));
                                    assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                                }
                                assistArray[1] = entry.getLocalAmount().negate();
                                assistArray[2] = entry.getReportingAmount().negate();
                                copyAmt[1] = sub;
                                copyAmt[0] = copyAmt[0].subtract(assistArray[0]);
                                copyAmt[2] = copyAmt[2].subtract(assistArray[2]);
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                entry.setLocalAmount(PcaUtils.zero);
                                entry.setOriginalAmount(PcaUtils.zero);
                                entry.setReportingAmount(PcaUtils.zero);
                            }
                        }
                        if (!(copyAmt[1].signum() >= 0 && sub.signum() <= 0 || copyAmt[1].signum() <= 0 && sub.signum() >= 0)) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private PcCashflowSplitRecordInfo createSplitRecord(Context ctx, CashEntryInfo selfEntry, CashEntryInfo oppEntry, BigDecimal[] amt, PcCashflowSplitRecordCollection resultCollector, PcVoucherAssistRecordInfo voucherAssist, ItemFlag itemFlag) {
        PcCashflowSplitRecordInfo splitRecord = new PcCashflowSplitRecordInfo();
        splitRecord.setVoucher(selfEntry.getBill());
        splitRecord.setEntry(selfEntry.getVoucherEntry());
        splitRecord.setAccount(selfEntry.getVoucherEntry().getAccount());
        splitRecord.setCurrency(selfEntry.getVoucherEntry().getCurrency());
        splitRecord.setEntryDC(selfEntry.getVoucherEntry().getEntryDC());
        splitRecord.setOpposingAccountEntry(oppEntry.getVoucherEntry());
        splitRecord.setOppAccount(oppEntry.getAccount());
        splitRecord.setOppEntryDC(oppEntry.getEntryDC());
        splitRecord.setOriginalAmount(amt[0]);
        splitRecord.setLocalAmount(amt[1]);
        splitRecord.setReportingAmount(amt[2]);
        splitRecord.setIsSupItem(false);
        splitRecord.setSourceType(1);
        splitRecord.setItemFlag(itemFlag);
        if (voucherAssist != null) {
            splitRecord.setOppVoucherAssistRecord(voucherAssist);
            splitRecord.setOppAssGrp(voucherAssist.getAssGrp());
        }
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitRecord.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setCreateTime(nowTime);
        splitRecord.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setLastUpdateTime(nowTime);
        return splitRecord;
    }

    private void mergeCashflowSplitRecordCollection(PcCashflowSplitRecordCollection resultCollector) {
        PcCashflowSplitRecordCollection tempCol = new PcCashflowSplitRecordCollection();
        for (int i = 0; i < resultCollector.size(); ++i) {
            PcCashflowSplitRecordInfo record = resultCollector.get(i);
            this.addSplitRecord(tempCol, record);
        }
        resultCollector.clear();
        resultCollector.addCollection(tempCol);
    }

    private void addSplitRecord(PcCashflowSplitRecordCollection resultCollector, PcCashflowSplitRecordInfo splitRecord) {
        for (int i = 0; i < resultCollector.size(); ++i) {
            PcCashflowSplitRecordInfo record = resultCollector.get(i);
            if (record.getEntry() != splitRecord.getEntry() || record.getOpposingAccountEntry() != splitRecord.getOpposingAccountEntry() || record.getOppVoucherAssistRecord() != splitRecord.getOppVoucherAssistRecord()) continue;
            record.setLocalAmount(record.getLocalAmount().add(splitRecord.getLocalAmount()));
            record.setOriginalAmount(record.getOriginalAmount().add(splitRecord.getOriginalAmount()));
            record.setReportingAmount(record.getReportingAmount().add(splitRecord.getReportingAmount()));
            return;
        }
        resultCollector.add(splitRecord);
    }

    private boolean isAllCashAccount(List entries) {
        boolean isAllCash = true;
        for (int i = 0; i < entries.size(); ++i) {
            CashEntryInfo entryInfo = (CashEntryInfo)entries.get(i);
            if (PcCashflowUtils.isCashAccount(entryInfo.getAccount())) continue;
            isAllCash = false;
            break;
        }
        return isAllCash;
    }
}

