/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalanceInitData;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.IPcaBalanceFacade;
import com.kingdee.eas.ma.pca.IPcaFlag;
import com.kingdee.eas.ma.pca.InitPcAccountBalanceInfo;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractInitPcAccountBalanceControllerBean;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitPcAccountBalanceControllerBean
extends AbstractInitPcAccountBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.InitPcAccountBalanceControllerBean");
    BigDecimal one = new BigDecimal("1");
    BigDecimal negone = new BigDecimal("-1");
    public BigDecimal zero = new BigDecimal("0.00");
    public static final int BATCH_SIZE = 8192;

    protected PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitcenter) throws BOSException, EASBizException {
        return PcaInitHelp.getPeriods(ctx, company, profitcenter);
    }

    protected boolean isInitClosed(Context ctx, String orgUnitId) throws BOSException {
        return this.getFlagCtrl(ctx).getPcaInitClosed(orgUnitId);
    }

    @Override
    protected Map _getPageInitData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        long starttime = System.currentTimeMillis();
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)paramMap.get("PROFITCENTER");
        String relatedCompanyId = PcaUtils.getRelatedCompanyIds(profitCenter.getId().toString());
        CompanyOrgUnitInfo relatedCompany = PcaUtils.getCompanyById(relatedCompanyId);
        String companyId = (String)paramMap.get("COMPANYID");
        if (StringUtils.isEmpty((String)companyId)) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("COMPANY");
            companyId = company.getId().toString();
        }
        if (StringUtils.isEmpty((String)companyId) || relatedCompany == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        String profitCenterId = profitCenter.getId().toString();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo currencyView = new EntityViewInfo();
        currencyView.getSorter().add(new SorterItemInfo("number"));
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        boolean isInitClosed = this.isInitClosed(ctx, profitCenterId + "," + companyId);
        paramMap.put("ISINITCLOSED", isInitClosed);
        Map hmParamValue = PcaInitHelp.getInitParam(ctx, relatedCompany, profitCenterId);
        paramMap.put("GL_002", hmParamValue.get("GL_002"));
        paramMap.put("GL_008", hmParamValue.get("GL_008"));
        paramMap.put("G001", hmParamValue.get("G001"));
        boolean isSettleByLocal = 3 == relatedCompany.getReportConvertMode().getValue();
        PeriodInfo[] periods = this.getPeriods(ctx, relatedCompany, profitCenter);
        paramMap.put("STARTPERIOD", periods[0]);
        paramMap.put("CURRENTPERIOD", periods[2]);
        paramMap.put("FIRSTPERIOD", periods[1]);
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalReportCurrency = null;
        CurrencyInfo reportCur = relatedCompany.getReportCurrency();
        CurrencyInfo localCur = relatedCompany.getBaseCurrency();
        LinkedList<CurrencyInfo> removeList = new LinkedList<CurrencyInfo>();
        String bookCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)"bookCurrency", (Locale)ctx.getOriginLocale());
        int size = curCol.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo cur = curCol.get(i);
            if (cur.isGeneralLocalCurrency()) {
                generalLocalCurrency = cur;
                removeList.add(cur);
                continue;
            }
            if (cur.isGeneralReportCurrency()) {
                generalReportCurrency = cur;
                removeList.add(cur);
                continue;
            }
            if (!cur.getId().equals((Object)localCur.getId()) || cur.getName().contains(bookCurrency)) continue;
            cur.setName(cur.getName() + bookCurrency);
        }
        for (CurrencyInfo removeInfo : removeList) {
            curCol.remove(removeInfo);
        }
        if (!Boolean.parseBoolean(hmParamValue.get("GL_008").toString())) {
            if (generalLocalCurrency != null) {
                curCol.add(generalLocalCurrency);
            }
            if (Boolean.parseBoolean(hmParamValue.get("G001").toString()) && generalReportCurrency != null) {
                curCol.add(generalReportCurrency);
            }
        }
        paramMap.put("COMPANY_CURCOLS", curCol);
        paramMap.put("COMPANY_ACCTABLE_COLS", InitHelp.getAccountTableCollection((Context)ctx, (String)relatedCompany.getId().toString()));
        paramMap.put("PCA_055", hmParamValue.get("PCA_055"));
        if (periods[0] != null && periods[1] != null) {
            boolean isFirstPeriod = periods[0].getId().toString().equals(periods[1].getId().toString());
            paramMap.put("IS_FIRSTPERIOD", isFirstPeriod);
        }
        paramMap.put("IS_SETTLEBYLOCAL", isSettleByLocal);
        System.out.println("getPageInitData\u67e5\u8be2\u65f6\u95f4\uff08\u6beb\u79d2\uff09\uff1a" + (System.currentTimeMillis() - starttime));
        return paramMap;
    }

    public VoucherInfo.ExchangeRateWithValue getLocalExchangeRate(Context ctx, CompanyOrgUnitInfo companyInfo, String orgCurId, String localCurrencyId, PeriodInfo startPeriod) throws BOSException, EASBizException {
        if (orgCurId.equals(localCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        VoucherInfo.ExchangeRateWithValue ex = null;
        Object[] info = new Object[8];
        if (companyInfo.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        info[0] = companyInfo.getBaseExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[3] = localCurrencyId;
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = AssistInitFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        ex = (VoucherInfo.ExchangeRateWithValue)exes[0];
        return ex;
    }

    public VoucherInfo.ExchangeRateWithValue getReportingExchangeRate(Context ctx, CompanyOrgUnitInfo companyInfo, String orgCurId, String reportingCurrencyId, PeriodInfo startPeriod) throws BOSException, EASBizException {
        if (orgCurId.equals(reportingCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        VoucherInfo.ExchangeRateWithValue ex = null;
        Object[] info = new Object[8];
        if (companyInfo.getReportExchangeTable() == null) {
            throw new GLException(GLException.NOREPORTINGEXTABLE);
        }
        info[1] = companyInfo.getReportExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[4] = reportingCurrencyId;
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = AssistInitFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        ex = (VoucherInfo.ExchangeRateWithValue)exes[1];
        return ex;
    }

    @Override
    protected HashMap _tryBalance(Context ctx, String currencyId, HashMap otherCtx) throws BOSException, EASBizException {
        HashMap<String, Comparable<BigDecimal>> hashMap;
        BigDecimal zero;
        HashMap<String, Comparable<BigDecimal>> result = new HashMap<String, Comparable<BigDecimal>>();
        String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyId = company.getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        String startPeriodId = startPeriod.getId().toString();
        String firstPeriodId = firstPeriod.getId().toString();
        String accountTableid = otherCtx.get("ACCOUNTTABLEID").toString();
        boolean first = startPeriodId.equals(firstPeriodId);
        StringBuffer sql = new StringBuffer();
        sql.append("   select account.fdc fdc,sum(fbeginbalancefor) fbeginbalancefor,sum(fbeginbalancelocal) fbeginbalancelocal,sum(fbeginbalancerpt) fbeginbalancereport,");
        sql.append("   sum(fyeardebitfor) fyeardebitfor,sum(fyearcreditfor) fyearcreditfor,sum(fyeardebitlocal) fyeardebitlocal,sum(fyearcreditlocal) fyearcreditlocal, ");
        sql.append("   sum(fyeardebitrpt) fyeardebitreport,sum(fyearcreditrpt) fyearcreditreport ");
        sql.append("   from T_PCA_InitPcAccountBalance balance inner join t_BD_AccountView account on balance.faccountid=account.fid ");
        sql.append("   inner join t_bd_accounttype accounttype on account.faccounttypeid=accounttype.fid where  account.flevel=1 and accounttype.fproperty<>? and fprofitcenterid=?  and forgunitid = ?  ");
        sql.append("   and balance.fcurrencyid=? ");
        sql.append("   and account.fbw=0");
        sql.append("   and account.faccounttableid = ?");
        sql.append("   group by account.fdc order by account.fdc ");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BigDecimal beginDebitFor = zero = new BigDecimal("0");
        BigDecimal beginCreditFor = zero;
        BigDecimal yearDebitFor = zero;
        BigDecimal yearCreditFor = zero;
        BigDecimal beginDebitLocal = zero;
        BigDecimal beginDebitReport = zero;
        BigDecimal beginCreditLocal = zero;
        BigDecimal beginCreditReport = zero;
        BigDecimal yearDebitLocal = zero;
        BigDecimal yearDebitReport = zero;
        BigDecimal yearCreditLocal = zero;
        BigDecimal yearCreditReport = zero;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            stmt.setInt(index++, 5);
            stmt.setString(index++, profitCenterId);
            stmt.setString(index++, companyId);
            stmt.setString(index++, currencyId);
            stmt.setString(index++, accountTableid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("fdc") == 1) {
                    beginDebitFor = rs.getBigDecimal("fbeginbalancefor");
                    beginDebitLocal = rs.getBigDecimal("fbeginbalancelocal");
                    beginDebitReport = rs.getBigDecimal("fbeginbalancereport");
                    yearDebitFor = yearDebitFor.add(rs.getBigDecimal("fyeardebitfor"));
                    yearDebitLocal = yearDebitLocal.add(rs.getBigDecimal("fyeardebitlocal"));
                    yearDebitReport = yearDebitReport.add(rs.getBigDecimal("fyeardebitreport"));
                    yearCreditFor = yearCreditFor.add(rs.getBigDecimal("fyearcreditfor"));
                    yearCreditLocal = yearCreditLocal.add(rs.getBigDecimal("fyearcreditlocal"));
                    yearCreditReport = yearCreditReport.add(rs.getBigDecimal("fyearcreditreport"));
                    continue;
                }
                beginCreditFor = rs.getBigDecimal("fbeginbalancefor");
                beginCreditLocal = rs.getBigDecimal("fbeginbalancelocal");
                beginCreditReport = rs.getBigDecimal("fbeginbalancereport");
                yearDebitFor = yearDebitFor.add(rs.getBigDecimal("fyeardebitfor"));
                yearDebitLocal = yearDebitLocal.add(rs.getBigDecimal("fyeardebitlocal"));
                yearDebitReport = yearDebitReport.add(rs.getBigDecimal("fyeardebitreport"));
                yearCreditFor = yearCreditFor.add(rs.getBigDecimal("fyearcreditfor"));
                yearCreditLocal = yearCreditLocal.add(rs.getBigDecimal("fyearcreditlocal"));
                yearCreditReport = yearCreditReport.add(rs.getBigDecimal("fyearcreditreport"));
            }
            result.put("beginDebitFor", beginDebitFor);
            result.put("beginDebitLocal", beginDebitLocal);
            result.put("beginDebitReport", beginDebitReport);
            result.put("beginCreditFor", beginCreditFor);
            result.put("beginCreditLocal", beginCreditLocal);
            result.put("beginCreditReport", beginCreditReport);
            result.put("yearDebitFor", yearDebitFor);
            result.put("yearCreditFor", yearCreditFor);
            result.put("yearDebitLocal", yearDebitLocal);
            result.put("yearDebitReport", yearDebitReport);
            result.put("yearCreditLocal", yearCreditLocal);
            result.put("yearCreditReport", yearCreditReport);
            String glc = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            String grc = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
            boolean succeed = currencyId.equals(glc) ? (first ? beginDebitLocal.compareTo(beginCreditLocal) == 0 : yearDebitLocal.compareTo(yearCreditLocal) == 0 && beginDebitLocal.compareTo(beginCreditLocal) == 0) : (currencyId.equals(grc) ? (first ? beginDebitReport.compareTo(beginCreditReport) == 0 : yearDebitReport.compareTo(yearCreditReport) == 0 && beginDebitReport.compareTo(beginCreditReport) == 0) : (first ? beginDebitFor.compareTo(beginCreditFor) == 0 : yearDebitFor.compareTo(yearCreditFor) == 0 && beginDebitFor.compareTo(beginCreditFor) == 0));
            result.put("succeed", Boolean.valueOf(succeed));
            hashMap = result;
        }
        catch (SQLException sqle) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException e) {
                    logger.error((Object)sqle);
                }
                logger.error((Object)sqle);
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    @Override
    protected int _saveAccountBalanceList(Context ctx, AccountBalanceInitData[] accBalanceList, HashMap otherCtx) throws BOSException, EASBizException {
        int n;
        if (accBalanceList == null || accBalanceList.length == 0) {
            return 0;
        }
        int resCount = 0;
        Connection con = null;
        String profitCenterId = otherCtx.get("PROFITCENTERID").toString();
        String accTableId = otherCtx.get("ACCOUNTTABLEID").toString();
        String currencyId = otherCtx.get("CURRENCY_ID").toString();
        String companyId = otherCtx.get("COMPANYID").toString();
        StringBuilder sbu = new StringBuilder();
        sbu.append("delete from T_PCA_InitPcAccountBalance").append(" where fprofitcenterid = '" + profitCenterId + "'").append(" and forgunitid = '" + companyId + "'").append(" and fcurrencyid = '" + currencyId + "'").append(" and  faccountid in (");
        for (int i = 0; i < accBalanceList.length; ++i) {
            AccountBalanceInitData aAccBalance = accBalanceList[i];
            sbu.append("'" + aAccBalance.getAccountId() + "'");
            if (i + 1 == accBalanceList.length) continue;
            sbu.append(",");
        }
        sbu.append(")");
        PreparedStatement new_stmt = null;
        PreparedStatement delete_stmt = null;
        Object rs = null;
        String insertNewSql = this.getNewSql();
        try {
            con = this.getConnection(ctx);
            delete_stmt = con.prepareStatement(sbu.toString());
            delete_stmt.executeUpdate();
            delete_stmt.close();
            new_stmt = con.prepareStatement(insertNewSql);
            int accLength = accBalanceList.length;
            for (int i = 0; i < accLength; ++i) {
                AccountBalanceInitData data = accBalanceList[i];
                data.setCurrencyId(currencyId);
                int index = 1;
                new_stmt.setString(index++, companyId);
                new_stmt.setString(index++, profitCenterId);
                new_stmt.setString(index++, data.getAccountId());
                new_stmt.setString(index++, currencyId);
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceFor()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceLocal()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceReport()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceFor()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceLocal()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceReport()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitFor()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitLocal()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitReport()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditFor()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditLocal()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditReport()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitQty()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditQty()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLFor()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLLocal()));
                new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLReport()));
                new_stmt.addBatch();
                if (i != 0 && i % 8192 == 0) {
                    resCount += new_stmt.executeBatch().length;
                    new_stmt.clearParameters();
                }
                if (i + 1 != accLength || (i + 1) % 8192 <= 0) continue;
                resCount += new_stmt.executeBatch().length;
                new_stmt.clearParameters();
            }
            ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
            otherCtx.put("PROFITCENTER", profitCenterInfo);
            this.sum(ctx, con, accBalanceList, otherCtx);
            StringBuffer clearZero = new StringBuffer();
            clearZero.append("delete from t_pca_initPcaccountbalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0").append(" and fprofitcenterid='" + profitCenterId + "'").append(" and forgunitid='" + companyId + "'");
            delete_stmt = con.prepareStatement(clearZero.toString());
            delete_stmt.executeUpdate();
            delete_stmt.close();
            n = resCount;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup(delete_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)delete_stmt, (Connection)con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sum(Context ctx, Connection con, AccountBalanceInitData[] datas, HashMap otherCtx) throws BOSException, SQLException {
        int index;
        String currencyId;
        String sql;
        StringBuffer insert_general_report2;
        StringBuffer insert_general_report1;
        StringBuffer insert_general_local2;
        StringBuffer insert_general_local1;
        StringBuffer delete_general;
        String accounttable;
        String companyId;
        String relatedCompanyId;
        String profitCenterId;
        String grc;
        String glc;
        boolean isUseReport;
        StringBuffer ids_ancestor;
        boolean isDeleteByCurrency;
        StringBuffer ids_leaf;
        ResultSet rs;
        PreparedStatement ps;
        block15: {
            ps = null;
            rs = null;
            ids_leaf = new StringBuffer();
            int count = datas.length;
            for (int i = 0; i < count; ++i) {
                ids_leaf.append("'").append(datas[i].getAccountId()).append("',");
            }
            isDeleteByCurrency = false;
            if (otherCtx.get("isDeleteByCurrency") != null) {
                isDeleteByCurrency = (Boolean)otherCtx.get("isDeleteByCurrency");
            }
            ids_ancestor = new StringBuffer();
            ArrayList<String> alLeafIds = new ArrayList<String>();
            ArrayList<String> alAncestorIds = new ArrayList<String>();
            ArrayList<String> alAncestorNumbers = new ArrayList<String>();
            ArrayList<Integer> alAncestorDCs = new ArrayList<Integer>();
            isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
            glc = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            grc = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
            profitCenterId = otherCtx.get("PROFITCENTERID").toString();
            relatedCompanyId = PcaUtils.getRelatedCompanyIds(ctx, profitCenterId);
            companyId = otherCtx.get("COMPANYID").toString();
            accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
            StringBuffer query_ancestor = new StringBuffer("select fid,fnumber,fdc from t_BD_AccountView where charindex(flongnumber || '!' ,?) = 1 and Fcompanyid = ? and faccounttableid=? ");
            StringBuffer delete_ancestor = new StringBuffer("delete from T_PCA_InitPcAccountBalance where fprofitcenterId = ? and forgunitid = ? and  fcurrencyid= ? and faccountid in (");
            StringBuffer insert_ancestor = new StringBuffer();
            StringBuffer insert_ancestor_insertpart = new StringBuffer("insert into T_PCA_InitPcAccountBalance").append("(").append("forgunitid,FProfitcenterId,FAccountID,FCurrencyID,").append("FBeginBalanceFor,").append("FBeginBalanceLocal,").append("FBeginBalanceRpt,").append("FEndBalanceFor,").append("FEndBalanceLocal,").append("FEndBalanceRpt,").append("FYearDebitFor,").append("FYearDebitLocal,").append("FYearDebitRpt,").append("FYearCreditFor,").append("FYearCreditLocal,").append("FYearCreditRpt,").append("FYearPnLFor,").append("FYearPnLLocal,").append("FYearPnLRpt,").append("FBeginQty,").append("FEndQty,").append("FYearDebitQty,").append("FYearCreditQty").append(") ");
            StringBuffer insert_ancestor_selectpart = new StringBuffer();
            StringBuffer insert_ancestor_frompart = new StringBuffer(" from T_PCA_InitPcAccountBalance balance,t_bd_accountview account ").append(" where balance.fprofitcenterId=? and balance.forgunitid = ? and balance.fcurrencyid=? and balance.faccountid=account.fid and account.fcompanyid = ? and account.fnumber like ");
            delete_general = new StringBuffer("delete from T_PCA_InitPcAccountBalance where fprofitcenterId= ? and forgunitid = ? and (fcurrencyid= ? or fcurrencyid= ? ) and ").append(" faccountid in (");
            insert_general_local1 = new StringBuffer().append("insert into T_PCA_InitPcAccountBalance ").append("(").append("forgunitid,").append("fprofitcenterId,").append("FAccountID,").append("FCurrencyID,").append("FBeginBalanceFor,").append("FYearDebitFor,").append("FYearCreditFor,").append("FDebitFor,").append("FCreditFor,").append("FEndBalanceFor,").append("FBeginBalanceLocal,").append("FYearDebitLocal,").append("FYearCreditLocal,").append("FDebitLocal,").append("FCreditLocal,").append("FEndBalanceLocal,").append("FBeginBalanceRpt,").append("FYearDebitRpt,").append("FYearCreditRpt,").append("FDebitRpt,").append("FCreditRpt,").append("FEndBalanceRpt,").append("FYearPnLFor,").append("FMonthPnLFor,").append("FYearPnLLocal,").append("FMonthPnLLocal,").append("FYearPnLRpt,").append("FMonthPnLRpt,").append("FBeginQty,").append("FYearDebitQty,").append("FYearCreditQty,").append("FDebitQty,").append("FCreditQty,").append("FEndQty").append(")").append(" select ").append("forgunitid,").append("\tfprofitcenterId,").append("\tFAccountID,").append("'").append(glc).append("',").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FYearPnLLocal,0)),").append("\t0,").append("\tsum(ISNULL(FYearPnLLocal,0)),").append("\t0,").append("\t0,").append("\t0,").append("\tsum(ISNULL(FBeginQty,0)),").append("\tsum(ISNULL(FYearDebitQty,0)),").append("\tsum(ISNULL(FYearCreditQty,0)),").append("\tsum(ISNULL(FDebitQty,0)),").append("\tsum(ISNULL(FCreditQty,0)),").append("\tsum(ISNULL(FEndQty,0))").append(" from T_PCA_InitPcAccountBalance where fprofitcenterId=? and forgunitid = ? and faccountid in(");
            insert_general_local2 = new StringBuffer(") group by forgunitid,fprofitcenterId,FAccountID");
            insert_general_report1 = new StringBuffer().append("insert into T_PCA_InitPcAccountBalance (").append("forgunitid,").append("\tfprofitcenterId,").append("\tFAccountID,").append("\tFCurrencyID,").append("\tFBeginBalanceFor,").append("\tFYearDebitFor,").append("\tFYearCreditFor,").append("\tFDebitFor,").append("\tFCreditFor,").append("\tFEndBalanceFor,").append("\tFBeginBalanceRpt,").append("\tFYearDebitRpt,").append("\tFYearCreditRpt,").append("\tFDebitRpt,").append("\tFCreditRpt,").append("\tFEndBalanceRpt,").append("\tFBeginBalanceLocal,").append("\tFYearDebitLocal,").append("\tFYearCreditLocal,").append("\tFDebitLocal,").append("\tFCreditLocal,").append("\tFEndBalanceLocal,").append("\tFYearPnLFor,").append("\tFMonthPnLFor,").append("\tFYearPnLRpt,").append("\tFMonthPnLRpt,").append("\tFYearPnLLocal,").append("\tFMonthPnLLocal,").append("\tFBeginQty,").append("\tFYearDebitQty,").append("\tFYearCreditQty,").append("\tFDebitQty,").append("\tFCreditQty,").append("\tFEndQty").append(")").append(" select ").append("forgunitid,").append("\tfprofitcenterId,").append("\tFAccountID,").append("'").append(grc).append("',").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FYearPnLRpt,0)),").append("\t0,").append("\tsum(ISNULL(FYearPnLRpt,0)),").append("\t0,").append("\t0,").append("\t0,").append("\tsum(ISNULL(FBeginQty,0)),").append("\tsum(ISNULL(FYearDebitQty,0)),").append("\tsum(ISNULL(FYearCreditQty,0)),").append("\tsum(ISNULL(FDebitQty,0)),").append("\tsum(ISNULL(FCreditQty,0)),").append("\tsum(ISNULL(FEndQty,0))").append("\tfrom T_PCA_InitPcAccountBalance where fprofitcenterId = ? and forgunitid = ? and FCurrencyID <> ? and faccountid in(");
            insert_general_report2 = new StringBuffer(") group by forgunitid,fprofitcenterId,FAccountID");
            try {
                Boolean isForeign;
                sql = null;
                currencyId = null;
                if (!isDeleteByCurrency) {
                    HashMap hmTemp = new HashMap();
                    for (AccountBalanceInitData data : datas) {
                        String accountId = data.getAccountId();
                        if (currencyId == null) {
                            currencyId = data.getCurrencyId();
                        }
                        String longNumber = data.getAccountLongNumber();
                        alLeafIds.add(accountId);
                        ArrayList<String> alIds = new ArrayList<String>();
                        hmTemp.put(accountId, alIds);
                        query_ancestor = new StringBuffer("select  fid,fnumber,fdc from t_BD_AccountView where charindex(flongnumber || '!' ,").append("'").append(longNumber).append("') = 1 and Fcompanyid = ? and faccounttableid=?");
                        ps = con.prepareStatement(query_ancestor.toString());
                        index = 1;
                        ps.setString(index++, relatedCompanyId);
                        ps.setString(index++, accounttable);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            String tempid = rs.getString(1);
                            String tempnumber = rs.getString(2);
                            int tempdc = rs.getInt(3);
                            alIds.add(tempid);
                            if (alAncestorIds.contains(tempid)) continue;
                            alAncestorIds.add(tempid);
                            alAncestorDCs.add(new Integer(tempdc));
                            alAncestorNumbers.add(tempnumber);
                            ids_ancestor.append("'").append(tempid).append("',");
                        }
                        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                    }
                    if (ids_ancestor.length() > 0) {
                        sql = delete_ancestor.toString() + ids_ancestor.toString();
                        sql = sql.substring(0, sql.length() - 1) + ")";
                        ps = con.prepareStatement(sql);
                        index = 1;
                        ps.setString(index++, profitCenterId);
                        ps.setString(index++, companyId);
                        ps.setString(index++, currencyId);
                        ps.executeUpdate();
                        SQLUtils.cleanup((Statement)ps);
                    }
                    int count2 = alAncestorIds.size();
                    for (int i = 0; i < count2; ++i) {
                        String id = (String)alAncestorIds.get(i);
                        String number = (String)alAncestorNumbers.get(i);
                        Integer dc = (Integer)alAncestorDCs.get(i);
                        insert_ancestor_selectpart = new StringBuffer().append("select ").append("'").append(companyId).append("','").append(profitCenterId).append("',").append("'").append(id).append("',").append("'").append(currencyId).append("',");
                        if (dc == 1) {
                            insert_ancestor_selectpart.append("sum(ISNULL(balance.FBeginBalanceFor,0)*account.fdc),").append("sum(ISNULL(balance.FBeginBalanceLocal,0)*account.fdc),").append("sum(ISNULL(balance.FBeginBalanceRpt,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceFor,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceLocal,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceRpt,0)*account.fdc),").append("sum(ISNULL(balance.FYearDebitFor,0)),").append("sum(ISNULL(balance.FYearDebitLocal,0)),").append("sum(ISNULL(balance.FYearDebitRpt,0)),").append("sum(ISNULL(balance.FYearCreditFor,0)),").append("sum(ISNULL(balance.FYearCreditLocal,0)),").append("sum(ISNULL(balance.FYearCreditRpt,0)),").append("sum(ISNULL(balance.FYearPnLFor,0)*account.fdc),").append("sum(ISNULL(balance.FYearPnLLocal,0)*account.fdc),").append("sum(ISNULL(balance.FYearPnLRpt,0)*account.fdc),").append("sum(ISNULL(balance.FBeginQty,0)*account.fdc),").append("sum(ISNULL(balance.FEndQty,0)*account.fdc),").append("sum(ISNULL(balance.FYearDebitQty,0)),").append("sum(ISNULL(balance.FYearCreditQty,0))");
                        } else {
                            insert_ancestor_selectpart.append("sum(ISNULL(balance.FBeginBalanceFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginBalanceLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginBalanceRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearDebitFor,0)),").append("sum(ISNULL(balance.FYearDebitLocal,0)),").append("sum(ISNULL(balance.FYearDebitRpt,0)),").append("sum(ISNULL(balance.FYearCreditFor,0)),").append("sum(ISNULL(balance.FYearCreditLocal,0)),").append("sum(ISNULL(balance.FYearCreditRpt,0)),").append("sum(ISNULL(balance.FYearPnLFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearPnLLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearPnLRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginQty,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndQty,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearDebitQty,0)),").append("sum(ISNULL(balance.FYearCreditQty,0))");
                        }
                        insert_ancestor = new StringBuffer();
                        insert_ancestor.append(insert_ancestor_insertpart).append(insert_ancestor_selectpart).append(insert_ancestor_frompart).append("'").append(number).append("%' and account.fisleaf=1");
                        ps = con.prepareStatement(insert_ancestor.toString());
                        index = 1;
                        ps.setString(index++, profitCenterId);
                        ps.setString(index++, companyId);
                        ps.setString(index++, currencyId);
                        ps.setString(index++, relatedCompanyId);
                        ps.executeUpdate();
                        SQLUtils.cleanup((Statement)ps);
                    }
                }
                if (!(isForeign = (Boolean)otherCtx.get("ISFOREIGN")).booleanValue()) break block15;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
            SQLUtils.cleanup(rs, ps);
            return;
        }
        sql = delete_general.toString() + ids_leaf.toString() + ids_ancestor.toString();
        sql = sql.substring(0, sql.length() - 1) + ")";
        ps = con.prepareStatement(sql);
        index = 1;
        ps.setString(index++, profitCenterId);
        ps.setString(index++, companyId);
        ps.setString(index++, glc);
        ps.setString(index++, grc);
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        sql = ids_leaf.toString() + ids_ancestor.toString();
        sql = sql.substring(0, sql.length() - 1);
        sql = insert_general_local1.toString() + sql + insert_general_local2;
        ps = con.prepareStatement(sql);
        index = 1;
        ps.setString(index++, profitCenterId);
        ps.setString(index++, companyId);
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        if (isUseReport) {
            sql = ids_leaf.toString() + ids_ancestor.toString();
            sql = sql.substring(0, sql.length() - 1);
            sql = insert_general_report1.toString() + sql + insert_general_report2;
            ps = con.prepareStatement(sql);
            index = 1;
            ps.setString(index++, profitCenterId);
            ps.setString(index++, companyId);
            ps.setString(index++, glc);
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps);
        }
        if (!isDeleteByCurrency) {
            sql = "update t_pca_InitPcAccountBalance  set fbeginqty=0,fendqty=0,fyeardebitqty=0,fyearcreditqty=0,fdebitqty=0,fcreditqty=0  where fcurrencyid = ? and fprofitcenterid = ? and forgunitid=? and faccountid  in (select fid from t_bd_accountview where Fcompanyid = ? and faccounttableid = ? and fisqty = 0)";
            index = 1;
            ps = con.prepareStatement(sql);
            ps.setString(index++, currencyId);
            ps.setString(index++, profitCenterId);
            ps.setString(index++, companyId);
            ps.setString(index++, relatedCompanyId);
            ps.setString(index++, accounttable);
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    protected String getNewSql() {
        String temp = "insert into T_PCA_InitPcAccountBalance(forgunitid,fprofitcenterId,faccountid,fcurrencyid,fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fendbalancefor,fendbalancelocal,fendbalancerpt,fyeardebitfor,fyeardebitlocal,fyeardebitrpt,fyearcreditfor,fyearcreditlocal,fyearcreditrpt,";
        temp = temp + "fbeginqty,fendqty,fyeardebitqty,fyearcreditqty,";
        temp = temp + "fyearpnlfor,fyearpnllocal,fyearpnlrpt";
        temp = temp + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,";
        temp = temp + "?,?,?,?,";
        temp = temp + "?,?,?)";
        return temp;
    }

    @Override
    protected ArrayList _getInitDataByAssist(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String currencyId = (String)otherCtx.get("LOCALCURRENCYID");
        int type = Integer.parseInt((String)otherCtx.get("LOCALCURRENCY"));
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String sql = "select balance.fcurrencyid,\t\t\t\t\t                                                    \r\n\tsum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fyeardebitfor) fyeardebitfor, \t\t\t\t\t\r\n\tsum(balance.fyearcreditfor) fyearcreditfor,sum(balance.fdebitfor) fdebitfor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditfor) fcreditfor,sum(balance.fendbalancefor) fendbalancefor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal, \t\t\t\r\n\tsum(balance.fyearcreditLocal) fyearcreditLocal,sum(balance.fdebitlocal) fdebitlocal, \t\t\t\t\t\t\r\n\tsum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal, \t\t\t\t\t\t\r\n\tsum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt, \t\t\t\t\t\r\n\tsum(balance.fyearcreditrpt) fyearcreditrpt,sum(balance.fdebitrpt) fdebitrpt, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fbeginqty) fbeginqty,sum(balance.fyeardebitqty) fyeardebitqty, \t\t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearcreditqty) fyearcreditqty,sum(balance.fdebitqty) fdebitqty, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditqty) fcreditqty,sum(balance.fendqty) fendqty, \t\t\t\t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearpnlfor) fyearpnlfor,sum(balance.fmonthpnlfor) fmonthpnlfor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fmonthpnllocal) fmonthpnllocal,\t\t\t\t\t\t\r\n\tsum(balance.fyearpnlrpt) fyearpnlrpt,sum(balance.fmonthpnlrpt) fmonthpnlrpt, \t \t\t\t\t\t\t\t\r\n\tpaccount.fid faccountid,paccount.fnumber faccountnumber,paccount." + fname + " faccountname,paccount.flongnumber faccountlongnumber,\t\t\t\r\n\tpaccount.fisleaf fisleaf,paccount.flevel flevel,paccount.fdc ,paccount.fisqty ,paccount.fparentid fparentid,\t\t\t\t\t\t\t\r\n\tpaccount.fcurrencyid faccountcurrencyid,paccount.FAcctCurrency  acctcurrency ,paccount.FisGFreeze ,paccount.FisCFreeze ,paccount.FCAA\t\r\n   ,measureunit." + fname + "\tmeasureunitname,accounttype.fproperty\taccounttypeproperty\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tfrom  (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n      select balance.fprofitcenterid,balance.faccountid,balance.fcurrencyid,\t\t\t\t\t\t\t\t\t\r\n      sum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fyeardebitfor) fyeardebitfor,\t\t\t\t\r\n      sum(balance.fyearcreditfor) fyearcreditfor,sum(balance.fdebitfor) fdebitfor, \t\t\t\t\t\t\r\n      sum(balance.fcreditfor) fcreditfor,sum(balance.fendbalancefor) fendbalancefor, \t\t\t\t\t\t\r\n\t    sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal,\t\r\n      sum(balance.fyearcreditLocal) fyearcreditLocal,sum(balance.fdebitlocal) fdebitlocal, \t\t\t\t\r\n      sum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal, \t\t\t\t\r\n  \t  sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt, \t\t\t\t\r\n    \tsum(balance.fyearcreditrpt) fyearcreditrpt,sum(balance.fdebitrpt) fdebitrpt, \t\t\t\t\t\t\r\n      sum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt, \t\t\t\t\t\t\r\n      sum(balance.fstandardbeginqty) fbeginqty,sum(balance.fstandardyeardebitqty) fyeardebitqty, \t\t\t\r\n      sum(balance.fstandardyearcreditqty) fyearcreditqty,sum(balance.fdebitqty) fdebitqty, \t\t\t\t\r\n      sum(balance.fcreditqty) fcreditqty,sum(balance.fendqty) fendqty, \t\t\t\t\t\t\t\t\t\r\n      sum(balance.fyearpnlfor) fyearpnlfor,sum(balance.fmonthpnlfor) fmonthpnlfor,\t\t\t\t\t\t\t\r\n      sum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fmonthpnllocal) fmonthpnllocal,\t\t\t\t\t\r\n      sum(balance.fyearpnlrpt) fyearpnlrpt,sum(balance.fmonthpnlrpt) fmonthpnlrpt \t \t\t\t\t\t\t\r\n      from T_PCA_InitPcAssistBalance balance  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n        where balance.fprofitcenterid=? and balance.forgunitid=?   \t\t\t\t\t\t\t\t\t\t\r\n       and balance.fcurrencyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n        \tgroup by balance.fcurrencyid ,balance.fprofitcenterid,balance.faccountid \t) balance\t\t\t\t\r\n    inner join  t_BD_AccountView account   on balance.faccountid=account.fid\t\t\t\t\t\t\t\t\r\n    inner join  t_BD_AccountView paccount  on charIndex(paccount.flongnumber||'!',account.flongnumber||'!')=1\t\r\n          and account.Fcompanyid=paccount.Fcompanyid and account.faccountTableid=paccount.faccountTableid\t\t\r\n    left join t_bd_measureunitgroup measureunitgroup on account.fmeasureunitgroupid=measureunitgroup.fid \t\t\t\t\r\n    left join t_bd_measureunit measureunit on measureunit.fid=measureunitgroup.fdefaultunitid \t\t\t\t\t\t\t\r\n    left join t_bd_accounttype accounttype on accounttype.fid=account.faccounttypeid \t\t\t\t\t\t\t\t\t\r\n\t where account.fcompanyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n     and  account.faccountTableid=?\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\r\n     and  account.fid in ( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n           select a.fid from t_bd_accountview a  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                left join t_bd_accountcurrency b on  a.fid=b.faccountviewid   \t\t\t\t\t\t\t\t\t\r\n                where ((facctcurrency=1 and b.fcurrencyid=?)\t\t\t\t\t\t\t\t\t\t\t \t\t\r\n                  or facctcurrency=2 or facctcurrency=0  ) \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                 and fcompanyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                 and  account.faccountTableid=?\t\t   )  \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n \tgroup by       balance.fcurrencyid,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tpaccount.fid ,paccount.fnumber ,paccount.fname_" + ctx.getLocale().getLanguage() + " ,paccount.flongnumber ,paccount.fisleaf ,paccount.flevel ,\t\t\r\n\tpaccount.fdc ,paccount.fisqty ,paccount.fparentid ,paccount.fcurrencyid ,measureunit.fname_" + ctx.getLocale().getLanguage() + ",\t\t\t\t\t\t\r\n\tpaccount.FAcctCurrency   ,paccount.FisGFreeze ,paccount.FisCFreeze ,paccount.FCAA  ,accounttype.fproperty\t\t\t\r\n\torder by paccount.fnumber\t";
        ArrayList al = this.getAccountBalanceData(ctx, currencyId, otherCtx, type, sql, 1);
        return al;
    }

    protected ArrayList getAccountBalanceData(Context ctx, String currencyId, HashMap otherCtx, int type, String sql, int status) throws BOSException {
        String profitCenterId = otherCtx.get("PROFITCENTERID").toString();
        String companyId = otherCtx.get("COMPANYID").toString();
        String relatedCompanyId = otherCtx.get("RELATEDCOMPANYID").toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        ArrayList<AccountBalanceInitData> al = new ArrayList<AccountBalanceInitData>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, profitCenterId);
            stmt.setString(index++, companyId);
            stmt.setString(index++, currencyId);
            stmt.setString(index++, relatedCompanyId);
            stmt.setString(index++, accounttableid);
            stmt.setString(index++, currencyId);
            stmt.setString(index++, relatedCompanyId);
            stmt.setString(index++, accounttableid);
            rs = stmt.executeQuery();
            HashMap<String, AccountBalanceInitData> accountMap = new HashMap<String, AccountBalanceInitData>();
            while (rs.next()) {
                AccountBalanceInitData data;
                String faccountid = rs.getString("faccountid");
                if (accountMap.get(faccountid) == null) {
                    data = new AccountBalanceInitData();
                    data.setAccountId(rs.getString("faccountid"));
                    data.setAccountName(rs.getString("faccountname"));
                    data.setAccountCurrencyId(rs.getString("faccountcurrencyid"));
                    data.setAccountDC(rs.getInt("fdc"));
                    data.setAccountIsLeaf(rs.getInt("fisleaf"));
                    data.setAccountLevel(rs.getInt("flevel"));
                    data.setAccountIsQty(rs.getInt("fisqty"));
                    data.setAccountParentId(rs.getString("fparentid"));
                    data.setAccountLongNumber(rs.getString("faccountlongnumber"));
                    data.setAccountMeasureUnitName(rs.getString("measureunitname"));
                    data.setAccountNumber(rs.getString("faccountnumber"));
                    data.setAcctCurrency(rs.getInt("acctcurrency"));
                    data.setAccountIsPLType(rs.getInt("accounttypeproperty") == 4);
                    data.setAccountIsFreese(rs.getBoolean("FisCFreeze") || rs.getBoolean("FisGFreeze"));
                    String asstID = rs.getString("FCAA");
                    if (asstID != null) {
                        AccountViewInfo account = new AccountViewInfo();
                        AsstAccountInfo asst = new AsstAccountInfo();
                        asst.setId(BOSUuid.read((String)asstID));
                        account.setCAA(asst);
                        data.setAccount(account);
                    }
                    if (rs.getString("fcurrencyid") == null) {
                        data.setStatus(0);
                        data.setCurrencyId(currencyId);
                    } else {
                        data.setStatus(status);
                        data.setCurrencyId(rs.getString("fcurrencyid"));
                        data.setBeginBalanceFor(rs.getBigDecimal("fbeginbalancefor"));
                        data.setBeginBalanceLocal(rs.getBigDecimal("fbeginbalancelocal"));
                        data.setBeginBalanceReport(rs.getBigDecimal("fbeginbalancerpt"));
                        data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                        data.setEndBalanceFor(rs.getBigDecimal("fendbalancefor"));
                        data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                        data.setEndBalanceReport(rs.getBigDecimal("fendbalancerpt"));
                        data.setEndQty(rs.getBigDecimal("fendqty"));
                        data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
                        data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                        data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                        data.setYearCreditReport(rs.getBigDecimal("fyearcreditrpt"));
                        data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
                        data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                        data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                        data.setYearDebitReport(rs.getBigDecimal("fyeardebitrpt"));
                        data.setYearPnLFor(rs.getBigDecimal("fyearpnlfor"));
                        data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                        data.setYearPnLReport(rs.getBigDecimal("fyearpnlrpt"));
                        data.setCreditFor(rs.getBigDecimal("fcreditfor"));
                        data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
                        data.setCreditQty(rs.getBigDecimal("fcreditqty"));
                        data.setCreditReport(rs.getBigDecimal("fcreditrpt"));
                        data.setDebitFor(rs.getBigDecimal("fdebitfor"));
                        data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
                        data.setDebitQty(rs.getBigDecimal("fdebitqty"));
                        data.setDebitReport(rs.getBigDecimal("fdebitrpt"));
                    }
                } else {
                    data = (AccountBalanceInitData)accountMap.get(faccountid);
                    data.setBeginBalanceFor(data.getBeginBalanceFor().add(rs.getBigDecimal("fbeginbalancefor")));
                    data.setBeginBalanceLocal(data.getBeginBalanceLocal().add(rs.getBigDecimal("fbeginbalancelocal")));
                    data.setBeginBalanceReport(data.getBeginBalanceReport().add(rs.getBigDecimal("fbeginbalancerpt")));
                    data.setBeginQty(data.getBeginQty().add(rs.getBigDecimal("fbeginqty")));
                    data.setEndBalanceFor(rs.getBigDecimal("fendbalancefor"));
                    data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                    data.setEndBalanceReport(rs.getBigDecimal("fendbalancerpt"));
                    data.setEndQty(rs.getBigDecimal("fendqty"));
                    data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
                    data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                    data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                    data.setYearCreditReport(rs.getBigDecimal("fyearcreditrpt"));
                    data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
                    data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                    data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                    data.setYearDebitReport(rs.getBigDecimal("fyeardebitrpt"));
                    data.setYearPnLFor(rs.getBigDecimal("fyearpnlfor"));
                    data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                    data.setYearPnLReport(rs.getBigDecimal("fyearpnlrpt"));
                    data.setCreditFor(rs.getBigDecimal("fcreditfor"));
                    data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
                    data.setCreditQty(rs.getBigDecimal("fcreditqty"));
                    data.setCreditReport(rs.getBigDecimal("fcreditrpt"));
                    data.setDebitFor(rs.getBigDecimal("fdebitfor"));
                    data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
                    data.setDebitQty(rs.getBigDecimal("fdebitqty"));
                    data.setDebitReport(rs.getBigDecimal("fdebitrpt"));
                }
                if (accountMap.containsKey(faccountid)) continue;
                accountMap.put(faccountid, data);
                al.add(data);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return al;
    }

    @Override
    protected void _closeInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        String profitCenterId = profitCenterInfo.getId().toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        otherCtx.put("COMPANY", PcaUtils.getCompanyById(ctx, companyId));
        this.checkCloseInit(ctx, otherCtx);
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.initAccountBalance(profitCenterId + "," + companyId, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
        this.getFlagCtrl(ctx).setPcaInitClosed(true, profitCenterId + "," + companyId);
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).startProfit(SystemEnum.PROFIT_CENTER_ACCOUNTING, profitCenterInfo, true);
    }

    @Override
    protected void _cancelInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        String profitCenterId = otherCtx.get("PROFITCENTERID").toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        long start = System.currentTimeMillis();
        PcaInitHelp.checkCancelInit(ctx, profitCenterId);
        System.out.println("2:" + (System.currentTimeMillis() - start));
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.antiInitBalance(profitCenterId + "," + companyId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "T_PCA_PCACCOUNTBALANCE");
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        flag.setPcaInitClosed(false, profitCenterId + "," + companyId);
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).startProfit(SystemEnum.PROFIT_CENTER_ACCOUNTING, profitCenterInfo, false);
    }

    @Override
    protected SystemStatusCtrolCollection _sysCascadeCheck(Context ctx, String companyIdStr, String periodIdStr) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        SystemStatusCtrolCollection col = null;
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodIdStr));
        Integer iYear = new Integer(period.getPeriodYear());
        Integer iMonth = new Integer(period.getPeriodNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("profitcenter.id", (Object)companyIdStr));
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue()), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("relatedPeriod.periodYear", (Object)iYear));
        fic.add(new FilterItemInfo("relatedPeriod.periodNumber", (Object)iMonth));
        filter.setMaskString("#0 and #1 and #2 and #3  and #4 and #5");
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        col = ctrl.getSystemStatusCtrolCollection(view);
        return col;
    }

    protected void checkCloseInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitcenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        String companyId = PcaUtils.getRelatedCompanyIds(ctx, profitcenter.getId().toString());
        CompanyOrgUnitInfo company = PcaUtils.getCompanyById(ctx, companyId);
        Map hmParamValue = PcaInitHelp.getInitParam(ctx, company, profitcenter.getId().toString());
        Boolean doCheckBalance = (Boolean)hmParamValue.get("GL_112");
        Boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        if (doCheckBalance != null && doCheckBalance.booleanValue()) {
            if (isForeign.booleanValue()) {
                String[] allCurrencyId = (String[])otherCtx.get("ALLCURRENCYID");
                for (int i = 0; i < allCurrencyId.length; ++i) {
                    HashMap result = this._tryBalance(ctx, allCurrencyId[i], otherCtx);
                    boolean b = (Boolean)result.get("succeed");
                    if (b) continue;
                    throw new InitException(InitException.TRYNOTBALANCE, new Object[]{""});
                }
            } else {
                String currencyId = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
                HashMap result = this._tryBalance(ctx, currencyId, otherCtx);
                boolean b = (Boolean)result.get("succeed");
                if (!b) {
                    String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
                    String local = ResourceBase.getString((String)RESOURCE_PATH, (String)"GENERALLOCAL", (Locale)ctx.getLocale());
                    throw new InitException(InitException.TRYNOTBALANCE, new Object[]{local});
                }
                Boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
                if (isUseReport.booleanValue() && !(b = ((Boolean)(result = this._tryBalance(ctx, currencyId = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), otherCtx)).get("succeed")).booleanValue())) {
                    String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
                    String report = ResourceBase.getString((String)RESOURCE_PATH, (String)"GENERALREPORT", (Locale)ctx.getLocale());
                    throw new InitException(InitException.TRYNOTBALANCE, new Object[]{report});
                }
            }
        }
        String profitCenterId = otherCtx.get("PROFITCENTERID").toString();
        String orgCompanyID = otherCtx.get("COMPANYID").toString();
        String[] accounts = this.getFlagCtrl(ctx).getAllAstInitClosed(profitCenterId + "," + orgCompanyID);
        if (accounts == null || accounts.length == 0) {
            return;
        }
        AccountViewCollection accountcol = this.getAccountFromIds(ctx, accounts);
        boolean isQty = PcaUtils.getQtyAsstParam(ctx);
        otherCtx.put("G010", isQty);
        for (AccountViewInfo account : accountcol) {
            if (!account.isIsLeaf()) continue;
            this.checkAsstEqualPCA(ctx, account, otherCtx);
        }
    }

    protected void checkAsstEqualPCA(Context ctx, AccountViewInfo info, HashMap otherCtx) throws BOSException, EASBizException {
        PcaInitHelp.checkAsstEqualPCA(ctx, info, otherCtx);
    }

    protected IPcaFlag getFlagCtrl(Context ctx) throws BOSException {
        return PcaFlagFactory.getLocalInstance(ctx);
    }

    protected AccountViewCollection getAccountFromIds(Context ctx, String[] ids) throws BOSException, EASBizException {
        AccountViewCollection result = new AccountViewCollection();
        FilterInfo filter = new FilterInfo();
        int size = ids.length;
        if (size == 0) {
            return result;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            str.append(",").append(ids[i]);
        }
        str.deleteCharAt(0);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("number");
        selectorItemCollection.add("name");
        selectorItemCollection.add("isQty");
        selectorItemCollection.add("isLeaf");
        selectorItemCollection.add("CAA.isQty");
        selectorItemCollection.add("accountTypeID.property");
        view.setSelector(selectorItemCollection);
        IAccountView avctl = AccountViewFactory.getLocalInstance((Context)ctx);
        result = avctl.getAccountViewCollection(view);
        return result;
    }

    @Override
    protected boolean _isClosedInit(Context ctx, HashMap otherCtx) throws BOSException {
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        String profitCenterid = otherCtx.get("PROFITCENTERID").toString();
        String companyId = otherCtx.get("COMPANYID").toString();
        return flag.getPcaInitClosed(profitCenterid + "," + companyId);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InitPcAccountBalanceInfo info = (InitPcAccountBalanceInfo)model;
        if (!info.isFromExcel()) {
            IObjectPK pk = super._addnew(ctx, model);
            return pk;
        }
        info.put("persist_status", "new");
        info.setFromExcel(false);
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        otherCtx.put("ISUSEREPORT", Boolean.TRUE);
        CompanyOrgUnitInfo company = info.getOrgUnit();
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)ctx.get((Object)"PROFITCENTER");
        otherCtx.put("COMPANY", company);
        otherCtx.put("COMPANYID", company.getId().toString());
        otherCtx.put("PROFITCENTER", profitCenter);
        otherCtx.put("PROFITCENTERID", profitCenter.getId().toString());
        otherCtx.put("ISFOREIGN", Boolean.FALSE);
        otherCtx.put("CUID", company.getId().toString());
        otherCtx.put("ACCOUNTTABLEID", company.getAccountTable().getId().toString());
        AccountBalanceInitData _tmp = new AccountBalanceInitData();
        Object[] col = new AccountBalanceInitData[1];
        _tmp.setAccountId(info.getAccount().getId().toString());
        _tmp.setAccountLongNumber(info.getAccount().getLongNumber());
        _tmp.setBeginBalanceFor(info.getBeginBalanceFor());
        _tmp.setBeginBalanceLocal(info.getBeginBalanceLocal());
        _tmp.setBeginBalanceReport(info.getBeginBalanceRpt());
        _tmp.setBeginQty(info.getBeginQty());
        _tmp.setCreditFor(info.getCreditFor());
        _tmp.setCreditLocal(info.getCreditLocal());
        _tmp.setCreditQty(info.getCreditQty());
        _tmp.setCreditReport(info.getCreditRpt());
        _tmp.setCurrencyId(info.getCurrency().getId().toString());
        _tmp.setDebitFor(info.getDebitFor());
        _tmp.setDebitLocal(info.getDebitLocal());
        _tmp.setDebitQty(info.getDebitQty());
        _tmp.setDebitReport(info.getDebitRpt());
        _tmp.setEndBalanceFor(info.getEndBalanceFor());
        _tmp.setEndBalanceLocal(info.getEndBalanceLocal());
        _tmp.setEndBalanceReport(info.getEndBalanceRpt());
        _tmp.setEndQty(info.getEndQty());
        _tmp.setMonthPnLFor(info.getMonthPnLFor());
        _tmp.setMonthPnLLocal(info.getMonthPnLLocal());
        _tmp.setMonthPnLReport(info.getMonthPnLRpt());
        _tmp.setStatus(1);
        _tmp.setYearCreditFor(info.getYearCreditFor());
        _tmp.setYearCreditLocal(info.getYearCreditLocal());
        _tmp.setYearCreditQty(info.getYearCreditQty());
        _tmp.setYearCreditReport(info.getYearCreditRpt());
        _tmp.setYearDebitFor(info.getYearDebitFor());
        _tmp.setYearDebitLocal(info.getYearDebitLocal());
        _tmp.setYearDebitQty(info.getYearDebitQty());
        _tmp.setYearDebitReport(info.getYearDebitRpt());
        _tmp.setYearPnLFor(info.getYearPnLFor());
        _tmp.setYearPnLLocal(info.getYearPnLLocal());
        _tmp.setYearPnLReport(info.getYearPnLRpt());
        col[0] = _tmp;
        this._saveAccountBalance(ctx, col, otherCtx);
        return null;
    }

    @Override
    protected void _saveAccountBalance(Context ctx, Object[] params, HashMap otherCtx) throws BOSException, EASBizException {
        if (params == null) {
            return;
        }
        AccountBalanceInitData[] datas = (AccountBalanceInitData[])params;
        if (datas == null || datas.length == 0) {
            return;
        }
        Connection con = null;
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        StringBuffer clearZero = new StringBuffer();
        clearZero.append("delete from t_pca_initpcaccountbalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0");
        PreparedStatement new_stmt = null;
        PreparedStatement update_stmt = null;
        PreparedStatement select_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(clearZero.toString());
            update_stmt.executeUpdate();
            update_stmt.close();
            new_stmt = con.prepareStatement(this.getNewSql());
            update_stmt = con.prepareStatement(this.getUpdateSql());
            select_stmt = con.prepareStatement(this.getSelectSql());
            for (int i = 0; i < datas.length; ++i) {
                int index;
                AccountBalanceInitData data = datas[i];
                if (data == null) continue;
                if (data.getStatus() == 1) {
                    index = 1;
                    select_stmt.setString(index++, profitCenterId);
                    select_stmt.setString(index++, companyId);
                    select_stmt.setString(index++, data.getAccountId());
                    select_stmt.setString(index++, data.getCurrencyId());
                    rs = select_stmt.executeQuery();
                    if (!rs.next()) {
                        index = 1;
                        new_stmt.setString(index++, companyId);
                        new_stmt.setString(index++, profitCenterId);
                        new_stmt.setString(index++, data.getAccountId());
                        new_stmt.setString(index++, data.getCurrencyId());
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceFor()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceLocal()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceReport()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceFor()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceLocal()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceReport()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitFor()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitLocal()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitReport()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditFor()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditLocal()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditReport()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitQty()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditQty()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLFor()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLLocal()));
                        new_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLReport()));
                        new_stmt.executeUpdate();
                    } else {
                        data.setStatus(3);
                    }
                }
                if (data.getStatus() == 1) continue;
                index = 1;
                update_stmt.setString(index++, companyId);
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceFor()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceLocal()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginBalanceReport()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceFor()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceLocal()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getEndBalanceReport()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitFor()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitLocal()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitReport()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditFor()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditLocal()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditReport()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getBeginQty()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearDebitQty()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearCreditQty()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLFor()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLLocal()));
                update_stmt.setBigDecimal(index++, PcaInitHelp.nvl(data.getYearPnLReport()));
                update_stmt.setString(index++, profitCenterId);
                update_stmt.setString(index++, companyId);
                update_stmt.setString(index++, data.getAccountId());
                update_stmt.setString(index++, data.getCurrencyId());
                update_stmt.executeUpdate();
            }
            select_stmt.close();
            this.sum(ctx, con, datas, otherCtx);
            update_stmt.close();
            update_stmt = con.prepareStatement(clearZero.toString());
            update_stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup(update_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)update_stmt, (Connection)con);
    }

    protected String getUpdateSql() {
        String temp = "update t_pca_initPcaccountBalance set forgunitid =?,fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,";
        temp = temp + "fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,";
        temp = temp + "fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?";
        temp = temp + " where  fprofitcenterid = ? and forgunitid = ? and faccountid=? and fcurrencyid=?";
        return temp;
    }

    protected String getSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 where exists                                    \t\t\t\t\t\r\n");
        sql.append("( select 1                                 \t\t\t\t\t\r\n");
        sql.append("from t_pca_InitPcAccountBalance bal                                                   \r\n");
        sql.append("where  bal.fprofitcenterid = ? and forgunitid = ? and bal.FAccountID = ? and bal.fcurrencyid=? )");
        return sql.toString();
    }

    @Override
    protected void _deleteAccountBalance(Context ctx, Object[] data, HashMap otherCtx) throws BOSException, EASBizException {
        String[] currencyArrs = (String[])data;
        String profitCenterId = (String)otherCtx.get("PROFITCENTERID");
        String accountTableId = (String)otherCtx.get("ACCOUNTTABLEID");
        String companyId = (String)otherCtx.get("COMPANYID");
        String relatedCompanyId = PcaUtils.getRelatedCompanyIds(ctx, profitCenterId);
        boolean isDeleteAll = (Boolean)otherCtx.get("isSelectedAll");
        Connection con = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        String[] params = new String[4];
        StringBuffer sql = new StringBuffer("delete from t_pca_initPcaccountBalance  \r\n");
        sql.append(" where fprofitcenterid = ? and forgunitid = ?  \r\n");
        params[0] = profitCenterId;
        params[1] = companyId;
        sql.append("and exists  (select 1 from T_BD_AccountView av  where av.faccounttableid = ? and av.fcompanyid = ? and t_pca_initPcaccountBalance.Faccountid = av.fid) \r\n");
        params[2] = accountTableId;
        params[3] = relatedCompanyId;
        try {
            con = this.getConnection(ctx);
            if (!isDeleteAll) {
                String tempSql = "select  balance.fcurrencyid from t_pca_initPcaccountBalance balance inner join t_bd_accountview av on av.fid = balance.faccountid where FProfitCenterID = ? and forgunitid = ? and av.faccounttableid = ?  and balance.fcurrencyid<> ? and balance.fcurrencyid<> ? group by balance.fcurrencyid ";
                ps2 = con.prepareStatement(tempSql);
                ps2.setString(1, params[0]);
                ps2.setString(2, params[1]);
                ps2.setString(3, params[2]);
                ps2.setString(4, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString());
                ps2.setString(5, CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
                rs = ps2.executeQuery();
                isDeleteAll = this.compareCurrency(rs, currencyArrs);
            }
            if (!isDeleteAll) {
                StringBuffer ids = new StringBuffer();
                for (int i = 0; i < currencyArrs.length; ++i) {
                    ids.append("'").append(currencyArrs[i]).append("'");
                    if (i >= currencyArrs.length - 1) continue;
                    ids.append(",");
                }
                sql.append("and fcurrencyid in (").append(ids).append(") \r\n");
            }
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, params[0]);
            ps.setString(2, params[1]);
            ps.setString(3, params[2]);
            ps.setString(4, params[3]);
            ps.execute();
            if (!isDeleteAll) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("accountTableID"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("DC"));
                sic.add(new SelectorItemInfo("longNumber"));
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("level"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableId));
                filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
                view.setFilter(filter);
                AccountViewCollection col = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                AccountBalanceInitData[] datas = null;
                String currencyId = null;
                AccountViewInfo account = null;
                otherCtx.put("isDeleteByCurrency", true);
                for (int i = 0; i < currencyArrs.length; ++i) {
                    currencyId = currencyArrs[i];
                    datas = new AccountBalanceInitData[col.size()];
                    for (int j = 0; j < col.size(); ++j) {
                        account = col.get(j);
                        datas[j] = new AccountBalanceInitData();
                        datas[j].setAccount(account);
                        datas[j].setCurrencyId(currencyId);
                        datas[j].setAccountId(account.getId().toString());
                        datas[j].setAccountDC(account.getDC().getValue());
                        datas[j].setAccountName(account.getName());
                        datas[j].setAccountNumber(account.getNumber());
                        datas[j].setAccountLevel(account.getLevel());
                        datas[j].setAccountLongNumber(account.getLongNumber());
                        datas[j].setAccountIsLeaf(account.isIsLeaf() ? 1 : 0);
                    }
                    this.sum(ctx, con, datas, otherCtx);
                }
            }
        }
        catch (SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)e1);
                }
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps2);
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps2);
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private boolean compareCurrency(ResultSet rs, String[] currencys) throws SQLException {
        String currencyId = null;
        List list = Arrays.asList((Object[])currencys);
        ArrayList<String> temp = new ArrayList<String>();
        while (rs != null && rs.next()) {
            temp.add(rs.getString(1));
        }
        if (list.size() != temp.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            currencyId = (String)list.get(i);
            if (temp.contains(currencyId)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List _getCurrencyData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<CurrencyInfo> list = new ArrayList<CurrencyInfo>();
        String profitCenterId = (String)otherCtx.get("PROFITCENTERID");
        String companyId = (String)otherCtx.get("COMPANYID");
        String accountTableId = (String)otherCtx.get("ACCOUNTTABLEID");
        String tempSql = "select  balance.fcurrencyid from t_pca_initPcaccountBalance balance inner join t_bd_accountview av on av.fid = balance.faccountid where FProfitCenterID = ? and FOrgUnitID = ? and av.faccounttableid = ?  and balance.fcurrencyid<> ? and balance.fcurrencyid<> ? group by balance.fcurrencyid ";
        StringBuffer sql = new StringBuffer("select cur.fid, cur.fname_").append(ctx.getLocale()).append(" fname from t_bd_currency cur ");
        sql.append(" where fid <> ? and fid <> ? and exists ").append("(select 1   from t_pca_initPcaccountBalance balance \r\n");
        sql.append(" inner join t_bd_accountview av   on av.fid = balance.faccountid \r\n");
        sql.append("where FProfitCenterID = ? and FOrgUnitID = ? and av.faccounttableid = ?   and balance.fcurrencyid = cur.fid)");
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString());
            ps.setString(2, CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
            ps.setString(3, profitCenterId);
            ps.setString(4, companyId);
            ps.setString(5, accountTableId);
            rs = ps.executeQuery();
            CurrencyInfo currency = null;
            while (rs != null && rs.next()) {
                currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)rs.getString(1)));
                currency.setName(rs.getString(2));
                list.add(currency);
            }
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)e1);
                }
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return list;
    }
}

