/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ParamException;
import com.kingdee.eas.ma.pca.PCAParamInfo;
import com.kingdee.eas.ma.pca.app.AbstractPCAParamFacadeControllerBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PCAParamFacadeControllerBean
extends AbstractPCAParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PCAParamFacadeControllerBean");

    @Override
    protected PCAParamInfo _getGLParamInfo(Context ctx, IObjectValue profitCenter) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo company = (ProfitCenterOrgUnitInfo)profitCenter;
        HashMap prop = new HashMap();
        prop = this.innerGetGLParamInfo(ctx, company);
        if (prop.size() == 0) {
            throw new ParamException(ParamException.NOTINIT, new Object[]{""});
        }
        return this.genParamInfoFromProp(prop);
    }

    @Override
    protected boolean _save(Context ctx, PCAParamInfo paramInfo, HashMap otherCtx) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo company = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        IParamItem paramItemCtrl = ParamItemFactory.getLocalInstance((Context)ctx);
        for (ParamItemInfo info : paramInfo.getProperties().values()) {
            if ("update".equals(info.get("status"))) {
                ParamManager.updateParamItemByNumberAndOrg((Context)ctx, (String)info.getKeyID().getNumber(), (String)company.getId().toString(), (String)info.getValue());
                continue;
            }
            info.setIsControlSub(false);
            info.setIsModify(true);
            info.setOrgUnitID((OrgUnitInfo)company);
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l1"));
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l2"));
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l3"));
            paramItemCtrl.addnewNoVerify(info, info.getKeyID());
        }
        return true;
    }

    private HashMap innerGetGLParamInfo(Context ctx, ProfitCenterOrgUnitInfo company) throws BOSException, EASBizException {
        String locala = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = " select param.fid paramid,param.fnumber fnumber,param.fdefaultval_" + locala + " defaultvalue,item.fid itemid,item.fvalue_" + locala + " fvalue,item.forgunitid orgunitid,item.fiscontrolsub iscontrolsub,item.fismodify ismodify from t_bas_param param left join t_bas_paramitem item on param.fid=item.fkeyid and item.forgunitid=?where param.fsubsysid=? ";
        Connection con = null;
        HashMap<String, ParamItemInfo> prop = new HashMap<String, ParamItemInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            ps.setString(1, company.get(company.getPKField()).toString());
            ps.setString(2, this.getSubSysId());
            rs = ps.executeQuery();
            while (rs.next()) {
                ParamItemInfo info = new ParamItemInfo();
                String id = rs.getString("itemid");
                String value = null;
                if (id != null) {
                    info.setId(BOSUuid.read((String)id));
                    value = rs.getString("fvalue");
                } else {
                    value = rs.getString("defaultvalue");
                }
                info.setValue(value);
                ParamInfo paraminfo = new ParamInfo();
                paraminfo.setId(BOSUuid.read((String)rs.getString("paramid")));
                String number = rs.getString("fnumber");
                paraminfo.setNumber(number);
                info.setKeyID(paraminfo);
                prop.put(number, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return prop;
    }

    private PCAParamInfo genParamInfoFromProp(HashMap prop) {
        return new PCAParamInfo(prop);
    }

    private String getSubSysId() {
        return "com.kingdee.eas.ma.pca.pca";
    }
}

