/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.ma.pca.PcCashflowRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowRecordFactory;
import com.kingdee.eas.ma.pca.PcCashflowRecordInfo;
import com.kingdee.eas.ma.pca.PcCashflowSplitRecordCollection;
import com.kingdee.eas.ma.pca.PcCashflowSplitRecordInfo;
import com.kingdee.eas.ma.pca.PcCashflowUtils;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.app.ITAccountSplitStrategy;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PLVoucherEntrySplitStrategy
implements ITAccountSplitStrategy {
    protected static final Logger logger = Logger.getLogger(PLVoucherEntrySplitStrategy.class);
    public static final String cashflowAccountDiff = "cashflowAccountDiff";
    public static final String cashflowRecords = "cashflowRecords";
    public static final String cashflowSplitRecords = "cashflowSplitRecords";

    private PLVoucherEntrySplitStrategy() {
    }

    public static ITAccountSplitStrategy getInstance() {
        return new PLVoucherEntrySplitStrategy();
    }

    @Override
    public PcCashflowSplitRecordCollection split(Context ctx, PcVoucherInfo voucherInfo, Map params) throws EASBizException, BOSException {
        long currTime = System.currentTimeMillis();
        if (voucherInfo.getSourceType() == SourceType.PROFIT_AND_LOSS) {
            return new PcCashflowSplitRecordCollection();
        }
        Map cfAccountDiffMap = null;
        if (params != null) {
            cfAccountDiffMap = (Map)params.get(cashflowAccountDiff);
        }
        if (cfAccountDiffMap == null) {
            cfAccountDiffMap = PcCashflowUtils.getDifferenceMap(ctx, voucherInfo.getCompany().getId().toString());
        }
        if (!this.hasPLAccount(ctx, voucherInfo, cfAccountDiffMap)) {
            return new PcCashflowSplitRecordCollection();
        }
        PcCashflowRecordCollection cfColl = null;
        PcCashflowSplitRecordCollection splitColl = null;
        if (params != null) {
            cfColl = (PcCashflowRecordCollection)params.get(cashflowRecords);
            splitColl = (PcCashflowSplitRecordCollection)params.get(cashflowSplitRecords);
        }
        PcVoucherEntryCollection newEtryColl = this.deductCashflow(voucherInfo, cfColl, splitColl);
        PcVoucherEntryCollection[] entryColls = this.groupVoucherEntry(voucherInfo, newEtryColl, cfAccountDiffMap);
        this.disposePL(ctx, voucherInfo, entryColls[1], entryColls[2]);
        PcCashflowSplitRecordCollection plSplitColl = this.splitPL(ctx, voucherInfo, entryColls[0], entryColls[1], entryColls[2]);
        logger.info((Object)("PL split take " + (System.currentTimeMillis() - currTime) + " ms."));
        return plSplitColl;
    }

    private PcVoucherEntryCollection deductCashflow(PcVoucherInfo voucherInfo, PcCashflowRecordCollection cfColl, PcCashflowSplitRecordCollection splitColl) {
        PcVoucherEntryInfo oppEntry;
        PcVoucherEntryCollection entryColl = voucherInfo.getEntries();
        PcVoucherEntryCollection cfEntryColl = new PcVoucherEntryCollection();
        HashMap<BOSUuid, PcVoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, PcVoucherEntryInfo>();
        Iterator itEntry = entryColl.iterator();
        PcVoucherEntryInfo voucherEntryInfo = null;
        while (itEntry.hasNext()) {
            voucherEntryInfo = (PcVoucherEntryInfo)itEntry.next();
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
        }
        if (cfColl != null) {
            for (PcCashflowRecordInfo cfRecordInfo : cfColl) {
                PcVoucherEntryInfo entry = cfRecordInfo.getEntry();
                entry = (PcVoucherEntryInfo)voucherEntryMap.get(entry.getId());
                BigDecimal[] amount = new BigDecimal[]{cfRecordInfo.getOriginalAmount(), cfRecordInfo.getLocalAmount(), cfRecordInfo.getReportingAmount()};
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry);
                if (cfRecordInfo.getItemFlag() == ItemFlag.DISPOSE) continue;
                oppEntry = cfRecordInfo.getOpposingAccountEntry();
                oppEntry = (PcVoucherEntryInfo)voucherEntryMap.get(oppEntry.getId());
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry, oppEntry);
            }
        }
        if (splitColl != null) {
            for (PcCashflowSplitRecordInfo splitInfo : splitColl) {
                BigDecimal[] amount = new BigDecimal[]{splitInfo.getOriginalAmount(), splitInfo.getLocalAmount(), splitInfo.getReportingAmount()};
                PcVoucherEntryInfo entry = splitInfo.getEntry();
                entry = this.getVoucherEntryInfo(entryColl, entry.getId());
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry);
                oppEntry = splitInfo.getOpposingAccountEntry();
                oppEntry = this.getVoucherEntryInfo(entryColl, oppEntry.getId());
                this.deductCashflow(voucherInfo, entryColl, cfEntryColl, amount, entry, oppEntry);
            }
        }
        PcVoucherEntryCollection newEntryColl = new PcVoucherEntryCollection();
        Iterator entryIt = entryColl.iterator();
        PcVoucherEntryInfo tmpEntry = null;
        while (entryIt.hasNext()) {
            tmpEntry = (PcVoucherEntryInfo)entryIt.next();
            if (PcCashflowUtils.isCashAccount(tmpEntry.getAccount())) continue;
            PcVoucherEntryInfo newEntry = cfEntryColl.get((Object)tmpEntry.getId());
            if (newEntry == null) {
                newEntry = new PcVoucherEntryInfo();
                newEntry.setId(tmpEntry.getId());
                newEntry.setAccount(tmpEntry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(tmpEntry.getCurrency());
                newEntry.setLocalAmount(tmpEntry.getLocalAmount());
                newEntry.setOriginalAmount(tmpEntry.getOriginalAmount());
                newEntry.setReportingAmount(tmpEntry.getReportingAmount());
                newEntry.setEntryDC(tmpEntry.getEntryDC());
                newEntry.setSeq(tmpEntry.getSeq());
                newEntry.setLocalExchangeRate(tmpEntry.getLocalExchangeRate());
            }
            if (newEntry.getLocalAmount().doubleValue() == 0.0) continue;
            newEntryColl.add(newEntry);
        }
        return newEntryColl;
    }

    private PcVoucherEntryInfo getVoucherEntryInfo(PcVoucherEntryCollection entryColl, BOSUuid entryId) {
        PcVoucherEntryInfo entry2 = entryColl.get((Object)entryId);
        if (entry2 != null) {
            return entry2;
        }
        for (PcVoucherEntryInfo entry2 : entryColl) {
            if (!entry2.getId().equals((Object)entryId)) continue;
            return entry2;
        }
        return null;
    }

    private void deductCashflow(PcVoucherInfo voucherInfo, PcVoucherEntryCollection entryColl, PcVoucherEntryCollection cfEntryColl, BigDecimal[] amount, PcVoucherEntryInfo entry, PcVoucherEntryInfo oppEntry) {
        if (oppEntry != null && !PcCashflowUtils.isCashAccount(oppEntry.getAccount())) {
            PcVoucherEntryInfo newEntry = (PcVoucherEntryInfo)cfEntryColl.getObject((Object)oppEntry.getId());
            if (newEntry == null) {
                newEntry = new PcVoucherEntryInfo();
                newEntry.setId(oppEntry.getId());
                newEntry.setAccount(oppEntry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(oppEntry.getCurrency());
                newEntry.setLocalAmount(oppEntry.getLocalAmount());
                newEntry.setOriginalAmount(oppEntry.getOriginalAmount());
                newEntry.setReportingAmount(oppEntry.getReportingAmount());
                newEntry.setEntryDC(oppEntry.getEntryDC());
                newEntry.setSeq(oppEntry.getSeq());
                newEntry.setLocalExchangeRate(oppEntry.getLocalExchangeRate());
                cfEntryColl.add(newEntry);
            }
            BigDecimal origAmount = amount[0];
            BigDecimal localAmount = amount[1];
            BigDecimal rptAmount = amount[2];
            if (entry.getEntryDC() == oppEntry.getEntryDC()) {
                origAmount = origAmount.negate();
                localAmount = localAmount.negate();
                rptAmount = rptAmount.negate();
            }
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(localAmount));
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(origAmount));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(rptAmount));
        }
    }

    private void deductCashflow(PcVoucherInfo voucherInfo, PcVoucherEntryCollection entryColl, PcVoucherEntryCollection cfEntryColl, BigDecimal[] amount, PcVoucherEntryInfo entry) {
        if (entry != null && !PcCashflowUtils.isCashAccount(entry.getAccount())) {
            PcVoucherEntryInfo newEntry = (PcVoucherEntryInfo)cfEntryColl.getObject((Object)entry.getId());
            if (newEntry == null) {
                newEntry = new PcVoucherEntryInfo();
                newEntry.setId(entry.getId());
                newEntry.setAccount(entry.getAccount());
                newEntry.setBill(voucherInfo);
                newEntry.setCurrency(entry.getCurrency());
                newEntry.setLocalAmount(entry.getLocalAmount());
                newEntry.setOriginalAmount(entry.getOriginalAmount());
                newEntry.setReportingAmount(entry.getReportingAmount());
                newEntry.setEntryDC(entry.getEntryDC());
                newEntry.setSeq(entry.getSeq());
                newEntry.setLocalExchangeRate(entry.getLocalExchangeRate());
                cfEntryColl.add(newEntry);
            }
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(amount[0]));
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(amount[1]));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(amount[2]));
        }
    }

    private PcCashflowSplitRecordCollection splitPL(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryCollection newEntryColl, PcVoucherEntryCollection debitEntryColl, PcVoucherEntryCollection creditEntryColl) {
        PcCashflowSplitRecordCollection splitColl = new PcCashflowSplitRecordCollection();
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, debitEntryColl, false));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, creditEntryColl, false));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, debitEntryColl, true));
        splitColl.addCollection(this.splitPL(ctx, voucherInfo, newEntryColl, creditEntryColl, true));
        return splitColl;
    }

    private PcCashflowSplitRecordCollection splitPL(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryCollection newEntryColl, PcVoucherEntryCollection plEntryColl, boolean isSameDC) {
        PcCashflowSplitRecordCollection splitColl = new PcCashflowSplitRecordCollection();
        Iterator plEntryIt = plEntryColl.iterator();
        int plEntrySize = plEntryColl.size();
        block0: while (plEntryIt.hasNext()) {
            PcVoucherEntryInfo plEntry = (PcVoucherEntryInfo)plEntryIt.next();
            Iterator newEntryIt = newEntryColl.iterator();
            while (newEntryIt.hasNext()) {
                PcVoucherEntryInfo newEntry = (PcVoucherEntryInfo)newEntryIt.next();
                if (isSameDC) {
                    if (newEntry.getEntryDC() == plEntry.getEntryDC() && newEntry.getLocalAmount().signum() != plEntry.getLocalAmount().signum()) {
                        splitColl.add(this.splitSingleDC(ctx, voucherInfo, plEntryIt, plEntry, newEntryIt, newEntry));
                    }
                } else if (newEntry.getEntryDC() != plEntry.getEntryDC() && newEntry.getLocalAmount().signum() == plEntry.getLocalAmount().signum()) {
                    splitColl.add(this.splitDebitAndCredit(ctx, voucherInfo, plEntryIt, plEntry, newEntryIt, newEntry));
                }
                if (plEntryColl.size() >= plEntrySize) continue;
                plEntrySize = plEntryColl.size();
                continue block0;
            }
        }
        return splitColl;
    }

    private PcCashflowSplitRecordInfo splitSingleDC(Context ctx, PcVoucherInfo voucherInfo, Iterator plEntryIt, PcVoucherEntryInfo plEntry, Iterator newEntryIt, PcVoucherEntryInfo newEntry) {
        BigDecimal minLocValue = plEntry.getLocalAmount();
        BigDecimal minOrgValue = plEntry.getOriginalAmount();
        BigDecimal minRptValue = plEntry.getReportingAmount();
        if (minLocValue.abs().compareTo(newEntry.getLocalAmount().abs()) < 0) {
            plEntryIt.remove();
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().add(plEntry.getOriginalAmount().multiply(plEntry.getLocalExchangeRate()).divide(newEntry.getLocalExchangeRate(), newEntry.getOriginalAmount().scale(), 4)));
            newEntry.setLocalAmount(newEntry.getLocalAmount().add(plEntry.getLocalAmount()));
            newEntry.setReportingAmount(newEntry.getReportingAmount().add(plEntry.getReportingAmount()));
        } else if (plEntry.getLocalAmount().abs().compareTo(newEntry.getLocalAmount().abs()) > 0) {
            newEntryIt.remove();
            minLocValue = newEntry.getLocalAmount().negate();
            minOrgValue = newEntry.getOriginalAmount().negate();
            minRptValue = newEntry.getReportingAmount().negate();
            plEntry.setOriginalAmount(plEntry.getOriginalAmount().add(newEntry.getOriginalAmount().multiply(newEntry.getLocalExchangeRate()).divide(plEntry.getLocalExchangeRate(), plEntry.getOriginalAmount().scale(), 4)));
            plEntry.setLocalAmount(plEntry.getLocalAmount().add(newEntry.getLocalAmount()));
            plEntry.setReportingAmount(plEntry.getReportingAmount().add(newEntry.getReportingAmount()));
        } else {
            newEntryIt.remove();
            plEntryIt.remove();
        }
        return this.createCashflowSplitRecordInfo(ctx, voucherInfo, plEntry, newEntry, minLocValue, minOrgValue, minRptValue);
    }

    private PcCashflowSplitRecordInfo createCashflowSplitRecordInfo(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entry, PcVoucherEntryInfo oppEntry, BigDecimal locAmount, BigDecimal orgAmount, BigDecimal rptAmount) {
        PcCashflowSplitRecordInfo splitInfo = new PcCashflowSplitRecordInfo();
        splitInfo.setVoucher(voucherInfo);
        splitInfo.setEntry(entry);
        splitInfo.setAccount(entry.getAccount());
        splitInfo.setCurrency(entry.getCurrency());
        splitInfo.setEntryDC(entry.getEntryDC());
        splitInfo.setOpposingAccountEntry(oppEntry);
        splitInfo.setOppAccount(oppEntry.getAccount());
        splitInfo.setOppEntryDC(oppEntry.getEntryDC());
        splitInfo.setIsSupItem(voucherInfo.isHasCashAccount());
        splitInfo.setItemFlag(ItemFlag.SUPPLEMENTARY);
        splitInfo.setSourceType(1);
        splitInfo.setOriginalAmount(orgAmount);
        splitInfo.setLocalAmount(locAmount);
        splitInfo.setReportingAmount(rptAmount);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitInfo.setCreateTime(nowTime);
        splitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitInfo.setLastUpdateTime(nowTime);
        return splitInfo;
    }

    private PcCashflowSplitRecordInfo splitDebitAndCredit(Context ctx, PcVoucherInfo voucherInfo, Iterator plEntryIt, PcVoucherEntryInfo plEntry, Iterator newEntryIt, PcVoucherEntryInfo newEntry) {
        BigDecimal minLocValue = plEntry.getLocalAmount();
        BigDecimal minOrgValue = plEntry.getOriginalAmount();
        BigDecimal minRptValue = plEntry.getReportingAmount();
        if (minLocValue.abs().compareTo(newEntry.getLocalAmount().abs()) < 0) {
            plEntryIt.remove();
            newEntry.setOriginalAmount(newEntry.getOriginalAmount().subtract(plEntry.getOriginalAmount().multiply(plEntry.getLocalExchangeRate()).divide(newEntry.getLocalExchangeRate(), newEntry.getOriginalAmount().scale(), 4)));
            newEntry.setLocalAmount(newEntry.getLocalAmount().subtract(plEntry.getLocalAmount()));
            newEntry.setReportingAmount(newEntry.getReportingAmount().subtract(plEntry.getReportingAmount()));
        } else if (plEntry.getLocalAmount().abs().compareTo(newEntry.getLocalAmount().abs()) > 0) {
            newEntryIt.remove();
            minLocValue = newEntry.getLocalAmount();
            minOrgValue = newEntry.getOriginalAmount();
            minRptValue = newEntry.getReportingAmount();
            plEntry.setOriginalAmount(plEntry.getOriginalAmount().subtract(newEntry.getOriginalAmount().multiply(newEntry.getLocalExchangeRate()).divide(plEntry.getLocalExchangeRate(), plEntry.getOriginalAmount().scale(), 4)));
            plEntry.setLocalAmount(plEntry.getLocalAmount().subtract(newEntry.getLocalAmount()));
            plEntry.setReportingAmount(plEntry.getReportingAmount().subtract(newEntry.getReportingAmount()));
        } else {
            newEntryIt.remove();
            plEntryIt.remove();
        }
        return this.createCashflowSplitRecordInfo(ctx, voucherInfo, plEntry, newEntry, minLocValue, minOrgValue, minRptValue);
    }

    private void disposePL(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryCollection debitEntryColl, PcVoucherEntryCollection creditEntryColl) throws EASBizException, BOSException {
        PcCashflowRecordCollection disposeColl = new PcCashflowRecordCollection();
        disposeColl.addCollection(this.disposeDebitAndCredit(ctx, voucherInfo, debitEntryColl, creditEntryColl));
        disposeColl.addCollection(this.disposeSingleDC(ctx, voucherInfo, debitEntryColl));
        disposeColl.addCollection(this.disposeSingleDC(ctx, voucherInfo, creditEntryColl));
        if (disposeColl.size() > 0) {
            for (int i = 1; i <= disposeColl.size(); ++i) {
                PcCashflowRecordInfo record = disposeColl.get(i - 1);
                record.setSeq(i);
            }
            PcCashflowRecordFactory.getLocalInstance(ctx).addNewBatch(disposeColl);
        }
    }

    private PcCashflowRecordCollection disposeSingleDC(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryCollection entryColl) {
        PcCashflowRecordCollection disposeColl = new PcCashflowRecordCollection();
        Iterator entryIt = entryColl.iterator();
        PcVoucherEntryInfo firstEntry = null;
        PcVoucherEntryInfo entry = null;
        PcVoucherEntryInfo tmpEntry = null;
        while (entryIt.hasNext()) {
            entry = (PcVoucherEntryInfo)entryIt.next();
            if (firstEntry == null) {
                firstEntry = entry;
                continue;
            }
            if (!entry.getCurrency().getId().equals((Object)firstEntry.getCurrency().getId()) || firstEntry.getLocalAmount().signum() == entry.getLocalAmount().signum()) continue;
            int entrySig = entry.getLocalAmount().signum();
            int firstESig = firstEntry.getLocalAmount().signum();
            BigDecimal minLocValue = firstEntry.getLocalAmount().abs();
            BigDecimal minOrgValue = firstEntry.getOriginalAmount().abs();
            BigDecimal minRptValue = firstEntry.getReportingAmount().abs();
            if (minLocValue.compareTo(entry.getLocalAmount().abs()) < 0) {
                entryColl.remove(firstEntry);
                entry.setOriginalAmount(entry.getOriginalAmount().add(firstEntry.getOriginalAmount()));
                entry.setLocalAmount(entry.getLocalAmount().add(firstEntry.getLocalAmount()));
                entry.setReportingAmount(entry.getReportingAmount().add(firstEntry.getReportingAmount()));
                tmpEntry = firstEntry;
                firstEntry = null;
                entryIt = entryColl.iterator();
            } else if (minLocValue.compareTo(entry.getLocalAmount().abs()) > 0) {
                minLocValue = entry.getLocalAmount().abs();
                minOrgValue = entry.getOriginalAmount().abs();
                minRptValue = entry.getReportingAmount().abs();
                entryIt.remove();
                firstEntry.setOriginalAmount(firstEntry.getOriginalAmount().add(entry.getOriginalAmount()));
                firstEntry.setLocalAmount(firstEntry.getLocalAmount().add(entry.getLocalAmount()));
                firstEntry.setReportingAmount(firstEntry.getReportingAmount().add(entry.getReportingAmount()));
                tmpEntry = firstEntry;
            } else {
                entryIt.remove();
                entryColl.remove(firstEntry);
                tmpEntry = firstEntry;
                firstEntry = null;
                entryIt = entryColl.iterator();
            }
            if (entrySig == -1) {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
            } else {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, minLocValue, minOrgValue, minRptValue));
            }
            if (firstESig == -1) {
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, minLocValue.negate(), minOrgValue.negate(), minRptValue.negate()));
                continue;
            }
            disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, tmpEntry, minLocValue, minOrgValue, minRptValue));
        }
        return disposeColl;
    }

    private PcCashflowRecordCollection disposeDebitAndCredit(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryCollection debitEntryColl, PcVoucherEntryCollection creditEntryColl) {
        PcCashflowRecordCollection disposeColl = new PcCashflowRecordCollection();
        Iterator plDebitEntryIt = debitEntryColl.iterator();
        PcVoucherEntryInfo debitEntry = null;
        PcVoucherEntryInfo creditEntry = null;
        block0: while (plDebitEntryIt.hasNext()) {
            debitEntry = (PcVoucherEntryInfo)plDebitEntryIt.next();
            Iterator plCreditEntryIt = creditEntryColl.iterator();
            while (plCreditEntryIt.hasNext()) {
                PcVoucherEntryInfo entry = null;
                if (debitEntry == null) continue block0;
                creditEntry = (PcVoucherEntryInfo)plCreditEntryIt.next();
                if (!debitEntry.getCurrency().getId().equals((Object)creditEntry.getCurrency().getId()) || debitEntry.getLocalAmount().signum() != creditEntry.getLocalAmount().signum()) continue;
                BigDecimal minLocValue = debitEntry.getLocalAmount();
                BigDecimal minOrgValue = debitEntry.getOriginalAmount();
                BigDecimal minRptValue = debitEntry.getReportingAmount();
                if (minLocValue.abs().compareTo(creditEntry.getLocalAmount().abs()) < 0) {
                    plDebitEntryIt.remove();
                    creditEntry.setOriginalAmount(creditEntry.getOriginalAmount().subtract(minOrgValue));
                    creditEntry.setLocalAmount(creditEntry.getLocalAmount().subtract(minLocValue));
                    creditEntry.setReportingAmount(creditEntry.getReportingAmount().subtract(minRptValue));
                    entry = debitEntry;
                    debitEntry = null;
                } else if (minLocValue.abs().compareTo(creditEntry.getLocalAmount().abs()) > 0) {
                    minLocValue = creditEntry.getLocalAmount();
                    minOrgValue = creditEntry.getOriginalAmount();
                    minRptValue = creditEntry.getReportingAmount();
                    plCreditEntryIt.remove();
                    debitEntry.setOriginalAmount(debitEntry.getOriginalAmount().subtract(minOrgValue));
                    debitEntry.setLocalAmount(debitEntry.getLocalAmount().subtract(minLocValue));
                    debitEntry.setReportingAmount(debitEntry.getReportingAmount().subtract(minRptValue));
                    entry = debitEntry;
                } else {
                    plDebitEntryIt.remove();
                    plCreditEntryIt.remove();
                    entry = debitEntry;
                    debitEntry = null;
                }
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, entry, minLocValue, minOrgValue, minRptValue));
                disposeColl.add(this.createCashflowRecord(ctx, voucherInfo, creditEntry, minLocValue, minOrgValue, minRptValue));
            }
        }
        return disposeColl;
    }

    private PcCashflowRecordInfo createCashflowRecord(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entry, BigDecimal locAmount, BigDecimal orgAmount, BigDecimal rptAmount) {
        PcCashflowRecordInfo cf = new PcCashflowRecordInfo();
        cf.setVoucher(voucherInfo);
        cf.setEntry(entry);
        cf.setOpposingAccountEntry(entry);
        cf.setOriginalAmount(orgAmount);
        cf.setLocalAmount(locAmount);
        cf.setReportingAmount(rptAmount);
        cf.setIsSupItem(voucherInfo.isHasCashAccount());
        cf.setSupplementaryCoefficient(1);
        cf.setType(CashflowTypeEnum.NONE);
        cf.setItemFlag(ItemFlag.DISPOSE);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        cf.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cf.setCreateTime(nowTime);
        cf.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        cf.setLastUpdateTime(nowTime);
        return cf;
    }

    private PcVoucherEntryCollection[] groupVoucherEntry(PcVoucherInfo voucher, PcVoucherEntryCollection entryColl, Map cfAccountDiffMap) {
        PcVoucherEntryCollection newEntryColl = new PcVoucherEntryCollection();
        PcVoucherEntryCollection debitEntryColl = new PcVoucherEntryCollection();
        PcVoucherEntryCollection creditEntryColl = new PcVoucherEntryCollection();
        for (PcVoucherEntryInfo entry : entryColl) {
            if (!PcCashflowUtils.isCashAccount(entry.getAccount()) && (entry.getAccount().getPLType() == AccountPLType.NONE || cfAccountDiffMap.containsKey(entry.getAccount().getId().toString()))) {
                newEntryColl.add(entry);
                continue;
            }
            if (entry.getEntryDC() == EntryDC.CREDIT) {
                creditEntryColl.add(entry);
                continue;
            }
            debitEntryColl.add(entry);
        }
        PcVoucherEntryCollection[] entryColls = new PcVoucherEntryCollection[]{newEntryColl, debitEntryColl, creditEntryColl};
        return entryColls;
    }

    private boolean hasPLAccount(Context ctx, PcVoucherInfo voucher, Map cfAccountDiffMap) throws BOSException {
        Iterator entryIt = voucher.getEntries().iterator();
        while (entryIt.hasNext()) {
            AccountViewInfo account = ((PcVoucherEntryInfo)entryIt.next()).getAccount();
            if (account == null || account.getPLType() == AccountPLType.NONE || cfAccountDiffMap.containsKey(account.getId().toString())) continue;
            return true;
        }
        return false;
    }
}

