/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.ma.pca.IPcaBalanceFacade;
import com.kingdee.eas.ma.pca.IPcaFlag;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceCollection;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceFactory;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceInfo;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractPcAssistInitFacadeControllerBean;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcAssistInitFacadeControllerBean
extends AbstractPcAssistInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcAssistInitFacadeControllerBean");

    @Override
    protected ArrayList _findInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CurrencyCollection curCol;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        CompanyOrgUnitInfo relatedCompany = (CompanyOrgUnitInfo)otherCtx.get("RELATEDCOMPANY");
        if (relatedCompany == null) {
            relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenter.getId().toString());
            otherCtx.put("RELATEDCOMPANY", relatedCompany);
            otherCtx.put("RELATEDCOMPANYID", relatedCompany.getId().toString());
        }
        if (company == null || relatedCompany == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (relatedCompany.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(false);
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)relatedCompany.getBaseCurrency().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
            filter.setMaskString("#0 or #1");
            curCol = curCtrl.getCurrencyCollection(view);
        }
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        Map hmParamValue = InitHelp.getInitParam((Context)ctx, (CompanyOrgUnitInfo)relatedCompany);
        result.add(hmParamValue.get("GL_002"));
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        result.add(curCol);
        PeriodInfo[] periods = this.getPeriods(ctx, relatedCompany, profitCenter);
        result.add(periods[0]);
        result.add(periods[2]);
        result.add(periods[1]);
        LowTimer low = new LowTimer();
        low.reset();
        try {
            result.add(this._getAllAssistAccountBySql(ctx, otherCtx));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        low.reset();
        otherCtx.put("COMPANYID", company.getId().toString());
        result.add(this._getAllInitClosed(ctx, otherCtx));
        result.add(InitHelp.getAccountTableCollection((Context)ctx, (String)relatedCompany.getId().toString()));
        result.add(hmParamValue.get("G010"));
        result.add(hmParamValue.get("GL_028"));
        low.reset();
        return result;
    }

    @Override
    protected String[] _getAllInitClosed(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        if (StringUtils.isEmpty((String)companyId)) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
            companyId = company.getId().toString();
        }
        ctx.put((Object)"companyID", otherCtx.get("COMPANYID"));
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllAstInitClosed(orgUnitId + "," + companyId);
        return result;
    }

    protected IObjectCollection _getAllAssistAccountBySql(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        AsstAccountCollection result = new AsstAccountCollection();
        CompanyOrgUnitInfo relatedCompany = (CompanyOrgUnitInfo)otherCtx.get("RELATEDCOMPANY");
        if (relatedCompany == null) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
            try {
                relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenter.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String loc = ctx.getLocale().getLanguage();
        String sql = "select asstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_" + loc + " as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId, \t\n asstActType.fname_" + loc + " as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName,\n asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient,b.fac,asstActType.FUseLongNumber \n from t_bd_asstactgroupdetail a\t \n inner join t_bd_accountview b on b.fcaa = a.fasstaccountid\n inner join t_bd_asstaccount asstAccount on a.fasstaccountid = asstAccount.fid\t\n inner join t_bd_asstacttype asstActType on a.fasstActTypeid = asstActType.fid\t\n left join t_bd_measureunit m on asstAccount.fmeasureunitid=m.fid \n where b.fcompanyid=? and b.faccounttableid=? and b.fisleaf=1 \n order by asstAccountId desc,a.fseq,asstActTypeNumber  \n";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{relatedCompany.getId().toString(), accouttable});
        if (set != null) {
            HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
            while (set.next()) {
                String asstid = set.getString("asstAccountId");
                AsstAccountInfo temp = null;
                if (cache.containsKey(asstid)) {
                    temp = (AsstAccountInfo)cache.get(asstid);
                    if (set.getBoolean("fac")) {
                        temp.setBoolean("isAc", true);
                    }
                } else {
                    temp = new AsstAccountInfo();
                    temp.setId(BOSUuid.read((String)asstid));
                    temp.setNumber(set.getString("asstAccountNumber"));
                    temp.setCount(set.getInt("asstcount"));
                    temp.setName(set.getString("asstAccountName"));
                    temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                    temp.setIsQty(set.getBoolean("fisqty"));
                    temp.setBoolean("isAc", set.getBoolean("fac"));
                    if (set.getString("fmeasureunitid") != null) {
                        MeasureUnitInfo unit = new MeasureUnitInfo();
                        unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                        unit.setName(set.getString("fmeasureunitname"));
                        unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                        temp.setMeasureUnit(unit);
                    }
                    if (set.getString("fmeasureunitgroupid") != null) {
                        MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                        unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                        temp.setMeasureUnitGroup(unitGroup);
                    }
                    result.add(temp);
                    cache.put(asstid, temp);
                }
                AsstActTypeInfo type = new AsstActTypeInfo();
                type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                type.setNumber(set.getString("asstActTypeNumber"));
                type.setName(set.getString("asstActTypeName"));
                type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                type.setMappingFieldName(set.getString("fmappingFieldName"));
                type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                type.setRealtionDataObject(set.getString("frealtionDataObject"));
                type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                type.setIsForCompany(set.getBoolean("fisForCompany"));
                type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                if (fglAsstActTypeGrpid != null) {
                    GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                    info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                    type.setGlAsstActTypeGrp(info);
                }
                ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
            }
        }
        return result;
    }

    private PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter) throws BOSException, EASBizException {
        return PcaInitHelp.getPeriods(ctx, company, profitCenter);
    }

    @Override
    protected void _closeInit(Context ctx, IObjectCollection accounts, String[] asstTypeAttrs, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        PeriodInfo curtPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        this.checkCloseInit(ctx, accounts, otherCtx);
        AccountViewCollection col = (AccountViewCollection)accounts;
        int size = accounts.size();
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append("'").append(col.get(i).getId().toString()).append("'");
        }
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.initAssistBalance(orgUnitId + "," + companyId, accounts, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
        updateBalance.initAssistMeasureBalance(orgUnitId + "," + companyId, accounts, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_pca_flag where forgUnitid = '").append(orgUnitId).append("' and fcompanyid = '").append(companyId).append("' and fname = 'astinit' and fkey in (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_pca_flag(fid,fname,fvalue,forgunitid,fcompanyid,fkey) select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("')");
        sql.append(",'astinit','true','").append(orgUnitId).append("','").append(companyId).append("',av.fid from t_bd_accountview av where av.fid in (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _cancelInit(Context ctx, IObjectCollection accounts, String[] asstTypeAttrs, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        AccountViewCollection col = (AccountViewCollection)accounts;
        int size = accounts.size();
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append("'").append(col.get(i).getId().toString()).append("'");
        }
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        if (accounts != null && accounts.size() > 0) {
            ctx.put((Object)"accounts", (Object)accounts);
        }
        updateBalance.antiInitBalance(orgUnitId + "," + companyId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "t_pca_pcassistbalance");
        updateBalance.antiInitBalance(orgUnitId + "," + companyId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "t_pca_pcassistmeasurebalance");
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_pca_flag where forgUnitid = '").append(orgUnitId).append("' and fcompanyid = '").append(companyId).append("' and fname = 'astinit' and fkey in (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_pca_flag(fid,fname,fvalue,forgunitid,fcompanyid,fkey) select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("')");
        sql.append(",'astinit','false','").append(orgUnitId).append("','").append(companyId).append("',av.fid from t_bd_accountview av where av.fid in (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (accounts != null && accounts.size() > 0) {
            ctx.remove((Object)"accounts");
        }
    }

    private void checkCloseInit(Context ctx, IObjectCollection selectedAccount, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = (String)otherCtx.get("COMPANYID");
        AccountViewCollection col = (AccountViewCollection)selectedAccount;
        int size = col.size();
        if (this.isPcaClosed(ctx, orgUnitId + "," + companyId)) {
            PcaInitHelp.checkAsstEqualPCA(ctx, col, otherCtx);
        }
    }

    private boolean isPcaClosed(Context ctx, String orgUnitId) throws BOSException {
        return this.getFlagCtrl(ctx).getPcaInitClosed(orgUnitId);
    }

    private IPcaFlag getFlagCtrl(Context ctx) throws BOSException {
        return PcaFlagFactory.getLocalInstance(ctx);
    }

    @Override
    protected ArrayList _getCanClosedAndCancelAccounts(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>(4);
        LowTimer low = new LowTimer();
        low.reset();
        if (otherCtx.get("RELATEDCOMPANYID") == null) {
            String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
            CompanyOrgUnitInfo relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenterId);
            otherCtx.put("RELATEDCOMPANY", relatedCompany);
            otherCtx.put("RELATEDCOMPANYID", relatedCompany.getId().toString());
        }
        String[] allcolsed = this._getAllInitClosed(ctx, otherCtx);
        low.reset();
        AccountViewCollection col = this.getAllAccount(ctx, asstAccountId, otherCtx);
        low.reset();
        AccountViewCollection canCloseInitAccount = new AccountViewCollection();
        AccountViewCollection cancelInitAccount = new AccountViewCollection();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                AccountViewInfo info = col.get(i);
                if (allcolsed != null && allcolsed.length > 0 && Arrays.asList(allcolsed).contains(info.getId().toString())) {
                    cancelInitAccount.add(info);
                    continue;
                }
                canCloseInitAccount.add(info);
            }
        }
        result.add(canCloseInitAccount);
        result.add(cancelInitAccount);
        low.reset();
        int hasColse = allcolsed == null ? 0 : cancelInitAccount.size();
        boolean isAllClosed = canCloseInitAccount.isEmpty();
        boolean isNonClosed = hasColse == 0;
        result.add(isAllClosed);
        result.add(isNonClosed);
        return result;
    }

    private ArrayList getAllCloseAccount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String profitCenterId = (String)otherCtx.get("PROFITCENTERID");
        String sql = "select distinct fkey from t_pca_flag flag,t_BD_AccountView acc where flag.forgunitid=? and flag.fcompanyid=? and flag.fname='astinit' and flag.fvalue='true' and acc.faccounttableid=? and acc.fid=flag.fkey and acc.fcaa is not null and acc.fisleaf=1 and acc.fcompanyid=? and flag.fcompanyid=?  ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{profitCenterId, companyId, accounttable, companyId, companyId});
        ArrayList<String> result = new ArrayList<String>();
        if (rs != null) {
            while (rs.next()) {
                result.add(rs.getString("fkey"));
            }
        }
        return result;
    }

    private AccountViewCollection getAllAccount(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException {
        String relatedCompanyId = (String)otherCtx.get("RELATEDCOMPANYID");
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        String accountid = (String)otherCtx.get("Account");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)relatedCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        return av.getAccountViewCollection(view);
    }

    private int getAllCount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        String accounttable;
        String sql = "select count(*) as count from t_BD_AccountView account where account.fcompanyid=? and account.faccounttableid=?   and account.fcaa is not null and account.fisleaf=1 ";
        String relatedCompanyId = (String)otherCtx.get("RELATEDCOMPANYID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{relatedCompanyId, accounttable = (String)otherCtx.get("ACCOUNTTABLEID")});
        if (rs != null && rs.next()) {
            return rs.getInt("count");
        }
        return 0;
    }

    @Override
    protected void _closeAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        otherCtx.put("Account", null);
        IObjectCollection accounts = this._getCanCloseInitAccount(ctx, null, otherCtx);
        if (accounts == null || accounts.size() <= 0) {
            return;
        }
        this._closeInit(ctx, accounts, null, otherCtx);
    }

    @Override
    protected IObjectCollection _getCanCloseInitAccount(Context ctx, String astAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        return this.getAccountCol(ctx, astAccountId, otherCtx, true);
    }

    private IObjectCollection getAccountCol(Context ctx, String asstAccountId, HashMap otherCtx, boolean isCanClose) throws EASBizException, BOSException {
        String relatedCompanyId = (String)otherCtx.get("RELATEDCOMPANYID");
        if (StringUtils.isEmpty((String)relatedCompanyId)) {
            String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
            CompanyOrgUnitInfo relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenterId);
            relatedCompanyId = relatedCompany.getId().toString();
        }
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        String accountid = (String)otherCtx.get("Account");
        String[] accountIds = this._getAllInitClosed(ctx, otherCtx);
        FilterInfo filter = new FilterInfo();
        StringBuffer str = new StringBuffer();
        if (accountIds != null) {
            for (int i = 0; i < accountIds.length; ++i) {
                str.append(",").append(accountIds[i]);
            }
            str.deleteCharAt(0);
            if (isCanClose) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.NOTINCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
            }
            filter.setMaskString(" #0 ");
        }
        AccountViewCollection accounts = (AccountViewCollection)this.getAccountFromAsstAccount(ctx, asstAccountId, relatedCompanyId, accounttableid, accountid, filter);
        return accounts;
    }

    private IObjectCollection getAccountFromAsstAccount(Context ctx, String asstAccountId, String orgUnitId, String accounttableid, String accountId, FilterInfo filter) throws BOSException {
        int index;
        String mask;
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if ((mask = filter.getMaskString()) == null) {
            mask = "";
        }
        if ((index = filter.getFilterItems().size()) > 0) {
            mask = mask + " and ";
        }
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
        mask = mask + "#" + index++;
        if (asstAccountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)asstAccountId));
            mask = mask + " and #" + index++;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
            mask = mask + " and #" + index++;
        }
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        mask = mask + " and #" + index++;
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
        mask = mask + " and #" + index++;
        if (accountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountId));
            mask = mask + " and #" + index++;
        }
        filter.setMaskString(mask);
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        return av.getAccountViewCollection(view);
    }

    @Override
    protected void _cancelAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        otherCtx.put("Account", null);
        IObjectCollection accounts = this._getCanCancelInitAccount(ctx, null, otherCtx);
        if (accounts == null || accounts.size() <= 0) {
            return;
        }
        this._cancelInit(ctx, accounts, null, otherCtx);
    }

    @Override
    protected IObjectCollection _getCanCancelInitAccount(Context ctx, String astAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        return this.getAccountCol(ctx, astAccountId, otherCtx, false);
    }

    @Override
    protected List _checkDuplicate(Context ctx, Map paramMap) throws BOSException, EASBizException {
        int i;
        ArrayList<String> duplicate = new ArrayList<String>();
        List addList = (List)paramMap.get("addList");
        List deleteList = (List)paramMap.get("deleteList");
        String profitCenterId = (String)paramMap.get("profitCenterId");
        String accountId = (String)paramMap.get("accountId");
        String currencyId = (String)paramMap.get("currencyId");
        String companyId = (String)paramMap.get("companyId");
        StringBuffer sql = new StringBuffer();
        sql.append("select FAssistGrpID from T_Pca_InitPcAssistBalance where FProfitCenterID = ? and FOrgUnitID = ? and FAccountID = ? and FCurrencyID= ?");
        if (deleteList.size() > 0) {
            sql.append(" and FAssistGrpID not in (");
            for (i = 0; i < deleteList.size(); ++i) {
                if (i == 0) {
                    sql.append("'");
                } else {
                    sql.append(",'");
                }
                String delete = (String)deleteList.get(i);
                sql.append(delete);
                sql.append("'");
            }
            sql.append(") ");
        }
        if (addList.size() > 0) {
            sql.append(" and FAssistGrpID in (");
            for (i = 0; i < addList.size(); ++i) {
                if (i == 0) {
                    sql.append("'");
                } else {
                    sql.append(",'");
                }
                String add = (String)addList.get(i);
                sql.append(add);
                sql.append("'");
            }
            sql.append(") ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, companyId, accountId, currencyId});
        try {
            if (rs.next()) {
                duplicate.add(rs.getString("FAssistGrpID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return duplicate;
    }

    @Override
    protected void _save(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        InitPcAssistBalanceInfo as;
        int i;
        String curAsstAccountid = otherCtx.get("curAsstAccountid") == null ? "" : otherCtx.get("curAsstAccountid").toString();
        String sql = "select max(Fseq) maxseq from T_Pca_InitPcAssistBalance";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int seq = 0;
        try {
            if (rs.next()) {
                seq = rs.getInt("maxseq");
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        for (i = 0; i < datas.size(); ++i) {
            as = (InitPcAssistBalanceInfo)datas.getObject(i);
            if (!as.get("persist_status").equals("deleted")) continue;
            this.myDelete(ctx, as, curAsstAccountid);
        }
        for (i = 0; i < datas.size(); ++i) {
            as = (InitPcAssistBalanceInfo)datas.getObject(i);
            if (as.get("persist_status").equals("new")) {
                as.setSeq(++seq);
                InitPcAssistBalanceFactory.getLocalInstance(ctx).addnew(as);
                continue;
            }
            if (!as.get("persist_status").equals("dirty")) continue;
            boolean existInitPcAssistBalance = this.existInitPcAssistBalanceInfo(ctx, as, otherCtx);
            if (!existInitPcAssistBalance) {
                InitPcAssistBalanceFactory.getLocalInstance(ctx).addnew(as);
            }
            this.myUpdate(ctx, as);
        }
        this.deletaFromInitPcAssistBalanceByAssgrpId(ctx, datas, otherCtx);
        this.saveGeneral(ctx, datas, otherCtx);
    }

    private void deletaFromInitPcAssistBalanceByAssgrpId(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        StringBuffer deleteBuffer = new StringBuffer();
        deleteBuffer.append("delete from t_pca_initpcassistbalance balance where balance.fprofitcenterid=? and balance.forgunitid=? and balance.fcurrencyid=?  and ( ");
        InitPcAssistBalanceInfo as = null;
        boolean isExecute = false;
        String assgrpid = "assgrpid";
        String or = "or";
        ArrayList<InitPcAssistBalanceInfo> list = new ArrayList<InitPcAssistBalanceInfo>();
        for (int i = 0; i < datas.size(); ++i) {
            as = (InitPcAssistBalanceInfo)datas.getObject(i);
            if (null == as.get(assgrpid) || as.get(assgrpid).equals(as.getAssistGrp().getId().toString())) continue;
            InitPcAssistBalanceInfo data = new InitPcAssistBalanceInfo();
            data.setAccount(as.getAccount());
            data.setOrgUnit(as.getOrgUnit());
            data.setProfitCenter(as.getProfitCenter());
            AssistantHGInfo hgInfo = new AssistantHGInfo();
            hgInfo.setId(BOSUuid.read((String)((String)as.get(assgrpid))));
            data.setAssistGrp(hgInfo);
            list.add(data);
            deleteBuffer.append(" (balance.faccountid= '").append(as.getAccount().getId().toString()).append("' ");
            deleteBuffer.append(" and balance.fassistgrpid='").append(as.get(assgrpid)).append("') ");
            deleteBuffer.append(or);
            isExecute = true;
        }
        if (!isExecute) {
            return;
        }
        String executeSql = deleteBuffer.toString();
        executeSql = executeSql.substring(0, executeSql.length() - 2) + ")";
        String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String glcid = ((InitPcAssistBalanceInfo)datas.getObject(0)).getCurrency().getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (InitPcAssistBalanceInfo data : list) {
            datas.addObject((IObjectValue)data);
        }
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(executeSql);
            int index = 1;
            stmt.setString(index++, profitCenterId);
            stmt.setString(index++, companyId);
            stmt.setString(index++, glcid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
    }

    private boolean existInitPcAssistBalanceInfo(Context ctx, InitPcAssistBalanceInfo as, HashMap otherCtx) throws BOSException, EASBizException {
        boolean bl;
        String existSql = "select top 1 * from t_pca_initpcassistbalance balance where balance.fprofitcenterid=? and balance.forgunitid=? and balance.faccountid=?  and balance.fassistgrpid=? and balance.fcurrencyid=? ";
        String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String glcid = as.getCurrency().getId().toString();
        String accountId = as.getAccount().getId().toString();
        String hgId = as.getAssistGrp().getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(existSql);
            int index = 1;
            stmt.setString(index++, profitCenterId);
            stmt.setString(index++, companyId);
            stmt.setString(index++, accountId);
            stmt.setString(index++, hgId);
            stmt.setString(index++, glcid);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return bl;
    }

    private void saveGeneral(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        String profitCenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String grcid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        String sumSql = new StringBuffer("select ").append("sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal,sum(balance.fyearcreditLocal) fyearcreditLocal").append(",sum(balance.fdebitlocal) fdebitlocal,sum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal").append(",sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt,sum(balance.fyearcreditrpt) fyearcreditrpt").append(",sum(balance.fdebitrpt) fdebitrpt,sum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt").append(",sum(balance.fbeginqty) fbeginqty,sum(balance.fyeardebitqty) fyeardebitqty,sum(balance.fyearcreditqty) fyearcreditqty").append(",sum(balance.fdebitqty) fdebitqty,sum(balance.fcreditqty) fcreditqty,sum(balance.fendqty) fendqty").append(",sum(balance.fStandardbeginqty) fStandardbeginqty,sum(balance.fStandardyeardebitqty) fStandardyeardebitqty,sum(balance.fStandardyearcreditqty) fStandardyearcreditqty").append(",sum(balance.fStandarddebitqty) fStandarddebitqty,sum(balance.fStandardcreditqty) fStandardcreditqty,sum(balance.fStandardendqty) fStandardendqty").append(",sum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fyearpnlrpt) fyearpnlrpt").append(" from t_pca_initpcassistbalance balance where balance.fprofitcenterid=? and balance.forgunitid=?  and balance.faccountid=? and balance.fassistgrpid=? ").append(" and balance.fcurrencyid<>? and balance.fcurrencyid<>?").toString();
        String existSql = "select top 1 * from t_pca_initpcassistbalance balance where balance.fprofitcenterid=? and balance.forgunitid=? and balance.faccountid=?  and balance.fassistgrpid=? and balance.fcurrencyid=? ";
        String newSql = new StringBuffer("insert into t_pca_initpcassistBalance(fprofitcenterid,faccountid,fassistgrpid,fcurrencyid,forgunitid,fmeasureUnitid,").append("fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fendbalancefor,fendbalancelocal,fendbalancerpt,").append("fyeardebitfor,fyeardebitlocal,fyeardebitrpt,fyearcreditfor,fyearcreditlocal,fyearcreditrpt,").append("fbeginqty,fendqty,fyeardebitqty,fyearcreditqty,").append("fStandardbeginqty,fStandardendqty,fStandardyeardebitqty,fStandardyearcreditqty,").append("fyearpnlfor,fyearpnllocal,fyearpnlrpt) ").append("values(?,?,?,?,?,?,").append("?,?,?,?,?,?,?,?,?,?,?,?,").append("?,?,?,?,").append("?,?,?,?,").append("?,?,?)").toString();
        String updateSql = new StringBuffer("update t_pca_initpcassistBalance ").append("set fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,").append("fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,").append("fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,").append("fStandardbeginqty=?,fStandardendqty=?,fStandardyeardebitqty=?,fStandardyearcreditqty=?,").append("fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?").append(" where fprofitcenterid=? and forgunitid=? and faccountid=? and fassistgrpid=? and fcurrencyid=? ").toString();
        String deleteSql = "delete from t_pca_initpcassistBalance where fprofitcenterid=? and forgunitid=? and faccountid=? and fassistgrpid=? and (fcurrencyid=? or fcurrencyid=?)";
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement update_stmt = null;
        PreparedStatement new_stmt = null;
        Statement clear_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(updateSql);
            new_stmt = con.prepareStatement(newSql);
            for (int i = 0; i < datas.size(); ++i) {
                InitPcAssistBalanceInfo as = (InitPcAssistBalanceInfo)datas.getObject(i);
                String accountId = as.getAccount().getId().toString();
                String hgId = as.getAssistGrp().getId().toString();
                String measureUnitid = null;
                if (as.getMesureUnit() != null) {
                    measureUnitid = as.getMesureUnit().getId().toString();
                }
                stmt = con.prepareStatement(sumSql);
                int index = 1;
                stmt.setString(index++, profitCenterId);
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, glcid);
                stmt.setString(index++, grcid);
                rs = stmt.executeQuery();
                if (!rs.next()) continue;
                InitPcAssistBalanceInfo data = new InitPcAssistBalanceInfo();
                data.put("account", accountId);
                data.put("assistGrp", hgId);
                data.put("measureUnitid", measureUnitid);
                data.setBeginBalanceLocal(rs.getBigDecimal("fbeginbalancelocal"));
                data.setBeginBalanceRpt(rs.getBigDecimal("fbeginbalancerpt"));
                data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                data.setStabdardBeginQty(rs.getBigDecimal("fStandardbeginqty"));
                data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                data.setEndBalanceRpt(rs.getBigDecimal("fendbalancerpt"));
                data.setEndQty(rs.getBigDecimal("fendqty"));
                data.setStabdardEndQty(rs.getBigDecimal("fStandardendqty"));
                data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                data.setStabdardYearCreditQty(rs.getBigDecimal("fStandardyearcreditqty"));
                data.setYearCreditRpt(rs.getBigDecimal("fyearcreditrpt"));
                data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                data.setStabdardYearDebitQty(rs.getBigDecimal("fStandardyeardebitqty"));
                data.setYearDebitRpt(rs.getBigDecimal("fyeardebitrpt"));
                data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                data.setYearPnLRpt(rs.getBigDecimal("fyearpnlrpt"));
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (data.getBeginBalanceLocal() == null) {
                    stmt = con.prepareStatement(deleteSql);
                    index = 1;
                    stmt.setString(index++, profitCenterId);
                    stmt.setString(index++, companyId);
                    stmt.setString(index++, accountId);
                    stmt.setString(index++, hgId);
                    stmt.setString(index++, glcid);
                    stmt.setString(index++, grcid);
                    stmt.executeUpdate();
                    SQLUtils.cleanup((Statement)stmt);
                    continue;
                }
                stmt = con.prepareStatement(existSql);
                index = 1;
                stmt.setString(index++, profitCenterId);
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, glcid);
                rs = stmt.executeQuery();
                boolean flag = rs.next();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    index = 1;
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getBeginQty());
                    update_stmt.setBigDecimal(index++, data.getEndQty());
                    update_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setString(index++, profitCenterId);
                    update_stmt.setString(index++, companyId);
                    update_stmt.setString(index++, accountId);
                    update_stmt.setString(index++, hgId);
                    update_stmt.setString(index++, glcid);
                    update_stmt.executeUpdate();
                } else {
                    index = 1;
                    new_stmt.setString(index++, profitCenterId);
                    new_stmt.setString(index++, accountId);
                    new_stmt.setString(index++, hgId);
                    new_stmt.setString(index++, glcid);
                    new_stmt.setString(index++, companyId);
                    new_stmt.setString(index++, measureUnitid);
                    new_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    new_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    new_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    new_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    new_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getBeginQty());
                    new_stmt.setBigDecimal(index++, data.getEndQty());
                    new_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    new_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    new_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    new_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.executeUpdate();
                }
                if (!isUseReport) continue;
                stmt = con.prepareStatement(existSql);
                index = 1;
                stmt.setString(index++, profitCenterId);
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, grcid);
                rs = stmt.executeQuery();
                flag = rs.next();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    index = 1;
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                    update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                    update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                    update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                    update_stmt.setBigDecimal(index++, data.getBeginQty());
                    update_stmt.setBigDecimal(index++, data.getEndQty());
                    update_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                    update_stmt.setString(index++, profitCenterId);
                    update_stmt.setString(index++, companyId);
                    update_stmt.setString(index++, accountId);
                    update_stmt.setString(index++, hgId);
                    update_stmt.setString(index++, grcid);
                    update_stmt.executeUpdate();
                    continue;
                }
                index = 1;
                new_stmt.setString(index++, profitCenterId);
                new_stmt.setString(index++, accountId);
                new_stmt.setString(index++, hgId);
                new_stmt.setString(index++, grcid);
                new_stmt.setString(index++, companyId);
                new_stmt.setString(index++, measureUnitid);
                new_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                new_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                new_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                new_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                new_stmt.setBigDecimal(index++, data.getBeginQty());
                new_stmt.setBigDecimal(index++, data.getEndQty());
                new_stmt.setBigDecimal(index++, data.getYearDebitQty());
                new_stmt.setBigDecimal(index++, data.getYearCreditQty());
                new_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                new_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                new_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                new_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                new_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                new_stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(clear_stmt);
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup((Statement)update_stmt);
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(clear_stmt);
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)update_stmt);
        SQLUtils.cleanup(rs, stmt, (Connection)con);
    }

    private void myDelete(Context ctx, InitPcAssistBalanceInfo as, String curAsstAccountid) throws BOSException {
        AssistantHGInfo hg = as.getAssistGrp();
        String deleteBalance = null;
        String hgId = null;
        String profitCenterId = as.getProfitCenter().get(as.getProfitCenter().getPKField()).toString();
        String companyId = as.getOrgUnit().getId().toString();
        String currencyid = as.getCurrency().getId().toString();
        String accountid = null;
        deleteBalance = "delete from t_pca_initpcassistbalance where fprofitcenterid=? and forgunitid = ? and faccountid=? and fcurrencyid=? and fassistgrpid=?";
        hgId = hg.getId().toString();
        accountid = as.getAccount().getId().toString();
        Connection con = null;
        PreparedStatement ps2 = null;
        try {
            con = this.getConnection(ctx);
            ps2 = con.prepareStatement(deleteBalance);
            int i = 1;
            ps2.setString(i++, profitCenterId);
            ps2.setString(i++, companyId);
            ps2.setString(i++, accountid);
            ps2.setString(i++, currencyid);
            ps2.setString(i++, hgId);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps2, (Connection)con);
    }

    private void myUpdate(Context ctx, InitPcAssistBalanceInfo as) throws BOSException {
        AssistantHGInfo hg = as.getAssistGrp();
        String hgId = hg.getId().toString();
        String profitCenterId = as.getProfitCenter().get(as.getProfitCenter().getPKField()).toString();
        String companyId = as.getOrgUnit().getId().toString();
        String accountid = as.getAccount().getId().toString();
        String currencyid = as.getCurrency().getId().toString();
        String updateSql = "update t_pca_initpcassistBalance set fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?,fmeasureunitid=?,fstandardyeardebitqty=?,fstandardyearcreditqty=?,fstandardbeginqty=? ,fstandardendqty=? where fprofitcenterid=? and forgunitid = ? and faccountid=? and fassistgrpid=? and fcurrencyid=?";
        InitPcAssistBalanceInfo data = as;
        int index = 1;
        Connection con = null;
        PreparedStatement update_stmt = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(updateSql);
            update_stmt.setBigDecimal(index++, data.getBeginBalanceFor());
            update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
            update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
            update_stmt.setBigDecimal(index++, data.getEndBalanceFor());
            update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
            update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
            update_stmt.setBigDecimal(index++, data.getYearDebitFor());
            update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
            update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
            update_stmt.setBigDecimal(index++, data.getYearCreditFor());
            update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
            update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
            update_stmt.setBigDecimal(index++, data.getBeginQty());
            update_stmt.setBigDecimal(index++, data.getEndQty());
            update_stmt.setBigDecimal(index++, data.getYearDebitQty());
            update_stmt.setBigDecimal(index++, data.getYearCreditQty());
            update_stmt.setBigDecimal(index++, data.getYearPnLFor());
            update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
            update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
            update_stmt.setString(index++, data.getMesureUnit() == null ? null : data.getMesureUnit().getId().toString());
            update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty() == null ? data.getYearDebitQty() : data.getStabdardYearDebitQty());
            update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty() == null ? data.getYearCreditQty() : data.getStabdardYearCreditQty());
            update_stmt.setBigDecimal(index++, data.getStabdardBeginQty() == null ? data.getBeginQty() : data.getStabdardBeginQty());
            update_stmt.setBigDecimal(index++, data.getStabdardEndQty() == null ? data.getEndQty() : data.getStabdardEndQty());
            update_stmt.setString(index++, profitCenterId);
            update_stmt.setString(index++, companyId);
            update_stmt.setString(index++, accountid);
            update_stmt.setString(index++, hgId);
            update_stmt.setString(index++, currencyid);
            update_stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(update_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)update_stmt, (Connection)con);
    }

    @Override
    protected void _deleteInitData(Context ctx, String[] accountviews, String[] currencys, Map otherCtx) throws BOSException, EASBizException {
        StringBuffer sb;
        String profitCenterId = (String)otherCtx.get("PROFITCENTERID");
        String accountTableId = (String)otherCtx.get("ACCOUNTTABLEID");
        ProfitCenterOrgUnitInfo profitCenterInfo = PcaUtils.getProfitCenterById(ctx, profitCenterId);
        otherCtx.put("PROFITCENTER", profitCenterInfo);
        CompanyOrgUnitInfo relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenterId);
        String relatedCompanyId = relatedCompany.getId().toString();
        otherCtx.put("RELATEDCOMPANY", relatedCompany);
        otherCtx.put("RELATEDCOMPANYID", relatedCompanyId);
        String companyId = (String)otherCtx.get("COMPANYID");
        CompanyOrgUnitInfo company = PcaUtils.getCompanyById(ctx, companyId);
        otherCtx.put("COMPANY", company);
        boolean isSelectedAllAccount = (Boolean)otherCtx.get("isSelectedAllAccount");
        boolean isSelectedAllCurrency = (Boolean)otherCtx.get("isSelectedAllCurrency");
        boolean isUserRpt = (Boolean)otherCtx.get("ISUSEREPORT");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        InitPcAssistBalanceCollection col = null;
        if (!isSelectedAllCurrency) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(currencys));
            HashSet<String> accountSet = new HashSet<String>(Arrays.asList(accountviews));
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("mesureUnit.id"));
            sic.add(new SelectorItemInfo("assistGrp.id"));
            sic.add(new SelectorItemInfo("account.id"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)profitCenterId));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", set, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("account.id", accountSet, CompareType.INCLUDE));
            view.setFilter(filter);
            col = InitPcAssistBalanceFactory.getLocalInstance(ctx).getInitPcAssistBalanceCollection(view);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_pca_initpcassistbalance where fprofitcenterid = ? and forgunitid = ? ");
        String[] accounts = this._getAllInitClosed(ctx, (HashMap)otherCtx);
        if (accounts != null && accounts.length > 0) {
            sql.append(" and faccountid not in ( ");
            sb = new StringBuffer();
            for (int i = 0; i < accounts.length; ++i) {
                sb.append("'").append(accounts[i]).append("'");
                if (i >= accounts.length - 1) continue;
                sb.append(",");
            }
            sql.append(sb.toString()).append(" ) \r\n");
        }
        if (!isSelectedAllCurrency) {
            sql.append(" and fcurrencyid in ( ");
            sb = new StringBuffer();
            for (int i = 0; i < currencys.length; ++i) {
                sb.append("'").append(currencys[i]).append("'");
                if (i >= currencys.length - 1) continue;
                sb.append(",");
            }
            sql.append(sb.toString()).append(" ) \r\n");
        }
        if (!isSelectedAllAccount) {
            sql.append(" and  faccountid in (  ");
            sb = new StringBuffer();
            for (int i = 0; i < accountviews.length; ++i) {
                sb.append("'").append(accountviews[i]).append("'");
                if (i >= accountviews.length - 1) continue;
                sb.append(",");
            }
            sql.append(sb.toString()).append(" ) \r\n");
        } else {
            sql.append(" and exists \r\n");
            sql.append(" ( select  1 from t_bd_accountview av  where av.faccounttableid = ? and av.fcompanyid = ? and av.fid = t_pca_initpcassistbalance.faccountid)");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        int index = 1;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql.toString());
            ps.setString(index++, profitCenterId);
            ps.setString(index++, companyId);
            if (isSelectedAllAccount) {
                ps.setString(index++, accountTableId);
                ps.setString(index++, relatedCompanyId);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        DBUtils.cleanup((Statement)ps, (Connection)conn);
        if (!isSelectedAllCurrency && col != null && col.size() > 0) {
            this.saveGeneral(ctx, (IObjectCollection)col, (HashMap)otherCtx);
        }
    }
}

