/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.IPcaFlag;
import com.kingdee.eas.ma.pca.PcCashflowInitCollection;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.ma.pca.app.AbstractPcCashflowInitControllerBean;
import com.kingdee.eas.ma.pca.app.CashflowInitCheckAsstIsEqualService;
import com.kingdee.eas.ma.pca.app.CashflowInitListDataService;
import com.kingdee.eas.ma.pca.app.CashfowInitCheckService;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcCashflowInitControllerBean
extends AbstractPcCashflowInitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcCashflowInitControllerBean");
    CompanyOrgUnitInfo curCompany = null;
    private static final String RESCLASSNAME = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    private static final String RECFLOW = "com.kingdee.eas.fi.gl.CashflowInitResource";
    private int lineIndex = 1;
    final Integer INTESUB1 = new Integer(11000000);
    final Integer INTESUB2 = new Integer(12000000);
    final Integer INTEPURGE1 = new Integer(11000000);
    final Integer INTEPURGE2 = new Integer(12000000);
    final Integer PRIMARYWORK = new Integer(30000000);
    final Integer SECONDARYWORK = new Integer(30000001);
    final Integer PRIMARYCASH = new Integer(40000000);
    final Integer SECONDARYCASH = new Integer(40000001);
    static final BigDecimal ZERO = new BigDecimal("0");

    protected Map _findInitData(Context ctx, Map otherCtx) throws BOSException, EASBizException {
        CurrencyCollection curCol;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(false);
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getBaseCurrency().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
            filter.setMaskString("#0 or #1");
            curCol = curCtrl.getCurrencyCollection(view);
        }
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        map.put("initParam", InitHelp.getInitParam((Context)ctx, (CompanyOrgUnitInfo)company));
        map.put("periods", this.getPeriods(ctx, profitCenter, company));
        map.put("AssistAccount", this.getAllAssistAccountBySql(ctx));
        map.put("allCurrency", curCol);
        return map;
    }

    protected Map getAllAssistAccountBySql(Context ctx) throws BOSException {
        AsstAccountCollection result = new AsstAccountCollection();
        HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
        String loc = ctx.getLocale().getLanguage();
        try {
            String sql = "select \tasstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_" + loc + " as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId, \t\n asstActType.fname_" + loc + " as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName,\n asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient,asstActType.FUseLongNumber \n from t_bd_asstactgroupdetail a\t \n inner join t_bd_asstaccount asstAccount on a.fasstaccountid = asstAccount.fid\t\n inner join t_bd_asstacttype asstActType on a.fasstActTypeid = asstActType.fid\t\n left join t_bd_measureunit m on asstAccount.fmeasureunitid=m.fid \n";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set != null) {
                while (set.next()) {
                    String asstid = set.getString("asstAccountId");
                    AsstAccountInfo temp = null;
                    if (cache.containsKey(asstid)) {
                        temp = (AsstAccountInfo)cache.get(asstid);
                    } else {
                        temp = new AsstAccountInfo();
                        temp.setId(BOSUuid.read((String)asstid));
                        temp.setNumber(set.getString("asstAccountNumber"));
                        temp.setCount(set.getInt("asstcount"));
                        temp.setName(set.getString("asstAccountName"));
                        temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                        temp.setIsQty(set.getBoolean("fisqty"));
                        if (set.getString("fmeasureunitid") != null) {
                            MeasureUnitInfo unit = new MeasureUnitInfo();
                            unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                            unit.setName(set.getString("fmeasureunitname"));
                            unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                            temp.setMeasureUnit(unit);
                        }
                        if (set.getString("fmeasureunitgroupid") != null) {
                            MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                            unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                            temp.setMeasureUnitGroup(unitGroup);
                        }
                        result.add(temp);
                        cache.put(asstid, temp);
                    }
                    AsstActTypeInfo type = new AsstActTypeInfo();
                    type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                    type.setNumber(set.getString("asstActTypeNumber"));
                    type.setName(set.getString("asstActTypeName"));
                    type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                    type.setMappingFieldName(set.getString("fmappingFieldName"));
                    type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                    type.setRealtionDataObject(set.getString("frealtionDataObject"));
                    type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                    type.setIsForCompany(set.getBoolean("fisForCompany"));
                    type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                    type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                    String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                    if (fglAsstActTypeGrpid != null) {
                        GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                        info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                        type.setGlAsstActTypeGrp(info);
                    }
                    ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cache;
    }

    private PeriodInfo[] getPeriods(Context ctx, ProfitCenterOrgUnitInfo profitCenter, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return PcaInitHelp.getPeriods(ctx, company, profitCenter);
    }

    @Override
    protected void _saveCashflowInit(Context ctx, PcCashflowInitCollection cfInitCollection) throws BOSException, EASBizException {
        int size = cfInitCollection.size();
        if (size == 0) {
            return;
        }
        String currencyId = cfInitCollection.get(0).getCurrency().getId().toString();
        String profitCenterId = cfInitCollection.get(0).getProfitCenter().getId().toString();
        String sqlDel = "delete from t_pca_pccashflowinit where fcurrencyid=? and fprofitCenterId=?";
        DbUtil.execute((Context)ctx, (String)sqlDel, (Object[])new Object[]{currencyId, profitCenterId});
        for (int i = 0; i < size; ++i) {
            this.submit(ctx, (CoreBaseInfo)cfInitCollection.get(i));
        }
    }

    protected boolean _isClosedInitForCashflowInit(Context ctx, HashMap otherCtx) throws BOSException {
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        ProfitCenterOrgUnitInfo pc = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        return flag.getCashflowInitClosed(pc.getId().toString());
    }

    protected void _closeInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        this._checkInitCash(ctx, otherCtx);
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        flag.setCashflowInitClosed(true, orgUnitId);
    }

    protected void _checkInitCash(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        CashfowInitCheckService service = new CashfowInitCheckService(ctx, company, profitCenter);
        service.check();
    }

    protected void _cancelInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        flag.setCashflowInitClosed(false, orgUnitId);
    }

    protected boolean _isClosedInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException {
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        ProfitCenterOrgUnitInfo pc = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        return flag.getCashflowGrpAsstClosed(pc.getId().toString());
    }

    protected void _closeInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        this.checkAsstIsEqual(ctx, otherCtx);
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        flag.setCashflowGrpAsstClosed(true, orgUnitId);
    }

    protected void _cancelInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        flag.setCashflowGrpAsstClosed(false, orgUnitId);
    }

    private void checkAsstIsEqual(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER");
        CashflowInitCheckAsstIsEqualService service = new CashflowInitCheckAsstIsEqualService(ctx, company, profitCenter);
        service.check();
    }

    protected ArrayList _getEnabledGrpAsst(Context ctx) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" SELECT FAsstAccountID FROM T_BD_CashFlowItem WHERE fisenable=1 and FAsstAccountID is not null");
        ArrayList<String> items = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                items.add(rs.getString("FAsstAccountID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return items;
    }

    @Override
    protected List _getCashflowInitValue4Web(Context ctx, IObjectValue currencyInfo, IObjectValue company, IObjectValue profitCenter) throws BOSException, EASBizException {
        CashflowInitListDataService service = new CashflowInitListDataService(ctx, (CurrencyInfo)currencyInfo, (CompanyOrgUnitInfo)company, (ProfitCenterOrgUnitInfo)profitCenter);
        return service.getData();
    }
}

