/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CreateVoucherModeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.PLAccountRangeEnum;
import com.kingdee.eas.fi.gl.PL_VoucherDataEnum;
import com.kingdee.eas.fi.gl.ProduceInfo;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.TransPLException;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherTransPeriodEnum;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.IPcTransPLProgramVoucherRef;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.IPcaFlag;
import com.kingdee.eas.ma.pca.PcTransPLProgramAsstAccountCollection;
import com.kingdee.eas.ma.pca.PcTransPLProgramAsstAccountInfo;
import com.kingdee.eas.ma.pca.PcTransPLProgramEntryCollection;
import com.kingdee.eas.ma.pca.PcTransPLProgramEntryInfo;
import com.kingdee.eas.ma.pca.PcTransPLProgramInfo;
import com.kingdee.eas.ma.pca.PcTransPLProgramVoucherRefFactory;
import com.kingdee.eas.ma.pca.PcTransPLProgramVoucherRefInfo;
import com.kingdee.eas.ma.pca.PcTransPlProgramFilter;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.ma.pca.PcaParam;
import com.kingdee.eas.ma.pca.PcaPeriodEndException;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractPcTransPLProgramControllerBean;
import com.kingdee.eas.ma.pca.app.PcAccountCurrencyPair;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PcTransPLProgramControllerBean
extends AbstractPcTransPLProgramControllerBean {
    private static final long serialVersionUID = 8980593451594135636L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcTransPLProgramControllerBean");
    private boolean isState = false;
    public String curId2;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        return super._save(ctx, model);
    }

    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PcTransPLProgramInfo info = (PcTransPLProgramInfo)model;
        PcTransPLProgramEntryCollection plProgramEntryCollection = info.getEntries();
        CompanyOrgUnitInfo companyOrgUnitInfo = info.getCompany();
        ProfitCenterOrgUnitInfo profitCenterInfo = info.getProfitCenter();
        String profitCenterId = profitCenterInfo.getString("id");
        String loc = this._getLocaleString(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where number ='" + model.getString("number") + "' ");
        oql.append(" and profitCenter.id ='" + profitCenterId + "' ");
        if (!PcaUtils.isEmpty(model.getString("id"))) {
            oql.append(" and  id !='" + model.getString("id") + "' ");
        }
        if (this._exists(ctx, oql.toString())) {
            throw new TransPLException(TransPLException.DOUBLENUMBER);
        }
        Iterator items = plProgramEntryCollection.iterator();
        PcTransPLProgramEntryInfo entryInfo = null;
        ArrayList<String> idsList = new ArrayList<String>();
        while (items.hasNext()) {
            entryInfo = (PcTransPLProgramEntryInfo)items.next();
            idsList.add(entryInfo.getAccountView().getId().toString());
        }
        String ids = SQLUtil.stringListToString(idsList);
        IRowSet rowSet = null;
        Object param = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select av.Fnumber avNumber,av.Fname_" + loc + " avName,p.Fnumber pNumber \r\n");
        sql.append(" from T_PCA_PcTransPLProgram p \r\n");
        sql.append(" inner join T_PCA_PcTransPLProgramEntry pe on pe.FParentID = p.Fid \r\n");
        sql.append(" inner join t_bd_accountView av on av.Fid= pe.FAccountViewID and av.FcompanyID ='" + companyOrgUnitInfo.getString("id") + "'  \r\n");
        sql.append(" where p.FProfitCenterID ='" + profitCenterId + "'  \r\n");
        if (!PcaUtils.isEmpty(model.getString("id"))) {
            sql.append(" and  p.FID !='" + model.getString("id") + "'  \r\n");
        }
        sql.append(" and pe.FAccountViewID in (" + ids + ") \r\n");
        sql.append(" order by p.Fid,av.Fnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String avNumber = "";
        String avName = "";
        String pNumber = "";
        StringBuffer errorMsg = new StringBuffer();
        String baseMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"DoubleAccountView", (Locale)ctx.getLocale());
        try {
            int errCount = 0;
            while (rowSet.next()) {
                avNumber = rowSet.getString("avNumber");
                avName = rowSet.getString("avName");
                pNumber = rowSet.getString("pNumber");
                errorMsg.append(MessageFormat.format(baseMsg, "  " + avNumber + "  " + avName + "  ", "  " + pNumber + "  "));
                if (++errCount >= 3 || errCount >= rowSet.size()) {
                    errorMsg.append("!\r\n");
                    break;
                }
                errorMsg.append(",\r\n");
            }
            if (rowSet.size() > 3) {
                errorMsg.append("...");
            }
            if (errorMsg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("8800001", errorMsg.toString()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (CreateVoucherModeEnum.ASSTACCOUNT.equals((Object)info.getCreateVoucherMode())) {
            HashSet<String> aaID = new HashSet<String>();
            PcTransPLProgramAsstAccountCollection aa = info.getAsstAccounts();
            int j = aa.size();
            for (int i = 0; i < j; ++i) {
                aaID.add(aa.get(i).getAsstAccount().getId().toString());
            }
            PcTransPLProgramEntryCollection entryColl = info.getEntries();
            HashSet<String> caaCache = new HashSet<String>();
            int j2 = entryColl.size();
            for (int i = 0; i < j2; ++i) {
                AccountViewInfo accView = entryColl.get(i).getAccountView();
                if (accView.getCAA() != null) {
                    if (caaCache.contains(accView.getCAA().getId().toString())) continue;
                    FilterInfo filter = new FilterInfo();
                    StringBuffer sqlIn = new StringBuffer();
                    sqlIn.append("select fasstacttypeid from t_bd_asstactgroupdetail where fasstaccountid ='");
                    sqlIn.append(accView.getCAA().getId().toString());
                    sqlIn.append("'");
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sqlIn.toString(), CompareType.INNER));
                    IObjectPK[] pks = AsstActTypeFactory.getLocalInstance((Context)ctx).getPKList(filter, null);
                    HashSet<String> assSet = new HashSet<String>();
                    int n = pks.length;
                    for (int m = 0; m < n; ++m) {
                        assSet.add(pks[m].toString());
                    }
                    if (!assSet.containsAll(aaID)) {
                        throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{accView.getNumber()});
                    }
                    caaCache.add(accView.getCAA().getId().toString());
                    continue;
                }
                throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{accView.getNumber()});
            }
        }
    }

    protected String _getLocaleString(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected Map _fetchInitData(Context ctx, String profitCenterID) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        GLPeriodEndFilter initData = new GLPeriodEndFilter();
        String curCompanyID = PcaUtils.getRelatedCompanyIds(ctx, profitCenterID);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyID), PcaUtils.getCompanySic());
        initData.setCurCompany(company);
        String[] paramList = new String[]{"G001", "GL_008", "GL_002", "GL_003", "GL_028", "GLG01", "GLG01_1", "GL_052", "G010", "GL_068", "GL_072"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)curCompanyID);
        String[] pcaParamList = new String[]{"PCA_011", "PCA_010", "PCA_051", "PCA011"};
        PcaParam pcaParam = PcaParam.getPcaParams(ctx, pcaParamList, profitCenterID);
        HashMap paMap = (HashMap)glParam.getParamMap();
        paMap.putAll(pcaParam.getParamMap());
        initData.setHmGLParam(paMap);
        String prifodAcctID = (String)paMap.get("PCA_010");
        if (prifodAcctID != null && prifodAcctID.length() > 0 && !"none".equalsIgnoreCase(prifodAcctID)) {
            AccountViewInfo profitAcct = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(prifodAcctID));
            map.put("PCA_010", profitAcct);
        }
        initData.setParamCheckNumber(pcaParam.getInt("PCA_051"));
        initData.setParamCheckVoucherTemp(pcaParam.getBoolean("PCA011"));
        initData.setCanNotClosedAfterReport(glParam.getBoolean("GL_068"));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        FilterInfo filterVT = new FilterInfo();
        filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(company.getCU().getId().toString()), "id", "adminCU");
        view.setFilter(filterVT);
        map.put("initData", initData);
        map.put("filterVT", filterVT);
        return map;
    }

    @Override
    protected Vector _getTransPLAcct(Context ctx, String companyID) throws BOSException, EASBizException {
        boolean isUseRptCy = this.isUseReportCurrency(ctx);
        Vector<AccountViewInfo> vec = new Vector<AccountViewInfo>();
        CompanyOrgUnitInfo company = PcTransPLProgramControllerBean.getCurrentCompany(ctx, companyID);
        String curCompanyID = company.getId().toString();
        PeriodInfo period = PcaUtils.getCurrentPeriod(ctx, curCompanyID);
        String curPeriodID = period.getId().toString();
        BigDecimal minQtyByPrecision = PcaUtils.getMinQtyByPrecision(ctx, curCompanyID);
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 0;
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            if (isUseRptCy) {
                sql.append("select vacct.*                          \r\n");
                sql.append("from                                                                \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                     \r\n");
                sql.append("from " + PCABalanceUtils.getAccountBalanceTable(5) + " bal bal,                                       \r\n");
                sql.append("    t_BD_AccountType actype,                    \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FProfitCenterID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and actype.FID = acct.FAccountTypeID                            \r\n");
                sql.append("    and actype.FProperty in (4 ,8)                               \r\n");
                sql.append("    and acct.FIsLeaf = 1                                    \r\n");
                sql.append("    --and acct.FCAA is null                                 \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("        or bal.FEndBalanceRpt <> 0 or ").append(strQtyBalNotZero).append(" and acct.FCAA is null)     \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("union                                                               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                     \r\n");
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(5) + " bal,                         \r\n");
                sql.append("    t_BD_AccountType actype,                    \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FProfitCenterID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and actype.FID = acct.FAccountTypeID                            \r\n");
                sql.append("    and actype.FProperty in (4 ,8)                             \r\n");
                sql.append("    and acct.FIsLeaf = 1                                  \r\n");
                sql.append("    and acct.FCAA is not null                             \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("        or bal.FEndBalanceRpt <> 0 or ").append(strQtyBalNotZero).append(")     \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append(") vacct                                                             \r\n");
                sql.append("                                                                    \r\n");
                sql.append("order by vacct.FNumber                                              \r\n");
                sql.append(";");
            } else {
                sql.append("select vacct.*                                                      \r\n");
                sql.append("from                                                                \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                           \r\n");
                sql.append("from  " + PCABalanceUtils.getAccountBalanceTable(5) + " bal,                                       \r\n");
                sql.append("    t_BD_AccountType actype,                                        \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FProfitCenterID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and actype.FID = acct.FAccountTypeID                            \r\n");
                sql.append("    and actype.FProperty in (4 ,8)                             \r\n");
                sql.append("    and acct.FIsLeaf = 1                                  \r\n");
                sql.append("    and acct.FCAA is null                                 \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("         or ").append(strQtyBalNotZero).append(")               \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("union                                                               \r\n");
                sql.append("                                                                    \r\n");
                sql.append("select distinct bal.FAccountID,                                     \r\n");
                sql.append("    acct.FNumber, acct.FName");
                sql.append(loc);
                sql.append(" as FName                                                           \r\n");
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal,                                        \r\n");
                sql.append("    t_BD_AccountType actype,                                        \r\n");
                sql.append("    t_bd_accountview acct                                           \r\n");
                sql.append("where                                                               \r\n");
                sql.append("    bal.FProfitCenterID = ? and bal.FPeriod = ?                        \r\n");
                sql.append("    and acct.FID = bal.FAccountID                                   \r\n");
                sql.append("    and actype.FID = acct.FAccountTypeID                            \r\n");
                sql.append("    and actype.FProperty in (4 ,8)                                       \r\n");
                sql.append("    and acct.FIsLeaf = 1                                            \r\n");
                sql.append("    and acct.FCAA is not null                                       \r\n");
                sql.append("    and (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0       \r\n");
                sql.append("         or ").append(strQtyBalNotZero).append(")               \r\n");
                sql.append("    and acct.fbw=0               \r\n");
                sql.append(") vacct                                                             \r\n");
                sql.append("                                                                    \r\n");
                sql.append("order by vacct.FNumber                                              \r\n");
                sql.append(";");
            }
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, period.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            stmt.setInt(index++, period.getNumber());
            rs = stmt.executeQuery();
            while (rs.next()) {
                AccountViewInfo acct = new AccountViewInfo();
                acct.setId(BOSUuid.read((String)rs.getString("FAccountID")));
                acct.setNumber(rs.getString("FNumber"));
                acct.setName(rs.getString("FName"));
                vec.add(acct);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return vec;
    }

    private boolean isUseReportCurrency(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("G001").toString());
        return bParam;
    }

    private static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        SelectorItemCollection sic = PcaUtils.getCompanySic();
        return PcaUtils.getCurrentCompany(ctx, curCompanyID, sic, true);
    }

    @Override
    protected PcTransPlProgramFilter _generalVoucherCollection(Context ctx, List idList) throws BOSException {
        PcTransPlProgramFilter result = new PcTransPlProgramFilter();
        PcTransPlProgramFilter rtnFilter = new PcTransPlProgramFilter();
        ArrayList<ProduceInfo> produceList = new ArrayList<ProduceInfo>();
        try {
            int length = idList.size();
            for (int i = 0; i < length; ++i) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("yearProfitAcct.id"));
                sic.add(new SelectorItemInfo("yearProfitAcct.number"));
                sic.add(new SelectorItemInfo("yearProfitAcct.name"));
                sic.add(new SelectorItemInfo("yearProfitAcct.CAA.id"));
                sic.add(new SelectorItemInfo("voucherDate"));
                sic.add(new SelectorItemInfo("vDescription"));
                sic.add(new SelectorItemInfo("PLAccountRange"));
                sic.add(new SelectorItemInfo("voucherType.id"));
                sic.add(new SelectorItemInfo("voucherType.name"));
                sic.add(new SelectorItemInfo("byBalanceReverse"));
                sic.add(new SelectorItemInfo("yearProfitByOriginal"));
                sic.add(new SelectorItemInfo("byPL"));
                sic.add(new SelectorItemInfo("voucherTransPeriod"));
                sic.add(new SelectorItemInfo("entries.accountView.id"));
                sic.add(new SelectorItemInfo("entries.accountView.number"));
                sic.add(new SelectorItemInfo("entries.accountView.name"));
                sic.add(new SelectorItemInfo("entries.accountView.CAA.id"));
                sic.add(new SelectorItemInfo("createVoucherMode"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.id"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.assistantType"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.realtionDataObject"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.defaultQueryName"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.asstHGAttribute"));
                sic.add(new SelectorItemInfo("asstAccounts.asstAccount.mappingFieldName"));
                sic.add(new SelectorItemInfo("asstAccounts.acctTypeNumberFromTo"));
                sic.add(new SelectorItemInfo("asstAccounts.actTypeNumberTo"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)idList.get(i))));
                PcTransPLProgramInfo transPlProgramInfo = (PcTransPLProgramInfo)this._getValue(ctx, (IObjectPK)pk, sic);
                ProduceInfo produceInfo = new ProduceInfo();
                String voucherNumber = null;
                String voucherWebNumber = null;
                String voucherId = null;
                PcTransPlProgramFilter filter = this.initFilterData(ctx, transPlProgramInfo);
                ProfitCenterOrgUnitInfo profitCenter = filter.getProfitCenter();
                CompanyOrgUnitInfo relatedCompany = filter.getCompanyOrgUnit();
                produceInfo.setId((String)idList.get(i));
                produceInfo.setCompany(profitCenter.getId().toString());
                produceInfo.setAutoTransName(transPlProgramInfo.getName());
                produceInfo.setAutoTransNumber(transPlProgramInfo.getNumber());
                String cuid = profitCenter.getCU().getId().toString();
                PeriodInfo transCompanyPeriod = filter.getTransCompanyPeriod();
                produceInfo.setPeriodId(transCompanyPeriod.getId().toString());
                produceInfo.setPeriodNumber(transCompanyPeriod.getNumber());
                ArrayList<String> periodIDList = new ArrayList<String>();
                String adjustPeriodID = null;
                if (!transCompanyPeriod.isIsAdjustPeriod() && filter.isAdjustTrans()) {
                    String sql = "select p.fid from t_bd_period p , t_org_company com where com.fid = ? and p.FTypeID = com.FAccountPeriodID and p.fnumber=? and FIsAdjustPeriod=1 order by p.fnumber";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{relatedCompany.getId().toString(), new Integer(transCompanyPeriod.getPeriodYear() - 1 + "13")});
                    try {
                        if (rs.next()) {
                            adjustPeriodID = rs.getString("FID");
                            periodIDList.add(adjustPeriodID);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"338_TransPLProgramControllerBean", (Locale)ctx.getLocale()));
                    }
                }
                periodIDList.add(transCompanyPeriod.getId().toString());
                String[] profitCenterIdArray = new String[]{profitCenter.getId().toString()};
                IPcVoucher ivoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
                IPcTransPLProgramVoucherRef iTransPLProgramVoucherRef = PcTransPLProgramVoucherRefFactory.getLocalInstance(ctx);
                IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
                ArrayList<PcVoucherInfo> voucherList = new ArrayList<PcVoucherInfo>();
                boolean isAdjustPeriodError = false;
                int size = periodIDList.size();
                for (int j = 0; j < size; ++j) {
                    if (isAdjustPeriodError) continue;
                    PeriodInfo period = (PeriodInfo)iperiod.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)periodIDList.get(j)))));
                    filter.setTransCompanyPeriod(period);
                    PcaUtils.updateBalance(ctx, profitCenterIdArray);
                    try {
                        this.checkCanTransPL(ctx, cuid, profitCenter.getId().toString(), relatedCompany.getId().toString(), (String)periodIDList.get(j));
                        if (filter.isTransMethodByAsst()) {
                            rtnFilter = this.genVchTrans(ctx, this.checkTrans(ctx, filter.getHmPLAccount(), filter));
                        } else {
                            rtnFilter = this.genVchTrans(ctx, filter);
                            if (rtnFilter.getReturnVchCount() != 0) {
                                if (rtnFilter.getReturnVch1() != null) {
                                    this.resetEntryMeasureUnit(ctx, (PcVoucherInfo)rtnFilter.getReturnVch1(), filter);
                                }
                                if (rtnFilter.getReturnVch2() != null) {
                                    this.resetEntryMeasureUnit(ctx, (PcVoucherInfo)rtnFilter.getReturnVch2(), filter);
                                }
                            }
                        }
                        produceInfo.setSuccess(true);
                    }
                    catch (Exception e) {
                        if (period.isIsAdjustPeriod()) {
                            isAdjustPeriodError = true;
                        }
                        produceInfo.setSuccess(false);
                        if (filter.isAdjustTrans() && !isAdjustPeriodError && !period.isIsAdjustPeriod() && !filter.isAdjustNoBalance()) {
                            String errorMsg = this.getStr(ctx, "adjustPeriod_Success");
                            errorMsg = errorMsg + MessageFormat.format(this.getStr(ctx, "currentPeriod_error"), String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber()));
                            produceInfo.setErrInfo(errorMsg + e.getMessage());
                        } else {
                            produceInfo.setErrInfo(e.getMessage());
                        }
                        if (e instanceof PcaPeriodEndException && "89-042".equals(((PcaPeriodEndException)((Object)e)).getCode())) {
                            produceInfo.setDealFunction("showVoucher");
                        }
                        logger.error((Object)e);
                        continue;
                    }
                    if (rtnFilter.getReturnVch1() != null) {
                        PcVoucherInfo voucher1 = (PcVoucherInfo)rtnFilter.getReturnVch1();
                        IObjectPK pk1 = ivoucher.save((CoreBaseInfo)voucher1);
                        voucher1.setId(BOSUuid.read((String)pk1.toString()));
                        PcTransPLProgramVoucherRefInfo transVchRef1 = new PcTransPLProgramVoucherRefInfo();
                        transVchRef1.setTransplprogram(transPlProgramInfo);
                        transVchRef1.setVoucher(voucher1);
                        transVchRef1.setCompany(profitCenter);
                        transVchRef1.setPeriod(filter.getTransCompanyPeriod());
                        iTransPLProgramVoucherRef.save(transVchRef1);
                        voucherList.add(voucher1);
                        voucherNumber = voucherNumber != null ? voucherNumber + ";" + voucher1.getVoucherType().getName() + "-" + voucher1.getNumber() : voucher1.getVoucherType().getName() + "-" + voucher1.getNumber();
                        voucherWebNumber = voucherWebNumber != null ? voucherWebNumber + ";[" + voucher1.getVoucherType().getName() + "]" + voucher1.getNumber() + "  " : "[" + voucher1.getVoucherType().getName() + "]" + voucher1.getNumber() + "  ";
                        voucherId = voucherId != null ? voucherId + voucher1.getId().toString() + ";" : voucher1.getId().toString();
                    }
                    if (rtnFilter.getReturnVch2() == null) continue;
                    PcVoucherInfo voucher2 = (PcVoucherInfo)rtnFilter.getReturnVch2();
                    IObjectPK pk2 = ivoucher.save((CoreBaseInfo)voucher2);
                    voucher2.setId(BOSUuid.read((String)pk2.toString()));
                    PcTransPLProgramVoucherRefInfo transVchRef2 = new PcTransPLProgramVoucherRefInfo();
                    transVchRef2.setTransplprogram(transPlProgramInfo);
                    transVchRef2.setVoucher(voucher2);
                    transVchRef2.setCompany(profitCenter);
                    transVchRef2.setPeriod(filter.getTransCompanyPeriod());
                    iTransPLProgramVoucherRef.save(transVchRef2);
                    voucherList.add(voucher2);
                    voucherNumber = voucherNumber != null ? voucherNumber + ";" + voucher2.getVoucherType().getName() + "-" + voucher2.getNumber() : voucher2.getVoucherType().getName() + "-" + voucher2.getNumber();
                    voucherWebNumber = voucherWebNumber != null ? voucherWebNumber + ";[" + voucher2.getVoucherType().getName() + "]" + voucher2.getNumber() + "  " : "[" + voucher2.getVoucherType().getName() + "]" + voucher2.getNumber() + "  ";
                    voucherId = voucherId != null ? voucherId + voucher2.getId().toString() + ";" : voucher2.getId().toString();
                }
                filter.setVoucherList(voucherList);
                filter.setReturnVchCount(voucherList.size());
                produceInfo.setVoucherNumber(voucherNumber);
                produceInfo.setVoucherWebNumber(voucherWebNumber);
                produceInfo.setVoucherId(voucherId);
                if (transCompanyPeriod.isIsAdjustPeriod() && filter.isAdjustNoBalance()) {
                    produceInfo.setSuccess(false);
                    produceInfo.setErrInfo(new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL).getMessage());
                }
                produceList.add(produceInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"339_TransPLProgramControllerBean", (Locale)ctx.getLocale()));
            throw new BOSException((Throwable)e);
        }
        result.setProduceList(produceList);
        return result;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this.getTransPlProgramInternal(ctx, pk, selector);
    }

    private PcTransPLProgramInfo getTransPlProgramInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws EASBizException, BOSException {
        return this.getTransPLProgramInternal(ctx, pk, selector);
    }

    private PcTransPLProgramInfo getTransPLProgramInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("profitCenter.id"));
        sic.add(new SelectorItemInfo("asstAccounts.asstAccount.glAsstActTypeGrp.*"));
        sic.add(new SelectorItemInfo("asstAccounts.asstAccount.*"));
        sic.add(new SelectorItemInfo("asstAccounts.*"));
        sic.addObjectCollection((IObjectCollection)selector);
        PcTransPLProgramInfo transPLProgramInfo = null;
        try {
            transPLProgramInfo = (PcTransPLProgramInfo)super._getValue(ctx, pk, sic);
            for (int i = 0; i < transPLProgramInfo.getAsstAccounts().size(); ++i) {
                String to;
                PcTransPLProgramAsstAccountInfo entryInfo = transPLProgramInfo.getAsstAccounts().get(i);
                AsstActTypeInfo actTypeInfo = entryInfo.getAsstAccount();
                String from = entryInfo.getAcctTypeNumberFromTo();
                if (!com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)from)) {
                    entryInfo.put("fromObject", this.getAsstActObject(ctx, actTypeInfo, from));
                }
                if (com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)(to = entryInfo.getActTypeNumberTo()))) continue;
                entryInfo.put("toObject", this.getAsstActObject(ctx, actTypeInfo, to));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return transPLProgramInfo;
    }

    private Object getAsstActObject(Context ctx, AsstActTypeInfo actTypeInfo, String number) throws BOSException, SQLException {
        Object[] objectArray;
        if (com.kingdee.eas.basedata.master.util.StringUtil.isEmpty((String)number)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        boolean isNeedLongnumber = actTypeInfo == null ? false : actTypeInfo.isUseLongNumber();
        sql.append(" select fid,fnumber,fname_").append(ctx.getLocale()).append(" fname ");
        sql.append(" from ").append(actTypeInfo.getRealtionDataObject());
        if (isNeedLongnumber) {
            sql.append(" where flongNumber = ? ");
        } else {
            sql.append(" where fnumber = ? ");
        }
        if (actTypeInfo.getGlAsstActTypeGrp() != null) {
            sql.append(" and fgroupid = ? ");
        }
        if (isNeedLongnumber) {
            number = number.replace('.', '!');
        }
        String string = sql.toString();
        if (actTypeInfo.getGlAsstActTypeGrp() != null) {
            String[] stringArray = new String[2];
            stringArray[0] = number;
            objectArray = stringArray;
            stringArray[1] = actTypeInfo.getGlAsstActTypeGrp().getId().toString();
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = number;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)string, (Object[])objectArray);
        if (rs.next()) {
            String fid = rs.getString("fid");
            BOSUuid id = BOSUuid.read((String)fid);
            CurrencyInfo info = new CurrencyInfo();
            info.setId(id);
            info.setName(rs.getString("fname"));
            info.setNumber(rs.getString("fnumber"));
            if (isNeedLongnumber) {
                info.put("longNumber", (Object)number);
                info.put("displayLongNumber", (Object)number.replace('!', '.'));
            }
            return info;
        }
        return null;
    }

    private PcTransPlProgramFilter initFilterData(Context ctx, PcTransPLProgramInfo transPlProgramInfo) throws EASBizException, BOSException, UuidException {
        try {
            PcTransPlProgramFilter filter = new PcTransPlProgramFilter();
            filter.setAllAccount(PLAccountRangeEnum.ALLPLACCOUNT.equals((Object)transPlProgramInfo.getPLAccountRange()));
            String companyId = transPlProgramInfo.getCompany().getId().toString();
            String profitCenterId = transPlProgramInfo.getProfitCenter().getId().toString();
            SelectorItemCollection companySic = new SelectorItemCollection();
            companySic.addObjectCollection((IObjectCollection)PcaUtils.getCompanySic());
            SelectorItemCollection profitCenterSic = new SelectorItemCollection();
            profitCenterSic.addObjectCollection((IObjectCollection)PcaUtils.getProfitCenterSic());
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), companySic);
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)profitCenterId)), profitCenterSic);
            filter.setCompanyOrgUnit(companyOrgUnit);
            filter.setProfitCenter(profitCenter);
            PeriodInfo transCompanyPeriod = PcaUtils.getCurrentPeriod(ctx, profitCenterId);
            filter.setTransCompanyPeriod(transCompanyPeriod);
            filter.setCurUser((UserInfo)ctx.get((Object)"UserInfo"));
            String[] paramList = new String[]{"G001", "GL_008", "GL_002", "GL_003", "GL_028", "GLG01", "GLG01_1", "GL_052", "G010", "GL_068", "GL_072"};
            GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyId);
            String[] pcaParamList = new String[]{"PCA_011", "PCA_010", "PCA_051", "PCA011"};
            PcaParam pcaParam = PcaParam.getPcaParams(ctx, pcaParamList, profitCenterId);
            for (Map.Entry e : pcaParam.getParamMap().entrySet()) {
                if (e.getValue() == null) continue;
                glParam.setParam((String)e.getKey(), e.getValue());
            }
            filter.setHmGLParam((HashMap)glParam.getParamMap());
            boolean foreignCurrencySU = glParam.getBoolean("GL_008");
            if (!foreignCurrencySU) {
                if (companyOrgUnit.getBaseCurrency() == null) {
                    throw new GLException(GLException.NOLOCALCUR);
                }
                filter.setLocalCurrency(companyOrgUnit.getBaseCurrency());
            }
            filter.setParamForeignCurrencySU(foreignCurrencySU);
            boolean useReportingCurrency = glParam.getBoolean("G001");
            if (useReportingCurrency) {
                if (companyOrgUnit.getReportCurrency() == null) {
                    throw new GLException(GLException.NOREPORTINGCUR);
                }
                filter.setReportCurrency(companyOrgUnit.getReportCurrency());
            }
            filter.setParamUseReportCurrency(useReportingCurrency);
            BigDecimal minQtyByPrecision = PcaUtils.getMinQtyByPrecision(ctx, companyOrgUnit.getId().toString());
            filter.setMinQtyByPrecision(minQtyByPrecision);
            filter.setParamUseReportAdjust(glParam.getBoolean("GL_072"));
            filter.setParamInitClosed(PcaFlagFactory.getLocalInstance(ctx).getPcaInitClosed(companyId));
            filter.setQtyByAsst(glParam.getBoolean("G010"));
            VoucherTypeInfo transVoucherType = transPlProgramInfo.getVoucherType();
            filter.setFilterVchType(transVoucherType);
            filter.setTransVoucherType(transVoucherType);
            filter.setFilterTransPLByBalOppDC(transPlProgramInfo.isByBalanceReverse());
            boolean transProfitLossSep = transPlProgramInfo.isByPL();
            if (transProfitLossSep) {
                filter.setFilterCountVch(2);
                filter.setFilterVchProfitLoss(3);
                filter.setFilterVchPLType(1);
            } else {
                filter.setFilterCountVch(1);
                filter.setFilterVchPLType(2);
                filter.setFilterVchProfitLoss(0);
            }
            PL_VoucherDataEnum pl_VoucherDataEnum = transPlProgramInfo.getVoucherDate();
            filter.setVoucherDateType(pl_VoucherDataEnum.getValue());
            filter.setFilterVchDesc(transPlProgramInfo.getVDescription());
            filter.setParamCheckCurrency(!transPlProgramInfo.isYearProfitByOriginal());
            VoucherTransPeriodEnum voucherTransPeriodEnum = transPlProgramInfo.getVoucherTransPeriod();
            int voucherTransPeriod = voucherTransPeriodEnum.getValue();
            if (voucherTransPeriod == 1) {
                filter.setAdjustTrans(true);
            } else {
                filter.setAdjustTrans(false);
            }
            HashMap<String, AccountViewInfo> hmGainAccount = new HashMap<String, AccountViewInfo>();
            HashMap hmUnSelectedAccount = new HashMap();
            PcTransPLProgramEntryCollection transPLProgramEntryCollection = transPlProgramInfo.getEntries();
            AccountViewInfo gainAccount = transPlProgramInfo.getYearProfitAcct();
            for (int i = 0; i < transPLProgramEntryCollection.size(); ++i) {
                PcTransPLProgramEntryInfo transPLProgramEntryInfo = transPLProgramEntryCollection.get(i);
                String acctID = transPLProgramEntryInfo.getAccountView().getId().toString();
                hmGainAccount.put(acctID, gainAccount);
            }
            filter.setHmPLAccount(hmGainAccount);
            filter.setHmUnSelectedAccount(hmUnSelectedAccount);
            CreateVoucherModeEnum createVoucherModeEnum = transPlProgramInfo.getCreateVoucherMode();
            if (createVoucherModeEnum.getValue() == 1) {
                filter.setTransMethodByAsst(true);
                PcTransPLProgramAsstAccountCollection transPLProgramAsstAccountCollection = transPlProgramInfo.getAsstAccounts();
                HashMap<String, String> baseNumberFrom = new HashMap<String, String>();
                HashMap<String, String> baseNumberTo = new HashMap<String, String>();
                ArrayList<AsstActTypeInfo> asstActInfoList = new ArrayList<AsstActTypeInfo>();
                int length = transPLProgramAsstAccountCollection.size();
                for (int i = 0; i < length; ++i) {
                    PcTransPLProgramAsstAccountInfo transPLProgramAsstAccountInfo = transPLProgramAsstAccountCollection.get(i);
                    AsstActTypeInfo asstActInfo = transPLProgramAsstAccountInfo.getAsstAccount();
                    asstActInfoList.add(asstActInfo);
                    if (!StringUtil.isEmptyString((String)transPLProgramAsstAccountInfo.getAcctTypeNumberFromTo())) {
                        baseNumberFrom.put(asstActInfo.getAsstHGAttribute(), transPLProgramAsstAccountInfo.getAcctTypeNumberFromTo());
                    }
                    if (!StringUtil.isEmptyString((String)transPLProgramAsstAccountInfo.getActTypeNumberTo())) {
                        baseNumberTo.put(asstActInfo.getAsstHGAttribute(), transPLProgramAsstAccountInfo.getActTypeNumberTo());
                    }
                    filter.setBaseNumberFrom(baseNumberFrom);
                    filter.setBaseNumberTo(baseNumberTo);
                }
                filter.setAsstActInfoList(asstActInfoList);
            } else {
                filter.setTransMethodByAsst(false);
            }
            return filter;
        }
        catch (Exception e) {
            logger.error((Object)"\u7ed3\u8f6c\u635f\u76ca\u83b7\u53d6\u65b9\u6848\u53c2\u6570\u65f6\u51fa\u9519\u5566\uff01");
            throw new BOSException((Throwable)e);
        }
    }

    private int checkCanTransPL(Context ctx, String cuid, String profitCenterId, String companyId, String periodId) throws BOSException, EASBizException, PcaPeriodEndException {
        ObjectUuidPK companyIdPk = new ObjectUuidPK(BOSUuid.read((String)companyId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)PcaUtils.getCompanySic());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)companyIdPk, sic);
        if (company.getAccountTable() == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        String accounttableid = company.getAccountTable().getId().toString();
        int result = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select Top 1 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("from \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tt_BD_AccountType actype,\t\t\t\t\t\t\t\t  \t\t\r\n");
            sql.append("  \tt_bd_accountview acct\t                                        \r\n");
            sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tacct.Fcompanyid = ?\t and acct.FaccountTableId=?\t\t\t\t\t\r\n");
            sql.append("\tand actype.FID = acct.FAccountTypeID and actype.FProperty in (4 ,8)\t\r\n");
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLACCOUNT);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("select Top 1 1\t \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("from t_PCA_PcVoucher vch \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tvch.FProfitCenterID = ?\t\t\t\t\t\t                    \r\n");
            sql.append("\tand vch.FPeriodID =");
            sql.append("?               \r\n");
            sql.append("\tand (vch.FBizStatus <> 0 and vch.FBizStatus <> 2 and vch.FBizStatus <> 5);\r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)profitCenterId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)periodId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new PcaPeriodEndException(PcaPeriodEndException.HAS_VOUCHER_NOT_POSTED);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            if (this.checkCloseInit(ctx, true, true, true, -1, company, profitCenterId) != 0) {
                throw new PcaPeriodEndException(PcaPeriodEndException.PCA_INIT_NOT_CLOSED);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        result = 1;
        return result;
    }

    private int checkCloseInit(Context ctx, boolean isCheckAccount, boolean isCheckAssist, boolean isCheckCussent, int accountType, CompanyOrgUnitInfo company, String profitCenterId) throws BOSException, EASBizException {
        String accounttableid;
        String relatedCompanyId = company.getId().toString();
        boolean isClosed = PcVoucherUtil.closeInit(ctx, profitCenterId, relatedCompanyId, accounttableid = company.getAccountTable().getId().toString());
        if (isClosed) {
            return 0;
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer errMsg = null;
        boolean isGLAcctCussent = this.isAllowCussent(ctx, (IObjectPK)new ObjectUuidPK(relatedCompanyId));
        try {
            con = this.getConnection(ctx);
            if (isCheckAccount) {
                sql = new StringBuffer();
                sql.append("select 1 where exists          \t\t\r\n");
                sql.append("(select 1 from t_PCA_Flag          \t\r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("\tand FName = 'pcainit'    \t\r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)profitCenterId);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new PcaPeriodEndException(PcaPeriodEndException.PCA_INIT_NOT_CLOSED);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckAssist) {
                sql = new StringBuffer();
                sql.append("select top 10 v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct acct.FID as FAccountID,     \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \t\t\r\n");
                sql.append("\tacct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\t\t\r\n");
                sql.append("from t_bd_accountview acct,          \t\t\r\n");
                sql.append("\tt_bd_AccountType actype               \t\r\n");
                sql.append("where actype.FID = acct.FAccountTypeID    \t\r\n");
                if (accountType != -1) {
                    sql.append("\tand actype.FProperty = ").append(accountType).append("   \t\r\n");
                }
                sql.append("\tand acct.FCAA is not null       \t\t\r\n");
                sql.append("\tand acct.Fcompanyid = ?   and acct.FaccountTableId=?        \t\t\r\n");
                sql.append("\tand acct.FIsLeaf = 1           \t\t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_PCA_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("\tand FName = 'astinit'           \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append("order by v1.FAccountNumber          \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)relatedCompanyId);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)profitCenterId);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
                if (errMsg.length() > 0) {
                    errMsg.delete(errMsg.length() - 1, errMsg.length());
                    Object[] info = new String[]{errMsg.toString()};
                    throw new PcaPeriodEndException(PcaPeriodEndException.ASST_INIT_NOT_CLOSED, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            if (isCheckCussent) {
                // empty if block
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return 0;
    }

    private boolean isAllowCussent(Context ctx, IObjectPK comPK) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> hmParamIn = new HashMap<String, IObjectPK>();
        hmParamIn.put("GL_028", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        return bParam;
    }

    private PcTransPlProgramFilter checkTrans(Context ctx, Map otherMap, PcTransPlProgramFilter filter) throws BOSException, EASBizException {
        String sqlSelectAsstActtype = "select fMappingFieldname,FAsstHGAttribute from  t_bd_asstactgroupdetail b \t\t\t\r\n inner join  t_bd_asstacttype a on a.fid=b.fasstacttypeid\t\t\t\t\r\n where b.fasstaccountid=? and a.FAsstHGAttribute in(";
        String sqlSelectSql = "select fMappingFieldname,FAsstHGAttribute from  t_bd_asstactgroupdetail b \t\t\t\r\n inner join  t_bd_asstacttype a on a.fid=b.fasstacttypeid\t\t\t\t\r\n\twhere b.fasstaccountid = (select fcaa from t_bd_accountview where fid=?)";
        List asstActInfoList = filter.getAsstActInfoList();
        if (asstActInfoList.size() == 0) {
            return filter;
        }
        int size = asstActInfoList.size();
        for (int i = 0; i < size; ++i) {
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
            if (i > 0) {
                sqlSelectAsstActtype = sqlSelectAsstActtype + ",";
            }
            sqlSelectAsstActtype = sqlSelectAsstActtype + "'" + asstActInfo.getAsstHGAttribute() + "'";
        }
        sqlSelectAsstActtype = sqlSelectAsstActtype + ")";
        if (otherMap != null) {
            Set st = otherMap.keySet();
            Iterator it = st.iterator();
            IRowSet rows = null;
            HashMap<String, String> asstHGAttribute = new HashMap<String, String>();
            HashMap acctAsstHGAttribute = new HashMap();
            ArrayList<String[]> asstHGAttributeList = null;
            ArrayList<String> remove = new ArrayList<String>();
            try {
                String fnumber = null;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    AccountViewInfo gainAccount = (AccountViewInfo)otherMap.get(key);
                    fnumber = gainAccount.getNumber();
                    if (gainAccount.getCAA() != null) {
                        String[] asstbite;
                        String caa = gainAccount.getCAA().getId().toString();
                        asstHGAttribute.clear();
                        if (acctAsstHGAttribute.containsKey(gainAccount.getId().toString())) {
                            asstHGAttributeList = (ArrayList<String[]>)acctAsstHGAttribute.get(gainAccount.getId().toString());
                        } else {
                            rows = DbUtil.executeQuery((Context)ctx, (String)sqlSelectAsstActtype, (Object[])new Object[]{caa});
                            if (rows != null) {
                                asstHGAttributeList = null;
                                while (rows.next()) {
                                    if (asstHGAttributeList == null) {
                                        asstHGAttributeList = new ArrayList<String[]>();
                                    }
                                    String field = rows.getString("fMappingFieldname");
                                    asstbite = rows.getString("FAsstHGAttribute");
                                    asstHGAttributeList.add(new String[]{field, asstbite});
                                }
                            }
                            if (asstHGAttributeList != null) {
                                acctAsstHGAttribute.put(gainAccount.getId().toString(), asstHGAttributeList);
                            } else {
                                remove.add(key);
                                continue;
                            }
                        }
                        rows = DbUtil.executeQuery((Context)ctx, (String)sqlSelectSql, (Object[])new Object[]{key});
                        while (rows != null && rows.next()) {
                            asstHGAttribute.put(rows.getString("fMappingFieldname"), caa);
                        }
                        for (int i = 0; i < asstHGAttributeList.size(); ++i) {
                            asstbite = (String[])asstHGAttributeList.get(i);
                            if (asstHGAttribute.containsKey(asstbite[0])) continue;
                            remove.add(key);
                        }
                        continue;
                    }
                    remove.add(key);
                }
                for (int i = 0; i < remove.size(); ++i) {
                    otherMap.remove(remove.get(i));
                }
                if (otherMap.size() == 0) {
                    throw new TransPLException(TransPLException.ACCOUNTNOTSAME, new Object[]{fnumber});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new SQLDataException(e);
            }
            filter.setAcctAsstHGAttribute(acctAsstHGAttribute);
        }
        return filter;
    }

    /*
     * Unable to fully structure code
     */
    private PcTransPlProgramFilter genVchTrans(Context ctx, PcTransPlProgramFilter filter) throws BOSException, EASBizException {
        block74: {
            block73: {
                company = filter.getCompanyOrgUnit();
                profitCenter = filter.getProfitCenter();
                filter.setReturnVchCount(0);
                filter.setReturnVch1(null);
                filter.setReturnVch2(null);
                isByAsstTrans = filter.isTransMethodByAsst();
                isQtyByAsst = filter.isQtyByAsst();
                this.isState = filter.isParamCheckCurrency();
                hmAllParam = filter.getHmGLParam();
                isForCySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
                if (isForCySU) {
                    return this.genVchTransPnL0(ctx, filter);
                }
                transCompanyId = profitCenter.getId().toString();
                curUserID = filter.getCurUser().getId().toString();
                lcId = company.getBaseCurrency().getId().toString();
                lexTableId = null;
                if (company.getBaseExchangeTable() != null) {
                    lexTableId = company.getBaseExchangeTable().getId().toString();
                }
                useReport = filter.isParamUseReportCurrency();
                rcId = null;
                if (company.getReportCurrency() != null) {
                    rcId = company.getReportCurrency().getId().toString();
                }
                rexTableId = null;
                if (company.getReportExchangeTable() != null) {
                    rexTableId = company.getReportExchangeTable().getId().toString();
                }
                isLocal = false;
                if (company.getReportConvertMode() != null) {
                    isLocal = ReportCurrencyConvertMode.Base.equals((Object)company.getReportConvertMode());
                }
                transPeriod = filter.getTransCompanyPeriod();
                filter.setTransCompanyPeriod(transPeriod);
                transPeriodID = transPeriod.getId().toString();
                curUser = new UserInfo();
                curUser.setId(BOSUuid.read((String)curUserID));
                filter.setCurUser(curUser);
                filter.setCurServerTime(filter.getFilterVchDate());
                priceScale = new Integer(hmAllParam.get("GL_003").toString());
                vchGenPLSeparate = filter.getFilterVchPLType();
                vchGenProfitOrLoss = filter.getFilterVchProfitLoss();
                hmPLAccount = filter.getHmPLAccount();
                hmUnSelectedAccount = filter.getHmUnSelectedAccount();
                vchDesc = filter.getFilterVchDesc();
                transByDC = filter.isFilterTransPLByBalOppDC();
                now = new java.sql.Date(filter.getFilterVchDate().getTime());
                hmLocalEx = new HashMap<K, V>();
                hmRptEx = new HashMap<K, V>();
                con = null;
                stmt = null;
                rs = null;
                isSubAdjustPeriodBal = false;
                con = this.getConnection(ctx);
                sql = null;
                if (!filter.getTransCompanyPeriod().isIsAdjustPeriod()) {
                    adjustPeriodInfo = PeriodUtils.getAdjPeriodInfo((Context)ctx, (PeriodInfo)filter.getTransCompanyPeriod());
                    if (adjustPeriodInfo != null) {
                        currentPeriod = filter.getTransCompanyPeriod();
                        isSubAdjustPeriodBal = true;
                        currentSql = this.getVchTransPnLSql(filter, false);
                        filter.setTransCompanyPeriod(adjustPeriodInfo);
                        adjustSql = this.getVchTransPnLSql(filter, false);
                        sqlSb = new StringBuffer();
                        sqlSb.append("select curr.fnumber,  curr.FAccountDC, curr.FAccountID, curr.FAssistGrpID,  curr.FCurrencyID,  curr.FIsQty,  curr.FDefaultUnitID, (curr.FEndBalanceFor -  isnull(adjust.FEndBalanceFor,0)) as FEndBalanceFor,  (curr.FEndBalanceLocal -   isnull(adjust.FEndBalanceLocal,0)) as  FEndBalanceLocal ,  (curr.FEndBalanceRpt -  isnull(adjust.FEndBalanceRpt,0)) as FEndBalanceRpt,  (curr.FEndQty -  isnull(adjust.FEndQty,0)) as FEndQty  ");
                        if (isByAsstTrans) {
                            asstActInfoList = filter.getAsstActInfoList();
                            size = asstActInfoList.size();
                            for (i = 0; i < size; ++i) {
                                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                                sqlSb.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                            }
                        }
                        sqlSb.append("  from ").append("( ").append(currentSql).append(" ) curr left join").append(" ( ").append(adjustSql).append(" ) adjust ").append(" on curr.FAccountID = adjust.FAccountID and curr.FAssistGrpID = adjust.FAssistGrpID and curr.FCurrencyID = adjust.FCurrencyID ").append(" order by curr.FCurrencyID, curr.fnumber,curr.FAccountID, curr.FAssistGrpID ");
                        filter.setTransCompanyPeriod(currentPeriod);
                        stmt = con.prepareStatement(sqlSb.toString());
                        index = 1;
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, currentPeriod.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, currentPeriod.getNumber());
                        if (isQtyByAsst) {
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, currentPeriod.getNumber());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, currentPeriod.getNumber());
                        }
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, adjustPeriodInfo.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, adjustPeriodInfo.getNumber());
                        if (isQtyByAsst) {
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, adjustPeriodInfo.getNumber());
                            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                            stmt.setInt(index++, adjustPeriodInfo.getNumber());
                        }
                    } else {
                        sql = this.getVchTransPnLSql(filter, true);
                    }
                } else {
                    sql = this.getVchTransPnLSql(filter, true);
                }
                if (!isSubAdjustPeriodBal) {
                    stmt = con.prepareStatement(sql);
                    index = 1;
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                    stmt.setInt(index++, transPeriod.getNumber());
                    DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                    stmt.setInt(index++, transPeriod.getNumber());
                    if (isQtyByAsst) {
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, transPeriod.getNumber());
                        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transCompanyId);
                        stmt.setInt(index++, transPeriod.getNumber());
                    }
                }
                rs = stmt.executeQuery();
                vchCtrl = PcVoucherFactory.getLocalInstance((Context)ctx);
                preVch1 = this.getNewPLVoucher(ctx, filter);
                preVch2 = this.getNewPLVoucher(ctx, filter);
                hmPLAcctSum1 = new HashMap<PcAccountCurrencyPair, BigDecimal[]>();
                hmPLAcctSum2 = new HashMap<K, V>();
                glAcctAsstMap = new HashMap<String, HashMap<K, V>>();
                filter.setGlAcctAsstMap(glAcctAsstMap);
                preEntry = null;
                preSum = null;
                acctOldId = null;
                entryDCPl = false;
                while (rs.next()) {
                    acctDC = rs.getInt("FAccountDC");
                    grpId = rs.getString("FAssistGrpID");
                    acctId = rs.getString("FAccountID");
                    newEntry = " ".equals(grpId) != false || "".equals(grpId) != false;
                    isAddEntry = false;
                    if (acctOldId != null) {
                        isAddEntry = newEntry == false && acctOldId.equals(acctId) == false;
                    }
                    acctOldId = rs.getString("FAccountID");
                    if (hmUnSelectedAccount.containsKey(acctId)) continue;
                    plAcct = (AccountViewInfo)hmPLAccount.get(acctId);
                    this.curId2 = filter.getCompanyOrgUnit().getBaseCurrency().getId().toString();
                    number = rs.getString("fnumber");
                    curId = rs.getString("FCurrencyID");
                    loc = rs.getBigDecimal("FEndBalanceLocal") == null ? PcaUtils.zero : rs.getBigDecimal("FEndBalanceLocal");
                    rpt = rs.getBigDecimal("FEndBalanceRpt") == null ? PcaUtils.zero : rs.getBigDecimal("FEndBalanceRpt");
                    org = rs.getBigDecimal("FEndBalanceFor") == null ? PcaUtils.zero : rs.getBigDecimal("FEndBalanceFor");
                    qty = rs.getBigDecimal("FEndQty") == null ? PcaUtils.zero : rs.getBigDecimal("FEndQty");
                    v0 = isQty = rs.getInt("FIsQty") != 0;
                    if (plAcct == null) {
                        if (PcaUtils.zero.compareTo(loc) == 0 && PcaUtils.zero.compareTo(rpt) == 0 && PcaUtils.zero.compareTo(org) == 0 && PcaUtils.zero.compareTo(qty) == 0 || isByAsstTrans) continue;
                        throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLACCOUNT2, new Object[]{number});
                    }
                    pl = this.getPL(new BigDecimal[]{loc, rpt, org, qty});
                    if (newEntry) {
                        entryDCPl = pl;
                    }
                    v1 = pl = acctDC == -1;
                    if (newEntry || isAddEntry) {
                        this.addPLEntry(preEntry, hmPLAccount, preSum);
                        vch = pl != false ? preVch1 : preVch2;
                        hmSum = pl != false ? hmPLAcctSum1 : hmPLAcctSum2;
                        cur = new CurrencyInfo();
                        cur.setId(BOSUuid.read((String)curId));
                        cur2 = new CurrencyInfo();
                        cur2.setId(BOSUuid.read((String)this.curId2));
                        if (!PcaUtils.isAllZeroOrNull(new BigDecimal[]{org, loc, rpt, qty})) {
                            pair = this.isState != false ? new PcAccountCurrencyPair(plAcct, cur2) : new PcAccountCurrencyPair(plAcct, cur);
                            if (!isAddEntry) {
                                s = (BigDecimal[])hmSum.get(pair);
                                if (s == null) {
                                    hmSum.put(pair, new BigDecimal[]{org, loc, rpt});
                                } else {
                                    s[0] = s[0].add(org);
                                    s[1] = s[1].add(loc);
                                    s[2] = s[2].add(rpt);
                                }
                            } else {
                                s = (BigDecimal[])hmSum.get(pair);
                                if (s == null) {
                                    hmSum.put(pair, new BigDecimal[]{PcaUtils.zero, PcaUtils.zero, PcaUtils.zero});
                                } else {
                                    s[0] = s[0].add(PcaUtils.zero);
                                    s[1] = s[1].add(PcaUtils.zero);
                                    s[2] = s[2].add(PcaUtils.zero);
                                }
                            }
                        }
                        preEntry = new PcVoucherEntryInfo();
                        preEntry.setOprStatus(1);
                        preEntry.setBill(vch);
                        preEntry.setDescription(vchDesc);
                        acct = new AccountViewInfo();
                        acct.setId(BOSUuid.read((String)acctId));
                        preEntry.setAccount(acct);
                        preEntry.setCurrency(cur);
                        dc = EntryDC.CREDIT;
                        el = loc;
                        er = rpt;
                        es = org;
                        eq = qty;
                        if (transByDC && entryDCPl || !transByDC && acctDC == -1) {
                            el = loc.negate();
                            er = rpt.negate();
                            es = org.negate();
                            eq = qty.negate();
                            dc = EntryDC.DEBIT;
                        }
                        preEntry.setEntryDC(dc);
                        preEntry.setOriginalAmount(es);
                        preEntry.setLocalAmount(el);
                        preEntry.setReportingAmount(er);
                        lex = this.getEx(con, hmLocalEx, curId, lcId, lexTableId, now);
                        preEntry.setLocalExchangeRate(lex);
                        rex = null;
                        rex = useReport ? (isLocal ? this.getEx(con, hmRptEx, lcId, rcId, rexTableId, now) : this.getEx(con, hmRptEx, curId, rcId, rexTableId, now)) : PcaUtils.zero;
                        preEntry.setReportingExchangeRate(rex);
                        if (!isQtyByAsst && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                            mu = new MeasureUnitInfo();
                            mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                            preEntry.setMeasureUnit(mu);
                        }
                        preEntry.setQuantity(eq);
                        preEntry.setStandardQuantity(eq);
                        if (PcaUtils.zero.compareTo(eq) != 0) {
                            preEntry.setPrice(org.divide(eq, priceScale, 4).abs());
                        } else {
                            preEntry.setPrice(PcaUtils.zero);
                        }
                        preSum = hmSum;
                        if (isAddEntry) {
                            preEntry.setOriginalAmount(PcaUtils.zero);
                            preEntry.setLocalAmount(PcaUtils.zero);
                            preEntry.setReportingAmount(PcaUtils.zero);
                            preEntry.setQuantity(PcaUtils.zero);
                            preEntry.setStandardQuantity(PcaUtils.zero);
                            preEntry.setPrice(PcaUtils.zero);
                        }
                    }
                    if (newEntry && !isAddEntry) continue;
                    rec = new PcVoucherAssistRecordInfo();
                    if (preEntry == null) {
                        this.addPLEntry(preEntry, hmPLAccount, preSum);
                        vch = pl != false ? preVch1 : preVch2;
                        hmSum = pl != false ? hmPLAcctSum1 : hmPLAcctSum2;
                        cur = new CurrencyInfo();
                        cur.setId(BOSUuid.read((String)curId));
                        preEntry = new PcVoucherEntryInfo();
                        preEntry.setOprStatus(1);
                        preEntry.setBill(vch);
                        preEntry.setDescription(vchDesc);
                        acct = new AccountViewInfo();
                        acct.setId(BOSUuid.read((String)acctId));
                        preEntry.setAccount(acct);
                        preEntry.setCurrency(cur);
                        dc = EntryDC.CREDIT;
                        if (transByDC && entryDCPl || !transByDC && acctDC == -1) {
                            dc = EntryDC.DEBIT;
                        }
                        preEntry.setEntryDC(dc);
                        preEntry.setOriginalAmount(PcaInitHelp.zero);
                        preEntry.setLocalAmount(PcaInitHelp.zero);
                        preEntry.setReportingAmount(PcaInitHelp.zero);
                        lex = this.getEx(con, hmLocalEx, curId, lcId, lexTableId, now);
                        preEntry.setLocalExchangeRate(lex);
                        rex = null;
                        rex = useReport ? (isLocal ? this.getEx(con, hmRptEx, lcId, rcId, rexTableId, now) : this.getEx(con, hmRptEx, curId, rcId, rexTableId, now)) : PcaUtils.zero;
                        preEntry.setReportingExchangeRate(rex);
                        if (!isQtyByAsst && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                            mu = new MeasureUnitInfo();
                            mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                            preEntry.setMeasureUnit(mu);
                        }
                        preEntry.setQuantity(PcaInitHelp.zero);
                        preEntry.setStandardQuantity(PcaInitHelp.zero);
                        preEntry.setPrice(PcaUtils.zero);
                        preSum = hmSum;
                    }
                    rec.setOprStatus(1);
                    rec.setBizDate(preEntry.getBill().getBizDate());
                    rec.setDescription(vchDesc);
                    hg = new AssistantHGInfo();
                    hg.setId(BOSUuid.read((String)grpId));
                    rec.setAssGrp(hg);
                    rec.setEndDate(preEntry.getBill().getBizDate());
                    al = loc;
                    ar = rpt;
                    as = org;
                    aq = qty;
                    if (EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                        al = loc.negate();
                        ar = rpt.negate();
                        as = org.negate();
                        aq = qty.negate();
                    }
                    rec.setOriginalAmount(as);
                    rec.setLocalAmount(al);
                    rec.setReportingAmount(ar);
                    rec.setQuantity(aq);
                    rec.setStandardQuantity(aq);
                    if (isByAsstTrans) {
                        if (!EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                            al = al.negate();
                            ar = ar.negate();
                            as = as.negate();
                            aq = aq.negate();
                        }
                        if ((keyMap = (HashMap<String, HashMap<K, V>>)glAcctAsstMap.get(key = this.isState != false ? plAcct.getId().toString() + this.curId2 : plAcct.getId().toString() + curId)) == null) {
                            keyMap = new HashMap<String, HashMap<K, V>>();
                            glAcctAsstMap.put(key, keyMap);
                        }
                        if ((asstbitemap = (HashMap<String, HashMap<K, V>>)keyMap.get("asstbitemap")) == null) {
                            asstbitemap = new HashMap<String, HashMap<K, V>>();
                            keyMap.put("asstbitemap", asstbitemap);
                        }
                        asstHGAttributeList = null;
                        if (filter.getAcctAsstHGAttribute() != null) {
                            asstHGAttributeList = (List)filter.getAcctAsstHGAttribute().get(plAcct.getId().toString());
                        }
                        hgasstid = "";
                        if (asstHGAttributeList != null) {
                            idmap = new HashMap<String, String>();
                            size = asstHGAttributeList.size();
                            for (i = 0; i < size; ++i) {
                                asstbite = (String[])asstHGAttributeList.get(i);
                                mappingFieldName = asstbite[0];
                                hgasstid = hgasstid + rs.getString(mappingFieldName);
                                idmap.put(asstbite[1], rs.getString(mappingFieldName));
                            }
                            if (vchGenProfitOrLoss == 3 && vchGenPLSeparate == 1) {
                                asstbitemap.put(hgasstid + "Profit", idmap);
                                asstbitemap.put(hgasstid + "Loss", idmap);
                            } else {
                                asstbitemap.put(hgasstid, idmap);
                            }
                        }
                        if ((almap = (HashMap<String, BigDecimal>)keyMap.get("almap")) == null) {
                            almap = new HashMap<String, BigDecimal>();
                            keyMap.put("almap", almap);
                        }
                        if ((armap = (HashMap<String, BigDecimal>)keyMap.get("armap")) == null) {
                            armap = new HashMap<String, BigDecimal>();
                            keyMap.put("armap", armap);
                        }
                        if ((asmap = (HashMap<String, BigDecimal>)keyMap.get("asmap")) == null) {
                            asmap = new HashMap<String, BigDecimal>();
                            keyMap.put("asmap", asmap);
                        }
                        if ((aqmap = (HashMap<String, BigDecimal>)keyMap.get("aqmap")) == null) {
                            aqmap = new HashMap<String, BigDecimal>();
                            keyMap.put("aqmap", aqmap);
                        }
                        v2 = isAddPlRec = pl != false && vchGenProfitOrLoss == 1 || pl == false && vchGenProfitOrLoss == 2 || vchGenProfitOrLoss == 0 || vchGenProfitOrLoss == 3;
                        if (isAddPlRec) {
                            hgasstidkey = hgasstid;
                            if (vchGenProfitOrLoss == 3 && vchGenPLSeparate == 1) {
                                hgasstidkey = pl != false ? hgasstidkey + "Profit" : hgasstidkey + "Loss";
                            }
                            if (glAcctAsstMap.containsKey(key)) {
                                keyal = al;
                                keyar = ar;
                                keyas = as;
                                keyaq = aq;
                                if (almap.get(hgasstidkey) != null) {
                                    keyal = al.add((BigDecimal)almap.get(hgasstidkey));
                                    keyar = ar.add((BigDecimal)armap.get(hgasstidkey));
                                    keyas = as.add((BigDecimal)asmap.get(hgasstidkey));
                                    keyaq = aq.add((BigDecimal)aqmap.get(hgasstidkey));
                                }
                                almap.put(hgasstidkey, keyal);
                                armap.put(hgasstidkey, keyar);
                                asmap.put(hgasstidkey, keyas);
                                aqmap.put(hgasstidkey, keyaq);
                            } else {
                                almap.put(hgasstidkey, al);
                                armap.put(hgasstidkey, ar);
                                asmap.put(hgasstidkey, as);
                                aqmap.put(hgasstidkey, aq);
                            }
                        }
                    }
                    if (isQtyByAsst && isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                        mu = new MeasureUnitInfo();
                        mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                        rec.setMeasureUnit(mu);
                    }
                    if (PcaUtils.zero.compareTo(aq) != 0) {
                        rec.setPrice(org.divide(aq, priceScale, 4).abs());
                    } else {
                        rec.setPrice(PcaUtils.zero);
                    }
                    preEntry.getAssistRecords().add(rec);
                }
                this.addPLEntry(preEntry, hmPLAccount, preSum);
                if (vchGenProfitOrLoss == 1) {
                    hmPLAcctSum2.clear();
                    preVch2.getEntries().clear();
                } else if (vchGenProfitOrLoss == 2) {
                    hmPLAcctSum1.clear();
                    preVch1.getEntries().clear();
                }
                if (preVch1.getEntries().size() != 0 || preVch2.getEntries().size() != 0) ** GOTO lbl392
                if (!transPeriod.isIsAdjustPeriod()) break block73;
                filter.setAdjustNoBalance(true);
                acctDC = filter;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return acctDC;
            }
            try {
                throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL);
lbl392:
                // 1 sources

                if (vchGenPLSeparate == 1) {
                    count = 0;
                    if (preVch1.getEntries().size() > 0) {
                        this.genPLEntryEx(ctx, hmPLAcctSum1, preVch1, vchDesc, vchCtrl, filter, isLocal, hmLocalEx, hmRptEx, vchGenPLSeparate, true);
                        preVch1 = this.lazyLoad(ctx, preVch1);
                        if (preVch1.getEntries().size() > 0) {
                            filter.setReturnVch1((BaseVoucherInfo)preVch1);
                            ++count;
                        } else {
                            throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL);
                        }
                    }
                    if (preVch2.getEntries().size() > 0) {
                        this.genPLEntryEx(ctx, hmPLAcctSum2, preVch2, vchDesc, vchCtrl, filter, isLocal, hmLocalEx, hmRptEx, vchGenPLSeparate, false);
                        preVch2 = this.lazyLoad(ctx, preVch2);
                        if (preVch2.getEntries().size() > 0) {
                            filter.setReturnVch2((BaseVoucherInfo)preVch2);
                            ++count;
                        } else {
                            throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL);
                        }
                    }
                    filter.setReturnVchCount(count);
                    break block74;
                }
                preVch1.getEntries().addCollection(preVch2.getEntries());
                this.combineSumEx(hmPLAcctSum1, hmPLAcctSum2);
                this.genPLEntryEx(ctx, hmPLAcctSum1, preVch1, vchDesc, vchCtrl, filter, isLocal, hmLocalEx, hmRptEx, vchGenPLSeparate, true);
                preVch1 = this.lazyLoad(ctx, preVch1);
                if (preVch1.getEntries().size() > 0) {
                    filter.setReturnVch1((BaseVoucherInfo)preVch1);
                    filter.setReturnVchCount(1);
                    break block74;
                }
                throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL);
            }
            catch (SQLException sqle) {
                try {
                    throw new BOSException((Throwable)sqle);
                }
                catch (Throwable var80_90) {
                    SQLUtils.cleanup(rs, stmt, (Connection)con);
                    throw var80_90;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return filter;
    }

    private void combineSumEx(HashMap hmPLAcctSum1, HashMap hmPLAcctSum2) {
        if (hmPLAcctSum2.size() == 0) {
            return;
        }
        if (hmPLAcctSum1.size() == 0) {
            hmPLAcctSum1.putAll(hmPLAcctSum2);
            return;
        }
        for (Map.Entry e : hmPLAcctSum2.entrySet()) {
            BigDecimal[] s2 = (BigDecimal[])e.getValue();
            BigDecimal[] s1 = (BigDecimal[])hmPLAcctSum1.get(e.getKey());
            if (s1 != null) {
                s1[0] = s1[0].add(s2[0]);
                s1[1] = s1[1].add(s2[1]);
                s1[2] = s1[2].add(s2[2]);
                continue;
            }
            hmPLAcctSum1.put(e.getKey(), s2);
        }
    }

    private PcVoucherInfo lazyLoad(Context ctx, PcVoucherInfo vchinfo) throws BOSException, VoucherException, EASBizException {
        IPcVoucher vchCtrl = PcVoucherFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = PcVoucherInfo.getDefaultSelector();
        PcVoucherInfo vch = new PcVoucherInfo();
        vch = vchCtrl.exteriorLazyLoad((BaseVoucherInfo)vchinfo, selector);
        PcVoucherEntryInfo ve = null;
        AccountViewInfo acct = null;
        PcVoucherEntryCollection veColl = vch.getEntries();
        PcVoucherEntryCollection newVeColl = new PcVoucherEntryCollection();
        for (int i = 0; i < veColl.size(); ++i) {
            ve = veColl.get(i);
            acct = ve.getAccount();
            if (acct.getCAA() != null) {
                int rtnFlag = this.fillEntryHasAssist1(ctx, ve, acct);
                if (rtnFlag != 1) continue;
                newVeColl.add(ve);
                continue;
            }
            if (ve.getLocalAmount().doubleValue() == 0.0 && ve.getReportingAmount().doubleValue() == 0.0 && ve.getOriginalAmount().doubleValue() == 0.0 && (ve.getQuantity() == null || ve.getQuantity().doubleValue() == 0.0)) continue;
            newVeColl.add(ve);
        }
        vchinfo.setEntries((AbstractObjectCollection)newVeColl);
        return vch;
    }

    private int fillEntryHasAssist1(Context ctx, PcVoucherEntryInfo ve, AccountViewInfo acct) throws BOSException, VoucherException, EASBizException {
        int rtnFlag = 0;
        AsstAccountInfo asstAct = null;
        String typeGroupId = null;
        if (acct.getCAA() == null) {
            return rtnFlag;
        }
        asstAct = acct.getCAA();
        typeGroupId = asstAct.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("asstActType.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)typeGroupId));
        IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
        AsstActGroupDetailCollection asstDeColl = relCtrl.getAsstActGroupDetailCollection(view);
        SelectorItemCollection sicHG = new SelectorItemCollection();
        for (AsstActGroupDetailInfo asstDe : asstDeColl) {
            AsstActTypeInfo asstType = asstDe.getAsstActType();
            String attribute = asstType.getAsstHGAttribute();
            sicHG.add(new SelectorItemInfo(attribute + ".id"));
            sicHG.add(new SelectorItemInfo(attribute + ".number"));
            sicHG.add(new SelectorItemInfo(attribute + ".name"));
            if (attribute.equalsIgnoreCase("companyOrg") || attribute.equalsIgnoreCase("saleOrg") || attribute.equalsIgnoreCase("profitOrg") || attribute.equalsIgnoreCase("purchaseOrg") || attribute.equalsIgnoreCase("storeageOrg") || attribute.equalsIgnoreCase("costOrg")) {
                sicHG.add(new SelectorItemInfo(attribute + ".isBizUnit"));
                continue;
            }
            if (!attribute.equalsIgnoreCase("adminOrg")) continue;
            sicHG.add(new SelectorItemInfo(attribute + ".isLeaf"));
        }
        IAssistantHG hgCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        PcVoucherAssistRecordCollection asstColl = ve.getAssistRecords();
        PcVoucherAssistRecordInfo asst = null;
        Iterator iterator = asstColl.iterator();
        while (iterator.hasNext()) {
            PcVoucherAssistRecordInfo assistRecord = (PcVoucherAssistRecordInfo)iterator.next();
            if (assistRecord.getLocalAmount().doubleValue() == 0.0 && assistRecord.getReportingAmount().doubleValue() == 0.0 && assistRecord.getOriginalAmount().doubleValue() == 0.0 && (assistRecord.getQuantity() == null || assistRecord.getQuantity().doubleValue() == 0.0)) {
                iterator.remove();
                continue;
            }
            rtnFlag = 1;
            AssistantHGInfo hg = null;
            asst = assistRecord;
            hg = asst.getAssGrp();
            if (hg == null) continue;
            String hgId = hg.getId().toString();
            ObjectUuidPK hgPK = new ObjectUuidPK(BOSUuid.read((String)hgId));
            hg = hgCtrl.getAssistantHGInfo((IObjectPK)hgPK, sicHG);
            for (AsstActGroupDetailInfo asstDe : asstDeColl) {
                DataBaseInfo info;
                AsstActTypeInfo asstType = asstDe.getAsstActType();
                String attribute = asstType.getAsstHGAttribute();
                if (hg.get(attribute) == null || (info = (DataBaseInfo)hg.get(attribute)) == null || info.getString("displayName") != null) continue;
                if (info.getDisplayName() != null) {
                    info.setString("displayName", info.getDisplayName().trim());
                    continue;
                }
                info.setString("displayName", info.getName());
            }
            asst.setAssGrp(hg);
        }
        return rtnFlag;
    }

    private void genPLEntryEx(Context ctx, HashMap hmPLAcctSum, PcVoucherInfo vch, String vchDesc, IPcVoucher vchCtrl, PcTransPlProgramFilter filter, boolean isLocal, HashMap localEx, HashMap rptEX, int vchGenPLSeparate, boolean isProfit) throws BOSException, EASBizException {
        BigDecimal[] sum;
        HashMap<PcAccountCurrencyPair, Object> hmTemp = new HashMap<PcAccountCurrencyPair, Object>();
        for (Map.Entry e : hmPLAcctSum.entrySet()) {
            PcAccountCurrencyPair pair = (PcAccountCurrencyPair)e.getKey();
            AccountViewInfo plAcct = pair.getAccount();
            if (plAcct.getCurrencyID() != null) {
                CurrencyInfo cur = plAcct.getCurrencyID();
                PcAccountCurrencyPair newPair = new PcAccountCurrencyPair(plAcct, cur);
                sum = (BigDecimal[])e.getValue();
                BigDecimal[] s = (BigDecimal[])hmTemp.get(newPair);
                if (s == null) {
                    hmTemp.put(pair, new BigDecimal[]{sum[1], sum[1], sum[2]});
                    continue;
                }
                s[0] = s[0].add(sum[1]);
                s[1] = s[1].add(sum[1]);
                s[2] = s[2].add(sum[2]);
                continue;
            }
            hmTemp.put(pair, e.getValue());
        }
        String baseCurId = filter.getCompanyOrgUnit().getBaseCurrency().getId().toString();
        for (Map.Entry e : hmTemp.entrySet()) {
            BigDecimal rate1;
            PcAccountCurrencyPair pair = (PcAccountCurrencyPair)e.getKey();
            AccountViewInfo plAcct = pair.getAccount();
            CurrencyInfo cur = pair.getCurrency();
            sum = (BigDecimal[])e.getValue();
            EntryDC dc = EntryDC.DEBIT;
            if (this.getPL(sum)) {
                for (int i = 0; i < sum.length; ++i) {
                    sum[i] = sum[i].negate();
                }
                dc = EntryDC.CREDIT;
            }
            PcVoucherEntryInfo entry = new PcVoucherEntryInfo();
            entry.setOriginalAmount(PcaUtils.zero);
            entry.setLocalAmount(PcaUtils.zero);
            entry.setReportingAmount(PcaUtils.zero);
            entry.setOprStatus(1);
            entry.setDescription(vchDesc);
            entry.setAccount(plAcct);
            entry.setCurrency(cur);
            CurrencyInfo cur1 = new CurrencyInfo();
            cur1.setId(BOSUuid.read((String)baseCurId));
            if (this.isState) {
                entry.setCurrency(cur1);
                sum[0] = sum[1];
            } else {
                entry.setCurrency(cur);
            }
            if (!baseCurId.equals(cur.getId().toString())) {
                this.checkAccountAndCurrency(ctx, plAcct, cur);
            }
            entry.setEntryDC(dc);
            boolean isByAsstTrans = filter.isTransMethodByAsst();
            boolean useReport = filter.isParamUseReportCurrency();
            entry.setOriginalAmount(sum[0]);
            entry.setLocalAmount(sum[1]);
            entry.setReportingAmount(sum[2]);
            if (filter.getLocalCurrency().getId().toString().equals(cur.getId().toString()) || entry.getOriginalAmount().compareTo(PcaUtils.zero) == 0) {
                entry.setLocalExchangeRate(PcaUtils.one);
            } else if (this.isState) {
                rate1 = new BigDecimal("1.00");
                entry.setLocalExchangeRate(rate1);
            } else {
                entry.setLocalExchangeRate((BigDecimal)localEx.get(cur.getId().toString()));
            }
            if (filter.getReportCurrency() == null || filter.getReportCurrency().getId().toString().equals(cur.getId().toString()) || entry.getOriginalAmount().compareTo(PcaUtils.zero) == 0) {
                entry.setReportingExchangeRate(PcaUtils.one);
            } else if (useReport) {
                if (isLocal) {
                    entry.setReportingExchangeRate((BigDecimal)rptEX.get(filter.getLocalCurrency().getId().toString()));
                } else if (this.isState) {
                    rate1 = new BigDecimal("1.00");
                    entry.setReportingExchangeRate(rate1);
                } else {
                    entry.setReportingExchangeRate((BigDecimal)rptEX.get(cur.getId().toString()));
                }
            } else {
                entry.setReportingExchangeRate(PcaUtils.one);
            }
            if (plAcct.isIsQty()) {
                entry.setMeasureUnit(plAcct.getMeasureUnitGroupID().getDefaultUnit());
                entry.setQuantity(PcaUtils.zero);
                entry.setPrice(PcaUtils.zero);
            }
            if (plAcct.getCAA() != null) {
                if (!isByAsstTrans) {
                    PcVoucherAssistRecordInfo rec = new PcVoucherAssistRecordInfo();
                    rec.setBizDate(vch.getBizDate());
                    rec.setOprStatus(1);
                    rec.setDescription(vchDesc);
                    rec.setQuantity(entry.getQuantity());
                    rec.setOriginalAmount(entry.getOriginalAmount());
                    rec.setLocalAmount(entry.getLocalAmount());
                    rec.setReportingAmount(entry.getReportingAmount());
                    entry.getAssistRecords().add(rec);
                } else {
                    String key;
                    String asstaccount = plAcct.getCAA().getId().toString();
                    AsstActTypeCollection types = new AsstActTypeCollection();
                    IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                    Map glasstMap = filter.getGlAcctAsstMap();
                    Map keyMap = (Map)glasstMap.get(key = plAcct.getId().toString() + cur.getId().toString());
                    if (keyMap != null) {
                        Map asstbitemap = (Map)keyMap.get("asstbitemap");
                        Map almap = (Map)keyMap.get("almap");
                        Map armap = (Map)keyMap.get("armap");
                        Map asmap = (Map)keyMap.get("asmap");
                        Map aqmap = (Map)keyMap.get("aqmap");
                        Set set = almap.keySet();
                        PcVoucherAssistRecordInfo rec = null;
                        ArrayList<PcVoucherAssistRecordInfo> vchAssistCollection = new ArrayList<PcVoucherAssistRecordInfo>();
                        int size = vch.getEntries().size();
                        for (int i = 0; i < size; ++i) {
                            PcVoucherAssistRecordCollection vchAssistRecordCollection = vch.getEntries().get(i).getAssistRecords();
                            for (int j = 0; j < vchAssistRecordCollection.size(); ++j) {
                                rec = new PcVoucherAssistRecordInfo();
                                PcVoucherAssistRecordInfo vchAssistRecordInfo = vchAssistRecordCollection.get(j);
                                rec.setOprStatus(1);
                                rec.setDescription(vchDesc);
                                if (!plAcct.isIsQty()) {
                                    rec.setQuantity(PcaUtils.zero);
                                } else {
                                    rec.setQuantity(vchAssistRecordInfo.getQuantity());
                                }
                                if (null != vchAssistRecordInfo.getMeasureUnit()) {
                                    rec.setMeasureUnit(vchAssistRecordInfo.getMeasureUnit());
                                }
                                if (entry.getCurrency() != null && !entry.getCurrency().getId().toString().equals(vch.getEntries().get(i).getCurrency().getId().toString())) continue;
                                if (!vch.getEntries().get(i).getEntryDC().equals((Object)entry.getEntryDC())) {
                                    rec.setOriginalAmount(vchAssistRecordInfo.getOriginalAmount());
                                    rec.setLocalAmount(vchAssistRecordInfo.getLocalAmount());
                                    rec.setReportingAmount(vchAssistRecordInfo.getReportingAmount());
                                } else {
                                    rec.setOriginalAmount(vchAssistRecordInfo.getOriginalAmount().negate());
                                    rec.setLocalAmount(vchAssistRecordInfo.getLocalAmount().negate());
                                    rec.setReportingAmount(vchAssistRecordInfo.getReportingAmount().negate());
                                }
                                AssistantHGInfo hgInfo = vchAssistRecordInfo.getAssGrp();
                                SelectorItemCollection selector = new SelectorItemCollection();
                                selector.add(new SelectorItemInfo("*"));
                                selector.add(new SelectorItemInfo("asstAccount.id"));
                                hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgInfo.getId()), selector);
                                AsstAccountInfo asstAccountInfo = hgInfo.getAsstAccount();
                                AsstAccountInfo newPLAsstAccountInfo = entry.getAccount().getCAA();
                                if (newPLAsstAccountInfo != null) {
                                    if (asstAccountInfo.getId().toString().equals(newPLAsstAccountInfo.getId().toString())) {
                                        rec.setAssGrp(hgInfo);
                                    } else {
                                        SelectorItemCollection asstSelector = new SelectorItemCollection();
                                        asstSelector.add(new SelectorItemInfo("asstActGpDt.id"));
                                        asstSelector.add(new SelectorItemInfo("asstActGpDt.asstActType.id"));
                                        asstSelector.add(new SelectorItemInfo("asstActGpDt.asstActType.asstHGAttribute"));
                                        newPLAsstAccountInfo = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(newPLAsstAccountInfo.getId()), asstSelector);
                                        types = new AsstActTypeCollection();
                                        AssistantHGInfo newPLhg = new AssistantHGInfo();
                                        int asstActTypeSize = newPLAsstAccountInfo.getAsstActGpDt().size();
                                        for (int k = 0; k < asstActTypeSize; ++k) {
                                            AsstActTypeInfo asstActInfo = newPLAsstAccountInfo.getAsstActGpDt().get(k).getAsstActType();
                                            types.add(asstActInfo);
                                            newPLhg.put(asstActInfo.getAsstHGAttribute(), hgInfo.get(asstActInfo.getAsstHGAttribute()));
                                        }
                                        newPLhg = igCtrl.getAssistantHG(newPLhg, newPLAsstAccountInfo.getId().toString(), types);
                                        rec.setAssGrp(newPLhg);
                                    }
                                }
                                vchAssistCollection.add(rec);
                            }
                        }
                        LinkedHashMap<String, PcVoucherAssistRecordInfo> vchAssitMap = new LinkedHashMap<String, PcVoucherAssistRecordInfo>();
                        int size1 = vchAssistCollection.size();
                        for (int i = 0; i < size1; ++i) {
                            PcVoucherAssistRecordInfo vchAssistRecordInfo1 = (PcVoucherAssistRecordInfo)vchAssistCollection.get(i);
                            String assgrpId1 = vchAssistRecordInfo1.getAssGrp().getId().toString();
                            if (vchAssitMap.containsKey(assgrpId1)) {
                                PcVoucherAssistRecordInfo record = (PcVoucherAssistRecordInfo)vchAssitMap.get(assgrpId1);
                                record.setQuantity(record.getQuantity().add(vchAssistRecordInfo1.getQuantity()));
                                record.setOriginalAmount(record.getOriginalAmount().add(vchAssistRecordInfo1.getOriginalAmount()));
                                record.setLocalAmount(record.getLocalAmount().add(vchAssistRecordInfo1.getLocalAmount()));
                                record.setReportingAmount(record.getReportingAmount().add(vchAssistRecordInfo1.getReportingAmount()));
                                continue;
                            }
                            vchAssitMap.put(assgrpId1, vchAssistRecordInfo1);
                        }
                        for (Map.Entry vchAssitMapEntry : vchAssitMap.entrySet()) {
                            PcVoucherAssistRecordInfo vchAssistRecordInfo = (PcVoucherAssistRecordInfo)vchAssitMapEntry.getValue();
                            if (vchAssistRecordInfo.getLocalAmount() == null || vchAssistRecordInfo.getLocalAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                            entry.getAssistRecords().add((PcVoucherAssistRecordInfo)vchAssitMapEntry.getValue());
                        }
                    }
                }
            }
            vch.getEntries().add(entry);
        }
    }

    private Map getPLAsstActInfoList(AssistantHGInfo hgInfo, AsstAccountInfo asstAccountInfo, List asstActInfoList, Map idmap) {
        AsstActGroupDetailCollection groupDetailCollection = asstAccountInfo.getAsstActGpDt();
        int size1 = groupDetailCollection.size();
        for (int i = 0; i < size1; ++i) {
            AsstActTypeInfo typeInfo = groupDetailCollection.get(i).getAsstActType();
            int size2 = asstActInfoList.size();
            for (int j = 0; j < size2; ++j) {
                AsstActTypeInfo plTypeInfo = (AsstActTypeInfo)asstActInfoList.get(j);
                if (!plTypeInfo.getId().toString().equals(typeInfo.getId().toString())) continue;
                DataBaseInfo dataBaseInfo = (DataBaseInfo)hgInfo.get(plTypeInfo.getAsstHGAttribute());
                idmap.put(plTypeInfo.getAsstHGAttribute(), dataBaseInfo.getId().toString());
            }
        }
        return idmap;
    }

    private void checkAccountAndCurrency(Context ctx, AccountViewInfo acc, CurrencyInfo cur) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        acc = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acc.getId().toString()), selector);
        String accountName = null;
        String curName = null;
        accountName = acc.getName();
        if (acc.getAccountingcurrency().getValue() == 0) {
            CurrencyInfo curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cur.getId().toString()));
            curName = curInfo.getName();
            if (!this.isState) {
                throw new PcaPeriodEndException(PcaPeriodEndException.NO_FORCURRENCY, new Object[]{curName, accountName, curName});
            }
        }
        if (acc.getAccountingcurrency().getValue() == 1) {
            CurrencyInfo curInfo;
            AccountCurrencyCollection cc = acc.getAccountCurrency();
            Iterator iter = cc.iterator();
            boolean hasON = false;
            while (iter.hasNext()) {
                curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(cur.getId().toString())) continue;
                hasON = true;
                break;
            }
            if (!hasON) {
                curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cur.getId().toString()));
                curName = curInfo.getName();
                throw new PcaPeriodEndException(PcaPeriodEndException.NO_FORCURRENCY, new Object[]{curName, accountName, curName});
            }
        }
    }

    protected BigDecimal getEx(Connection conn, HashMap cache, String curId, String tcId, String tableId, java.sql.Date now) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        if (curId.equals(tcId)) {
            cache.put(curId, PcaUtils.one);
            return PcaUtils.one;
        }
        if (tableId == null) {
            cache.put(curId, PcaUtils.one);
            return PcaUtils.one;
        }
        BigDecimal result = (BigDecimal)cache.get(curId);
        if (result != null) {
            return result;
        }
        String sql = "select r.FConvertRate,a.fprecision from T_BD_ExchangeRate r\t\t \t\u3000inner join T_BD_ExchangeAux a\u3000on r.FExchangeAuxID = a.FID\t\t\t\t\u3000inner join T_BD_ExchangeTable t on a.FExchangeTableID = t.FID \t\t \t\twhere a.FSourceCurrencyID=? and a.FTargetCurrencyID=?\t\t\t\t\t\t and t.FID=? and r.FAvailTime<=? \torder by r.FAvailTime desc\t\t";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)curId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)2, (String)tcId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)3, (String)tableId);
            stmt.setDate(4, now);
            rs = stmt.executeQuery();
            result = PcaUtils.zero;
            if (rs.next()) {
                result = rs.getBigDecimal(1);
                cache.put(curId, result);
            }
            bigDecimal = result;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return bigDecimal;
    }

    private void addPLEntry(PcVoucherEntryInfo preEntry, HashMap hmPLAccount, HashMap hmSum) throws EASBizException {
        if (preEntry != null && hmSum != null) {
            boolean hasAsst;
            boolean allZero = PcaUtils.isAllZeroOrNull(new BigDecimal[]{preEntry.getQuantity(), preEntry.getOriginalAmount(), preEntry.getLocalAmount(), preEntry.getReportingAmount()});
            boolean bl = hasAsst = preEntry.getAssistRecords().size() > 0;
            if (!allZero || hasAsst) {
                preEntry.getBill().getEntries().add(preEntry);
                if (allZero) {
                    AccountViewInfo plAcct = (AccountViewInfo)hmPLAccount.get(preEntry.getAccount().getId().toString());
                    if (plAcct == null) {
                        return;
                    }
                    CurrencyInfo cur1 = new CurrencyInfo();
                    cur1.setId(BOSUuid.read((String)this.curId2));
                    PcAccountCurrencyPair pair = this.isState ? new PcAccountCurrencyPair(plAcct, cur1) : new PcAccountCurrencyPair(plAcct, preEntry.getCurrency());
                    BigDecimal[] s = (BigDecimal[])hmSum.get(pair);
                    if (s == null) {
                        hmSum.put(pair, new BigDecimal[]{PcaUtils.zero, PcaUtils.zero, PcaUtils.zero});
                    }
                }
            }
        }
    }

    private boolean getPL(BigDecimal[] bg) {
        for (int i = 0; i < bg.length; ++i) {
            if (bg[i].signum() < 0) {
                return true;
            }
            if (bg[i].signum() <= 0) continue;
            return false;
        }
        return true;
    }

    private PcVoucherInfo getNewPLVoucher(Context ctx, PcTransPlProgramFilter filter) throws BOSException, EASBizException {
        PcVoucherInfo vch = this.getNewVoucher(ctx, filter);
        vch.setSourceType(SourceType.PROFIT_AND_LOSS);
        return vch;
    }

    private PcVoucherInfo getNewVoucher(Context ctx, PcTransPlProgramFilter filter) throws BOSException, EASBizException {
        PcVoucherInfo vch = new PcVoucherInfo();
        vch.setDescription(filter.getFilterVchDesc());
        vch.setBizDate(filter.getCurServerTime());
        vch.setBookedDate(filter.getCurServerTime());
        vch.setCompany(filter.getCompanyOrgUnit());
        vch.setProfitCenter(filter.getProfitCenter());
        if (filter.getVoucherDateType() == 1) {
            if (filter.getCurServerTime().compareTo(filter.getTransCompanyPeriod().getEndDate()) > 0) {
                vch.setBizDate((Date)filter.getTransCompanyPeriod().getEndDate());
                vch.setBookedDate((Date)filter.getTransCompanyPeriod().getEndDate());
            }
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)vch.getBookedDate(), (CompanyOrgUnitInfo)filter.getCompanyOrgUnit());
            vch.setPeriod(period);
        } else {
            vch.setPeriod(filter.getTransCompanyPeriod());
        }
        vch.setCreator(filter.getCurUser());
        vch.setHandler(filter.getCurUser());
        vch.setAttachments(0);
        vch.setSourceSys(SystemEnum.PROFIT_CENTER_ACCOUNTING);
        VoucherTypeInfo transVoucherType = filter.getTransVoucherType();
        vch.setVoucherType(transVoucherType);
        return vch;
    }

    private String getVchTransPnLSql(PcTransPlProgramFilter filter, boolean isOrderBy) {
        boolean useReport = filter.isParamUseReportCurrency();
        boolean isByAsstTrans = filter.isTransMethodByAsst();
        boolean isQtyByAsst = filter.isQtyByAsst();
        String accountFilterSql = this.getAccountFilterSql(filter);
        BigDecimal minQtyByPrecision = filter.getMinQtyByPrecision();
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        Map baseNumberFrom = filter.getBaseNumberFrom();
        Map baseNumberTo = filter.getBaseNumberTo();
        List asstActInfoList = filter.getAsstActInfoList();
        StringBuffer sql = new StringBuffer();
        if (!isByAsstTrans) {
            sql.append(" select vbal.fnumber,  vbal.FAccountDC, vbal.FAccountID, vbal.FAssistGrpID,  vbal.FCurrencyID   ,  vbal.FIsQty   ,  vbal.FDefaultUnitID  ,  sum(vbal.FEndBalanceFor) FEndBalanceFor,  sum(vbal.FEndBalanceLocal)  FEndBalanceLocal,  sum(vbal.FEndBalanceRpt) FEndBalanceRpt,  sum(vbal.FEndQty)   FEndQty                                                      \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID, acct.FIsQty, mugrp.FDefaultUnitID,                                     \r\n");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty\t\t\t\t\r\n");
            sql.append(" from " + PCABalanceUtils.getAccountBalanceTable(5) + " bal                                                               \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                                \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                                    \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\t\t\t\t\t\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" and acct.FCAA is  null)\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" union        all                                                                               \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + " bal                                                                \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand (acct.FCAA is not null)\t                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                          \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union             all                                                                          \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                sql.append(" from " + PCABalanceUtils.getAssistMeasureBalanceTable(5) + "  bal                                                           \r\n");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                                        \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and  asst.fisqty=1)                                                 \r\n");
                sql.append(" and acct.fnumber  in (");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber           \t\r\n");
                sql.append(" from " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal                                                                \r\n");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                             \t            \r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\tor ").append(strQtyBalNotZero).append("\t \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("                                                                                            \r\n");
                sql.append(")");
                sql.append("                                                                                            \r\n");
            }
            sql.append(" )vbal       group by vbal.fnumber,vbal.FAccountDC,vbal.FAccountID,vbal.FAssistGrpID,vbal.FCurrencyID,vbal.FIsQty,vbal.FDefaultUnitID                                                                                \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber,vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        } else if (!(!isByAsstTrans || baseNumberFrom != null && baseNumberFrom.size() != 0 || baseNumberTo != null && baseNumberTo.size() != 0)) {
            AsstActTypeInfo asstActInfo;
            int i;
            int size;
            sql.append(" select vbal.fnumber,  vbal.FAccountDC,  vbal.FAccountID, vbal.FAssistGrpID,  vbal.FCurrencyID   ,  vbal.FIsQty   ,  vbal.FDefaultUnitID  ,  sum(vbal.FEndBalanceFor) FEndBalanceFor,  sum(vbal.FEndBalanceLocal)  FEndBalanceLocal,  sum(vbal.FEndBalanceRpt) FEndBalanceRpt,  sum(vbal.FEndQty)     FEndQty                                                               \t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID,  sum(acct.FIsQty) as FIsQty , mugrp.FDefaultUnitID,                                     \r\n");
            sql.append("  sum(bal.FEndBalanceFor) FEndBalanceFor, sum(bal.FEndBalanceLocal) FEndBalanceLocal, sum(bal.FEndBalanceRpt) FEndBalanceRpt, sum(bal.FEndQty   ) FEndQty \t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , ' ' as " + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal                                                               \r\n");
            if (isByAsstTrans) {
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            }
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                                \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                                       \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" )\t\t\t\t\t\t\t\t\t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                }
            }
            sql.append("                                                                                            \r\n");
            sql.append(" group by acct.fnumber,acct.FDC, bal.FAccountID, bal.FCurrencyID,mugrp.FDefaultUnitID ");
            sql.append(" union        all                                                                               \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  ,hg." + asstActInfo.getMappingFieldName());
                }
            }
            sql.append(" from " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal                                                                \r\n");
            if (isByAsstTrans) {
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            }
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand (acct.FCAA is not null)\t                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                             \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            if (isByAsstTrans) {
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                }
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union            all                                                                           \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                if (isByAsstTrans) {
                    size = asstActInfoList.size();
                    for (i = 0; i < size; ++i) {
                        asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                        sql.append("  ,hg." + asstActInfo.getMappingFieldName());
                    }
                }
                sql.append(" from " + PCABalanceUtils.getAssistMeasureBalanceTable(5) + "  bal                                                           \r\n");
                if (isByAsstTrans) {
                    sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                }
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                            \t            \r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t            \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and asst.fisqty=1)                                                 \r\n");
                if (isByAsstTrans) {
                    size = asstActInfoList.size();
                    for (i = 0; i < size; ++i) {
                        asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                        sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                    }
                }
                sql.append(" and acct.fnumber  in (");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + " bal                                                                \r\n");
                if (isByAsstTrans) {
                    sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                }
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                                          \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                           \t                \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                if (isByAsstTrans) {
                    size = asstActInfoList.size();
                    for (i = 0; i < size; ++i) {
                        asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                        sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
                    }
                }
                sql.append(" )                                                                                  \r\n");
            }
            sql.append(" )vbal      group by vbal.fnumber,vbal.FAccountDC,vbal.FAccountID,vbal.FAssistGrpID,vbal.FCurrencyID,vbal.FIsQty,vbal.FDefaultUnitID                                                                         \r\n");
            sql.append("                                                                                            \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber, vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        } else {
            AsstActTypeInfo asstActInfo;
            int i;
            sql.append(" select vbal.fnumber,  vbal.FAccountDC, vbal.FAccountID, vbal.FAssistGrpID,  vbal.FCurrencyID   ,  vbal.FIsQty   ,  vbal.FDefaultUnitID  ,  sum(vbal.FEndBalanceFor) FEndBalanceFor,  sum(vbal.FEndBalanceLocal)  FEndBalanceLocal,  sum(vbal.FEndBalanceRpt) FEndBalanceRpt,  sum(vbal.FEndQty)   FEndQty                                                      \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \t' ' as FAssistGrpID, bal.FCurrencyID, sum(acct.FIsQty) as FIsQty , mugrp.FDefaultUnitID,                   \r\n");
            sql.append(" sum(bal.FEndBalanceFor) FEndBalanceFor, sum(bal.FEndBalanceLocal) FEndBalanceLocal, sum(bal.FEndBalanceRpt) FEndBalanceRpt, sum(bal.FEndQty   ) FEndQty         \t\r\n");
            int size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append("  ,' ' as " + asstActInfo.getMappingFieldName());
            }
            sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + " bal                                                                \r\n");
            sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand (acct.FCAA is not null)                                             \t            \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                                           \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                            \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0\t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
            sql.append(" group by acct.fnumber,acct.FDC, bal.FAccountID, bal.FCurrencyID,mugrp.FDefaultUnitID ");
            sql.append(" union      all                                                                                \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append("  , hg." + asstActInfo.getMappingFieldName());
            }
            sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + " bal                                                                \r\n");
            sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
            sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
            if (isQtyByAsst) {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
            } else {
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            }
            size = asstActInfoList.size();
            for (i = 0; i < size; ++i) {
                asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
            }
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand (acct.FCAA is not null)\t                                              \t\r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                             \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                    \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\r\n");
            if (useReport) {
                sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
            }
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and (acct.fisqty<>1 or asst.fisqty<>1)                                                 \r\n");
            }
            this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
            if (isQtyByAsst) {
                sql.append(" union        all                                                                              \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber,acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                   \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndBalanceLocal, bal.FEndBalanceRpt, bal.FEndQty           \t\r\n");
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append("  , hg." + asstActInfo.getMappingFieldName());
                }
                sql.append(" from " + PCABalanceUtils.getAssistMeasureBalanceTable(5) + "   bal                                                           \r\n");
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                              \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                              \t\r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and (acct.fisqty=1 and asst.fisqty=1)                                                 \r\n");
                this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
                sql.append(" and acct.fnumber  in (");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.fnumber \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" from " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal                                                                \r\n");
                sql.append(" inner join t_bd_assistanthg hg on hg.fid=bal.fassistgrpid ");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID                           \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID                  \r\n");
                sql.append(" \t\tand actype.FProperty in (4 ,8)\t\t\t\t\t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA           \r\n");
                if (isQtyByAsst) {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID           \r\n");
                } else {
                    sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                }
                size = asstActInfoList.size();
                for (i = 0; i < size; ++i) {
                    asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
                    sql.append(" \tleft join      ").append(asstActInfo.getRealtionDataObject()).append(" cus").append(i).append(" on cus").append(i).append(".fid = hg.").append(asstActInfo.getMappingFieldName());
                }
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                              \t\r\n");
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                           \t    \r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 \t\r\n");
                if (useReport) {
                    sql.append(" \t or bal.FEndBalanceRpt <> 0\t");
                }
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                this.appendAssActFilter(baseNumberFrom, baseNumberTo, asstActInfoList, sql);
                sql.append(")");
            }
            sql.append(" )vbal        group by vbal.fnumber,vbal.FAccountDC,vbal.FAccountID,vbal.FAssistGrpID,vbal.FCurrencyID,vbal.FIsQty,vbal.FDefaultUnitID                                                                               \r\n");
            if (isOrderBy) {
                sql.append(" order by vbal.FCurrencyID, vbal.fnumber,vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            }
        }
        return sql.toString();
    }

    private void appendAssActFilter(Map baseNumberFrom, Map baseNumberTo, List asstActInfoList, StringBuffer sql) {
        int size = asstActInfoList.size();
        for (int i = 0; i < size; ++i) {
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)asstActInfoList.get(i);
            String numStr = "cus" + i + (asstActInfo.isUseLongNumber() ? ".flongnumber" : ".fnumber");
            String fromNumber = (String)baseNumberFrom.get(asstActInfo.getAsstHGAttribute());
            String toNumber = (String)baseNumberTo.get(asstActInfo.getAsstHGAttribute());
            if (fromNumber != null && toNumber != null) {
                sql.append("  and (").append(numStr).append(" in ('").append(fromNumber).append("','").append(toNumber).append("')").append("  or (").append(numStr).append(">'").append(fromNumber).append("'").append("  and ").append(numStr).append("<'").append(toNumber).append("'))");
            } else if (fromNumber != null) {
                sql.append("  and ").append(numStr).append(">='").append(fromNumber).append("'");
            } else if (toNumber != null) {
                sql.append("  and ").append(numStr).append("<='").append(toNumber).append("'");
            }
            sql.append(" and hg." + asstActInfo.getMappingFieldName() + " is not null ");
        }
    }

    private String getAccountFilterSql(PcTransPlProgramFilter filter) {
        String accountFilterSql = null;
        if (!filter.isAllAccount() && filter.getHmPLAccount() != null && filter.getHmPLAccount().size() > 0) {
            StringBuffer acctFilterSb = new StringBuffer();
            Set accountIdSet = filter.getHmPLAccount().keySet();
            Iterator it = accountIdSet.iterator();
            int i = 0;
            acctFilterSb.append("(");
            while (it.hasNext()) {
                String accountId = (String)it.next();
                if (i == 0) {
                    acctFilterSb.append("'").append(accountId).append("'");
                } else {
                    acctFilterSb.append(",'").append(accountId).append("'");
                }
                ++i;
            }
            acctFilterSb.append(")");
            accountFilterSql = acctFilterSb.toString();
        }
        return accountFilterSql;
    }

    protected PcTransPlProgramFilter genVchTransPnL0(Context ctx, PcTransPlProgramFilter filter) throws BOSException, EASBizException {
        String transProfitCenterID = filter.getProfitCenter().getId().toString();
        String transRelatedCompanyID = filter.getCompanyOrgUnit().getId().toString();
        String curUserID = filter.getCurUser().getId().toString();
        PeriodInfo transPeriod = filter.getTransCompanyPeriod();
        String transPeriodID = transPeriod.getId().toString();
        UserInfo curUser = new UserInfo();
        curUser.setId(BOSUuid.read((String)curUserID));
        filter.setCurUser(curUser);
        filter.setCurServerTime(filter.getFilterVchDate());
        boolean isQtyByAsst = filter.isQtyByAsst();
        BigDecimal minQtyByPrecision = filter.getMinQtyByPrecision();
        String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
        HashMap hmAllParam = filter.getHmGLParam();
        int priceScale = new Integer(hmAllParam.get("GL_003").toString());
        int vchGenPLSeparate = filter.getFilterVchPLType();
        int vchGenProfitOrLoss = filter.getFilterVchProfitLoss();
        HashMap hmPLAccount = filter.getHmPLAccount();
        String vchDesc = filter.getFilterVchDesc();
        boolean transByDC = filter.isFilterTransPLByBalOppDC();
        String accountFilterSql = this.getAccountFilterSql(filter);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int vchCount = 0;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" select vbal.FAccountDC,vbal.FAccountID,vbal.FAssistGrpID,vbal.FCurrencyID,vbal.FIsQty,vbal.FMeasureUnitID,vbal.FDefaultUnitID,sum(vbal.FEndBalanceFor),sum(vbal.FEndQty)                                                             \t\t\t\r\n");
            sql.append(" from                                                                                       \r\n");
            sql.append(" (                                                                                          \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append("\t' ' as FAssistGrpID,       \t\t\t\t\t\r\n");
            sql.append(" \tbal.FCurrencyID, acct.FIsQty, mugrp.FDefaultUnitID,                                     \r\n");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" from  " + PCABalanceUtils.getAccountBalanceTable(5) + "  bal                                                               \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty in (4 ,8)   \r\n");
            sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand acct.FIsLeaf = 1\t                                                      \r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                              \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" or acct.FCAA is not null)\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" union                                                                                      \r\n");
            sql.append("                                                                                            \r\n");
            sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
            sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
            sql.append("    mugrp.FDefaultUnitID,");
            sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + "  bal                                                                \r\n");
            sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID \r\n");
            sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty in (4 ,8)\t\t\r\n");
            sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
            sql.append(" where                                                                                      \r\n");
            sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
            sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
            sql.append(" \tand (acct.FCAA is not null)\t                                              \t\r\n");
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append(" \tand acct.FIsLeaf = 1\t\t                                          \t\r\n");
            if (filter.isAdjustTrans()) {
                sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
            }
            if (accountFilterSql != null) {
                sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
            }
            sql.append("    and acct.fbw = 0                                                             \r\n");
            sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            if (isQtyByAsst) {
                sql.append("    and acct.fisqty<>1                                                  \r\n");
            }
            sql.append("                                                                                            \r\n");
            if (isQtyByAsst) {
                sql.append(" union                                                                                      \r\n");
                sql.append("                                                                                            \r\n");
                sql.append(" select acct.FDC as FAccountDC, bal.FAccountID, \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" \tbal.FAssistGrpID, bal.FCurrencyID, acct.FIsQty,                    \r\n");
                sql.append(" \tbal.FMeasureUnitID as FDefaultUnitID, ");
                sql.append(" \tbal.FEndBalanceFor, bal.FEndQty               \t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(" from " + PCABalanceUtils.getAssistMeasureBalanceTable(5) + "   bal                                                           \r\n");
                sql.append(" \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID \r\n");
                sql.append(" \tinner join t_BD_AccountType actype on actype.FID = acct.FAccountTypeID and actype.FProperty in (4 ,8)\t   \r\n");
                sql.append(" \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = acct.FMeasureUnitGroupID           \r\n");
                sql.append(" where                                                                                      \r\n");
                sql.append(" \tbal.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand bal.FPeriod = ?                                                                   \r\n");
                sql.append(" \tand (acct.FCAA is not null)\t                                              \t\r\n");
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand acct.FIsLeaf = 1\t\t                                             \t\r\n");
                if (filter.isAdjustTrans()) {
                    sql.append(" and acct.FAccountTableID = '").append(filter.getCompanyOrgUnit().getAccountTable().getId().toString()).append("' \r\n");
                }
                if (accountFilterSql != null) {
                    sql.append(" and acct.fid in").append(accountFilterSql).append(" \r\n");
                }
                sql.append(" \tand (bal.FEndBalanceFor <> 0 \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(" \t\t\tor ").append(strQtyBalNotZero).append(" \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("    and acct.fisqty=1                                                  \r\n");
                sql.append(" and exists (");
                sql.append(" select 1 \t\t\t\t\t\t\t\t\t        \r\n");
                sql.append(" from  " + PCABalanceUtils.getAssistBalanceTable(5) + " b                                                                   \r\n");
                sql.append(" where                                                                                       \r\n");
                sql.append("    bal.faccountid = b.FAccountID and bal.FCurrencyID = b.FCurrencyID and bal.FAssistGrpID = b.FAssistGrpID \r\n");
                sql.append(" \tand b.FProfitCenterID = ?                                                                      \r\n");
                sql.append(" \tand b.FPeriod = ?                                                                       \r\n");
                sql.append(" \tand (b.FEndBalanceFor <> 0 \tor abs(b.FEndQty)>=").append(minQtyByPrecision).append(" \t  )\r\n");
                sql.append(" \t                                                           \r\n");
                sql.append(")");
                sql.append("                                                                                            \r\n");
            }
            sql.append(" )vbal     group by vbal.fnumber,vbal.FAccountDC,vbal.FAccountID,vbal.FAssistGrpID,vbal.FCurrencyID,vbal.FIsQty,vbal.FMeasureUnitID,vbal.FDefaultUnitID                                                                              \r\n");
            sql.append(" order by vbal.FCurrencyID, vbal.FAccountID, vbal.FAssistGrpID                             \t\r\n");
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transProfitCenterID);
            stmt.setInt(index++, transPeriod.getNumber());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transProfitCenterID);
            stmt.setInt(index++, transPeriod.getNumber());
            if (isQtyByAsst) {
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transProfitCenterID);
                stmt.setInt(index++, transPeriod.getNumber());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)transProfitCenterID);
                stmt.setInt(index++, transPeriod.getNumber());
            }
            rs = stmt.executeQuery();
            IPcVoucher vchCtrl = PcVoucherFactory.getLocalInstance((Context)ctx);
            PcVoucherInfo preVch1 = this.getNewPLVoucher(ctx, filter);
            PcVoucherInfo preVch2 = this.getNewPLVoucher(ctx, filter);
            HashMap<AccountViewInfo, BigDecimal> hmPLAcctSum1 = new HashMap<AccountViewInfo, BigDecimal>();
            HashMap hmPLAcctSum2 = new HashMap();
            PcVoucherEntryInfo preEntry = null;
            String preCurId = null;
            CurrencyInfo preCur = null;
            HashMap<AccountViewInfo, BigDecimal> preSum = null;
            HashMap hmUnSelectedAccount = filter.getHmUnSelectedAccount();
            while (rs.next()) {
                boolean newEntry;
                int acctDC = rs.getInt("FAccountDC");
                String acctId = rs.getString("FAccountID");
                String curId = rs.getString("FCurrencyID");
                String grpId = rs.getString("FAssistGrpID");
                BigDecimal sum = rs.getBigDecimal("FEndBalanceFor");
                BigDecimal qty = rs.getBigDecimal("FEndQty");
                boolean isQty = true;
                if (hmUnSelectedAccount.containsKey(acctId)) continue;
                if (!curId.equals(preCurId)) {
                    this.addPLEntry(preEntry, hmPLAccount, preSum);
                    if (vchGenProfitOrLoss == 1) {
                        hmPLAcctSum2.clear();
                        preVch2.getEntries().clear();
                    } else if (vchGenProfitOrLoss == 2) {
                        hmPLAcctSum1.clear();
                        preVch1.getEntries().clear();
                    }
                    if (vchGenPLSeparate == 1) {
                        vchCount += this.genPLEntry(hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl);
                        vchCount += this.genPLEntry(hmPLAcctSum2, preVch2, vchDesc, preCur, vchCtrl);
                    } else {
                        preVch1.getEntries().addCollection(preVch2.getEntries());
                        this.combineSum(hmPLAcctSum1, hmPLAcctSum2);
                        vchCount += this.genPLEntry(hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl);
                    }
                    preVch1 = this.getNewPLVoucher(ctx, filter);
                    preVch2 = this.getNewPLVoucher(ctx, filter);
                    hmPLAcctSum1.clear();
                    hmPLAcctSum2.clear();
                    preEntry = null;
                    preCurId = curId;
                    CurrencyInfo cur = new CurrencyInfo();
                    cur.setId(BOSUuid.read((String)curId));
                    preVch1.setCurrency(cur);
                    preVch2.setCurrency(cur);
                    preCur = cur;
                    preSum = null;
                }
                boolean bl = newEntry = " ".equals(grpId) || "".equals(grpId);
                if (newEntry) {
                    HashMap<AccountViewInfo, BigDecimal> hmSum;
                    this.addPLEntry(preEntry, hmPLAccount, preSum);
                    boolean pl = this.getPL(new BigDecimal[]{sum, qty});
                    PcVoucherInfo vch = pl ? preVch1 : preVch2;
                    HashMap<Object, BigDecimal> hashMap = hmSum = pl ? hmPLAcctSum1 : hmPLAcctSum2;
                    if (!PcaUtils.isAllZeroOrNull(new BigDecimal[]{sum, qty})) {
                        AccountViewInfo plAcct = (AccountViewInfo)hmPLAccount.get(acctId);
                        if (plAcct == null) continue;
                        BigDecimal s = (BigDecimal)hmSum.get(plAcct);
                        if (s == null) {
                            hmSum.put(plAcct, sum);
                        } else {
                            hmSum.put(plAcct, s.add(sum));
                        }
                    }
                    preEntry = new PcVoucherEntryInfo();
                    preEntry.setOprStatus(1);
                    preEntry.setBill(vch);
                    preEntry.setDescription(vchDesc);
                    AccountViewInfo acct = new AccountViewInfo();
                    acct.setId(BOSUuid.read((String)acctId));
                    preEntry.setAccount(acct);
                    preEntry.setCurrency(preCur);
                    EntryDC dc = EntryDC.CREDIT;
                    BigDecimal es = sum;
                    BigDecimal eq = qty;
                    if (transByDC && vch == preVch1 || !transByDC && acctDC == -1) {
                        es = sum.negate();
                        eq = qty.negate();
                        dc = EntryDC.DEBIT;
                    }
                    preEntry.setEntryDC(dc);
                    preEntry.setOriginalAmount(es);
                    if (isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                        MeasureUnitInfo mu = new MeasureUnitInfo();
                        mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                        preEntry.setMeasureUnit(mu);
                        preEntry.setQuantity(eq);
                        preEntry.setStandardQuantity(eq);
                        if (!PcaUtils.zero.equals(eq)) {
                            preEntry.setPrice(sum.divide(eq, priceScale, 4).abs());
                        } else {
                            preEntry.setPrice(PcaUtils.zero);
                        }
                    }
                    preSum = hmSum;
                    continue;
                }
                PcVoucherAssistRecordInfo rec = new PcVoucherAssistRecordInfo();
                rec.setOprStatus(1);
                if (preEntry != null) {
                    rec.setBizDate(preEntry.getBill().getBizDate());
                    rec.setEndDate(preEntry.getBill().getBizDate());
                }
                rec.setDescription(vchDesc);
                AssistantHGInfo hg = new AssistantHGInfo();
                hg.setId(BOSUuid.read((String)grpId));
                rec.setAssGrp(hg);
                BigDecimal as = sum;
                BigDecimal aq = qty;
                if (preEntry != null && EntryDC.DEBIT.equals((Object)preEntry.getEntryDC())) {
                    as = sum.negate();
                    aq = qty.negate();
                }
                rec.setOriginalAmount(as);
                if (isQty) {
                    rec.setQuantity(aq);
                }
                if (isQtyByAsst && isQty && rs.getString("FDefaultUnitID") != null && !rs.getString("FDefaultUnitID").equals("00000000-0000-0000-0000-0000000000005B825C57")) {
                    MeasureUnitInfo mu = new MeasureUnitInfo();
                    mu.setId(BOSUuid.read((String)rs.getString("FDefaultUnitID")));
                    rec.setMeasureUnit(mu);
                }
                if (preEntry == null) continue;
                preEntry.getAssistRecords().add(rec);
            }
            this.addPLEntry(preEntry, hmPLAccount, preSum);
            if (vchGenProfitOrLoss == 1) {
                hmPLAcctSum2.clear();
                preVch2.getEntries().clear();
            } else if (vchGenProfitOrLoss == 2) {
                hmPLAcctSum1.clear();
                preVch1.getEntries().clear();
            }
            if (vchGenPLSeparate == 1) {
                vchCount += this.genPLEntry(hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl);
                vchCount += this.genPLEntry(hmPLAcctSum2, preVch2, vchDesc, preCur, vchCtrl);
            } else {
                preVch1.getEntries().addCollection(preVch2.getEntries());
                this.combineSum(hmPLAcctSum1, hmPLAcctSum2);
                vchCount += this.genPLEntry(hmPLAcctSum1, preVch1, vchDesc, preCur, vchCtrl);
            }
            if (vchCount == 0) {
                throw new PcaPeriodEndException(PcaPeriodEndException.TRANSPL_NO_PLBAL);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        filter.setReturnVchCount(vchCount);
        filter.setReturnVch1(null);
        filter.setReturnVch2(null);
        return filter;
    }

    private void combineSum(HashMap hmPLAcctSum1, HashMap hmPLAcctSum2) {
        if (hmPLAcctSum2.size() == 0) {
            return;
        }
        if (hmPLAcctSum1.size() == 0) {
            hmPLAcctSum1.putAll(hmPLAcctSum2);
            return;
        }
        for (Map.Entry e : hmPLAcctSum2.entrySet()) {
            BigDecimal s2 = (BigDecimal)e.getValue();
            BigDecimal s1 = (BigDecimal)hmPLAcctSum1.get(e.getKey());
            if (s1 != null) {
                hmPLAcctSum1.put(e.getKey(), s1.add(s2));
                continue;
            }
            hmPLAcctSum1.put(e.getKey(), s2);
        }
    }

    private int genPLEntry(HashMap hmPLAcctSum, PcVoucherInfo vch, String vchDesc, CurrencyInfo cur, IPcVoucher vchCtrl) throws BOSException, EASBizException {
        for (Map.Entry e : hmPLAcctSum.entrySet()) {
            AccountViewInfo plAcct = (AccountViewInfo)e.getKey();
            BigDecimal sum = (BigDecimal)e.getValue();
            EntryDC dc = EntryDC.DEBIT;
            if (sum.signum() < 0) {
                sum = sum.negate();
                dc = EntryDC.CREDIT;
            }
            PcVoucherEntryInfo entry = new PcVoucherEntryInfo();
            entry.setOprStatus(1);
            entry.setDescription(vchDesc);
            entry.setAccount(plAcct);
            entry.setCurrency(cur);
            entry.setEntryDC(dc);
            entry.setOriginalAmount(sum);
            if (plAcct.isIsQty()) {
                entry.setMeasureUnit(plAcct.getMeasureUnitGroupID().getDefaultUnit());
                entry.setQuantity(PcaUtils.zero);
                entry.setPrice(PcaUtils.zero);
            }
            if (plAcct.getCAA() != null) {
                PcVoucherAssistRecordInfo rec = new PcVoucherAssistRecordInfo();
                rec.setOprStatus(1);
                rec.setDescription(vchDesc);
                rec.setQuantity(entry.getQuantity());
                rec.setOriginalAmount(entry.getOriginalAmount());
                entry.getAssistRecords().add(rec);
            }
            vch.getEntries().add(entry);
        }
        if (vch.getEntries().size() > 0) {
            vchCtrl.save((CoreBaseInfo)vch);
            return 1;
        }
        return 0;
    }

    private void resetEntryMeasureUnit(Context ctx, PcVoucherInfo voucher, PcTransPlProgramFilter filter) throws EASBizException, BOSException, Exception {
        PcVoucherEntryCollection entries = voucher.getEntries();
        int priceScale = new Integer(filter.getHmGLParam().get("GL_003").toString());
        for (PcVoucherEntryInfo entry : entries) {
            MeasureUnitInfo measure;
            if (!entry.getAccount().isIsQty() || entry.getAssistRecords() != null && entry.getAssistRecords().size() != 0 || (measure = this.getAccountMeasure(ctx, entry.getAccount().getMeasureUnitGroupID())) == null || entry.getMeasureUnit() != null || measure.getId() == null) continue;
            entry.setMeasureUnit(measure);
            if (entry.getPrice() == null && entry.getQuantity() != null) {
                entry.setPrice(entry.getOriginalAmount().divide(entry.getQuantity(), priceScale, 4));
                continue;
            }
            entry.setPrice(PcaUtils.zero);
        }
    }

    private MeasureUnitInfo getAccountMeasure(Context ctx, MeasureUnitGroupInfo measureUnitGroup) throws EASBizException, BOSException, Exception {
        if (measureUnitGroup != null && measureUnitGroup.getId() != null) {
            return this.getAccountMU(ctx, measureUnitGroup.getId().toString());
        }
        return null;
    }

    protected MeasureUnitInfo getAccountMU(Context ctx, String acctDefautMUGroupId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        MeasureUnitInfo measureUnit = null;
        boolean hasDefault = false;
        String name = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append(" select measure2.* from  t_BD_MeasureUnitGroup mgroup   \r\n");
        sql.append(" inner join  t_BD_MeasureUnit measure2 on  measure2.FID=mgroup.fdefaultunitid     \r\n");
        sql.append(" where mgroup.fid=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{acctDefautMUGroupId});
        measureUnit = new MeasureUnitInfo();
        try {
            if (rs.next()) {
                measureUnit.setId(BOSUuid.read((String)rs.getString("FID")));
                measureUnit.setName(rs.getString(name));
                measureUnit.setCoefficient(rs.getBigDecimal("FCoefficient"));
                measureUnit.setIsBaseUnit(rs.getBoolean("FIsBaseUnit"));
                hasDefault = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!hasDefault) {
            sql = new StringBuffer();
            sql.append(" select measure2.* from  t_BD_MeasureUnitGroup mgroup   \r\n");
            sql.append(" inner join  t_BD_MeasureUnit measure2 on  measure2.FgroupID=mgroup.fid     \r\n");
            sql.append(" where mgroup.fid=? and measure2.fcoefficient=1");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{acctDefautMUGroupId});
            measureUnit = new MeasureUnitInfo();
            try {
                if (rs.next()) {
                    measureUnit.setId(BOSUuid.read((String)rs.getString("FID")));
                    measureUnit.setName(rs.getString(name));
                    measureUnit.setCoefficient(rs.getBigDecimal("FCoefficient"));
                    measureUnit.setIsBaseUnit(rs.getBoolean("FIsBaseUnit"));
                    hasDefault = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return measureUnit;
    }

    private boolean isInitClosed(Context ctx, String companyID) throws BOSException, EASBizException {
        IPcaFlag flagCtrl = PcaFlagFactory.getLocalInstance(ctx);
        return flagCtrl.getPcaInitClosed(companyID);
    }

    private UserInfo getCurrentUser(Context ctx) throws BOSException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        return user;
    }

    private String getStr(Context ctx, String id) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)id, (Locale)ctx.getLocale());
    }
}

