/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PcVoucherEntryAutoBalance {
    List autoLocalEntryList = new ArrayList();
    List autoReportEntryList = new ArrayList();
    private PcVoucherInfo voucherInfo;
    private GlParam sysParam;
    private CompanyOrgUnitInfo companyOrgUnitInfo;
    private Context ctx;

    public void autoBalanceVoucherEntry() throws BOSException, EASBizException {
        this.initCompanyOrgUnitInfo();
        this.setVoucherEntryPrecision();
        if (this.getAutoBalance()) {
            this.befroeAutoBalance();
            this.autoBalanceLoc();
            this.autoBalanceRpt();
        }
    }

    private void befroeAutoBalance() {
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            PcVoucherEntryInfo locEntryInfo = entryCollection.get(i);
            if (locEntryInfo.getAssistRecords() == null || locEntryInfo.getAssistRecords().size() == 0) continue;
            PcVoucherAssistRecordCollection assistRecordCollection = locEntryInfo.getAssistRecords();
            BigDecimal localTotal = new BigDecimal("0.00");
            BigDecimal rptTotal = new BigDecimal("0.00");
            for (int j = 0; j < assistRecordCollection.size(); ++j) {
                PcVoucherAssistRecordInfo assistRecord = assistRecordCollection.get(j);
                localTotal = localTotal.add(assistRecord.getLocalAmount() == null ? new BigDecimal("0.00") : assistRecord.getLocalAmount());
                rptTotal = rptTotal.add(assistRecord.getReportingAmount() == null ? new BigDecimal("0.00") : assistRecord.getReportingAmount());
            }
            locEntryInfo.setLocalAmount(localTotal);
            locEntryInfo.setReportingAmount(rptTotal);
        }
    }

    private void autoBalanceLoc() throws BOSException, EASBizException {
        boolean canSaveZero = this.getCanSaveAsZero();
        BigDecimal autoBalanceAmountRange = this.getAutoBalanceAmountRange();
        String BalanceEntry = this.getAutoBalanceLine();
        CurrencyInfo localCurrency = this.companyOrgUnitInfo.getBaseCurrency();
        BigDecimal result = this.getLocalAmountDebitSum().subtract(this.getLocalAmountCreditSum());
        if (result.abs().compareTo(new BigDecimal("0.00")) == 0) {
            return;
        }
        int compareResult = result.abs().compareTo(autoBalanceAmountRange);
        if (compareResult <= -1 || compareResult == 0) {
            PcVoucherAssistRecordCollection assistRecordCollection;
            int i;
            int size;
            PcVoucherEntryInfo entryInfo = new PcVoucherEntryInfo();
            entryInfo.setLocalAmount(new BigDecimal("0.00"));
            PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
            PcVoucherEntryInfo locEntryInfo = null;
            if ("4".equals(BalanceEntry)) {
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (this.isCurrencyEqual(locEntryInfo.getCurrency(), localCurrency) || locEntryInfo.getLocalAmount().compareTo(entryInfo.getLocalAmount()) <= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("3".equals(BalanceEntry)) {
                entryInfo.setLocalAmount(new BigDecimal("9999999999.9999"));
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (this.isCurrencyEqual(locEntryInfo.getCurrency(), localCurrency) || locEntryInfo.getLocalAmount().compareTo(entryInfo.getLocalAmount()) >= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("1".equals(BalanceEntry)) {
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (this.isCurrencyEqual(locEntryInfo.getCurrency(), localCurrency)) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            } else if ("2".equals(BalanceEntry)) {
                for (int size2 = entryCollection.size() - 1; size2 >= 0; --size2) {
                    locEntryInfo = entryCollection.get(size2);
                    if (this.isCurrencyEqual(locEntryInfo.getCurrency(), localCurrency)) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            }
            if ((assistRecordCollection = entryInfo.getAssistRecords()) == null || assistRecordCollection.size() == 0) {
                if (entryInfo.getAccount() != null) {
                    if (1 == entryInfo.getEntryDC().getValue()) {
                        entryInfo.setLocalAmount(entryInfo.getLocalAmount().subtract(result));
                        entryInfo.setOprStatus(2);
                    } else {
                        entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(result));
                        entryInfo.setOprStatus(2);
                    }
                }
                return;
            }
            PcVoucherAssistRecordInfo assistRecord = new PcVoucherAssistRecordInfo();
            assistRecord.setLocalAmount(new BigDecimal("0.00"));
            PcVoucherAssistRecordInfo locAssistRecord = null;
            if ("4".equals(BalanceEntry)) {
                int size3 = assistRecordCollection.size();
                for (int i2 = 0; i2 < size3; ++i2) {
                    locAssistRecord = assistRecordCollection.get(i2);
                    if (locAssistRecord.getLocalAmount().compareTo(assistRecord.getLocalAmount()) <= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("3".equals(BalanceEntry)) {
                assistRecord.setLocalAmount(new BigDecimal("9999999999.9999"));
                int size4 = assistRecordCollection.size();
                for (int i3 = 0; i3 < size4; ++i3) {
                    locAssistRecord = assistRecordCollection.get(i3);
                    if (locAssistRecord.getLocalAmount().compareTo(assistRecord.getLocalAmount()) >= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("1".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(0);
                } else {
                    int size5 = assistRecordCollection.size();
                    for (int i4 = 0; i4 < size5; ++i4) {
                        locAssistRecord = assistRecordCollection.get(i4);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            } else if ("2".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(assistRecordCollection.size() - 1);
                } else {
                    for (int size6 = assistRecordCollection.size() - 1; size6 >= 0; --size6) {
                        locAssistRecord = assistRecordCollection.get(size6);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            }
            if (1 == entryInfo.getEntryDC().getValue()) {
                assistRecord.setLocalAmount(assistRecord.getLocalAmount().subtract(result));
                assistRecord.setOprStatus(2);
            } else {
                assistRecord.setLocalAmount(assistRecord.getLocalAmount().add(result));
                assistRecord.setOprStatus(2);
            }
            if (!canSaveZero && assistRecord.getBizDate() == null) {
                this.autoLocalEntryList.add(entryInfo);
                this.autoBalanceLoc();
            } else {
                if (1 == entryInfo.getEntryDC().getValue()) {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().subtract(result));
                    entryInfo.setOprStatus(2);
                } else {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(result));
                    entryInfo.setOprStatus(2);
                }
                this.autoLocalEntryList = new ArrayList();
            }
        }
    }

    private void autoBalanceRpt() throws BOSException, EASBizException {
        boolean canSaveZero = this.getCanSaveAsZero();
        BigDecimal autoBalanceAmountRange = this.getAutoBalanceAmountRange();
        String BalanceEntry = this.getAutoBalanceLine();
        CurrencyInfo reportingCurrency = this.companyOrgUnitInfo.getReportCurrency();
        BigDecimal result = this.getReportAmountDebitSum().subtract(this.getReportAmountCreditSum());
        if (result.abs().compareTo(new BigDecimal("0.00")) == 0) {
            return;
        }
        int compareResult = result.abs().compareTo(autoBalanceAmountRange);
        if (compareResult <= -1 || compareResult == 0) {
            PcVoucherAssistRecordCollection assistRecordCollection;
            int i;
            int size;
            PcVoucherEntryInfo entryInfo = new PcVoucherEntryInfo();
            entryInfo.setReportingAmount(new BigDecimal("0.00"));
            PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
            PcVoucherEntryInfo locEntryInfo = null;
            if ("4".equals(BalanceEntry)) {
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (locEntryInfo.getReportingAmount().compareTo(entryInfo.getReportingAmount()) <= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("3".equals(BalanceEntry)) {
                entryInfo.setReportingAmount(new BigDecimal("9999999999.9999"));
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (locEntryInfo.getReportingAmount().compareTo(entryInfo.getReportingAmount()) >= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("1".equals(BalanceEntry)) {
                size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            } else if ("2".equals(BalanceEntry)) {
                for (int size2 = entryCollection.size() - 1; size2 >= 0; --size2) {
                    locEntryInfo = entryCollection.get(size2);
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            }
            if ((assistRecordCollection = entryInfo.getAssistRecords()) == null || assistRecordCollection.size() == 0) {
                if (entryInfo.getAccount() != null) {
                    if (1 == entryInfo.getEntryDC().getValue()) {
                        entryInfo.setReportingAmount(entryInfo.getReportingAmount().subtract(result));
                        entryInfo.setOprStatus(2);
                    } else {
                        entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(result));
                        entryInfo.setOprStatus(2);
                    }
                }
                return;
            }
            PcVoucherAssistRecordInfo assistRecord = new PcVoucherAssistRecordInfo();
            assistRecord.setReportingAmount(new BigDecimal("0.00"));
            PcVoucherAssistRecordInfo locAssistRecord = null;
            if ("4".equals(BalanceEntry)) {
                int size3 = assistRecordCollection.size();
                for (int i2 = 0; i2 < size3; ++i2) {
                    locAssistRecord = assistRecordCollection.get(i2);
                    if (locAssistRecord.getReportingAmount().compareTo(assistRecord.getReportingAmount()) <= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("3".equals(BalanceEntry)) {
                assistRecord.setReportingAmount(new BigDecimal("9999999999.9999"));
                int size4 = assistRecordCollection.size();
                for (int i3 = 0; i3 < size4; ++i3) {
                    locAssistRecord = assistRecordCollection.get(i3);
                    if (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("1".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(0);
                } else {
                    int size5 = assistRecordCollection.size();
                    for (int i4 = 0; i4 < size5; ++i4) {
                        locAssistRecord = assistRecordCollection.get(i4);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            } else if ("2".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(assistRecordCollection.size() - 1);
                } else {
                    for (int size6 = assistRecordCollection.size() - 1; size6 >= 0; --size6) {
                        locAssistRecord = assistRecordCollection.get(size6);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            }
            if (1 == entryInfo.getEntryDC().getValue()) {
                assistRecord.setReportingAmount(assistRecord.getReportingAmount().subtract(result));
                assistRecord.setOprStatus(2);
            } else {
                assistRecord.setReportingAmount(assistRecord.getReportingAmount().add(result));
                assistRecord.setOprStatus(2);
            }
            if (!canSaveZero && assistRecord.getBizDate() == null) {
                this.autoReportEntryList.add(entryInfo);
                this.autoBalanceRpt();
            } else {
                if (1 == entryInfo.getEntryDC().getValue()) {
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().subtract(result));
                    entryInfo.setOprStatus(2);
                } else {
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(result));
                    entryInfo.setOprStatus(2);
                }
                this.autoReportEntryList = new ArrayList();
            }
        }
    }

    private BigDecimal getLocalAmountDebitSum() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        PcVoucherEntryInfo entryInfo = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            if (1 != entryInfo.getEntryDC().getValue()) continue;
            bigDecimal = bigDecimal.add(entryInfo.getLocalAmount());
        }
        return bigDecimal;
    }

    private BigDecimal getLocalAmountCreditSum() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        PcVoucherEntryInfo entryInfo = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            if (0 != entryInfo.getEntryDC().getValue()) continue;
            bigDecimal = bigDecimal.add(entryInfo.getLocalAmount());
        }
        return bigDecimal;
    }

    private BigDecimal getReportAmountDebitSum() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        PcVoucherEntryInfo entryInfo = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            if (1 != entryInfo.getEntryDC().getValue()) continue;
            bigDecimal = bigDecimal.add(entryInfo.getReportingAmount());
        }
        return bigDecimal;
    }

    private BigDecimal getReportAmountCreditSum() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        PcVoucherEntryInfo entryInfo = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            if (0 != entryInfo.getEntryDC().getValue()) continue;
            bigDecimal = bigDecimal.add(entryInfo.getReportingAmount());
        }
        return bigDecimal;
    }

    private BigDecimal getAutoBalanceAmountRange() throws BOSException, EASBizException {
        return new BigDecimal(this.sysParam.getString("GL_100_1"));
    }

    private String getAutoBalanceLine() throws BOSException, EASBizException {
        return this.sysParam.getString("GL_100_2");
    }

    private boolean getAutoBalance() throws BOSException, EASBizException {
        return this.sysParam.getBoolean("GL_100");
    }

    private boolean getCanSaveAsZero() throws BOSException, EASBizException {
        return this.sysParam.getBoolean("GL_0301");
    }

    private boolean isCurrencyEqual(CurrencyInfo currencyInfo1, CurrencyInfo currencyInfo2) {
        if (currencyInfo1 == null || currencyInfo2 == null) {
            return false;
        }
        return currencyInfo1.getId().equals((Object)currencyInfo2.getId());
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setVoucherInfo(PcVoucherInfo voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public void setSysParam(GlParam sysParam) {
        this.sysParam = sysParam;
    }

    private void initCompanyOrgUnitInfo() throws BOSException, EASBizException {
        if (this.voucherInfo.getCompany().getBaseCurrency() != null && this.voucherInfo.getCompany().getBaseCurrency().get("precision") != null) {
            this.companyOrgUnitInfo = this.voucherInfo.getCompany();
        } else {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            ObjectUuidPK pk = new ObjectUuidPK(this.voucherInfo.getCompany().getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)this.getCompanySic());
            this.companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        }
    }

    private void setVoucherEntryPrecision() throws BOSException, EASBizException {
        int lcPre = 0;
        int rcurPre = 0;
        lcPre = this.companyOrgUnitInfo.getBaseCurrency().getPrecision();
        rcurPre = this.companyOrgUnitInfo.getReportCurrency() == null ? 4 : this.companyOrgUnitInfo.getReportCurrency().getPrecision();
        PcVoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            PcVoucherEntryInfo entryInfo = entryCollection.get(i);
            entryInfo.setLocalAmount(GlUtils.setScale((BigDecimal)entryInfo.getLocalAmount(), (int)lcPre));
            entryInfo.setReportingAmount(GlUtils.setScale((BigDecimal)entryInfo.getReportingAmount(), (int)rcurPre));
        }
    }

    private SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        return sic;
    }
}

