/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTReverseManager;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.IPcaGeneralFacade;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaGeneralFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractPcVoucherHelpFacadeControllerBean;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PcVoucherHelpFacadeControllerBean
extends AbstractPcVoucherHelpFacadeControllerBean {
    private static String RESOURCE = "com.kingdee.eas.ma.pca.PcaResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.PcVoucherHelpFacadeControllerBean");
    final int BATCHSIZE = 200;

    protected String[] _getBatchNumber(Context ctx, int count, int initial, IObjectValue type, IObjectValue orgUnit) throws BOSException, EASBizException {
        VoucherTypeCollection col;
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)orgUnit;
        PcVoucherInfo voucherInfo = new PcVoucherInfo();
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setProfitCenter(profitCenter);
        if (type == null && (col = PcaUtils.getVoucherTypeCollection(ctx, null, profitCenter.getId().toString())).size() > 0) {
            type = col.get(0);
        }
        PeriodInfo period = PcaUtils.getCurrentPeriod(ctx, profitCenter.getId().toString());
        voucherInfo.setVoucherType((VoucherTypeInfo)type);
        voucherInfo.setPeriod(period);
        voucherInfo.setCU(profitCenter.getCU());
        voucherInfo.setBookedDate(period.getBeginDate());
        CodingRuleInfo codingruleVo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus");
        if (codingruleVo != null) {
            return this._getBatchNumber(ctx, (IObjectValue)voucherInfo, (IObjectValue)codingruleVo, null, count, initial);
        }
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = metaLoader.getEntity(voucherInfo.getBOSType());
        throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{eo.getAlias()});
    }

    protected String[] getBatchNumber(Context ctx, int count, int initial, IObjectValue type, IObjectValue orgUnit, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherTypeCollection col;
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)orgUnit;
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setProfitCenter(profitCenter);
        if (type == null && (col = PcaUtils.getVoucherTypeCollection(ctx, null, profitCenter.getId().toString())).size() > 0) {
            type = col.get(0);
        }
        PeriodInfo period = PcaUtils.getCurrentPeriod(ctx, profitCenter.getId().toString());
        voucherInfo.setVoucherType((VoucherTypeInfo)type);
        voucherInfo.setPeriod(period);
        voucherInfo.setCU(profitCenter.getCU());
        CodingRuleInfo codingruleVo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus");
        if (codingruleVo != null) {
            return this._getBatchNumber(ctx, (IObjectValue)voucherInfo, (IObjectValue)codingruleVo, null, count, initial);
        }
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = metaLoader.getEntity(voucherInfo.getBOSType());
        throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{eo.getAlias()});
    }

    protected void _reSortNumber(Context ctx, String profitCenterIdStr) throws BOSException, EASBizException {
        if (profitCenterIdStr != null && !"".equals(profitCenterIdStr)) {
            String[] ids;
            for (String id : ids = profitCenterIdStr.split(",")) {
                this.resortNumberSingleOrg(ctx, id);
            }
        }
    }

    private void resortNumberSingleOrg(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        String cuid = profitCenter.getCU().getId().toString();
        PeriodInfo curPeriod = PcaUtils.getCurrentPeriod(ctx, profitCenterId);
        FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        VoucherTypeCollection vtCol = PcaUtils.getVoucherTypeCollection(ctx, filterVT, "true");
        CodingRuleInfo codingRule = (CodingRuleInfo)this.getCodingRule(ctx, profitCenter, null, curPeriod);
        if (codingRule == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)RESOURCE, (String)"PcVoucherHelpFacadeControllerBean1001", (Locale)ctx.getLocale())});
        }
        CodingRuleEntryCollection codienentrys = codingRule.getCodingRuleEntrys();
        String orderby = null;
        HashMap<String, String> dateFormat = new HashMap<String, String>();
        for (int i = 0; i < codienentrys.size(); ++i) {
            CodingRuleEntryInfo codingRuleEntry = codienentrys.get(i);
            if (codingRuleEntry.getCodeAttribute().trim().equals("sn") || codingRuleEntry.getValueAttribute() == null || !codingRuleEntry.isIsSortByItem()) continue;
            String attr = codingRuleEntry.getValueAttribute().trim();
            if (attr.indexOf("bizDate") != -1) {
                orderby = "bizDate";
                dateFormat.put("bizDate", codingRuleEntry.getFormat());
            }
            if (attr.indexOf("bookedDate") == -1) continue;
            orderby = "bookedDate";
            dateFormat.put("bookedDate", codingRuleEntry.getFormat());
        }
        HashMap<String, PcVoucherCollection> dateAndVoucher = new HashMap<String, PcVoucherCollection>();
        String voucherTypeId = null;
        if (vtCol != null && vtCol.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            SorterItemCollection sorters = evi.getSorter();
            if (orderby != null) {
                sorters.add(new SorterItemInfo(orderby));
            } else {
                sorters.add(new SorterItemInfo("bookedDate"));
            }
            sorters.add(new SorterItemInfo("number"));
            SelectorItemCollection sic = new SelectorItemCollection();
            this.setSelector(sic);
            Iterator itrVt = vtCol.iterator();
            PcVoucherInfo tempVoucher = null;
            String date = null;
            while (itrVt.hasNext()) {
                VoucherTypeInfo vt = (VoucherTypeInfo)itrVt.next();
                voucherTypeId = vt.getId().toString();
                PcVoucherCollection col = this.loadData(ctx, voucherTypeId, curPeriod.getId().toString(), profitCenterId, false, sorters, sic);
                boolean isControl = GlParam.getGlParams((Context)ctx, (String)"GL_VCH_POST_CONTROL", (String)profitCenterId).getBoolean("GL_VCH_POST_CONTROL");
                int sum = 0;
                if (isControl) {
                    EntityViewInfo e = new EntityViewInfo();
                    e.setSelector(sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)profitCenterId));
                    filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)curPeriod.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
                    filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
                    e.setFilter(filter);
                    PcVoucherCollection postColl = PcVoucherFactory.getLocalInstance((Context)ctx).getPcVoucherCollection(e);
                    sum = postColl.size();
                }
                if (orderby != null) {
                    for (int i = 0; i < col.size(); ++i) {
                        tempVoucher = col.get(i);
                        Date orderDate = tempVoucher.getDate(orderby);
                        String[] times = CodingRuleFactory.getLocalInstance((Context)ctx).getTimeFormat((java.util.Date)orderDate);
                        date = times[Integer.parseInt((String)dateFormat.get(orderby))];
                        if (dateAndVoucher.get(date) == null) {
                            PcVoucherCollection pcVc = new PcVoucherCollection();
                            pcVc.add(tempVoucher);
                            dateAndVoucher.put(date, pcVc);
                            continue;
                        }
                        ((PcVoucherCollection)dateAndVoucher.get(date)).add(tempVoucher);
                    }
                    Set set = dateAndVoucher.keySet();
                    Iterator itr = set.iterator();
                    while (itr.hasNext()) {
                        PcVoucherCollection pcVCol = (PcVoucherCollection)dateAndVoucher.get(itr.next());
                        int count = pcVCol.size();
                        if (count <= 0) continue;
                        String[] number = this.getBatchNumber(ctx, count, sum + 1, (IObjectValue)vt, (IObjectValue)profitCenter, pcVCol.get(0));
                        ctx.put((Object)"isCheckNumberRepeated", (Object)Boolean.FALSE);
                        this._updateNumber(ctx, this.getSelectedValues(pcVCol, count, number));
                    }
                    continue;
                }
                int count = col.size();
                if (count <= 0) continue;
                String[] number = this._getBatchNumber(ctx, count, sum + 1, (IObjectValue)vt, (IObjectValue)profitCenter);
                ctx.put((Object)"isCheckNumberRepeated", (Object)Boolean.FALSE);
                this._updateNumber(ctx, this.getSelectedValues(col, count, number));
            }
        }
    }

    private PcVoucherCollection loadData(Context ctx, String voucherTypeId, String periodId, String profitCenterId, boolean hasZf, SorterItemCollection s, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo companyOrgUnit = PcaUtils.getDelegateCompany(ctx, profitCenterId);
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)profitCenterId));
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
        if (hasZf) {
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        boolean isControl = GlParam.getGlParams((Context)ctx, (String)"GL_VCH_POST_CONTROL", (String)companyOrgUnit.getId().toString()).getBoolean("GL_VCH_POST_CONTROL");
        if (isControl) {
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        if (s == null) {
            sorters.add(new SorterItemInfo("number"));
        } else {
            sorters.addObjectCollection((IObjectCollection)s.getSorter());
        }
        return PcVoucherFactory.getLocalInstance((Context)ctx).getPcVoucherCollection(evi);
    }

    protected Map getSelectedValues(PcVoucherCollection col, int count, String[] number) throws BOSException, EASBizException {
        HashMap<String, String[]> numberMap = new HashMap<String, String[]>();
        for (int i = 0; i < count; ++i) {
            PcVoucherInfo voucher = col.get(i);
            String id = voucher.getId().toString();
            String newnumber = number[i];
            String oldNumber = voucher.getNumber();
            String[] numbermap = new String[]{newnumber, oldNumber, voucher.getVoucherType() == null ? "" : voucher.getVoucherType().getName()};
            numberMap.put(id, numbermap);
        }
        return numberMap;
    }

    protected boolean _updateNumber(Context ctx, Map numberMap) throws BOSException, EASBizException {
        return this.updateNumber(ctx, numberMap, 0);
    }

    private boolean updateNumber(Context ctx, Map numberMap, int sourceType) throws BOSException, EASBizException {
        if (numberMap.isEmpty()) {
            return false;
        }
        PcVoucherCollection voucherCol = this.getPcVoucherCollection(ctx, numberMap);
        PcVoucherInfo vch = voucherCol.get(0);
        this.updateVoucherNumber(ctx, numberMap, voucherCol, sourceType);
        boolean isHand = PcaUtils.getVoucherHandParam(ctx, vch.getProfitCenter().getId().toString());
        if (!isHand) {
            this.recycleVoucherNumber(ctx, numberMap, voucherCol);
        }
        this.botpRewrite(ctx, voucherCol);
        return true;
    }

    private PcVoucherCollection getPcVoucherCollection(Context ctx, Map numberMap) throws BOSException {
        IPcVoucher iVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        PcVoucherCollection voucherCol = null;
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(PcVoucherInfo.getDefaultProcessSelector());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Set idKeySet = numberMap.keySet();
        int size = idKeySet.size();
        Iterator keyIterator = idKeySet.iterator();
        HashSet<String> tempIdSet = new HashSet<String>();
        while (keyIterator.hasNext()) {
            String id = (String)keyIterator.next();
            tempIdSet.add(id);
            if (tempIdSet.size() < 200 && keyIterator.hasNext()) continue;
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            PcVoucherCollection col = iVoucher.getPcVoucherCollection(view);
            if (voucherCol == null) {
                voucherCol = new PcVoucherCollection();
            }
            voucherCol.addCollection(col);
            tempIdSet.clear();
        }
        return voucherCol;
    }

    private void recycleVoucherNumber(Context ctx, Map numberMap, PcVoucherCollection voucherCol) throws BOSException, EASBizException {
        HashMap<String, String> oldNumberMap = new HashMap<String, String>();
        HashMap<String, String> newNumberMap = new HashMap<String, String>();
        Set idKeySet = numberMap.keySet();
        HashSet filterIdSet = new HashSet(idKeySet);
        for (String id : idKeySet) {
            String[] numbermap = (String[])numberMap.get(id);
            String newNumber = numbermap[0];
            String oldNumber = numbermap[1];
            oldNumberMap.put(id, oldNumber);
            newNumberMap.put(newNumber, oldNumber);
        }
        Set keySet = oldNumberMap.keySet();
        Iterator it = keySet.iterator();
        PcVoucherInfo voucherInfo = null;
        IPcVoucher ivoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        while (it.hasNext()) {
            String key = (String)it.next();
            String number = (String)oldNumberMap.get(key);
            if (newNumberMap.containsKey(number)) continue;
            BOSUuid id = BOSUuid.read((String)key);
            voucherInfo = voucherCol.containsKey((Object)id) ? voucherCol.get((Object)id) : (PcVoucherInfo)ivoucher.getValue((IObjectPK)new ObjectUuidPK(key), VoucherInfo.getDefaultProcessSelector());
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            voucherInfo.setNumber(number);
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
        }
    }

    private void botpRewrite(final Context ctx, final PcVoucherCollection voucherCol) {
        Thread voucherReverseSaveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    int count = voucherCol.size();
                    for (int i = 0; i < count; ++i) {
                        PcVoucherInfo voucherInfo = voucherCol.get(i);
                        BOTRelationCollection botRelationCol = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
                        BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
                        botReverseManager.setOprtState(BOTBillOperStateEnum.EDIT);
                        int total = botRelationCol.size();
                        for (int j = 0; j < total; ++j) {
                            BOTRelationInfo botRelationInfo = botRelationCol.get(j);
                            botReverseManager.reverseWrite(botRelationInfo);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while rewriting Botp!", (Throwable)ex);
                }
            }
        });
        voucherReverseSaveThread.start();
    }

    private void updateVoucherNumber(Context ctx, Map numberMap, PcVoucherCollection voucherCol, int sourceType) throws BOSException, EASBizException {
        if (numberMap == null) {
            return;
        }
        LinkedHashMap<String, String[]> voucherMap = new LinkedHashMap<String, String[]>();
        boolean isCheckNumberRepeated = ctx.get((Object)"isCheckNumberRepeated") == null || (Boolean)ctx.get((Object)"isCheckNumberRepeated") != false;
        IPcaGeneralFacade facade = null;
        if (isCheckNumberRepeated) {
            facade = PcaGeneralFacadeFactory.getLocalInstance(ctx);
        } else {
            ctx.remove((Object)"isCheckNumberRepeated");
        }
        BOSObjectType bosType = new PcVoucherInfo().getBOSType();
        String strLogRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"vchResortNumber", (Locale)ctx.getLocale());
        String strLogMethod = this.getLogMethod(ctx, sourceType);
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        String updateSql = "update t_pca_pcvoucher set fnumber=? where fid=?";
        Set idKeySet = numberMap.keySet();
        HashSet filterIdSet = new HashSet(idKeySet);
        for (String key : idKeySet) {
            String[] numbermap = (String[])numberMap.get(key);
            String newNumber = numbermap[0];
            String oldNumber = numbermap[1];
            String vchType = numbermap[2];
            String[] vchNumberMap = new String[]{oldNumber, newNumber};
            voucherMap.put(key, vchNumberMap);
            if (isCheckNumberRepeated) {
                PcVoucherInfo chkVoucherInfo = voucherCol.get((Object)BOSUuid.read((String)key));
                if (chkVoucherInfo == null) {
                    throw new BOSException("Get Voucher Error!");
                }
                Map<String, Object> param = new HashMap<String, Object>();
                param.put("voucherid", chkVoucherInfo.getId().toString());
                param.put("vouchertypeid", chkVoucherInfo.getVoucherType().getId().toString());
                param.put("periodid", chkVoucherInfo.getPeriod().getId().toString());
                param.put("number", newNumber);
                param.put("filterIdSet", filterIdSet);
                param.put("profitCenterId", chkVoucherInfo.getProfitCenter().getId().toString());
                param = facade.dealTask("getPreNumberRepeated", param);
                if (param != null) {
                    throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                }
            }
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{newNumber, key});
            filterIdSet.remove(key);
            String logDetail = MessageFormat.format(strLogRes, vchType + "-" + oldNumber, vchType + "-" + newNumber);
            IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)strLogMethod, (BOSObjectType)bosType, null, (String)logDetail, (String)strLogMethod);
            logPkList.add(logPk);
        }
        PcVoucherUtil.modifyVoucherNumberBatch(ctx, voucherMap);
        Iterator it = logPkList.iterator();
        while (it.hasNext()) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)((IObjectPK)it.next()));
        }
    }

    private String getLogMethod(Context ctx, int sourceType) {
        String resPath = "com.kingdee.eas.fi.gl.GLResource";
        switch (sourceType) {
            case 0: {
                return ResourceBase.getString((String)resPath, (String)"logMethod_ResortNumber", (Locale)ctx.getLocale());
            }
            case 1: {
                return ResourceBase.getString((String)resPath, (String)"logMethod_AdjustNumberBatch", (Locale)ctx.getLocale());
            }
        }
        return null;
    }

    protected void recycleVoucherId(Context ctx, PcVoucherInfo voucherInfo, String voucherId) throws BOSException, EASBizException {
        this.getCodingRuleCtrl(ctx).recycleNumber((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus", "", voucherId);
    }

    private IObjectValue getCodingRule(Context ctx, ProfitCenterOrgUnitInfo profitCenter, VoucherTypeInfo type, PeriodInfo period) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = new PcVoucherInfo();
        voucherInfo.setVoucherType(type);
        voucherInfo.setPeriod(period);
        voucherInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setProfitCenter(profitCenter);
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getProfitCenter().getId().toString(), "bizStatus");
    }

    @Override
    protected void _modifyAttach(Context ctx, String id, int count) throws BOSException {
        String updateSql = "update t_pca_pcvoucher set FAttachments=? where fid=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Integer(count), id});
    }
}

