/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.IAsstAccountChangeProcess;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.PCAMutexUtils;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.app.PcaBalanceFacadeControllerBean;
import com.kingdee.eas.ma.pca.app.PcaBalanceRepairer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PcaAsstAccountChangeProcess
implements IAsstAccountChangeProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.PcaAsstAccountChangeProcess");
    private String caa;
    private AsstAccountInfo asstAccount;
    private Map assisthg = new HashMap();
    private AsstActTypeCollection typeCol;
    private IAssistantHG igCtrl;
    private SelectorItemCollection selector;
    private AccountViewInfo accountViewInfo;
    private boolean isNew;
    private Context ctx;
    private Map defaultVal;
    private AsstAccountChangeInfo change = null;
    private Uuid requestId = null;
    private int type = 1;
    private String oldCaa = null;
    private String newCaa = null;

    public void changeAsst(Context ctx, String caaID, Map defaultVal, boolean isNew, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        this.initParam(ctx, caaID, defaultVal, isNew, accountViewInfo);
        this.dealInitBizData();
        this.dealVoucherAssistRecord();
        this.dealAssistBalance();
    }

    private void checkExistBizData(Context ctx, String accountViewID) throws BOSException, EASBizException {
        String sql = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            sql = "select top 1 fid from t_pca_pcvoucherassistrecord where fentryid in (select fid from t_pca_pcvoucherentry where faccountid=? ) ";
            ps = con.prepareStatement(sql);
            ps.setString(1, accountViewID);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.ACCOUNT_EXIST_VOUCHER_DATA);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 faccountid from t_pca_initpcassistbalance where faccountid=? ";
            ps = con.prepareStatement(sql);
            ps.setString(1, accountViewID);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.ACCOUNT_EXIST_INITDATA);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select top 1 faccountid from t_pca_pcassistbalance where faccountid=?  ";
            ps = con.prepareStatement(sql);
            ps.setString(1, accountViewID);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new PcaException(PcaException.ACCOUNT_EXIST_VOUCHER_DATA);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
    }

    private void initParam(Context ctx, String caaID, Map defaultVal, boolean isNew, AccountViewInfo accountViewInfo) throws BOSException {
        this.caa = caaID;
        this.asstAccount = new AsstAccountInfo();
        if (this.caa != null) {
            this.asstAccount.setId(BOSUuid.read((String)this.caa));
        }
        this.typeCol = new AsstActTypeCollection();
        this.igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        this.selector = new SelectorItemCollection();
        if (defaultVal != null) {
            Set keyset = defaultVal.keySet();
            for (AsstActTypeInfo oldInfo : keyset) {
                if (oldInfo == null) continue;
                String asstHGAttribute = oldInfo.getAsstHGAttribute();
                this.selector.add(new SelectorItemInfo(asstHGAttribute + ".id"));
                this.typeCol.add(oldInfo);
            }
        }
        this.accountViewInfo = accountViewInfo;
        this.isNew = isNew;
        this.ctx = ctx;
        this.defaultVal = defaultVal;
    }

    private void dealInitBizData() throws BOSException, EASBizException {
        if (this.caa == null) {
            String initSql = "delete from t_pca_initpcassistbalance where faccountid=? ";
            DbUtil.execute((Context)this.ctx, (String)initSql, (Object[])new Object[]{this.accountViewInfo.getId().toString()});
            initSql = "delete from t_pca_flag where fkey=? ";
            DbUtil.execute((Context)this.ctx, (String)initSql, (Object[])new Object[]{this.accountViewInfo.getId().toString()});
        } else if (this.isNew) {
            this.insert(this.ctx, this.accountViewInfo.getId().toString(), this.caa, this.defaultVal, this.asstAccount, this.typeCol, this.assisthg, this.igCtrl, 1);
            String companyID = this.accountViewInfo.getCompanyID().getId().toString();
            HashSet<String> profitCenterIds = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)companyID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("fromUnit.id");
            view.setSelector(selector);
            IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
            OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                profitCenterIds.add(coll.get(i).getFromUnit().getId().toString());
            }
            this.insertFlag(profitCenterIds, companyID);
        } else {
            String selectSql = "select fassistgrpid from t_pca_initpcassistbalance where faccountid=? ";
            String updateSql = "update t_pca_initpcassistbalance set (fassistgrpid)=(select Fnewhgid from t_bd_assistanthgTmp  \twhere t_pca_initpcassistbalance.faccountid = '" + this.accountViewInfo.getId().toString() + "' and t_pca_initpcassistbalance.fassistgrpid = t_bd_assistanthgTmp.Foldhgid) ";
            this.selectAndUpdate(this.ctx, this.accountViewInfo.getId().toString(), this.caa, this.defaultVal, this.selector, this.asstAccount, this.typeCol, selectSql, updateSql, this.assisthg, this.igCtrl, "fassistgrpid", "init");
            selectSql = "select b.fassgrpid from t_pca_pcacctcussent a,t_pca_pcvoucherassistrecord b where a.fvchassistrecordid=b.fid and a.faccountid=? and a.fisinit=1 ";
            StringBuffer updateSqlSB = new StringBuffer();
            updateSqlSB.append(" update t_pca_pcvoucherassistrecord                                         ");
            updateSqlSB.append("    set (fassgrpid) =                                                    ");
            updateSqlSB.append("        (select Fnewhgid from varHGIDtmp                                 ");
            updateSqlSB.append("          where t_pca_pcvoucherassistrecord.fid = varHGIDtmp.fvarid ");
            updateSqlSB.append("            and t_pca_pcvoucherassistrecord.fassgrpid = varHGIDtmp.Foldhgid)        ");
            updateSql = updateSqlSB.toString();
            selectSql = "select a.fassgrpid from t_pca_pcacctcussent a where a.faccountid=? ";
            String string = " update t_pca_pcacctcussent set (fassgrpid)=(select Fnewhgid from t_bd_assistanthgTmp  \twhere t_pca_pcacctcussent.fassgrpid = t_bd_assistanthgTmp.Foldhgid ) ";
        }
    }

    private void insertFlag(Set<String> profitCenterIds, String companyID) throws BOSException {
        if (profitCenterIds == null || profitCenterIds.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        for (String profitCenterId : profitCenterIds) {
            sql.setLength(0);
            sql.append("insert into t_pca_flag (fid, fname, fvalue, forgunitid, fkey, fcompanyid) \n");
            sql.append("select newbosid('E5A15661'), 'astinit', t.fvalue, t.forgUnitid, ? , t.fcompanyid\n");
            sql.append("from t_pca_flag t where t.fname = 'pcainit' and t.forgUnitid = ? and t.fcompanyid = ?\n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.accountViewInfo.getId().toString(), profitCenterId, companyID});
        }
    }

    private void insert(Context ctx, String account, String caa, Map defaultVal, AsstAccountInfo asstAccount, AsstActTypeCollection typeCol, Map assisthg, IAssistantHG igCtrl, int type) throws BOSException, EASBizException {
        AssistantHGInfo hgInfo = null;
        if (assisthg.containsKey(caa)) {
            hgInfo = (AssistantHGInfo)assisthg.get(caa);
        } else {
            hgInfo = new AssistantHGInfo();
            hgInfo.setId(null);
            hgInfo.setAsstAccount(asstAccount);
            if (defaultVal != null) {
                Set keyset = defaultVal.keySet();
                for (AsstActTypeInfo oldInfo : keyset) {
                    String asstHGAttribute = oldInfo.getAsstHGAttribute();
                    if (defaultVal.get(oldInfo) == null) continue;
                    hgInfo.put(asstHGAttribute, defaultVal.get(oldInfo));
                }
                hgInfo = igCtrl.getAssistantHG(hgInfo, caa, typeCol);
            }
            assisthg.put(caa, hgInfo);
        }
        AssistUtil._modify((Context)ctx, (String)hgInfo.getId().toString());
        String inserSql = this.getInserSql(hgInfo.getId().toString(), type);
        if (hgInfo != null) {
            if (type == 3) {
                DbUtil.execute((Context)ctx, (String)this.getDeleteSql(), (Object[])new Object[]{account, hgInfo.getId().toString()});
            }
            DbUtil.execute((Context)ctx, (String)inserSql, (Object[])new Object[]{account});
        }
    }

    private String getDeleteSql() {
        String delSql = "delete from t_pca_pcAssistBalance where exists(select 1 from t_pca_pcAccountBalance acbl  where acbl.FBalType = t_pca_pcAssistBalance.FBalType and acbl.FPeriodId = t_pca_pcAssistBalance.FPeriodId  and acbl.FOrgUnitID = t_pca_pcAssistBalance.FOrgUnitID and acbl.FprofitcenterID = t_pca_pcAssistBalance.FprofitcenterID and acbl.FCurrencyID = t_pca_pcAssistBalance.FCurrencyID )  and t_pca_pcAssistBalance.FAccountID = ? and t_pca_pcAssistBalance.FAssistGrpID = ?";
        return delSql;
    }

    private String getInserSql(String hgid, int type) {
        StringBuffer sql = new StringBuffer();
        if (type == 1) {
            sql.append("Insert into t_pca_initpcAssistBalance                                  \r\n");
            sql.append("(\t                                                            \r\n");
            sql.append("\tFOrgUnitID,                                                 \r\n");
            sql.append("\tFprofitcenterID,                                                 \r\n");
            sql.append("\tFAccountID,                                                 \r\n");
            sql.append("\tFAssistGrpID,                                               \r\n");
            sql.append("\tFCurrencyID,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceFor ,                                          \r\n");
            sql.append("\tFDebitFor ,                                             \r\n");
            sql.append("\tFCreditFor ,                                            \r\n");
            sql.append("\tFYearDebitFor ,                                             \r\n");
            sql.append("\tFYearCreditFor ,                                            \r\n");
            sql.append("\tFEndBalanceFor ,                                            \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceLocal ,                                        \r\n");
            sql.append("\tFDebitLocal ,                                           \r\n");
            sql.append("\tFCreditLocal ,                                          \r\n");
            sql.append("\tFYearDebitLocal ,                                           \r\n");
            sql.append("\tFYearCreditLocal ,                                          \r\n");
            sql.append("\tFEndBalanceLocal ,                                          \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceRpt ,                                          \r\n");
            sql.append("\tFDebitRpt ,                                             \r\n");
            sql.append("\tFCreditRpt ,                                            \r\n");
            sql.append("\tFYearDebitRpt ,                                             \r\n");
            sql.append("\tFYearCreditRpt ,                                            \r\n");
            sql.append("\tFEndBalanceRpt ,                                            \r\n");
            sql.append("\t                                                            \r\n");
            sql.append("\tFYearPnLFor,                                                \r\n");
            sql.append("\tFYearPnLLocal,                                              \r\n");
            sql.append("\tFYearPnLRpt,                                                \r\n");
            sql.append("\tFmonthPnLFor,                                                \r\n");
            sql.append("\tFmonthPnLLocal,                                              \r\n");
            sql.append("\tFmonthPnLRpt,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginQty,                                                  \r\n");
            sql.append("\tFDebitQty,                                              \r\n");
            sql.append("\tFCreditQty,                                             \r\n");
            sql.append("\tFYearDebitQty,                                              \r\n");
            sql.append("\tFYearCreditQty,                                             \r\n");
            sql.append("\tFEndQty                                                     \r\n");
            sql.append(")                                                               \r\n");
            sql.append("                                                                \r\n");
            sql.append("Select                                                          \r\n");
            sql.append("\tFOrgUnitID,                                                 \r\n");
            sql.append("\tFprofitcenterID,                                                 \r\n");
            sql.append("\tFAccountID,                                                 \r\n");
            sql.append("\t'" + hgid + "',                                               \r\n");
            sql.append("\tFCurrencyID,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceFor ,                \r\n");
            sql.append("\tFDebitFor ,                                             \r\n");
            sql.append("\tFCreditFor ,                                            \r\n");
            sql.append("\tFYearDebitFor ,                                             \r\n");
            sql.append("\tFYearCreditFor ,                                            \r\n");
            sql.append("\tFEndBalanceFor ,                                            \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceLocal ,                                        \r\n");
            sql.append("\tFDebitLocal ,                                           \r\n");
            sql.append("\tFCreditLocal ,                                          \r\n");
            sql.append("\tFYearDebitLocal ,                                           \r\n");
            sql.append("\tFYearCreditLocal ,                                          \r\n");
            sql.append("\tFEndBalanceLocal ,                                          \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceRpt ,                                          \r\n");
            sql.append("\tFDebitRpt ,                                             \r\n");
            sql.append("\tFCreditRpt ,                                            \r\n");
            sql.append("\tFYearDebitRpt ,                                             \r\n");
            sql.append("\tFYearCreditRpt ,                                            \r\n");
            sql.append("\tFEndBalanceRpt ,                                            \r\n");
            sql.append("\t                                                            \r\n");
            sql.append("\tFYearPnLFor,                                                \r\n");
            sql.append("\tFYearPnLLocal,                                              \r\n");
            sql.append("\tFYearPnLRpt,                                                \r\n");
            sql.append("\tFmonthPnLFor,                                                \r\n");
            sql.append("\tFmonthPnLLocal,                                              \r\n");
            sql.append("\tFmonthPnLRpt,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginQty,                                                  \r\n");
            sql.append("\tFDebitQty,                                              \r\n");
            sql.append("\tFCreditQty,                                             \r\n");
            sql.append("\tFYearDebitQty,                                              \r\n");
            sql.append("\tFYearCreditQty,                                             \r\n");
            sql.append("\tFEndQty                                                     \r\n");
            sql.append("From t_pca_initpcAccountBalance                                          \r\n");
            sql.append("Where faccountid=?                         \r\n");
        } else if (type == 2) {
            sql.append("insert into t_pca_pcvoucherassistrecord (fid,fentryid,fassgrpid,fseq,fbizdate,foriginalamount,flocalamount, \tfreportingamount,fquantity,fstandardquantity,fmeasureunitid,fprice,fdescription,fbillid,fmactrlamount,fmaholdamount )  \t\t\t\t\tselect newBosID('0FFFBCAA'),a.fid,'" + hgid + "', 1,b.fbizdate,a.foriginalamount,a.flocalamount,\t\t\t\t\t\t\t\t\t\ta.freportingamount,a.fquantity,a.fstandardquantity,a.fmeasureunitid,a.fprice,a.fdescription,a.fbillid,a.fmactrlamount,a.fmaholdamount\t\tfrom t_pca_pcvoucherentry a,t_pca_pcvoucher b where a.fbillid=b.fid and a.faccountid=? ");
        } else if (type == 3) {
            sql.append("Insert into t_pca_pcAssistBalance                                  \r\n");
            sql.append("(\t                                                            \r\n");
            sql.append("\tFBalType,                                                 \r\n");
            sql.append("\tFPeriodId,                                                 \r\n");
            sql.append("\tFOrgUnitID,                                                 \r\n");
            sql.append("\tFprofitcenterID,                                                 \r\n");
            sql.append("\tFAccountID,                                                 \r\n");
            sql.append("\tFAssistGrpID,                                               \r\n");
            sql.append("\tFCurrencyID,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceFor ,                                          \r\n");
            sql.append("\tFDebitFor ,                                             \r\n");
            sql.append("\tFCreditFor ,                                            \r\n");
            sql.append("\tFYearDebitFor ,                                             \r\n");
            sql.append("\tFYearCreditFor ,                                            \r\n");
            sql.append("\tFEndBalanceFor ,                                            \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceLocal ,                                        \r\n");
            sql.append("\tFDebitLocal ,                                           \r\n");
            sql.append("\tFCreditLocal ,                                          \r\n");
            sql.append("\tFYearDebitLocal ,                                           \r\n");
            sql.append("\tFYearCreditLocal ,                                          \r\n");
            sql.append("\tFEndBalanceLocal ,                                          \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceRpt ,                                          \r\n");
            sql.append("\tFDebitRpt ,                                             \r\n");
            sql.append("\tFCreditRpt ,                                            \r\n");
            sql.append("\tFYearDebitRpt ,                                             \r\n");
            sql.append("\tFYearCreditRpt ,                                            \r\n");
            sql.append("\tFEndBalanceRpt ,                                            \r\n");
            sql.append("\t                                                            \r\n");
            sql.append("\tFYearPnLFor,                                                \r\n");
            sql.append("\tFYearPnLLocal,                                              \r\n");
            sql.append("\tFYearPnLRpt,                                                \r\n");
            sql.append("\tFmonthPnLFor,                                                \r\n");
            sql.append("\tFmonthPnLLocal,                                              \r\n");
            sql.append("\tFmonthPnLRpt,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginQty,                                                  \r\n");
            sql.append("\tFDebitQty,                                              \r\n");
            sql.append("\tFCreditQty,                                             \r\n");
            sql.append("\tFYearDebitQty,                                              \r\n");
            sql.append("\tFYearCreditQty,                                             \r\n");
            sql.append("\tFEndQty,                                                     \r\n");
            sql.append("\tFPERIODYEAR,                                                     \r\n");
            sql.append("\tFPERIODNUMBER                                                     \r\n");
            sql.append(")                                                               \r\n");
            sql.append("                                                                \r\n");
            sql.append("Select                                                          \r\n");
            sql.append("\tFBalType,                                                 \r\n");
            sql.append("\tFPeriodId,                                                 \r\n");
            sql.append("\tFOrgUnitID,                                                 \r\n");
            sql.append("\tFprofitcenterID,                                                 \r\n");
            sql.append("\tFAccountID,                                                 \r\n");
            sql.append("\t'" + hgid + "',                                               \r\n");
            sql.append("\tFCurrencyID,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceFor ,               \r\n");
            sql.append("\tFDebitFor ,                                             \r\n");
            sql.append("\tFCreditFor ,                                            \r\n");
            sql.append("\tFYearDebitFor ,                                             \r\n");
            sql.append("\tFYearCreditFor ,                                            \r\n");
            sql.append("\tFEndBalanceFor ,                                            \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceLocal ,                                        \r\n");
            sql.append("\tFDebitLocal ,                                           \r\n");
            sql.append("\tFCreditLocal ,                                          \r\n");
            sql.append("\tFYearDebitLocal ,                                           \r\n");
            sql.append("\tFYearCreditLocal ,                                          \r\n");
            sql.append("\tFEndBalanceLocal ,                                          \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginBalanceRpt ,                                          \r\n");
            sql.append("\tFDebitRpt ,                                             \r\n");
            sql.append("\tFCreditRpt ,                                            \r\n");
            sql.append("\tFYearDebitRpt ,                                             \r\n");
            sql.append("\tFYearCreditRpt ,                                            \r\n");
            sql.append("\tFEndBalanceRpt ,                                            \r\n");
            sql.append("\t                                                            \r\n");
            sql.append("\tFYearPnLFor,                                                \r\n");
            sql.append("\tFYearPnLLocal,                                              \r\n");
            sql.append("\tFYearPnLRpt,                                                \r\n");
            sql.append("\tFmonthPnLFor,                                                \r\n");
            sql.append("\tFmonthPnLLocal,                                              \r\n");
            sql.append("\tFmonthPnLRpt,                                                \r\n");
            sql.append("                                                                \r\n");
            sql.append("\tFBeginQty,                                                  \r\n");
            sql.append("\tFDebitQty,                                              \r\n");
            sql.append("\tFCreditQty,                                             \r\n");
            sql.append("\tFYearDebitQty,                                              \r\n");
            sql.append("\tFYearCreditQty,                                             \r\n");
            sql.append("\tFEndQty,                                                     \r\n");
            sql.append("\tt_bd_period.FPERIODYEAR FPERIODYEAR,                                                     \r\n");
            sql.append("\tt_bd_period.FPERIODNUMBER FPERIODNUMBER                                                     \r\n");
            sql.append(" From t_pca_pcAccountBalance left outer join t_bd_period on t_pca_pcAccountBalance.FPeriodId=t_bd_period.fid            \r\n");
            sql.append("Where faccountid=?                         \r\n");
        } else if (type == 4) {
            // empty if block
        }
        return sql.toString();
    }

    private void selectAndUpdate(Context ctx, String account, String caa, Map defaultVal, SelectorItemCollection selector, AsstAccountInfo asstAccount, AsstActTypeCollection typeCol, String selectSql, String updateSql, Map assisthg, IAssistantHG igCtrl, String field, String repeat) throws BOSException, EASBizException {
        Connection conn;
        PreparedStatement stmt;
        block26: {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{account});
            stmt = null;
            conn = null;
            try {
                Set keyset;
                HashMap<String, String> HGnewMap = new HashMap<String, String>();
                HashMap repeatMap = new HashMap();
                boolean isNeedUnit = false;
                HashSet<String> assistGrpIdSet = new HashSet<String>();
                while (rowSet != null && rowSet.next()) {
                    String id = rowSet.getString(field);
                    if (StringUtils.isEmpty((String)id)) continue;
                    assistGrpIdSet.add(id);
                }
                conn = EJBFactory.getConnection((Context)ctx);
                Iterator assistGrpIdIterator = assistGrpIdSet.iterator();
                while (assistGrpIdIterator != null && assistGrpIdIterator.hasNext()) {
                    String id = assistGrpIdIterator.next().toString();
                    if (id == null || id.trim().length() <= 0) continue;
                    AssistantHGInfo hgInfo = null;
                    if (assisthg.containsKey(id)) {
                        hgInfo = (AssistantHGInfo)assisthg.get(id);
                    } else {
                        hgInfo = igCtrl.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(id), selector);
                        hgInfo.setId(null);
                        hgInfo.setAsstAccount(asstAccount);
                        if (defaultVal != null) {
                            keyset = defaultVal.keySet();
                            for (AsstActTypeInfo oldInfo : keyset) {
                                String asstHGAttribute = oldInfo.getAsstHGAttribute();
                                if (defaultVal.get(oldInfo) == null) continue;
                                hgInfo.put(asstHGAttribute, defaultVal.get(oldInfo));
                            }
                            hgInfo = igCtrl.getAssistantHG(hgInfo, caa, typeCol);
                        }
                        assisthg.put(id, hgInfo);
                    }
                    String hgid = hgInfo.getId().toString();
                    if (repeat != null) {
                        Set<String> unitHgSet;
                        if (repeatMap.containsKey(hgid)) {
                            isNeedUnit = true;
                            unitHgSet = (Set)repeatMap.get(hgid);
                            unitHgSet.add(id);
                        } else {
                            unitHgSet = new HashSet<String>();
                            unitHgSet.add(id);
                            repeatMap.put(hgInfo.getId().toString(), unitHgSet);
                        }
                    }
                    HGnewMap.put(id, hgid);
                }
                String assistantHGtmp = this.createAssistantHGTmpTable(ctx);
                StringBuffer insertSql = new StringBuffer();
                insertSql.append(" insert into ");
                insertSql.append(assistantHGtmp);
                insertSql.append(" (Fnewhgid, Foldhgid) values(?, ?) ");
                stmt = conn.prepareStatement(insertSql.toString());
                keyset = HGnewMap.keySet();
                Iterator it = keyset.iterator();
                int index = 0;
                while (it.hasNext()) {
                    String oldId = (String)it.next();
                    stmt.setString(1, (String)HGnewMap.get(oldId));
                    stmt.setString(2, oldId);
                    stmt.addBatch();
                    if (++index % 500 != 0) continue;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                stmt.executeBatch();
                if (repeat != null && isNeedUnit) {
                    if (repeat.equals("init")) {
                        this.unitInitAssistBalance(ctx, assistantHGtmp, account);
                    } else {
                        this.unitAssistBalance(ctx, assistantHGtmp, account);
                    }
                }
                String varHGIDtmp = null;
                boolean isVarHGIDtmp = false;
                if (updateSql.indexOf("varHGIDtmp") > 0) {
                    isVarHGIDtmp = true;
                    varHGIDtmp = this.createVarHGIDtmpTable(ctx);
                    StringBuffer insertVarHGIDtmpSql = new StringBuffer();
                    insertVarHGIDtmpSql.append(" insert into ").append(varHGIDtmp).append(" (Fnewhgid,Foldhgid,fvarid)");
                    insertVarHGIDtmpSql.append(" select Fnewhgid,Foldhgid,fid from ").append(assistantHGtmp).append(" assistantHGtmp,t_pca_pcvoucherassistrecord ");
                    insertVarHGIDtmpSql.append(" where t_pca_pcvoucherassistrecord.fassgrpid = assistantHGtmp.Foldhgid ");
                    insertVarHGIDtmpSql.append("            and exists (select fvchassistrecordid from t_pca_pcacctcussent ");
                    insertVarHGIDtmpSql.append("                  where t_pca_pcacctcussent.faccountid = '" + account + "' ");
                    insertVarHGIDtmpSql.append("                    and fisinit = 1 ");
                    insertVarHGIDtmpSql.append("                    and t_pca_pcacctcussent.fvchassistrecordid = t_pca_pcvoucherassistrecord.fid) ");
                    DbUtil.execute((Context)ctx, (String)insertVarHGIDtmpSql.toString());
                    updateSql = updateSql.replaceAll("varHGIDtmp", varHGIDtmp);
                }
                String varHGentrytmp = null;
                boolean isVarHGentrytmp = false;
                if (updateSql.indexOf("varHGentrytmp") > 0) {
                    isVarHGentrytmp = true;
                    varHGentrytmp = this.createVarHGIDtmpTable(ctx);
                    StringBuffer insertVarHGentrytmpSql = new StringBuffer();
                    insertVarHGentrytmpSql.append(" insert into ").append(varHGentrytmp).append(" (Fnewhgid,Foldhgid,fvarid)");
                    insertVarHGentrytmpSql.append(" select Fnewhgid,Foldhgid,fid from ").append(assistantHGtmp).append(" assistantHGtmp,t_pca_pcvoucherassistrecord ");
                    insertVarHGentrytmpSql.append(" where t_pca_pcvoucherassistrecord.fassgrpid = assistantHGtmp.Foldhgid ");
                    insertVarHGentrytmpSql.append("   and exists (select fid from t_pca_pcvoucherentry ");
                    insertVarHGentrytmpSql.append("     where t_pca_pcvoucherentry.faccountid = '" + account + "' ");
                    insertVarHGentrytmpSql.append("       and t_pca_pcvoucherentry.fid = t_pca_pcvoucherassistrecord.fentryid) ");
                    DbUtil.execute((Context)ctx, (String)insertVarHGentrytmpSql.toString());
                    updateSql = updateSql.replaceAll("varHGentrytmp", varHGentrytmp);
                }
                updateSql = updateSql.replaceAll("t_bd_assistanthgTmp", assistantHGtmp);
                DbUtil.execute((Context)ctx, (String)updateSql);
                logger.info((Object)("updateSql:" + updateSql));
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistantHGtmp);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                if (isVarHGIDtmp) {
                    try {
                        TempTablePool.getInstance((Context)ctx).releaseTable(varHGIDtmp);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
                if (!isVarHGentrytmp) break block26;
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(varHGentrytmp);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String createAssistantHGTmpTable(Context ctx) throws BOSException {
        String assistantHGtmp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table assistantHGtmp ");
        createTableSql.append(" (Fnewhgid varchar(44), Foldhgid varchar(44)) ");
        try {
            assistantHGtmp = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            String columns = "Foldhgid";
            TempTablePool.getInstance((Context)ctx).createIndex(assistantHGtmp, columns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return assistantHGtmp;
    }

    private String createVarHGIDtmpTable(Context ctx) throws BOSException {
        String varHGIDtmp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table varHGIDtmp ");
        createTableSql.append(" (Fnewhgid varchar(44), Foldhgid varchar(44), fvarid varchar(44) ) ");
        try {
            varHGIDtmp = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            String columns = "fvarid,Foldhgid";
            TempTablePool.getInstance((Context)ctx).createIndex(varHGIDtmp, columns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return varHGIDtmp;
    }

    private void dealVoucherAssistRecord() throws BOSException, EASBizException {
        if (this.caa == null) {
            String voucherSql = null;
            voucherSql = this.accountViewInfo.isHasUserProperty() ? "update t_pca_pcvoucherassistrecord set fassgrpid=null where fentryid in (select fid from t_pca_pcvoucherentry where faccountid=? )" : "delete from t_pca_pcvoucherassistrecord where fentryid in (select fid from t_pca_pcvoucherentry where faccountid=? ) ";
            DbUtil.execute((Context)this.ctx, (String)voucherSql, (Object[])new Object[]{this.accountViewInfo.getId().toString()});
        } else if (this.isNew) {
            if (!this.accountViewInfo.isHasUserProperty()) {
                this.insert(this.ctx, this.accountViewInfo.getId().toString(), this.caa, this.defaultVal, this.asstAccount, this.typeCol, this.assisthg, this.igCtrl, 2);
            } else {
                String newAsstHGId = ((AssistantHGInfo)this.assisthg.get(this.caa)).getId().toString();
                String acctId = this.accountViewInfo.getId().toString();
                String updateSql = "update t_pca_pcvoucherassistrecord set fassgrpid=? where fentryid in(select fid from t_pca_pcvoucherentry where faccountid=?)";
                DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])new Object[]{newAsstHGId, acctId});
            }
        } else {
            String selectSql = "select fassgrpid from t_pca_pcvoucherassistrecord a ,t_pca_pcvoucherentry b where a.fentryid=b.fid and b.faccountid=? ";
            StringBuffer updateSqlSB = new StringBuffer();
            updateSqlSB.append(" update t_pca_pcvoucherassistrecord                              ");
            updateSqlSB.append("   set (fassgrpid) = (select Fnewhgid from varHGentrytmp ");
            updateSqlSB.append("   where t_pca_pcvoucherassistrecord.fid = varHGentrytmp.fvarid ");
            updateSqlSB.append("     and t_pca_pcvoucherassistrecord.fassgrpid = varHGentrytmp.Foldhgid) ");
            String updateSql = updateSqlSB.toString();
            this.selectAndUpdate(this.ctx, this.accountViewInfo.getId().toString(), this.caa, this.defaultVal, this.selector, this.asstAccount, this.typeCol, selectSql, updateSql, this.assisthg, this.igCtrl, "fassgrpid", null);
        }
    }

    private void dealAcctCussentHistory() throws BOSException, EASBizException {
        if (this.caa != null && !this.isNew) {
            String selectSql = "select FAssGrpID from t_pca_pcAcctCussentHistory where FAccountID=? ";
            String updateSql = " update t_pca_pcAcctCussentHistory set (FAssGrpID)=(select Fnewhgid from t_bd_assistanthgTmp  \twhere t_pca_pcAcctCussentHistory.faccountid = '" + this.accountViewInfo.getId().toString() + "' and t_pca_pcAcctCussentHistory.FAssGrpID = t_bd_assistanthgTmp.Foldhgid) ";
            this.selectAndUpdate(this.ctx, this.accountViewInfo.getId().toString(), this.caa, this.defaultVal, this.selector, this.asstAccount, this.typeCol, selectSql, updateSql, this.assisthg, this.igCtrl, "FAssGrpID", null);
        }
    }

    private void dealAssistBalance() throws BOSException, EASBizException {
        HashSet<String> profitCenterIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select v.FProfitCenterID FProfitCenterID \n");
        sql.append("from t_pca_pcvoucher v \n");
        sql.append("join t_pca_pcvoucherentry ve on ve.FBillID = v.FID \n");
        sql.append("where ve.FAccountID = ? \n");
        sql.append("union \n");
        sql.append("select b.FProfitCenterID FProfitCenterID \n");
        sql.append("from t_pca_pcaccountbalance_1f b \n");
        sql.append("where b.FAccountID = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{this.accountViewInfo.getId().toString(), this.accountViewInfo.getId().toString()});
        try {
            while (rs.next()) {
                profitCenterIds.add(rs.getString("FProfitCenterID"));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("companyId", this.accountViewInfo.getCompanyID().getId().toString());
            HashSet<String> accountNumbers = new HashSet<String>();
            accountNumbers.add(this.accountViewInfo.getNumber());
            params.put("accountNumbers", accountNumbers);
            params.put("repairAccount", true);
            params.put("repairAssist", true);
            params.put("repairMeasure", true);
            params.put("onlyClean", false);
            for (String profitCenterId : profitCenterIds) {
                int period;
                String[] ids = new String[]{profitCenterId};
                PcaBalanceFacadeControllerBean b = new PcaBalanceFacadeControllerBean();
                b.updateVoucherBalance(this.ctx, ids);
                params.put("profitCenterId", profitCenterId);
                PeriodInfo start = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitStartPeriod(1006, profitCenterId);
                params.put("periodfrom", start);
                PeriodInfo current = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitCurrentPeriod(1006, profitCenterId);
                PeriodInfo periodto = new PeriodInfo();
                periodto.setNumber(current.getNumber());
                params.put("periodto", periodto);
                sql.setLength(0);
                sql.append("select max(p.FNumber) FPeriod \n");
                sql.append("from t_pca_pcvoucher v \n");
                sql.append("join t_bd_period p on p.fid = v.FPeriodID \n");
                sql.append("join t_pca_pcvoucherentry ve on ve.FBillID = v.FID \n");
                sql.append("where v.FProfitCenterID = ? and ve.FAccountID = ? \n");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{profitCenterId, this.accountViewInfo.getId().toString()});
                if (rs.next() && (period = rs.getInt("FPeriod")) > periodto.getNumber()) {
                    periodto.setNumber(period);
                }
                PcaBalanceRepairer.repair(this.ctx, params);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void unitInitAssistBalance(Context ctx, String assistantHGtmp, String account) throws BOSException {
        String initAssistBalanceTemp = this.createinitAssistBalanceTempTable(ctx);
        StringBuffer insertTempSql = new StringBuffer();
        insertTempSql.append(" insert into ").append(initAssistBalanceTemp);
        insertTempSql.append(" (FOrgUnitID,FprofitcenterID, FAccountID, FCurrencyID,FAssistGrpID, ");
        insertTempSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertTempSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertTempSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertTempSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertTempSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt) ");
        insertTempSql.append(" select balance.forgunitid,balance.FprofitcenterID, balance.faccountid, balance.fcurrencyid, hg.Fnewhgid, ");
        insertTempSql.append(" sum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fdebitfor) fdebitfor, sum(balance.fyeardebitfor) fyeardebitfor,");
        insertTempSql.append(" sum(balance.fcreditfor) fcreditfor, sum(balance.fyearcreditfor) fyearcreditfor, ");
        insertTempSql.append(" sum(balance.fendbalancefor) fendbalancefor, ");
        insertTempSql.append(" sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fdebitlocal) fdebitlocal, sum(balance.fyeardebitLocal) fyeardebitLocal,");
        insertTempSql.append(" sum(balance.fcreditlocal) fcreditlocal, sum(balance.fyearcreditLocal) fyearcreditLocal, ");
        insertTempSql.append(" sum(balance.fendbalancelocal) fendbalancelocal, ");
        insertTempSql.append(" sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fdebitrpt) fdebitrpt,sum(balance.fyeardebitrpt) fyeardebitrpt, ");
        insertTempSql.append(" sum(balance.fcreditrpt) fcreditrpt,sum(balance.fyearcreditrpt) fyearcreditrpt, ");
        insertTempSql.append(" sum(balance.fendbalancerpt) fendbalancerpt,");
        insertTempSql.append(" sum(balance.fbeginqty) fbeginqty,sum(balance.fdebitqty) fdebitqty,sum(balance.fyeardebitqty) fyeardebitqty, ");
        insertTempSql.append(" sum(balance.fcreditqty) fcreditqty,sum(balance.fyearcreditqty) fyearcreditqty, ");
        insertTempSql.append(" sum(balance.fendqty) fendqty, ");
        insertTempSql.append(" sum(balance.fmonthpnlfor) fmonthpnlfor,sum(balance.fyearpnlfor) fyearpnlfor, ");
        insertTempSql.append(" sum(balance.fmonthpnllocal) fmonthpnllocal,sum(balance.fyearpnllocal) fyearpnllocal, ");
        insertTempSql.append(" sum(balance.fmonthpnlrpt) fmonthpnlrpt,sum(balance.fyearpnlrpt) fyearpnlrpt ");
        insertTempSql.append(" from t_pca_initpcAssistBalance balance ");
        insertTempSql.append(" inner join ").append(assistantHGtmp).append(" hg ");
        insertTempSql.append("   on hg.Foldhgid = balance.FAssistGrpID ");
        insertTempSql.append(" where balance.FAccountID = '" + account + "' ");
        insertTempSql.append(" group by balance.forgunitid, balance.FprofitcenterID,balance.faccountid,balance.fcurrencyid,hg.Fnewhgid ");
        insertTempSql.append(" having count(hg.Fnewhgid) > 1              ");
        DbUtil.execute((Context)ctx, (String)insertTempSql.toString());
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from t_pca_initpcassistbalance balance    ");
        deleteSql.append(" where exists(                             ");
        deleteSql.append(" select * from ").append(assistantHGtmp).append(" hg ");
        deleteSql.append(" where balance.FAccountID = '" + account + "' ");
        deleteSql.append(" and hg.Foldhgid = balance.FAssistGrpID    ");
        deleteSql.append(" )                                         ");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into t_pca_initpcassistbalance ");
        insertSql.append(" (FOrgUnitID,FprofitcenterID, FAccountID, FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt) ");
        insertSql.append(" select FOrgUnitID, FprofitcenterID,FAccountID, FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt ");
        insertSql.append(" from ").append(initAssistBalanceTemp);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(initAssistBalanceTemp);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String createinitAssistBalanceTempTable(Context ctx) throws BOSException {
        String initAssistBalanceTemp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table initAssistBalanceTemp ");
        createTableSql.append(" (FOrgUnitID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FprofitcenterID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FAccountID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FCurrencyID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FAssistGrpID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FBeginBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ");
        createTableSql.append(" )");
        try {
            initAssistBalanceTemp = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            String columns = "FOrgUnitID,FprofitcenterID,FAccountID,FCurrencyID,FAssistGrpID";
            TempTablePool.getInstance((Context)ctx).createIndex(initAssistBalanceTemp, columns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return initAssistBalanceTemp;
    }

    private void unitAssistBalance(Context ctx, String assistantHGtmp, String account) throws BOSException {
        String assistBalanceTemp = this.createAssistBalanceTempTable(ctx);
        StringBuffer insertTempSql = new StringBuffer();
        insertTempSql.append(" insert into  ").append(assistBalanceTemp);
        insertTempSql.append(" (FBalType,FPERIODYEAR,FPERIODNUMBER,FOrgUnitID,FprofitcenterID,                                                           ");
        insertTempSql.append(" FPeriodID,FAccountID,FCurrencyID,FAssistGrpID,                                                            ");
        insertTempSql.append(" FBeginBalanceFor,FDebitFor,FYearDebitFor,FCreditFor,FYearCreditFor,FEndBalanceFor,                        ");
        insertTempSql.append(" FBeginBalanceLocal,FDebitLocal,FYearDebitLocal,FCreditLocal,FYearCreditLocal,FEndBalanceLocal,            ");
        insertTempSql.append(" FBeginBalanceRpt,FDebitRpt,FYearDebitRpt,FCreditRpt,FYearCreditRpt,FEndBalanceRpt,FBeginQty,FDebitQty,    ");
        insertTempSql.append(" FYearDebitQty,FCreditQty,FYearCreditQty,FEndQty,FMonthPnLFor,FYearPnLFor,FMonthPnLLocal,                  ");
        insertTempSql.append(" FYearPnLLocal,FMonthPnLRpt,FYearPnLRpt)                                                                   ");
        insertTempSql.append(" select balance.FBalType,balance.FPERIODYEAR,balance.FPERIODNUMBER,                                        ");
        insertTempSql.append(" balance.forgunitid,balance.FprofitcenterID,balance.FPeriodID,balance.faccountid,balance.fcurrencyid, hg.Fnewhgid,                 ");
        insertTempSql.append(" sum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fdebitfor) fdebitfor,                          ");
        insertTempSql.append(" sum(balance.fyeardebitfor) fyeardebitfor,                                                                 ");
        insertTempSql.append(" sum(balance.fcreditfor) fcreditfor,sum(balance.fyearcreditfor) fyearcreditfor,                            ");
        insertTempSql.append(" sum(balance.fendbalancefor) fendbalancefor,                                                               ");
        insertTempSql.append(" sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fdebitlocal) fdebitlocal,                  ");
        insertTempSql.append(" sum(balance.fyeardebitLocal) fyeardebitLocal,                                                             ");
        insertTempSql.append(" sum(balance.fcreditlocal) fcreditlocal,sum(balance.fyearcreditLocal) fyearcreditLocal,                    ");
        insertTempSql.append(" sum(balance.fendbalancelocal) fendbalancelocal,                                                           ");
        insertTempSql.append(" sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fdebitrpt) fdebitrpt,                          ");
        insertTempSql.append(" sum(balance.fyeardebitrpt) fyeardebitrpt,                                                                 ");
        insertTempSql.append(" sum(balance.fcreditrpt) fcreditrpt,sum(balance.fyearcreditrpt) fyearcreditrpt,                            ");
        insertTempSql.append(" sum(balance.fendbalancerpt) fendbalancerpt,                                                               ");
        insertTempSql.append(" sum(balance.fbeginqty) fbeginqty,sum(balance.fdebitqty) fdebitqty,                                        ");
        insertTempSql.append(" sum(balance.fyeardebitqty) fyeardebitqty,                                                                 ");
        insertTempSql.append(" sum(balance.fcreditqty) fcreditqty,sum(balance.fyearcreditqty) fyearcreditqty,                            ");
        insertTempSql.append(" sum(balance.fendqty) fendqty,                                                                             ");
        insertTempSql.append(" sum(balance.fmonthpnlfor) fmonthpnlfor,sum(balance.fyearpnlfor) fyearpnlfor,                              ");
        insertTempSql.append(" sum(balance.fmonthpnllocal) fmonthpnllocal,sum(balance.fyearpnllocal) fyearpnllocal,                      ");
        insertTempSql.append(" sum(balance.fmonthpnlrpt)fmonthpnlrpt,sum(balance.fyearpnlrpt) fyearpnlrpt                                ");
        insertTempSql.append(" from t_pca_pcAssistBalance balance                                                                           ");
        insertTempSql.append(" inner join ").append(assistantHGtmp).append(" hg ");
        insertTempSql.append("   on hg.Foldhgid = balance.FAssistGrpID ");
        insertTempSql.append(" where balance.FAccountID = '" + account + "' and hg.Foldhgid = balance.FAssistGrpID ");
        insertTempSql.append(" group by balance.FBalType,balance.forgunitid,balance.FprofitcenterID,balance.FPeriodID,                                           ");
        insertTempSql.append(" balance.faccountid,balance.fcurrencyid,balance.FPERIODYEAR,balance.FPERIODNUMBER,hg.Fnewhgid              ");
        insertTempSql.append(" having count(hg.Fnewhgid) > 1              ");
        DbUtil.execute((Context)ctx, (String)insertTempSql.toString());
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from t_pca_pcAssistBalance balance    ");
        deleteSql.append(" where exists(                             ");
        deleteSql.append(" select * from ").append(assistantHGtmp).append(" hg ");
        deleteSql.append(" where balance.FAccountID = '" + account + "' ");
        deleteSql.append(" and hg.Foldhgid = balance.FAssistGrpID    ");
        deleteSql.append(" )                                         ");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into  t_pca_pcAssistBalance(FBalType,FPERIODYEAR,FPERIODNUMBER,FOrgUnitID,FprofitcenterID, ");
        insertSql.append(" FPeriodID,FAccountID,FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor,FYearDebitFor,FCreditFor,FYearCreditFor,FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal,FYearDebitLocal,FCreditLocal,FYearCreditLocal,FEndBalanceLocal, ");
        insertSql.append(" FBeginBalanceRpt,FDebitRpt,FYearDebitRpt,FCreditRpt,FYearCreditRpt,FEndBalanceRpt,FBeginQty,FDebitQty, ");
        insertSql.append(" FYearDebitQty,FCreditQty,FYearCreditQty,FEndQty,FMonthPnLFor,FYearPnLFor,FMonthPnLLocal, ");
        insertSql.append(" FYearPnLLocal,FMonthPnLRpt,FYearPnLRpt) ");
        insertSql.append(" select FBalType,FPERIODYEAR,FPERIODNUMBER,FOrgUnitID,FprofitcenterID, ");
        insertSql.append(" FPeriodID,FAccountID,FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor,FYearDebitFor,FCreditFor,FYearCreditFor,FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal,FYearDebitLocal,FCreditLocal,FYearCreditLocal,FEndBalanceLocal, ");
        insertSql.append(" FBeginBalanceRpt,FDebitRpt,FYearDebitRpt,FCreditRpt,FYearCreditRpt,FEndBalanceRpt,FBeginQty,FDebitQty, ");
        insertSql.append(" FYearDebitQty,FCreditQty,FYearCreditQty,FEndQty,FMonthPnLFor,FYearPnLFor,FMonthPnLLocal, ");
        insertSql.append(" FYearPnLLocal,FMonthPnLRpt,FYearPnLRpt ");
        insertSql.append(" from ").append(assistBalanceTemp);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistBalanceTemp);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String createAssistBalanceTempTable(Context ctx) throws BOSException {
        String assistBalanceTemp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table assistBalanceTemp ");
        createTableSql.append(" (FBalType INT NOT NULL ,                                                                   ");
        createTableSql.append(" fperiodyear decimal(4) default 1900 not null,                                                                              ");
        createTableSql.append(" fperiodnumber decimal(2) default 0 not null,                                                                               ");
        createTableSql.append(" FOrgUnitID VARCHAR(44) NOT NULL ,                                                                                           ");
        createTableSql.append(" FprofitcenterID VARCHAR(44) NOT NULL ,                                                                                           ");
        createTableSql.append(" FPeriodID VARCHAR(44) NOT NULL ,                                                                                            ");
        createTableSql.append(" FAccountID VARCHAR(44) NOT NULL ,                                                                                           ");
        createTableSql.append(" FCurrencyID VARCHAR(44) NOT NULL ,                                                                                          ");
        createTableSql.append(" FAssistGrpID VARCHAR(44) NOT NULL ,                                                                                         ");
        createTableSql.append(" FBeginBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                         ");
        createTableSql.append(" FDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                                ");
        createTableSql.append(" FYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                            ");
        createTableSql.append(" FCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                               ");
        createTableSql.append(" FYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                       ");
        createTableSql.append(" FDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                              ");
        createTableSql.append(" FYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                          ");
        createTableSql.append(" FCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                             ");
        createTableSql.append(" FYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                         ");
        createTableSql.append(" FEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                         ");
        createTableSql.append(" FBeginBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                         ");
        createTableSql.append(" FDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                                ");
        createTableSql.append(" FYearDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                            ");
        createTableSql.append(" FCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                               ");
        createTableSql.append(" FYearCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FEndBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FBeginQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                               ");
        createTableSql.append(" FDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                               ");
        createTableSql.append(" FYearDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                              ");
        createTableSql.append(" FYearCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                          ");
        createTableSql.append(" FEndQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,                                                                                 ");
        createTableSql.append(" FMonthPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                             ");
        createTableSql.append(" FYearPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                              ");
        createTableSql.append(" FMonthPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                           ");
        createTableSql.append(" FYearPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                            ");
        createTableSql.append(" FMonthPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,                                                                             ");
        createTableSql.append(" FYearPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL                                                                         ");
        createTableSql.append(")");
        try {
            assistBalanceTemp = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            String columns = "FAccountID,FOrgUnitID,FprofitcenterID,FPeriodID,FBalType,FCurrencyID,FAssistGrpID";
            TempTablePool.getInstance((Context)ctx).createIndex(assistBalanceTemp, columns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return assistBalanceTemp;
    }

    public void init(Context ctx, AsstAccountChangeInfo change, Map defaultVal) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.change = change;
        if (change.getAfter() != null) {
            this.newCaa = change.getAfter().getId().toString();
        }
        if (change.getBefore() != null) {
            this.oldCaa = change.getBefore().getId().toString();
        }
        this.isNew = false;
        if (this.oldCaa == null && this.newCaa != null) {
            this.isNew = true;
        }
        this.initParam(ctx, this.newCaa, defaultVal, this.isNew, change.getAccount());
    }

    public void check() throws BOSException, EASBizException {
    }

    public void change() throws BOSException, EASBizException {
        if (!this.accountViewInfo.isIsLeaf() || !this.accountViewInfo.getCompanyID().isIsBizUnit()) {
            return;
        }
        this.dealInitBizData();
        this.dealVoucherAssistRecord();
        this.dealAssistBalance();
    }

    private AsstActTypeCollection getAsstActTypes(String caaId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        return asstActTypes;
    }

    public String requestMutex() throws BOSException {
        String companyId = this.accountViewInfo.getCompanyID().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        MutexParameter mp = PCAMutexUtils.buildModifyBalanceParameter(this.ctx, companyId, userId, "GL_AsstAccountChange");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        boolean isLockSucceed = mutex.requestMutex(mp);
        if (isLockSucceed) {
            this.requestId = mp.getRequestId();
            return null;
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"HAS_BUSINESS_NOT_CHANGE", (Locale)this.ctx.getLocale());
    }

    public void releaseMutex() {
        if (this.requestId == null) {
            return;
        }
        try {
            MutexServiceControlFactory.getLocalInstance((Context)this.ctx).releaseMutex(this.requestId);
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }
}

