/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeReferenceCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeReferenceFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeReference;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistTransTypeEnum;
import com.kingdee.eas.fi.gl.AutoTransDataSource;
import com.kingdee.eas.fi.gl.AutoTransEntryDC;
import com.kingdee.eas.fi.gl.AutoTransException;
import com.kingdee.eas.fi.gl.AutoTransSorterEnum;
import com.kingdee.eas.fi.gl.AutoTransType;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.pca.AbstractPcAutoTransEntryInfo;
import com.kingdee.eas.ma.pca.PcAssistRepordEntryCollection;
import com.kingdee.eas.ma.pca.PcAssistRepordEntryInfo;
import com.kingdee.eas.ma.pca.PcAutoTransAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcAutoTransAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcAutoTransCollection;
import com.kingdee.eas.ma.pca.PcAutoTransEntryCollection;
import com.kingdee.eas.ma.pca.PcAutoTransEntryInfo;
import com.kingdee.eas.ma.pca.PcAutoTransFactory;
import com.kingdee.eas.ma.pca.PcAutoTransInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PcaAutoTransDataImport
extends AbstractDataTransmission {
    private static final String RES_PATH = "com.kingdee.eas.fi.gl.AutoTransResource";
    private static final int PER_PRECISION = 2;
    private static final int STR_LENGTH = 80;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final BigDecimal HUNDRED = new BigDecimal("100.00");
    protected HashMap hmDynamicColumnInfo = new HashMap();
    private PcAutoTransCollection autoTransColl;
    private VoucherTypeCollection voucherTypeColl;
    private AsstActTypeCollection actTypeColl;
    private AccountViewCollection accountColl;
    private MeasureUnitCollection muColl;
    private CurrencyCollection currencyColl;
    private HashMap asstItemMap = new HashMap();
    private CompanyOrgUnitInfo company;
    private ProfitCenterOrgUnitInfo profitCenter;
    private String companyNumber = null;
    private String profitCenterNumber = null;

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.company = new CompanyOrgUnitInfo();
        this.profitCenter = new ProfitCenterOrgUnitInfo();
        this.voucherTypeColl = null;
        Hashtable firstData = (Hashtable)hsData.get(new Integer(0));
        String number = this.getString(firstData, "number");
        this.profitCenterNumber = this.getString(firstData, "profitCenter.number");
        PcAutoTransInfo autoTransInfo = new PcAutoTransInfo();
        try {
            this.checkCompanyNumber(ctx, this.profitCenterNumber, autoTransInfo);
            this.checkNumberAndCompany(ctx, number.trim(), this.profitCenterNumber);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = PcaUtils.getProfitCenterSic();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.profitCenterNumber));
        try {
            ProfitCenterOrgUnitCollection pcc = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(view);
            for (int i = 0; i < pcc.size(); ++i) {
                if (!pcc.get(i).getNumber().equals(this.profitCenterNumber)) continue;
                this.profitCenter = pcc.get(i);
                break;
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            if (!permission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.profitCenter.getId().toString()), "pca_autoTrans_addNew")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"NO_AUTOTRANS_PRE", (Locale)ctx.getLocale()));
            }
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        try {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(this.profitCenter.getId().toString());
            HashSet<String> companyIds = new HashSet<String>();
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("toUnit.id");
            view.setSelector(selector);
            IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                companyIds.add(coll.get(i).getToUnit().getId().toString());
            }
            String companyId = null;
            Iterator it = companyIds.iterator();
            if (!it.hasNext()) {
                return null;
            }
            companyId = (String)it.next();
            this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), PcaUtils.getCompanySic());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        autoTransInfo.setNumber(number.trim());
        String name = this.getString(firstData, "name");
        if (name == null || name.trim().length() == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"noName", (Locale)ctx.getLocale()));
        }
        if (name.trim().length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"nameLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        autoTransInfo.setName(name.trim());
        String desc = this.getString(firstData, "description");
        if (desc.length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"descLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        autoTransInfo.setDescription(desc);
        String voucherTypeNumber = this.getString(firstData, "voucherType.number");
        try {
            autoTransInfo.setVoucherType(this.getVoucherTypeInfo(ctx, voucherTypeNumber));
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        String transferType = this.getString(firstData, "transferType");
        AutoTransType autoTransType = AutoTransType.NORMAL;
        if (transferType != null && transferType.trim().length() > 0) {
            try {
                autoTransType = AutoTransType.getEnum((int)Integer.parseInt(transferType.trim()));
            }
            catch (NumberFormatException ex) {
                autoTransType = null;
            }
            if (autoTransType == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res18", (Locale)ctx.getLocale()) + transferType.trim());
            }
        }
        autoTransInfo.setTransferType(autoTransType);
        String tmpValue = this.getString(firstData, "attachments");
        int attachments = 0;
        if (tmpValue != null && tmpValue.trim().length() > 0) {
            try {
                attachments = Integer.parseInt(tmpValue);
            }
            catch (NumberFormatException ex) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res20", (Locale)ctx.getLocale()), (Throwable)ex);
            }
        }
        if (attachments < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res19", (Locale)ctx.getLocale()));
        }
        autoTransInfo.setAttachments(attachments);
        String strSort = this.getString(firstData, "voucherEntrySort");
        AutoTransSorterEnum sortEnum = AutoTransSorterEnum.ORIGINAL;
        if (strSort != null && strSort.trim().length() > 0) {
            try {
                sortEnum = AutoTransSorterEnum.getEnum((int)Integer.parseInt(strSort.trim()));
            }
            catch (NumberFormatException ex) {
                sortEnum = null;
            }
            if (sortEnum == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res27", (Locale)ctx.getLocale()) + strSort.trim());
            }
        }
        autoTransInfo.setVoucherEntrySort(sortEnum);
        for (int i = 0; i < hsData.size(); ++i) {
            AbstractPcAutoTransEntryInfo entryInfo;
            PcAutoTransEntryCollection autoTransEntryColl;
            int entrySeq;
            Hashtable data;
            block39: {
                block38: {
                    data = (Hashtable)hsData.get(new Integer(i));
                    entrySeq = 1;
                    tmpValue = this.getString(data, "entry.seq");
                    autoTransEntryColl = autoTransInfo.getAutoTransEntries();
                    entryInfo = null;
                    if (tmpValue != null && tmpValue.trim().length() != 0) break block38;
                    if (autoTransEntryColl.size() <= 0) break block39;
                    entryInfo = autoTransEntryColl.get(autoTransEntryColl.size() - 1);
                    break block39;
                }
                try {
                    entrySeq = Integer.parseInt(tmpValue);
                }
                catch (NumberFormatException ex) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res21", (Locale)ctx.getLocale()), (Throwable)ex);
                }
                if (entrySeq < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res21", (Locale)ctx.getLocale()));
                }
                for (int j = 0; j < autoTransEntryColl.size(); ++j) {
                    if (autoTransEntryColl.get(j).getSeq() != entrySeq) continue;
                    entryInfo = autoTransEntryColl.get(j);
                    break;
                }
            }
            if (entryInfo == null) {
                entryInfo = new PcAutoTransEntryInfo();
                entryInfo.setSeq(entrySeq);
                autoTransEntryColl.add((PcAutoTransEntryInfo)entryInfo);
                entryInfo.setAutoTrans(autoTransInfo);
                ((PcAutoTransEntryInfo)entryInfo).setOprStatus(1);
                this.fillAutoTransEntryInfo(ctx, data, (PcAutoTransEntryInfo)entryInfo);
            }
            if (entryInfo.getAccount().getCAA() == null && !entryInfo.getAccount().isHasUserProperty()) continue;
            PcAutoTransAssistRecordCollection recordColl = entryInfo.getAutoTransAssistRecords();
            PcAutoTransAssistRecordInfo recordInfo = new PcAutoTransAssistRecordInfo();
            recordInfo.setSeq(recordColl.size());
            recordColl.add(recordInfo);
            recordInfo.setAutoTrans(autoTransInfo);
            recordInfo.setAutoTransEntry((PcAutoTransEntryInfo)entryInfo);
            this.fillAutoTransAssistRecordInfo(ctx, data, (PcAutoTransEntryInfo)entryInfo, recordInfo);
            recordInfo.setOprStatus(1);
        }
        this.verifyData(ctx, autoTransInfo);
        autoTransInfo.setCompany(this.company);
        return autoTransInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            String[] field = new String[]{"profitCenter.number", "name", "description", "voucherType.number", "transferType", "attachments", "voucherEntrySort", "entry.seq", "entry.description", "entry.account.number", "entry.currency.number", "entry.autoTransDCType", "entry.hasPostVoucher", "entry.dataSourceType", "entry.AssistTransType", "entry.measureUnit.number", "entry.amountFormula", "entry.quantityFormula", "entry.caa.description", "entry.caa.measureUnit.number", "entry.caa.amountFormula", "entry.caa.quantityFormula"};
            Hashtable<String, String> result = new Hashtable<String, String>();
            String number = rs.getString("number");
            result.put("number", number);
            BigDecimal entryFpercent = rs.getBigDecimal("entry.Fpercent");
            result.put("entry.Fpercent", entryFpercent == null ? "" : entryFpercent.setScale(2).toString());
            BigDecimal entryCaaFpercent = rs.getBigDecimal("entry.caa.Fpercent");
            result.put("entry.caa.Fpercent", entryCaaFpercent == null ? "" : entryCaaFpercent.setScale(2).toString());
            for (int i = 0; i < field.length; ++i) {
                Object tmpValue = rs.getObject(field[i]);
                String value = tmpValue == null ? "" : tmpValue.toString();
                result.put(field[i], value);
            }
            String assistItemID = rs.getString("entry.caa.assistItem.id");
            if (assistItemID != null) {
                int entrySeq = rs.getInt("entry.seq");
                int entryCaaSeq = rs.getInt("entry.caa.seq");
                int seq = rs.getInt("entry.caa.assistItem.seq");
                int index = seq + 1;
                String asstActTypeName = rs.getString("entry.caa.acctType.name");
                if (asstActTypeName == null) {
                    asstActTypeName = "";
                }
                result.put("entry.caa.asstActType" + index, asstActTypeName);
                String fromTo = rs.getString("entry.caa.assistItem.acctFromTo");
                if (fromTo != null) {
                    result.put("entry.caa.assistItem" + index, fromTo);
                }
                while (rs.next() && rs.getString("number").equals(number) && rs.getInt("entry.seq") == entrySeq && rs.getInt("entry.caa.seq") == entryCaaSeq) {
                    ++index;
                    asstActTypeName = rs.getString("entry.caa.acctType.name");
                    if (asstActTypeName == null) {
                        asstActTypeName = "";
                    }
                    Set<String> set = result.keySet();
                    Iterator<String> it = set.iterator();
                    boolean bool = false;
                    while (it.hasNext()) {
                        String value;
                        String key = it.next();
                        if (null == result.get(key) || key.replaceAll("entry.caa.asstActType", "").length() >= key.length() || null == (value = result.get(key).toString()) || !value.trim().equals(asstActTypeName.trim())) continue;
                        bool = true;
                    }
                    if (bool) continue;
                    result.put("entry.caa.asstActType" + index, asstActTypeName);
                    fromTo = rs.getString("entry.caa.assistItem.acctFromTo");
                    if (fromTo == null) continue;
                    result.put("entry.caa.assistItem" + index, fromTo);
                }
                rs.previous();
            }
            return this.clearAsstact(result);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable<String, String> clearAsstact(Hashtable<String, String> result) {
        Set<String> set = result.keySet();
        Iterator<String> it = set.iterator();
        String key = null;
        String value = null;
        LinkedList<String> needClearTypeKeys = new LinkedList<String>();
        LinkedList<String> needCleatNumberKeys = new LinkedList<String>();
        while (it.hasNext()) {
            String obj = it.next();
            if (null != obj) {
                key = obj.toString();
            }
            if (null != result.get(key)) {
                value = result.get(key);
            }
            if (null != key && key.replaceAll("entry.caa.asstActType", "").length() < key.length()) {
                needClearTypeKeys.add(key + "\t" + value);
            }
            if (null == key || key.replaceAll("entry.caa.assistItem", "").length() >= key.length()) continue;
            needCleatNumberKeys.add(key + "\t" + value);
        }
        for (String needClearTypeKey : needClearTypeKeys) {
            result.remove(needClearTypeKey.split("\t")[0]);
        }
        for (String needClearTypeKey : needCleatNumberKeys) {
            result.remove(needClearTypeKey.split("\t")[0]);
        }
        for (int i = 0; i < needClearTypeKeys.size(); ++i) {
            String type_key_values = (String)needClearTypeKeys.get(i);
            String[] type_key_value = type_key_values.split("\t");
            String type_newvalue = type_key_value[1];
            result.put("entry.caa.asstActType" + (i + 1), type_newvalue);
        }
        for (int j = 0; j < needCleatNumberKeys.size(); ++j) {
            String number_key_values = (String)needCleatNumberKeys.get(j);
            String[] number_key_value = number_key_values.split("\t");
            String number_newvalue = number_key_value[1];
            result.put("entry.caa.assistItem" + (j + 1), number_newvalue);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        String profitCenterId = paramMap.get("profitCenterIds").toString();
        HashSet profitCenterIds = new HashSet();
        profitCenterIds.addAll(Arrays.asList((Object[])profitCenterId.split(",")));
        String selectedRows = null;
        HashSet selectedIds = new HashSet();
        if (paramMap.get("selectedRows") != null) {
            selectedRows = paramMap.get("selectedRows").toString();
            selectedIds.addAll(Arrays.asList((Object[])selectedRows.split(",")));
        }
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", profitCenterIds, CompareType.INCLUDE));
        if (selectedRows != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ma.pca.app.PcAutoTransExportQuery";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PcAutoTransFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currenctData) {
        String number = this.getString(currenctData, "number");
        String profitCenterNumber = this.getString(currenctData, "profitCenter.number");
        if (number == null || number.trim().length() == 0 || profitCenterNumber == null || profitCenterNumber.trim().length() == 0) {
            return true;
        }
        return number.equals(this.getString(firstData, "number")) && profitCenterNumber.equals(this.getString(firstData, "profitCenter.number"));
    }

    private void verifyData(Context ctx, PcAutoTransInfo autoTransInfo) throws TaskExternalException {
        int entrysNum = autoTransInfo.getAutoTransEntries().size();
        if (entrysNum == 0) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"missingEntries"));
        }
        if (entrysNum < 2) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"missingEntriesCount"));
        }
        for (int i = 0; i < entrysNum; ++i) {
            this.checkEntry(ctx, autoTransInfo, i);
        }
        BigDecimal inPercent = ZERO;
        BigDecimal remianTranInPercent = ZERO;
        BigDecimal percent = ZERO;
        boolean hasTransIn = false;
        boolean hasTransOut = false;
        block7: for (int i = 0; i < entrysNum; ++i) {
            PcAutoTransEntryInfo entry = autoTransInfo.getAutoTransEntries().get(i);
            AutoTransDataSource ds = entry.getDataSourceType();
            percent = entry.getFPercent();
            if (percent == null) {
                percent = ZERO;
            }
            switch (ds.getValue()) {
                case 1: {
                    hasTransIn = true;
                    inPercent = inPercent.add(percent).setScale(2);
                    continue block7;
                }
                case 7: {
                    hasTransIn = true;
                    remianTranInPercent = remianTranInPercent.add(percent).setScale(2);
                    continue block7;
                }
                case 6: {
                    hasTransIn = true;
                    continue block7;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    hasTransOut = true;
                }
            }
        }
        if (!hasTransIn) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"missingInEntry"));
        }
        if (!hasTransOut) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"missingOutEntry"));
        }
        if (!this.isFormulaTransIn(autoTransInfo) && !this.isRemainTransIn(autoTransInfo) && inPercent.compareTo(HUNDRED) != 0) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"errSumEntryPercent"));
        }
        if (this.isRemainTransIn(autoTransInfo) && remianTranInPercent.compareTo(HUNDRED) != 0) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"errSumRemainInEntryPercent"));
        }
    }

    private void checkEntry(Context ctx, PcAutoTransInfo autoTransInfo, int rowIndex) throws TaskExternalException {
        PcAutoTransEntryInfo entry = autoTransInfo.getAutoTransEntries().get(rowIndex);
        AccountViewInfo acc = entry.getAccount();
        if (!(acc.isIsLeaf() || AutoTransDataSource.TRANS_INTO != entry.getDataSourceType() && AutoTransDataSource.TRANS_IN_REMAIN != entry.getDataSourceType())) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"autotrans_res13"));
        }
        if (!acc.isIsLeaf() && (AutoTransDataSource.TRANS_OUT_FORMULA.equals((Object)entry.getDataSourceType()) || AutoTransDataSource.TRANS_IN_FORMULA.equals((Object)entry.getDataSourceType()))) {
            throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"autotrans_res12"));
        }
        int recordNum = entry.getAutoTransAssistRecords().size();
        if (recordNum > 0) {
            BigDecimal sumPercent = ZERO;
            for (int i = 0; i < recordNum; ++i) {
                PcAutoTransAssistRecordInfo record = entry.getAutoTransAssistRecords().get(i);
                BigDecimal percent = record.getFPercent();
                if (record.getFPercent() != null) {
                    sumPercent = sumPercent.add(percent).setScale(2);
                }
                if (!acc.isIsCashEquivalent() && !acc.isIsBank() || record.get("accountBank") == null) continue;
                AccountBankInfo accountbank = (AccountBankInfo)record.get("accountBank");
                CurrencyInfo currencyInfo = entry.getCurrency();
                if (currencyInfo == null || !accountbank.isIsByCurrency() || currencyInfo.getId().equals((Object)accountbank.getCurrency().getId())) continue;
                throw new TaskExternalException(new AutoTransException(AutoTransException.NOT_ACCOUNT_CURRENCY, (Object[])new String[]{this.profitCenterNumber, accountbank.getName(), currencyInfo.getName()}).getMessage());
            }
            if (AssistTransTypeEnum.TRANS_AUTO.equals((Object)entry.getAssistTransType()) && recordNum > 1) {
                throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"autotrans_res4"));
            }
            AutoTransDataSource ds = entry.getDataSourceType();
            if ((ds == AutoTransDataSource.TRANS_INTO || ds == AutoTransDataSource.TRANS_IN_REMAIN) && sumPercent.compareTo(HUNDRED) != 0) {
                throw new TaskExternalException(EASResource.getString((String)RES_PATH, (String)"errSumAssistPercent"));
            }
        }
        if (entry.getAssistTransType() == AssistTransTypeEnum.TRANS_AUTO && entry.getDataSourceType() == AutoTransDataSource.TRANS_INTO && entry.getAccount().getCAA() != null) {
            for (int i = 0; i < autoTransInfo.getAutoTransEntries().size(); ++i) {
                PcAutoTransEntryInfo entryInfo = autoTransInfo.getAutoTransEntries().get(i);
                if (entryInfo.getDataSourceType() == AutoTransDataSource.TRANS_INTO) continue;
                PcAutoTransInfo.DynamicColumnInfo[] assItemInCols = (PcAutoTransInfo.DynamicColumnInfo[])this.getCachedColumnInfo(ctx, entry.getAccount())[0];
                ArrayList<PcAutoTransInfo.DynamicColumnInfo> notJoinedType = new ArrayList<PcAutoTransInfo.DynamicColumnInfo>();
                for (int j = 0; j < assItemInCols.length; ++j) {
                    String propName = assItemInCols[j].getMappingPropName();
                    if (entryInfo.getAccount().getCAA() == null) {
                        notJoinedType.add(assItemInCols[j]);
                        continue;
                    }
                    PcAutoTransInfo.DynamicColumnInfo[] assItemOutCols = (PcAutoTransInfo.DynamicColumnInfo[])this.getCachedColumnInfo(ctx, entryInfo.getAccount())[0];
                    boolean joined = false;
                    for (int m = 0; m < assItemOutCols.length; ++m) {
                        if (!assItemOutCols[m].getMappingPropName().equals(propName)) continue;
                        joined = true;
                        break;
                    }
                    if (joined) continue;
                    notJoinedType.add(assItemInCols[j]);
                }
                ArrayList notFilledType = new ArrayList();
                if (notJoinedType.size() > 0) {
                    if (entry.getAutoTransAssistRecords().size() > 0) {
                        for (int j = 0; j < entry.getAutoTransAssistRecords().size(); ++j) {
                            PcAssistRepordEntryCollection rColl = entry.getAutoTransAssistRecords().get(j).getEntry();
                            block5: for (int m = 0; m < notJoinedType.size(); ++m) {
                                for (int n = 0; n < rColl.size(); ++n) {
                                    if (rColl.get(n).getAcctType() == null || !((PcAutoTransInfo.DynamicColumnInfo)notJoinedType.get(m)).getMappingPropName().equals(rColl.get(n).getAcctType().getAsstHGAttribute())) continue;
                                    if (rColl.get(n).getAcctFromTo() != null && rColl.get(n).getAcctFromTo().trim().length() != 0) continue block5;
                                    notFilledType.add(notJoinedType.get(m));
                                    continue block5;
                                }
                            }
                        }
                    } else {
                        notFilledType = notJoinedType;
                    }
                }
                if (notFilledType.size() <= 0) continue;
                String asstTypeNames = "";
                for (int k = 0; k < notFilledType.size(); ++k) {
                    asstTypeNames = asstTypeNames + "\u3001\"" + ((PcAutoTransInfo.DynamicColumnInfo)notFilledType.get(k)).getColName() + "\"";
                }
                AutoTransException ex = new AutoTransException(AutoTransException.MISSASSTACTTYPE, (Object[])new String[]{String.valueOf(rowIndex + 1), String.valueOf(i + 1), asstTypeNames.substring(1)});
                String title = ResourceBase.getString((String)RES_PATH, (String)"title", (Locale)ctx.getLocale());
                throw new TaskExternalException(title + autoTransInfo.getNumber() + ex.getMessage());
            }
        }
    }

    public Object[] getCachedColumnInfo(Context ctx, AccountViewInfo acc) throws TaskExternalException {
        String accId = acc.getId().toString();
        Object[] colInfo = (Object[])this.hmDynamicColumnInfo.get(accId);
        if (colInfo == null) {
            AsstAccountInfo typeGroup = acc.getCAA();
            String typeGroupId = null;
            if (typeGroup != null) {
                typeGroupId = typeGroup.get("id").toString();
            }
            String accountId = null;
            if (acc.isHasUserProperty()) {
                accountId = accId;
            }
            try {
                colInfo = PcAutoTransFactory.getLocalInstance(ctx).fetchAssColumnInfo(accountId, typeGroupId, null);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.hmDynamicColumnInfo.put(accId, colInfo);
        }
        return colInfo;
    }

    private boolean isFormulaTransIn(PcAutoTransInfo autoTransInfo) {
        for (int i = 0; i < autoTransInfo.getAutoTransEntries().size(); ++i) {
            if (AutoTransDataSource.TRANS_IN_FORMULA != autoTransInfo.getAutoTransEntries().get(i).getDataSourceType()) continue;
            return true;
        }
        return false;
    }

    private boolean isRemainTransIn(PcAutoTransInfo autoTransInfo) {
        for (int i = 0; i < autoTransInfo.getAutoTransEntries().size(); ++i) {
            if (AutoTransDataSource.TRANS_IN_REMAIN != autoTransInfo.getAutoTransEntries().get(i).getDataSourceType()) continue;
            return true;
        }
        return false;
    }

    private void fillAutoTransAssistRecordInfo(Context ctx, Hashtable hsData, PcAutoTransEntryInfo entryInfo, PcAutoTransAssistRecordInfo recordInfo) throws TaskExternalException {
        AsstAccountInfo caa;
        String strMU;
        String caaDesc = this.getString(hsData, "entry.caa.description");
        if (caaDesc != null && caaDesc.length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"caaDescLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        recordInfo.setDescription(caaDesc);
        BigDecimal percent = ZERO;
        String StrPercent = this.getString(hsData, "entry.caa.Fpercent");
        if (StrPercent != null && StrPercent.trim().length() > 0) {
            try {
                percent = new BigDecimal(StrPercent);
            }
            catch (NumberFormatException ex) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res25", (Locale)ctx.getLocale()), (Throwable)ex);
            }
        }
        if (AssistTransTypeEnum.TRANS_SELFDINFINE == entryInfo.getAssistTransType() && (percent.doubleValue() <= 0.0 || percent.doubleValue() > 100.0)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res25", (Locale)ctx.getLocale()));
        }
        recordInfo.setFPercent(percent);
        if ((entryInfo.getDataSourceType() == AutoTransDataSource.TRANS_IN_FORMULA || entryInfo.getDataSourceType() == AutoTransDataSource.TRANS_OUT_FORMULA) && entryInfo.getAccount() != null && entryInfo.getAccount().isIsQty() && entryInfo.getAccount().getCAA() != null && entryInfo.getAccount().getCAA().isIsQty() && (strMU = this.getString(hsData, "entry.caa.measureUnit.number")) != null && strMU.trim().length() > 0) {
            try {
                recordInfo.setMeasureUnit(this.getMeasureUnitInfo(ctx, strMU));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (entryInfo.getDataSourceType() == AutoTransDataSource.TRANS_IN_FORMULA || entryInfo.getDataSourceType() == AutoTransDataSource.TRANS_OUT_FORMULA) {
            String amountFormula = this.getString(hsData, "entry.caa.amountFormula");
            if (amountFormula != null && amountFormula.length() > 1800) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"caaDescLengthMorethan", (Locale)ctx.getLocale()) + 1800);
            }
            recordInfo.setLocalFormula(amountFormula);
            recordInfo.setOriginalFormula(amountFormula);
            recordInfo.setReportingFormula(amountFormula);
            String quantityFormula = this.getString(hsData, "entry.caa.quantityFormula");
            if (quantityFormula != null && quantityFormula.length() > 1800) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"caaDescLengthMorethan", (Locale)ctx.getLocale()) + 1800);
            }
            recordInfo.setQuantityFormula(quantityFormula);
        }
        if ((caa = entryInfo.getAccount().getCAA()) != null) {
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            PcAssistRepordEntryCollection repordColl = recordInfo.getEntry();
            for (int i = 0; i < detailColl.size(); ++i) {
                DataBaseInfo baseInfo;
                DataBaseCollection asstActColl;
                String asstHGAttribute;
                int index = i + 1;
                String typeName = this.getString(hsData, "entry.caa.asstActType" + index);
                AsstActTypeInfo asstActTypeInfo = null;
                try {
                    if (typeName != null && typeName.trim().length() > 0) {
                        asstActTypeInfo = this.getAsstActTypeInfo(ctx, typeName);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                String itemNumber = this.getString(hsData, "entry.caa.assistItem" + index);
                if (AssistTransTypeEnum.TRANS_SELFDINFINE == entryInfo.getAssistTransType()) {
                    if (asstActTypeInfo == null) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"484_AutoTransDataImport", (Locale)ctx.getLocale()));
                    }
                    if (itemNumber == null || itemNumber.trim().length() == 0) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res15", (Locale)ctx.getLocale()));
                    }
                    if ((itemNumber = itemNumber.trim()).length() > 800) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res26", (Locale)ctx.getLocale()));
                    }
                    asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                    asstActColl = (DataBaseCollection)this.asstItemMap.get(asstHGAttribute);
                    if (asstActColl == null) {
                        try {
                            asstActColl = this.getAsstActCollection(ctx, asstActTypeInfo);
                        }
                        catch (Exception e) {
                            throw new TaskExternalException(e.getMessage(), (Throwable)e);
                        }
                    }
                    baseInfo = null;
                    if (asstActColl != null) {
                        baseInfo = asstActTypeInfo.isUseLongNumber() ? (DataBaseInfo)this.findObjectValue((IObjectCollection)asstActColl, "longNumber", itemNumber.replace('.', '!')) : (DataBaseInfo)this.findObjectValue((IObjectCollection)asstActColl, "number", itemNumber);
                    }
                    if (baseInfo == null) {
                        throw new TaskExternalException(new AutoTransException(AutoTransException.NOTFOUNDASST, (Object[])new String[]{itemNumber, asstActTypeInfo.getName()}).getMessage());
                    }
                    if (baseInfo instanceof AccountBankInfo) {
                        recordInfo.put("accountBank", baseInfo);
                    }
                }
                if (AssistTransTypeEnum.TRANS_AUTO == entryInfo.getAssistTransType() && AutoTransDataSource.TRANS_INTO == entryInfo.getDataSourceType() && asstActTypeInfo != null && itemNumber != null && itemNumber.trim().length() > 0) {
                    if ((itemNumber = itemNumber.trim()).length() > 800) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res26", (Locale)ctx.getLocale()));
                    }
                    asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                    asstActColl = (DataBaseCollection)this.asstItemMap.get(asstHGAttribute);
                    if (asstActColl == null) {
                        try {
                            asstActColl = this.getAsstActCollection(ctx, asstActTypeInfo);
                        }
                        catch (Exception e) {
                            throw new TaskExternalException(e.getMessage(), (Throwable)e);
                        }
                        this.asstItemMap.put(asstHGAttribute, asstActColl);
                    }
                    baseInfo = null;
                    if (asstActColl != null) {
                        String[] values = itemNumber.split(":");
                        for (int n = 0; n < values.length; ++n) {
                            String newItemNumber = values[n];
                            baseInfo = asstActTypeInfo.getGlAsstActTypeGrp() != null || "CurProject".equalsIgnoreCase(asstHGAttribute) ? (DataBaseInfo)this.findObjectValue((IObjectCollection)asstActColl, "longNumber", newItemNumber.replace('.', '!')) : (DataBaseInfo)this.findObjectValue((IObjectCollection)asstActColl, "number", newItemNumber);
                            if (baseInfo != null) continue;
                            throw new TaskExternalException(new AutoTransException(AutoTransException.NOTFOUNDASST, (Object[])new String[]{newItemNumber, asstActTypeInfo.getName()}).getMessage());
                        }
                    }
                }
                PcAssistRepordEntryInfo repordInfo = new PcAssistRepordEntryInfo();
                repordInfo.setAcctFromTo(itemNumber);
                repordInfo.put("asstObject", itemNumber);
                repordInfo.setAcctType(asstActTypeInfo);
                repordInfo.setSeq(i);
                repordInfo.setAsstRep(recordInfo);
                repordColl.add(repordInfo);
            }
        }
    }

    private DataBaseCollection getAsstActCollection(Context ctx, AsstActTypeInfo typeInfo) throws Exception {
        String asstHGAttribute = typeInfo.getAsstHGAttribute();
        BOSObjectType type = new AssistantHGInfo().getBOSType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(type);
        PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
        Iterator itr = props.iterator();
        LinkPropertyInfo pi = null;
        DataBaseCollection collection = null;
        while (itr.hasNext()) {
            PropertyInfo p = (PropertyInfo)itr.next();
            if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
            pi = (LinkPropertyInfo)p;
            break;
        }
        if (pi != null) {
            FilterInfo Dfilter;
            EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
            String strFacotry = eobj.getBusinessImplFactory();
            String strImpl = eobj.getBusinessImplName();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            String cuid = this.profitCenter.getCU().getId().toString();
            if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getLocalInstance((Context)ctx), (String)cuid);
                if (Dfilter != null) {
                    filter.mergeFilter(Dfilter, "and");
                }
            } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getLocalInstance((Context)ctx), (String)cuid);
                if (Dfilter != null) {
                    filter.mergeFilter(Dfilter, "and");
                }
            } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
            } else if (typeInfo.isIsMultilevel()) {
                String groupID;
                FilterInfo filter1 = new FilterInfo();
                if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg")) {
                    fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                } else if (typeInfo.getGroupTableName() == null && (typeInfo.getGlAsstActTypeGrp() == null || !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) && !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1))) {
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                } else if (typeInfo.getGlAsstActTypeGrp() != null) {
                    filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    groupID = typeInfo.getGlAsstActTypeGrp().getId().toString();
                    String idCol = GlUtils.getGeneralCollection((Context)ctx, (String)groupID);
                    if (idCol.length() != 0) {
                        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idCol, CompareType.NOTINCLUDE));
                        filter1.setMaskString("#0 or #1");
                    }
                }
                if (typeInfo.getGlAsstActTypeGrp() != null) {
                    groupID = typeInfo.getGlAsstActTypeGrp().getId().toString();
                    fic.add(new FilterItemInfo("group.id", (Object)groupID));
                    filter.mergeFilter(GlUtils.getFilterForGeneral((Context)ctx, (String)groupID), "and");
                }
                if (filter1.getFilterItems().size() > 0) {
                    filter.mergeFilter(filter1, "and");
                }
            }
            String strMethod = "getDataBaseCollection";
            Class[] argTypes = new Class[]{view.getClass()};
            Object[] args = new Object[]{view};
            Object result = RunningBusinessMethod.runLocalMethod((Context)ctx, (String)strFacotry, (String)strImpl, (String)strMethod, (Class[])argTypes, (Object[])args);
            collection = (DataBaseCollection)result;
        }
        return collection;
    }

    private void fillAutoTransEntryInfo(Context ctx, Hashtable hsData, PcAutoTransEntryInfo entryInfo) throws TaskExternalException {
        String strMU;
        AccountViewInfo acc;
        String entryDesc = this.getString(hsData, "entry.description");
        if (entryDesc != null && entryDesc.length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"entryDescLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        entryInfo.setDescription(entryDesc);
        try {
            acc = this.getAccountViewInfo(ctx, this.getString(hsData, "entry.account.number"));
            entryInfo.setAccount(acc);
            entryInfo.setCurrency(this.getCurrencyInfo(ctx, this.getString(hsData, "entry.currency.number")));
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        AutoTransEntryDC dc = AutoTransEntryDC.AUTODC;
        String strDC = this.getString(hsData, "entry.autoTransDCType");
        if (strDC != null && strDC.trim().length() > 0) {
            try {
                dc = AutoTransEntryDC.getEnum((int)Integer.parseInt(strDC.trim()));
            }
            catch (NumberFormatException ex) {
                dc = null;
            }
            if (dc == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res18", (Locale)ctx.getLocale()) + strDC.trim());
            }
        }
        entryInfo.setAutoTransDCType(dc);
        entryInfo.setHasPostVoucher("true".equalsIgnoreCase(this.getString(hsData, "entry.hasPostVoucher")));
        AutoTransDataSource ds = AutoTransDataSource.TRANS_OUT_ENDBAL_BY_RATE;
        String strDS = this.getString(hsData, "entry.dataSourceType");
        if (strDS != null && strDS.trim().length() > 0) {
            try {
                ds = AutoTransDataSource.getEnum((int)Integer.parseInt(strDS.trim()));
            }
            catch (NumberFormatException ex) {
                ds = null;
            }
            if (ds == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res23", (Locale)ctx.getLocale()) + strDS.trim());
            }
        }
        entryInfo.setDataSourceType(ds);
        if ((ds == AutoTransDataSource.TRANS_IN_FORMULA || ds == AutoTransDataSource.TRANS_OUT_FORMULA) && acc != null && acc.isIsQty() && (strMU = this.getString(hsData, "entry.measureUnit.number")) != null && strMU.trim().length() > 0) {
            try {
                entryInfo.setMeasureUnit(this.getMeasureUnitInfo(ctx, strMU));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
            }
        }
        AssistTransTypeEnum type = AssistTransTypeEnum.TRANS_SELFDINFINE;
        String strType = this.getString(hsData, "entry.AssistTransType");
        if (strType != null && strType.trim().length() > 0) {
            try {
                type = AssistTransTypeEnum.getEnum((int)Integer.parseInt(strType.trim()));
            }
            catch (NumberFormatException ex) {
                type = null;
            }
            if (type == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res24", (Locale)ctx.getLocale()) + strType.trim());
            }
        }
        entryInfo.setAssistTransType(type);
        BigDecimal entryPercent = ZERO;
        String entryPer = this.getString(hsData, "entry.Fpercent");
        if (entryPer != null && entryPer.trim().length() > 0) {
            try {
                entryPercent = new BigDecimal(entryPer);
            }
            catch (NumberFormatException ex) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res25", (Locale)ctx.getLocale()), (Throwable)ex);
            }
        }
        if (entryPercent.doubleValue() <= 0.0 || entryPercent.doubleValue() > 100.0) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"autotrans_res25", (Locale)ctx.getLocale()));
        }
        entryInfo.setFPercent(entryPercent.setScale(2, 4));
        if (!(entryInfo.getDataSourceType() != AutoTransDataSource.TRANS_IN_FORMULA && entryInfo.getDataSourceType() != AutoTransDataSource.TRANS_OUT_FORMULA || entryInfo.getAccount().getCAA() != null && entryInfo.getAccount().getCAA().size() != 0)) {
            String amountFormula = this.getString(hsData, "entry.amountFormula");
            if (amountFormula != null && amountFormula.length() > 1800) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"caaDescLengthMorethan", (Locale)ctx.getLocale()) + 1800);
            }
            entryInfo.setLocalFormula(amountFormula);
            entryInfo.setOriginalFormula(amountFormula);
            entryInfo.setReportingFormula(amountFormula);
            String quantityFormula = this.getString(hsData, "entry.quantityFormula");
            if (quantityFormula != null && quantityFormula.length() > 1800) {
                throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"caaDescLengthMorethan", (Locale)ctx.getLocale()) + 1800);
            }
            entryInfo.setQuantityFormula(quantityFormula);
        }
    }

    private VoucherTypeInfo getVoucherTypeInfo(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.trim().length() == 0) {
            throw new AutoTransException(AutoTransException.VOUCHERTYPE_IS_NULL);
        }
        BOSUuid cuID = this.profitCenter.getCU().getId();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filterInfo = new FilterInfo();
        IVoucherType iVoucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
        filterInfo = iVoucherType.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuID.toString()), "id", "adminCU");
        view.setFilter(filterInfo);
        this.voucherTypeColl = iVoucherType.getVoucherTypeCollection(view);
        VoucherTypeInfo voucherType = (VoucherTypeInfo)this.findObjectValue((IObjectCollection)this.voucherTypeColl, "number", number);
        if (voucherType == null) {
            throw new AutoTransException(AutoTransException.NOVOUCHERTYPE, (Object[])new String[]{number});
        }
        return voucherType;
    }

    private void checkNumber(Context ctx, String number) throws BOSException, EASBizException, TaskExternalException {
        PcAutoTransInfo autoTransInfo;
        if (number == null || number.trim().length() == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"noNumber", (Locale)ctx.getLocale()));
        }
        if (number.trim().length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"numberLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        BOSUuid profitCenterID = this.profitCenter.getId();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)profitCenterID.toString()));
        view.setFilter(filterInfo);
        this.autoTransColl = PcAutoTransFactory.getLocalInstance(ctx).getPcAutoTransCollection(view);
        if (!this.isSltImportUpdate() && (autoTransInfo = (PcAutoTransInfo)this.findObjectValue((IObjectCollection)this.autoTransColl, "number", number)) != null) {
            throw new AutoTransException(AutoTransException.EXISTNUMBER, (Object[])new String[]{number});
        }
    }

    private void checkNumberAndCompany(Context ctx, String number, String profitCenterNumber) throws BOSException, EASBizException, TaskExternalException {
        if (number == null || number.trim().length() == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"noNumber", (Locale)ctx.getLocale()));
        }
        if (number.trim().length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)RES_PATH, (String)"numberLengthMorethan", (Locale)ctx.getLocale()) + 80);
        }
        PcAutoTransCollection autoTrans = null;
        if (this.autoTransColl != null) {
            IObjectValue autoTransInfo = this.findObjectValue_validat_Company_number((IObjectCollection)this.autoTransColl, "number", number, "profitCenter.number", profitCenterNumber);
            if (!this.isSltImportUpdate() && autoTransInfo != null) {
                throw new AutoTransException(AutoTransException.COMPANY_NUMBER_EXISTS, (Object[])new String[]{profitCenterNumber, number});
            }
        } else {
            this.autoTransColl = new PcAutoTransCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("profitCenter.number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("profitCenter.number", (Object)profitCenterNumber, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        view.setFilter(filterInfo);
        autoTrans = PcAutoTransFactory.getLocalInstance(ctx).getPcAutoTransCollection(view);
        if (!this.isSltImportUpdate() && autoTrans != null && autoTrans.size() != 0) {
            throw new AutoTransException(AutoTransException.COMPANY_NUMBER_EXISTS, (Object[])new String[]{profitCenterNumber, number});
        }
    }

    private void checkCompanyNumber(Context ctx, String profitCenterNumber, PcAutoTransInfo autoTransInfo) throws BOSException, EASBizException, TaskExternalException {
        ProfitCenterOrgUnitCollection autoTrans = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountTable"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)profitCenterNumber));
        view.setFilter(filterInfo);
        autoTrans = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(view);
        if (autoTrans == null || autoTrans.size() == 0) {
            throw new AutoTransException(AutoTransException.NUMBER_NOTIN_COMPANY, (Object[])new String[]{profitCenterNumber});
        }
        autoTransInfo.setProfitCenter(autoTrans.get(0));
        this.profitCenter = autoTrans.get(0);
    }

    private AsstActTypeInfo getAsstActTypeInfo(Context ctx, String name) throws BOSException, EASBizException {
        AsstActTypeInfo actTypeInfo;
        if (name == null || name.trim().length() == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"484_AutoTransDataImport", (Locale)ctx.getLocale()));
        }
        if (this.actTypeColl == null) {
            this.actTypeColl = this.getAsstActTypeCollection(ctx);
        }
        if ((actTypeInfo = (AsstActTypeInfo)this.findObjectValue((IObjectCollection)this.actTypeColl, "name", name)) == null) {
            throw new AutoTransException(AutoTransException.ASSTACTTYPE_NOTIN_COMPANY, (Object[])new String[]{this.profitCenterNumber, name});
        }
        return actTypeInfo;
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.trim().length() == 0) {
            throw new AutoTransException(AutoTransException.ACCOUNT_IS_NULL);
        }
        BOSUuid cuID = this.company.getId();
        BOSUuid accountTableID = this.company.getAccountTable().getId();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.seq"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.id"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.name"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cuID.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID.toString()));
        filterInfo.setMaskString("#0 and #1");
        view.setFilter(filterInfo);
        this.accountColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        AccountViewInfo account = (AccountViewInfo)this.findObjectValue((IObjectCollection)this.accountColl, "number", number);
        if (account == null) {
            throw new AutoTransException(AutoTransException.ACCOUNT_NOTIN_COMPANY, (Object[])new String[]{this.profitCenterNumber, number});
        }
        return account;
    }

    private MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        this.muColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
        MeasureUnitInfo mu = (MeasureUnitInfo)this.findObjectValue((IObjectCollection)this.muColl, "number", number);
        if (mu == null) {
            throw new AutoTransException(AutoTransException.MEASUREUNIT_NOTIN_COMPANY, (Object[])new String[]{this.profitCenterNumber, number});
        }
        return mu;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.trim().length() == 0) {
            return this.company.getBaseCurrency();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        this.currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        CurrencyInfo currency = (CurrencyInfo)this.findObjectValue((IObjectCollection)this.currencyColl, "number", number);
        if (currency == null) {
            throw new AutoTransException(AutoTransException.CURRENCY_NOTIN_COMPANY, (Object[])new String[]{this.company.getNumber(), number});
        }
        return currency;
    }

    private IObjectValue findObjectValue(IObjectCollection coll, String fieldName, String number) {
        for (int i = 0; i < coll.size(); ++i) {
            ObjectBaseInfo info = (ObjectBaseInfo)coll.getObject(i);
            if (info.getString(fieldName) == null || !info.getString(fieldName).equals(number)) continue;
            return info;
        }
        return null;
    }

    private IObjectValue findObjectValue_validat_Company_number(IObjectCollection coll, String fieldName, String number, String fieldCompanyNumber, String profitCenterNumber) {
        for (int i = 0; i < coll.size(); ++i) {
            ObjectBaseInfo info = (ObjectBaseInfo)coll.getObject(i);
            if (info.getString(fieldName) == null || !info.getString(fieldName).equals(number) || info.getString(fieldCompanyNumber) == null || !info.getString(fieldCompanyNumber).equals(profitCenterNumber)) continue;
            return info;
        }
        return null;
    }

    private String getString(Hashtable values, String key) {
        Object value = values.get(key);
        if (value == null) {
            return null;
        }
        Object obj = ((DataToken)value).data;
        return obj == null ? null : obj.toString();
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (this.isSltImportUpdate()) {
                String number = coreBaseInfo.getString("number");
                PcAutoTransInfo autoTransInfo = (PcAutoTransInfo)this.findObjectValue((IObjectCollection)this.autoTransColl, "number", number);
                StringBuffer buf = new StringBuffer();
                buf.append("select fid ,fnumber,fname from t_pca_pcAutoTrans where fnumber = '").append(number).append("'");
                ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
                IRowSet rs = dataAccess.getRowSet(buf.toString());
                if (rs.next()) {
                    this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PcaResource", (String)"AUTOTRANS_NOT_EXIST", (Locale)ctx.getLocale()));
                }
            }
            this.getController(ctx).submit(coreBaseInfo);
            this.autoTransColl.add((PcAutoTransInfo)coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private AsstActTypeCollection getAsstActTypeCollection(Context ctx) throws BOSException {
        return AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection();
    }

    private AsstActTypeCollection getAsstActTypeCollection2(Context ctx) throws BOSException {
        FilterInfo fi = null;
        String controlType = null;
        String CONTROL_TYPE_NAME = "controlType";
        String CONTROLTYPE_I = "I";
        String FILTERFIELD_CUID = "CU.id";
        String CONTROLTYPE_S4 = "S4";
        String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
        EntityObjectInfo eoi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(AsstActTypeFactory.getLocalInstance((Context)ctx).getType());
        CtrlUnitInfo cui = this.company.getCU();
        String cuid = cui.getId().toString();
        IAsstActType iAsstAct = AsstActTypeFactory.getLocalInstance((Context)ctx);
        if (eoi.containsExtendedPropertyKey(CONTROL_TYPE_NAME)) {
            controlType = eoi.getExtendedProperty(CONTROL_TYPE_NAME);
        }
        if (controlType != null && !controlType.equals("")) {
            FilterItemCollection fic;
            if (controlType.equalsIgnoreCase(CONTROLTYPE_I)) {
                fi = new FilterInfo();
                fic = fi.getFilterItems();
                fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)cuid, CompareType.EQUALS));
            } else if (controlType.equalsIgnoreCase(CONTROLTYPE_S4)) {
                fi = new FilterInfo();
                fic = fi.getFilterItems();
                fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)cuid));
                fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
                fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.NOTEQUALS));
                String ln = cui.getLongNumber();
                String[] lnSecs = ln.split("!");
                int size = lnSecs.length;
                HashSet<String> lnUps = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < size - 1; ++i) {
                    if (i != 0) {
                        sb.append("!");
                    }
                    sb.append(lnSecs[i]);
                    lnUps.add(sb.toString());
                }
                if (lnUps.size() != 0) {
                    fic.add(new FilterItemInfo(FILTERFIELD_CULONGNUMBER, lnUps, CompareType.INCLUDE));
                    fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null));
                    fi.setMaskString("#0 or (#1 and #2 and #3) or (#4 and #5)");
                } else {
                    fi.setMaskString("#0 or (#1 and #2 and #3)");
                }
            }
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.setMaskString("#0 or #1 or #2");
            fi = filter;
        }
        EntityViewInfo acttypeView = new EntityViewInfo();
        acttypeView.getSelector().add(new SelectorItemInfo("*"));
        acttypeView.setFilter(fi);
        AsstActTypeCollection assigns = iAsstAct.getAsstActTypeCollection(acttypeView);
        assigns.addObjectCollection((IObjectCollection)this.getCurrentAssign(ctx));
        assigns.addObjectCollection((IObjectCollection)this.getParentAssign(ctx));
        if (assigns.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < assigns.size(); ++i) {
                set.add(assigns.getObject(i).getBOSUuid("id").toString());
            }
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            acttypeView.setFilter(fi);
            assigns = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(acttypeView);
        }
        return assigns;
    }

    private AsstActTypeCollection getCurrentAssign(Context ctx) throws BOSException {
        FilterInfo filterInfoMerger = new FilterInfo();
        IAsstActTypeReference iAsstActTypeReference = AsstActTypeReferenceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)this.company.getCU().getId().toString()));
        filterInfo.mergeFilter(filterInfoMerger, "and");
        evi.setFilter(filterInfo);
        AsstActTypeReferenceCollection aATRC = iAsstActTypeReference.getAsstActTypeReferenceCollection(evi);
        AsstActTypeCollection aATC = new AsstActTypeCollection();
        if (aATRC.size() > 0) {
            IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evitemp = new EntityViewInfo();
            evitemp.getSelector().add("id");
            evitemp.getSelector().add("number");
            evitemp.getSelector().add("name");
            evitemp.getSelector().add("asstHGAttribute");
            evitemp.getSelector().add("realtionDataObject");
            evitemp.getSelector().add("mappingFieldName");
            evitemp.getSelector().add("isSystemAsstActItem");
            evitemp.getSelector().add("realDataObjAlias");
            evitemp.getSelector().add("CU.name");
            evitemp.getSelector().add("description");
            evitemp.getSelector().add("isQty");
            evitemp.getSelector().add("defaultQueryName");
            evitemp.getSelector().add("defaultF7UI");
            evitemp.getSelector().add("isForCompany");
            evitemp.getSelector().add("glAsstActTypeGrp.id");
            evitemp.getSelector().add("measureUnit.name");
            evitemp.getSelector().add("measureUnitGroup.name");
            FilterInfo filterTemp = new FilterInfo();
            for (int i = 0; i < aATRC.size(); ++i) {
                AsstActTypeCollection aATCTemp = new AsstActTypeCollection();
                FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRC.get(i).getAsstActType().getId().toString());
                filterTemp.getFilterItems().add(filterItem);
                evitemp.setFilter(filterTemp);
                aATCTemp = iAsstActType.getAsstActTypeCollection(evitemp);
                aATC.addObjectCollection((IObjectCollection)aATCTemp);
                filterTemp.getFilterItems().remove(filterItem);
            }
        }
        return aATC;
    }

    private AsstActTypeCollection getParentAssign(Context ctx) throws BOSException {
        FilterInfo filterInfoMerger = new FilterInfo();
        AsstActTypeCollection aATCParent = new AsstActTypeCollection();
        IAsstActTypeReference iAsstActTypeReference = AsstActTypeReferenceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("assignCU.id");
        evi.getSelector().add("assignCU.longnumber");
        evi.getSelector().add("asstActType.id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.level", (Object)new Integer(this.company.getCU().getLevel()), CompareType.LESS));
        filterInfo.mergeFilter(filterInfoMerger, "and");
        evi.setFilter(filterInfo);
        AsstActTypeReferenceCollection aATRC = iAsstActTypeReference.getAsstActTypeReferenceCollection(evi);
        AsstActTypeReferenceCollection aATRCParent = new AsstActTypeReferenceCollection();
        if (aATRC.size() > 0) {
            for (int i = 0; i < aATRC.size(); ++i) {
                if (this.company.getCU().getLongNumber().indexOf(aATRC.get(i).getAssignCU().getLongNumber()) != 0) continue;
                aATRCParent.addObject((IObjectValue)aATRC.get(i));
            }
        }
        if (aATRCParent.size() > 0) {
            IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evitemp = new EntityViewInfo();
            evitemp.getSelector().add("id");
            evitemp.getSelector().add("number");
            evitemp.getSelector().add("name");
            evitemp.getSelector().add("asstHGAttribute");
            evitemp.getSelector().add("realtionDataObject");
            evitemp.getSelector().add("mappingFieldName");
            evitemp.getSelector().add("isSystemAsstActItem");
            evitemp.getSelector().add("realDataObjAlias");
            evitemp.getSelector().add("CU.name");
            evitemp.getSelector().add("description");
            evitemp.getSelector().add("defaultQueryName");
            evitemp.getSelector().add("defaultF7UI");
            evitemp.getSelector().add("isForCompany");
            evitemp.getSelector().add("isQty");
            evitemp.getSelector().add("glAsstActTypeGrp.id");
            evitemp.getSelector().add("cu.longnumber");
            evitemp.getSelector().add("measureUnit.name");
            evitemp.getSelector().add("measureUnitGroup.name");
            FilterInfo filterTemp = new FilterInfo();
            for (int i = 0; i < aATRCParent.size(); ++i) {
                AsstActTypeCollection aATCTemp = new AsstActTypeCollection();
                FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRCParent.get(i).getAsstActType().getId().toString());
                filterTemp.getFilterItems().add(filterItem);
                evitemp.setFilter(filterTemp);
                aATCTemp = iAsstActType.getAsstActTypeCollection(evitemp);
                aATCParent.addObjectCollection((IObjectCollection)aATCTemp);
                filterTemp.getFilterItems().remove(filterItem);
            }
        }
        if (aATCParent.size() > 0) {
            int i;
            AsstActTypeCollection aATCParentTemp = new AsstActTypeCollection();
            for (i = 0; i < aATCParent.size(); ++i) {
                if (this.company.getCU().getLongNumber().toString().indexOf(aATCParent.get(i).getCU().getLongNumber().toString()) != 0) continue;
                aATCParentTemp.addObject((IObjectValue)aATCParent.get(i));
            }
            if (aATCParentTemp.size() > 0) {
                for (i = 0; i < aATCParentTemp.size(); ++i) {
                    aATCParent.removeObject((Object)aATCParentTemp.get(i).getId());
                }
            }
        }
        return aATCParent;
    }
}

