/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.app.AbstractPcaBalanceAnaFacadeControllerBean;
import com.kingdee.eas.ma.pca.app.PcaBalanceRepairer;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PcaBalanceAnaFacadeControllerBean
extends AbstractPcaBalanceAnaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcaBalanceAnaFacadeControllerBean");
    private static final String AnaPosted = "AnaBal_Posted";
    private static final String AnaUnPost = "AnaBal_UnPost";
    private static final String AnaBegin = "AnaBal_Begin";
    private static final String AnaCurrent = "AnaBal_Current";
    private static final String AnaCurrency = "AnaBal_Currency";
    private static final String AnaAccount = "AnaBal_Account";
    private static final String AnaAssist = "AnaBal_Assist";
    private static final String AnaAmt = "AnaBal_CompareAmt";
    private static final String AnaQty = "AnaBal_CompareQty";
    private static final String AnaPNL = "AnaBal_ComparePNL";
    private static final String MaxSize = "AnaBal_MaxSize";

    private List<PeriodInfo> getAnaHistorys(Context ctx, PeriodInfo target, PeriodInfo min, int count) throws BOSException, EASBizException {
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    FID, FNumber, FPeriodYear, FPeriodNumber, FIsAdjustPeriod \n");
            sql.append("from T_BD_Period \n");
            sql.append("where FTypeID = ? \n");
            sql.append("    and FNumber < ? \n");
            sql.append("    and FNumber >= ? \n");
            sql.append("order by FNumber desc \n");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, target.getPeriodType().getId().toString());
            pstmt.setInt(index++, target.getNumber());
            pstmt.setInt(index++, min.getNumber());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setNumber(rs.getInt("FNumber"));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                period.setIsAdjustPeriod(rs.getBoolean("FIsAdjustPeriod"));
                periods.add(period);
                if (periods.size() < count) continue;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    private List<PeriodInfo> getAnaFutures(Context ctx, PeriodInfo target, int count) throws BOSException, EASBizException {
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    FID, FNumber, FPeriodYear, FPeriodNumber, FIsAdjustPeriod \n");
            sql.append("from T_BD_Period \n");
            sql.append("where FTypeID = ? \n");
            sql.append("    and FNumber > ? \n");
            sql.append("order by FNumber asc \n");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, target.getPeriodType().getId().toString());
            pstmt.setInt(index++, target.getNumber());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setNumber(rs.getInt("FNumber"));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                period.setIsAdjustPeriod(rs.getBoolean("FIsAdjustPeriod"));
                periods.add(period);
                if (periods.size() < count) continue;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    @Override
    protected Object _analysis(Context ctx, String profitCenterId, Map params) throws BOSException, EASBizException {
        int iPeriod;
        boolean isUseRpt;
        try {
            Object value = GlUtils.getParamByKey((Context)ctx, null, (String)"G001");
            isUseRpt = Boolean.valueOf(value.toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"G001"});
        }
        params.put("isUseRpt", isUseRpt);
        if (this.isForRepair(params)) {
            params.put("AnaBal_ShowName", false);
        }
        PcaBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{profitCenterId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList errors = new LinkedList();
        result.put("errors", errors);
        PeriodInfo current = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(1006, profitCenterId);
        PeriodInfo start = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitStartPeriod(1006, profitCenterId);
        if (current == null || start == null) {
            return result;
        }
        int cyType = (Integer)params.get(AnaCurrency);
        boolean local = (cyType & 2) != 0;
        boolean report = (cyType & 4) != 0 && isUseRpt;
        Boolean showName = (Boolean)params.get("AnaBal_ShowName");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        if (showName.booleanValue()) {
            selector.add("name");
            selector.add("accountTable.name");
        }
        String companyId = this.queryCompanyId(ctx, profitCenterId);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        params.put("company", company);
        ProfitCenterOrgUnitInfo profitCenter = this.queryProfitCenter(ctx, profitCenterId);
        params.put("profitCenter", profitCenter);
        List<Object> periods = new ArrayList<PeriodInfo>();
        Integer iHistory = (Integer)params.get("AnaBal_Historys");
        if (iHistory != null) {
            int iTemp;
            if (current.getId().equals((Object)start.getId())) {
                periods.add(current);
                iPeriod = 1;
            } else if (iHistory == 0) {
                periods.add(current);
                PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)current);
                if (prePeriod != null && prePeriod.getNumber() >= start.getNumber()) {
                    periods.add(prePeriod);
                }
                iPeriod = 1;
            } else {
                if (iHistory < 0) {
                    iHistory = 12000;
                }
                iPeriod = (periods = this.getAnaHistorys(ctx, current, start, iHistory + 1)).size() > iHistory ? periods.size() - 1 : periods.size();
                periods.add(0, current);
                ++iPeriod;
            }
            int iFuture = 0;
            if (params.get("AnaBal_Futures") != null && (iTemp = ((Integer)params.get("AnaBal_Futures")).intValue()) > 0) {
                iFuture = iTemp;
            }
            if (iFuture > 0) {
                List<PeriodInfo> futures = this.getAnaFutures(ctx, current, iFuture);
                for (PeriodInfo p : futures) {
                    periods.add(0, p);
                }
                iPeriod += futures.size();
            }
        } else {
            PeriodInfo periodFrom = (PeriodInfo)params.get("periodFrom");
            PeriodInfo periodTo = (PeriodInfo)params.get("periodTo");
            periodFrom.setPeriodType(current.getPeriodType());
            periodTo.setPeriodType(current.getPeriodType());
            if (start.getNumber() > periodFrom.getNumber()) {
                periodFrom = start;
            }
            if (periodFrom.getNumber() != periodTo.getNumber()) {
                periods = this.getAnaHistorys(ctx, periodTo, periodFrom, 12000);
            }
            iPeriod = periods.size();
            periods.add(0, periodTo);
            ++iPeriod;
            PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodFrom);
            if (prePeriod != null && prePeriod.getNumber() >= start.getNumber()) {
                periods.add(prePeriod);
            }
        }
        Set accountNumbers = (Set)params.get("accountNumbers");
        List<Map<String, Object>> constrasts = null;
        if (accountNumbers != null && accountNumbers.size() > 0 && (constrasts = PcaBalanceAnaFacadeControllerBean.getAccountRefConstrasts(ctx, companyId, (PeriodInfo)periods.get(iPeriod - 1))).size() > 0) {
            HashMap<String, Object> last = new HashMap<String, Object>();
            last.put("periodNumber", 999913);
            last.put("disableAcctTableID", company.getAccountTable().getId().toString());
            constrasts.add(last);
        }
        HashMap<String, Map<String, Set<String>>> cache = new HashMap<String, Map<String, Set<String>>>();
        Integer maxSize = (Integer)params.get(MaxSize);
        for (int i = 0; i < iPeriod; ++i) {
            PeriodInfo period = (PeriodInfo)periods.get(i);
            PeriodInfo prePeriod = null;
            if (i + 1 < periods.size()) {
                prePeriod = (PeriodInfo)periods.get(i + 1);
            }
            params.put("AnaBal_SubSize", maxSize - errors.size());
            params.put("AnaBal_Future", period.getNumber() > current.getNumber());
            int anaPt = 3;
            if (period.getNumber() < current.getNumber()) {
                anaPt = 1;
                if (period.getNumber() == start.getNumber()) {
                    anaPt = 11;
                }
            } else if (period.getNumber() == current.getNumber()) {
                anaPt = 2;
                if (period.getNumber() == start.getNumber()) {
                    anaPt = 21;
                }
            }
            period.put("anaPt", (Object)anaPt);
            Map<String, Set<String>> map = PcaBalanceAnaFacadeControllerBean.getAccountIds(ctx, company, period, accountNumbers, constrasts, cache);
            Set<String> accountIds = map.get("accountIds");
            Set<String> leafAccountIds = map.get("leafAccountIds");
            if (accountNumbers != null && accountNumbers.size() > 0 && leafAccountIds.size() == 0) continue;
            params.put("accountIds", accountIds);
            params.put("leafAccountIds", leafAccountIds);
            List sub = (List)this.analysisPeriod(ctx, profitCenterId, period, prePeriod, params);
            errors.addAll(sub);
            if (errors.size() >= maxSize) break;
        }
        String companyInfo = profitCenter.getNumber();
        if (showName.booleanValue()) {
            companyInfo = companyInfo + "-" + profitCenter.getName();
        }
        String accountTableInfo = "";
        if (company.getAccountTable() != null) {
            accountTableInfo = company.getAccountTable().getNumber();
            if (showName.booleanValue()) {
                accountTableInfo = accountTableInfo + "-" + company.getAccountTable().getName();
            }
        }
        result.put("company", companyInfo);
        result.put("startPeriod", start.getNumber());
        result.put("currentPeriod", current.getNumber());
        result.put("currentAccountTable", accountTableInfo);
        if (showName.booleanValue() && (local || report)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            sel.add("number");
            sel.add("name");
            view.setSelector(sel);
            FilterInfo filter = new FilterInfo();
            HashSet ids = new HashSet();
            ids.add("11111111-1111-1111-1111-111111111111DEB58FDC");
            ids.add("22222222-2222-2222-2222-222222222222DEB58FDC");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filter);
            CurrencyCollection cys = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            String localInfo = "GLC";
            String reportInfo = "GRC";
            for (int i = 0; i < cys.size(); ++i) {
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cys.get(i).getId().toString())) {
                    localInfo = localInfo + "-" + cys.get(i).getName();
                    continue;
                }
                if (!"22222222-2222-2222-2222-222222222222DEB58FDC".equals(cys.get(i).getId().toString())) continue;
                reportInfo = reportInfo + "-" + cys.get(i).getName();
            }
            for (Map item : errors) {
                if ("GLC".equals(item.get("currency"))) {
                    item.put("currency", localInfo);
                    continue;
                }
                if (!"GRC".equals(item.get("currency"))) continue;
                item.put("currency", reportInfo);
            }
        }
        if (this.isForRepair(params) && errors.size() > 0) {
            HashSet<String> accNumbers = new HashSet<String>();
            int iperiodfrom = 999913;
            int iperiodto = 0;
            for (Map row : errors) {
                int period = (Integer)row.get("period");
                if (period > iperiodto) {
                    iperiodto = period;
                }
                if (period < iperiodfrom) {
                    iperiodfrom = period;
                }
                accNumbers.add((String)row.get("account"));
            }
            if (iperiodto < current.getNumber()) {
                iperiodto = current.getNumber();
            }
            HashMap<String, Object> rparams = new HashMap<String, Object>();
            rparams.put("companyId", company.getId().toString());
            rparams.put("profitCenterId", profitCenter.getId().toString());
            rparams.put("accountNumbers", accNumbers);
            PeriodInfo periodfrom = new PeriodInfo();
            periodfrom.setNumber(iperiodfrom);
            rparams.put("periodfrom", periodfrom);
            PeriodInfo periodto = new PeriodInfo();
            periodto.setNumber(iperiodto);
            rparams.put("periodto", periodto);
            rparams.put("repairAccount", true);
            rparams.put("repairAssist", true);
            rparams.put("repairMeasure", true);
            rparams.put("onlyClean", false);
            rparams.put("isNeedRepair", true);
            return rparams;
        }
        return result;
    }

    private static List<Map<String, Object>> getAccountRefConstrasts(Context ctx, String companyId, PeriodInfo startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  p.FNumber FPeriodNumber, c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("join T_bd_Period p on p.FID = c.FEnabledPeriodID \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        sql.append("  and p.FNumber >= ? \n");
        sql.append("order by p.FNumber \n");
        ArrayList<Map<String, Object>> constrasts = new ArrayList<Map<String, Object>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, startPeriod.getNumber()});
        try {
            while (rs.next()) {
                HashMap<String, Object> constrast = new HashMap<String, Object>();
                constrast.put("periodNumber", rs.getInt("FPeriodNumber"));
                constrast.put("disableAcctTableID", rs.getString("FDisabledAcctTableID"));
                constrasts.add(constrast);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return constrasts;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, String tableId, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        sql.append("where av.FCompanyID = ? \n");
        sql.append("  and av.FAccountTableID = ? \n");
        params.add(companyId);
        params.add(tableId);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
            params.add(accountNumbers.iterator().next());
        } else {
            sql.append("  and av.FNumber in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountNumbers) + " \n");
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("accountIds", accountIds);
        result.put("leafAccountIds", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                accountIds.add(rs.getString("FID"));
                if (rs.getInt("FIsLeaf") != 1) continue;
                leafAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountNumbers, List<Map<String, Object>> constrasts, Map<String, Map<String, Set<String>>> cache) throws BOSException {
        HashSet accountIds = new HashSet();
        HashSet leafAccountIds = new HashSet();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("accountIds", accountIds);
        result.put("leafAccountIds", leafAccountIds);
        if (accountNumbers == null || accountNumbers.size() == 0) {
            return result;
        }
        if (constrasts == null || constrasts.size() == 0) {
            Map<String, Set<String>> iResult = cache.get(company.getAccountTable().getId().toString());
            if (iResult == null) {
                iResult = PcaBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), company.getAccountTable().getId().toString(), accountNumbers);
                cache.put(company.getAccountTable().getId().toString(), iResult);
            }
            return iResult;
        }
        for (int cIndex = 0; cIndex < constrasts.size(); ++cIndex) {
            Map<String, Object> constrast = constrasts.get(cIndex);
            int periodNumber = (Integer)constrast.get("periodNumber");
            if (periodNumber < period.getNumber()) continue;
            String disableAcctTableID = (String)constrast.get("disableAcctTableID");
            Map<String, Set<String>> iResult = cache.get(disableAcctTableID);
            if (iResult == null) {
                iResult = PcaBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), disableAcctTableID, accountNumbers);
                cache.put(disableAcctTableID, iResult);
            }
            if (periodNumber > period.getNumber()) {
                return iResult;
            }
            accountIds.addAll(iResult.get("accountIds"));
            leafAccountIds.addAll(iResult.get("leafAccountIds"));
            if (cIndex + 1 >= constrasts.size()) break;
            constrast = constrasts.get(cIndex + 1);
            disableAcctTableID = (String)constrast.get("disableAcctTableID");
            Map<String, Set<String>> iiResult = cache.get(disableAcctTableID);
            if (iiResult == null) {
                iiResult = PcaBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), disableAcctTableID, accountNumbers);
                cache.put(disableAcctTableID, iiResult);
            }
            accountIds.addAll(iiResult.get("accountIds"));
            leafAccountIds.addAll(iiResult.get("leafAccountIds"));
            break;
        }
        return result;
    }

    private static String toInSql(Set ids) {
        StringBuffer sql = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if ((o = it.next()) instanceof String) {
                sql.append("'").append(o).append("'");
                continue;
            }
            sql.append(o);
        }
        return "(" + sql.toString() + ")";
    }

    private ProfitCenterOrgUnitInfo queryProfitCenter(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        return ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId), selector);
    }

    private String queryCompanyId(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)profitCenterId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("toUnit.id");
        view.setSelector(selector);
        OrgUnitRelationCollection coll = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        if (coll.size() > 0) {
            return coll.get(0).getToUnit().getId().toString();
        }
        return null;
    }

    protected Object analysisPeriod(Context ctx, String profitCenterId, PeriodInfo period, PeriodInfo prePeriod, Map params) throws BOSException, EASBizException {
        Set accountIds = (Set)params.get("accountIds");
        Set leafAccountIds = (Set)params.get("leafAccountIds");
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        try {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.get("company");
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)params.get("profitCenter");
            Boolean anaPosted = (Boolean)params.get(AnaPosted);
            Boolean anaUnPost = (Boolean)params.get(AnaUnPost);
            Boolean anaBegin = (Boolean)params.get(AnaBegin);
            Boolean future = (Boolean)params.get("AnaBal_Future");
            if (future != null && future.booleanValue()) {
                anaBegin = false;
            }
            Boolean anaCurrent = (Boolean)params.get(AnaCurrent);
            boolean isUseRpt = (Boolean)params.get("isUseRpt");
            int cyType = (Integer)params.get(AnaCurrency);
            boolean origin = (cyType & 1) != 0;
            boolean local = (cyType & 2) != 0;
            boolean report = (cyType & 4) != 0 && isUseRpt;
            Boolean showName = (Boolean)params.get("AnaBal_ShowName");
            Boolean anaAccount = (Boolean)params.get(AnaAccount);
            Boolean anaAssist = (Boolean)params.get(AnaAssist);
            Boolean compareAmt = (Boolean)params.get(AnaAmt);
            Boolean compareQty = (Boolean)params.get(AnaQty);
            Boolean comparePNL = (Boolean)params.get(AnaPNL);
            int compareType = 3;
            if (((Boolean)params.get("AnaBal_CompareFwd")).booleanValue()) {
                compareType = 1;
            } else if (((Boolean)params.get("AnaBal_CompareRev")).booleanValue()) {
                compareType = 2;
            }
            Integer maxSize = (Integer)params.get("AnaBal_SubSize");
            boolean isForRepair = this.isForRepair(params);
            if (anaPosted.booleanValue()) {
                if (anaAccount.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 5, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 5, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
                if (anaAssist.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 5, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 5, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
            }
            if (anaUnPost.booleanValue()) {
                if (anaAccount.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAccountBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 1, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 1, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAccountCurrent2(ctx, profitCenter, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, profitCenter, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
                if (anaAssist.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAssistBegin2(ctx, profitCenter, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, profitCenter, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 1, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 1, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.analysisAssistCurrent2(ctx, profitCenter, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, profitCenter, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountBegin(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAccountStartBegin(ctx, profitCenter, period, accountIds, balType, cyId, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " cur \n");
                sql.append("join T_BD_AccountView av on av.FID = cur.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = cur.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " pre \n");
                sql.append("    on cur.FProfitCenterID = pre.FProfitCenterID \n");
                sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and pre.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where cur.FProfitCenterID = ? \n");
                sql.append("    and cur.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and cur.FAccountID = ? \n");
                    } else {
                        sql.append("  and cur.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " pre \n");
                sql.append("join T_BD_AccountView av on av.FID = pre.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = pre.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " cur \n");
                sql.append("    on cur.FProfitCenterID = pre.FProfitCenterID \n");
                sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and cur.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where pre.FProfitCenterID = ? \n");
                sql.append("    and pre.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and pre.FAccountID = ? \n");
                    } else {
                        sql.append("  and pre.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setInt(index++, prePeriod.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, prePeriod.getNumber());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountBegin2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAccountStartBegin2(ctx, profitCenter, period, accountIds, balType, cyId, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, \n");
            sql.append("        FAccountID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FBeginBalance" + suffix + ", FBeginQty \n");
            sql.append("    from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and FAccountID = ? \n");
                } else {
                    sql.append("        and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") cur \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, \n");
            sql.append("        FAccountID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FEndBalance" + suffix + ", FEndQty \n");
            sql.append("    from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and FAccountID = ? \n");
                } else {
                    sql.append("        and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") pre on cur.FAccountID = pre.FAccountID \n");
            sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
            if (cyId == null) {
                sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = cur.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = cur.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = pre.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = pre.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, prePeriod.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountStartBegin(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FBeginQty*av.fdc, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'pcainit' \n");
                sql.append("left join T_PCA_InitPcAccountBalance ib \n");
                sql.append("    on ib.FProfitCenterID = b.FProfitCenterID \n");
                sql.append("    and ib.FOrgUnitID = b.FOrgUnitID \n");
                sql.append("    and ib.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                sql.append("    and f.FValue = 'true' \n");
                sql.append("where b.FProfitCenterID = ? \n");
                sql.append("    and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from T_PCA_InitPcAccountBalance ib \n");
                sql.append("join T_BD_AccountView av on av.FID = ib.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = ib.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = ib.FProfitCenterID and f.FCompanyID = ib.FOrgUnitID and f.FName = 'pcainit' and f.FValue = 'true' \n");
                sql.append("left join " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FProfitCenterID = ib.FProfitCenterID \n");
                sql.append("    and b.FOrgUnitID = ib.FOrgUnitID \n");
                sql.append("    and b.FPeriod = ? \n");
                sql.append("    and b.FAccountID = ib.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and b.FCurrencyID = ib.FCurrencyID \n");
                }
                sql.append("where ib.FProfitCenterID = ? \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                    sql.append("    and ib.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ib.FAccountID = ? \n");
                    } else {
                        sql.append("  and ib.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av.fdc, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountStartBegin2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FBeginQty*av2.fdc, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, \n");
            sql.append("        FAccountID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FBeginBalance" + suffix + ", FBeginQty \n");
            sql.append("    from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and FAccountID = ? \n");
                } else {
                    sql.append("      and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        t.FOrgUnitID, \n");
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FBeginBalance" + suffix + ", t.FBeginQty \n");
            sql.append("    from T_PCA_InitPcAccountBalance t \n");
            sql.append("    join T_PCA_FLAG f \n");
            sql.append("        on f.FOrgUnitID = t.FProfitCenterID and f.FCompanyID = t.FOrgUnitID and f.FName = 'pcainit' and f.FValue = 'true' \n");
            sql.append("    where t.FProfitCenterID = ? \n");
            if (cyId == null) {
                sql.append("        and t.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                sql.append("        and t.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
            } else {
                sql.append("        and t.FCurrencyID = '" + cyId + "' \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") ib on ib.FAccountID = b.FAccountID \n");
            sql.append("    and ib.FOrgUnitID = b.FOrgUnitID \n");
            if (cyId == null) {
                sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = ib.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = ib.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av2.fdc, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av2.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistBegin(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAssistStartBegin(ctx, profitCenter, period, accountIds, balType, cyId, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " cur \n");
                sql.append("join T_BD_AccountView av on av.FID = cur.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = cur.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = cur.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " pre \n");
                sql.append("    on cur.FProfitCenterID = pre.FProfitCenterID \n");
                sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and pre.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where cur.FProfitCenterID = ? \n");
                sql.append("    and cur.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and cur.FAccountID = ? \n");
                    } else {
                        sql.append("  and cur.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " pre \n");
                sql.append("join T_BD_AccountView av on av.FID = pre.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = pre.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = pre.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " cur \n");
                sql.append("    on cur.FProfitCenterID = pre.FProfitCenterID \n");
                sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and cur.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where pre.FProfitCenterID = ? \n");
                sql.append("    and pre.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and pre.FAccountID = ? \n");
                    } else {
                        sql.append("  and pre.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setInt(index++, prePeriod.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, prePeriod.getNumber());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistBegin2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAssistStartBegin2(ctx, profitCenter, period, accountIds, balType, cyId, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FBeginBalance" + suffix + ", FBeginQty \n");
            sql.append("    from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and FAccountID = ? \n");
                } else {
                    sql.append("        and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") cur \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FEndBalance" + suffix + ", FEndQty \n");
            sql.append("    from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and FAccountID = ? \n");
                } else {
                    sql.append("        and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") pre on cur.FAccountID = pre.FAccountID \n");
            sql.append("    and cur.FOrgUnitID = pre.FOrgUnitID \n");
            sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
            if (cyId == null) {
                sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = cur.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = cur.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = cur.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = pre.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = pre.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, prePeriod.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistStartBegin(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FStandardBeginQty*av.fdc, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID \n");
                sql.append("left join T_PCA_InitPcAssistBalance ib \n");
                sql.append("    on ib.FProfitCenterID = b.FProfitCenterID \n");
                sql.append("    and ib.FOrgUnitID = b.FOrgUnitID \n");
                sql.append("    and ib.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                sql.append("    and ib.FAssistGrpID = b.FAssistGrpID \n");
                sql.append("    and f.FValue = 'true' \n");
                sql.append("where b.FProfitCenterID = ? \n");
                sql.append("    and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from T_PCA_InitPcAssistBalance ib \n");
                sql.append("join T_BD_AccountView av on av.FID = ib.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = ib.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = ib.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = ib.FProfitCenterID and f.FCompanyID = ib.FOrgUnitID and f.FName = 'astinit' and f.FKey = ib.FAccountID and f.FValue = 'true' \n");
                sql.append("left join " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FProfitCenterID = ib.FProfitCenterID \n");
                sql.append("    and b.FOrgUnitID = ib.FOrgUnitID \n");
                sql.append("    and b.FPeriod = ? \n");
                sql.append("    and b.FAccountID = ib.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and b.FCurrencyID = ib.FCurrencyID \n");
                }
                sql.append("    and b.FAssistGrpID = ib.FAssistGrpID \n");
                sql.append("where ib.FProfitCenterID = ? \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                    sql.append("    and ib.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ib.FAccountID = ? \n");
                    } else {
                        sql.append("  and ib.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av.fdc, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setString(index++, profitCenter.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, profitCenter.getId().toString());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistStartBegin2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FStandardBeginQty*av2.fdc, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        FOrgUnitID, FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        FCurrencyID, \n");
            }
            sql.append("        FBeginBalance" + suffix + ", FBeginQty \n");
            sql.append("    from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " \n");
            sql.append("    where FProfitCenterID = ? and FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and FAccountID = ? \n");
                } else {
                    sql.append("      and FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        t.FOrgUnitID, t.FAccountID, t.FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FBeginBalance" + suffix + ", t.FStandardBeginQty \n");
            sql.append("    from T_PCA_InitPcAssistBalance t \n");
            sql.append("    join T_PCA_FLAG f \n");
            sql.append("        on f.FOrgUnitID = t.FProfitCenterID and f.FCompanyID = t.FOrgUnitID and f.FName = 'astinit' and f.FKey = t.FAccountID and f.FValue = 'true' \n");
            sql.append("    where t.FProfitCenterID = ? \n");
            if (cyId == null) {
                sql.append("        and t.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                sql.append("        and t.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
            } else {
                sql.append("        and t.FCurrencyID = '" + cyId + "' \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") ib on ib.FAccountID = b.FAccountID and ib.FAssistGrpID = b.FAssistGrpID \n");
            sql.append("    and ib.FOrgUnitID = b.FOrgUnitID \n");
            if (cyId == null) {
                sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = ib.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = ib.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = ib.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av2.fdc, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av2.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountCurrent(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join ( \n");
                sql.append("    select \n");
                sql.append("        v.FCompanyID FOrgUnitID, \n");
                sql.append("        ve.FAccountID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_PCA_PcVoucher v \n");
                sql.append("    inner join T_PCA_PcVoucherEntry ve on ve.FBillID = v.FID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by v.FCompanyID, ve.FAccountID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a on a.FAccountID = b.FAccountID \n");
                sql.append(" and a.FOrgUnitID = b.FOrgUnitID \n");
                if (cyId == null) {
                    sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
                }
                sql.append("where b.FProfitCenterID = ? and b.FPeriod = ? \n");
                sql.append("    and av.FIsLeaf = 1 \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from ( \n");
                sql.append("    select \n");
                sql.append("        v.FCompanyID FOrgUnitID, \n");
                sql.append("        ve.FAccountID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_PCA_PcVoucher v \n");
                sql.append("    inner join T_PCA_PcVoucherEntry ve on ve.FBillID = v.FID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by v.FCompanyID, ve.FAccountID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a \n");
                sql.append("join T_BD_AccountView av on av.FID = a.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = a.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FProfitCenterID = ? and b.FPeriod = ? \n");
                sql.append("    and a.FOrgUnitID = b.FOrgUnitID \n");
                sql.append("    and a.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("where av.FIsLeaf = 1 \n");
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountCurrent2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        t.FOrgUnitID, \n");
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + PCABalanceUtils.getAccountBalanceTable(balType, cyId) + " t \n");
            sql.append("    join t_bd_accountview ac on ac.fid = t.faccountid \n");
            sql.append("    where t.FProfitCenterID = ? and t.FPeriod = ? and ac.FIsLeaf = 1 \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        v.FCompanyID FOrgUnitID, \n");
            sql.append("        ve.FAccountID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_PCA_PcVoucher v \n");
            sql.append("    inner join T_PCA_PcVoucherEntry ve on ve.FBillID = v.FID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by v.FCompanyID, ve.FAccountID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") a on a.FAccountID = b.FAccountID \n");
            sql.append(" and a.FOrgUnitID = b.FOrgUnitID \n");
            if (cyId == null) {
                sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistCurrent(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join ( \n");
                sql.append("    select \n");
                sql.append("        v.FCompanyID FOrgUnitID, ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_PCA_PcVoucher v \n");
                sql.append("    inner join T_PCA_PcVoucherEntry ve on v.FID = ve.FBillID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                sql.append("    inner join T_PCA_PcVoucherAssistRecord r on r.FENTRYID = ve.FID \n");
                sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by v.FCompanyID, ve.FAccountID, r.FAssGrpID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a on a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
                sql.append("    and a.FOrgUnitID = b.FOrgUnitID \n");
                if (cyId == null) {
                    sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
                }
                sql.append("where b.FProfitCenterID = ? and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from ( \n");
                sql.append("    select \n");
                sql.append("        v.FCompanyID FOrgUnitID, ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_PCA_PcVoucher v \n");
                sql.append("    inner join T_PCA_PcVoucherEntry ve on v.FID = ve.FBillID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                sql.append("    inner join T_PCA_PcVoucherAssistRecord r on r.FENTRYID = ve.FID \n");
                sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by v.FCompanyID, ve.FAccountID, r.FAssGrpID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a \n");
                sql.append("join T_BD_AccountView av on av.FID = a.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = a.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = a.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FProfitCenterID = ? and b.FPeriod = ? \n");
                sql.append("    and a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
                sql.append("    and a.FOrgUnitID = b.FOrgUnitID \n");
                if (cyId == null) {
                    sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("where av.FIsLeaf = 1 \n");
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistCurrent2(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            sql.append("        t.FOrgUnitID, t.FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + PCABalanceUtils.getAssistBalanceTable(balType, cyId) + " t \n");
            sql.append("    where t.FProfitCenterID = ? and t.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            sql.append("        v.FCompanyID FOrgUnitID, ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_PCA_PcVoucher v \n");
            sql.append("    inner join T_PCA_PcVoucherEntry ve on v.FID = ve.FBillID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            sql.append("    inner join T_PCA_PcVoucherAssistRecord r on r.FENTRYID = ve.FID \n");
            sql.append("    where v.FProfitCenterID = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + PcaBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by v.FCompanyID, ve.FAccountID, r.FAssGrpID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") a on a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
            sql.append("    and a.FOrgUnitID = b.FOrgUnitID \n");
            if (cyId == null) {
                sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = a.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, profitCenter.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private boolean isForRepair(Map<String, Object> params) {
        return params != null && params.get("AnaBal_Repair") != null && (Boolean)params.get("AnaBal_Repair") != false;
    }

    @Override
    protected Map _repair(Context ctx, Map params) throws BOSException, EASBizException {
        return PcaBalanceRepairer.repair(ctx, params);
    }
}

