/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.GLBalanceFacadeControllerBean;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.app.AbstractPcaBalanceFacadeControllerBean;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcaBalanceFacadeControllerBean
extends AbstractPcaBalanceFacadeControllerBean {
    private static final String T_PCA_PCVOUCHERLOG = "t_pca_pcvoucherlog";
    private static final String FPROFITCENTERID = "fprofitcenterid";
    private static final String PROFITCENTERID = "profitcenterid";
    private static final String T_ORG_PROFITCENTER = "t_org_profitcenter";
    private static final String T_PCA_PCVOUCHER = "t_pca_pcvoucher";
    private static final String T_PCA_PCVOUCHERENTRY = "t_pca_pcvoucherentry";
    private static final String T_PCA_PCVOUCHERASSISTRECORD = "t_pca_pcvoucherassistrecord";
    private static final String T_PCA_INITPCACCOUNTBALANCE = "t_pca_initpcaccountbalance";
    private static final String T_PCA_INITPCASSISTBALANCE = "t_pca_initpcassistbalance";
    private static final int ACCOUNT_BALANCE = 1;
    private static final int ASSIST_BALANCE = 2;
    private static final int MEASURE_BALANCE = 3;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcaBalanceFacadeControllerBean");

    protected String getVoucherLogTable() {
        return T_PCA_PCVOUCHERLOG;
    }

    protected String getOrgColumnName() {
        return FPROFITCENTERID;
    }

    protected String getOrgColumnNameB() {
        return this.getOrgColumnName();
    }

    protected String getOrgColumnNameBV() {
        return PROFITCENTERID;
    }

    protected String getOrgTable() {
        return T_ORG_PROFITCENTER;
    }

    protected int getSystemTypeValue() {
        return 1006;
    }

    protected String getOrgSelector() {
        return "fprofitcenterid,";
    }

    protected String getOrgSelector(String tableAlias) {
        return tableAlias + ".fprofitcenterid,";
    }

    protected String getOrgSelectorV() {
        return "profitcenterid,";
    }

    protected String getOrgSelectorV(String tableAlias) {
        return tableAlias + ".profitcenterid,";
    }

    protected String getVoucherTable() {
        return T_PCA_PCVOUCHER;
    }

    protected String getVoucherEntryTable() {
        return T_PCA_PCVOUCHERENTRY;
    }

    protected String getVoucherAssRecTable() {
        return T_PCA_PCVOUCHERASSISTRECORD;
    }

    protected String getInitAccountBalanceTable() {
        return T_PCA_INITPCACCOUNTBALANCE;
    }

    protected String getInitAssistBalanceTable() {
        return T_PCA_INITPCASSISTBALANCE;
    }

    protected String getSaveVoucherLogParam() {
        return "PCA_VOUCHER_LOG";
    }

    protected void _updateVoucherBalance(Context ctx, String[] companyIds) throws BOSException {
        String[] cpIds;
        if (companyIds == null || companyIds.length == 0) {
            companyIds = new String[]{ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
        }
        if (!this.isNeedUpdate(ctx, cpIds = this.distinctId(companyIds))) {
            return;
        }
        String[] calCpIds = null;
        try {
            PcaBalanceFacadeFactory.getLocalInstance(ctx).fillTransaction(cpIds);
            calCpIds = this.getNeedUpdateCompanys(ctx, cpIds);
            if (calCpIds == null || calCpIds.length == 0) {
                return;
            }
            if (!this.isNeedUpdate(ctx, calCpIds)) {
                return;
            }
            PcaBalanceFacadeFactory.getLocalInstance(ctx).doUpdateVoucherBalance(calCpIds);
        }
        catch (Throwable e) {
            throw new BOSException("Update voucher balance error!", e);
        }
        finally {
            if (calCpIds != null && calCpIds.length > 0) {
                PcaBalanceFacadeFactory.getLocalInstance(ctx).unLockCalBalance(calCpIds);
            }
        }
    }

    protected String[] getNeedUpdateCompanys(Context ctx, String[] companyIds) throws BOSException {
        if (companyIds.length == 0) {
            return null;
        }
        String strCpIds = this.listId2StrId(companyIds);
        HashMap initStatusMap = new HashMap();
        Map lastStatus = null;
        while (true) {
            GLBalanceFacadeControllerBean.BalanceCalInfo info;
            if ((info = this.getUpdateStatus(ctx, strCpIds, initStatusMap, lastStatus)).getCalStatus() == 0) {
                companyIds = info.getCompanyIds();
                try {
                    PcaBalanceFacadeFactory.getLocalInstance(ctx).lockCalBalance(companyIds);
                }
                catch (BOSException ex) {
                    if ("balance_update_conflict".equals(ex.getMessage())) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new BOSException("DBLock error!", (Throwable)e);
                        }
                    }
                    throw new BOSException("SQL ERROR!", (Throwable)ex);
                }
                return companyIds;
            }
            if (info.getCalStatus() == 2) {
                return null;
            }
            lastStatus = info.getStatusMap();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new BOSException("DBFinalLock error!", (Throwable)e);
            }
        }
    }

    private GLBalanceFacadeControllerBean.BalanceCalInfo getUpdateStatus(Context ctx, String companyIds, Map initStatusMap, Map lastStatusMap) throws BOSException {
        HashMap statusMap = new HashMap();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery("select fid, ftimecount, fisupdating, fupdatetime, getDate() curTime from t_bas_transaction where fid in (" + companyIds + ") and fnumber = 'updatebalance' and fsystype = " + this.getSystemTypeValue());
            while (rs.next()) {
                this.setUpdateStatus(ctx, statusMap, initStatusMap, rs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return this.buildBalanceCalStatus(statusMap);
    }

    private void setUpdateStatus(Context ctx, Map statusMap, Map initStatusMap, ResultSet rs) throws SQLException, BOSException {
        Object[] initStatus = (Object[])initStatusMap.get(rs.getString("fid"));
        Object[] status = new Object[3];
        int isUpdating = rs.getInt("fisupdating");
        Timestamp lastUpdateTime = rs.getTimestamp("fupdatetime");
        Timestamp currTime = rs.getTimestamp("curTime");
        if (isUpdating == 1 && currTime.getTime() - lastUpdateTime.getTime() > 300000L) {
            PcaBalanceFacadeFactory.getLocalInstance(ctx).unLockCalBalance(new String[]{rs.getString("fid")});
            isUpdating = 0;
        }
        int timecount = rs.getInt("ftimecount");
        status[0] = Integer.valueOf(isUpdating + "");
        status[1] = Integer.valueOf(timecount + "");
        if (initStatus == null) {
            status[2] = NO_UPDATE;
            initStatusMap.put(rs.getString("fid"), status);
        } else {
            int initTimeCount = (Integer)initStatus[1];
            if (timecount - initTimeCount >= 2 || timecount < initTimeCount && timecount + 10000 - initTimeCount >= 2 || timecount - initTimeCount == 1 && isUpdating == 0) {
                status[2] = UPDATED;
            }
        }
        statusMap.put(rs.getString("fid"), status);
    }

    protected String createVoucherBalanceTempTable(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table T_Pca_BALANCETMPTABLE ");
        sql.append(" (");
        sql.append(" PROFITCENTERID    VARCHAR(44),");
        sql.append(" ORGUNITID         VARCHAR(44),");
        sql.append(" PERIOD            INT,");
        sql.append(" ACCOUNTID         VARCHAR(44),");
        sql.append(" CURRENCYID        VARCHAR(44),");
        sql.append(" BALTYPE           INT,");
        sql.append(" ASSISTGRPID       VARCHAR(44),");
        sql.append(" MEASUREUNITID     VARCHAR(44),");
        sql.append(" DEBITFOR          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITFOR         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITLOCAL        NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITRPT          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITRPT         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITQTY          NUMERIC(28,10) DEFAULT 0,");
        sql.append(" CREDITQTY         NUMERIC(28,10) DEFAULT 0,");
        sql.append(" MONTHPNLFOR       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLLOCAL     NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLRPT       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLQTY       NUMERIC(28,10) DEFAULT 0,");
        sql.append(" BALANCETYPE           INT");
        sql.append(" ,FLOGCOUNT INT");
        sql.append(")");
        String tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + tmpTableName));
        if (rs.next()) {
            logger.error((Object)"Get temp table error, exist data in the new temp table!");
            return null;
        }
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, "accountid, profitcenterid,orgunitid, period, currencyid, baltype, assistgrpid, measureunitid", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update voucher balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    protected void _transBalanceToNextPeriod(Context ctx, String companyID, String currentPeriodID, String nextPeriodID, boolean isNextYear, String acctIDs) throws BOSException {
        super._transBalanceToNextPeriod(ctx, companyID, currentPeriodID, nextPeriodID, isNextYear, acctIDs);
    }

    protected String getBalanceToNextPeriodOracleSQL(boolean isNextYear, int balTableType, int baltype, String currencyId, String acctIDs) {
        boolean isForCurency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        StringBuffer sql = new StringBuffer();
        String balTable = this.getBalanceTable(balTableType, baltype, currencyId);
        sql.append(" /*dialect*/MERGE INTO ").append(balTable).append(" tin USING (select * from ").append(balTable).append(" where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ?");
        if (!StringUtils.isEmpty((String)acctIDs)) {
            sql.append(" and faccountid in (").append(acctIDs).append(")");
        }
        sql.append(") tout ");
        sql.append(" ON (tin.").append(this.getOrgColumnNameB()).append(" = tout.").append(this.getOrgColumnNameB()).append(" and tin.forgunitid = tout.forgunitid ").append(" and tin.faccountid = tout.faccountid");
        if (isForCurency) {
            sql.append(" and tin.fcurrencyid = tout.fcurrencyid ");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" and tin.fassistgrpid = tout.fassistgrpid ");
            if (3 == balTableType) {
                sql.append(" and tin.fmeasureunitid = tout.fmeasureunitid ");
            }
        }
        sql.append(" and tin.fperiod = ?) ");
        sql.append(" WHEN MATCHED THEN UPDATE SET ");
        if (isForCurency) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "for"));
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "local"));
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "rpt"));
        }
        sql.append(this.getUpdateQtySQL(isNextYear));
        StringBuffer fsql = new StringBuffer();
        if (isForCurency) {
            fsql.append(this.getEqualAmountSQL(isNextYear, "for"));
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            if (fsql.length() > 0) {
                fsql.append(" or ");
            }
            fsql.append(this.getEqualAmountSQL(isNextYear, "local"));
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            if (fsql.length() > 0) {
                fsql.append(" or ");
            }
            fsql.append(this.getEqualAmountSQL(isNextYear, "rpt"));
        }
        if (fsql.length() > 0) {
            fsql.append(" or ");
        }
        fsql.append(this.getEqualQtySQL(isNextYear));
        sql.append(" where ").append(fsql.toString());
        sql.append(" WHEN NOT MATCHED THEN ");
        sql.append(" INSERT (forgunitid, ").append(this.getOrgSelector()).append(" fperiod, faccountid, ");
        if (isForCurency) {
            sql.append(" fcurrencyid,");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" fassistgrpid, ");
            if (3 == balTableType) {
                sql.append(" fmeasureunitid, ");
            }
        }
        if (isForCurency) {
            sql.append(" fbeginbalancefor,fendbalancefor,");
            if (!isNextYear) {
                sql.append(" fyeardebitfor,fyearcreditfor,fyearpnlfor,");
            }
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancelocal,fendbalancelocal,");
            if (!isNextYear) {
                sql.append(" fyeardebitlocal,fyearcreditlocal,fyearpnllocal,");
            }
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancerpt,fendbalancerpt,");
            if (!isNextYear) {
                sql.append(" fyeardebitrpt,fyearcreditrpt,fyearpnlrpt,");
            }
        }
        sql.append(" fbeginqty,fendqty,");
        if (!isNextYear) {
            sql.append(" fyeardebitqty,fyearcreditqty,fyearpnlqty,");
        }
        sql.append(" fdetailcount)");
        sql.append(" VALUES (tout.forgunitid,").append(this.getOrgSelector("tout")).append(" ?, tout.faccountid,");
        if (isForCurency) {
            sql.append(" tout.fcurrencyid,");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" tout.fassistgrpid, ");
            if (3 == balTableType) {
                sql.append(" tout.fmeasureunitid, ");
            }
        }
        if (isForCurency) {
            sql.append(" tout.fendbalancefor,tout.fendbalancefor,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitfor,tout.fyearcreditfor,tout.fyearpnlfor,");
            }
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" tout.fendbalancelocal,tout.fendbalancelocal,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitlocal,tout.fyearcreditlocal,tout.fyearpnllocal,");
            }
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" tout.fendbalancerpt,tout.fendbalancerpt,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitrpt,tout.fyearcreditrpt,tout.fyearpnlrpt,");
            }
        }
        sql.append(" tout.fendqty,tout.fendqty,");
        if (!isNextYear) {
            sql.append(" tout.fyeardebitqty,tout.fyearcreditqty,nvl(tout.fyearpnlqty,0),");
        }
        sql.append("0)");
        sql.append(this.getAmountZeroFilter(isNextYear, currencyId));
        return sql.toString();
    }

    protected String getAssistBalanceTempTable(Context ctx, boolean isNextYear, String currencyId) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        if (isNextYear) {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" ORGUNITID         VARCHAR(44),");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            if (isForCurrency) {
                sql.append(" CURRENCYID        VARCHAR(44),");
            }
            if (isForCurrency) {
                sql.append(" ENDBALANCEFOR          NUMERIC(19,4) DEFAULT 0,");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append(" ENDBALANCELOCAL         NUMERIC(19,4) DEFAULT 0,");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append(" ENDBALANCERPT        NUMERIC(19,4) DEFAULT 0,");
            }
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        } else {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" ORGUNITID         VARCHAR(44),");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            if (isForCurrency) {
                sql.append(" CURRENCYID        VARCHAR(44),");
            }
            if (isForCurrency) {
                sql.append(" YEARDEBITFOR          NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITFOR         NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCEFOR        NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLFOR       NUMERIC(19,4) DEFAULT 0,");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append(" YEARDEBITLOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCELOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLLOCAL       NUMERIC(19,4) DEFAULT 0,");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append(" YEARDEBITRPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITRPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCERPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLRPT       NUMERIC(19,4) DEFAULT 0,");
            }
            sql.append(" YEARDEBITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        }
        String tmpTableName = null;
        try {
            tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("Create assist temp balance error!", (Throwable)e);
        }
        try {
            String indexColumns = "orgunitid, accountid, assistgrpid";
            if (isForCurrency) {
                indexColumns = indexColumns + ", currencyid";
            }
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, indexColumns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update assist temp balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    protected void doTransBalanceToNextPeriod(Context ctx, String companyID, PeriodInfo currentPeriod, PeriodInfo nextPeriod, boolean isNextYear, String acctIDs, int baltype, String currencyId, String assistTmp) throws BOSException {
        String T_AccountBalance = this.getBalanceTable(1, baltype, currencyId);
        String T_AssistBalance = this.getBalanceTable(2, baltype, currencyId);
        String T_AssistMeasureBalance = this.getBalanceTable(3, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer acctInsertSql = new StringBuffer();
        acctInsertSql.append("insert into " + T_AccountBalance + " ( \n");
        acctInsertSql.append("    forgunitid, ").append(this.getOrgSelector()).append(" faccountid, ");
        if (isForCurrency) {
            acctInsertSql.append("fcurrencyid, ");
        }
        acctInsertSql.append("fperiod \n");
        acctInsertSql.append(") \n");
        acctInsertSql.append("select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ");
        if (isForCurrency) {
            acctInsertSql.append("ab.fcurrencyid, ");
        }
        acctInsertSql.append("? \n");
        acctInsertSql.append("from ").append(T_AccountBalance).append(" ab \n");
        acctInsertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \n");
        acctInsertSql.append("    and ab.fperiod = ? \n");
        if (acctIDs != null && !"".equals(acctIDs)) {
            acctInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        acctInsertSql.append("    and not exists ( \n");
        acctInsertSql.append("        select 1 from ").append(T_AccountBalance).append(" ab1 \n");
        acctInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append(" = ? \n");
        acctInsertSql.append("        and ab1.fperiod = ? \n");
        acctInsertSql.append("        and ab1.faccountid=ab.faccountid \n");
        acctInsertSql.append("        and ab1.forgunitid=ab.forgunitid \n");
        if (isForCurrency) {
            acctInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \n");
        }
        acctInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transAccountBalance1", (String)acctInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)acctInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer acctUpdateSql = new StringBuffer();
        if (isNextYear) {
            acctUpdateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            acctUpdateSql.append("fbeginqty, fendqty \r\n");
            acctUpdateSql.append(") = ( \r\n");
            acctUpdateSql.append("select \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            acctUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            acctUpdateSql.append("from ( \r\n");
            acctUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            acctUpdateSql.append("ab.forgunitid orgunitid, \n");
            acctUpdateSql.append("ab.fperiod period, ab.faccountid accountid, \n");
            if (isForCurrency) {
                acctUpdateSql.append("ab.fcurrencyid currencyid, \n");
            }
            if (isForCurrency) {
                acctUpdateSql.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            acctUpdateSql.append("ab.fendqty endqty \r\n");
            acctUpdateSql.append("from ").append(T_AccountBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \n");
            acctUpdateSql.append("and ab.fperiod=? ) t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            acctUpdateSql.append(" ) \r\n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                acctUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            acctUpdateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("    fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                acctUpdateSql.append("    fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                acctUpdateSql.append("    fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                acctUpdateSql.append("    fyearpnlrpt, \r\n");
            }
            acctUpdateSql.append("    fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty \r\n");
            acctUpdateSql.append(") = ( \r\n");
            acctUpdateSql.append("select \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("    endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, \r\n");
                acctUpdateSql.append("    yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
                acctUpdateSql.append("    yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
                acctUpdateSql.append("    yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            acctUpdateSql.append("    endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, \r\n");
            acctUpdateSql.append("    isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            acctUpdateSql.append("from ( \r\n");
            acctUpdateSql.append("    select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            acctUpdateSql.append("    ab.forgunitid orgunitid, \n");
            acctUpdateSql.append("    ab.fperiod period, ab.faccountid accountid, \n");
            if (isForCurrency) {
                acctUpdateSql.append("    ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, \r\n");
                acctUpdateSql.append("    ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, \r\n");
                acctUpdateSql.append("    ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, \r\n");
                acctUpdateSql.append("    ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            acctUpdateSql.append("    ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, \r\n");
            acctUpdateSql.append("    ab.fyearpnlqty yearpnlqty \r\n");
            acctUpdateSql.append("    from ").append(T_AccountBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            acctUpdateSql.append("    and ab.fperiod=? \n");
            acctUpdateSql.append(") t \n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            acctUpdateSql.append("and orgunitid = forgunitid \r\n");
            acctUpdateSql.append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            acctUpdateSql.append(" ) \r\n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                acctUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transAccountBalance2", (String)acctUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)acctUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer asstInsertSql = new StringBuffer();
        asstInsertSql.append(" insert into ").append(T_AssistBalance).append("( \r\n");
        asstInsertSql.append("forgunitid, ").append(this.getOrgSelector()).append("faccountid, fassistgrpid, ");
        if (isForCurrency) {
            asstInsertSql.append("fcurrencyid, ");
        }
        asstInsertSql.append("fperiod \n");
        asstInsertSql.append(") \n");
        asstInsertSql.append(" select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ab.fassistgrpid, \r\n");
        if (isForCurrency) {
            asstInsertSql.append("ab.fcurrencyid, ");
        }
        asstInsertSql.append("? \n");
        asstInsertSql.append(" from ").append(T_AssistBalance).append(" ab \r\n").append(" where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstInsertSql.append("    and ab.fperiod = ? \n");
        asstInsertSql.append(" and ( \r\n");
        if (isForCurrency) {
            asstInsertSql.append(" ab.fendbalancefor<>0 or ");
        }
        if (isLocaCurrency || isForCurrency) {
            asstInsertSql.append(" ab.fendbalancelocal<>0 or ");
        }
        if (isRptCurrency || isForCurrency) {
            asstInsertSql.append(" ab.fendbalancerpt<>0 or ");
        }
        asstInsertSql.append(" ab.fendqty<>0 ");
        if (!isNextYear) {
            if (isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitfor<>0 or ab.fyearcreditfor<>0 or ab.fyearpnlfor<>0 ");
            }
            if (isLocaCurrency || isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitlocal<>0 or ab.fyearcreditlocal<>0 or ab.fyearpnllocal<>0 ");
            }
            if (isRptCurrency || isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitrpt<>0 or ab.fyearcreditrpt<>0 or ab.fyearpnlrpt<>0 ");
            }
            asstInsertSql.append(" or ab.fyeardebitqty<>0 or ab.fyearcreditqty<>0 or isNull(ab.fyearpnlqty,0)<>0");
        }
        asstInsertSql.append(") \r\n");
        if (acctIDs != null && !"".equals(acctIDs)) {
            asstInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        asstInsertSql.append(" and not exists ( \r\n");
        asstInsertSql.append("         select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
        asstInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstInsertSql.append("        and ab1.fperiod = ? \r\n");
        asstInsertSql.append("        and ab1.forgunitid=ab.forgunitid \r\n");
        asstInsertSql.append("        and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
        if (isForCurrency) {
            asstInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \n");
        }
        asstInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transAssistBalance1", (String)asstInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer insertTempTabSQL = null;
        StringBuffer asstUpdateSql = new StringBuffer();
        if (isNextYear) {
            insertTempTabSQL = new StringBuffer("insert into ").append(assistTmp);
            insertTempTabSQL.append(" select ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, \r\n");
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            insertTempTabSQL.append("ab.fendqty endqty \r\n");
            insertTempTabSQL.append("from ").append(T_AssistBalance).append(" ab \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? \r\n").append("and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                insertTempTabSQL.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"transAssistBalance2", (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            asstUpdateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            asstUpdateSql.append("fbeginqty, fendqty \r\n");
            asstUpdateSql.append(") = ( \r\n");
            asstUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            asstUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            asstUpdateSql.append("from  \r\n");
            asstUpdateSql.append(assistTmp);
            asstUpdateSql.append("  t \r\n");
            asstUpdateSql.append("where \r\n");
            asstUpdateSql.append(" accountid = faccountid \r\n");
            asstUpdateSql.append(" and orgunitid = forgunitid \r\n");
            asstUpdateSql.append(" and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                asstUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            insertTempTabSQL = new StringBuffer("insert into ").append(assistTmp);
            insertTempTabSQL.append(" select ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, \r\n");
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, \r\n");
                insertTempTabSQL.append("ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, \r\n");
                insertTempTabSQL.append("ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, \r\n");
                insertTempTabSQL.append("ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            insertTempTabSQL.append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, \r\n");
            insertTempTabSQL.append("ab.fyearpnlqty yearpnlqty \r\n");
            insertTempTabSQL.append("from ").append(T_AssistBalance).append(" ab \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            insertTempTabSQL.append("and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                insertTempTabSQL.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"transAssistBalance2", (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            asstUpdateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                asstUpdateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                asstUpdateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                asstUpdateSql.append("fyearpnlrpt, \r\n");
            }
            asstUpdateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, \r\n");
            asstUpdateSql.append("fyearpnlqty \r\n");
            asstUpdateSql.append(") = ( \r\n");
            asstUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, \r\n");
                asstUpdateSql.append("yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
                asstUpdateSql.append("yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
                asstUpdateSql.append("yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            asstUpdateSql.append("endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, \r\n");
            asstUpdateSql.append("isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            asstUpdateSql.append("from  \r\n");
            asstUpdateSql.append(assistTmp);
            asstUpdateSql.append("  t \r\n");
            asstUpdateSql.append("where \r\n");
            asstUpdateSql.append(" accountid = faccountid \r\n");
            asstUpdateSql.append(" and orgunitid = forgunitid \r\n");
            asstUpdateSql.append(" and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                asstUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transAssistBalance2", (String)asstUpdateSql.toString(), (Object[])new Object[]{companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstUpdateSql.toString(), (Object[])new Object[]{companyID, nextPeriod.getNumber()});
        StringBuffer asstMeasureInsertSql = new StringBuffer();
        asstMeasureInsertSql.append("insert into ").append(T_AssistMeasureBalance).append("( \r\n");
        asstMeasureInsertSql.append("forgunitid, ").append(this.getOrgSelector()).append("faccountid, fassistgrpid, fmeasureunitid, \n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("fcurrencyid, \n");
        }
        asstMeasureInsertSql.append("fperiod \n");
        asstMeasureInsertSql.append(") \n");
        asstMeasureInsertSql.append("select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid, \r\n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("ab.fcurrencyid, ");
        }
        asstMeasureInsertSql.append("? \n");
        asstMeasureInsertSql.append(" from ").append(T_AssistMeasureBalance).append(" ab \r\n").append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstMeasureInsertSql.append("    and ab.fperiod = ? \n");
        if (isNextYear) {
            asstMeasureInsertSql.append(" and ( ");
            if (isForCurrency) {
                asstMeasureInsertSql.append(" ab.fendbalancefor<>0 or ");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureInsertSql.append(" ab.fendbalancelocal<>0 or ");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureInsertSql.append(" ab.fendbalancerpt<>0 or ");
            }
            asstMeasureInsertSql.append(" ab.fendqty<>0 ");
            asstMeasureInsertSql.append(") \r\n");
        }
        if (acctIDs != null && !"".equals(acctIDs)) {
            asstMeasureInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        asstMeasureInsertSql.append(" and not exists ( \r\n");
        asstMeasureInsertSql.append("        select 1 from ").append(T_AssistMeasureBalance).append(" ab1 \r\n");
        asstMeasureInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.").append(this.getOrgColumnNameB()).append("= ? \r\n");
        asstMeasureInsertSql.append("        and ab1.fperiod = ? \r\n");
        asstMeasureInsertSql.append("        and ab1.forgunitid=ab.forgunitid \r\n");
        asstMeasureInsertSql.append("        and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        asstMeasureInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transMeasureBalance1", (String)asstMeasureInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstMeasureInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer asstMeasureUpdateSql = new StringBuffer();
        if (isNextYear) {
            asstMeasureUpdateSql.append("update ").append(T_AssistMeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            asstMeasureUpdateSql.append("fbeginqty, fendqty \r\n");
            asstMeasureUpdateSql.append(") = ( \r\n");
            asstMeasureUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            asstMeasureUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            asstMeasureUpdateSql.append("from ( \r\n");
            asstMeasureUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            asstMeasureUpdateSql.append("ab.forgunitid orgunitid, \r\n");
            asstMeasureUpdateSql.append("ab.fperiod period, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            asstMeasureUpdateSql.append("ab.fendqty endqty \r\n");
            asstMeasureUpdateSql.append("from ").append(T_AssistMeasureBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            asstMeasureUpdateSql.append(" and ab.fperiod=? ) t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstMeasureUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                asstMeasureUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            asstMeasureUpdateSql.append("update ").append(T_AssistMeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, fyearpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty \r\n");
            asstMeasureUpdateSql.append(") = ( \r\n");
            asstMeasureUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            asstMeasureUpdateSql.append("from ( \r\n");
            asstMeasureUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            asstMeasureUpdateSql.append("ab.forgunitid orgunitid, \r\n");
            asstMeasureUpdateSql.append("ab.fperiod period, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, ab.fyearpnlqty yearpnlqty \r\n");
            asstMeasureUpdateSql.append("from ").append(T_AssistMeasureBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            asstMeasureUpdateSql.append("and ab.fperiod=? ) t \r\n");
            asstMeasureUpdateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            asstMeasureUpdateSql.append("and orgunitid = forgunitid \r\n");
            asstMeasureUpdateSql.append("and accountid = faccountid \r\n");
            asstMeasureUpdateSql.append("and assistgrpid = fassistgrpid \r\n");
            asstMeasureUpdateSql.append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstMeasureUpdateSql.append(" ) \r\n");
            asstMeasureUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                asstMeasureUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"transMeasureBalance2", (String)asstMeasureUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstMeasureUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
    }

    protected String getZeroBalanceToNextPeriodSQL(int balTableType, int baltype, String currencyId, String acctIDs) {
        boolean isForCurency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        StringBuffer sql = new StringBuffer();
        String balTable = this.getBalanceTable(balTableType, baltype, currencyId);
        sql.append(" UPDATE   ").append(balTable).append("    set    ");
        if (isForCurency) {
            sql.append(" fbeginbalance").append("for").append(" = 0,");
            sql.append(" fendbalance").append("for").append(" = fdebit").append("for").append(" - fcredit").append("for").append(",");
            sql.append(" fyeardebit").append("for").append(" = fdebit").append("for").append(",");
            sql.append(" fyearcredit").append("for").append(" = fcredit").append("for").append(",");
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalance").append("local").append(" = 0,");
            sql.append(" fendbalance").append("local").append(" = fdebit").append("local").append(" - fcredit").append("local").append(",");
            sql.append(" fyeardebit").append("local").append(" = fdebit").append("local").append(",");
            sql.append(" fyearcredit").append("local").append(" = fcredit").append("local").append(",");
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalance").append("rpt").append(" = 0,");
            sql.append(" fendbalance").append("rpt").append(" = fdebit").append("rpt").append(" - fcredit").append("rpt").append(",");
            sql.append(" fyeardebit").append("rpt").append(" = fdebit").append("rpt").append(",");
            sql.append(" fyearcredit").append("rpt").append(" = fcredit").append("rpt").append(",");
        }
        sql.append(" fbeginqty").append(" = 0,");
        sql.append(" fyeardebitqty").append(" = fdebitqty,");
        sql.append(" fyearcreditqty").append(" = fcreditqty,");
        sql.append(" fendqty").append(" = fdebitqty").append(" - fcreditqty").append(",");
        sql = new StringBuffer(sql.substring(0, sql.length() - 1));
        sql.append(" where ").append(balTable).append(".").append(this.getOrgColumnNameB()).append(" = ? ");
        if (!StringUtils.isEmpty((String)acctIDs)) {
            sql.append(" and ").append(balTable).append(".faccountid in (").append(acctIDs).append(") ");
        }
        sql.append(" and ").append(balTable).append(".fperiod = ? ");
        sql.append(" and not exists (SELECT 1 FROM ").append(balTable).append(" tout where ");
        sql.append(" tout.").append(this.getOrgColumnNameB()).append("=").append(balTable).append(".").append(this.getOrgColumnNameB()).append("\n");
        sql.append(" and tout.").append("forgunitid").append("=").append(balTable).append(".forgunitid").append("\n");
        sql.append(" and tout.").append("faccountid").append("=").append(balTable).append(".faccountid").append("\n");
        if (isForCurency) {
            sql.append(" and tout.fcurrencyid =").append(balTable).append(".fcurrencyid").append("\n");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" and tout.fassistgrpid=").append(balTable).append(".fassistgrpid").append("\n");
            if (3 == balTableType) {
                sql.append(" and tout.fmeasureunitid = ").append(balTable).append(".fmeasureunitid").append("\n");
            }
        }
        sql.append(" and tout.fperiod").append("=? \n");
        sql.append(") \n");
        return sql.toString();
    }

    protected void afterTransBalanceToNextPeriod(Context ctx, String companyID, String currentPeriodID) throws BOSException {
    }

    protected void _antiTransBalanceToPrevPeriod(Context ctx, String companyID, String currentPeriodID) throws BOSException {
        super._antiTransBalanceToPrevPeriod(ctx, companyID, currentPeriodID);
    }

    protected void afterAntiTransBalanceToPrevPeriod(Context ctx, String companyID, String currentPeriodID) throws BOSException {
    }

    protected void _transBalanceToNextYear(Context ctx, String companyID, String fromPeriodID, String toPeriodID, String acctIDs) throws BOSException, EASBizException {
    }

    protected String getBalanceTable(int tableType, int balType, String currencyId) {
        return PCABalanceUtils.getBalanceTable(tableType, balType, currencyId);
    }

    protected int getBalanceType(String tableName) {
        int tabletype = 1;
        tabletype = "t_pca_pcaccountbalance".equalsIgnoreCase(tableName) ? 1 : ("t_pca_pcassistbalance".equalsIgnoreCase(tableName) ? 2 : ("t_pca_pcassistmeasurebalance".equalsIgnoreCase(tableName) ? 3 : -1));
        return tabletype;
    }

    protected void insertVoucherBalance(Context ctx, String tmpTableName, Map sysParams, String companyIds) throws BOSException {
        this.insertCurrencyBalance(ctx, tmpTableName, companyIds, 1);
        this.insertCurrencyBalance(ctx, tmpTableName, companyIds, 2);
        boolean isAsstQty = Boolean.valueOf(sysParams.get("G010").toString());
        if (isAsstQty) {
            this.insertCurrencyBalance(ctx, tmpTableName, companyIds, 3);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' currencyid, t.baltype, t.assistgrpid, t.measureunitid, ");
        sql.append(" sum(t.DebitLocal) DebitFor, sum(t.CreditLocal) CreditFor, ");
        sql.append(" sum(t.DebitLocal) DebitLocal, sum(t.CreditLocal) CreditLocal, ");
        sql.append(" sum(t.DebitLocal) DebitRpt, sum(t.CreditLocal) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLLocal) MonthPnLFor, sum(t.MonthPnLLocal) MonthPnLLocal, sum(t.MonthPnLLocal) MonthPnLRpt, sum(t.MonthPnlQty) MonthPnlQty, ");
        sql.append(" t.balanceType, sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, t.baltype, t.balanceType, t.assistgrpid, t.measureunitid");
        sql.append(" union all ");
        sql.append(" select ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' currencyid, t.baltype, t.assistgrpid, t.measureunitid, ");
        sql.append(" sum(t.DebitRpt) DebitFor, sum(t.CreditRpt) CreditFor,");
        sql.append(" sum(t.DebitRpt) DebitLocal, sum(t.CreditRpt) CreditLocal, ");
        sql.append(" sum(t.DebitRpt) DebitRpt, sum(t.CreditRpt) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLRpt) MonthPnLFor, sum(t.MonthPnLRpt) MonthPnLLocal, sum(t.MonthPnLRpt) MonthPnLRpt, sum(t.MonthPnlQty) MonthPnlQty, ");
        sql.append(" t.balanceType, sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, t.baltype, t.balanceType, t.assistgrpid, t.measureunitid");
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
    }

    private void insertCurrencyBalance(Context ctx, String tmpTableName, String companyIds, int balType) throws BOSException {
        String accountId = balType == 1 ? "pacct.fid" : "log.FAccountID";
        String assistgrpId = balType == 1 ? "to_char(null)" : "log.fassistgrpid";
        String unitId = balType == 3 ? "case when log.FMeasureUnitId is null then '00000000-0000-0000-0000-0000000000005B825C57' else log.FMeasureUnitId end FMeasureUnitId" : "to_char(null)";
        int isAssist = balType == 1 ? 0 : 1;
        String group = this.getOrgSelector("log") + "log.fcompanyid, p.FNumber, " + accountId + ", log.fcurrencyid, log.fbaltype ";
        if (balType == 2 || balType == 3) {
            group = group + ", log.fassistgrpid ";
        }
        if (balType == 3) {
            group = group + ", log.fmeasureunitid ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(this.getOrgSelector("log")).append("log.fcompanyid, p.FNumber, ").append(accountId).append(", log.fcurrencyid, log.fbaltype, ");
        sql.append(assistgrpId).append(", ").append(unitId).append(", ");
        sql.append(" sum(log.FDebitFor) FDebitForV, sum(log.FCreditFor) FCreditForV, ");
        sql.append(" sum(log.FDebitLocal) FDebitLocalV, sum(log.FCreditLocal) FCreditLocalV, ");
        sql.append(" sum(log.FDebitRpt) FDebitRptV, sum(log.FCreditRpt) FCreditRptV, ");
        if (balType == 3) {
            sql.append(" sum(log.FDebitQty) FDebitQtyV, sum(log.FCreditQty) FCreditQtyV, ");
        } else {
            sql.append(" sum(log.FStandardDebitQty) FDebitQtyV, sum(log.FStandardCreditQty) FCreditQtyV, ");
        }
        sql.append(" sum(log.FMonthPnLFor) FMonthPnLForV,sum(log.FMonthPnLLocal) FMonthPnLLocalV,sum(log.FMonthPnLRpt) FMonthPnLRptV, ");
        if (balType == 3) {
            sql.append(" sum(isNull(log.FMONTHPNLQTY,0)) FMONTHPNLQTYV, ");
        } else {
            sql.append(" sum(isNull(log.FSTANDARDMONTHPNLQTY,0)) FSTANDARDMONTHPNLQTYV, ");
        }
        sql.append(balType).append(", sum(log.FVeCount) FLogCount ");
        sql.append(" from " + this.getVoucherLogTable() + " log ");
        sql.append(" join T_BD_Period p on p.FID = log.fperiodid ");
        if (balType == 1 || balType == 3) {
            sql.append(" inner join t_BD_AccountView acct on log.FAccountID = acct.FID ");
            if (balType == 3) {
                sql.append(" inner join t_bd_asstaccount ac on ac.fid = acct.fcaa ");
            }
        }
        if (balType == 1) {
            sql.append(" inner join t_BD_AccountView pacct on pacct.Fcompanyid = acct.Fcompanyid and pacct.faccounttableid = acct.faccounttableid ");
            sql.append(" and (charindex(pacct.FLongNumber||'!', acct.FLongNumber) = 1 or pacct.fid = acct.fid) ");
        }
        sql.append(" where log.fisassist = ").append(isAssist).append(" and log.fisupdating = 1 ");
        if (balType == 3) {
            sql.append(" and acct.fisqty=1 and ac.fisqty = 1 ");
        }
        if (companyIds.length() > 0) {
            sql.append(" and log.").append(this.getOrgColumnName()).append(" in (").append(companyIds).append(")");
        }
        sql.append(" group by ").append(group);
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
    }

    protected void updateBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType) throws BOSException {
        if (this.isOracle(ctx)) {
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, null);
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, null);
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        } else {
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, null);
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, null);
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, null);
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, null);
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
    }

    private void doOracleUpdateBalance(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/MERGE INTO ").append(this.getBalanceTable(balanceType, baltype, currencyId)).append(" tin ");
        sql.append(" USING (select * from ").append(tempTableName).append(" where balancetype=").append(balanceType);
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and currencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' ");
            sql.append(" and currencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' ");
        } else {
            sql.append(" and currencyid='").append(currencyId).append("' ");
        }
        sql.append(" and baltype = ").append(baltype);
        sql.append(" and ").append(this.getOrgColumnNameBV()).append(" is not null and accountid is not null ");
        if (balanceType != 1) {
            sql.append("  and assistgrpid is not null ");
        }
        sql.append(") tout ");
        sql.append(" ON (tin.").append(this.getOrgColumnNameB()).append(" = tout.").append(this.getOrgColumnNameBV());
        sql.append(" and tin.forgunitid = tout.orgunitid ");
        sql.append(" and tin.fperiod = tout.period and tin.faccountid = tout.accountid ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and tin.fcurrencyid = tout.currencyid ");
        }
        if (balanceType == 2) {
            sql.append(" and tin.fassistgrpid = tout.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and tin.fassistgrpid = tout.assistgrpid ");
            sql.append(" and tin.fmeasureunitid = tout.measureunitid ");
        }
        sql.append(")");
        sql.append(" WHEN MATCHED THEN UPDATE ");
        sql.append(" SET ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" tin.fdebitfor  = tin.fdebitfor + tout.debitfor, ");
            sql.append(" tin.fcreditfor = tin.fcreditfor + tout.creditfor, ");
            sql.append(" tin.fyeardebitfor  = tin.fyeardebitfor + tout.debitfor, ");
            sql.append(" tin.fyearcreditfor = tin.fyearcreditfor + tout.creditfor, ");
            sql.append(" tin.fmonthpnlfor   = tin.fmonthpnlfor + tout.monthpnlfor, ");
            sql.append(" tin.fyearpnlfor    = tin.fyearpnlfor + tout.monthpnlfor, ");
            sql.append(" tin.fendbalancefor = tin.fendbalancefor + tout.debitfor - tout.creditfor, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" tin.fdebitlocal    = tin.fdebitlocal + tout.debitlocal, ");
            sql.append(" tin.fcreditlocal   = tin.fcreditlocal + tout.creditlocal, ");
            sql.append(" tin.fyeardebitlocal    = tin.fyeardebitlocal + tout.debitlocal, ");
            sql.append(" tin.fyearcreditlocal   = tin.fyearcreditlocal + tout.creditlocal, ");
            sql.append(" tin.fmonthpnllocal = tin.fmonthpnllocal + tout.monthpnllocal, ");
            sql.append(" tin.fyearpnllocal  = tin.fyearpnllocal + tout.monthpnllocal, ");
            sql.append(" tin.fendbalancelocal   = tin.fendbalancelocal + tout.debitlocal - tout.creditlocal, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" tin.fdebitrpt  = tin.fdebitrpt + tout.debitrpt, ");
            sql.append(" tin.fcreditrpt = tin.fcreditrpt + tout.creditrpt, ");
            sql.append(" tin.fyeardebitrpt  = tin.fyeardebitrpt + tout.debitrpt, ");
            sql.append(" tin.fyearcreditrpt = tin.fyearcreditrpt + tout.creditrpt, ");
            sql.append(" tin.fmonthpnlrpt   = tin.fmonthpnlrpt + tout.monthpnlrpt, ");
            sql.append(" tin.fyearpnlrpt    = tin.fyearpnlrpt + tout.monthpnlrpt, ");
            sql.append(" tin.fendbalancerpt = tin.fendbalancerpt + tout.debitrpt - tout.creditrpt, ");
        }
        sql.append(" tin.fdebitqty  = tin.fdebitqty + tout.debitqty, ");
        sql.append(" tin.fcreditqty = tin.fcreditqty + tout.creditqty, ");
        sql.append(" tin.fyeardebitqty  = tin.fyeardebitqty + tout.debitqty, ");
        sql.append(" tin.fyearcreditqty = tin.fyearcreditqty + tout.creditqty, ");
        sql.append(" tin.fendqty    = tin.fendqty + tout.debitqty - tout.creditqty, ");
        sql.append(" tin.fmonthpnlqty = nvl(tin.fmonthpnlqty,0) + nvl(tout.monthpnlqty,0), ");
        sql.append(" tin.fyearpnlqty  = nvl(tin.fyearpnlqty,0) + nvl(tout.monthpnlqty,0), ");
        sql.append(" tin.fdetailcount   = nvl(tin.fdetailcount,0) + tout.flogcount ");
        sql.append(" WHEN NOT MATCHED THEN INSERT ");
        sql.append(" (").append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" fcurrencyid, ");
        }
        if (balanceType == 2) {
            sql.append(" fassistgrpid, ");
        } else if (balanceType == 3) {
            sql.append(" fassistgrpid, ");
            sql.append(" fmeasureunitid, ");
        }
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fmonthpnlfor, fyearpnlfor, fendbalancefor, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fmonthpnllocal, fyearpnllocal, fendbalancelocal, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fmonthpnlrpt, fyearpnlrpt, fendbalancerpt, ");
        }
        sql.append(" fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fmonthpnlqty, fyearpnlqty, fendqty, fdetailcount) ");
        sql.append(" VALUES ");
        sql.append(" (").append(this.getOrgSelectorV("tout")).append("tout.orgunitid, tout.period, tout.accountid, ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" tout.currencyid, ");
        }
        if (balanceType == 2) {
            sql.append(" tout.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append(" tout.assistgrpid, ");
            sql.append(" tout.measureunitid, ");
        }
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" tout.debitfor, tout.creditfor, tout.debitfor, tout.creditfor, tout.monthpnlfor, tout.monthpnlfor, tout.debitfor - tout.creditfor, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" tout.debitlocal, tout.creditlocal, tout.debitlocal, tout.creditlocal, tout.monthpnllocal, tout.monthpnllocal, tout.debitlocal - tout.creditlocal, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" tout.debitrpt, tout.creditrpt, tout.debitrpt, tout.creditrpt, tout.monthpnlrpt, tout.monthpnlrpt, tout.debitrpt - tout.creditrpt, ");
        }
        sql.append(" tout.debitqty,tout.creditqty,tout.debitqty,tout.creditqty,nvl(tout.monthpnlqty,0), nvl(tout.monthpnlqty,0), tout.debitqty - tout.creditqty,tout.flogcount) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void doInsertEmptyBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTable(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        boolean useRpt = Boolean.valueOf(sysParams.get("G001").toString());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(balanceTableName);
        sql.append("(").append(this.getOrgSelector()).append("forgunitid, ");
        if (isForCurrency) {
            sql.append("fcurrencyid, ");
        }
        sql.append("faccountid, fperiod");
        if (balanceType == 2) {
            sql.append(", fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", fassistgrpid ");
            sql.append(", fmeasureunitid ");
        }
        sql.append(") ");
        sql.append(" select distinct ").append(this.getOrgSelectorV("t")).append("t.orgunitid, ");
        if (isForCurrency) {
            sql.append("t.currencyid, ");
        }
        sql.append("t.accountid, t.period");
        if (balanceType == 2) {
            sql.append(", t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", t.assistgrpid ");
            sql.append(", t.measureunitid ");
        }
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype);
        if (isForCurrency) {
            sql.append(" and t.currencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            sql.append(" and t.currencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("' \n");
        }
        sql.append(" and not exists ( ");
        sql.append(" select 1 from ").append(balanceTableName).append(" b ");
        sql.append(" where b.").append(this.getOrgColumnNameB()).append(" = t.").append(this.getOrgColumnNameBV()).append(" ");
        sql.append(" and b.forgunitid = t.orgunitid ");
        sql.append(" and b.fperiod = t.period ");
        if (isForCurrency) {
            sql.append(" and b.fcurrencyid = t.currencyid ");
        }
        sql.append(" and b.faccountid = t.accountid ");
        if (balanceType == 2) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
            sql.append(" and b.fmeasureunitid = t.measureunitid ");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void doUpdateBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTable(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update /*+ NOT_GEN_EXISTS*/ ").append(balanceTableName).append(" set (");
        if (isForCurrency) {
            sql.append(" FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor,");
            sql.append(" FMonthPnLFor, FYearPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal,");
            sql.append(" FMonthPnLLocal, FYearPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt,");
            sql.append(" FMonthPnLRpt, FYearPnLRpt, ");
        }
        sql.append(" FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty,");
        sql.append(" FMonthPnLQty, FYearPnLQty ");
        sql.append(" ,FDetailCount ");
        sql.append(") = (");
        sql.append(" select ");
        if (isForCurrency) {
            sql.append(" FDebitFor + t.DebitFor, FYearDebitFor + t.DebitFor,FCreditFor + t.CreditFor, FYearCreditFor + t.CreditFor,FEndBalanceFor + t.DebitFor - t.CreditFor,");
            sql.append(" FMonthPnLFor + t.MonthPnLFor, FYearPnLFor + t.MonthPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal + t.DebitLocal,  FYearDebitLocal + t.DebitLocal, FCreditLocal + t.CreditLocal, FYearCreditLocal + t.CreditLocal, FEndBalanceLocal + t.DebitLocal - t.CreditLocal, ");
            sql.append(" FMonthPnLLocal + t.MonthPnLLocal, FYearPnLLocal + t.MonthPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt + t.DebitRpt, FYearDebitRpt + t.DebitRpt, FCreditRpt + t.CreditRpt, FYearCreditRpt + t.CreditRpt, FEndBalanceRpt + t.DebitRpt - t.CreditRpt, ");
            sql.append(" FMonthPnLRpt + t.MonthPnLRpt, FYearPnLRpt + t.MonthPnLRpt,");
        }
        sql.append(" FDebitQty + t.DebitQty, FYearDebitQty + t.DebitQty, FCreditQty + t.CreditQty, FYearCreditQty + t.CreditQty, FEndQty + t.DebitQty - t.CreditQty, ");
        sql.append(" isNull(FMonthPnLQty,0) + t.MonthPnLQty, isNull(FYearPnLQty,0) + t.MonthPnLQty ");
        sql.append(" ,case when isnull(FDetailCount,0)+ t.FLogCount < 0 then 0 else isnull(FDetailCount,0)+ t.FLogCount end ");
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" ");
        sql.append(" and t.orgunitid = forgunitid ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" and t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype);
        sql.append(" ) ");
        sql.append(" where exists ");
        sql.append(" (select 1 from ").append(tempTableName).append(" t ");
        sql.append(" where t.").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" ");
        sql.append(" and t.orgunitid = forgunitid ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" and t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _initAccountBalance(Context ctx, String companyID, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        logger.error((Object)("PcaBalance.initAccountBalance companyID : " + companyID));
        String profitCenterId = null;
        String orgUnitId = null;
        if (companyID != null && companyID.contains(",")) {
            profitCenterId = companyID.split(",")[0];
            orgUnitId = companyID.split(",")[1];
        }
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAccountBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAccountBalance(Context ctx, String profitCenterId, String orgUnitId, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_AccountBalance = this.getBalanceTable(1, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_AccountBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        insertSql.append("and ab.forgunitid = ? \r\n");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (acctIDs != null && !"".equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(") \r\n");
        }
        insertSql.append("and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_AccountBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid = ab.forgunitid and ab1.fperiod = ? and ab1.faccountid=ab.faccountid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"initAccountBalance_insertstart1", (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()});
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer().append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n").append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, ").append(T_AccountBalance).append(".").append("fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, ").append(T_AccountBalance).append(".").append("fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, ").append(T_AccountBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("beginqty * fdc, beginqty * fdc + fdebitqty - fcreditqty, isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ").append("ab.forgunitid orgunitid, ab.faccountid accountid, ab.fcurrencyid currencyid, ").append("ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fbeginqty beginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n").append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and orgunitid = forgunitid and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAccountBalance_updatestart1", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer().append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = (select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + ").append(T_AccountBalance).append(".").append("fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + ").append(T_AccountBalance).append(".").append("fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + ").append(T_AccountBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("beginqty * fdc, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, beginqty * fdc + fdebitqty - fcreditqty, \r\n");
            updateSql.append("isNull(yearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fbeginqty beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n").append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAccountBalance_updatestart2", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_AccountBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            insertSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_AccountBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid = ab.forgunitid and ab1.fperiod = ? and ab1.faccountid=ab.faccountid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAccountBalance_insertfirst1", (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, fmonthpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty, fmonthpnlqty) = (select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
                updateSql.append("yearpnlfor * fdc, yearpnlfor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
                updateSql.append("yearpnllocal * fdc, yearpnllocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
                updateSql.append("yearpnlrpt * fdc, yearpnlrpt * fdc, \r\n");
            }
            updateSql.append("beginqty * fdc - yeardebitqty + yearcreditqty, yeardebitqty, yearcreditqty, yeardebitqty, yearcreditqty, beginqty * fdc, \r\n");
            updateSql.append("isNull(yearpnlqty,0) * fdc, isNull(yearpnlqty,0) * fdc \r\n");
            updateSql.append("from ( \r\n");
            updateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fbeginqty beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n").append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? \r\n");
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAccountBalance_updatefirst", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
        }
    }

    protected void _antiInitBalance(Context ctx, String companyID, String startPeriodID, String firstPeriodID, String tableName) throws BOSException {
        logger.error((Object)("PcaBalance.antiInitBalance companyID : " + companyID));
        String profitCenterId = null;
        String orgUnitId = null;
        if (companyID != null && companyID.contains(",")) {
            profitCenterId = companyID.split(",")[0];
            orgUnitId = companyID.split(",")[1];
        }
        IObjectCollection accounts = null;
        StringBuffer sb = new StringBuffer();
        if (ctx != null) {
            accounts = (IObjectCollection)ctx.get((Object)"accounts");
        }
        if (accounts != null && accounts.size() > 0) {
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo accountView = (AccountViewInfo)accounts.getObject(i);
                sb.append("'" + accountView.getId() + "',");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        String accoutViewCon = sb.toString();
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        int balanceType = this.getBalanceType(tableName);
        if (balanceType == -1) {
            return;
        }
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 1, null, accoutViewCon);
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 5, null, accoutViewCon);
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, profitCenterId, orgUnitId, startPeriod, firstPeriod, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", accoutViewCon);
    }

    protected void doAntiInitBalance(Context ctx, String profitCenterId, String orgUnitId, PeriodInfo startPeriod, PeriodInfo firstPeriod, int balanceType, int baltype, String currencyId, String accoutViewCon) throws BOSException {
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        String tableName = this.getBalanceTable(balanceType, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor = 0.0, fendbalancefor = fdebitfor-fcreditfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal = 0.0, fendbalancelocal = fdebitlocal-fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt = 0.0, fendbalancerpt = fdebitrpt-fcreditrpt, \r\n");
            }
            updateSql.append("fbeginqty = 0.0, fendqty = fdebitqty-fcreditqty \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? \r\n");
            if (accoutViewCon.length() > 0) {
                updateSql.append(" and FACCOUNTID in ( " + accoutViewCon + " )");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)("antiInitBalance1_" + tableName), (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor = 0.0, fyeardebitfor = fdebitfor, fyearcreditfor = fcreditfor, fendbalancefor = fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyearpnlfor = fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal = 0.0, fyeardebitlocal = fdebitlocal, fyearcreditlocal = fcreditlocal, fendbalancelocal = fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyearpnllocal = fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt = 0.0, fyeardebitrpt = fdebitrpt, fyearcreditrpt = fcreditrpt, fendbalancerpt = fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt = fmonthpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty = 0.0, fyeardebitqty = fdebitqty, fyearcreditqty = fcreditqty, fendqty = fdebitqty - fcreditqty, \r\n");
            updateSql.append("fyearpnlqty = isNull(fmonthpnlqty,0) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? \r\n");
            if (accoutViewCon.length() > 0) {
                updateSql.append(" and FACCOUNTID in ( " + accoutViewCon + " )");
            }
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)("antiInitBalance2_" + tableName), (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, startPeriod.getNumber()});
            StringBuffer deleteSql = new StringBuffer().append("delete from ").append(tableName).append(" where ").append(this.getOrgColumnNameB()).append(" = ? ").append("and forgunitid = ? and fperiod = ? ");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)("antiInitBalanced_" + tableName), (String)deleteSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, firstPeriod.getNumber()});
        }
    }

    protected void _initAssistBalance(Context ctx, String companyID, IObjectCollection accounts, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        logger.error((Object)("PcaBalance._initAssistBalance companyID : " + companyID));
        String profitCenterId = null;
        String orgUnitId = null;
        if (companyID != null && companyID.contains(",")) {
            profitCenterId = companyID.split(",")[0];
            orgUnitId = companyID.split(",")[1];
        }
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAssistBalance(Context ctx, String profitCenterId, String orgUnitId, IObjectCollection accounts, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_AssistBalance = this.getBalanceTable(2, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer ids = new StringBuffer();
        if (accounts != null) {
            AccountViewCollection col = (AccountViewCollection)accounts;
            int size = accounts.size();
            for (int i = 0; i < size; ++i) {
                ids.append("'").append(col.get(i).getId().toString()).append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_AssistBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
        insertSql.append("and ab.forgunitid = ? ");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (accounts != null) {
            insertSql.append("and ab.faccountid in (").append(ids).append(") ");
        }
        if (acctIDs != null && !"".equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        insertSql.append("and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid=ab.forgunitid ").append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"initAssistBalance_insertstart1", (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()});
        }
        Object[] params = new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()};
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])params);
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n");
            updateSql.append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, \r\n");
                updateSql.append(T_AssistBalance).append(".fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, \r\n");
                updateSql.append(T_AssistBalance).append(".fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, \r\n");
                updateSql.append(T_AssistBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("standardbeginqty * fdc, standardbeginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fstandardbeginqty standardbeginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and orgunitid = forgunitid \r\n");
            updateSql.append("and accountid = faccountid \r\n");
            updateSql.append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAssistBalance_updatestart1", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + ").append(T_AssistBalance).append(".fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + ").append(T_AssistBalance).append(".fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + ").append(T_AssistBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("standardbeginqty * fdc, standardyeardebitqty + fdebitqty, standardyearcreditqty + fcreditqty, standardbeginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(standardyearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fstandardyeardebitqty standardyeardebitqty, ab.fstandardyearcreditqty standardyearcreditqty, ab.fstandardbeginqty standardbeginqty, ab.fstandardyearpnlqty standardyearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append(" \r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAssistBalance_updatestart2", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_AssistBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
            insertSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (accounts != null) {
                insertSql.append("and ab.faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid=ab.forgunitid and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAssistBalance_insertfirst1", (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, fmonthpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty, fmonthpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
                updateSql.append("yearpnlfor * fdc, yearpnlfor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
                updateSql.append("yearpnllocal * fdc, yearpnllocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
                updateSql.append("yearpnlrpt * fdc, yearpnlrpt * fdc, \r\n");
            }
            updateSql.append("standardbeginqty * fdc - standardyeardebitqty + standardyearcreditqty, standardyeardebitqty, standardyearcreditqty, standardyeardebitqty, standardyearcreditqty, standardbeginqty * fdc, \r\n").append("isNull(standardyearpnlqty,0) * fdc, isNull(standardyearpnlqty,0) * fdc \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fstandardyeardebitqty standardyeardebitqty, ab.fstandardyearcreditqty standardyearcreditqty, ab.fstandardbeginqty standardbeginqty, ab.fstandardyearpnlqty standardyearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initAssistBalance_updatefirst", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
        }
    }

    protected void _initAssistMeasureBalance(Context ctx, String companyID, IObjectCollection accounts, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        logger.error((Object)("PcaBalance._initAssistBalance companyID : " + companyID));
        String profitCenterId = null;
        String orgUnitId = null;
        if (companyID != null && companyID.contains(",")) {
            profitCenterId = companyID.split(",")[0];
            orgUnitId = companyID.split(",")[1];
        }
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, profitCenterId, orgUnitId, accounts, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAssistMeasureBalance(Context ctx, String profitCenterId, String orgUnitId, IObjectCollection accounts, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_MeasureBalance = this.getBalanceTable(3, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer ids = new StringBuffer();
        if (accounts != null) {
            AccountViewCollection col = (AccountViewCollection)accounts;
            int size = accounts.size();
            for (int i = 0; i < size; ++i) {
                ids.append("'").append(col.get(i).getId().toString()).append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_MeasureBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid, fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
        insertSql.append("and ab.forgunitid = ? \r\n");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (accounts != null) {
            insertSql.append("and ab.faccountid in (").append(ids).append(") ");
        }
        if (acctIDs != null && !"".equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        insertSql.append("and ab.fmeasureunitid is not null and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_MeasureBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid = ab.forgunitid and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            PcaBalanceFacadeControllerBean.logSql((String)"initMeasureBalance_insertstart1", (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), profitCenterId, orgUnitId, startPeriod.getNumber()});
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n");
            updateSql.append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, \r\n");
                updateSql.append(T_MeasureBalance).append(".fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, \r\n");
                updateSql.append(T_MeasureBalance).append(".fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, \r\n");
                updateSql.append(T_MeasureBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("beginqty * fdc, beginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fbeginqty beginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and orgunitid = forgunitid \r\n");
            updateSql.append("and accountid = faccountid \r\n");
            updateSql.append("and assistgrpid = fassistgrpid \r\n");
            updateSql.append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initMeasureBalance_updatestart1", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + ").append(T_MeasureBalance).append(".fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + ").append(T_MeasureBalance).append(".fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + ").append(T_MeasureBalance).append(".fmonthpnlrpt, \r\n");
            }
            updateSql.append("beginqty * fdc, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, beginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(yearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, isNull(ab.fbeginqty,0) beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initMeasureBalance_updatestart2", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_MeasureBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid, fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
            insertSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (accounts != null) {
                insertSql.append("and ab.faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and ab.fmeasureunitid is not null and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_MeasureBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.forgunitid = ab.forgunitid and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initMeasureBalance_insertfirst1", (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), profitCenterId, orgUnitId, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, fmonthpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty, fmonthpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
                updateSql.append("yearpnlfor * fdc, yearpnlfor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
                updateSql.append("yearpnllocal * fdc, yearpnllocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
                updateSql.append("yearpnlrpt * fdc, yearpnlrpt * fdc, \r\n");
            }
            updateSql.append("beginqty * fdc - yeardebitqty + yearcreditqty, yeardebitqty, yearcreditqty, yeardebitqty, yearcreditqty, beginqty * fdc, \r\n").append("isNull(yearpnlqty,0) * fdc, isNull(yearpnlqty,0) * fdc \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.forgunitid orgunitid, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, isNull(ab.fbeginqty,0) beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            updateSql.append("and ab.forgunitid = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and orgunitid = forgunitid \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and forgunitid = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !"".equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                PcaBalanceFacadeControllerBean.logSql((String)"initMeasureBalance_updatefirst", (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{profitCenterId, orgUnitId, profitCenterId, orgUnitId, firstPeriod.getNumber()});
        }
    }
}

