/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.IPcaBalanceFacade;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.app.AbstractPcaBalanceFixService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class PcaBalanceFixInitFixService
extends AbstractPcaBalanceFixService {
    public PcaBalanceFixInitFixService(Context ctx, Map param) throws BOSException, EASBizException {
        super(ctx, param);
    }

    @Override
    public String execute() throws EASBizException, BOSException {
        String result;
        PeriodInfo start = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitStartPeriod(1006, this.profitCenterID);
        Object[] initParam = this.getInitParam(start);
        boolean isNewAccount = (Boolean)initParam[0];
        if (isNewAccount) {
            String disableTable = (String)initParam[3];
            result = this.doIintNewAccount(disableTable);
        } else {
            result = this.doIint();
        }
        return result;
    }

    protected String doIint() throws BOSException, EASBizException {
        String result = "Success";
        String periodfromId = this.periodfrom.getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            this.clearNextPeriod(stmt, con, this.periodfrom.getNumber(), 1);
            this.clearNextPeriod(stmt, con, this.periodfrom.getNumber(), 5);
            IPcaBalanceFacade bf = PcaBalanceFacadeFactory.getLocalInstance(this.ctx);
            bf.initAccountBalance(this.profitCenterID, periodfromId, periodfromId, this.acctIDs);
            bf.initAssistBalance(this.profitCenterID, null, periodfromId, periodfromId, this.acctIDs);
            bf.initAssistMeasureBalance(this.profitCenterID, null, periodfromId, periodfromId, this.acctIDs);
            this.updateCurPeriodBalance2(1);
            this.updateCurPeriodBalance2(5);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return result;
    }

    protected Object[] getInitParam(PeriodInfo start) throws BOSException, EASBizException {
        Object[] initParam = new Object[4];
        boolean isNewAccount = false;
        int year = 0;
        int number = 0;
        String disableTable = null;
        String sql = "select b.fperiodyear,b.fperiodnumber,a.fdisabledaccttableid from T_BD_AcctRefContrast a inner join t_bd_period b on a.fenabledperiodid=b.fid  where a.fenabledaccttableid=? and a.fcompanyid=? and a.fisenabled=1";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.accountTableID, this.companyID});
        try {
            if (rs != null && rs.next()) {
                isNewAccount = true;
                year = rs.getInt("fperiodyear");
                number = rs.getInt("fperiodnumber");
                disableTable = rs.getString("fdisabledaccttableid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (isNewAccount && (year < start.getPeriodYear() || year == start.getPeriodYear() && number < start.getPeriodNumber())) {
            isNewAccount = false;
        }
        initParam[0] = isNewAccount;
        initParam[1] = new Integer(year);
        initParam[2] = new Integer(number);
        initParam[3] = disableTable;
        return initParam;
    }

    protected String doIintNewAccount(String oldTable) throws BOSException, EASBizException {
        String result = "Success";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            this.clearNextPeriod(stmt, con, this.periodfrom.getNumber(), 1);
            this.clearNextPeriod(stmt, con, this.periodfrom.getNumber(), 5);
            this.colseNewAcctInit(stmt, con, this.periodfrom.getNumber(), 1, this.periodfrom.getNumber());
            this.updateCurPeriodBalance2(1);
            this.updateCurPeriodBalance2(5);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return result;
    }

    private void colseNewAcctInit(PreparedStatement stmt, Connection con, int curPeriod, int balType, int prePeriod) throws SQLException {
        this.doColseNewAcctInit(stmt, con, curPeriod, 1, balType, prePeriod, null);
        this.doColseNewAcctInit(stmt, con, curPeriod, 1, balType, prePeriod, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doColseNewAcctInit(stmt, con, curPeriod, 1, balType, prePeriod, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doColseNewAcctInit(stmt, con, curPeriod, 2, balType, prePeriod, null);
        this.doColseNewAcctInit(stmt, con, curPeriod, 2, balType, prePeriod, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doColseNewAcctInit(stmt, con, curPeriod, 2, balType, prePeriod, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doColseNewAcctInit(stmt, con, curPeriod, 3, balType, prePeriod, null);
        this.doColseNewAcctInit(stmt, con, curPeriod, 3, balType, prePeriod, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doColseNewAcctInit(stmt, con, curPeriod, 3, balType, prePeriod, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    private void doColseNewAcctInit(PreparedStatement stmt, Connection con, int curPeriod, int balanceType, int balType, int prePeriod, String currencyId) throws SQLException {
        String tableName = this.getBalanceTable(balanceType, balType, currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(tableName).append("                       \r\n");
        sql.append("(\t                                                            \r\n");
        sql.append("\tFOrgUnitID,                                                 \r\n");
        sql.append("\tFProfitCenterID,                                                 \r\n");
        sql.append("\tFPeriod,                                                  \r\n");
        sql.append("\tFAccountID,                                                 \r\n");
        if (1 != balanceType) {
            sql.append("\tFAssistGrpID,                                               \r\n");
        }
        sql.append("\tFCurrencyID,                                                \r\n");
        if (3 == balanceType) {
            sql.append("\tFMeasureUnitID,                                               \r\n");
        }
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append("\tFBeginBalanceLocal ,                                        \r\n");
            sql.append("\tFYearDebitLocal ,                                           \r\n");
            sql.append("\tFYearCreditLocal ,                                          \r\n");
            sql.append("\tFEndBalanceLocal ,                                          \r\n");
            sql.append("                                                             \r\n");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append("\tFBeginBalanceRpt ,                                          \r\n");
            sql.append("\tFYearDebitRpt ,                                             \r\n");
            sql.append("\tFYearCreditRpt ,                                            \r\n");
            sql.append("\tFEndBalanceRpt ,                                            \r\n");
            sql.append("\t                                                            \r\n");
        } else {
            sql.append("\tFBeginBalanceFor ,                                          \r\n");
            sql.append("\tFYearDebitFor ,                                             \r\n");
            sql.append("\tFYearCreditFor ,                                            \r\n");
            sql.append("\tFEndBalanceFor ,                                            \r\n");
            sql.append("                                                                \r\n");
        }
        sql.append("\tFYearPnLFor,                                                \r\n");
        sql.append("\tFYearPnLLocal,                                              \r\n");
        sql.append("\tFYearPnLRpt,                                                \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginQty,                                                  \r\n");
        sql.append("\tFYearDebitQty,                                              \r\n");
        sql.append("\tFYearCreditQty,                                             \r\n");
        sql.append("\tFEndQty,                                                     \r\n");
        sql.append("\tFYearPnLQty,                                                \r\n");
        sql.append("\tFPeriodYear,                                                     \r\n");
        sql.append("\tFPeriodNumber                                                     \r\n");
        sql.append(")                                                               \r\n");
        sql.append("                                                                \r\n");
        sql.append("Select                                                          \r\n");
        sql.append("\tFOrgUnitID,                                                 \r\n");
        sql.append("\tFProfitCenterID,                                                 \r\n");
        sql.append("\t'").append(curPeriod).append("' as FNextPeriod,             \r\n");
        sql.append("\tb.fnewacctid,                                                   \r\n");
        if (1 != balanceType) {
            sql.append("\ta.FAssistGrpID,                                               \r\n");
        }
        sql.append("\ta.FCurrencyID,                                                \r\n");
        if (3 == balanceType) {
            sql.append("    FMeasureUnitID,                                                       \r\n");
        }
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append("    FEndBalanceLocal ,                           \t\t\t\t  \r\n");
            sql.append("\t0 ,                                        \t\t\t\t\t  \r\n");
            sql.append("\t0 ,                                     \t\t\t\t      \r\n");
            sql.append("\tFEndBalanceLocal  ,                                           \r\n");
            sql.append("                                                                \r\n");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append("    FEndBalanceRpt   ,                              \r\n");
            sql.append("\t0 ,                                             \r\n");
            sql.append("\t0 ,                                            \r\n");
            sql.append("\tFEndBalanceRpt  ,                                            \r\n");
            sql.append("\t                                                            \r\n");
        } else {
            sql.append("    FEndBalanceFor ,                                \r\n");
            sql.append("\t0 ,                                             \r\n");
            sql.append("\t0 ,                                            \r\n");
            sql.append("\tFEndBalanceFor   ,                                            \r\n");
            sql.append("                                                                \r\n");
        }
        sql.append("\t0,                                                \r\n");
        sql.append("\t0,                                              \r\n");
        sql.append("\t0,                                                \r\n");
        sql.append("                                                                \r\n");
        sql.append("    FEndQty  ,                                      \r\n");
        sql.append("\t0,                                              \r\n");
        sql.append("\t0,                                             \r\n");
        sql.append("\tFEndQty,                                                      \r\n");
        sql.append("\t0,                                                \r\n");
        sql.append("\ta.FPeriodYear,                                                 \r\n");
        sql.append("\ta.FPeriodNumber                                                 \r\n");
        sql.append("From ").append(tableName).append(" a,T_BD_AcctRefContrastentry b,T_BD_AcctRefContrast E                                          \r\n");
        sql.append("    Where a.FProfitCenterID = ? and a.FPeriod = ?               \r\n");
        sql.append("    and b.facctrefcontrastid=E.FID and E.fcompanyid=?        \r\n");
        sql.append("    and E.Fenabledaccttableid=?   AND a.faccountid=b.foldacctid     and ( FEndQty<>0         \r\n");
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append("   or FEndBalanceLocal<>0                           \t\t\t\t  \r\n");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append("  or FEndBalanceRpt<>0\t   \r\n");
        } else {
            sql.append("  or  FEndBalanceFor<>0              \r\n");
        }
        sql.append(")");
        if (this.acctIDs != null && !"".equals(this.acctIDs)) {
            sql.append(" and a.faccountid in(").append(this.acctIDs).append(")                 \r\n");
        }
        sql.append(";                                                               \r\n");
        stmt = con.prepareStatement(sql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.profitCenterID);
        stmt.setInt(index++, prePeriod);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.companyID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)this.accountTableID);
        stmt.executeUpdate();
        stmt.close();
    }
}

