/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PcaBalanceRepairer {
    private static String RESOURCE = "com.kingdee.eas.ma.pca.PcaResource";

    public static void test(Context ctx) throws EASBizException, BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String tableId = company.getAccountTable().getId().toString();
        HashSet accountNumbers = new HashSet();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", companyId);
        params.put("accountNumbers", accountNumbers);
        PeriodInfo periodfrom = new PeriodInfo();
        periodfrom.setNumber(201510);
        params.put("periodfrom", periodfrom);
        PeriodInfo periodto = new PeriodInfo();
        periodto.setNumber(201512);
        params.put("periodto", periodto);
        params.put("repairAccount", true);
        params.put("repairAssist", true);
        params.put("repairMeasure", true);
        PcaBalanceRepairer.repair(ctx, params);
    }

    public static Map<String, Object> repair(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isQtyAsst;
        boolean isUseRpt;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyId = (String)params.get("companyId");
        String profitCenterId = (String)params.get("profitCenterId");
        Set accountNumbers = (Set)params.get("accountNumbers");
        int startPeriod = ((PeriodInfo)params.get("periodfrom")).getNumber();
        int endPeriod = ((PeriodInfo)params.get("periodto")).getNumber();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("accountTable.name");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        PeriodInfo start = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitStartPeriod(1006, profitCenterId);
        PeriodInfo current = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(1006, profitCenterId);
        if (current == null || start == null) {
            result.put("message", ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1001", (Locale)ctx.getLocale()));
            return result;
        }
        EntityViewInfo view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        selector.add("isAdjustPeriod");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)current.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)start.getNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)endPeriod, CompareType.LESS_EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        PeriodCollection periodCol = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        if (periodCol.size() <= 0) {
            result.put("message", ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1002", (Locale)ctx.getLocale()));
            return result;
        }
        int maxAfterCount = 5;
        String sql = "select FValue from T_GL_AnaConfig where FKey = 'AnaBal_MaxRepair' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            int i;
            if (rs.next() && (i = Integer.parseInt(rs.getString("FValue"))) >= 0 && i <= 1200) {
                maxAfterCount = i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        int afterCount = 0;
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo period = periodCol.get(i);
            periods.add(period);
            if (period.getNumber() > current.getNumber() && ++afterCount >= maxAfterCount) break;
        }
        PeriodInfo first = null;
        if (((PeriodInfo)periods.get(0)).getNumber() == start.getNumber() && start.getPeriodNumber() != 1) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)current.getPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(start.getPeriodYear() * 100 + 1)));
            view.setFilter(filter);
            periodCol = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
            if (periodCol.size() > 0) {
                first = periodCol.get(0);
            }
        }
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        hmParamIn.put("G010", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        try {
            isUseRpt = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"G001"});
        }
        try {
            isQtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"G010"});
        }
        params.put("isUseRpt", isUseRpt);
        params.put("isQtyAsst", isQtyAsst);
        Set<String> parentAccountIds = new HashSet<String>();
        Set<String> leafAccountIds = new HashSet<String>();
        if (accountNumbers == null || accountNumbers.size() == 0) {
            PcaBalanceRepairer.repair(ctx, params, profitCenterId, periods, current, start, first, parentAccountIds, leafAccountIds);
        } else {
            List<Map<String, Object>> constrasts = PcaBalanceRepairer.getAccountRefConstrasts(ctx, companyId, (PeriodInfo)periods.get(0));
            if (constrasts.size() == 0) {
                Map<String, Set<String>> map = PcaBalanceRepairer.getAccountIds(ctx, companyId, company.getAccountTable().getId().toString(), accountNumbers);
                parentAccountIds = map.get("parent");
                leafAccountIds = map.get("leaf");
                PcaBalanceRepairer.repair(ctx, params, profitCenterId, periods, current, start, first, parentAccountIds, leafAccountIds);
            } else {
                HashMap<String, Object> last = new HashMap<String, Object>();
                last.put("periodNumber", 999913);
                last.put("disableAcctTableID", company.getAccountTable().getId().toString());
                constrasts.add(last);
                int pIndex = 0;
                for (int cIndex = 0; cIndex < constrasts.size(); ++cIndex) {
                    Map<String, Object> constrast = constrasts.get(cIndex);
                    int periodNumber = (Integer)constrast.get("periodNumber");
                    String disableAcctTableID = (String)constrast.get("disableAcctTableID");
                    ArrayList<PeriodInfo> disablePeriods = new ArrayList<PeriodInfo>();
                    while (pIndex < periods.size()) {
                        PeriodInfo period = (PeriodInfo)periods.get(pIndex);
                        if (period.getNumber() < periodNumber) {
                            disablePeriods.add(period);
                        } else if (period.getNumber() >= periodNumber) {
                            if (period.getNumber() != periodNumber) break;
                            disablePeriods.add(period);
                            break;
                        }
                        ++pIndex;
                    }
                    if (disablePeriods.size() <= 0) continue;
                    Map<String, Set<String>> map = PcaBalanceRepairer.getAccountIds(ctx, companyId, disableAcctTableID, accountNumbers);
                    parentAccountIds = map.get("parent");
                    leafAccountIds = map.get("leaf");
                    PcaBalanceRepairer.repair(ctx, params, profitCenterId, disablePeriods, current, start, (PeriodInfo)(cIndex == 0 ? first : null), parentAccountIds, leafAccountIds);
                }
            }
        }
        boolean onlyClean = (Boolean)params.get("onlyClean");
        result.put("status", "Success");
        String action = ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1003", (Locale)ctx.getLocale());
        if (onlyClean) {
            action = ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1004", (Locale)ctx.getLocale());
        }
        if (accountNumbers.size() > 0) {
            result.put("message", ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1005", (Locale)ctx.getLocale(), (Object[])new Object[]{((PeriodInfo)periods.get(0)).getNumber(), ((PeriodInfo)periods.get(periods.size() - 1)).getNumber(), accountNumbers}));
        } else {
            result.put("message", ResourceBase.getString((String)RESOURCE, (String)"PcaBalanceRepairer1006", (Locale)ctx.getLocale(), (Object[])new Object[]{((PeriodInfo)periods.get(0)).getNumber(), ((PeriodInfo)periods.get(periods.size() - 1)).getNumber()}));
        }
        return result;
    }

    private static List<Map<String, Object>> getAccountRefConstrasts(Context ctx, String companyId, PeriodInfo startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  p.FNumber FPeriodNumber, c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("join T_bd_Period p on p.FID = c.FEnabledPeriodID \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        sql.append("  and p.FNumber >= ? \n");
        sql.append("order by p.FNumber \n");
        ArrayList<Map<String, Object>> constrasts = new ArrayList<Map<String, Object>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, startPeriod.getNumber()});
        try {
            while (rs.next()) {
                HashMap<String, Object> constrast = new HashMap<String, Object>();
                constrast.put("periodNumber", rs.getInt("FPeriodNumber"));
                constrast.put("disableAcctTableID", rs.getString("FDisabledAcctTableID"));
                constrasts.add(constrast);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return constrasts;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, String tableId, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        sql.append("where av.FCompanyID = ? \n");
        sql.append("  and av.FAccountTableID = ? \n");
        params.add(companyId);
        params.add(tableId);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
            params.add(accountNumbers.iterator().next());
        } else {
            sql.append("  and av.FNumber in " + PcaBalanceRepairer.toInSql(accountNumbers) + " \n");
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> parentAccountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("parent", parentAccountIds);
        result.put("leaf", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                if (rs.getInt("FIsLeaf") == 1) {
                    leafAccountIds.add(rs.getString("FID"));
                    continue;
                }
                parentAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static void repair(Context ctx, Map params, String profitCenterId, List<PeriodInfo> periods, PeriodInfo current, PeriodInfo start, PeriodInfo first, Set<String> parentAccountIds, Set<String> leafAccountIds) throws BOSException {
        boolean repairAccount = (Boolean)params.get("repairAccount");
        boolean repairAssist = (Boolean)params.get("repairAssist");
        boolean repairMeasure = (Boolean)params.get("repairMeasure");
        boolean onlyClean = (Boolean)params.get("onlyClean");
        boolean isUseRpt = (Boolean)params.get("isUseRpt");
        boolean isQtyAsst = (Boolean)params.get("isQtyAsst");
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.addAll(parentAccountIds);
        accountIds.addAll(leafAccountIds);
        List<PeriodInfo> clears = periods;
        if (first != null) {
            clears = new ArrayList<PeriodInfo>(periods.size() + 1);
            clears.add(first);
            clears.addAll(periods);
        }
        if (repairAccount) {
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 1, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 5, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (repairAssist) {
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 1, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 5, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (repairMeasure && isQtyAsst) {
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 1, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 5, null);
            PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                PcaBalanceRepairer.clearBalance(ctx, profitCenterId, clears, accountIds, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (onlyClean) {
            return;
        }
        String T_TMP_Table = null;
        try {
            T_TMP_Table = PcaBalanceRepairer.createTempTable(ctx, 1);
            PeriodInfo period = null;
            PeriodInfo prePeriod = null;
            for (int i = 0; i < periods.size(); ++i) {
                period = periods.get(i);
                if (prePeriod == null) {
                    prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                }
                if (repairAccount) {
                    PcaBalanceRepairer.doRepair(ctx, params, profitCenterId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 1);
                }
                if (repairAssist) {
                    PcaBalanceRepairer.doRepair(ctx, params, profitCenterId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 2);
                }
                if (repairMeasure && isQtyAsst) {
                    PcaBalanceRepairer.doRepair(ctx, params, profitCenterId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 3);
                }
                prePeriod = period;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (T_TMP_Table != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Table);
            }
        }
    }

    private static void clearBalance(Context ctx, String profitCenterId, List<PeriodInfo> periods, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_Balance = PCABalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(profitCenterId);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + T_Balance + " \n");
        sql.append("where FProfitCenterId = ? \n");
        if (periods.size() == 1) {
            sql.append("  and FPeriod = ? \n");
            params.add(periods.get(0).getNumber());
        } else {
            HashSet<Integer> periodNumbers = new HashSet<Integer>();
            for (int i = 0; i < periods.size(); ++i) {
                periodNumbers.add(periods.get(i).getNumber());
            }
            sql.append("  and FPeriod in " + PcaBalanceRepairer.toInSql(periodNumbers));
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and FAccountID = ? \n");
                params.add(accountIds.iterator().next());
            } else {
                sql.append("  and FAccountID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private static void doRepair(Context ctx, Map params, String profitCenterId, PeriodInfo current, PeriodInfo start, PeriodInfo first, PeriodInfo period, PeriodInfo prePeriod, String T_TMP_Table, Set<String> parentAccountIds, Set<String> leafAccountIds, int balanceType) throws Exception {
        boolean isUseRpt = (Boolean)params.get("isUseRpt");
        DbUtil.execute((Context)ctx, (String)("delete from " + T_TMP_Table));
        if (period.getId().equals((Object)start.getId())) {
            PcaBalanceRepairer.insertStart(ctx, T_TMP_Table, profitCenterId, current, start, leafAccountIds, balanceType);
        } else {
            PcaBalanceRepairer.insertBegin(ctx, T_TMP_Table, profitCenterId, period, prePeriod, leafAccountIds, balanceType, 5);
        }
        PcaBalanceRepairer.insertCurrent(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 5);
        PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 5, null);
        PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        if (isUseRpt) {
            PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        if (period.getNumber() < current.getNumber() && !period.isIsAdjustPeriod()) {
            PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, null);
            PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        } else {
            DbUtil.execute((Context)ctx, (String)("delete from " + T_TMP_Table));
            if (period.getId().equals((Object)start.getId())) {
                PcaBalanceRepairer.insertStart(ctx, T_TMP_Table, profitCenterId, current, start, leafAccountIds, balanceType);
            } else {
                PcaBalanceRepairer.insertBegin(ctx, T_TMP_Table, profitCenterId, period, prePeriod, leafAccountIds, balanceType, 1);
            }
            PcaBalanceRepairer.insertCurrent(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1);
            PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, null);
            PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.buildBalance(ctx, T_TMP_Table, profitCenterId, period, leafAccountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (balanceType == 1 && (parentAccountIds.size() > 0 || leafAccountIds.size() == 0)) {
            PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 5, null);
            PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 1, null);
            PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
                PcaBalanceRepairer.buildParent(ctx, profitCenterId, period, parentAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (period.getId().equals((Object)start.getId()) && first != null) {
            HashSet<String> accountIds = new HashSet<String>();
            accountIds.addAll(parentAccountIds);
            accountIds.addAll(leafAccountIds);
            PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 5, null);
            PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 1, null);
            PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
                PcaBalanceRepairer.buildFirst(ctx, profitCenterId, current, start, first, accountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
    }

    private static String createTempTable(Context ctx, int balanceType) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_TMP_Table ( ");
        sql.append("  FOrgUnitID         VARCHAR(44),");
        sql.append("  FAccountID         VARCHAR(44),");
        sql.append("  FCurrencyID        VARCHAR(44),");
        sql.append("  FAssGrpID          VARCHAR(44),");
        sql.append("  FMeasureUnitID     VARCHAR(44),");
        sql.append("  FBeginBalanceFor   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitFor          NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditFor         NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitFor      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditFor     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlFor       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlFor        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceFor     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitLocal        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditLocal       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitLocal    NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditLocal   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlLocal     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlLocal      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceLocal   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginBalanceRpt   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitRpt          NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditRpt         NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitRpt      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditRpt     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlRpt       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlRpt        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceRpt     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginQty          NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FDebitQty          NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FCreditQty         NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearDebitQty      NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearCreditQty     NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FMonthPnlQty       NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearPnlQty        NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FEndQty            NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FDetailCount       int DEFAULT 0");
        sql.append(") \n");
        String T_TMP_Table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        return T_TMP_Table;
    }

    public static void insertStart(Context ctx, String T_TMP_Table, String profitCenterId, PeriodInfo current, PeriodInfo start, Set<String> accountIds, int balanceType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FOrgUnitID, FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FOrgUnitID, b.FAccountID, b.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        sql.append("  b.FBeginBalanceFor * av.fdc, 0, 0, b.FYearDebitFor, b.FYearCreditFor, 0, b.FYearPnlFor * av.fdc, 0, \n");
        sql.append("  b.FBeginBalanceLocal * av.fdc, 0, 0, b.FYearDebitLocal, b.FYearCreditLocal, 0, b.FYearPnlLocal * av.fdc, 0, \n");
        sql.append("  b.FBeginBalanceRpt * av.fdc, 0, 0, b.FYearDebitRpt, b.FYearCreditRpt, 0, b.FYearPnlRpt * av.fdc, 0, \n");
        if (balanceType == 2) {
            sql.append("  b.FStandardBeginQty * av.fdc, 0, 0, b.FStandardYearDebitQty, b.FStandardYearCreditQty, 0, b.FStandardYearPnlQty * av.fdc, 0, \n");
        } else {
            sql.append("  b.FBeginQty * av.fdc, 0, 0, b.FYearDebitQty, b.FYearCreditQty, 0, b.FYearPnlQty * av.fdc, 0, \n");
        }
        sql.append("  0 \n");
        if (balanceType == 1) {
            sql.append("from T_PCA_InitPcAccountBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'pcainit' and f.FValue = 'true' \n");
            }
        } else {
            sql.append("from T_PCA_InitPcAssistBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID and f.FValue = 'true' \n");
            }
        }
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FProfitCenterID = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("  and b.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
        sql.append("  and b.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        if (balanceType == 3) {
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        Object[] params = accountIds.size() == 1 ? new Object[]{profitCenterId, accountIds.iterator().next()} : new Object[]{profitCenterId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    public static void insertBegin(Context ctx, String T_TMP_Table, String profitCenterId, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balanceType, int balType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        boolean isNextYear = period.getPeriodYear() != prePeriod.getPeriodYear();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FOrgUnitID, FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FOrgUnitID, b.FAccountID, b.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        if (isNextYear) {
            sql.append("  b.FEndBalanceFor, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndBalanceLocal, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndBalanceRpt, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndQty, 0, 0, 0, 0, 0, 0, 0, \n");
        } else {
            sql.append("  b.FEndBalanceFor, 0, 0, b.FYearDebitFor, b.FYearCreditFor, 0, b.FYearPnlFor, 0, \n");
            sql.append("  b.FEndBalanceLocal, 0, 0, b.FYearDebitLocal, b.FYearCreditLocal, 0, b.FYearPnlLocal, 0, \n");
            sql.append("  b.FEndBalanceRpt, 0, 0, b.FYearDebitRpt, b.FYearCreditRpt, 0, b.FYearPnlRpt, 0, \n");
            sql.append("  b.FEndQty, 0, 0, b.FYearDebitQty, b.FYearCreditQty, 0, b.FYearPnlQty, 0, \n");
        }
        sql.append("  0 \n");
        sql.append("from " + PCABalanceUtils.getBalanceTable(balanceType, balType, null) + " b \n");
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FProfitCenterID = ? \n");
        sql.append("  and b.FPeriod = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        if (balanceType == 3) {
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        if (balanceType == 2 || balanceType == 3) {
            if (isNextYear) {
                sql.append("and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndBalanceRpt <> 0 or b.FEndQty <> 0) \n");
            } else {
                sql.append("and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndBalanceRpt <> 0 or b.FEndQty <> 0 \n");
                sql.append("  or b.FYearDebitFor <> 0 or b.FYearCreditFor <> 0 or b.FYearPnlFor <> 0 \n");
                sql.append("  or b.FYearDebitLocal <> 0 or b.FYearCreditLocal <> 0 or b.FYearPnlLocal <> 0 \n");
                sql.append("  or b.FYearDebitRpt <> 0 or b.FYearCreditRpt <> 0 or b.FYearPnlRpt <> 0 \n");
                sql.append("  or b.FYearDebitQty <> 0 or b.FYearCreditQty <> 0 \n");
                sql.append("  or isNull(b.FDetailCount,0) <> 0) \n");
            }
        }
        Object[] params = accountIds.size() == 1 ? new Object[]{profitCenterId, prePeriod.getNumber(), accountIds.iterator().next()} : new Object[]{profitCenterId, prePeriod.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    public static void insertCurrent(Context ctx, String T_TMP_Table, String profitCenterId, PeriodInfo period, Set<String> accountIds, int balanceType, int balType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FOrgUnitID, FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  v.FCompanyID, ve.FAccountID, ve.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  r.FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  r.FAssGrpID, case when r.FMeasureUnitID is null then '00000000-0000-0000-0000-0000000000005B825C57' else r.FMeasureUnitID end, \n");
        }
        if (balanceType == 1) {
            sql.append("  0, sum(ve.FOriginalAmount * ve.FEntryDC) FDebitFor, sum(ve.FOriginalAmount * (1 - ve.FEntryDC)) FCreditFor, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fOriginalAmount else 0 end) FMonthPnlFor, 0, 0, \n");
            sql.append("  0, sum(ve.FLocalAmount * ve.FEntryDC) FDebitLocal, sum(ve.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocal, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fLocalAmount else 0 end) FMonthPnlLocal, 0, 0, \n");
            sql.append("  0, sum(ve.FReportingAmount * ve.FEntryDC) FDebitRpt, sum(ve.FReportingAmount * (1 - ve.FEntryDC)) FCreditRpt, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fReportingAmount else 0 end) FMonthPnlRpt, 0, 0, \n");
            sql.append("  0, sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FStandardQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            sql.append("  count(ve.FID) \n");
        } else {
            sql.append("  0, sum(r.FOriginalAmount * ve.FEntryDC) FDebitFor, sum(r.FOriginalAmount * (1 - ve.FEntryDC)) FCreditFor, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fOriginalAmount else 0 end) FMonthPnlFor, 0, 0, \n");
            sql.append("  0, sum(r.FLocalAmount * ve.FEntryDC) FDebitLocal, sum(r.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocal, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fLocalAmount else 0 end) FMonthPnlLocal, 0, 0, \n");
            sql.append("  0, sum(r.FReportingAmount * ve.FEntryDC) FDebitRpt, sum(r.FReportingAmount * (1 - ve.FEntryDC)) FCreditRpt, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fReportingAmount else 0 end) FMonthPnlRpt, 0, 0, \n");
            if (balanceType == 2) {
                sql.append("  0, sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
                sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FStandardQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            } else {
                sql.append("  0, sum(r.FQuantity * ve.FEntryDC) FDebitQty, sum(r.FQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
                sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            }
            sql.append("  count(r.FID) \n");
        }
        sql.append("from T_PCA_PCVoucher v \n");
        sql.append("inner join T_PCA_PCVoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
        sql.append("inner join t_bd_accounttype acctType on acctType.fid = av.faccounttypeid \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("inner join T_PCA_PCVoucherAssistRecord r on r.FEntryID = ve.FID \n");
            if (balanceType == 3) {
                sql.append("inner join T_BD_AssistantHG hg on hg.FID = r.FAssGrpID \n");
                sql.append("inner join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
            }
        }
        sql.append("where v.FProfitCenterID = ? \n");
        sql.append("and v.FPeriodID = ? \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("and r.FAssGrpID is not null \n");
            if (balanceType == 3) {
                sql.append("and av.FIsQty = 1 and aa.FIsQty = 1 \n");
            }
        }
        if (balType == 1) {
            sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
        } else {
            sql.append("        and v.FbizStatus = 5 \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and ve.FAccountID = ? \n");
            } else {
                sql.append("  and ve.FAccountID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("group by v.FCompanyID, ve.FAccountID, ve.FCurrencyID \n");
        if (balanceType == 2) {
            sql.append("  ,r.FAssGrpID \n");
        } else if (balanceType == 3) {
            sql.append("  ,r.FAssGrpID, r.FMeasureUnitID \n");
        }
        Object[] params = accountIds.size() == 1 ? new Object[]{profitCenterId, period.getId().toString(), accountIds.iterator().next()} : new Object[]{profitCenterId, period.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private static void buildBalance(Context ctx, String T_TMP_Table, String profitCenterId, PeriodInfo period, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_AccountBalance = PCABalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FProfitCenterID, FOrgUnitID, FPeriod, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssistGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  ?, FOrgUnitID, ?, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor+FDebitFor), sum(FYearCreditFor+FCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), sum(FYearPnlFor+FMonthPnlFor), \n");
            sql.append("  sum(FBeginBalanceFor) + sum(FDebitFor) - sum(FCreditFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal+FDebitLocal), sum(FYearCreditLocal+FCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), sum(FYearPnlLocal+FMonthPnlLocal), \n");
            sql.append("  sum(FBeginBalanceLocal) + sum(FDebitLocal) - sum(FCreditLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt+FDebitRpt), sum(FYearCreditRpt+FCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), sum(FYearPnlRpt+FMonthPnlRpt), \n");
            sql.append("  sum(FBeginBalanceRpt) + sum(FDebitRpt) - sum(FCreditRpt), \n");
        }
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty+FDebitQty), sum(FYearCreditQty+FCreditQty), \n");
        sql.append("  sum(FMonthPnlQty), sum(FYearPnlQty+FMonthPnlQty), \n");
        sql.append("  sum(FBeginQty) + sum(FDebitQty) - sum(FCreditQty), \n");
        sql.append("  sum(FDetailCount) \n");
        sql.append("from " + T_TMP_Table + " \n");
        if (balanceType == 3) {
            sql.append("where FMeasureUnitID is not null \n");
        }
        sql.append("group by FOrgUnitID, FAccountID \n");
        if (isForCurrency) {
            sql.append("  ,FCurrencyID \n");
        }
        if (balanceType == 2) {
            sql.append("  ,FAssGrpID \n");
        } else if (balanceType == 3) {
            sql.append("  ,FAssGrpID, FMeasureUnitID \n");
        }
        Object[] params = new Object[]{profitCenterId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private static void buildParent(Context ctx, String profitCenterId, PeriodInfo period, Set<String> accountIds, int balType, String currencyId) throws BOSException {
        String T_AccountBalance = PCABalanceUtils.getBalanceTable(1, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FProfitCenterID, FOrgUnitID, FPeriod, FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  t.FProfitCenterID, t.FOrgUnitID, t.FPeriod, pav.FID FAccountID, \n");
        if (isForCurrency) {
            sql.append("  t.FCurrencyID, \n");
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor), sum(FYearCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), sum(FYearPnlFor), \n");
            sql.append("  sum(FEndBalanceFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal), sum(FYearCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), sum(FYearPnlLocal), \n");
            sql.append("  sum(FEndBalanceLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt), sum(FYearCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), sum(FYearPnlRpt), \n");
            sql.append("  sum(FEndBalanceRpt), \n");
        }
        if (isForCurrency) {
            sql.append("  sum(case when pav.FIsQty = 1 then FBeginQty else 0 end), \n");
            sql.append("  sum(case when pav.FIsQty = 1 then FDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FCreditQty else 0 end), \n");
            sql.append("  sum(case when pav.FIsQty = 1 then FYearDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FYearCreditQty else 0 end), \n");
            sql.append("  sum(case when pav.FIsQty = 1 then FMonthPnlQty else 0 end), sum(case when pav.FIsQty = 1 then FYearPnlQty else 0 end), \n");
            sql.append("  sum(case when pav.FIsQty = 1 then FEndQty else 0 end), \n");
        } else {
            sql.append("  sum(FBeginQty), \n");
            sql.append("  sum(FDebitQty), sum(FCreditQty), \n");
            sql.append("  sum(FYearDebitQty), sum(FYearCreditQty), \n");
            sql.append("  sum(FMonthPnlQty), sum(FYearPnlQty), \n");
            sql.append("  sum(FEndQty), \n");
        }
        sql.append("  sum(FDetailCount) \n");
        sql.append("from " + T_AccountBalance + " t \n");
        sql.append("join t_BD_AccountView av on av.FID = t.FAccountID \n");
        sql.append("join t_BD_AccountView pav on pav.Fcompanyid = av.Fcompanyid and pav.faccounttableid = av.faccounttableid \n");
        sql.append("  and charindex(pav.FLongNumber||'!', av.FLongNumber) = 1 \n");
        sql.append("where t.FProfitCenterID = ? \n");
        sql.append("  and t.FPeriod = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and pav.FID = ? \n");
            } else {
                sql.append("  and pav.FID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("group by t.FProfitCenterID, t.FOrgUnitID, t.FPeriod, pav.FID \n");
        if (isForCurrency) {
            sql.append("  ,t.FCurrencyID \n");
        }
        Object[] params = accountIds.size() == 1 ? new Object[]{profitCenterId, period.getNumber(), accountIds.iterator().next()} : new Object[]{profitCenterId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private static void buildFirst(Context ctx, String profitCenterId, PeriodInfo current, PeriodInfo start, PeriodInfo first, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_AccountBalance = PCABalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FProfitCenterID, FOrgUnitID, FPeriod, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssistGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FProfitCenterID, b.FOrgUnitID, ?, b.FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        if (balanceType == 1) {
            if (isForCurrency) {
                sql.append("  b.FCurrencyID, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc - b.FYearDebitFor + b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearPnlFor * av.fdc, b.FYearPnlFor * av.fdc, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc, \n");
            }
            if (isLocalCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceLocal * av.fdc - b.FYearDebitLocal + b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearPnlLocal * av.fdc, b.FYearPnlLocal * av.fdc, \n");
                sql.append("  b.FBeginBalanceLocal * av.fdc, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceRpt * av.fdc - b.FYearDebitRpt + b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearPnlRpt * av.fdc, b.FYearPnlRpt * av.fdc, \n");
                sql.append("  b.FBeginBalanceRpt * av.fdc, \n");
            }
            sql.append("  b.FBeginQty * av.fdc - b.FYearDebitQty + b.FYearCreditQty, \n");
            sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
            sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
            sql.append("  b.FBeginQty * av.fdc, \n");
        } else {
            if (isForCurrency) {
                sql.append("  b.FCurrencyID, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc - b.FYearDebitFor + b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearPnlFor * av.fdc, b.FYearPnlFor * av.fdc, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc, \n");
            }
            if (isLocalCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceLocal * av.fdc - b.FYearDebitLocal + b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearPnlLocal * av.fdc, b.FYearPnlLocal * av.fdc, \n");
                sql.append("  b.FBeginBalanceLocal * av.fdc, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceRpt * av.fdc - b.FYearDebitRpt + b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearPnlRpt * av.fdc, b.FYearPnlRpt * av.fdc, \n");
                sql.append("  b.FBeginBalanceRpt * av.fdc, \n");
            }
            if (balanceType == 2) {
                sql.append("  b.FStandardBeginQty * av.fdc - b.FStandardYearDebitQty + b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardYearDebitQty, b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardYearDebitQty, b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardBeginQty * av.fdc, \n");
            } else {
                sql.append("  b.FBeginQty * av.fdc - b.FYearDebitQty + b.FYearCreditQty, \n");
                sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
                sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
                sql.append("  b.FBeginQty * av.fdc, \n");
            }
        }
        sql.append("  0 \n");
        if (balanceType == 1) {
            sql.append("from T_PCA_InitPcAccountBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'pcainit' and f.FValue = 'true' \n");
            }
        } else {
            sql.append("from T_PCA_InitPcAssistBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_PCA_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FProfitCenterID and f.FCompanyID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID and f.FValue = 'true' \n");
            }
        }
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FOrgUnitID = ? \n");
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + PcaBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        if (isForCurrency) {
            sql.append("  and b.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            sql.append("  and b.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            sql.append("  and b.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (balanceType == 3) {
            sql.append("  and b.FMeasureUnitID is not null \n");
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        Object[] params = accountIds.size() == 1 ? new Object[]{first.getNumber(), profitCenterId, accountIds.iterator().next()} : new Object[]{first.getNumber(), profitCenterId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private static String toInSql(Set ids) {
        StringBuffer sql = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if ((o = it.next()) instanceof String) {
                sql.append("'").append(o).append("'");
                continue;
            }
            sql.append(o);
        }
        return "(" + sql.toString() + ")";
    }

    public static void main(String[] args) {
        ArrayList constrasts = new ArrayList();
        HashMap<String, Object> last = new HashMap<String, Object>();
        last.put("periodNumber", 201713);
        last.put("disableAcctTableID", "table201713");
        constrasts.add(last);
        last = new HashMap();
        last.put("periodNumber", 201813);
        last.put("disableAcctTableID", "table201813");
        constrasts.add(last);
        last = new HashMap();
        last.put("periodNumber", 999912);
        last.put("disableAcctTableID", "table999912");
        constrasts.add(last);
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        PeriodInfo p = new PeriodInfo();
        p.setNumber(201612);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201613);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201701);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201702);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201703);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201704);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201705);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201706);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201707);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201708);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201709);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201710);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201711);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201712);
        periods.add(p);
        int pIndex = 0;
        for (int cIndex = 0; cIndex < constrasts.size(); ++cIndex) {
            Map constrast = (Map)constrasts.get(cIndex);
            int periodNumber = (Integer)constrast.get("periodNumber");
            String disableAcctTableID = (String)constrast.get("disableAcctTableID");
            ArrayList<PeriodInfo> disablePeriods = new ArrayList<PeriodInfo>();
            while (pIndex < periods.size()) {
                PeriodInfo period = (PeriodInfo)periods.get(pIndex);
                if (period.getNumber() < periodNumber) {
                    disablePeriods.add(period);
                } else if (period.getNumber() >= periodNumber) {
                    if (period.getNumber() != periodNumber) break;
                    disablePeriods.add(period);
                    break;
                }
                ++pIndex;
            }
            if (disablePeriods.size() <= 0) continue;
            System.out.println(disableAcctTableID + " " + disablePeriods);
        }
    }
}

