/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.ma.pca.IPcaBalanceFacade;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaPeriodEndFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractPcaClosePeriodFacadeControllerBean;
import com.kingdee.eas.ma.pca.app.PcaClosePeriodUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcaClosePeriodFacadeControllerBean
extends AbstractPcaClosePeriodFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcaClosePeriodFacadeControllerBean");
    private static final String RESOURCE_NAME = "com.kingdee.eas.ma.pca.PcaClosePeriodResource";
    public static final String MUTEX_CLOSE = "O9aN5tKYtUug1QLyvaJx9RI0Vng=_";
    public static final String ORG_PREFIX = "_org";
    public static final String ERROR_PREFIX = "_error";

    public static Uuid requestMutex(Context ctx, String orgId, String userId, String name) throws BOSException, EASBizException {
        MutexParameter mutexParam = new MutexParameter();
        Uuid requestId = Uuid.create();
        mutexParam.setRequestId(requestId);
        mutexParam.setMutexName(MUTEX_CLOSE + orgId);
        mutexParam.setActionName(name);
        mutexParam.setUserID(BOSUuid.read((String)userId));
        mutexParam.setOrgUnitID(BOSUuid.read((String)orgId));
        mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParam.setDcName(ctx.getAIS());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isSucceed = mutex.requestMutex(mutexParam);
        if (isSucceed) {
            return requestId;
        }
        return null;
    }

    public static void releaseMutex(Context ctx, Uuid requestId) throws BOSException, EASBizException {
        if (requestId != null) {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex.releaseMutex(requestId);
        }
    }

    protected String getLocaleString(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE_NAME, (String)resName, (Locale)ctx.getLocale());
    }

    private Map<String, Object> getSystemStatusCtrol(Context ctx, String orgId) throws BOSException, EASBizException {
        String loc = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID FID, \n");
        sql.append("    pc.FNumber FOrgNumber, pc.FName_" + loc + " FOrgName, \n");
        sql.append("    c.FID FCompanyID, \n");
        sql.append("    pc.FControlUnitID, c.FAccountTableID, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth, p.FBeginDate, p.FEndDate, \n");
        sql.append("    sc.FStartPeriodID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("join T_ORG_UnitRelation r on r.FFromUnitID = pc.FID \n");
        sql.append("join T_ORG_TypeRelation t on t.FID = r.FTypeRelationID \n");
        sql.append("join T_ORG_Company c on c.FID = r.FToUnitID \n");
        sql.append("where pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
        sql.append("    and s.FName = 1006 \n");
        sql.append("    and sc.FIsStart = 1 \n");
        sql.append("    and t.FFromType = 6 and t.FToType = 1 \n");
        sql.append("    and pc.FID = ? \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId});
            if (rowSet.next()) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("id", rowSet.getString("FID"));
                info.put("orgId", orgId);
                info.put("orgName", rowSet.getString("FOrgName"));
                info.put("orgNumber", rowSet.getString("FOrgNumber"));
                info.put("companyId", rowSet.getString("FCompanyID"));
                info.put("cuId", rowSet.getString("FControlUnitID"));
                info.put("accountTableId", rowSet.getString("FAccountTableID"));
                info.put("periodId", rowSet.getString("FPeriodID"));
                String periodYear = rowSet.getString("FPeriodYear");
                String periodMonth = rowSet.getString("FPeriodMonth");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodNumber = periodYear + periodMonth;
                String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
                info.put("periodYear", periodYear);
                info.put("periodMonth", periodMonth);
                info.put("periodNumber", periodNumber);
                info.put("periodName", periodName);
                info.put("beginDate", rowSet.getDate("FBeginDate"));
                info.put("endDate", rowSet.getDate("FEndDate"));
                info.put("startPeriodId", rowSet.getString("FStartPeriodID"));
                return info;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected Map _getData(Context ctx, Map params) throws BOSException, EASBizException {
        String permissionName;
        BOSUuid userId;
        HashMap<? extends String, Object> result = new HashMap<String, Object>();
        String loc = ctx.getLocale().toString();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.ProfitCenter, null, permissionName = "pca_closePeriod");
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        String orgTemp = this.dealOrgRelation(ctx, orgs, loc);
        if (params.get("getPeriodList") != null) {
            List<Map> periodList = this.getPeriodList(ctx, orgTemp, loc);
            result.put("periodList", periodList);
        } else {
            String filter = (String)params.get("filter");
            result.putAll(this.getListData(ctx, params, orgTemp, filter, loc));
        }
        return result;
    }

    private Map<? extends String, ? extends Object> getListData(Context ctx, Map params, String orgTemp, String periodId, String loc) throws BOSException {
        int i;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        LinkedList data = new LinkedList();
        result.put("records", Integer.valueOf(0));
        result.put("total", Integer.valueOf(0));
        result.put("page", Integer.valueOf(0));
        result.put("rows", data);
        result.put("rowList", data);
        int records = 0;
        Object[] param = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select \n");
        sql.append("    temp.pcOrgId FOrgID, temp.pcNumber FPcNumber, temp.pcOrgName FOrgName, \n");
        sql.append("    temp.orgId FCompanyID, temp.orgName FCompanyName, \n");
        sql.append("\tp.fdescription_" + loc + " periodName, sc.FCurrentPeriodID periodId \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("join ").append(orgTemp).append(" temp on temp.pcOrgId = sc.FProfitCenterID \n");
        sql.append("join T_ORG_ProfitCenter pc on pc.FID = temp.pcOrgId \n");
        sql.append("where s.FName = 1006 \n");
        sql.append("    and sc.FIsStart = 1 \n");
        if (!"-1".equals(periodId)) {
            sql.append("    and sc.FCurrentPeriodID = ? \n");
            param = new String[]{periodId};
        } else {
            param = new String[]{};
        }
        if (params.get("company") != null && !"".equals(params.get("company"))) {
            String[] companyIds = params.get("company").toString().split(",");
            StringBuilder companyFilter = new StringBuilder();
            if (companyIds.length > 0) {
                for (i = 0; i < companyIds.length; ++i) {
                    BOSUuid.read((String)companyIds[i]);
                    companyFilter.append("'").append(companyIds[i]).append("'").append(",");
                }
                if (companyFilter.length() > 0 && companyFilter.charAt(companyFilter.length() - 1) == ',') {
                    companyFilter.deleteCharAt(companyFilter.length() - 1);
                }
                sql.append("   and temp.orgId in ( ").append((CharSequence)companyFilter).append(") ");
            }
        }
        if (params.get("profitCenter") != null && !"".equals(params.get("profitCenter"))) {
            String[] profitCenterIds = params.get("profitCenter").toString().split(",");
            StringBuilder profitCenterFilter = new StringBuilder();
            if (profitCenterIds.length > 0) {
                for (i = 0; i < profitCenterIds.length; ++i) {
                    BOSUuid.read((String)profitCenterIds[i]);
                    profitCenterFilter.append("'").append(profitCenterIds[i]).append("'").append(",");
                }
                if (profitCenterFilter.length() > 0 && profitCenterFilter.charAt(profitCenterFilter.length() - 1) == ',') {
                    profitCenterFilter.deleteCharAt(profitCenterFilter.length() - 1);
                }
                sql.append("   and temp.pcOrgId in ( ").append((CharSequence)profitCenterFilter).append(") ");
            }
        }
        sql.append("order by  temp.LONGNUMBER,  pc.FLONGNUMBER \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            String preCompanyId = null;
            int index = 0;
            String Pre_Prefix = "_PreOrg_";
            String prefix = "_";
            records = rowSet.size();
            HashSet<String> companyList = new HashSet<String>();
            HashSet<String> orgList = new HashSet<String>();
            while (rowSet.next()) {
                String companyId = rowSet.getString("FCompanyID");
                companyList.add(companyId);
                HashMap<String, String> map = new HashMap<String, String>();
                if (preCompanyId == null || !companyId.equals(preCompanyId)) {
                    preCompanyId = companyId;
                    companyId = Pre_Prefix + companyId;
                    String companyName = rowSet.getString("FCompanyName");
                    map.put("companyName", companyName);
                }
                String id = companyId + ORG_PREFIX + ++index;
                String orgId = rowSet.getString("FOrgID");
                orgList.add(orgId);
                String orgNumber = rowSet.getString("FPcNumber");
                String orgName = rowSet.getString("FOrgName");
                String periodName = rowSet.getString("periodName");
                periodId = rowSet.getString("periodId");
                map.put("id", id);
                map.put("companyId", companyId);
                map.put("orgcb", "0");
                map.put("orgId", orgId);
                map.put("orgName", orgNumber + prefix + orgName);
                map.put("periodId", periodId);
                map.put("periodName", periodName);
                data.add(map);
            }
            result.put("records", Integer.valueOf(records));
            result.put("total", Integer.valueOf(data.size()));
            result.put("rows", data);
            result.put("rowList", data);
            result.put("companyList", companyList);
            result.put("orgList", orgList);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("getListData Exception");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String dealOrgRelation(Context ctx, FullOrgUnitCollection orgs, String loc) throws BOSException {
        String idsTemp;
        String tempateTable;
        block11: {
            String orgIdSql = "create table closePeriod_orgid (orgId varchar(44))";
            String createSql = "create table closePeriod (orgId varchar(44), longnumber varchar(100), orgName varchar(255), pcOrgId varchar(44), pcNumber varchar(100), pcOrgName varchar(255))";
            TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
            tempateTable = "";
            idsTemp = "";
            try {
                idsTemp = iPool.createTempTable(orgIdSql);
                tempateTable = iPool.createTempTable(createSql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Connection con = null;
            PreparedStatement ps = null;
            try {
                con = this.getConnection(ctx);
                String insertIds = "insert into " + idsTemp + " values(?)";
                ps = con.prepareStatement(insertIds);
                int c = 0;
                int length = orgs.size();
                for (int i = 0; i < length; ++i) {
                    ps.setString(1, orgs.get(i).getId().toString());
                    ps.addBatch();
                    if (++c % 500 != 0) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    c = 0;
                }
                if (c > 0) {
                    ps.executeBatch();
                    ps.clearBatch();
                }
                SQLUtils.cleanup((Statement)ps, (Connection)con);
            }
            catch (SQLDataException e) {
                e.printStackTrace();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(ps, (Connection)con);
            }
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(tempateTable);
        insertSql.append(" select distinct c.fid, c.flongnumber, c.fname_").append(loc).append(" orgname, pc.fid, pc.fnumber, pc.fname_").append(loc).append(" pcorgname ");
        insertSql.append(" from ").append(idsTemp).append(" temp ");
        insertSql.append(" join T_ORG_ProfitCenter pc on temp.orgId = pc.FID \n");
        insertSql.append(" join T_ORG_UnitRelation r on r.FFromUnitID = pc.FID \n");
        insertSql.append(" join T_ORG_TypeRelation t on t.FID = r.FTypeRelationID \n");
        insertSql.append(" join T_ORG_Company c on c.FID = r.FToUnitID \n");
        insertSql.append(" where pc.FIsBizUnit = 1 and pc.FIsSealup = 0 and t.FFROMTYPE = 6 and t.FTOTYPE = 1");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempateTable;
    }

    private List<Map> getPeriodList(Context ctx, String orgTemp, String loc) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct \n");
        sql.append("    p.FID FPeriodID, p.fdescription_l2 alias, p.fnumber number \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join ").append(orgTemp).append(" temp on temp.pcOrgId = sc.FProfitCenterID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where s.FName = 1006 \n");
        sql.append("    and sc.FIsStart = 1 \n");
        sql.append("order by p.fnumber \n");
        sql.append("\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            while (rowSet.next()) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("alias", rowSet.getString("alias"));
                item.put("value", rowSet.getString("FPeriodID"));
                item.put("number", rowSet.getString("number"));
                result.add(item);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected Map _closeCheck(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        result.put("errors", errors);
        this.doCloseCheck(ctx, params, errors);
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }

    private void doCloseCheck(Context ctx, Map params, List<Map<String, Object>> errors) throws BOSException, EASBizException {
        boolean isExistPlAccountBalance;
        boolean plAccount;
        HashMap<String, Object> error;
        boolean isExistUnPostVoucher;
        HashMap<String, Object> error2;
        boolean isExistSaveVoucher;
        String id = (String)params.get("id");
        String companyId = (String)params.get("companyId");
        String profitCenterId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        HashSet ignores = new HashSet();
        if (params.get("ignores") instanceof List) {
            ignores.addAll((List)params.get("ignores"));
        }
        params.put("ignores", ignores);
        int errorIndex = errors.size();
        if (profitCenterId == null || periodId == null) {
            HashMap<String, String> error3 = new HashMap<String, String>();
            error3.put("id", id + ERROR_PREFIX + ++errorIndex);
            error3.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            error3.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error3);
            return;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(profitCenterId), "pca_closePeriod");
        if (!hasPer) {
            HashMap<String, String> error4 = new HashMap<String, String>();
            error4.put("id", id + ERROR_PREFIX + ++errorIndex);
            error4.put("orgName", this.getLocaleString(ctx, "NO_CLOSE_PERMISSION_OF_ORG"));
            errors.add(error4);
            return;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, profitCenterId);
        if (sscInfo == null) {
            HashMap<String, String> error5 = new HashMap<String, String>();
            error5.put("id", id + ERROR_PREFIX + ++errorIndex);
            error5.put("orgName", this.getLocaleString(ctx, "PCA_SYSTEM_STATUS_ERROR"));
            errors.add(error5);
            return;
        }
        params.put("sscInfo", sscInfo);
        companyId = (String)sscInfo.get("companyId");
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error6 = new HashMap<String, String>();
            error6.put("id", id + ERROR_PREFIX + ++errorIndex);
            error6.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "CLOSE_PERIOD_ERROR"), sscInfo.get("periodName")));
            errors.add(error6);
            return;
        }
        String accountTableId = (String)sscInfo.get("accountTableId");
        boolean isCloseInit = PcaClosePeriodUtils.isCloseInit(ctx, companyId, profitCenterId, accountTableId, true, true);
        if (!isCloseInit) {
            HashMap<String, String> error7 = new HashMap<String, String>();
            error7.put("id", id + ERROR_PREFIX + ++errorIndex);
            error7.put("orgName", this.getLocaleString(ctx, "PCA_NOT_INIT"));
            errors.add(error7);
            return;
        }
        String[] profitCenterIds = new String[]{profitCenterId};
        PcaUtils.updateBalance(ctx, profitCenterIds);
        String cuId = (String)sscInfo.get("cuId");
        String periodYear = (String)sscInfo.get("periodYear");
        String periodMonth = (String)sscInfo.get("periodMonth");
        String periodNumber = (String)sscInfo.get("periodNumber");
        Date beginDate = (Date)sscInfo.get("beginDate");
        Date endDate = (Date)sscInfo.get("endDate");
        PeriodInfo curPeriodInfo = new PeriodInfo();
        curPeriodInfo.setId(BOSUuid.read((String)periodId));
        curPeriodInfo.setPeriodYear(Integer.parseInt(periodYear));
        curPeriodInfo.setPeriodNumber(Integer.parseInt(periodMonth));
        curPeriodInfo.setNumber(curPeriodInfo.getPeriodYear() * 100 + curPeriodInfo.getPeriodNumber());
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        int periodNum = period.getNumber();
        HashMap hmAllParam = PcaClosePeriodUtils.getDefaultPCAParam(ctx, companyId, profitCenterId);
        boolean isAllowOnExistSaveVoucher = Boolean.valueOf(hmAllParam.get("PCA011").toString());
        if (!isAllowOnExistSaveVoucher && (isExistSaveVoucher = PcaClosePeriodUtils.isExistSaveVoucher(ctx, profitCenterId, periodId))) {
            error2 = new HashMap<String, Object>();
            error2.put("id", id + ERROR_PREFIX + ++errorIndex);
            error2.put("orgName", this.getLocaleString(ctx, "EXIST_SAVE_VOUCHER"));
            error2.put("operation", this.getLocaleString(ctx, "PROCESS"));
            error2.put("operatfunction", "showTempVoucher");
            error2.put("periodId", periodId);
            error2.put("periodNumber", periodNum);
            error2.put("orgId", profitCenterId);
            errors.add(error2);
        }
        if (isExistUnPostVoucher = PcaClosePeriodUtils.isExistUnPostVoucher(ctx, profitCenterId, periodId)) {
            error2 = new HashMap();
            error2.put("id", id + ERROR_PREFIX + ++errorIndex);
            error2.put("orgName", this.getLocaleString(ctx, "EXIST_UNPOST_VOUCHER"));
            error2.put("operation", this.getLocaleString(ctx, "PROCESS"));
            error2.put("operatfunction", "showUnPostVoucher");
            error2.put("periodId", periodId);
            error2.put("periodNumber", periodNum);
            error2.put("orgId", profitCenterId);
            errors.add(error2);
        }
        if (!ignores.contains("ignoreBreakNumber")) {
            boolean isNotAllowBreakNumber = false;
            boolean bl = isNotAllowBreakNumber = Integer.parseInt(hmAllParam.get("PCA_051").toString()) == 2;
            if (isNotAllowBreakNumber) {
                period = new PeriodInfo();
                period.setPeriodNumber(Integer.parseInt(periodMonth));
                period.setPeriodYear(Integer.parseInt(periodYear));
                period.setId(BOSUuid.read((String)periodId));
                period.setBeginDate((java.util.Date)beginDate);
                boolean existsBreakNumber = PcaClosePeriodUtils.isExistBreakNumber(ctx, profitCenterId, periodId, cuId);
                if (existsBreakNumber) {
                    error = new HashMap();
                    error.put("id", id + ERROR_PREFIX + ++errorIndex);
                    error.put("orgName", this.getLocaleString(ctx, "EXIST_BREAK_NUMBER_VOUCHER"));
                    error.put("operation", this.getLocaleString(ctx, "PROCESS"));
                    error.put("operatfunction", "showAllVoucher");
                    error.put("periodId", periodId);
                    error.put("periodNumber", periodNum);
                    error.put("orgId", profitCenterId);
                    errors.add(error);
                }
            }
        }
        if (!ignores.contains("ignorePlAccount") && (plAccount = Boolean.valueOf(hmAllParam.get("PCA_011").toString()).booleanValue()) && (isExistPlAccountBalance = PcaClosePeriodUtils.isExistPlAccountBalance(ctx, profitCenterId, curPeriodInfo.getNumber()))) {
            error = new HashMap<String, Object>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "EXIST_PL_ACCOUNT_BALANCE"));
            error.put("operation", this.getLocaleString(ctx, "PROCESS"));
            error.put("operatfunction", "showTransPL");
            error.put("periodId", periodId);
            error.put("orgId", profitCenterId);
            errors.add(error);
        }
        if (!ignores.contains("ignoreCheckBalance")) {
            boolean fcSU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
            boolean isUserReportCurr = Boolean.valueOf(hmAllParam.get("G001").toString());
            boolean isCheckBalance = Boolean.valueOf(hmAllParam.get("PCA_103").toString());
            boolean isbalanceCorrect = false;
            if (isCheckBalance) {
                isbalanceCorrect = PcaPeriodEndFacadeFactory.getLocalInstance(ctx).checkBalanceCorrect(fcSU, profitCenterId, periodId, isUserReportCurr);
            }
            if (isCheckBalance && !isbalanceCorrect) {
                HashMap<String, String> error8 = new HashMap<String, String>();
                error8.put("id", id + ERROR_PREFIX + ++errorIndex);
                error8.put("orgName", this.getLocaleString(ctx, "CHECK_NOT_BALANCE"));
                errors.add(error8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String profitCenterId = (String)params.get("orgId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)new BOSObjectType("18A94DC7"), null, (String)profitCenter.getName(), (String)"pca_closePeriod");
        Uuid requestId = PcaClosePeriodFacadeControllerBean.requestMutex(ctx, profitCenterId, userId, this.getLocaleString(ctx, "CLOSE"));
        try {
            if (requestId != null) {
                this.doClosePeriod(ctx, params, result);
            } else {
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                String id = (String)params.get("id");
                error.put("id", id + ERROR_PREFIX + ++errorIndex);
                error.put("orgName", this.getLocaleString(ctx, "MUTEX_ERROR"));
                errors.add(error);
            }
            if (errors.size() > 0) {
                HashMap<String, Object> errorIndex = result;
                return errorIndex;
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            result.put("status", "success");
            HashMap<String, Object> errorIndex = result;
            return errorIndex;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            PcaClosePeriodFacadeControllerBean.releaseMutex(ctx, requestId);
        }
    }

    protected void doClosePeriod(Context ctx, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        List errors = (List)result.get("errors");
        this.doCloseCheck(ctx, params, errors);
        if (errors.size() > 0) {
            return;
        }
        Map sscInfo = (Map)params.get("sscInfo");
        String profitCenterId = (String)params.get("orgId");
        String curPeriodId = (String)params.get("periodId");
        PeriodInfo periodFrom = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodId));
        PeriodInfo periodNext = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(curPeriodId));
        if (periodNext == null || periodNext.getId() == null) {
            throw new GLPeriodEndException(GLPeriodEndException.NO_NEXT_PERIOD_ORG, new Object[]{params.get("name")});
        }
        String nextPeriodId = periodNext.getId().toString();
        boolean nextYear = periodNext.getPeriodYear() != periodFrom.getPeriodYear();
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.transBalanceToNextPeriod(profitCenterId, curPeriodId, nextPeriodId, nextYear, null);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BD_SystemStatusCtrol set FCurrentPeriodID = ? where FID = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodNext.getId().toString(), sscInfo.get("id")});
        sql.setLength(0);
        sql.append("update T_PCA_Flag set fkey=? where forgunitid=? and fname='pcainit' and fvalue='true'");
        String periodnumber = periodNext.getPeriodYear() + "." + periodNext.getPeriodNumber();
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodnumber, profitCenterId});
        PeriodInfo curPeriod = PcaUtils.getCurrentPeriod(ctx, profitCenterId);
        String periodYear = String.valueOf(curPeriod.getPeriodYear());
        String periodMonth = String.valueOf(curPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", curPeriod.getId().toString());
        result.put("periodName", periodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unClosePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String profitCenterId = (String)params.get("orgId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)new BOSObjectType("18A94DC7"), null, (String)profitCenter.getName(), (String)"pca_unClosePeriod");
        Uuid requestId = PcaClosePeriodFacadeControllerBean.requestMutex(ctx, profitCenterId, userId, this.getLocaleString(ctx, "UNCLOSE"));
        try {
            if (requestId != null) {
                this.doUnClosePeriod(ctx, params, result);
            } else {
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                String id = (String)params.get("id");
                error.put("id", id + ERROR_PREFIX + ++errorIndex);
                error.put("orgName", this.getLocaleString(ctx, "MUTEX_ERROR"));
                errors.add(error);
            }
            if (errors.size() > 0) {
                HashMap<String, Object> errorIndex = result;
                return errorIndex;
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            result.put("status", "success");
            HashMap<String, Object> errorIndex = result;
            return errorIndex;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            PcaClosePeriodFacadeControllerBean.releaseMutex(ctx, requestId);
        }
    }

    protected void doUnClosePeriod(Context ctx, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        List errors = (List)result.get("errors");
        String id = (String)params.get("id");
        String profitCenterId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        int errorIndex = errors.size();
        if (profitCenterId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            error.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error);
            return;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(profitCenterId), "pca_unClosePeriod");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "NO_UNCLOSE_PERMISSION_OF_ORG"));
            errors.add(error);
            return;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, profitCenterId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "PCA_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "UNCLOSE_PERIOD_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return;
        }
        if (periodId.equals(sscInfo.get("startPeriodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "UNCLOSE_ON_START_PERIOD"));
            errors.add(error);
            return;
        }
        if (errors.size() > 0) {
            return;
        }
        String companyId = (String)sscInfo.get("companyId");
        String curPeriodId = periodId;
        PeriodInfo curPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodId));
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        String accountTableId = (String)sscInfo.get("accountTableId");
        boolean isCloseInit = PcaClosePeriodUtils.isCloseInit(ctx, companyId, profitCenterId, accountTableId, true, true);
        if (!isCloseInit) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + ERROR_PREFIX + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "PCA_NOT_INIT"));
            errors.add(error);
            return;
        }
        if (prePeriod.isIsAdjustPeriod()) {
            String clssql = "update T_PCA_PCVoucher set FIsClose = 0 where FProfitCenterID = ? and FPeriodID = ? and FIsClose = 1";
            DbUtil.execute((Context)ctx, (String)clssql, (Object[])new Object[]{profitCenterId, prePeriod.getId().toString()});
        }
        IPcaBalanceFacade updateBalance = PcaBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.antiTransBalanceToPrevPeriod(profitCenterId, curPeriodId);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BD_SystemStatusCtrol set FCurrentPeriodID = ? where FID = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{prePeriod.getId().toString(), sscInfo.get("id")});
        curPeriod = PcaUtils.getCurrentPeriod(ctx, profitCenterId);
        if (!prePeriod.getId().equals((Object)curPeriod.getId())) {
            throw new GLPeriodEndException(GLPeriodEndException.HASUNCLOSED);
        }
        String periodYear = String.valueOf(curPeriod.getPeriodYear());
        String periodMonth = String.valueOf(curPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", curPeriod.getId().toString());
        result.put("periodName", periodName);
    }
}

