/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PcaInitHelp {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.app.PcaInitHelp");
    public static final BigDecimal zero = new BigDecimal("0");

    public static PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitcenter) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo[] periods = new PeriodInfo[3];
        periods[0] = ictrol.getProfitStartPeriod(new Integer(SystemEnum.PROFIT_CENTER_ACCOUNTING.getValue()).intValue(), profitcenter.getId().toString());
        periods[2] = ictrol.getProfitCurrentPeriod(new Integer(SystemEnum.PROFIT_CENTER_ACCOUNTING.getValue()).intValue(), profitcenter.getId().toString());
        if (periods[0] != null) {
            IPeriod iPeriod = null;
            iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periods[0].getPeriodYear())));
            filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)company.getAccountPeriodType().getId().toString()));
            evi.setFilter(filter);
            PeriodCollection periodCollection = iPeriod.getPeriodCollection(evi);
            if (periodCollection.size() > 0) {
                periods[1] = periodCollection.get(0);
            }
        }
        return periods;
    }

    public static BigDecimal nvl(BigDecimal b) {
        return b == null ? zero : b;
    }

    public static void checkAsstEqualPCA(Context ctx, AccountViewInfo info, HashMap otherCtx) throws BOSException, EASBizException {
        String profitCenterId = otherCtx.get("PROFITCENTERID").toString();
        String companyId = otherCtx.get("COMPANYID").toString();
        int amountScale = (Integer)otherCtx.get("AMOUNTSCALE");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        String accountId = info.getId().toString();
        String pcacid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String pcarid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        String asstSql = "select fcurrencyid,sum(fbeginbalancefor) amountfor,sum(fbeginbalancelocal) amountlocal,sum(fbeginbalancerpt) amountreport,sum(fstandardbeginqty) qty ,sum(fyeardebitfor) yeardebitfor,sum(fyeardebitlocal) yeardebitlocal,sum(fyeardebitrpt) yeardebitreport,sum(fstandardyeardebitqty) yeardebitqty ,sum(fyearcreditfor) yearcreditfor,sum(fyearcreditlocal) yearcreditlocal,sum(fyearcreditrpt) yearcreditreport,sum(fstandardyearcreditqty) yearcreditqty ,sum(fyearpnlfor) yearpnlfor,sum(fyearpnllocal) yearpnllocal,sum(fyearpnlrpt) yearpnlreport from T_PCA_InitPcAssistBalance where faccountid=? and fprofitcenterid=?  and forgunitid = ? and fcurrencyid<>'" + pcacid + "' and fcurrencyid<>'" + pcarid + "'  group by fcurrencyid";
        String pcaSql = "select fcurrencyid,sum(fbeginbalancefor) amountfor,sum(fbeginbalancelocal) amountlocal,sum(fbeginbalancerpt) amountreport,sum(fbeginqty) qty ,sum(fyeardebitfor) yeardebitfor,sum(fyeardebitlocal) yeardebitlocal,sum(fyeardebitrpt) yeardebitreport,sum(fyeardebitqty) yeardebitqty ,sum(fyearcreditfor) yearcreditfor,sum(fyearcreditlocal) yearcreditlocal,sum(fyearcreditrpt) yearcreditreport,sum(fyearcreditqty) yearcreditqty ,sum(fyearpnlfor) yearpnlfor,sum(fyearpnllocal) yearpnllocal,sum(fyearpnlrpt) yearpnlreport from T_PCA_InitPcAccountBalance where faccountid=? and fprofitcenterid=? and forgunitid = ? and fcurrencyid<>'" + pcacid + "' and fcurrencyid<>'" + pcarid + "'  group by fcurrencyid";
        HashMap map1 = new HashMap();
        HashMap map2 = new HashMap();
        HashSet<String> keySet = new HashSet<String>();
        Connection con = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        boolean isqty = false;
        String currencyid = null;
        if (otherCtx.get("G010") != null && ((Boolean)otherCtx.get("G010")).booleanValue() && info.isIsQty() && info.getCAA() != null && info.getCAA().isIsQty()) {
            isqty = true;
        }
        boolean ispl = info.getAccountTypeID().getProperty().getValue() == 4;
        try {
            ArrayList<BigDecimal> al;
            con = PcaInitHelp.getConnection(ctx);
            ps1 = con.prepareStatement(pcaSql);
            ps2 = con.prepareStatement(asstSql);
            ps1.setString(1, accountId);
            ps1.setString(2, profitCenterId);
            ps1.setString(3, companyId);
            ps2.setString(1, accountId);
            ps2.setString(2, profitCenterId);
            ps2.setString(3, companyId);
            rs1 = ps1.executeQuery();
            rs2 = ps2.executeQuery();
            while (rs1.next()) {
                al = new ArrayList<BigDecimal>(3);
                currencyid = rs1.getString("fcurrencyid");
                if (isqty) {
                    al.add(rs1.getBigDecimal("qty"));
                    if (!isFirstPeriod) {
                        al.add(rs1.getBigDecimal("yeardebitqty"));
                        al.add(rs1.getBigDecimal("yearcreditqty"));
                    }
                }
                al.add(rs1.getBigDecimal("amountfor"));
                if (!isFirstPeriod) {
                    al.add(rs1.getBigDecimal("yeardebitfor"));
                    al.add(rs1.getBigDecimal("yearcreditfor"));
                }
                if (ispl) {
                    al.add(rs1.getBigDecimal("yearpnlfor"));
                }
                if (!isForeign) {
                    al.add(rs1.getBigDecimal("amountlocal"));
                    if (!isFirstPeriod) {
                        al.add(rs1.getBigDecimal("yeardebitlocal"));
                        al.add(rs1.getBigDecimal("yearcreditlocal"));
                    }
                    if (ispl) {
                        al.add(rs1.getBigDecimal("yearpnllocal"));
                    }
                    if (isUseReport) {
                        al.add(rs1.getBigDecimal("amountreport"));
                        if (!isFirstPeriod) {
                            al.add(rs1.getBigDecimal("yeardebitreport"));
                            al.add(rs1.getBigDecimal("yearcreditreport"));
                        }
                        if (ispl) {
                            al.add(rs1.getBigDecimal("yearpnlreport"));
                        }
                    }
                }
                map1.put(currencyid, al);
                keySet.add(currencyid);
            }
            while (rs2.next()) {
                al = new ArrayList(3);
                currencyid = rs2.getString("fcurrencyid");
                if (isqty) {
                    al.add(rs2.getBigDecimal("qty"));
                    if (!isFirstPeriod) {
                        al.add(rs2.getBigDecimal("yeardebitqty"));
                        al.add(rs2.getBigDecimal("yearcreditqty"));
                    }
                }
                al.add(rs2.getBigDecimal("amountfor"));
                if (!isFirstPeriod) {
                    al.add(rs2.getBigDecimal("yeardebitfor"));
                    al.add(rs2.getBigDecimal("yearcreditfor"));
                }
                if (ispl) {
                    al.add(rs2.getBigDecimal("yearpnlfor"));
                }
                if (!isForeign) {
                    al.add(rs2.getBigDecimal("amountlocal"));
                    if (!isFirstPeriod) {
                        al.add(rs2.getBigDecimal("yeardebitlocal"));
                        al.add(rs2.getBigDecimal("yearcreditlocal"));
                    }
                    if (ispl) {
                        al.add(rs2.getBigDecimal("yearpnllocal"));
                    }
                    if (isUseReport) {
                        al.add(rs2.getBigDecimal("amountreport"));
                        if (!isFirstPeriod) {
                            al.add(rs2.getBigDecimal("yeardebitreport"));
                            al.add(rs2.getBigDecimal("yearcreditreport"));
                        }
                        if (ispl) {
                            al.add(rs2.getBigDecimal("yearpnlreport"));
                        }
                    }
                }
                map2.put(currencyid, al);
                keySet.add(currencyid);
            }
            Iterator iter = keySet.iterator();
            BigDecimal zero = new BigDecimal("0");
            boolean exception = false;
            String key = null;
            int index = -1;
            BigDecimal pca = null;
            BigDecimal asst = null;
            block6: while (!exception && iter.hasNext()) {
                BigDecimal c;
                BigDecimal a;
                Iterator iter2;
                index = -1;
                key = (String)iter.next();
                ArrayList pcaValues = (ArrayList)map1.get(key);
                ArrayList asstValues = (ArrayList)map2.get(key);
                if (asstValues == null && pcaValues != null) {
                    iter2 = pcaValues.iterator();
                    while (iter2.hasNext()) {
                        ++index;
                        a = (BigDecimal)iter2.next();
                        if (a.compareTo(c = zero) == 0) continue;
                        pca = a;
                        asst = c;
                        exception = true;
                        continue block6;
                    }
                    continue;
                }
                if (pcaValues == null && asstValues != null) {
                    iter2 = asstValues.iterator();
                    while (iter2.hasNext()) {
                        ++index;
                        a = (BigDecimal)iter2.next();
                        if (a.compareTo(c = zero) == 0) continue;
                        pca = c;
                        asst = a;
                        exception = true;
                        continue block6;
                    }
                    continue;
                }
                iter2 = asstValues.iterator();
                Iterator iter3 = pcaValues.iterator();
                while (iter2.hasNext() && iter3.hasNext()) {
                    BigDecimal c2;
                    ++index;
                    BigDecimal a2 = (BigDecimal)iter2.next();
                    if (a2.compareTo(c2 = (BigDecimal)iter3.next()) == 0) continue;
                    asst = a2;
                    pca = c2;
                    exception = true;
                    continue block6;
                }
            }
            if (exception) {
                String strAsst;
                String strPCA;
                CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read(key)));
                ArrayList<String> columns = new ArrayList<String>();
                if (isqty) {
                    columns.add("monthBeginQty");
                    if (!isFirstPeriod) {
                        columns.add("yearDebitQty");
                        columns.add("yearCreditQty");
                    }
                }
                columns.add("monthBeginFor");
                if (!isFirstPeriod) {
                    columns.add("yearDebitFor");
                    columns.add("yearCreditFor");
                }
                if (ispl) {
                    columns.add("pnlFor");
                }
                if (!isForeign) {
                    columns.add("monthBeginLocal");
                    if (!isFirstPeriod) {
                        columns.add("yearDebitLocal");
                        columns.add("yearCreditLocal");
                    }
                    if (ispl) {
                        columns.add("pnlLocal");
                    }
                    if (isUseReport) {
                        columns.add("monthBeginReport");
                        if (!isFirstPeriod) {
                            columns.add("yearDebitReport");
                            columns.add("yearCreditReport");
                        }
                        if (ispl) {
                            columns.add("pnlReport");
                        }
                    }
                }
                String column = (String)columns.get(index);
                boolean exceptionIsQty = column.endsWith("Qty");
                column = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)column, (Locale)ctx.getLocale());
                if (exceptionIsQty) {
                    strPCA = PcaUtils.formatNumber(pca);
                    strAsst = PcaUtils.formatNumber(asst);
                } else {
                    strPCA = PcaUtils.formatNumber(pca, amountScale);
                    strAsst = PcaUtils.formatNumber(asst, amountScale);
                }
                throw new InitException(InitException.ASST_GL_CHECK_NOTEQUAL, new Object[]{info.getNumber() + "-" + info.getName(), cur.getName(), column, strPCA, strAsst});
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs1, ps1);
                SQLUtils.cleanup(rs2, ps2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
        SQLUtils.cleanup((ResultSet)rs2, (Statement)ps2, (Connection)con);
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static void checkCancelInit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String startPeriodId = null;
        String currPeriodId = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.fid,ssc.fstartperiodid,ssc.fcurrentperiodid from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid ");
        sql.append(" where ssc.fprofitcenterid = ? and ss.fname = ").append(1006);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitId});
        try {
            if (rs.next()) {
                startPeriodId = rs.getString("fstartperiodid");
                currPeriodId = rs.getString("fcurrentperiodid");
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        if (startPeriodId != null && !startPeriodId.equals(currPeriodId)) {
            throw new InitException(InitException.CHECK_CANCELINIT);
        }
    }

    public static void checkBooksHasCloseInit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        if (BooksUtil.isMasterBook((Context)ctx) && BooksUtil.canCreateBook((Context)ctx)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 where exists          \t\t\r\n");
            sql.append("(select 1 from t_pca_Flag          \t\r\n");
            sql.append("where FOrgUnitID = ?                \r\n");
            sql.append("    and FName = 'pcainit'            \r\n");
            sql.append("\tand FValue = 'true'            \t\r\n");
            sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(";");
            Map bookList = BookUtil._getBookList((Context)ctx, (String)orgUnitId);
            Set keys = bookList.keySet();
            for (String transferOrg : keys) {
                if (!PcaInitHelp.checkHasCloseInit(ctx, transferOrg, sql.toString())) continue;
                String bookid = (String)bookList.get(transferOrg);
                AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
                throw new InitException(InitException.OTHERBOOKSCLOSED, new Object[]{book.getName()});
            }
        }
    }

    public static boolean checkHasCloseInit(Context ctx, String curCompanyID, String sql) throws BOSException {
        boolean isColsed = false;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID});
        try {
            if (set.next()) {
                isColsed = true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return isColsed;
    }

    public static void checkAsstEqualPCA(Context ctx, AccountViewCollection accountColl, HashMap otherCtx) throws BOSException, EASBizException {
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String profitcenterId = ((ProfitCenterOrgUnitInfo)otherCtx.get("PROFITCENTER")).getId().toString();
        int amountScale = (Integer)otherCtx.get("AMOUNTSCALE");
        boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        String pcacid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String pcarid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        StringBuffer accountids = new StringBuffer();
        for (int i = 0; i < accountColl.size(); ++i) {
            if (i > 0) {
                accountids.append(",");
            }
            accountids.append("'").append(accountColl.get(i).getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( \r\n");
        sql.append(" select cy.fname_").append(ctx.getLocale().toString()).append(" currencyName,av.fnumber accountNumber,av.fname_").append(ctx.getLocale().toString()).append(" accountName,");
        sql.append(" isnull(pca.fbeginbalancefor,0.00) pcabeginbalancefor, isnull(asst.asstbeginbalancefor,0.00) asstbeginbalancefor,");
        sql.append(" isnull(pca.fbeginbalancelocal,0.00) pcabeginbalancelocal, isnull(asst.asstbeginbalancelocal,0.00) asstbeginbalancelocal,");
        sql.append(" isnull(pca.fbeginbalancerpt,0.00) pcabeginbalancerpt, isnull(asst.asstbeginbalancerpt,0.00) asstbeginbalancerpt,");
        sql.append(" isnull(pca.fbeginqty,0.00) pcastandardbeginqty, isnull(asst.asststandardbeginqty,0.00) asststandardbeginqty ");
        if (!isFirstPeriod) {
            sql.append(", isnull(pca.fyeardebitfor,0.00) pcayeardebitfor, isnull(asst.asstyeardebitfor,0.00) asstyeardebitfor,");
            sql.append(" isnull(pca.fyeardebitlocal,0.00) pcayeardebitlocal, isnull(asst.asstyeardebitlocal,0.00) asstyeardebitlocal,");
            sql.append(" isnull(pca.fyeardebitrpt,0.00) pcayeardebitrpt, isnull(asst.asstyeardebitrpt,0.00) asstyeardebitrpt,");
            sql.append(" isnull(pca.fyeardebitqty,0.00) pcastandardyeardebitqty, isnull(asst.asststandardyeardebitqty,0.00) asststandardyeardebitqty, ");
            sql.append(" isnull(pca.fyearcreditfor,0.00) pcayearcreditfor, isnull(asst.asstyearcreditfor,0.00) asstyearcreditfor,");
            sql.append(" isnull(pca.fyearcreditlocal,0.00) pcayearcreditlocal, isnull(asst.asstyearcreditlocal,0.00) asstyearcreditlocal,");
            sql.append(" isnull(pca.fyearcreditrpt,0.00) pcayearcreditrpt, isnull(asst.asstyearcreditrpt,0.00) asstyearcreditrpt,");
            sql.append(" isnull(pca.fyearcreditqty,0.00) pcastandardyearcreditqty, isnull(asst.asststandardyearcreditqty,0.00) asststandardyearcreditqty, ");
            sql.append(" isnull(pca.fyearpnlfor,0.00) pcayearpnlfor, isnull(asst.asstyearpnlfor,0.00) asstyearpnlfor,");
            sql.append(" isnull(pca.fyearpnllocal,0.00) pcayearpnllocal, isnull(asst.asstyearpnllocal,0.00) asstyearpnllocal,");
            sql.append(" isnull(pca.fyearpnlrpt,0.00) pcayearpnlrpt, isnull(asst.asstyearpnlrpt,0.00) asstyearpnlrpt ");
        }
        sql.append(" from t_bd_accountview av \r\n");
        sql.append(" left outer join (select fprofitcenterid, forgunitid,faccountid,fcurrencyid,");
        sql.append(" sum(fbeginbalancefor) asstbeginbalancefor,sum(fbeginbalancelocal) asstbeginbalancelocal,sum(fbeginbalancerpt) asstbeginbalancerpt,sum(fstandardbeginqty) asststandardbeginqty ");
        if (!isFirstPeriod) {
            sql.append(" ,sum(fyeardebitfor) asstyeardebitfor,sum(fyeardebitlocal) asstyeardebitlocal,sum(fyeardebitrpt) asstyeardebitrpt,sum(fstandardyeardebitqty) asststandardyeardebitqty,");
            sql.append(" sum(fyearcreditfor) asstyearcreditfor,sum(fyearcreditlocal) asstyearcreditlocal,sum(fyearcreditrpt) asstyearcreditrpt,sum(fstandardyearcreditqty) asststandardyearcreditqty,");
            sql.append(" sum(fyearpnlfor) asstyearpnlfor,sum(fyearpnllocal) asstyearpnllocal,sum(fyearpnlrpt) asstyearpnlrpt");
        }
        sql.append(" from T_PCA_InitPcAssistBalance where fprofitcenterid = ? and forgunitid = ? \r\n");
        sql.append(" and faccountid in (").append(accountids.toString()).append(") and fcurrencyid <> '" + pcacid + "' and fcurrencyid <> '" + pcarid + "' \r\n");
        sql.append(" group by fprofitcenterid,forgunitid,faccountid,fcurrencyid) asst on asst.faccountid = av.fid \r\n");
        sql.append(" inner join t_bd_currency cy on cy.fid = asst.fcurrencyid \r\n");
        sql.append(" inner join t_org_profitcenter pc on pc.fid = asst.fprofitcenterid \r\n");
        sql.append(" inner join t_org_company com on com.fid = asst.forgunitid \r\n");
        sql.append(" left outer join T_PCA_InitPcAccountBalance pca on pca.faccountid = av.fid and pca.fprofitcenterid = pc.fid and pca.fcurrencyid = cy.fid and pca.forgunitid = com.fid \r\n");
        sql.append(" where pc.fid=? and com.fid = ? and av.fid in (").append(accountids.toString()).append(") and cy.fid<>'" + pcacid + "' and cy.fid<>'" + pcarid + "' ");
        sql.append(" ) t \r\n ");
        sql.append(" where pcabeginbalancefor - asstbeginbalancefor <> 0 ");
        sql.append(" or pcastandardbeginqty - asststandardbeginqty <>0 ");
        if (!isForeign) {
            sql.append(" or pcabeginbalancelocal - asstbeginbalancelocal <> 0 ");
            if (isUseReport) {
                sql.append(" or pcabeginbalancerpt - asstbeginbalancerpt <> 0 ");
            }
        }
        if (!isFirstPeriod) {
            sql.append(" or pcayeardebitfor - asstyeardebitfor <>0 ");
            sql.append(" or pcastandardyeardebitqty - asststandardyeardebitqty <>0 ");
            sql.append(" or pcayearcreditfor - asstyearcreditfor<>0 ");
            sql.append(" or pcastandardyearcreditqty - asststandardyearcreditqty <>0 ");
            sql.append(" or pcayearpnlfor - asstyearpnlfor <>0 ");
            if (!isForeign) {
                sql.append(" or pcayeardebitlocal - asstyeardebitlocal <> 0 ");
                sql.append(" or pcayearcreditlocal - asstyearcreditfor <> 0 ");
                sql.append(" or pcayearpnllocal - asstyearpnllocal <> 0 ");
                if (isUseReport) {
                    sql.append(" or pcayeardebitrpt - asstyeardebitrpt <> 0 ");
                    sql.append(" or pcayearcreditrpt - asstyearcreditfor <> 0 ");
                    sql.append(" or pcayearpnlrpt - asstyearpnlrpt <> 0 ");
                }
            }
        }
        sql.append(" order by accountNumber,currencyName ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{profitcenterId, companyId, profitcenterId, companyId});
        try {
            String column = null;
            BigDecimal pca = null;
            BigDecimal asst = null;
            while (rs.next()) {
                if (rs.getBigDecimal("pcabeginbalancefor").doubleValue() - rs.getBigDecimal("asstbeginbalancefor").doubleValue() != 0.0) {
                    column = "monthBeginFor";
                    pca = rs.getBigDecimal("pcabeginbalancefor");
                    asst = rs.getBigDecimal("asstbeginbalancefor");
                    break;
                }
                if (rs.getBigDecimal("pcastandardbeginqty").doubleValue() - rs.getBigDecimal("asststandardbeginqty").doubleValue() != 0.0) {
                    column = "monthBeginQty";
                    pca = rs.getBigDecimal("pcastandardbeginqty");
                    asst = rs.getBigDecimal("asststandardbeginqty");
                    break;
                }
                if (!isForeign) {
                    if (rs.getBigDecimal("pcabeginbalancelocal").doubleValue() - rs.getBigDecimal("asstbeginbalancelocal").doubleValue() != 0.0) {
                        column = "monthBeginLocal";
                        pca = rs.getBigDecimal("pcabeginbalancelocal");
                        asst = rs.getBigDecimal("asstbeginbalancelocal");
                        break;
                    }
                    if (isUseReport && rs.getBigDecimal("pcabeginbalancerpt").doubleValue() - rs.getBigDecimal("asstbeginbalancerpt").doubleValue() != 0.0) {
                        column = "monthBeginReport";
                        pca = rs.getBigDecimal("pcabeginbalancerpt");
                        asst = rs.getBigDecimal("asstbeginbalancerpt");
                        break;
                    }
                }
                if (isFirstPeriod) continue;
                if (rs.getBigDecimal("pcayeardebitfor").doubleValue() - rs.getBigDecimal("asstyeardebitfor").doubleValue() != 0.0) {
                    column = "yearDebitFor";
                    pca = rs.getBigDecimal("pcayeardebitfor");
                    asst = rs.getBigDecimal("asstyeardebitfor");
                    break;
                }
                if (rs.getBigDecimal("pcayearcreditfor").doubleValue() - rs.getBigDecimal("asstyearcreditfor").doubleValue() != 0.0) {
                    column = "yearCreditFor";
                    pca = rs.getBigDecimal("pcayearcreditfor");
                    asst = rs.getBigDecimal("asstyearcreditfor");
                    break;
                }
                if (rs.getBigDecimal("pcastandardyeardebitqty").doubleValue() - rs.getBigDecimal("asststandardyeardebitqty").doubleValue() != 0.0) {
                    column = "yearDebitQty";
                    pca = rs.getBigDecimal("pcastandardyeardebitqty");
                    asst = rs.getBigDecimal("asststandardyeardebitqty");
                    break;
                }
                if (rs.getBigDecimal("pcastandardyearcreditqty").doubleValue() - rs.getBigDecimal("asststandardyearcreditqty").doubleValue() != 0.0) {
                    column = "yearCreditQty";
                    pca = rs.getBigDecimal("pcastandardyearcreditqty");
                    asst = rs.getBigDecimal("asststandardyearcreditqty");
                    break;
                }
                if (rs.getBigDecimal("pcayearpnlfor").doubleValue() - rs.getBigDecimal("asstyearpnlfor").doubleValue() != 0.0) {
                    column = "pnlFor";
                    pca = rs.getBigDecimal("pcayearpnlfor");
                    asst = rs.getBigDecimal("asstyearpnlfor");
                    break;
                }
                if (isForeign) continue;
                if (rs.getBigDecimal("pcayeardebitlocal").doubleValue() - rs.getBigDecimal("asstyeardebitlocal").doubleValue() != 0.0) {
                    column = "yearDebitLocal";
                    pca = rs.getBigDecimal("pcayeardebitlocal");
                    asst = rs.getBigDecimal("asstyeardebitlocal");
                    break;
                }
                if (rs.getBigDecimal("pcayearcreditlocal").doubleValue() - rs.getBigDecimal("asstyearcreditlocal").doubleValue() != 0.0) {
                    column = "yearCreditLocal";
                    pca = rs.getBigDecimal("pcayearcreditlocal");
                    asst = rs.getBigDecimal("asstyearcreditlocal");
                    break;
                }
                if (rs.getBigDecimal("pcayearpnllocal").doubleValue() - rs.getBigDecimal("asstyearpnllocal").doubleValue() != 0.0) {
                    column = "pnlLocal";
                    pca = rs.getBigDecimal("pcayearpnllocal");
                    asst = rs.getBigDecimal("asstyearpnllocal");
                    break;
                }
                if (!isUseReport) continue;
                if (rs.getBigDecimal("pcayeardebitrpt").doubleValue() - rs.getBigDecimal("asstyeardebitrpt").doubleValue() != 0.0) {
                    column = "yearDebitReport";
                    pca = rs.getBigDecimal("pcayeardebitrpt");
                    asst = rs.getBigDecimal("asstyeardebitrpt");
                    break;
                }
                if (rs.getBigDecimal("pcayearcreditrpt").doubleValue() - rs.getBigDecimal("asstyearcreditrpt").doubleValue() != 0.0) {
                    column = "yearCreditReport";
                    pca = rs.getBigDecimal("pcayearcreditrpt");
                    asst = rs.getBigDecimal("asstyearcreditrpt");
                    break;
                }
                if (rs.getBigDecimal("pcayearpnlrpt").doubleValue() - rs.getBigDecimal("asstyearpnlrpt").doubleValue() == 0.0) continue;
                column = "pnlReport";
                pca = rs.getBigDecimal("pcayearpnlrpt");
                asst = rs.getBigDecimal("asstyearpnlrpt");
                break;
            }
            if (column != null) {
                String strAsst;
                String strGl;
                String colTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.InitResource", column, (Locale)ctx.getLocale());
                boolean exceptionIsQty = column.endsWith("Qty");
                if (exceptionIsQty) {
                    strGl = GlUtils.formatNumber(pca);
                    strAsst = GlUtils.formatNumber(asst);
                } else {
                    strGl = GlUtils.formatNumber(pca, (int)amountScale);
                    strAsst = GlUtils.formatNumber(asst, (int)amountScale);
                }
                throw new InitException(InitException.ASST_GL_CHECK_NOTEQUAL, new Object[]{rs.getString("accountNumber") + "-" + rs.getString("accountName"), rs.getString("currencyName"), colTitle, strGl, strAsst});
            }
        }
        catch (SQLException ex) {
            throw new BOSException("SQL ERROR", (Throwable)ex);
        }
    }

    public static AccountViewCollection getInitedCussentAccountViewCollection(Context ctx, String[] accountIds, String orgUnitId) throws BOSException {
        if (accountIds == null || accountIds.length == 0) {
            return new AccountViewCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < accountIds.length; ++i) {
            idSet.add(accountIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit"));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("key", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true"));
        view.setFilter(filter);
        GLFlagCollection flagColl = GLFlagFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (flagColl.size() == 0) {
            return new AccountViewCollection();
        }
        idSet.clear();
        for (int i = 0; i < flagColl.size(); ++i) {
            idSet.add(flagColl.get(i).getKey());
        }
        view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.asstHGAttribute"));
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
    }

    public static Map getInitParam(Context ctx, CompanyOrgUnitInfo company, String profitCenterId) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)company.getId().toString()));
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        hmNumAndOrgId.put("G001", null);
        hmNumAndOrgId.put("GL_002", comPK);
        hmNumAndOrgId.put("GL_008", comPK);
        hmNumAndOrgId.put("GL_112", comPK);
        ObjectUuidPK profitPK = new ObjectUuidPK(BOSUuid.read((String)profitCenterId));
        hmNumAndOrgId.put("PCA_055", profitPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmNumAndOrgId);
        Integer qtyscale = null;
        try {
            qtyscale = new Integer(hmAllParam.get("GL_002").toString());
            hmAllParam.put("GL_002", qtyscale);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"GL_002"});
        }
        Boolean foreignCurrencySU = null;
        try {
            foreignCurrencySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
            hmAllParam.put("GL_008", foreignCurrencySU);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"GL_008"});
        }
        Boolean useReportingCurrency = null;
        try {
            useReportingCurrency = Boolean.valueOf(hmAllParam.get("G001").toString());
            hmAllParam.put("G001", useReportingCurrency);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"G001"});
        }
        if (Boolean.TRUE.equals(useReportingCurrency)) {
            if (company.getReportCurrency() == null) {
                throw new GLException(GLException.NOREPORTINGCUR);
            }
            if (company.getReportExchangeTable() == null) {
                throw new GLException(GLException.NOREPORTINGEXTABLE);
            }
        }
        Boolean isAccountInit = null;
        try {
            isAccountInit = Boolean.valueOf(hmAllParam.get("PCA_055").toString());
            hmAllParam.put("PCA_055", isAccountInit);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"PCA_055"});
        }
        Boolean pcBalanceChecked = Boolean.TRUE;
        try {
            if (hmAllParam.get("GL_112") == null) {
                hmAllParam.put("GL_112", pcBalanceChecked);
            } else {
                hmAllParam.put("GL_112", Boolean.valueOf(hmAllParam.get("GL_112").toString()));
            }
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, (Throwable)ex, new Object[]{"GL_112"});
        }
        return hmAllParam;
    }

    public static void doColseInit(Context ctx, String profitCenterID, String curCompanyID, String accountTableid) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.fid from t_bd_accountview a  ");
        sql.append(" left join t_pca_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='astinit' ");
        sql.append(" where( b.fvalue is null or b.fvalue='false') and a.fisleaf=1 and a.fcaa is not null and a.fcompanyid=? and a.faccounttableid=? ");
        StringBuffer accountIDs = new StringBuffer();
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, accountTableid});
        while (set.next()) {
            if (!set.isFirst()) {
                accountIDs.append(",");
            }
            accountIDs.append("'").append(set.getString("fid")).append("'");
        }
        if (accountIDs.length() > 0) {
            sql = new StringBuffer();
            sql.append(" delete from t_pca_flag where fname='astinit' and forgunitid = ? and fcompanyid = ? and fkey in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterID, curCompanyID});
            sql = new StringBuffer();
            sql.append(" insert into t_pca_flag(fid,fname,fvalue,forgunitid,fcompanyid,fkey) ");
            sql.append(" select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("'),");
            sql.append(" 'astinit','true','").append(profitCenterID).append("','").append(curCompanyID).append("',av.fid \r\n");
            sql.append(" from t_bd_accountview av where av.fid in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append(" select a.fid from t_bd_accountview a ");
        sql.append(" left join t_pca_flag b on a.fid=b.fkey and b.forgunitid = a.fcompanyid and b.fname='cussentinit'  ");
        sql.append(" where( b.fvalue is null or b.fvalue='false') ");
        sql.append(" and a.fisleaf=1 and a.fcaa is not null  and a.fac=1  ");
        sql.append(" and a.fcompanyid=? and a.faccounttableid=? ");
        accountIDs = new StringBuffer();
        set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, accountTableid});
        while (set.next()) {
            if (!set.isFirst()) {
                accountIDs.append(",");
            }
            accountIDs.append("'").append(set.getString("fid")).append("'");
        }
        if (accountIDs.length() > 0) {
            SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select currentPeriod.*,acPeriod.* where systemStatus.name=1006 and profitCenter.id='" + profitCenterID + "'");
            if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod() != null) {
                PeriodInfo currentPeriod = ctrols.get(0).getCurrentPeriod();
                PeriodInfo acPeriod = ctrols.get(0).getAcPeriod();
                if (currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber() < acPeriod.getPeriodYear() * 100 + acPeriod.getPeriodNumber()) {
                    return;
                }
            }
            sql = new StringBuffer();
            sql.append(" delete from t_pca_flag where fname='cussentinit' and forgunitid = ? and fcompanyid = ? and fkey in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterID, curCompanyID});
            sql = new StringBuffer();
            sql.append(" insert into t_pca_flag(fid,fname,fvalue,forgunitid,fcompanyid,fkey) ");
            sql.append(" select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("'),");
            sql.append(" 'cussentinit','true','").append(profitCenterID).append("','").append(curCompanyID).append("',av.fid \r\n");
            sql.append(" from t_bd_accountview av where av.fid in (").append(accountIDs).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

