/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.PostVoucherCheckPara;
import com.kingdee.eas.fi.gl.PostVoucherCheckReturn;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.ma.pca.PcaBalanceFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.AbstractPcaPeriodEndFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PcaPeriodEndFacadeControllerBean
extends AbstractPcaPeriodEndFacadeControllerBean {
    private static Logger log = Logger.getLogger(PcaPeriodEndFacadeControllerBean.class);
    private static final String T_PCA_PCVOUCHER = "t_pca_pcvoucher";
    private static final String T_PCA_PCVOUCHERENTRY = "t_pca_pcvoucherentry";
    private static final String T_PCA_PCVOUCHERASSISTRECORD = "t_pca_pcvoucherassistrecord";

    protected String getVoucherTable() {
        return T_PCA_PCVOUCHER;
    }

    protected String getVoucherEntryTable() {
        return T_PCA_PCVOUCHERENTRY;
    }

    protected String getVoucherAssRecTable() {
        return T_PCA_PCVOUCHERASSISTRECORD;
    }

    protected PostVoucherCheckReturn[] checkAccountBalanceAndVoucher(Context ctx, boolean fcSU, Connection con, String curCompanyID, PeriodInfo period, boolean isUserReportCurr) throws SQLException {
        StringBuffer sbSql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        sbSql.append(" select ac.fid , ac.fnumber,ac.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" acname, cu.fnumber, cu.fprecision,cu.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" cuname,                                   \t\r\n");
        if (fcSU) {
            sbSql.append(" \tgl.fdebitfor, gl.fcreditfor, isnull(ld, 0) ld, isnull(lc, 0) lc            \t\r\n");
        } else {
            sbSql.append(" \tgl.fdebitfor, gl.fcreditfor, isnull(ld, 0) ld, isnull(lc, 0) lc            \t\r\n");
            sbSql.append(" \t,gl.fdebitlocal, gl.fcreditlocal, isnull(ldl, 0) ldl, isnull(lcl, 0) lcl            \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,gl.fdebitrpt, gl.fcreditrpt, isnull(ldr, 0) ld, isnull(lcr, 0) lcr           \t\r\n");
            }
        }
        sbSql.append(" from T_PCA_PCAccountBalance_5F gl                                                     \t\r\n");
        sbSql.append(" inner join t_bd_accountview ac  on gl.faccountid = ac.fid                                                      \t\r\n");
        sbSql.append(" inner join t_bd_currency cu \ton gl.fcurrencyid = cu.fid                                                     \t\r\n");
        sbSql.append(" left join                                                                       \t\r\n");
        sbSql.append(" \t(                                                                              \t\r\n");
        sbSql.append(" \tselect e.faccountid, e.fcurrencyid,                 \t\t\t\t\t\t\t\r\n");
        if (fcSU) {
            sbSql.append(" \tsum(e.foriginalamount * e.fentrydc) ld, sum(e.foriginalamount * (1 - e.fentrydc)) lc \t\r\n");
        } else {
            sbSql.append(" \tsum(e.foriginalamount * e.fentrydc) ld, sum(e.foriginalamount * (1 - e.fentrydc)) lc \t\r\n");
            sbSql.append(" \t,sum(e.flocalamount * e.fentrydc) ldl, sum(e.flocalamount * (1 - e.fentrydc)) lcl \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,sum(e.FReportingAmount * e.fentrydc) ldr, sum(e.FReportingAmount * (1 - e.fentrydc)) lcr \t\r\n");
            }
        }
        sbSql.append(" \tfrom T_PCA_PCVoucher v                                                            \t\r\n");
        sbSql.append(" \tinner join T_PCA_PCVoucherEntry e on e.fbillid = v.fid                                                   \t\t\r\n");
        sbSql.append("\twhere v.fbizstatus = 5                                                         \t\r\n");
        sbSql.append("\t\tand v.FProfitCenterID = ?                                                   \t\t\r\n");
        sbSql.append("\t\tand v.fperiodid = ?                                                    \t\t\r\n");
        sbSql.append("\tgroup by e.faccountid, e.fcurrencyid                \t\t\t\t\t\t\t\r\n");
        sbSql.append("\t) w                                                                            \t\r\n");
        sbSql.append("\ton gl.faccountid = w.faccountid  and gl.fcurrencyid = w.fcurrencyid                                     \t\t\r\n");
        sbSql.append(" where                                                          \t\r\n");
        sbSql.append("\t gl.FProfitCenterID = ?                                                          \t\r\n");
        sbSql.append("\tand gl.fperiod = ?                                                           \t\r\n");
        sbSql.append(" \tand ac.fisleaf = 1                                                            \t\r\n");
        if (fcSU) {
            sbSql.append("\tand (gl.fdebitfor <> isnull(ld, 0) or gl.fcreditfor <> isnull(lc, 0)      \t\r\n");
        } else {
            sbSql.append("\tand (gl.fdebitfor <> isnull(ld, 0) or gl.fcreditfor <> isnull(lc, 0)      \t\r\n");
            sbSql.append("\tor gl.fdebitlocal <> isnull(ldl, 0) or gl.fcreditlocal <> isnull(lcl, 0)      \t\r\n");
            if (isUserReportCurr) {
                sbSql.append("\tor gl.FDebitRpt <> isnull(ldr, 0) or gl.fcreditRpt <> isnull(lcr, 0)      \t\r\n");
            }
        }
        sbSql.append(") \t\t\r\n");
        sbSql.append(" order by ac.fnumber, cu.fnumber                                                 \t\r\n");
        stmt = con.prepareStatement(sbSql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)period.getId().toString());
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        rs = stmt.executeQuery();
        Vector<PostVoucherCheckReturn> vec = new Vector<PostVoucherCheckReturn>();
        while (rs.next()) {
            PostVoucherCheckReturn err = new PostVoucherCheckReturn();
            int curPre = rs.getInt("fprecision");
            err.setBalanceError(true);
            err.setAccountName(rs.getString("acname"));
            err.setAccountNumber(rs.getString("fnumber"));
            err.setCurrencyName(rs.getString("cuname"));
            vec.addElement(err);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (vec.size() > 0) {
            PostVoucherCheckReturn[] checkReturn = new PostVoucherCheckReturn[vec.size()];
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                checkReturn[i] = (PostVoucherCheckReturn)vec.get(i);
            }
            return checkReturn;
        }
        return null;
    }

    protected PostVoucherCheckReturn[] checkAssistBalanceAndVoucher(Context ctx, boolean fcSU, Connection con, String curCompanyID, PeriodInfo period, boolean isUserReportCurr) throws SQLException {
        StringBuffer sbSql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        sbSql.append(" select ac.fid , ac.fnumber,ac.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" acname, cu.fnumber,cu.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" cuname, cu.fprecision, w.fassgrpid,                                   \t\r\n");
        if (fcSU) {
            sbSql.append(" \tgl.fdebitfor, gl.fcreditfor, isnull(ld, 0) ld, isnull(lc, 0) lc            \t\r\n");
        } else {
            sbSql.append(" \tgl.fdebitfor, gl.fcreditfor, isnull(ld, 0) ld, isnull(lc, 0) lc            \t\r\n");
            sbSql.append(" \t,gl.fdebitlocal, gl.fcreditlocal, isnull(ldl, 0) ldl, isnull(lcl, 0) lcl            \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,gl.fdebitrpt, gl.fcreditrpt, isnull(ldr, 0) ld, isnull(lcr, 0) lcr           \t\r\n");
            }
        }
        sbSql.append(" from T_PCA_PCAssistBalance_5F gl                                                     \t\r\n");
        sbSql.append(" inner join t_bd_accountview ac  on gl.faccountid = ac.fid                                                      \t\r\n");
        sbSql.append(" inner join t_bd_currency cu \ton gl.fcurrencyid = cu.fid                                                     \t\r\n");
        sbSql.append(" left join                                                                       \t\r\n");
        sbSql.append(" \t(                                                                              \t\r\n");
        sbSql.append(" \tselect e.faccountid, e.fcurrencyid, r.fassgrpid,                \t\t\t\t\t\t\t\r\n");
        if (fcSU) {
            sbSql.append(" \tsum(r.foriginalamount * e.fentrydc) ld, sum(r.foriginalamount * (1 - e.fentrydc)) lc \t\r\n");
        } else {
            sbSql.append(" \tsum(r.foriginalamount * e.fentrydc) ld, sum(r.foriginalamount * (1 - e.fentrydc)) lc \t\r\n");
            sbSql.append(" \t,sum(r.flocalamount * e.fentrydc) ldl, sum(r.flocalamount * (1 - e.fentrydc)) lcl \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,sum(r.FReportingAmount * e.fentrydc) ldr, sum(r.FReportingAmount * (1 - e.fentrydc)) lcr \t\r\n");
            }
        }
        sbSql.append(" \tfrom T_PCA_PCVoucher v                                                            \t\r\n");
        sbSql.append(" \tinner join T_PCA_PCVoucherEntry e on e.fbillid = v.fid                                                   \t\t\r\n");
        sbSql.append("  inner join T_PCA_PCVoucherAssistRecord r on r.fbillid = v.fid and r.fentryid = e.fid  \r\n ");
        sbSql.append("\twhere v.fbizstatus = 5                                                         \t\r\n");
        sbSql.append("\t\tand v.FProfitCenterID = ?                                                   \t\t\r\n");
        sbSql.append("\t\tand v.fperiodid = ?                                                    \t\t\r\n");
        sbSql.append("\tgroup by e.faccountid, e.fcurrencyid , r.fassgrpid               \t\t\t\t\t\t\t\r\n");
        sbSql.append("\t) w                                                                            \t\r\n");
        sbSql.append("\ton gl.faccountid = w.faccountid  and gl.fcurrencyid = w.fcurrencyid and gl.FAssistGrpID = w.fassgrpid                                    \t\t\r\n");
        sbSql.append(" where                                                            \t\r\n");
        sbSql.append("\t gl.FProfitCenterID = ?                                                          \t\r\n");
        sbSql.append("\tand gl.fperiod = ?                                                           \t\r\n");
        sbSql.append(" \tand ac.fisleaf = 1                                                            \t\r\n");
        if (fcSU) {
            sbSql.append("\tand (gl.fdebitfor <> isnull(ld, 0) or gl.fcreditfor <> isnull(lc, 0)      \t\r\n");
        } else {
            sbSql.append("\tand (gl.fdebitfor <> isnull(ld, 0) or gl.fcreditfor <> isnull(lc, 0)      \t\r\n");
            sbSql.append("\tor gl.fdebitlocal <> isnull(ldl, 0) or gl.fcreditlocal <> isnull(lcl, 0)      \t\r\n");
            if (isUserReportCurr) {
                sbSql.append("\tor gl.FDebitRpt <> isnull(ldr, 0) or gl.fcreditRpt <> isnull(lcr, 0)      \t\r\n");
            }
        }
        sbSql.append(") \t\t\t\t\r\n");
        sbSql.append(" order by ac.fnumber, cu.fnumber                                                 \t\r\n");
        stmt = con.prepareStatement(sbSql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)period.getId().toString());
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        rs = stmt.executeQuery();
        Vector<PostVoucherCheckReturn> vec = new Vector<PostVoucherCheckReturn>();
        while (rs.next()) {
            PostVoucherCheckReturn err = new PostVoucherCheckReturn();
            int curPre = rs.getInt("fprecision");
            err.setBalanceError(true);
            err.setAccountName(rs.getString("acname"));
            err.setAccountNumber(rs.getString("fnumber"));
            err.setCurrencyName(rs.getString("cuname"));
            vec.addElement(err);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (vec.size() > 0) {
            PostVoucherCheckReturn[] checkReturn = new PostVoucherCheckReturn[vec.size()];
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                checkReturn[i] = (PostVoucherCheckReturn)vec.get(i);
            }
            return checkReturn;
        }
        return null;
    }

    protected PostVoucherCheckReturn[] checkAccountEndBalance(Context ctx, boolean fcSU, Connection con, String curCompanyID, PeriodInfo period, boolean isUserReportCurr) throws SQLException {
        StringBuffer sbSql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        sbSql.append(" select ac.fid , ac.fnumber, cu.fnumber, cu.fprecision,ac.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" acname,cu.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" cuname,                                   \t\r\n");
        if (fcSU) {
            sbSql.append(" \tgl.fEndBalancefor,gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor EndBalanceFor           \t\r\n");
        } else {
            sbSql.append(" \tgl.fEndBalancefor,gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor EndBalanceFor           \t\r\n");
            sbSql.append(" \t,gl.fEndBalanceLocal,gl.FBeginBalanceLocal + gl.fdebitLocal-gl.fcreditLocal EndBalanceLocal          \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,gl.fEndBalanceRpt,gl.FBeginBalanceRpt + gl.fdebitRpt-gl.fcreditRpt EndBalanceRpt          \t\r\n");
            }
        }
        sbSql.append(" from T_PCA_PCAccountBalance_5F gl                                                     \t\r\n");
        sbSql.append(" inner join t_bd_accountview ac  on gl.faccountid = ac.fid                                                      \t\r\n");
        sbSql.append(" inner join t_bd_currency cu \ton gl.fcurrencyid = cu.fid                                                     \t\r\n");
        sbSql.append(" where                                                           \t\r\n");
        sbSql.append("\t gl.FProfitCenterID = ?                                                          \t\r\n");
        sbSql.append("\tand gl.fperiod = ?                                                           \t\r\n");
        if (fcSU) {
            sbSql.append("\tand (gl.fEndBalancefor <> gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor       \t\r\n");
        } else {
            sbSql.append("\tand (gl.fEndBalancefor <> gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor       \t\r\n");
            sbSql.append("\tor gl.fEndBalanceLocal <> gl.FBeginBalanceLocal + gl.fdebitLocal-gl.fcreditLocal      \t     \t\r\n");
            if (isUserReportCurr) {
                sbSql.append("\tor gl.fEndBalanceRpt <> gl.FBeginBalanceRpt + gl.fdebitRpt-gl.fcreditRpt      \t     \t\r\n");
            }
        }
        sbSql.append(") \t\t\t\t\r\n");
        sbSql.append(" order by ac.fnumber, cu.fnumber                                                 \t\r\n");
        stmt = con.prepareStatement(sbSql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        rs = stmt.executeQuery();
        Vector<PostVoucherCheckReturn> vec = new Vector<PostVoucherCheckReturn>();
        while (rs.next()) {
            PostVoucherCheckReturn err = new PostVoucherCheckReturn();
            int curPre = rs.getInt("fprecision");
            err.setBalanceError(true);
            err.setAccountName(rs.getString("acname"));
            err.setAccountNumber(rs.getString("fnumber"));
            err.setCurrencyName(rs.getString("cuname"));
            vec.addElement(err);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (vec.size() > 0) {
            PostVoucherCheckReturn[] checkReturn = new PostVoucherCheckReturn[vec.size()];
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                checkReturn[i] = (PostVoucherCheckReturn)vec.get(i);
            }
            return checkReturn;
        }
        return null;
    }

    protected PostVoucherCheckReturn[] checkAssistEndBalance(Context ctx, boolean fcSU, Connection con, String curCompanyID, PeriodInfo period, boolean isUserReportCurr) throws SQLException {
        StringBuffer sbSql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        sbSql.append(" select ac.fid , ac.fnumber, cu.fnumber, cu.fprecision,ac.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" acname,cu.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" cuname,                                    \t\r\n");
        if (fcSU) {
            sbSql.append(" \tgl.fEndBalancefor,gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor EndBalanceFor           \t\r\n");
        } else {
            sbSql.append(" \tgl.fEndBalancefor,gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor EndBalanceFor           \t\r\n");
            sbSql.append(" \t,gl.fEndBalanceLocal,gl.FBeginBalanceLocal + gl.fdebitLocal-gl.fcreditLocal EndBalanceLocal          \t\r\n");
            if (isUserReportCurr) {
                sbSql.append(" \t,gl.fEndBalanceRpt,gl.FBeginBalanceRpt + gl.fdebitRpt-gl.fcreditRpt EndBalanceRpt          \t\r\n");
            }
        }
        sbSql.append(" from T_PCA_PCAssistBalance_5F gl                                                     \t\r\n");
        sbSql.append(" inner join t_bd_accountview ac  on gl.faccountid = ac.fid                                                      \t\r\n");
        sbSql.append(" inner join t_bd_currency cu \ton gl.fcurrencyid = cu.fid                                                     \t\r\n");
        sbSql.append(" where                                                          \t\r\n");
        sbSql.append("\t gl.FProfitCenterID = ?                                                          \t\r\n");
        sbSql.append("\tand gl.fperiod = ?                                                           \t\r\n");
        if (fcSU) {
            sbSql.append("\tand (gl.fEndBalancefor <> gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor       \t\r\n");
        } else {
            sbSql.append("\tand (gl.fEndBalancefor <> gl.FBeginBalanceFor + gl.fdebitfor-gl.fcreditfor       \t\r\n");
            sbSql.append("\tor gl.fEndBalanceLocal <> gl.FBeginBalanceLocal + gl.fdebitLocal-gl.fcreditLocal      \t     \t\r\n");
            if (isUserReportCurr) {
                sbSql.append("\tor gl.fEndBalanceRpt <> gl.FBeginBalanceRpt + gl.fdebitRpt-gl.fcreditRpt      \t     \t\r\n");
            }
        }
        sbSql.append(") \t\t\t\t\r\n");
        sbSql.append(" order by ac.fnumber, cu.fnumber                                                 \t\r\n");
        stmt = con.prepareStatement(sbSql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        rs = stmt.executeQuery();
        Vector<PostVoucherCheckReturn> vec = new Vector<PostVoucherCheckReturn>();
        while (rs.next()) {
            PostVoucherCheckReturn err = new PostVoucherCheckReturn();
            int curPre = rs.getInt("fprecision");
            err.setBalanceError(true);
            err.setAccountName(rs.getString("acname"));
            err.setAccountNumber(rs.getString("fnumber"));
            err.setCurrencyName(rs.getString("cuname"));
            vec.addElement(err);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (vec.size() > 0) {
            PostVoucherCheckReturn[] checkReturn = new PostVoucherCheckReturn[vec.size()];
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                checkReturn[i] = (PostVoucherCheckReturn)vec.get(i);
            }
            return checkReturn;
        }
        return null;
    }

    protected PostVoucherCheckReturn[] checkNotLeafAccountBalance(Context ctx, boolean fcSU, Connection con, String curCompanyID, PeriodInfo period, boolean isUserReportCurr) throws SQLException, EASBizException, BOSException {
        StringBuffer sbSql = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        sbSql.append(" select ac.fid, \r\n");
        sbSql.append("        ac.fnumber, \r\n");
        sbSql.append("        cu.fnumber, \r\n");
        sbSql.append("        cu.fprecision, \r\n");
        sbSql.append("       gl.fdebitfor, \r\n");
        sbSql.append("        gl.fcreditfor,ac.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" acname,cu.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" cuname \r\n");
        sbSql.append("   from T_PCA_PCAccountBalance_5F gl \r\n");
        sbSql.append("  inner join t_bd_accountview ac \r\n");
        sbSql.append("     on gl.faccountid = ac.fid \r\n");
        sbSql.append("  inner join t_bd_currency cu \r\n");
        sbSql.append("     on gl.fcurrencyid = cu.fid \r\n");
        sbSql.append("   left join (select v.forgunitid, pav.fid faccountid, pav.fdc, v.fcurrencyid, \r\n");
        sbSql.append("                     sum(v.fbeginbalancefor )  fbeginbalancefor, \r\n");
        sbSql.append("                           sum(v.fbeginbalancelocal )  fbeginbalancelocal, \r\n");
        sbSql.append("                            sum(v.fbeginbalancerpt ) fbeginbalancerpt, \r\n");
        sbSql.append("                            sum(FYearDebitFor) FYearDebitFor, \r\n");
        sbSql.append("                           sum(FYearCreditFor) FYearCreditFor, \r\n");
        sbSql.append("                           sum(FYearDebitLocal) FYearDebitLocal, \r\n");
        sbSql.append("                           sum(FYearCreditLocal) FYearCreditLocal, \r\n");
        sbSql.append("                           sum(FYearDebitRpt) FYearDebitRpt, \r\n");
        sbSql.append("                           sum(FYearCreditRpt) FYearCreditRpt, \r\n");
        sbSql.append("                           sum(v.fendbalancefor )  fendbalancefor, \r\n");
        sbSql.append("                           sum(v.fendbalancelocal )fendbalancelocal, \r\n");
        sbSql.append("                           sum(v.fendbalancerpt ) fendbalancerpt, \r\n");
        sbSql.append("                           sum(FDebitFor) FDebitFor, \r\n");
        sbSql.append("                           sum(FCreditFor) FCreditFor, \r\n");
        sbSql.append("                           sum(FDebitLocal) FDebitLocal, \r\n");
        sbSql.append("                           sum(FCreditLocal) FCreditLocal, \r\n");
        sbSql.append("                           sum(FDebitRpt) FDebitRpt, \r\n");
        sbSql.append("                     sum(FCreditRpt) FCreditRpt \r\n");
        sbSql.append("                      from T_PCA_PCAccountBalance_5F v \r\n");
        sbSql.append("                     inner join t_bd_accountview av \r\n");
        sbSql.append("                        on av.fid = v.faccountid \r\n");
        sbSql.append("                       and av.fcompanyid = v.forgunitid \r\n");
        sbSql.append("                     inner join t_bd_accountview pav \r\n");
        sbSql.append("                        on charindex(pav.flongnumber || '!', av.flongnumber) = 1 \r\n");
        sbSql.append("                       and av.faccounttableid = pav.faccounttableid \r\n");
        sbSql.append("                       and av.fcompanyid = pav.fcompanyid \r\n");
        sbSql.append("                     where v.FProfitCenterID = ?    \r\n");
        sbSql.append("                       and v.fperiod = ? \r\n");
        sbSql.append("                       and av.fisleaf = 1 \r\n");
        sbSql.append("                     group by v.forgunitid, pav.fid, pav.fdc, v.fcurrencyid \r\n");
        sbSql.append("             ) w \r\n");
        sbSql.append("    on gl.faccountid = w.faccountid \r\n");
        sbSql.append("   and gl.fcurrencyid = w.fcurrencyid \r\n");
        sbSql.append(" where gl.FProfitCenterID = ? \r\n");
        sbSql.append("   and gl.fperiod = ? \r\n");
        sbSql.append("   and (gl.fdebitfor <> w.fdebitfor or gl.FCreditFor <> w.FCreditFor or \r\n");
        sbSql.append("       gl.FYearDebitFor <> w.FYearDebitFor or \r\n");
        sbSql.append("       gl.FYearCreditFor <> w.FYearCreditFor  \r\n");
        if (!fcSU) {
            sbSql.append("     or   gl.FBeginbalanceLocal <> w.FBeginbalanceLocal \r\n");
            sbSql.append("     or  gl.FEndbalanceLocal <> w.FEndbalanceLocal  \r\n");
            sbSql.append("     or  gl.fdebitLocal <> w.fdebitLocal  \r\n");
            sbSql.append("     or  gl.FCreditLocal <> w.FCreditLocal  \r\n");
            sbSql.append("      or gl.FYearDebitLocal <> w.FYearDebitLocal  \r\n");
            sbSql.append("      or gl.FYearCreditLocal <> w.FYearCreditLocal \r\n");
            sbSql.append("      or gl.FBeginbalanceLocal <> w.FBeginbalanceLocal  \r\n");
            sbSql.append("      or gl.FEndbalanceLocal <> w.FEndbalanceLocal  \r\n");
            if (isUserReportCurr) {
                sbSql.append("      or gl.fdebitRpt <> w.fdebitRpt or gl.FCreditRpt <> w.FCreditRpt \r\n");
                sbSql.append("      or gl.FYearDebitRpt <> w.FYearDebitRpt \r\n");
                sbSql.append("      or gl.FYearCreditRpt <> w.FYearCreditRpt \r\n");
                sbSql.append("      or gl.FBeginbalanceRpt <> w.FBeginbalanceRpt  \r\n");
                sbSql.append("      or gl.FEndbalanceRpt <> w.FEndbalanceRpt \r\n");
            }
        }
        sbSql.append(" )   \r\n");
        sbSql.append(" order by ac.fnumber, cu.fnumber \r\n");
        stmt = con.prepareStatement(sbSql.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
        stmt.setInt(index++, period.getNumber());
        rs = stmt.executeQuery();
        Vector<PostVoucherCheckReturn> vec = new Vector<PostVoucherCheckReturn>();
        while (rs.next()) {
            PostVoucherCheckReturn err = new PostVoucherCheckReturn();
            int curPre = rs.getInt("fprecision");
            err.setBalanceError(true);
            err.setAccountName(rs.getString("acname"));
            err.setAccountNumber(rs.getString("fnumber"));
            err.setCurrencyName(rs.getString("cuname"));
            vec.addElement(err);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (vec.size() > 0) {
            PostVoucherCheckReturn[] checkReturn = new PostVoucherCheckReturn[vec.size()];
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                checkReturn[i] = (PostVoucherCheckReturn)vec.get(i);
            }
            return checkReturn;
        }
        return null;
    }

    protected int _submitVoucherBatch(Context ctx) throws BOSException, EASBizException {
        try {
            String[] companyIds = new String[]{ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
            PcaBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(companyIds);
        }
        catch (Exception ex) {
            log.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
        return 1;
    }

    protected int _submitVoucherBatch(Context ctx, String[] profitCenterIds) throws BOSException, EASBizException {
        try {
            PcaBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(profitCenterIds);
        }
        catch (Exception ex) {
            log.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
        return 1;
    }

    protected int _submitVoucherBatchAll(Context ctx) throws BOSException {
        try {
            String[] companyIds = new String[]{ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
            PcaBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(companyIds);
        }
        catch (Exception ex) {
            log.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
        return 1;
    }

    protected int _postVocher(Context ctx, String vchID, String companyID, int balType, boolean isUnPost, boolean hasNotice, Map checkViews) throws BOSException, EASBizException, GLPeriodEndException {
        String curCompanyID = companyID;
        String startPeriodID = null;
        String curPeriodID = null;
        PeriodInfo[] aryPrd = PcaUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo startPeriod = aryPrd[0];
        startPeriodID = startPeriod.getId().toString();
        PeriodInfo period = aryPrd[1];
        curPeriodID = period.getId().toString();
        if (this.CheckPostVoucherValid(ctx, vchID, companyID, isUnPost, curPeriodID, startPeriodID, false, false) == 1) {
            return 1;
        }
        return 0;
    }

    private int CheckPostVoucherValid(Context ctx, String vchID, String curProfitCenterID, boolean isUnPost, String curPeriodID, String startPeriodID, boolean isGLAcctCussent, boolean isInTimeVerify) throws BOSException, EASBizException, GLPeriodEndException {
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer errMsg = new StringBuffer();
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("Select Fcompanyid,FBizStatus from t_pca_pcvoucher \r\n");
            sql.append("Where fprofitcenterid = ? \r\n");
            sql.append("and  FID = ? \r\n");
            sql.append(";");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curProfitCenterID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)vchID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.NO_VOUCHER);
            }
            int bizStatus = rs.getInt("FBizStatus");
            String companyid = rs.getString("Fcompanyid");
            if (isUnPost && bizStatus != 5) {
                throw new GLPeriodEndException(GLPeriodEndException.POST_VOUCHER_STATUS_INVALID, new Object[]{VoucherStatusEnum.getEnum((int)bizStatus)});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            String sql2 = "select distinct vch.fprofitcenterid,vch.fperiodid from t_pca_pcvoucher  vch \t\t\r\n\tinner join t_bd_period per on vch.fperiodid=per.fid \t\t\t\t\t\r\n\tinner join T_BD_SystemStatusCtrol ctr on ctr.fprofitcenterid=vch.fprofitcenterid\t\t\t\t\t\t\t\t\t\t\r\n\tinner join t_bd_period per2 on ctr.fcurrentperiodid=per2.fid \t\t\t\t\t\r\n\tinner join T_BD_SystemStatus sta on ctr.fsystemstatusid=sta.fid\t\t\t\r\n\twhere vch.fprofitcenterid=?\t\t\r\n\tand vch.FID=?\tand sta.fname=1006 and ((per.FIsAdjustPeriod=0 and ctr.fcurrentperiodid=vch.fperiodid ) or  ( per.FIsAdjustPeriod=1 and (per.FPeriodyear=per2.FPeriodyear or per.FPeriodyear=per2.FPeriodyear-1) ))";
            stmt = con.prepareStatement(sql2);
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curProfitCenterID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)vchID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.VCH_NOT_IN_CURRENT_PERIOD);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            this._checkAccountValid(ctx, companyid);
            PostVoucherCheckPara checkPara = new PostVoucherCheckPara();
            checkPara.setVoucherID(vchID);
            checkPara.setGLAcctCussent(isGLAcctCussent);
            checkPara.setIncludePostedVch(!isUnPost);
            PostVoucherCheckReturn[] checkReturn = this._checkPostVoucher(ctx, checkPara);
            if (checkReturn != null) {
                for (int i = 0; i < 1; ++i) {
                    if (checkReturn[i].getVeSeq() != -1) {
                        errMsg.append(this.getStr(ctx, "VoucherEntrySeq"));
                        errMsg.append(checkReturn[i].getVeSeq());
                        errMsg.append(" ");
                    }
                    if (checkReturn[i].getAsstSeq() != -1) {
                        errMsg.append(this.getStr(ctx, "VoucherAssistSeq"));
                        errMsg.append(checkReturn[i].getAsstSeq());
                        errMsg.append(" ");
                    }
                    errMsg.append(checkReturn[i].getErrorTip());
                    errMsg.append(";\r");
                }
                Object[] info = new String[]{errMsg.toString()};
                throw new VoucherException(VoucherException.VCH_NOT_VALID, info);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return 0;
    }
}

